/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

/**
 * @fileoverview Create variable with all parts,
 * created from database & Fritzing official parts
 * @author ROBOM
 * @author scanet@libreduc.cc (Sébastien CANET)
 */

var componentsList = [
{
	"page":"1",
	"count": 37,
	"el": [{
			"name":"MAX1555 Lithium Charger IC",
			"description":"MAX1555 Lithium Charger ICSOT-23 Lithium Polymer charging IC. Schematic element and footprint proven. Spark Fun Electronics SKU : COM-00674",
			"image":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Darlington Driver",
			"description":"Darlington DriverULN2803 Darlington array. 500mA max per channel, 8-channel package. Spark Fun Electronics SKU : COM-00312",
			"image":"core\/breadboard\/sparkfun-poweric_so18l_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_so18l_breadboard.svg",
			"width":"900",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"PICAXE-08M",
			"description":"PICAXE-08M from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_08M_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_08M_breadboard.svg",
			"width":"400",
			"height":"330",
			"points": [[34, 285.6, 32, 45.4], [34, -1, 32, 45.4], [334, 285.6, 32, 45.4], [334, -1, 32, 45.4], [134, 285.6, 32, 45.4], [134, -1, 32, 45.4], [234, 285.6, 32, 45.4], [234, -1, 32, 45.4]]
		}, {
			"name":"CRYSTAL",
			"description":"Various standard crystals. Proven footprints. Spark Fun Electronics SKU : COM-00534",
			"image":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"icon":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"width":"15.457",
			"height":"43.819",
			"points": [[2.451, 39.819, 4.152, 3], [9.651, 39.819, 4.152, 3]]
		}, {
			"name":"PIC 16F8x",
			"description":"PIC 16F8x8-Bit PIC16F8X FamilyPin Compatible : PIC16F83, PIC16CR83, PIC16F84A, PIC16CR84",
			"image":"core\/breadboard\/sparkfun-digitalic_ssop_20_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_ssop_20_breadboard.svg",
			"width":"1000",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"CY7C64215",
			"description":"The enCoRe III is based on the flexible PSoC architecture and is a full-featured, full-speed (12-Mbps) USB part. Configurable analog, digital, and interconnect circuitry enable a high level of integration in a host of consumer, and communication applications.",
			"image":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"icon":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"AD8541-CMOS Rail-to-Rail Op Amp",
			"description":"",
			"image":"core\/breadboard\/AD8541.svg",
			"icon":"core\/breadboard\/AD8541.svg",
			"width":"28.8",
			"height":"29.786",
			"points": [[0.852, 22.942, 5.5, 5.5], [8.053, 22.944, 5.5, 5.5], [15.251, 22.944, 5.5, 5.5], [22.447, 22.942, 5.5, 5.5], [22.449, 1.344, 5.5, 5.5], [15.25, 1.344, 5.5, 5.5], [8.053, 1.342, 5.5, 5.5], [0.853, 1.341, 5.5, 5.5]]
		}, {
			"name":"Color Sensor Breakout ADJD-S311",
			"description":"Description: The ADJD-S311-CR999 is a great little color light sensor. In fact, it's so little that it can be pretty difficult to play with, so we made this evaluation board! It provides all the necessary support circuitry to discern the smallest differences between visible colors. Dimensions: 21.6x12.7mm (0.85x0.50\") Documents: Schematic Eagle Files Datasheet (ADJD-S311) Example Arduino Code Example PIC code Example ARM code Bildr Tutorial",
			"image":"core\/breadboard\/Color_Sensor_Breakout_ADJD_S311_breadboard.svg",
			"icon":"core\/breadboard\/Color_Sensor_Breakout_ADJD_S311_breadboard.svg",
			"width":"66.103",
			"height":"36.85",
			"points": [[58.988, 8.353, 5.744, 5.744], [58.987, 15.553, 5.746, 5.746], [58.988, 22.753, 5.744, 5.744], [1.396, 29.955, 5.742, 5.742], [1.395, 22.753, 5.744, 5.744], [1.395, 15.554, 5.744, 5.744], [1.395, 8.354, 5.744, 5.744], [1.395, 1.154, 5.744, 5.744]]
		}, {
			"name":"Header 4",
			"description":"Header 4Standard 4-pin 0.1 header. Use with straight break away headers (SKU : PRT-00116), right angle break away headers (PRT-00553), swiss pins (PRT-00743), machine pins (PRT-00117), and female headers (PRT-00115). Molex polarized connector foot print use with SKU : PRT-08231 with associated crimp pins and housings. 1MM SMD Version SKU: PRT-10208",
			"image":"core\/breadboard\/sparkfun-connectors_screwterminal-3.5mm-4_lock_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_screwterminal-3.5mm-4_lock_breadboard.svg",
			"width":"15.3032",
			"height":"7.2032",
			"points": [[-1.0842, 0.1936, 3.616, 3.616], [2.7714, 0.1936, 3.616, 3.616], [5.9158, 0.1936, 3.616, 3.616], [9.7714, 0.1936, 3.616, 3.616]]
		}, {
			"name":"Darlington Driver",
			"description":"Darlington DriverULN2803 Darlington array. 500mA max per channel, 8-channel package. Spark Fun Electronics SKU : COM-00312",
			"image":"core\/breadboard\/sparkfun-poweric_so018_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_so018_breadboard.svg",
			"width":"900",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino ProtoScrew Shield Kit",
			"description":"\tDescription: The ScrewShield extends all pins of the Arduino out to 3.5mm pitch screw terminals. It also has a lot of the utility provided by Arduino Protoshield, including: a large prototyping space of both connected and unconnected 0.1' spaced through-holes, a couple 5V and GND busses, a reset button, general use push button, and a 5mm yellow LED.\tThis product includes all the parts shown and comes in kit form and must be soldered together by the end user.\tKit Includes: \t\t\t1x ScrewShield PCB\t\t\t1x 5mm Yellow LED\t\t\t1x 330Ω Resistor\t\t\t2x 6-pin Stackable Headers\t\t\t2x 8-pin Stackable Headers\t\t\t2x Momentary Push Buttons\t\t\t6x 2-pin 3.5mm Screw Terminals\t\t\t8x 3-pin 3.5mm Screw Terminals\tDocuments: \t\t\tSchematic\t\t\tMaker Faire Project",
			"image":"core\/breadboard\/screwshield-v15_breadboard.svg",
			"icon":"core\/breadboard\/screwshield-v15_breadboard.svg",
			"width":"197.178",
			"height":"230.4",
			"points": [[116.897, 205.51, 6.582, 6.582], [126.819, 205.51, 6.582, 6.582], [136.74, 205.51, 6.582, 6.582], [146.662, 205.51, 6.582, 6.582], [156.583, 205.51, 6.582, 6.582], [166.504, 205.51, 6.582, 6.582], [176.425, 205.51, 6.582, 6.582], [186.346, 205.51, 6.582, 6.582], [52.098, 205.51, 6.582, 6.582], [62.019, 205.51, 6.582, 6.582], [71.94, 205.51, 6.582, 6.582], [81.862, 205.51, 6.582, 6.582], [91.782, 205.51, 6.582, 6.582], [101.704, 205.51, 6.582, 6.582], [5.298, 205.51, 6.582, 6.582], [15.219, 205.51, 6.582, 6.582], [25.14, 205.51, 6.582, 6.582], [35.061, 205.51, 6.582, 6.582], [156.498, 18.309, 6.582, 6.582], [146.577, 18.309, 6.582, 6.582], [136.655, 18.309, 6.582, 6.582], [126.735, 18.309, 6.582, 6.582], [116.813, 18.309, 6.582, 6.582], [106.891, 18.309, 6.582, 6.582], [96.969, 18.309, 6.582, 6.582], [87.049, 18.309, 6.582, 6.582], [73.698, 18.309, 6.582, 6.582], [63.777, 18.309, 6.582, 6.582], [53.855, 18.309, 6.582, 6.582], [43.934, 18.309, 6.582, 6.582], [34.012, 18.309, 6.582, 6.582], [24.092, 18.309, 6.582, 6.582], [14.17, 18.309, 6.582, 6.582], [4.249, 18.309, 6.582, 6.582], [178.098, 18.309, 6.582, 6.582], [168.177, 18.309, 6.582, 6.582], [70.336, 180.548, 6.104, 6.104], [77.537, 180.548, 6.104, 6.104], [113.537, 180.548, 6.104, 6.104], [120.737, 180.548, 6.104, 6.104], [127.937, 180.548, 6.104, 6.104], [135.136, 180.548, 6.104, 6.104], [142.337, 180.548, 6.104, 6.104], [149.537, 180.548, 6.104, 6.104], [37.937, 43.748, 6.104, 6.104], [135.136, 43.748, 6.104, 6.104], [127.937, 43.748, 6.104, 6.104], [120.737, 43.748, 6.104, 6.104], [113.537, 43.748, 6.104, 6.104], [106.337, 43.748, 6.104, 6.104], [99.136, 43.748, 6.104, 6.104], [88.336, 43.748, 6.104, 6.104], [81.137, 43.748, 6.104, 6.104], [73.937, 43.748, 6.104, 6.104], [66.737, 43.748, 6.104, 6.104], [59.537, 43.748, 6.104, 6.104], [52.337, 43.748, 6.104, 6.104], [84.737, 180.548, 6.104, 6.104], [91.937, 180.548, 6.104, 6.104], [45.137, 43.748, 6.104, 6.104], [63.137, 180.548, 6.104, 6.104], [149.537, 43.748, 6.104, 6.104], [142.337, 43.748, 6.104, 6.104], [99.136, 180.548, 6.104, 6.104], [70.336, 158.948, 6.104, 6.104], [70.336, 166.148, 6.104, 6.104], [127.937, 130.148, 6.104, 6.104], [135.136, 130.148, 6.104, 6.104], [142.337, 130.148, 6.104, 6.104], [149.537, 130.148, 6.104, 6.104], [156.737, 130.148, 6.104, 6.104], [120.737, 130.148, 6.104, 6.104], [113.537, 130.148, 6.104, 6.104], [106.337, 130.148, 6.104, 6.104], [99.136, 130.148, 6.104, 6.104], [91.937, 130.148, 6.104, 6.104], [84.737, 130.148, 6.104, 6.104], [77.537, 130.148, 6.104, 6.104], [70.336, 130.148, 6.104, 6.104], [63.137, 130.148, 6.104, 6.104], [48.737, 130.148, 6.104, 6.104], [55.937, 130.148, 6.104, 6.104], [77.537, 158.948, 6.104, 6.104], [127.937, 86.948, 6.104, 6.104], [135.136, 86.948, 6.104, 6.104], [142.337, 86.948, 6.104, 6.104], [149.537, 86.948, 6.104, 6.104], [156.737, 86.948, 6.104, 6.104], [120.737, 86.948, 6.104, 6.104], [113.537, 86.948, 6.104, 6.104], [106.337, 86.948, 6.104, 6.104], [99.136, 86.948, 6.104, 6.104], [91.937, 86.948, 6.104, 6.104], [84.737, 86.948, 6.104, 6.104], [77.537, 86.948, 6.104, 6.104], [70.336, 86.948, 6.104, 6.104], [63.137, 86.948, 6.104, 6.104], [48.737, 86.948, 6.104, 6.104], [55.937, 86.948, 6.104, 6.104], [41.537, 86.948, 6.104, 6.104], [34.337, 86.948, 6.104, 6.104], [27.137, 86.948, 6.104, 6.104], [19.937, 86.948, 6.104, 6.104], [12.737, 86.948, 6.104, 6.104], [5.537, 86.948, 6.104, 6.104], [77.537, 166.148, 6.104, 6.104], [113.537, 166.148, 6.104, 6.104], [113.537, 158.948, 6.104, 6.104], [120.737, 158.948, 6.104, 6.104], [120.737, 166.148, 6.104, 6.104], [127.937, 166.148, 6.104, 6.104], [127.937, 158.948, 6.104, 6.104], [135.136, 158.948, 6.104, 6.104], [135.136, 166.148, 6.104, 6.104], [142.337, 158.948, 6.104, 6.104], [142.337, 166.148, 6.104, 6.104], [149.537, 158.948, 6.104, 6.104], [149.537, 166.148, 6.104, 6.104], [37.937, 68.948, 6.104, 6.104], [37.937, 61.748, 6.104, 6.104], [12.737, 144.548, 6.104, 6.104], [12.737, 137.348, 6.104, 6.104], [12.737, 151.748, 6.104, 6.104], [19.937, 137.348, 6.104, 6.104], [19.937, 151.748, 6.104, 6.104], [19.937, 144.548, 6.104, 6.104], [27.137, 144.548, 6.104, 6.104], [27.137, 137.348, 6.104, 6.104], [27.137, 151.748, 6.104, 6.104], [34.337, 137.348, 6.104, 6.104], [34.337, 144.548, 6.104, 6.104], [34.337, 151.748, 6.104, 6.104], [41.537, 151.748, 6.104, 6.104], [41.537, 144.548, 6.104, 6.104], [41.537, 137.348, 6.104, 6.104], [48.737, 151.748, 6.104, 6.104], [48.737, 144.548, 6.104, 6.104], [48.737, 137.348, 6.104, 6.104], [55.937, 151.748, 6.104, 6.104], [55.937, 144.548, 6.104, 6.104], [55.937, 137.348, 6.104, 6.104], [63.137, 151.748, 6.104, 6.104], [63.137, 144.548, 6.104, 6.104], [63.137, 137.348, 6.104, 6.104], [70.336, 151.748, 6.104, 6.104], [70.336, 144.548, 6.104, 6.104], [70.336, 137.348, 6.104, 6.104], [77.537, 151.748, 6.104, 6.104], [77.537, 144.548, 6.104, 6.104], [77.537, 137.348, 6.104, 6.104], [84.737, 151.748, 6.104, 6.104], [84.737, 144.548, 6.104, 6.104], [84.737, 137.348, 6.104, 6.104], [91.937, 151.748, 6.104, 6.104], [91.937, 144.548, 6.104, 6.104], [91.937, 137.348, 6.104, 6.104], [99.136, 151.748, 6.104, 6.104], [99.136, 144.548, 6.104, 6.104], [99.136, 137.348, 6.104, 6.104], [106.337, 151.748, 6.104, 6.104], [106.337, 144.548, 6.104, 6.104], [106.337, 137.348, 6.104, 6.104], [113.537, 151.748, 6.104, 6.104], [113.537, 144.548, 6.104, 6.104], [113.537, 137.348, 6.104, 6.104], [120.737, 151.748, 6.104, 6.104], [120.737, 144.548, 6.104, 6.104], [120.737, 137.348, 6.104, 6.104], [127.937, 151.748, 6.104, 6.104], [127.937, 144.548, 6.104, 6.104], [127.937, 137.348, 6.104, 6.104], [135.136, 151.748, 6.104, 6.104], [135.136, 144.548, 6.104, 6.104], [135.136, 137.348, 6.104, 6.104], [142.337, 151.748, 6.104, 6.104], [142.337, 144.548, 6.104, 6.104], [142.337, 137.348, 6.104, 6.104], [149.537, 151.748, 6.104, 6.104], [149.537, 144.548, 6.104, 6.104], [149.537, 137.348, 6.104, 6.104], [156.737, 144.548, 6.104, 6.104], [41.537, 94.148, 6.104, 6.104], [34.337, 94.148, 6.104, 6.104], [41.537, 101.348, 6.104, 6.104], [41.537, 108.548, 6.104, 6.104], [34.337, 101.348, 6.104, 6.104], [27.137, 94.148, 6.104, 6.104], [19.937, 94.148, 6.104, 6.104], [27.137, 101.348, 6.104, 6.104], [34.337, 108.548, 6.104, 6.104], [41.537, 115.748, 6.104, 6.104], [41.537, 122.948, 6.104, 6.104], [34.337, 115.748, 6.104, 6.104], [27.137, 108.548, 6.104, 6.104], [19.937, 101.348, 6.104, 6.104], [12.737, 94.148, 6.104, 6.104], [5.537, 94.148, 6.104, 6.104], [12.737, 101.348, 6.104, 6.104], [19.937, 108.548, 6.104, 6.104], [27.137, 115.748, 6.104, 6.104], [34.337, 122.948, 6.104, 6.104], [41.537, 130.148, 6.104, 6.104], [34.337, 130.148, 6.104, 6.104], [27.137, 122.948, 6.104, 6.104], [19.937, 115.748, 6.104, 6.104], [5.537, 101.348, 6.104, 6.104], [12.737, 108.548, 6.104, 6.104], [5.537, 108.548, 6.104, 6.104], [12.737, 115.748, 6.104, 6.104], [19.937, 122.948, 6.104, 6.104], [27.137, 130.148, 6.104, 6.104], [19.937, 130.148, 6.104, 6.104], [5.537, 115.748, 6.104, 6.104], [12.737, 122.948, 6.104, 6.104], [5.537, 122.948, 6.104, 6.104], [12.737, 130.148, 6.104, 6.104], [5.537, 130.148, 6.104, 6.104], [149.537, 61.748, 6.104, 6.104], [149.537, 68.948, 6.104, 6.104], [142.337, 61.748, 6.104, 6.104], [142.337, 68.948, 6.104, 6.104], [135.136, 61.748, 6.104, 6.104], [135.136, 68.948, 6.104, 6.104], [127.937, 61.748, 6.104, 6.104], [127.937, 68.948, 6.104, 6.104], [120.737, 61.748, 6.104, 6.104], [120.737, 68.948, 6.104, 6.104], [113.537, 61.748, 6.104, 6.104], [113.537, 68.948, 6.104, 6.104], [106.337, 61.748, 6.104, 6.104], [106.337, 68.948, 6.104, 6.104], [99.136, 61.748, 6.104, 6.104], [99.136, 68.948, 6.104, 6.104], [88.336, 61.748, 6.104, 6.104], [88.336, 68.948, 6.104, 6.104], [81.137, 61.748, 6.104, 6.104], [81.137, 68.948, 6.104, 6.104], [73.937, 61.748, 6.104, 6.104], [73.937, 68.948, 6.104, 6.104], [66.737, 61.748, 6.104, 6.104], [66.737, 68.948, 6.104, 6.104], [59.537, 61.748, 6.104, 6.104], [59.537, 68.948, 6.104, 6.104], [52.337, 61.748, 6.104, 6.104], [52.337, 68.948, 6.104, 6.104], [45.137, 61.748, 6.104, 6.104], [45.137, 68.948, 6.104, 6.104], [91.937, 158.948, 6.104, 6.104], [156.737, 79.748, 6.104, 6.104], [149.537, 79.748, 6.104, 6.104], [142.337, 79.748, 6.104, 6.104], [135.136, 79.748, 6.104, 6.104], [127.937, 79.748, 6.104, 6.104], [120.737, 79.748, 6.104, 6.104], [113.537, 79.748, 6.104, 6.104], [106.337, 79.748, 6.104, 6.104], [99.136, 79.748, 6.104, 6.104], [91.937, 79.748, 6.104, 6.104], [84.737, 79.748, 6.104, 6.104], [77.537, 79.748, 6.104, 6.104], [70.336, 79.748, 6.104, 6.104], [63.137, 79.748, 6.104, 6.104], [55.937, 79.748, 6.104, 6.104], [48.737, 79.748, 6.104, 6.104], [41.537, 79.748, 6.104, 6.104], [34.337, 79.748, 6.104, 6.104], [27.137, 79.748, 6.104, 6.104], [19.937, 79.748, 6.104, 6.104], [12.737, 79.748, 6.104, 6.104], [5.537, 79.748, 6.104, 6.104], [84.737, 166.148, 6.104, 6.104], [84.737, 158.948, 6.104, 6.104], [91.937, 166.148, 6.104, 6.104], [156.737, 122.948, 6.104, 6.104], [149.537, 122.948, 6.104, 6.104], [142.337, 122.948, 6.104, 6.104], [135.136, 122.948, 6.104, 6.104], [127.937, 122.948, 6.104, 6.104], [120.737, 122.948, 6.104, 6.104], [113.537, 122.948, 6.104, 6.104], [106.337, 122.948, 6.104, 6.104], [99.136, 122.948, 6.104, 6.104], [91.937, 122.948, 6.104, 6.104], [84.737, 122.948, 6.104, 6.104], [77.537, 122.948, 6.104, 6.104], [70.336, 122.948, 6.104, 6.104], [63.137, 122.948, 6.104, 6.104], [55.937, 122.948, 6.104, 6.104], [48.737, 122.948, 6.104, 6.104], [156.737, 137.348, 6.104, 6.104], [156.737, 151.748, 6.104, 6.104], [5.537, 180.548, 6.104, 6.104], [5.537, 173.348, 6.104, 6.104], [5.537, 158.948, 6.104, 6.104], [5.537, 166.148, 6.104, 6.104], [12.737, 158.948, 6.104, 6.104], [12.737, 58.148, 6.104, 6.104], [12.737, 65.348, 6.104, 6.104], [19.937, 65.348, 6.104, 6.104], [19.937, 58.148, 6.104, 6.104], [27.137, 58.148, 6.104, 6.104], [27.137, 65.348, 6.104, 6.104], [19.937, 158.948, 6.104, 6.104], [27.137, 158.948, 6.104, 6.104], [34.337, 158.948, 6.104, 6.104], [41.537, 158.948, 6.104, 6.104], [48.737, 158.948, 6.104, 6.104], [55.937, 158.948, 6.104, 6.104], [12.737, 166.148, 6.104, 6.104], [19.937, 166.148, 6.104, 6.104], [27.137, 166.148, 6.104, 6.104], [34.337, 166.148, 6.104, 6.104], [41.537, 166.148, 6.104, 6.104], [48.737, 166.148, 6.104, 6.104], [55.937, 166.148, 6.104, 6.104], [156.737, 158.948, 6.104, 6.104], [163.937, 158.948, 6.104, 6.104], [171.136, 158.948, 6.104, 6.104], [156.737, 166.148, 6.104, 6.104], [163.937, 166.148, 6.104, 6.104], [171.136, 166.148, 6.104, 6.104], [156.737, 58.148, 6.104, 6.104], [163.937, 58.148, 6.104, 6.104], [171.136, 58.148, 6.104, 6.104], [156.737, 65.348, 6.104, 6.104], [163.937, 65.348, 6.104, 6.104], [171.136, 65.348, 6.104, 6.104], [5.537, 151.748, 6.104, 6.104], [163.937, 151.748, 6.104, 6.104], [5.537, 144.548, 6.104, 6.104], [163.937, 144.548, 6.104, 6.104], [5.537, 137.348, 6.104, 6.104], [163.937, 137.348, 6.104, 6.104], [48.737, 115.748, 6.104, 6.104], [55.937, 115.748, 6.104, 6.104], [63.137, 115.748, 6.104, 6.104], [70.336, 115.748, 6.104, 6.104], [77.537, 115.748, 6.104, 6.104], [84.737, 115.748, 6.104, 6.104], [91.937, 115.748, 6.104, 6.104], [99.136, 115.748, 6.104, 6.104], [106.337, 115.748, 6.104, 6.104], [113.537, 115.748, 6.104, 6.104], [120.737, 115.748, 6.104, 6.104], [127.937, 115.748, 6.104, 6.104], [135.136, 115.748, 6.104, 6.104], [142.337, 115.748, 6.104, 6.104], [149.537, 115.748, 6.104, 6.104], [156.737, 115.748, 6.104, 6.104], [163.937, 115.748, 6.104, 6.104], [48.737, 108.548, 6.104, 6.104], [55.937, 108.548, 6.104, 6.104], [63.137, 108.548, 6.104, 6.104], [70.336, 108.548, 6.104, 6.104], [77.537, 108.548, 6.104, 6.104], [84.737, 108.548, 6.104, 6.104], [91.937, 108.548, 6.104, 6.104], [99.136, 108.548, 6.104, 6.104], [106.337, 108.548, 6.104, 6.104], [113.537, 108.548, 6.104, 6.104], [120.737, 108.548, 6.104, 6.104], [127.937, 108.548, 6.104, 6.104], [135.136, 108.548, 6.104, 6.104], [142.337, 108.548, 6.104, 6.104], [149.537, 108.548, 6.104, 6.104], [156.737, 108.548, 6.104, 6.104], [163.937, 108.548, 6.104, 6.104], [48.737, 101.348, 6.104, 6.104], [55.937, 101.348, 6.104, 6.104], [63.137, 101.348, 6.104, 6.104], [70.336, 101.348, 6.104, 6.104], [77.537, 101.348, 6.104, 6.104], [84.737, 101.348, 6.104, 6.104], [91.937, 101.348, 6.104, 6.104], [99.136, 101.348, 6.104, 6.104], [106.337, 101.348, 6.104, 6.104], [113.537, 101.348, 6.104, 6.104], [120.737, 101.348, 6.104, 6.104], [127.937, 101.348, 6.104, 6.104], [135.136, 101.348, 6.104, 6.104], [142.337, 101.348, 6.104, 6.104], [149.537, 101.348, 6.104, 6.104], [156.737, 101.348, 6.104, 6.104], [163.937, 101.348, 6.104, 6.104], [48.737, 94.148, 6.104, 6.104], [55.937, 94.148, 6.104, 6.104], [63.137, 94.148, 6.104, 6.104], [70.336, 94.148, 6.104, 6.104], [77.537, 94.148, 6.104, 6.104], [84.737, 94.148, 6.104, 6.104], [91.937, 94.148, 6.104, 6.104], [99.136, 94.148, 6.104, 6.104], [106.337, 94.148, 6.104, 6.104], [113.537, 94.148, 6.104, 6.104], [120.737, 94.148, 6.104, 6.104], [127.937, 94.148, 6.104, 6.104], [135.136, 94.148, 6.104, 6.104], [142.337, 94.148, 6.104, 6.104], [149.537, 94.148, 6.104, 6.104], [156.737, 94.148, 6.104, 6.104], [163.937, 94.148, 6.104, 6.104], [5.537, 72.548, 6.104, 6.104], [12.737, 72.548, 6.104, 6.104], [19.937, 72.548, 6.104, 6.104], [27.137, 72.548, 6.104, 6.104], [5.537, 65.348, 6.104, 6.104], [5.537, 58.148, 6.104, 6.104], [12.737, 173.348, 6.104, 6.104], [19.937, 173.348, 6.104, 6.104], [27.137, 173.348, 6.104, 6.104], [34.337, 173.348, 6.104, 6.104], [41.537, 173.348, 6.104, 6.104], [48.737, 173.348, 6.104, 6.104], [55.937, 173.348, 6.104, 6.104], [12.737, 180.548, 6.104, 6.104], [19.937, 180.548, 6.104, 6.104], [27.137, 180.548, 6.104, 6.104], [34.337, 180.548, 6.104, 6.104], [41.537, 180.548, 6.104, 6.104], [48.737, 180.548, 6.104, 6.104], [55.937, 180.548, 6.104, 6.104], [5.537, 50.948, 6.104, 6.104], [12.737, 50.948, 6.104, 6.104], [19.937, 50.948, 6.104, 6.104], [156.737, 173.348, 6.104, 6.104], [163.937, 173.348, 6.104, 6.104], [171.136, 173.348, 6.104, 6.104], [27.137, 50.948, 6.104, 6.104], [5.537, 43.748, 6.104, 6.104], [12.737, 43.748, 6.104, 6.104], [19.937, 43.748, 6.104, 6.104], [27.137, 43.748, 6.104, 6.104], [156.737, 180.548, 6.104, 6.104], [163.937, 180.548, 6.104, 6.104], [171.136, 180.548, 6.104, 6.104], [156.737, 50.948, 6.104, 6.104], [163.937, 50.948, 6.104, 6.104], [171.136, 50.948, 6.104, 6.104], [156.737, 43.748, 6.104, 6.104], [163.937, 43.748, 6.104, 6.104], [171.136, 43.748, 6.104, 6.104], [63.137, 166.148, 6.104, 6.104], [63.137, 158.948, 6.104, 6.104], [99.136, 158.948, 6.104, 6.104], [99.136, 166.148, 6.104, 6.104]]
		}, {
			"name":"JUMPER-3-OLD",
			"description":"",
			"image":"core\/breadboard\/sparkfun-passives_sj_3_paste2_3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_3_paste2_3_breadboard.svg",
			"width":"263",
			"height":"400",
			"points": [[64.535, 333.05, 33.93, 33.9], [164.535, 333.05, 33.93, 33.9], [164.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"SSOP20",
			"description":"",
			"image":"core\/breadboard\/SSOP20_breadboard.svg",
			"icon":"core\/breadboard\/SSOP20_breadboard.svg",
			"width":"72",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"AD7781",
			"description":"20-Bit, Pin-Programmable, Ultralow Power Sigma-Delta ADC",
			"image":"core\/breadboard\/SOIC-14_breadboard.svg",
			"icon":"core\/breadboard\/SOIC-14_breadboard.svg",
			"width":"50.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Ceramic Capacitor",
			"description":"0.01 nF multilayered Ceramic Capacitor",
			"image":"core\/breadboard\/ceramic_capacitor_blue_leg.svg",
			"icon":"core\/breadboard\/ceramic_capacitor_blue_leg.svg",
			"width":"18.836",
			"height":"24.827",
			"points": [[1.919, 13.826, 5, 3], [11.919, 13.826, 5, 3]]
		}, {
			"name":"SSOP24",
			"description":"",
			"image":"core\/breadboard\/SSOP24_breadboard.svg",
			"icon":"core\/breadboard\/SSOP24_breadboard.svg",
			"width":"86.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Header 5x2",
			"description":"Header 5x2Standard 10-pin dual row 0.1 header.Commonly used with AVR-ISP.Use with Spark Fun Electronics SKU: PRT-00778",
			"image":"core\/breadboard\/sparkfun-connectors_avr_icsp_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_avr_icsp_breadboard.svg",
			"width":"57.6",
			"height":"36.918",
			"points": [[12.239, 17.928, 4.296, 4.296], [19.439, 17.928, 4.296, 4.296], [26.639, 17.929, 4.296, 4.296], [33.841, 17.928, 4.296, 4.296], [41.04, 17.928, 4.296, 4.296], [12.239, 25.129, 4.296, 4.296], [19.439, 25.129, 4.296, 4.296], [26.639, 25.129, 4.296, 4.296], [33.841, 25.129, 4.296, 4.296], [41.04, 25.129, 4.296, 4.296]]
		}, {
			"name":"Bluetooth SMD Module",
			"description":"Bluetooth SMD ModuleBR-C40A with antenna cut off.50 Ohm antenna trace and connector required.Footprint fully proven.Spark Fun Electronics SKU: WRL-00149",
			"image":"core\/breadboard\/sparkfun-rf_bluetooth-internal-fp2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_bluetooth-internal-fp2_breadboard.svg",
			"width":"1500",
			"height":"1000",
			"points": [[33.035, 933.05, 33.93, 33.9], [133.035, 933.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 933.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 933.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 933.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 933.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 933.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 933.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 933.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 933.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 933.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 933.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 933.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 933.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 933.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"HMC6343",
			"description":"Honeywell compass IC with tilt compensation, SEN-08656",
			"image":"core\/breadboard\/sparkfun-sensors_lcc36_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lcc36_breadboard.svg",
			"width":"1800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"TOUCH-SCREEN",
			"description":"Nintendo DS touch screen connector LCD-09105",
			"image":"core\/breadboard\/sparkfun-connectors_touch-screen_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_touch-screen_breadboard.svg",
			"width":"438.72",
			"height":"600",
			"points": [[102.395, 533.05, 33.93, 33.9], [102.395, 33.05, 33.93, 33.9], [202.395, 533.05, 33.93, 33.9], [202.395, 33.05, 33.93, 33.9], [302.395, 533.05, 33.93, 33.9], [302.395, 33.05, 33.93, 33.9]]
		}, {
			"name":"LHi958",
			"description":"The LHi 954 and LHi 958 pyroelectric infrared-detectors have been a worldstandard for more than 10 years.They both are dual element types with FET insource follower connection.The LHi 954 detector is available in TO-39 housingwith standard infrared filter whereas the LHi 958 is the same detector in a TO-5housing with standard infrared filter.It offers a highly stable responsivity with excellent common mode performance(match)and low noise.",
			"image":"core\/breadboard\/lhi958-pir_breadboard.svg",
			"icon":"core\/breadboard\/lhi958-pir_breadboard.svg",
			"width":"25.82",
			"height":"35.359",
			"points": [[5.48, 5.48, 6, 6], [12.656, 12.656, 6, 6], [19.879, 19.879, 6, 6], [12.68, 12.68, 6, 6]]
		}, {
			"name":"Electrolytic Capacitor",
			"description":"A small electrolytic capacitor",
			"image":"core\/breadboard\/electrolytic_capacitor_small_leg.svg",
			"icon":"core\/breadboard\/electrolytic_capacitor_small_leg.svg",
			"width":"19.686",
			"height":"48.266",
			"points": [[12.39, 44.19, 5, 3], [2.39, 44.19, 5, 3]]
		}, {
			"name":"microSD Socket",
			"description":"microSD SocketPush-push type uSD socket.Schematic element and footprint production proven.Spark Fun Electronics SKU: PRT-00127.tDoc lines correctly indicate media card edge positions when inserting(unlocked, locked, depressed).",
			"image":"core\/breadboard\/sparkfun-connectors_usd-socket-pp_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usd-socket-pp_breadboard.svg",
			"width":"772.833",
			"height":"1000",
			"points": [[119.452, 933.05, 33.93, 33.9], [119.452, 33.05, 33.93, 33.9], [219.452, 933.05, 33.93, 33.9], [219.452, 33.05, 33.93, 33.9], [319.452, 933.05, 33.93, 33.9], [319.452, 33.05, 33.93, 33.9], [419.452, 933.05, 33.93, 33.9], [419.452, 33.05, 33.93, 33.9], [519.452, 933.05, 33.93, 33.9], [519.452, 33.05, 33.93, 33.9], [619.452, 933.05, 33.93, 33.9], [619.452, 33.05, 33.93, 33.9]]
		}, {
			"name":"Half breadboard",
			"description":"A breadboard for easily prototyping circuits",
			"image":"core\/breadboard\/Half_breadboard56a.svg",
			"icon":"core\/breadboard\/Half_breadboard56a.svg",
			"width":"292.40924",
			"height":"188.99906",
			"points": [[11.15, 141.49952302908, 4.9920002, 4.9920002], [11.15, 132.49952302908, 4.9920002, 4.9920002], [11.15, 123.49952302908, 4.9920002, 4.9920002], [11.15, 114.49952302908, 4.9920002, 4.9920002], [11.15, 105.49952302908, 4.9920002, 4.9920002], [11.15, 78.499523029084, 4.9920002, 4.9920002], [11.15, 69.499523029084, 4.9920002, 4.9920002], [11.15, 60.499523029084, 4.9920002, 4.9920002], [11.15, 51.499523029084, 4.9920002, 4.9920002], [11.15, 42.499523029084, 4.9920002, 4.9920002], [20.15, 141.49952302908, 4.9920002, 4.9920002], [20.15, 132.49952302908, 4.9920002, 4.9920002], [20.15, 123.49952302908, 4.9920002, 4.9920002], [20.15, 114.49952302908, 4.9920002, 4.9920002], [20.15, 105.49952302908, 4.9920002, 4.9920002], [20.15, 78.499523029084, 4.9920002, 4.9920002], [20.15, 69.499523029084, 4.9920002, 4.9920002], [20.15, 60.499523029084, 4.9920002, 4.9920002], [20.15, 51.499523029084, 4.9920002, 4.9920002], [20.15, 42.499523029084, 4.9920002, 4.9920002], [29.15, 141.49952302908, 4.9920002, 4.9920002], [29.15, 132.49952302908, 4.9920002, 4.9920002], [29.15, 123.49952302908, 4.9920002, 4.9920002], [29.15, 114.49952302908, 4.9920002, 4.9920002], [29.15, 105.49952302908, 4.9920002, 4.9920002], [29.15, 78.499523029084, 4.9920002, 4.9920002], [29.15, 69.499523029084, 4.9920002, 4.9920002], [29.15, 60.499523029084, 4.9920002, 4.9920002], [29.15, 51.499523029084, 4.9920002, 4.9920002], [29.15, 42.499523029084, 4.9920002, 4.9920002], [38.150002, 141.49952302908, 4.9920002, 4.9920002], [38.150002, 132.49952302908, 4.9920002, 4.9920002], [38.150002, 123.49952302908, 4.9920002, 4.9920002], [38.150002, 114.49952302908, 4.9920002, 4.9920002], [38.150002, 105.49952302908, 4.9920002, 4.9920002], [38.150002, 78.499523029084, 4.9920002, 4.9920002], [38.150002, 69.499523029084, 4.9920002, 4.9920002], [38.150002, 60.499523029084, 4.9920002, 4.9920002], [38.150002, 51.499523029084, 4.9920002, 4.9920002], [38.150002, 42.499523029084, 4.9920002, 4.9920002], [47.150002, 141.49952302908, 4.9920002, 4.9920002], [47.150002, 132.49952302908, 4.9920002, 4.9920002], [47.150002, 123.49952302908, 4.9920002, 4.9920002], [47.150002, 114.49952302908, 4.9920002, 4.9920002], [47.150002, 105.49952302908, 4.9920002, 4.9920002], [47.150002, 78.499523029084, 4.9920002, 4.9920002], [47.150002, 69.499523029084, 4.9920002, 4.9920002], [47.150002, 60.499523029084, 4.9920002, 4.9920002], [47.150002, 51.499523029084, 4.9920002, 4.9920002], [47.150002, 42.499523029084, 4.9920002, 4.9920002], [56.150002, 141.49952302908, 4.9920002, 4.9920002], [56.150002, 132.49952302908, 4.9920002, 4.9920002], [56.150002, 123.49952302908, 4.9920002, 4.9920002], [56.150002, 114.49952302908, 4.9920002, 4.9920002], [56.150002, 105.49952302908, 4.9920002, 4.9920002], [56.150002, 78.499523029084, 4.9920002, 4.9920002], [56.150002, 69.499523029084, 4.9920002, 4.9920002], [56.150002, 60.499523029084, 4.9920002, 4.9920002], [56.150002, 51.499523029084, 4.9920002, 4.9920002], [56.150002, 42.499523029084, 4.9920002, 4.9920002], [65.150002, 141.49952302908, 4.9920002, 4.9920002], [65.150002, 132.49952302908, 4.9920002, 4.9920002], [65.150002, 123.49952302908, 4.9920002, 4.9920002], [65.150002, 114.49952302908, 4.9920002, 4.9920002], [65.150002, 105.49952302908, 4.9920002, 4.9920002], [65.150002, 78.499523029084, 4.9920002, 4.9920002], [65.150002, 69.499523029084, 4.9920002, 4.9920002], [65.150002, 60.499523029084, 4.9920002, 4.9920002], [65.150002, 51.499523029084, 4.9920002, 4.9920002], [65.150002, 42.499523029084, 4.9920002, 4.9920002], [74.150002, 141.49952302908, 4.9920002, 4.9920002], [74.150002, 132.49952302908, 4.9920002, 4.9920002], [74.150002, 123.49952302908, 4.9920002, 4.9920002], [74.150002, 114.49952302908, 4.9920002, 4.9920002], [74.150002, 105.49952302908, 4.9920002, 4.9920002], [74.150002, 78.499523029084, 4.9920002, 4.9920002], [74.150002, 69.499523029084, 4.9920002, 4.9920002], [74.150002, 60.499523029084, 4.9920002, 4.9920002], [74.150002, 51.499523029084, 4.9920002, 4.9920002], [74.150002, 42.499523029084, 4.9920002, 4.9920002], [83.150002, 141.49952302908, 4.9920002, 4.9920002], [83.150002, 132.49952302908, 4.9920002, 4.9920002], [83.150002, 123.49952302908, 4.9920002, 4.9920002], [83.150002, 114.49952302908, 4.9920002, 4.9920002], [83.150002, 105.49952302908, 4.9920002, 4.9920002], [83.150002, 78.499523029084, 4.9920002, 4.9920002], [83.150002, 69.499523029084, 4.9920002, 4.9920002], [83.150002, 60.499523029084, 4.9920002, 4.9920002], [83.150002, 51.499523029084, 4.9920002, 4.9920002], [83.150002, 42.499523029084, 4.9920002, 4.9920002], [92.150002, 141.49952302908, 4.9920002, 4.9920002], [92.150002, 132.49952302908, 4.9920002, 4.9920002], [92.150002, 123.49952302908, 4.9920002, 4.9920002], [92.150002, 114.49952302908, 4.9920002, 4.9920002], [92.150002, 105.49952302908, 4.9920002, 4.9920002], [92.150002, 78.499523029084, 4.9920002, 4.9920002], [92.150002, 69.499523029084, 4.9920002, 4.9920002], [92.150002, 60.499523029084, 4.9920002, 4.9920002], [92.150002, 51.499523029084, 4.9920002, 4.9920002], [92.150002, 42.499523029084, 4.9920002, 4.9920002], [101.15, 141.49952302908, 4.9920002, 4.9920002], [101.15, 132.49952302908, 4.9920002, 4.9920002], [101.15, 123.49952302908, 4.9920002, 4.9920002], [101.15, 114.49952302908, 4.9920002, 4.9920002], [101.15, 105.49952302908, 4.9920002, 4.9920002], [101.15, 78.499523029084, 4.9920002, 4.9920002], [101.15, 69.499523029084, 4.9920002, 4.9920002], [101.15, 60.499523029084, 4.9920002, 4.9920002], [101.15, 51.499523029084, 4.9920002, 4.9920002], [101.15, 42.499523029084, 4.9920002, 4.9920002], [110.15, 141.49952302908, 4.9920002, 4.9920002], [110.15, 132.49952302908, 4.9920002, 4.9920002], [110.15, 123.49952302908, 4.9920002, 4.9920002], [110.15, 114.49952302908, 4.9920002, 4.9920002], [110.15, 105.49952302908, 4.9920002, 4.9920002], [110.15, 78.499523029084, 4.9920002, 4.9920002], [110.15, 69.499523029084, 4.9920002, 4.9920002], [110.15, 60.499523029084, 4.9920002, 4.9920002], [110.15, 51.499523029084, 4.9920002, 4.9920002], [110.15, 42.499523029084, 4.9920002, 4.9920002], [119.15, 141.49952302908, 4.9920002, 4.9920002], [119.15, 132.49952302908, 4.9920002, 4.9920002], [119.15, 123.49952302908, 4.9920002, 4.9920002], [119.15, 114.49952302908, 4.9920002, 4.9920002], [119.15, 105.49952302908, 4.9920002, 4.9920002], [119.15, 78.499523029084, 4.9920002, 4.9920002], [119.15, 69.499523029084, 4.9920002, 4.9920002], [119.15, 60.499523029084, 4.9920002, 4.9920002], [119.15, 51.499523029084, 4.9920002, 4.9920002], [119.15, 42.499523029084, 4.9920002, 4.9920002], [128.14999, 141.49952302908, 4.9920002, 4.9920002], [128.14999, 132.49952302908, 4.9920002, 4.9920002], [128.14999, 123.49952302908, 4.9920002, 4.9920002], [128.14999, 114.49952302908, 4.9920002, 4.9920002], [128.14999, 105.49952302908, 4.9920002, 4.9920002], [128.14999, 78.499523029084, 4.9920002, 4.9920002], [128.14999, 69.499523029084, 4.9920002, 4.9920002], [128.14999, 60.499523029084, 4.9920002, 4.9920002], [128.14999, 51.499523029084, 4.9920002, 4.9920002], [128.14999, 42.499523029084, 4.9920002, 4.9920002], [137.14999, 141.49952302908, 4.9920002, 4.9920002], [137.14999, 132.49952302908, 4.9920002, 4.9920002], [137.14999, 123.49952302908, 4.9920002, 4.9920002], [137.14999, 114.49952302908, 4.9920002, 4.9920002], [137.14999, 105.49952302908, 4.9920002, 4.9920002], [137.14999, 78.499523029084, 4.9920002, 4.9920002], [137.14999, 69.499523029084, 4.9920002, 4.9920002], [137.14999, 60.499523029084, 4.9920002, 4.9920002], [137.14999, 51.499523029084, 4.9920002, 4.9920002], [137.14999, 42.499523029084, 4.9920002, 4.9920002], [146.14999, 141.49952302908, 4.9920002, 4.9920002], [146.14999, 132.49952302908, 4.9920002, 4.9920002], [146.14999, 123.49952302908, 4.9920002, 4.9920002], [146.14999, 114.49952302908, 4.9920002, 4.9920002], [146.14999, 105.49952302908, 4.9920002, 4.9920002], [146.14999, 78.499523029084, 4.9920002, 4.9920002], [146.14999, 69.499523029084, 4.9920002, 4.9920002], [146.14999, 60.499523029084, 4.9920002, 4.9920002], [146.14999, 51.499523029084, 4.9920002, 4.9920002], [146.14999, 42.499523029084, 4.9920002, 4.9920002], [155.14999, 141.49952302908, 4.9920002, 4.9920002], [155.14999, 132.49952302908, 4.9920002, 4.9920002], [155.14999, 123.49952302908, 4.9920002, 4.9920002], [155.14999, 114.49952302908, 4.9920002, 4.9920002], [155.14999, 105.49952302908, 4.9920002, 4.9920002], [155.14999, 78.499523029084, 4.9920002, 4.9920002], [155.14999, 69.499523029084, 4.9920002, 4.9920002], [155.14999, 60.499523029084, 4.9920002, 4.9920002], [155.14999, 51.499523029084, 4.9920002, 4.9920002], [155.14999, 42.499523029084, 4.9920002, 4.9920002], [164.14999, 141.49952302908, 4.9920002, 4.9920002], [164.14999, 132.49952302908, 4.9920002, 4.9920002], [164.14999, 123.49952302908, 4.9920002, 4.9920002], [164.14999, 114.49952302908, 4.9920002, 4.9920002], [164.14999, 105.49952302908, 4.9920002, 4.9920002], [164.14999, 78.499523029084, 4.9920002, 4.9920002], [164.14999, 69.499523029084, 4.9920002, 4.9920002], [164.14999, 60.499523029084, 4.9920002, 4.9920002], [164.14999, 51.499523029084, 4.9920002, 4.9920002], [164.14999, 42.499523029084, 4.9920002, 4.9920002], [173.14999, 141.49952302908, 4.9920002, 4.9920002], [173.14999, 132.49952302908, 4.9920002, 4.9920002], [173.14999, 123.49952302908, 4.9920002, 4.9920002], [173.14999, 114.49952302908, 4.9920002, 4.9920002], [173.14999, 105.49952302908, 4.9920002, 4.9920002], [173.14999, 78.499523029084, 4.9920002, 4.9920002], [173.14999, 69.499523029084, 4.9920002, 4.9920002], [173.14999, 60.499523029084, 4.9920002, 4.9920002], [173.14999, 51.499523029084, 4.9920002, 4.9920002], [173.14999, 42.499523029084, 4.9920002, 4.9920002], [182.14999, 141.49952302908, 4.9920002, 4.9920002], [182.14999, 132.49952302908, 4.9920002, 4.9920002], [182.14999, 123.49952302908, 4.9920002, 4.9920002], [182.14999, 114.49952302908, 4.9920002, 4.9920002], [182.14999, 105.49952302908, 4.9920002, 4.9920002], [182.14999, 78.499523029084, 4.9920002, 4.9920002], [182.14999, 69.499523029084, 4.9920002, 4.9920002], [182.14999, 60.499523029084, 4.9920002, 4.9920002], [182.14999, 51.499523029084, 4.9920002, 4.9920002], [182.14999, 42.499523029084, 4.9920002, 4.9920002], [191.14999, 141.49952302908, 4.9920002, 4.9920002], [191.14999, 132.49952302908, 4.9920002, 4.9920002], [191.14999, 123.49952302908, 4.9920002, 4.9920002], [191.14999, 114.49952302908, 4.9920002, 4.9920002], [191.14999, 105.49952302908, 4.9920002, 4.9920002], [191.14999, 78.499523029084, 4.9920002, 4.9920002], [191.14999, 69.499523029084, 4.9920002, 4.9920002], [191.14999, 60.499523029084, 4.9920002, 4.9920002], [191.14999, 51.499523029084, 4.9920002, 4.9920002], [191.14999, 42.499523029084, 4.9920002, 4.9920002], [200.14999, 141.49952302908, 4.9920002, 4.9920002], [200.14999, 132.49952302908, 4.9920002, 4.9920002], [200.14999, 123.49952302908, 4.9920002, 4.9920002], [200.14999, 114.49952302908, 4.9920002, 4.9920002], [200.14999, 105.49952302908, 4.9920002, 4.9920002], [200.14999, 78.499523029084, 4.9920002, 4.9920002], [200.14999, 69.499523029084, 4.9920002, 4.9920002], [200.14999, 60.499523029084, 4.9920002, 4.9920002], [200.14999, 51.499523029084, 4.9920002, 4.9920002], [200.14999, 42.499523029084, 4.9920002, 4.9920002], [209.14999, 141.49952302908, 4.9920002, 4.9920002], [209.14999, 132.49952302908, 4.9920002, 4.9920002], [209.14999, 123.49952302908, 4.9920002, 4.9920002], [209.14999, 114.49952302908, 4.9920002, 4.9920002], [209.14999, 105.49952302908, 4.9920002, 4.9920002], [209.14999, 78.499523029084, 4.9920002, 4.9920002], [209.14999, 69.499523029084, 4.9920002, 4.9920002], [209.14999, 60.499523029084, 4.9920002, 4.9920002], [209.14999, 51.499523029084, 4.9920002, 4.9920002], [209.14999, 42.499523029084, 4.9920002, 4.9920002], [218.14999, 141.49952302908, 4.9920002, 4.9920002], [218.14999, 132.49952302908, 4.9920002, 4.9920002], [218.14999, 123.49952302908, 4.9920002, 4.9920002], [218.14999, 114.49952302908, 4.9920002, 4.9920002], [218.14999, 105.49952302908, 4.9920002, 4.9920002], [218.14999, 78.499523029084, 4.9920002, 4.9920002], [218.14999, 69.499523029084, 4.9920002, 4.9920002], [218.14999, 60.499523029084, 4.9920002, 4.9920002], [218.14999, 51.499523029084, 4.9920002, 4.9920002], [218.14999, 42.499523029084, 4.9920002, 4.9920002], [227.14999, 141.49952302908, 4.9920002, 4.9920002], [227.14999, 132.49952302908, 4.9920002, 4.9920002], [227.14999, 123.49952302908, 4.9920002, 4.9920002], [227.14999, 114.49952302908, 4.9920002, 4.9920002], [227.14999, 105.49952302908, 4.9920002, 4.9920002], [227.14999, 78.499523029084, 4.9920002, 4.9920002], [227.14999, 69.499523029084, 4.9920002, 4.9920002], [227.14999, 60.499523029084, 4.9920002, 4.9920002], [227.14999, 51.499523029084, 4.9920002, 4.9920002], [227.14999, 42.499523029084, 4.9920002, 4.9920002], [236.14999, 141.49952302908, 4.9920002, 4.9920002], [236.14999, 132.49952302908, 4.9920002, 4.9920002], [236.14999, 123.49952302908, 4.9920002, 4.9920002], [236.14999, 114.49952302908, 4.9920002, 4.9920002], [236.14999, 105.49952302908, 4.9920002, 4.9920002], [236.14999, 78.499523029084, 4.9920002, 4.9920002], [236.14999, 69.499523029084, 4.9920002, 4.9920002], [236.14999, 60.499523029084, 4.9920002, 4.9920002], [236.14999, 51.499523029084, 4.9920002, 4.9920002], [236.14999, 42.499523029084, 4.9920002, 4.9920002], [245.14999, 141.49952302908, 4.9920002, 4.9920002], [245.14999, 132.49952302908, 4.9920002, 4.9920002], [245.14999, 123.49952302908, 4.9920002, 4.9920002], [245.14999, 114.49952302908, 4.9920002, 4.9920002], [245.14999, 105.49952302908, 4.9920002, 4.9920002], [245.14999, 78.499523029084, 4.9920002, 4.9920002], [245.14999, 69.499523029084, 4.9920002, 4.9920002], [245.14999, 60.499523029084, 4.9920002, 4.9920002], [245.14999, 51.499523029084, 4.9920002, 4.9920002], [245.14999, 42.499523029084, 4.9920002, 4.9920002], [254.14999, 141.49952302908, 4.9920002, 4.9920002], [254.14999, 132.49952302908, 4.9920002, 4.9920002], [254.14999, 123.49952302908, 4.9920002, 4.9920002], [254.14999, 114.49952302908, 4.9920002, 4.9920002], [254.14999, 105.49952302908, 4.9920002, 4.9920002], [254.14999, 78.499523029084, 4.9920002, 4.9920002], [254.14999, 69.499523029084, 4.9920002, 4.9920002], [254.14999, 60.499523029084, 4.9920002, 4.9920002], [254.14999, 51.499523029084, 4.9920002, 4.9920002], [254.14999, 42.499523029084, 4.9920002, 4.9920002], [263.14999, 141.49952302908, 4.9920002, 4.9920002], [263.14999, 132.49952302908, 4.9920002, 4.9920002], [263.14999, 123.49952302908, 4.9920002, 4.9920002], [263.14999, 114.49952302908, 4.9920002, 4.9920002], [263.14999, 105.49952302908, 4.9920002, 4.9920002], [263.14999, 78.499523029084, 4.9920002, 4.9920002], [263.14999, 69.499523029084, 4.9920002, 4.9920002], [263.14999, 60.499523029084, 4.9920002, 4.9920002], [263.14999, 51.499523029084, 4.9920002, 4.9920002], [263.14999, 42.499523029084, 4.9920002, 4.9920002], [272.14999, 141.49952302908, 4.9920002, 4.9920002], [272.14999, 132.49952302908, 4.9920002, 4.9920002], [272.14999, 123.49952302908, 4.9920002, 4.9920002], [272.14999, 114.49952302908, 4.9920002, 4.9920002], [272.14999, 105.49952302908, 4.9920002, 4.9920002], [272.14999, 78.499523029084, 4.9920002, 4.9920002], [272.14999, 69.499523029084, 4.9920002, 4.9920002], [272.14999, 60.499523029084, 4.9920002, 4.9920002], [272.14999, 51.499523029084, 4.9920002, 4.9920002], [272.14999, 42.499523029084, 4.9920002, 4.9920002], [14.49992937, 177.49952302908, 4.9920002, 4.9920002], [14.49992937, 168.49952302908, 4.9920002, 4.9920002], [14.49992937, 15.499523029084, 4.9920002, 4.9920002], [14.49992937, 6.4995230290838, 4.9920002, 4.9920002], [23.49992937, 177.49952302908, 4.9920002, 4.9920002], [23.49992937, 168.49952302908, 4.9920002, 4.9920002], [23.49992937, 15.499523029084, 4.9920002, 4.9920002], [23.49992937, 6.4995230290838, 4.9920002, 4.9920002], [32.49992937, 177.49952302908, 4.9920002, 4.9920002], [32.49992937, 168.49952302908, 4.9920002, 4.9920002], [32.49992937, 15.499523029084, 4.9920002, 4.9920002], [32.49992937, 6.4995230290838, 4.9920002, 4.9920002], [41.49992937, 177.49952302908, 4.9920002, 4.9920002], [41.49992937, 168.49952302908, 4.9920002, 4.9920002], [41.49992937, 15.499523029084, 4.9920002, 4.9920002], [41.49992937, 6.4995230290838, 4.9920002, 4.9920002], [50.49992937, 177.49952302908, 4.9920002, 4.9920002], [50.49992937, 168.49952302908, 4.9920002, 4.9920002], [50.49992937, 15.499523029084, 4.9920002, 4.9920002], [50.49992937, 6.4995230290838, 4.9920002, 4.9920002], [68.49992937, 177.49952302908, 4.9920002, 4.9920002], [68.49992937, 168.49952302908, 4.9920002, 4.9920002], [68.49992937, 15.499523029084, 4.9920002, 4.9920002], [68.49992937, 6.4995230290838, 4.9920002, 4.9920002], [77.49992937, 177.49952302908, 4.9920002, 4.9920002], [77.49992937, 168.49952302908, 4.9920002, 4.9920002], [77.49992937, 15.499523029084, 4.9920002, 4.9920002], [77.49992937, 6.4995230290838, 4.9920002, 4.9920002], [86.49992937, 177.49952302908, 4.9920002, 4.9920002], [86.49992937, 168.49952302908, 4.9920002, 4.9920002], [86.49992937, 15.499523029084, 4.9920002, 4.9920002], [86.49992937, 6.4995230290838, 4.9920002, 4.9920002], [95.49992937, 177.49952302908, 4.9920002, 4.9920002], [95.49992937, 168.49952302908, 4.9920002, 4.9920002], [95.49992937, 15.499523029084, 4.9920002, 4.9920002], [95.49992937, 6.4995230290838, 4.9920002, 4.9920002], [104.49992937, 177.49952302908, 4.9920002, 4.9920002], [104.49992937, 168.49952302908, 4.9920002, 4.9920002], [104.49992937, 15.499523029084, 4.9920002, 4.9920002], [104.49992937, 6.4995230290838, 4.9920002, 4.9920002], [122.49992937, 177.49952302908, 4.9920002, 4.9920002], [122.49992937, 168.49952302908, 4.9920002, 4.9920002], [122.49992937, 15.499523029084, 4.9920002, 4.9920002], [122.49992937, 6.4995230290838, 4.9920002, 4.9920002], [131.49992937, 177.49952302908, 4.9920002, 4.9920002], [131.49992937, 168.49952302908, 4.9920002, 4.9920002], [131.49992937, 15.499523029084, 4.9920002, 4.9920002], [131.49992937, 6.4995230290838, 4.9920002, 4.9920002], [140.49992937, 177.49952302908, 4.9920002, 4.9920002], [140.49992937, 168.49952302908, 4.9920002, 4.9920002], [140.49992937, 15.499523029084, 4.9920002, 4.9920002], [140.49992937, 6.4995230290838, 4.9920002, 4.9920002], [149.49992937, 177.49952302908, 4.9920002, 4.9920002], [149.49992937, 168.49952302908, 4.9920002, 4.9920002], [149.49992937, 15.499523029084, 4.9920002, 4.9920002], [149.49992937, 6.4995230290838, 4.9920002, 4.9920002], [158.49992937, 177.49952302908, 4.9920002, 4.9920002], [158.49992937, 168.49952302908, 4.9920002, 4.9920002], [158.49992937, 15.499523029084, 4.9920002, 4.9920002], [158.49992937, 6.4995230290838, 4.9920002, 4.9920002], [176.49992937, 177.49952302908, 4.9920002, 4.9920002], [176.49992937, 168.49952302908, 4.9920002, 4.9920002], [176.49992937, 15.499523029084, 4.9920002, 4.9920002], [176.49992937, 6.4995230290838, 4.9920002, 4.9920002], [185.49992937, 177.49952302908, 4.9920002, 4.9920002], [185.49992937, 168.49952302908, 4.9920002, 4.9920002], [185.49992937, 15.499523029084, 4.9920002, 4.9920002], [185.49992937, 6.4995230290838, 4.9920002, 4.9920002], [194.49992937, 177.49952302908, 4.9920002, 4.9920002], [194.49992937, 168.49952302908, 4.9920002, 4.9920002], [194.49992937, 15.499523029084, 4.9920002, 4.9920002], [194.49992937, 6.4995230290838, 4.9920002, 4.9920002], [203.49992937, 177.49952302908, 4.9920002, 4.9920002], [203.49992937, 168.49952302908, 4.9920002, 4.9920002], [203.49992937, 15.499523029084, 4.9920002, 4.9920002], [203.49992937, 6.4995230290838, 4.9920002, 4.9920002], [212.49992937, 177.49952302908, 4.9920002, 4.9920002], [212.49992937, 168.49952302908, 4.9920002, 4.9920002], [212.49992937, 15.499523029084, 4.9920002, 4.9920002], [212.49992937, 6.4995230290838, 4.9920002, 4.9920002], [230.49992937, 177.49952302908, 4.9920002, 4.9920002], [230.49992937, 168.49952302908, 4.9920002, 4.9920002], [230.49992937, 15.499523029084, 4.9920002, 4.9920002], [230.49992937, 6.4995230290838, 4.9920002, 4.9920002], [239.49992937, 177.49952302908, 4.9920002, 4.9920002], [239.49992937, 168.49952302908, 4.9920002, 4.9920002], [239.49992937, 15.499523029084, 4.9920002, 4.9920002], [239.49992937, 6.4995230290838, 4.9920002, 4.9920002], [248.49992937, 177.49952302908, 4.9920002, 4.9920002], [248.49992937, 168.49952302908, 4.9920002, 4.9920002], [248.49992937, 15.499523029084, 4.9920002, 4.9920002], [248.49992937, 6.4995230290838, 4.9920002, 4.9920002], [257.49992937, 177.49952302908, 4.9920002, 4.9920002], [257.49992937, 168.49952302908, 4.9920002, 4.9920002], [257.49992937, 15.499523029084, 4.9920002, 4.9920002], [257.49992937, 6.4995230290838, 4.9920002, 4.9920002], [266.49992937, 177.49952302908, 4.9920002, 4.9920002], [266.49992937, 168.49952302908, 4.9920002, 4.9920002], [266.49992937, 15.499523029084, 4.9920002, 4.9920002], [266.49992937, 6.4995230290838, 4.9920002, 4.9920002]]
		}, {
			"name":"TLP621",
			"description":"TLP621Optocoupler-keeps you from frying your stuff!",
			"image":"core\/breadboard\/Optocoupler_TLP621_breadboard.svg",
			"icon":"core\/breadboard\/Optocoupler_TLP621_breadboard.svg",
			"width":"18.031494",
			"height":"33.002628",
			"points": [[1.5144427, 27.662626, 5, 6.3400002], [11.514442, 27.662626, 5, 6.3400002], [1.5144427, -0.962415121, 5, 6.3400002], [11.703190388096, -0.72081441480445, 4.2836370096971, 5.9429871563697]]
		}, {
			"name":"OPA344",
			"description":"Single gate rail-to-rail output op-amp.Inputs extend 300mV past rails.",
			"image":"core\/breadboard\/sparkfun-analogic_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"LilyPad Slide Switch",
			"description":"This is a simple slide switch for the LilyPad.Use it as a simple ON\/OFF switch , or to control LEDs, buzzers, sensors, etc.LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They 're even washable!Note: A portion of this sale is given back to Dr. Leah Buechley for continued development and education of e-textiles.Dimensions:7.75x18.1mmThin 0.8mm PCB",
			"image":"core\/breadboard\/LilyPad-slide-switch13_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad-slide-switch13_breadboard.svg",
			"width":"21.6",
			"height":"51.42",
			"points": [[233.035, 33.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Mega ADK (Rev3)",
			"description":"The Arduino ADK is a microcontroller board based on the ATmega2560 (datasheet). It has a USB host interface to connect with Android based phones, based on the MAX3421e IC. It has 54 digital input\/output pins (of which 14 can be used as PWM outputs), 16 analog inputs, 4 UARTs (hardware serial ports), a 16 MHz crystal oscillator, a USB connection, a power jack, an ICSP header, and a reset button.The ADK is based on the Mega 2560.Similar to the Mega 2560 and Uno, it features an ATmega8U2 programmed as a USB-to-serial converter.Revision 2 of the MegaADK board has a resistor pulling the 8U2 HWB line to ground, making it easier to put into DFU mode.Revision 3 of the board has the following new features: 1.0 pinout: added SDA and SCL pins that are near to the AREF pin and two other new pins placed near to the RESET pin, the IOREF that allow the shields to adapt to the voltage provided from the board. In future, shields will be compatible both with the board that use the AVR, which operate with 5V and with the Arduino Due that operate with 3.3V. The second one is a not connected pin, that is reserved for future purposes. Stronger RESET circuit. For information on using the board with the Android OS, see Google' s ADK documentation.",
			"image":"core\/breadboard\/Arduino_ADK_MEGA_2560-Rev3_breadboard.svg",
			"icon":"core\/breadboard\/Arduino_ADK_MEGA_2560-Rev3_breadboard.svg",
			"width":"305.973",
			"height":"151.2",
			"points": [[202.683, 61.77, 5.768, 5.768], [195.483, 61.77, 5.768, 5.768], [202.683, 68.957, 5.768, 5.768], [195.483, 68.957, 5.768, 5.768], [202.683, 76.145, 5.768, 5.768], [195.483, 76.145, 5.768, 5.768], [224.161, 141.39, 5.22, 5.22], [231.363, 141.39, 5.22, 5.22], [238.561, 141.39, 5.22, 5.22], [245.763, 141.39, 5.22, 5.22], [252.963, 141.39, 5.22, 5.22], [260.161, 141.39, 5.22, 5.22], [267.363, 141.39, 5.22, 5.22], [274.561, 141.39, 5.22, 5.22], [159.363, 141.39, 5.22, 5.22], [166.561, 141.39, 5.22, 5.22], [173.763, 141.39, 5.22, 5.22], [180.963, 141.39, 5.22, 5.22], [188.161, 141.39, 5.22, 5.22], [195.363, 141.39, 5.22, 5.22], [202.561, 141.39, 5.22, 5.22], [209.763, 141.39, 5.22, 5.22], [260.161, 4.59, 5.22, 5.22], [252.963, 4.59, 5.22, 5.22], [245.763, 4.59, 5.22, 5.22], [238.561, 4.59, 5.22, 5.22], [231.363, 4.59, 5.22, 5.22], [224.161, 4.59, 5.22, 5.22], [216.963, 4.59, 5.22, 5.22], [209.763, 4.59, 5.22, 5.22], [74.241, 13.789, 5.542, 5.542], [74.24, 20.988, 5.544, 5.544], [67.041, 13.789, 5.542, 5.542], [67.04, 20.988, 5.544, 5.544], [59.84, 13.789, 5.542, 5.542], [59.839, 20.988, 5.544, 5.544], [83.042, 4.59, 5.22, 5.22], [90.242, 4.59, 5.22, 5.22], [97.442, 4.59, 5.22, 5.22], [104.642, 4.59, 5.22, 5.22], [111.842, 4.59, 5.22, 5.22], [119.042, 4.59, 5.22, 5.22], [126.242, 4.59, 5.22, 5.22], [133.442, 4.59, 5.22, 5.22], [108.962, 141.39, 5.22, 5.22], [116.162, 141.39, 5.22, 5.22], [123.362, 141.39, 5.22, 5.22], [130.562, 141.39, 5.22, 5.22], [137.762, 141.39, 5.22, 5.22], [144.962, 141.39, 5.22, 5.22], [195.363, 4.59, 5.22, 5.22], [188.161, 4.59, 5.22, 5.22], [180.963, 4.59, 5.22, 5.22], [173.763, 4.59, 5.22, 5.22], [166.561, 4.59, 5.22, 5.22], [159.363, 4.59, 5.22, 5.22], [152.161, 4.59, 5.22, 5.22], [144.962, 4.59, 5.22, 5.22], [281.512, 4.339, 5.722, 5.722], [288.711, 4.339, 5.722, 5.722], [281.512, 11.539, 5.722, 5.722], [288.711, 11.539, 5.722, 5.722], [281.512, 18.739, 5.722, 5.722], [288.711, 18.739, 5.722, 5.722], [281.512, 25.939, 5.722, 5.722], [288.711, 25.939, 5.722, 5.722], [281.512, 33.139, 5.722, 5.722], [288.711, 33.139, 5.722, 5.722], [281.512, 40.339, 5.722, 5.722], [288.711, 40.339, 5.722, 5.722], [281.512, 47.539, 5.722, 5.722], [288.711, 47.539, 5.722, 5.722], [281.512, 54.739, 5.722, 5.722], [288.711, 54.739, 5.722, 5.722], [281.512, 61.939, 5.722, 5.722], [288.711, 61.939, 5.722, 5.722], [281.512, 69.139, 5.722, 5.722], [288.711, 69.139, 5.722, 5.722], [281.512, 76.339, 5.722, 5.722], [288.711, 76.339, 5.722, 5.722], [281.513, 83.54, 5.72, 5.72], [288.712, 83.54, 5.72, 5.72], [281.512, 90.739, 5.722, 5.722], [288.711, 90.739, 5.722, 5.722], [281.512, 97.939, 5.722, 5.722], [288.711, 97.939, 5.722, 5.722], [281.512, 105.139, 5.722, 5.722], [288.711, 105.139, 5.722, 5.722], [281.512, 112.339, 5.722, 5.722], [288.711, 112.339, 5.722, 5.722], [281.513, 119.54, 5.72, 5.72], [288.712, 119.54, 5.72, 5.72], [281.512, 126.739, 5.722, 5.722], [288.711, 126.739, 5.722, 5.722], [94.561, 141.39, 5.22, 5.22], [101.762, 141.39, 5.22, 5.22]]
		}, {
			"name":"V_REG_NCP50X",
			"description":"NCP550x 500mA LDO Voltage Regulator",
			"image":"core\/breadboard\/sparkfun-poweric_dpak-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_dpak-5_breadboard.svg",
			"width":"339.114",
			"height":"600",
			"points": [[52.5921, 533.05, 33.93, 33.9], [152.592, 533.05, 33.93, 33.9], [152.592, 33.05, 33.93, 33.9], [252.592, 533.05, 33.93, 33.9], [252.592, 33.05, 33.93, 33.9]]
		}, {
			"name":"Blue smd LED",
			"description":"A generic blue LED(~1.8V)",
			"image":"core\/breadboard\/LED-5mm-red-leg.svg",
			"icon":"core\/breadboard\/LED-5mm-red-leg.svg",
			"width":"21.467",
			"height":"40.565",
			"points": [[3.793, 34.307, 4.989, 3], [13.793, 34.307, 4.992, 3]]
		}, {
			"name":"LilyPad XBee",
			"description":"The LilyPad XBee is a breakout board for the popular XBee modules.Board includes easy-to-sew tabs and all the necessary power regulation to run on the LilyPad system.LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They 're even washable!LilyPad XBee was co-developed by Kate Hartman and Rob Faludi. It works with all the popular XBee module types but does not ship with a module. Please see the related items below.Note: A portion of this sale is given back to Dr. Leah Buechley for continued development and education of e-textiles and to Rob Faludi and Kate Hartman for product support and continued development.Dimensions:50mm outer diameterThin 0.8mm PCB",
			"image":"core\/breadboard\/LilyPad-XBee-v15_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad-XBee-v15_breadboard.svg",
			"width":"141.732",
			"height":"141.732",
			"points": [[6.928, 58.985, 6.268, 6.268], [24.614, 49.814, 6.104, 6.104], [24.614, 57.014, 6.104, 6.104], [24.614, 64.214, 6.104, 6.104], [24.614, 71.414, 6.104, 6.104], [24.614, 78.614, 6.104, 6.104], [24.614, 85.814, 6.104, 6.104], [128.536, 76.48, 6.268, 6.268], [128.536, 58.985, 6.268, 6.268], [123.695, 42.143, 6.268, 6.268], [114.156, 27.508, 6.268, 6.268], [100.964, 16.043, 6.268, 6.268], [85.027, 8.767, 6.27, 6.27], [50.437, 126.696, 6.268, 6.268], [67.731, 129.159, 6.27, 6.27], [85.027, 126.695, 6.27, 6.27], [101.02, 119.477, 6.27, 6.27], [114.156, 107.957, 6.268, 6.268], [123.609, 93.264, 6.27, 6.27], [21.309, 107.957, 6.268, 6.268], [11.769, 93.293, 6.268, 6.268], [11.769, 42.171, 6.268, 6.268], [21.309, 27.508, 6.268, 6.268], [34.528, 16.043, 6.268, 6.268], [50.38, 8.598, 6.268, 6.268], [67.731, 6.304, 6.27, 6.27], [34.5, 119.421, 6.268, 6.268], [6.814, 76.507, 6.268, 6.268]]
		}, {
			"name":"Audio Jack (TRRS) 3.5mm",
			"description":"Smartphone audio jack with 4 pins (stereo plus microphone), based on the LUMBERG JEITA RC-5325A",
			"image":"core\/breadboard\/audio-jack-4pin.svg",
			"icon":"core\/breadboard\/audio-jack-4pin.svg",
			"width":"46.055",
			"height":"21.602",
			"points": []
		}, {
			"name":"Tantalum Capacitor",
			"description":"1 uF multilayered Ceramic Capacitor",
			"image":"core\/breadboard\/capacitor_tantalum_leg.svg",
			"icon":"core\/breadboard\/capacitor_tantalum_leg.svg",
			"width":"17.5",
			"height":"28.82",
			"points": [[3.292, 26.82, 4.083, 3], [10.365, 26.82, 4.275, 3]]
		}, {
			"name":"CRYSTAL",
			"description":"Various standard crystals. Proven footprints. Spark Fun Electronics SKU : COM-00534",
			"image":"core\/breadboard\/crystal_leg.svg",
			"icon":"core\/breadboard\/crystal_leg.svg",
			"width":"28.871",
			"height":"12.855",
			"points": [[4.824, 8.732, 4.146, 3.05], [19.186, 8.732, 4.146, 3.05]]
		}, {
			"name":"Capacitor",
			"description":"CapacitorStandard 0603 ceramic capacitor, and 0.1 leaded capacitor.",
			"image":"core\/breadboard\/sparkfun-passives_grm43d_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_grm43d_breadboard.svg",
			"width":"416.694",
			"height":"400",
			"points": [[191.382, 333.05, 33.93, 33.9], [191.382, 33.05, 33.93, 33.9]]
		}, {
			"name":"JUMPER-3",
			"description":"",
			"image":"core\/breadboard\/sparkfun-passives_sj_3_paste2_3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_3_paste2_3_breadboard.svg",
			"width":"263",
			"height":"400",
			"points": [[64.535, 333.05, 33.93, 33.9], [164.535, 333.05, 33.93, 33.9], [164.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"PQ1CY1032Z",
			"description":"3.5A Switching Regulator",
			"image":"core\/breadboard\/sparkfun-poweric_q5-dd_spx29300_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_q5-dd_spx29300_breadboard.svg",
			"width":"422",
			"height":"800",
			"points": [[94.035, 733.05, 33.93, 33.9], [94.035, 33.05, 33.93, 33.9], [194.035, 733.05, 33.93, 33.9], [194.035, 33.05, 33.93, 33.9], [294.035, 733.05, 33.93, 33.9], [294.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"SWITCH-SPST-2",
			"description":"",
			"image":"core\/breadboard\/sparkfun-electromechanical_switch-spst-vertical_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_switch-spst-vertical_breadboard.svg",
			"width":"36.01",
			"height":"61.516",
			"points": [[14.393, 31.396, 7.224, 7.224], [14.393, 11.553, 7.224, 7.224]]
		}, {
			"name":"CRYSTAL",
			"description":"Various standard crystals. Proven footprints. Spark Fun Electronics SKU : COM-00534",
			"image":"core\/breadboard\/crystal_leg.svg",
			"icon":"core\/breadboard\/crystal_leg.svg",
			"width":"28.871",
			"height":"12.855",
			"points": [[4.824, 8.732, 4.146, 3.05], [19.186, 8.732, 4.146, 3.05]]
		}, {
			"name":"TQFP32-5MM",
			"description":"",
			"image":"core\/breadboard\/TQFP32-5MM_breadboard.svg",
			"icon":"core\/breadboard\/TQFP32-5MM_breadboard.svg",
			"width":"115.2",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Breadboard Power Supply Board SMD",
			"description":"\tDescription: This is a very simple board that takes a 6-12V input voltage and outputs a selectable 5V or 3.3V regulated voltage. All headers are 0.1' pitch for simple insertion into a breadboard.\tInput power can be supplied to either the DC barrel jack or the two pin header labeled + and-.Output power is supplied to the pins labeled GND and VCC.Board has both an On\/Off switch and a voltage select switch (3.3V\/5V).\tThe two pairs of GND and VCC pins are spaced such that when connected to our Basic Breadboard both power busses will be powered.\tCheck out our Unregulated Power Supply Tutorial!\tDimensions: 2.15x0.65 '\tFeatures: \t\t\t6-12V input voltage via barrel jack or 2-pin header\t\t\t3.3V or 5V regulated output voltage\t\t\tON\/OFF switch \t\t\tOutput voltage select switch \t\t\tPower status LED\t\t\tPTC fuse protected power\t\t\t5.5x2.1mm center positive barrel jack\tDocuments: \t\t\tSchematic\t\t\tEagle Files\tReplaces: PRT-09319",
			"image":"core\/breadboard\/Breadboard Power Supply - SMD v13_breadboard.svg",
			"icon":"core\/breadboard\/Breadboard Power Supply - SMD v13_breadboard.svg",
			"width":"154.8",
			"height":"46.8",
			"points": [[4.148, 0.548, 6.104, 6.104], [11.348, 0.548, 6.104, 6.104], [139.148, 0.548, 6.104, 6.104], [131.948, 0.548, 6.104, 6.104], [90.548, 40.148, 6.104, 6.104], [97.748, 40.148, 6.104, 6.104]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_nippon_f80_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_nippon_f80_breadboard.svg",
			"width":"20.561",
			"height":"40.459",
			"points": [[5.833, 36.531, 2.753, 4.834], [11.927, 36.531, 2.837, 4.834]]
		}
	]
},
{
	"page":"2",
	"count": 37,
	"el": [{
			"name":"Power Jack",
			"description":"Power JackThis is the standard 5.5mm barrel jack for power. The PTH is the most common, proven, reliable, footprint. All others are experimental. The Slot footprint only works if the mill layer is transmitted to the PCB fab house so be warned. Spark Fun Electronics SKU : PRT-00119. Mating wall wart : TOL-00298 (and others)",
			"image":"core\/breadboard\/sparkfun-connectors_power_jack_combo_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_power_jack_combo_breadboard.svg",
			"width":"554.333",
			"height":"1000",
			"points": [[210.202, 933.05, 33.93, 33.9], [310.202, 933.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206. Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_1007_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_1007_breadboard.svg",
			"width":"310.25",
			"height":"400",
			"points": [[138.16, 333.05, 33.93, 33.9], [138.16, 33.05, 33.93, 33.9]]
		}, {
			"name":"LM 358 Dual Op-Amp",
			"description":"The classic LM 358 Dual Operational Amplifier (Op-Amp). The analog swiss-army knife.",
			"image":"core\/breadboard\/lm358_bread.svg",
			"icon":"core\/breadboard\/lm358_bread.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [22.5, -1, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [2.5, -1, 5, 6.3400002]]
		}, {
			"name":"green LED-5mm",
			"description":"A generic green LED (~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-green.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-green.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"BUTTON-MAGNETIC",
			"description":"Magnetic metal snaps. 18mm is DEV-08682.",
			"image":"core\/breadboard\/sparkfun-electromechanical_button-18mm_breadboard-female.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_button-18mm_breadboard-female.svg",
			"width":"26.061",
			"height":"53.018",
			"points": [[6.141, 23.732, 5.554, 5.554]]
		}, {
			"name":"SUP500F",
			"description":"SUP500F Venus GPS",
			"image":"core\/breadboard\/sparkfun-rf_sup500f_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_sup500f_breadboard.svg",
			"width":"1066.12",
			"height":"1200",
			"points": [[366.097, 1133.05, 33.93, 33.9], [466.097, 1133.05, 33.93, 33.9], [466.097, 33.05, 33.93, 33.9], [566.097, 1133.05, 33.93, 33.9], [566.097, 33.05, 33.93, 33.9], [666.098, 1133.05, 33.93, 33.9], [666.098, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic female header-8 pins",
			"description":"Generic female header",
			"image":"obsolete\/breadboard\/generic-female-header_bread_8.svg",
			"icon":"obsolete\/breadboard\/generic-female-header_bread_8.svg",
			"width":"57.432",
			"height":"7.178",
			"points": [[1.202, 1.202, 4.775, 4.775], [8.381, 1.202, 4.775, 4.775], [15.56, 1.202, 4.775, 4.775], [22.739, 1.202, 4.775, 4.775], [29.918, 1.202, 4.775, 4.775], [37.097, 1.202, 4.775, 4.775], [44.276, 1.202, 4.775, 4.775], [51.455, 1.202, 4.775, 4.775]]
		}, {
			"name":"USB+SHIELD",
			"description":"USB+ShieldUSB connector with shield pins connectable",
			"image":"core\/breadboard\/sparkfun-connectors_usb-b-pth_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-b-pth_breadboard.svg",
			"width":"593.375",
			"height":"800",
			"points": [[179.722, 733.05, 33.93, 33.9], [179.722, 33.05, 33.93, 33.9], [279.722, 733.05, 33.93, 33.9], [279.722, 33.05, 33.93, 33.9], [379.722, 733.05, 33.93, 33.9], [379.722, 33.05, 33.93, 33.9]]
		}, {
			"name":"FM Transmitter",
			"description":"FM Transmitter2mW transmitter NS73M. Easy SPI interface. Digital tuning. SKU: WRL-08452",
			"image":"core\/breadboard\/sparkfun-rf_ns73m_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_ns73m_breadboard.svg",
			"width":"800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"1k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_1k.svg",
			"icon":"obsolete\/breadboard\/resistor_1k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"chipKIT WF32",
			"description":"The chipKIT WF32 is based on the popular Arduino\u2122 open-source hardware prototyping platform and adds the performance of the Microchip PIC32 microcontroller. The WF32 is the first board from Digilent to have a WiFi MRF24 and SD card on the board both with dedicated signals. The WF32 board takes advantage of the powerful PIC32MX695F512L microcontroller. This microcontroller features a 32-bit MIPS processor core running at 80Mhz, 512K of flash program memory, and 128K of SRAM data memory. The WF32 can be programmed using the Multi-Platform Integrated Development Environment (MPIDE), an environment based on the original Arduino IDE, modified to support PIC32. It contains everything needed to start developing embedded applications. The WF32 features a USB serial port interface for connection to the MPIDE and can be powered via USB or by an external power supply. In addition, the WF32 is fully compatible with the advanced Microchip MPLAB\u00ae IDE and works with all MPLAB\u00ae compatible in-system programmer\/debuggers, such as the Microchip PICkit\u21223 or the Digilent chipKIT PGM. The WF32 is easy to use and suitable for both beginners and advanced users experimenting with electronics and embedded control systems.",
			"image":"core\/breadboard\/chipkit_WF32_breadboard.svg",
			"icon":"core\/breadboard\/chipkit_WF32_breadboard.svg",
			"width":"252.17",
			"height":"151.257",
			"points": [[234.234, 11.658, 5.6, 5.6], [212.633, 11.658, 5.6, 5.6], [227.035, 11.658, 5.6, 5.6], [219.834, 11.658, 5.6, 5.6], [191.934, 11.658, 5.6, 5.6], [205.434, 11.658, 5.6, 5.6], [184.967, 11.658, 5.6, 5.6], [199.133, 11.658, 5.6, 5.6], [234.234, 4.457, 5.6, 5.6], [212.633, 4.457, 5.6, 5.6], [227.035, 4.457, 5.6, 5.6], [219.834, 4.457, 5.6, 5.6], [191.934, 4.457, 5.6, 5.6], [205.434, 4.457, 5.6, 5.6], [184.967, 4.457, 5.6, 5.6], [199.133, 4.457, 5.6, 5.6], [172.313, 11.658, 5.6, 5.6], [150.712, 11.658, 5.6, 5.6], [165.114, 11.658, 5.6, 5.6], [157.913, 11.658, 5.6, 5.6], [130.013, 11.658, 5.6, 5.6], [143.513, 11.658, 5.599, 5.6], [123.046, 11.658, 5.6, 5.6], [137.213, 11.658, 5.6, 5.6], [172.313, 4.457, 5.6, 5.6], [150.712, 4.457, 5.6, 5.6], [165.114, 4.457, 5.6, 5.6], [157.913, 4.457, 5.6, 5.6], [130.013, 4.457, 5.6, 5.6], [143.513, 4.457, 5.599, 5.6], [123.046, 4.457, 5.6, 5.6], [137.213, 4.457, 5.6, 5.6], [234.8, 134.057, 5.6, 5.6], [227.601, 134.057, 5.6, 5.6], [220.399, 134.057, 5.6, 5.6], [213.2, 134.057, 5.6, 5.6], [205.999, 134.057, 5.602, 5.6], [198.8, 134.057, 5.6, 5.6], [234.8, 141.256, 5.6, 5.6], [227.601, 141.256, 5.6, 5.6], [220.399, 141.256, 5.6, 5.6], [213.2, 141.256, 5.6, 5.6], [205.999, 141.256, 5.602, 5.6], [198.8, 141.256, 5.6, 5.6], [183.834, 141.256, 5.6, 5.6], [162.232, 141.256, 5.6, 5.6], [176.635, 141.256, 5.6, 5.6], [169.434, 141.256, 5.6, 5.6], [141.533, 141.256, 5.6, 5.6], [155.033, 141.256, 5.6, 5.6], [134.566, 141.256, 5.6, 5.6], [148.732, 141.256, 5.6, 5.6], [115.164, 4.458, 5.6, 5.6], [108.197, 4.458, 5.6, 5.6]]
		}, {
			"name":"XS1_L1_64LQFP",
			"description":"XMos processor (multicore)",
			"image":"core\/breadboard\/sparkfun-digitalic_sqfp-s-10x10-64-xs1_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sqfp-s-10x10-64-xs1_breadboard.svg",
			"width":"3300",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 533.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"1k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_1k.svg",
			"icon":"obsolete\/breadboard\/resistor_1k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"4.7k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_4.7k.svg",
			"icon":"obsolete\/breadboard\/resistor_4.7k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"4.7k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_4.7k.svg",
			"icon":"obsolete\/breadboard\/resistor_4.7k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Basic FET N-Channel",
			"description":"A MOSFET N-Channel Transistor",
			"image":"core\/breadboard\/mosfet_n_channel.svg",
			"icon":"core\/breadboard\/mosfet_n_channel.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"AT45DB041B",
			"description":"4-Mbit SPI flash memory",
			"image":"core\/breadboard\/sparkfun-digitalic_so08wide_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_so08wide_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Header 4",
			"description":"Header 4Standard 4-pin 0.1 header. Use with straight break away headers (SKU : PRT-00116), right angle break away headers (PRT-00553), swiss pins (PRT-00743), machine pins (PRT-00117), and female headers (PRT-00115). Molex polarized connector foot print use with SKU : PRT-08231 with associated crimp pins and housings. 1MM SMD Version SKU: PRT-10208",
			"image":"core\/breadboard\/sparkfun-connectors_molex-1x4_lock_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_molex-1x4_lock_breadboard.svg",
			"width":"10.287",
			"height":"5.715",
			"points": [[-0.3904, 1.2606, 3.4478, 3.4478], [2.1496, 1.5146, 3.4478, 3.4478], [4.6896, 1.2606, 3.4478, 3.4478], [7.2296, 1.5146, 3.4478, 3.4478]]
		}, {
			"name":"BNC",
			"description":"BNC Connector, Mouser Part# 5227161",
			"image":"core\/breadboard\/sparkfun-connectors_bnc_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_bnc_breadboard.svg",
			"width":"28.801",
			"height":"61.021",
			"points": [[15.506, 5.93, 4.988, 4.988], [8.307, 5.93, 4.988, 4.988]]
		}, {
			"name":"XBEE-1",
			"description":"Xbee module footprints",
			"image":"core\/breadboard\/xbee.svg",
			"icon":"core\/breadboard\/xbee.svg",
			"width":"68.602",
			"height":"91.387",
			"points": [[64.52, 21.834, 4.367, 4.367], [64.52, 29.033, 4.367, 4.368], [64.52, 36.234, 4.367, 4.368], [64.52, 43.435, 4.367, 4.368], [64.52, 50.635, 4.367, 4.369], [64.52, 57.836, 4.367, 4.367], [64.52, 65.037, 4.367, 4.367], [64.52, 72.236, 4.367, 4.367], [64.52, 79.438, 4.367, 4.367], [64.52, 86.635, 4.367, 4.369], [-0.282, 86.639, 4.368, 4.367], [-0.282, 79.439, 4.368, 4.367], [-0.282, 72.238, 4.368, 4.367], [-0.282, 65.037, 4.368, 4.367], [-0.282, 57.838, 4.368, 4.367], [-0.282, 50.637, 4.368, 4.369], [-0.282, 43.435, 4.368, 4.368], [-0.282, 36.235, 4.368, 4.368], [-0.282, 29.034, 4.368, 4.368], [-0.282, 21.833, 4.368, 4.368]]
		}, {
			"name":"IMU3000",
			"description":"3-axis I2C programmable gyro.Can interface with an I2C accelerometer to provide 6-axis motion information.",
			"image":"core\/breadboard\/QFN-24_breadboard.svg",
			"icon":"core\/breadboard\/QFN-24_breadboard.svg",
			"width":"86.4",
			"height":"28.8",
			"points": [[1.45052, 23.0516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 23.0516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 23.0516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 23.0516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 23.0516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 23.0516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 23.0516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 23.0516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 23.0516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 23.0516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 23.0516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 23.0516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"XBEE-1",
			"description":"Xbee module footprints",
			"image":"core\/breadboard\/sparkfun-rf_xbee-silk_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_xbee-silk_breadboard.svg",
			"width":"68.604",
			"height":"74.269",
			"points": [[0.655, 69.239, 5.294, 5.294], [0.655, 63.57, 5.294, 5.294], [0.655, 57.9, 5.294, 5.294], [0.655, 52.231, 5.294, 5.294], [0.655, 46.562, 5.294, 5.294], [0.655, 40.892, 5.294, 5.294], [0.655, 35.223, 5.294, 5.294], [0.655, 29.554, 5.294, 5.294], [0.655, 23.884, 5.294, 5.294], [0.655, 18.216, 5.294, 5.294], [63.017, 69.239, 5.294, 5.294], [63.017, 63.57, 5.294, 5.294], [63.017, 57.9, 5.294, 5.294], [63.017, 52.231, 5.294, 5.294], [63.017, 46.562, 5.294, 5.294], [63.017, 40.892, 5.294, 5.294], [63.017, 35.223, 5.294, 5.294], [63.017, 29.554, 5.294, 5.294], [63.017, 23.884, 5.294, 5.294], [63.017, 18.216, 5.294, 5.294]]
		}, {
			"name":"Wiring Mini",
			"description":"Wiring Mini Microcontroller",
			"image":"core\/breadboard\/controller_wiring_mini.svg",
			"icon":"core\/breadboard\/controller_wiring_mini.svg",
			"width":"218.605",
			"height":"74.188",
			"points": [[57.739, 67.854, 3.184, 3.187], [50.53, 67.854, 3.186, 3.187], [43.321, 67.854, 3.186, 3.187], [36.114, 67.854, 3.184, 3.187], [28.903, 67.854, 3.187, 3.187], [21.694, 67.854, 3.187, 3.187], [14.486, 67.854, 3.185, 3.187], [7.277, 67.854, 3.184, 3.187], [7.278, 3.325, 3.184, 3.184], [14.486, 3.325, 3.185, 3.184], [21.694, 3.325, 3.187, 3.184], [28.903, 3.325, 3.185, 3.184], [36.112, 3.325, 3.186, 3.184], [43.321, 3.325, 3.186, 3.184], [50.53, 3.325, 3.186, 3.184], [57.739, 3.325, 3.185, 3.184], [64.446, 3.326, 3.185, 3.185], [71.653, 3.326, 3.187, 3.185], [78.862, 3.326, 3.187, 3.185], [86.071, 3.326, 3.185, 3.185], [93.28, 3.326, 3.186, 3.185], [100.489, 3.326, 3.185, 3.185], [107.698, 3.326, 3.185, 3.185], [114.907, 3.326, 3.185, 3.185], [172.157, 3.324, 3.184, 3.185], [164.947, 3.324, 3.186, 3.185], [157.738, 3.324, 3.186, 3.185], [150.532, 3.324, 3.184, 3.185], [143.32, 3.324, 3.188, 3.185], [136.111, 3.324, 3.188, 3.185], [128.902, 3.324, 3.188, 3.185], [121.693, 3.324, 3.187, 3.185], [207.889, 3.324, 3.186, 3.184], [200.68, 3.324, 3.186, 3.184], [193.471, 3.324, 3.186, 3.184], [186.262, 3.324, 3.184, 3.184], [207.889, 67.854, 3.186, 3.186], [200.68, 67.854, 3.186, 3.186], [193.471, 67.854, 3.186, 3.186], [186.262, 67.854, 3.184, 3.186], [172.157, 67.854, 3.185, 3.187], [164.947, 67.854, 3.186, 3.187], [157.738, 67.854, 3.186, 3.187], [150.532, 67.854, 3.185, 3.187], [143.32, 67.854, 3.188, 3.187], [136.111, 67.854, 3.188, 3.187], [128.902, 67.854, 3.188, 3.187], [121.693, 67.854, 3.187, 3.187], [114.904, 67.854, 3.187, 3.187], [107.698, 67.854, 3.185, 3.187], [100.489, 67.854, 3.185, 3.187], [93.282, 67.854, 3.184, 3.187], [86.071, 67.854, 3.187, 3.187], [78.862, 67.854, 3.187, 3.187], [71.653, 67.854, 3.187, 3.187], [64.444, 67.854, 3.186, 3.187]]
		}, {
			"name":"XBEE-1",
			"description":"Xbee module footprints",
			"image":"core\/breadboard\/sparkfun-rf_xbee-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_xbee-smd_breadboard.svg",
			"width":"1152.83",
			"height":"1400",
			"points": [[109.452, 1333.05, 33.93, 33.9], [109.452, 33.05, 33.93, 33.9], [209.452, 1333.05, 33.93, 33.9], [209.452, 33.05, 33.93, 33.9], [309.452, 1333.05, 33.93, 33.9], [309.452, 33.05, 33.93, 33.9], [409.452, 1333.05, 33.93, 33.9], [409.452, 33.05, 33.93, 33.9], [509.452, 1333.05, 33.93, 33.9], [509.452, 33.05, 33.93, 33.9], [609.452, 1333.05, 33.93, 33.9], [609.452, 33.05, 33.93, 33.9], [709.452, 1333.05, 33.93, 33.9], [709.452, 33.05, 33.93, 33.9], [809.452, 1333.05, 33.93, 33.9], [809.452, 33.05, 33.93, 33.9], [909.452, 1333.05, 33.93, 33.9], [909.452, 33.05, 33.93, 33.9], [1009.45, 1333.05, 33.93, 33.9], [1009.45, 33.05, 33.93, 33.9]]
		}, {
			"name":"ORP Circuit",
			"description":"Atlas Scientific specializes in merging the biological sciences with modern day embedded computer science. Atlas Scientific engineers understand the complexities of biology, modern embedded computer systems and the strict level of accuracy needed to take true scientific grade readings. Oxidation Reduction Potential (ORP) is a part of electrochemistry that is complex and commonly misunderstood. This made finding an ORP Circuit virtually impossible. The Atlas Scientific ORP Circuit (our fourth generation ORP Circuit) has put an end to this problem. Now, the engineer can easily incorporate a modern ORP Circuit into a design without having to learn complex chemistry and analog signal processing. With a wide operating voltage (2.5V to 5.5V) and a simple asynchronous serial communication protocol, this easy to use ORP Circuit is specifically designed for modern embedded computer systems.The Atlas Scientific ORP Circuit is designed for both continuous and intermittent readings. After calibration, the ORP Sensor can be immersed in a liquid and operate continuously for 12 months before recalibration is recommended.\u2022 Full range ORP reading from 0 to +1024 and \u20131024 mV\u2022 Accuracy within two significant figures (XX.XX)\u2022 Calibration not required\u2022 Single reading or continuous reading modes\u2022 Simple calibration protocol\u2022 Simple asynchronous serial connectivity (voltage swing 0-VCC)\u2022 Simple instruction set consisting of only nine commands\u2022 Micro footprint circuitry\u2022 Debugging LED's\u2022 2.5V to 5.5V operational voltage\u2022 Low power consumption\u2022 Dimensions: 14mm X 20.16mm (0.55' X0.79')",
			"image":"core\/breadboard\/atlas-sientific_ORP Circuit_breadboard.svg",
			"icon":"core\/breadboard\/atlas-sientific_ORP Circuit_breadboard.svg",
			"width":"39.465",
			"height":"58.038",
			"points": [[23.811, 0.132, 6.022, 6.022], [16.777, 0.133, 6.02, 6.02], [9.707, 51.67, 6.02, 6.02], [16.722, 51.67, 6.02, 6.02], [9.647, 0.133, 6.207, 6.03], [23.707, 51.658, 6.208, 6.03]]
		}, {
			"name":"27k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_27k.svg",
			"icon":"obsolete\/breadboard\/resistor_27k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"27k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_27k.svg",
			"icon":"obsolete\/breadboard\/resistor_27k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"LilyPad Arduino USB",
			"description":"The LilyPad Arduino USB is a microcontroller board based on the ATmega32u4 (datasheet). It has 9 digital input\/output pins (of which 4 can be used as PWM outputs and 4 as analog inputs), an 8 MHz resonator, a micro USB connection, a JST connector for a 3.7V LiPo battery, and a reset button. It contains everything needed to support the microcontroller; simply connect it to a computer with a USB cable or power it with a battery to get started.The LilyPad Arduino USB differs from previous LilyPad boards in that the ATmega32u4 has built-in USB communication, eliminating the need for a separate USB-to-serial adapter. This allows the LilyPad Arduino USB to appear to a connected computer as a mouse and keyboard, in addition to a virtual (CDC) serial \/ COM port. It also has other implications for the behavior of the board; these are detailed on the getting started page.",
			"image":"core\/breadboard\/LilyPad_Arduino_USB_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad_Arduino_USB_breadboard.svg",
			"width":"144",
			"height":"146.703",
			"points": [[66.14, 131.121, 11.72, 11.72], [35.001, 122.628, 11.72, 11.72], [35.001, 15.058, 11.72, 11.72], [12.355, 37.705, 11.72, 11.72], [3.863, 68.843, 11.72, 11.72], [12.355, 99.982, 11.72, 11.72], [97.279, 122.628, 11.72, 11.72], [119.925, 99.982, 11.72, 11.72], [128.417, 68.843, 11.72, 11.72], [119.925, 37.705, 11.72, 11.72], [97.279, 15.058, 11.72, 11.72]]
		}, {
			"name":"SSOP48",
			"description":"",
			"image":"core\/breadboard\/SSOP48_breadboard.svg",
			"icon":"core\/breadboard\/SSOP48_breadboard.svg",
			"width":"172.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968], [116.651, 37.4516, 4.29896, 4.2968], [116.651, 1.4516, 4.29896, 4.2968], [123.851, 37.4516, 4.29896, 4.2968], [123.851, 1.4516, 4.29896, 4.2968], [131.051, 37.4516, 4.29896, 4.2968], [131.051, 1.4516, 4.29896, 4.2968], [138.251, 37.4516, 4.29896, 4.2968], [138.251, 1.4516, 4.29896, 4.2968], [145.451, 37.4516, 4.29896, 4.2968], [145.451, 1.4516, 4.29896, 4.2968], [152.65, 37.4516, 4.29896, 4.2968], [152.65, 1.4516, 4.29896, 4.2968], [159.85, 37.4516, 4.29896, 4.2968], [159.85, 1.4516, 4.29896, 4.2968], [167.05, 37.4516, 4.29896, 4.2968], [167.05, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"DS1077",
			"description":"I2C non-volatile programmable oscillator, 16kHz to 133MHz",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"HMC5843",
			"description":"Honeywell 3-axis digital compass IC, SEN-09371",
			"image":"core\/breadboard\/sparkfun-sensors_lpcc20_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lpcc20_breadboard.svg",
			"width":"1000",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"BUTTON-CONDUCTIVE",
			"description":"Used with rubber key pads. This one was designed and proven to work with the PolyCase Key FOB enclosures.",
			"image":"core\/breadboard\/sparkfun-electromechanical_button-conductive-0.1_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_button-conductive-0.1_breadboard.svg",
			"width":"307.986",
			"height":"400",
			"points": [[137.028, 333.05, 33.93, 33.9], [137.028, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic female header-3 pins",
			"description":"Generic female header",
			"image":"obsolete\/breadboard\/generic-female-header_bread_3.svg",
			"icon":"obsolete\/breadboard\/generic-female-header_bread_3.svg",
			"width":"21.537",
			"height":"7.178",
			"points": [[1.202, 1.202, 4.775, 4.775], [8.381, 1.202, 4.775, 4.775], [15.56, 1.202, 4.775, 4.775]]
		}, {
			"name":"RJ9",
			"description":"RJ9 connector (e.g., phone handsets)",
			"image":"core\/breadboard\/sparkfun-connectors_rj9_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_rj9_breadboard.svg",
			"width":"627.139",
			"height":"1000",
			"points": [[246.605, 933.05, 33.93, 33.9], [246.605, 33.05, 33.93, 33.9], [346.605, 933.05, 33.93, 33.9], [346.605, 33.05, 33.93, 33.9]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors. Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties. Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer. The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_eia7343_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_eia7343_breadboard.svg",
			"width":"601.694",
			"height":"600",
			"points": [[283.882, 533.05, 33.93, 33.9], [283.882, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic male header",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic_male_header.svg",
			"icon":"obsolete\/breadboard\/generic_male_header.svg",
			"width":"7.199",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791]]
		}, {
			"name":"Memoire 1.0-SD card log shield",
			"description":"\tSD log shield with RTC and a square pads prototyping area for Arduino SD Card supportAllows backup of a large amount of data on SD card and PC retrievalSupport SdFat library for SD FAT16\/FAT32 SC\/HC cards3V3 regulator on the shield Real Time ClockAdding date and time data based on the component I2C DS1307Support the standard library DS1307Date accessed using the format year \/ month \/ day of week \/ hour \/ minute \/ secondsTime adjustable 12h with info AM \/ PM or 24HBackup Time on lithium battery (lasting 10 years if 48mAh)Corrections leap years, months with less than 31 daysSQW output signal (square wave) Programmable 1Hz (for pulse every second, or 4kHz or 8kHz or 32kHz)Clock not subject to bug date before 100 years And more ...Square pads prototyping area to add sensors, actuators, RF, ...5V and GND lines available on the sides of the prototyping areaArduino reset button on topLED display available on pin D9Simple modification provided for adapting the shield to an Arduino Mega Compatible with Arduino Uno, Uno CMS and DuemilanoveCompatible with Arduino Mega with a simple modification Documentation and installation guide : on going The official support forum: forum.snootlab.com \t\t\t\t\t\t\t\t\t\tAssembly guide Mémoire FR.pdfAssembly guide of Mémoire shield FR\t\t\t\t\tTopside Mémoire.pdfTopside Mémoire\t\t\t\t\tSchema Mémoire.pdfSchema Mémoire\t\t\t\t\tEagle Mémoire.zipEagle files of Mémoire\t\t\t\t\tManual Mémoire EN.pdfAssembly guide of Mémoire shield EN\t\t\t\t",
			"image":"core\/breadboard\/Memoire-1.0_breadboard.svg",
			"icon":"core\/breadboard\/Memoire-1.0_breadboard.svg",
			"width":"197.15",
			"height":"151.2",
			"points": [[117.958, 4.328, 5.744, 5.744], [110.758, 4.328, 5.744, 5.744], [103.558, 4.328, 5.744, 5.744], [96.3577, 4.328, 5.744, 5.744], [89.1577, 4.328, 5.744, 5.744], [81.9577, 4.328, 5.744, 5.744], [74.7577, 4.328, 5.744, 5.744], [67.5576, 4.328, 5.744, 5.744], [179.878, 4.328, 5.744, 5.744], [172.678, 4.328, 5.744, 5.744], [165.478, 4.328, 5.744, 5.744], [158.278, 4.328, 5.744, 5.744], [151.078, 4.328, 5.744, 5.744], [143.878, 4.328, 5.744, 5.744], [136.678, 4.328, 5.744, 5.744], [129.478, 4.328, 5.744, 5.744], [143.878, 141.128, 5.744, 5.744], [151.078, 141.128, 5.744, 5.744], [158.278, 141.128, 5.744, 5.744], [165.478, 141.128, 5.744, 5.744], [172.678, 141.128, 5.744, 5.744], [179.878, 141.128, 5.744, 5.744], [179.698, 18.548, 6.104, 6.104], [172.498, 18.548, 6.104, 6.104], [165.298, 18.548, 6.104, 6.104], [158.098, 18.548, 6.104, 6.104], [150.898, 18.548, 6.104, 6.104], [143.698, 18.548, 6.104, 6.104], [136.498, 18.548, 6.104, 6.104], [129.298, 18.548, 6.104, 6.104], [143.698, 126.548, 6.104, 6.104], [150.898, 126.548, 6.104, 6.104], [158.098, 126.548, 6.104, 6.104], [165.298, 126.548, 6.104, 6.104], [172.498, 126.548, 6.104, 6.104], [179.698, 126.548, 6.104, 6.104], [122.098, 18.548, 6.104, 6.104], [88.5997, 21.05, 6.5, 6.5], [95.7997, 21.05, 6.5, 6.5], [81.3997, 21.05, 6.5, 6.5], [103, 21.05, 6.5, 6.5], [93.4777, 141.128, 5.744, 5.744], [100.678, 141.128, 5.744, 5.744], [107.878, 141.128, 5.744, 5.744], [115.078, 141.128, 5.744, 5.744], [122.278, 141.128, 5.744, 5.744], [129.478, 141.128, 5.744, 5.744], [122.07334, 25.72334, 6.15332, 6.15332], [129.27334, 25.72334, 6.15332, 6.15332], [136.47334, 25.72334, 6.15332, 6.15332], [136.47334, 25.72334, 6.15332, 6.15332], [143.67334, 25.72334, 6.15332, 6.15332], [150.87334, 25.72334, 6.15332, 6.15332], [150.87334, 25.72334, 6.15332, 6.15332], [158.07334, 25.72334, 6.15332, 6.15332], [165.27334, 25.72334, 6.15332, 6.15332], [165.27334, 25.72334, 6.15332, 6.15332], [172.47334, 25.72334, 6.15332, 6.15332], [179.67334, 25.72334, 6.15332, 6.15332], [136.47334, 119.32334, 6.15332, 6.15332], [143.67334, 119.32334, 6.15332, 6.15332], [150.87334, 119.32334, 6.15332, 6.15332], [150.87334, 119.32334, 6.15332, 6.15332], [158.07334, 119.32334, 6.15332, 6.15332], [165.27334, 119.32334, 6.15332, 6.15332], [165.27334, 119.32334, 6.15332, 6.15332], [172.47334, 119.32334, 6.15332, 6.15332], [179.67334, 119.32334, 6.15332, 6.15332], [48.85574, 64.10614, 4.98772, 4.98772], [41.65574, 69.50614, 4.98772, 4.98772], [59.65574, 64.10614, 4.98772, 4.98772], [59.65574, 44.30614, 4.98772, 4.98772], [143.67334, 83.32334, 6.15332, 6.15332], [143.67334, 68.92334, 6.15332, 6.15332], [122.07334, 32.92334, 6.15332, 6.15332], [122.07334, 54.52334, 6.15332, 6.15332], [143.67334, 54.52334, 6.15332, 6.15332], [143.67334, 40.12334, 6.15332, 6.15332], [186.87334, 104.92334, 6.15332, 6.15332], [186.87334, 83.32334, 6.15332, 6.15332], [186.87334, 68.92334, 6.15332, 6.15332], [186.87334, 54.52334, 6.15332, 6.15332], [186.87334, 47.32334, 6.15332, 6.15332], [150.87334, 32.92334, 6.15332, 6.15332], [136.47334, 97.72334, 6.15332, 6.15332], [136.47334, 112.12334, 6.15332, 6.15332], [136.47334, 83.32334, 6.15332, 6.15332], [136.47334, 68.92334, 6.15332, 6.15332], [136.47334, 54.52334, 6.15332, 6.15332], [136.47334, 40.12334, 6.15332, 6.15332], [136.47334, 32.92334, 6.15332, 6.15332], [143.67334, 97.72334, 6.15332, 6.15332], [158.07334, 90.52334, 6.15332, 6.15332], [158.07334, 76.12334, 6.15332, 6.15332], [158.07334, 61.72334, 6.15332, 6.15332], [158.07334, 47.32334, 6.15332, 6.15332], [186.87334, 97.72334, 6.15332, 6.15332], [186.87334, 90.52334, 6.15332, 6.15332], [186.87334, 76.12334, 6.15332, 6.15332], [186.87334, 61.72334, 6.15332, 6.15332], [179.67334, 32.92334, 6.15332, 6.15332], [136.47334, 90.52334, 6.15332, 6.15332], [136.47334, 76.12334, 6.15332, 6.15332], [136.47334, 61.72334, 6.15332, 6.15332], [136.47334, 47.32334, 6.15332, 6.15332], [150.87334, 104.92334, 6.15332, 6.15332], [179.67334, 97.72334, 6.15332, 6.15332], [179.67334, 83.32334, 6.15332, 6.15332], [179.67334, 90.52334, 6.15332, 6.15332], [179.67334, 68.92334, 6.15332, 6.15332], [179.67334, 76.12334, 6.15332, 6.15332], [179.67334, 54.52334, 6.15332, 6.15332], [179.67334, 61.72334, 6.15332, 6.15332], [179.67334, 40.12334, 6.15332, 6.15332], [179.67334, 47.32334, 6.15332, 6.15332], [186.87334, 112.12334, 6.15332, 6.15332], [172.47334, 32.92334, 6.15332, 6.15332], [143.67334, 112.12334, 6.15332, 6.15332], [172.47334, 97.72334, 6.15332, 6.15332], [172.47334, 83.32334, 6.15332, 6.15332], [172.47334, 90.52334, 6.15332, 6.15332], [172.47334, 68.92334, 6.15332, 6.15332], [172.47334, 76.12334, 6.15332, 6.15332], [172.47334, 54.52334, 6.15332, 6.15332], [172.47334, 61.72334, 6.15332, 6.15332], [172.47334, 40.12334, 6.15332, 6.15332], [172.47334, 47.32334, 6.15332, 6.15332], [165.27334, 32.92334, 6.15332, 6.15332], [150.87334, 112.12334, 6.15332, 6.15332], [165.27334, 97.72334, 6.15332, 6.15332], [165.27334, 83.32334, 6.15332, 6.15332], [165.27334, 90.52334, 6.15332, 6.15332], [165.27334, 68.92334, 6.15332, 6.15332], [165.27334, 76.12334, 6.15332, 6.15332], [165.27334, 54.52334, 6.15332, 6.15332], [165.27334, 61.72334, 6.15332, 6.15332], [165.27334, 40.12334, 6.15332, 6.15332], [165.27334, 47.32334, 6.15332, 6.15332], [158.07334, 32.92334, 6.15332, 6.15332], [158.07334, 104.92334, 6.15332, 6.15332], [158.07334, 97.72334, 6.15332, 6.15332], [158.07334, 83.32334, 6.15332, 6.15332], [150.87334, 90.52334, 6.15332, 6.15332], [158.07334, 68.92334, 6.15332, 6.15332], [150.87334, 76.12334, 6.15332, 6.15332], [158.07334, 54.52334, 6.15332, 6.15332], [150.87334, 61.72334, 6.15332, 6.15332], [158.07334, 40.12334, 6.15332, 6.15332], [150.87334, 47.32334, 6.15332, 6.15332], [143.67334, 32.92334, 6.15332, 6.15332], [165.27334, 104.92334, 6.15332, 6.15332], [150.87334, 97.72334, 6.15332, 6.15332], [150.87334, 83.32334, 6.15332, 6.15332], [150.87334, 68.92334, 6.15332, 6.15332], [150.87334, 54.52334, 6.15332, 6.15332], [150.87334, 40.12334, 6.15332, 6.15332], [158.07334, 112.12334, 6.15332, 6.15332], [143.67334, 104.92334, 6.15332, 6.15332], [143.67334, 90.52334, 6.15332, 6.15332], [143.67334, 76.12334, 6.15332, 6.15332], [143.67334, 61.72334, 6.15332, 6.15332], [143.67334, 47.32334, 6.15332, 6.15332], [165.27334, 112.12334, 6.15332, 6.15332], [172.47334, 104.92334, 6.15332, 6.15332], [179.67334, 104.92334, 6.15332, 6.15332], [172.47334, 112.12334, 6.15332, 6.15332], [179.67334, 112.12334, 6.15332, 6.15332], [122.07334, 61.72334, 6.15332, 6.15332], [122.07334, 40.12334, 6.15332, 6.15332], [122.07334, 47.32334, 6.15332, 6.15332], [129.27334, 32.92334, 6.15332, 6.15332], [129.27334, 54.52334, 6.15332, 6.15332], [136.47334, 104.92334, 6.15332, 6.15332], [129.27334, 61.72334, 6.15332, 6.15332], [129.27334, 40.12334, 6.15332, 6.15332], [129.27334, 47.32334, 6.15332, 6.15332], [114.87334, 32.92334, 6.15332, 6.15332], [114.87334, 40.12334, 6.15332, 6.15332], [114.87334, 47.32334, 6.15332, 6.15332], [114.87334, 54.52334, 6.15332, 6.15332]]
		}, {
			"name":"DB25F",
			"description":"",
			"image":"core\/breadboard\/DB25F.svg",
			"icon":"core\/breadboard\/DB25F.svg",
			"width":"120306.35",
			"height":"272446.94",
			"points": [[113297.43, 15332.008, 4581.9985, 4300.0034], [113297.43, 35332.012, 4581.9985, 4300.0034], [113297.43, 55332.012, 4581.9985, 4300.0034], [113297.43, 75332.023, 4581.9985, 4300.0034], [113297.43, 95332.016, 4581.9985, 4300.0034], [113297.43, 115332.02, 4581.9985, 4300.0034], [113297.43, 135332.03, 4581.9985, 4300.0034], [113297.43, 155332.03, 4581.9985, 4300.0034], [113297.43, 175332.03, 4581.9985, 4300.0034], [113297.43, 195332.03, 4581.9985, 4300.0034], [113297.43, 215332.03, 4581.9985, 4300.0034], [113297.43, 235332.03, 4581.9985, 4300.0034], [113297.43, 255332.03, 4581.9985, 4300.0034], [103297.42, 25332.008, 4581.9985, 4300.0034], [103297.42, 45332.012, 4581.9985, 4300.0034], [103297.42, 65332.016, 4581.9985, 4300.0034], [103297.42, 85332.023, 4581.9985, 4300.0034], [103297.42, 105332.02, 4581.9985, 4300.0034], [103297.42, 125332.02, 4581.9985, 4300.0034], [103297.42, 145332.03, 4581.9985, 4300.0034], [103297.42, 165332.03, 4581.9985, 4300.0034], [103297.42, 185332.03, 4581.9985, 4300.0034], [103297.42, 205332.03, 4581.9985, 4300.0034], [103297.42, 225332.03, 4581.9985, 4300.0034], [103297.42, 245332.03, 4581.9985, 4300.0034]]
		}, {
			"name":"33 \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_33.svg",
			"icon":"obsolete\/breadboard\/resistor_33.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"33 \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_33.svg",
			"icon":"obsolete\/breadboard\/resistor_33.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"2.5mm Audio Jack",
			"description":"Simple 2.5mm common PCB mount audio jack. SKU: PRT-08032",
			"image":"core\/breadboard\/sparkfun-connectors_stereojack2.5mm_stereojack2.5mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_stereojack2.5mm_stereojack2.5mm_breadboard.svg",
			"width":"604.903",
			"height":"600",
			"points": [[235.487, 533.05, 33.93, 33.9], [235.487, 33.05, 33.93, 33.9], [335.486, 533.05, 33.93, 33.9], [335.486, 33.05, 33.93, 33.9]]
		}, {
			"name":"SN74LVC2G14DBVR",
			"description":"This dual Schmitt-trigger inverter is designed for 1.65-V to 5.5-V VCC operation.The SN74LVC2G14 contains two inverters and performs the Boolean function Y = A. The device functions as two independent inverters, but because of Schmitt action, it may have different input threshold levels for positive-going (VT+) and negative-going (VT\u2013) signals. This device is fully specified for partial-power-down applications using Ioff. The Ioff circuitry disables the outputs, preventing damaging current backflow through the device when it is powered down.",
			"image":"core\/breadboard\/SN74LVC2G14DBVR_7.svg",
			"icon":"core\/breadboard\/SN74LVC2G14DBVR_7.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"green smd LED",
			"description":"A generic green LED (~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-green.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-green.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"TRIAC",
			"description":"Low-power generic TRIAC packages",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot223_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot223_breadboard.svg",
			"width":"333",
			"height":"600",
			"points": [[99.535, 533.05, 33.93, 33.9], [99.535, 33.05, 33.93, 33.9], [199.535, 533.05, 33.93, 33.9], [199.535, 33.05, 33.93, 33.9]]
		}
	]
},
{
	"page":"3",
	"count": 37,
	"el": [{
			"name":"BASIC Stamp 2e",
			"description":"The BASIC Stamp 2e serves as the brains inside of electronics projects and applications that require a programmable microcontroller. It is able to control and monitor timers, keypads, motors, sensors, switches, relays, lights, and more. Programming is performed in an easy-to-learn language called PBASIC.",
			"image":"core\/breadboard\/BASIC_Stamp_2e.svg",
			"icon":"core\/breadboard\/BASIC_Stamp_2e.svg",
			"width":"45.358",
			"height":"86.4",
			"points": [[41.233, 1.85, 5.125, 4.16], [41.233, 1.85, 5.125, 4.16], [41.233, 81.05, 5.125, 4.16], [41.233, 81.05, 5.125, 4.16], [41.233, 9.05, 5.125, 4.16], [41.233, 9.05, 5.125, 4.16], [41.233, 16.25, 5.125, 4.16], [41.233, 16.25, 5.125, 4.16], [41.233, 23.45, 5.125, 4.16], [41.233, 23.45, 5.125, 4.16], [41.233, 30.65, 5.125, 4.16], [41.233, 30.65, 5.125, 4.16], [41.233, 37.851, 5.125, 4.16], [41.233, 37.851, 5.125, 4.16], [41.233, 45.05, 5.125, 4.16], [41.233, 45.05, 5.125, 4.16], [41.233, 52.251, 5.125, 4.16], [41.233, 52.251, 5.125, 4.16], [41.233, 59.45, 5.125, 4.16], [41.233, 59.45, 5.125, 4.16], [41.233, 66.649, 5.125, 4.16], [41.233, 66.649, 5.125, 4.16], [41.233, 73.851, 5.125, 4.16]]
		}, {
			"name":"DB25M",
			"description":"",
			"image":"core\/breadboard\/DB25M.svg",
			"icon":"core\/breadboard\/DB25M.svg",
			"width":"120306.35",
			"height":"272446.94",
			"points": [[113297.43, 15332.008, 4581.9985, 4300.0034], [113297.43, 35332.012, 4581.9985, 4300.0034], [113297.43, 55332.012, 4581.9985, 4300.0034], [113297.43, 75332.023, 4581.9985, 4300.0034], [113297.43, 95332.016, 4581.9985, 4300.0034], [113297.43, 115332.02, 4581.9985, 4300.0034], [113297.43, 135332.03, 4581.9985, 4300.0034], [113297.43, 155332.03, 4581.9985, 4300.0034], [113297.43, 175332.03, 4581.9985, 4300.0034], [113297.43, 195332.03, 4581.9985, 4300.0034], [113297.43, 215332.03, 4581.9985, 4300.0034], [113297.43, 235332.03, 4581.9985, 4300.0034], [113297.43, 255332.03, 4581.9985, 4300.0034], [103297.42, 25332.008, 4581.9985, 4300.0034], [103297.42, 45332.012, 4581.9985, 4300.0034], [103297.42, 65332.016, 4581.9985, 4300.0034], [103297.42, 85332.023, 4581.9985, 4300.0034], [103297.42, 105332.02, 4581.9985, 4300.0034], [103297.42, 125332.02, 4581.9985, 4300.0034], [103297.42, 145332.03, 4581.9985, 4300.0034], [103297.42, 165332.03, 4581.9985, 4300.0034], [103297.42, 185332.03, 4581.9985, 4300.0034], [103297.42, 205332.03, 4581.9985, 4300.0034], [103297.42, 225332.03, 4581.9985, 4300.0034], [103297.42, 245332.03, 4581.9985, 4300.0034]]
		}, {
			"name":"Spark Core (v1.0)",
			"description":"The Spark Core is a tiny Wi-Fi development board that makes it easy to create internet-connected hardware. The Core is all you need to get started; power it over USB and in minutes you'll be controlling LEDs, switches and motors and collecting data from sensors over the internet!It has 8 digital I\/O pins, 8 analog I\/O pins, 8 PWM pins; UART (Serial), SPI, I2C, and JTAG peripherals available. Programmed wirelessly (through Spark Cloud), via USB or JTAG. 3.3VDC supply voltage (on board power regulator); can be powered by USB Micro 100mA typical current consumption; 300mA peak consumption (during transmit events). 2MB of external flash; EEPROM supplied by CC3000. STM32F103 microcontroller, ARM Cortex M3 architecture, 32-bit 72Mhz processor, 128KB of Flash, 20KB of RAM.",
			"image":"core\/breadboard\/SPARKCORE_v1_breadboard.svg",
			"icon":"core\/breadboard\/SPARKCORE_v1_breadboard.svg",
			"width":"106.848",
			"height":"57.672",
			"points": [[72.707, 50.971, 6, 6], [58.308, 50.971, 6, 6], [51.106, 50.971, 6, 6], [43.905, 50.971, 6, 6], [36.707, 50.971, 6, 6], [29.508, 50.971, 6, 6], [22.308, 50.971, 6, 6], [7.905, 50.971, 6, 6], [15.106, 50.971, 6, 6], [65.508, 50.971, 6, 6], [79.905, 50.971, 6, 6], [87.106, 50.971, 6, 6], [72.707, 0.571, 6, 6], [58.308, 0.571, 6, 6], [51.106, 0.571, 6, 6], [43.905, 0.571, 6, 6], [36.707, 0.571, 6, 6], [29.508, 0.571, 6, 6], [22.308, 0.571, 6, 6], [7.907, 0.571, 6, 6], [15.106, 0.571, 6, 6], [65.508, 0.571, 6, 6], [79.905, 0.571, 6, 6], [87.106, 0.571, 6, 6]]
		}, {
			"name":"Stepper Motor-Bipolar",
			"description":"Simple, but very powerful bi polar stepper motor. 4 wire",
			"image":"core\/breadboard\/Stepper_Motor_Bipolar_breadboard_leg.svg",
			"icon":"core\/breadboard\/Stepper_Motor_Bipolar_breadboard_leg.svg",
			"width":"153.5",
			"height":"251.68690024",
			"points": [[55.999998, 247.02942, 3, 3], [70.000002, 247.02942, 3, 3], [80.000002, 247.02942, 11, 11], [97.000002, 247.02942, 11, 11]]
		}, {
			"name":"SWITCH-DPDT",
			"description":"DPDT Version of the COM-00597",
			"image":"core\/breadboard\/sparkfun-electromechanical_os_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_os_breadboard.svg",
			"width":"485.097",
			"height":"400",
			"points": [[125.583, 333.05, 33.93, 33.9], [125.583, 33.05, 33.93, 33.9], [225.583, 333.05, 33.93, 33.9], [225.583, 33.05, 33.93, 33.9], [325.583, 333.05, 33.93, 33.9], [325.583, 33.05, 33.93, 33.9]]
		}, {
			"name":"Pushbutton",
			"description":"A generic pushbutton.",
			"image":"core\/breadboard\/basic_pbutton_2leg_horizon.svg",
			"icon":"core\/breadboard\/basic_pbutton_2leg_horizon.svg",
			"width":"23.662",
			"height":"7.128",
			"points": [[19.167, 19.167, 6, 6], [-1, -1, 6, 6]]
		}, {
			"name":"Audio Jack (TRS) 3.5mm",
			"description":"Stereo Jack 3.5mm",
			"image":"core\/breadboard\/stereo-jack-3_5mm.svg",
			"icon":"core\/breadboard\/stereo-jack-3_5mm.svg",
			"width":"34.016",
			"height":"35.046",
			"points": [[14.416, 17.546, 5.125, 4.834], [0.193, 3.014, 4.835, 5.125], [7.393, 3.014, 4.835, 5.125], [21.793, 3.014, 4.834, 5.125], [28.993, 3.014, 4.834, 5.125]]
		}, {
			"name":"74ACT125D",
			"description":"Quad Buffer with 3-State Outputs-ON Semi Conductor:Digikey P\/N MC74ACT125DR2GOSTR-ND",
			"image":"core\/breadboard\/SOIC-14_breadboard.svg",
			"icon":"core\/breadboard\/SOIC-14_breadboard.svg",
			"width":"50.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"LilyPad Button Board",
			"description":"We designed this board to give the user a very discrete button without any sharp edges. Button closes when you push it and opens when you release (momentary push button).LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun. Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing. Various input, output, power, and sensor boards are available. They're even washable!Note: A portion of this sale is given back to Dr. Leah Buechley for continued development and education of e-textiles.Dimensions:8x16mmThin 0.8mm PCB",
			"image":"core\/breadboard\/LilyPad-Button-v12_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad-Button-v12_breadboard.svg",
			"width":"21.6",
			"height":"44.221",
			"points": [[44.6505, 1.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"ST-GYRO-PY",
			"description":"",
			"image":"core\/breadboard\/sparkfun-sensors_st-gyro_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_st-gyro_breadboard.svg",
			"width":"800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"F25",
			"description":"25 Pin male connector. PCB edge mount for regular PCB thicknesses. This connector will connect directly to the back of a PC parallel port or through a normal DB25 extension cable (M\/F). SKU: PRT-08287",
			"image":"core\/breadboard\/sparkfun-connectors_f25hp_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_f25hp_breadboard.svg",
			"width":"2300.46",
			"height":"600",
			"points": [[483.265, 533.05, 33.93, 33.9], [583.265, 533.05, 33.93, 33.9], [583.265, 33.05, 33.93, 33.9], [683.265, 533.05, 33.93, 33.9], [683.265, 33.05, 33.93, 33.9], [783.265, 533.05, 33.93, 33.9], [783.265, 33.05, 33.93, 33.9], [883.265, 533.05, 33.93, 33.9], [883.265, 33.05, 33.93, 33.9], [983.265, 533.05, 33.93, 33.9], [983.265, 33.05, 33.93, 33.9], [1083.26, 533.05, 33.93, 33.9], [1083.26, 33.05, 33.93, 33.9], [1183.26, 533.05, 33.93, 33.9], [1183.26, 33.05, 33.93, 33.9], [1283.26, 533.05, 33.93, 33.9], [1283.26, 33.05, 33.93, 33.9], [1383.26, 533.05, 33.93, 33.9], [1383.26, 33.05, 33.93, 33.9], [1483.27, 533.05, 33.93, 33.9], [1483.27, 33.05, 33.93, 33.9], [1583.27, 533.05, 33.93, 33.9], [1583.27, 33.05, 33.93, 33.9], [1683.27, 533.05, 33.93, 33.9], [1683.27, 33.05, 33.93, 33.9], [1783.27, 533.05, 33.93, 33.9], [1783.27, 33.05, 33.93, 33.9]]
		}, {
			"name":"PCF8574",
			"description":"8-bit parallel-load shift registers",
			"image":"core\/breadboard\/PCF8574.svg",
			"icon":"core\/breadboard\/PCF8574.svg",
			"width":"57.6",
			"height":"23.76",
			"points": [[1.52, 19.636, 4.16, 5.124], [8.72, 19.636, 4.16, 5.124], [15.92, 19.636, 4.159, 5.124], [23.119, 19.636, 4.16, 5.124], [30.319, 19.636, 4.16, 5.124], [37.521, 19.636, 4.159, 5.124], [44.719, 19.636, 4.16, 5.124], [51.919, 19.636, 4.16, 5.124], [51.919, -1, 4.16, 5.125], [44.719, -1, 4.16, 5.125], [37.521, -1, 4.159, 5.125], [30.319, -1, 4.16, 5.125], [23.119, -1, 4.16, 5.125], [15.92, -1, 4.159, 5.125], [8.72, -1, 4.16, 5.125], [1.52, -1, 4.16, 5.125]]
		}, {
			"name":"JOYSTICK-PSP1000",
			"description":"This is a footprint for the PSP-1000 Joystick. 4-pins: X, Y, Vcc and GND",
			"image":"core\/breadboard\/sparkfun-electromechanical_joystick-psp1000_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_joystick-psp1000_breadboard.svg",
			"width":"1004.56",
			"height":"1200",
			"points": [[435.313, 1133.05, 33.93, 33.9], [435.313, 33.05, 33.93, 33.9], [535.313, 1133.05, 33.93, 33.9], [535.313, 33.05, 33.93, 33.9]]
		}, {
			"name":"LED Dot Matrix 18mm (0.7 INCH)",
			"description":"Dot Matrix LED Display (Kingbright TC07-11).",
			"image":"core\/breadboard\/LED_Matrix_Kingbright_TX07-11.svg",
			"icon":"core\/breadboard\/LED_Matrix_Kingbright_TX07-11.svg",
			"width":"36",
			"height":"51",
			"points": [[26.9, 41.301, 3.8, 3.8], [26.9, 34.101, 3.8, 3.8], [26.9, 26.9, 3.8, 3.8], [26.9, 19.701, 3.8, 3.8], [26.9, 12.5, 3.8, 3.8], [26.9, 5.3, 3.8, 3.8], [5.3, 41.301, 3.8, 3.8], [5.3, 34.101, 3.8, 3.8], [5.3, 26.9, 3.8, 3.8], [5.3, 19.701, 3.8, 3.8], [5.3, 12.5, 3.8, 3.8], [5.3, 5.3, 3.8, 3.8]]
		}, {
			"name":"Arduino Mega Proto Shield (v6)",
			"description":"",
			"image":"core\/breadboard\/proto_shield_v6MEGA_breadboard.svg",
			"icon":"core\/breadboard\/proto_shield_v6MEGA_breadboard.svg",
			"width":"288",
			"height":"151.2",
			"points": [[263.6, 4.4, 5.6, 5.6], [270.8, 4.4, 5.6, 5.6], [206, 141.2, 5.6, 5.6], [213.2, 141.2, 5.6, 5.6], [220.4, 141.2, 5.6, 5.6], [227.6, 141.2, 5.6, 5.6], [234.8, 141.2, 5.6, 5.6], [242, 141.2, 5.6, 5.6], [249.2, 141.2, 5.6, 5.6], [256.4, 141.2, 5.6, 5.6], [141.2, 141.2, 5.6, 5.6], [148.4, 141.2, 5.6, 5.6], [155.6, 141.2, 5.6, 5.6], [162.8, 141.2, 5.6, 5.6], [170, 141.2, 5.6, 5.6], [177.2, 141.2, 5.6, 5.6], [184.4, 141.2, 5.6, 5.6], [191.6, 141.2, 5.6, 5.6], [191.6, 4.4, 5.6, 5.6], [198.8, 4.4, 5.6, 5.6], [206, 4.4, 5.6, 5.6], [213.2, 4.4, 5.6, 5.6], [220.4, 4.4, 5.6, 5.6], [227.6, 4.4, 5.6, 5.6], [234.8, 4.4, 5.6, 5.6], [242, 4.4, 5.6, 5.6], [263.6, 126.8, 5.6, 5.6], [270.8, 126.8, 5.6, 5.6], [177.2, 4.4, 5.6, 5.6], [170, 4.4, 5.6, 5.6], [162.8, 4.4, 5.6, 5.6], [155.6, 4.4, 5.6, 5.6], [148.4, 4.4, 5.6, 5.6], [141.2, 4.4, 5.6, 5.6], [134, 4.4, 5.6, 5.6], [126.8, 4.4, 5.6, 5.6], [206, 134, 5.6, 5.6], [213.2, 134, 5.6, 5.6], [220.4, 134, 5.6, 5.6], [227.6, 134, 5.6, 5.6], [234.8, 134, 5.6, 5.6], [242, 134, 5.6, 5.6], [249.2, 134, 5.6, 5.6], [256.4, 134, 5.6, 5.6], [115.28, 4.4, 5.6, 5.6], [108.08, 4.4, 5.6, 5.6], [100.88, 4.4, 5.6, 5.6], [93.68, 4.4, 5.6, 5.6], [86.48, 4.4, 5.6, 5.6], [79.28, 4.4, 5.6, 5.6], [72.08, 4.4, 5.6, 5.6], [64.88, 4.4, 5.6, 5.6], [115.28, 11.6, 5.6, 5.6], [108.08, 11.6, 5.6, 5.6], [100.88, 11.6, 5.6, 5.6], [93.68, 11.6, 5.6, 5.6], [86.48, 11.6, 5.6, 5.6], [79.28, 11.6, 5.6, 5.6], [72.08, 11.6, 5.6, 5.6], [64.88, 11.6, 5.6, 5.6], [177.2, 11.6, 5.6, 5.6], [170, 11.6, 5.6, 5.6], [162.8, 11.6, 5.6, 5.6], [155.6, 11.6, 5.6, 5.6], [148.4, 11.6, 5.6, 5.6], [141.2, 11.6, 5.6, 5.6], [134, 11.6, 5.6, 5.6], [126.8, 11.6, 5.6, 5.6], [141.2, 134, 5.6, 5.6], [148.4, 134, 5.6, 5.6], [155.6, 134, 5.6, 5.6], [162.8, 134, 5.6, 5.6], [170, 134, 5.6, 5.6], [177.2, 134, 5.6, 5.6], [184.4, 134, 5.6, 5.6], [191.6, 134, 5.6, 5.6], [191.6, 11.6, 5.6, 5.6], [198.8, 11.6, 5.6, 5.6], [206, 11.6, 5.6, 5.6], [213.2, 11.6, 5.6, 5.6], [220.4, 11.6, 5.6, 5.6], [227.6, 11.6, 5.6, 5.6], [234.8, 11.6, 5.6, 5.6], [242, 11.6, 5.6, 5.6], [90.8, 141.2, 5.6, 5.6], [98, 141.2, 5.6, 5.6], [90.8, 134, 5.6, 5.6], [98, 134, 5.6, 5.6], [263.6, 11.6, 5.6, 5.6], [270.8, 11.6, 5.6, 5.6], [263.6, 18.8, 5.6, 5.6], [270.8, 18.8, 5.6, 5.6], [263.6, 26, 5.6, 5.6], [270.8, 26, 5.6, 5.6], [263.6, 33.2, 5.6, 5.6], [270.8, 33.2, 5.6, 5.6], [263.6, 40.4, 5.6, 5.6], [270.8, 40.4, 5.6, 5.6], [263.6, 47.6, 5.6, 5.6], [270.8, 47.6, 5.6, 5.6], [263.6, 54.8, 5.6, 5.6], [270.8, 54.8, 5.6, 5.6], [263.6, 62, 5.6, 5.6], [270.8, 62, 5.6, 5.6], [263.6, 69.2, 5.6, 5.6], [270.8, 69.2, 5.6, 5.6], [263.6, 76.4, 5.6, 5.6], [270.8, 76.4, 5.6, 5.6], [263.6, 83.6, 5.6, 5.6], [270.8, 83.6, 5.6, 5.6], [263.6, 90.8, 5.6, 5.6], [270.8, 90.8, 5.6, 5.6], [263.6, 98, 5.6, 5.6], [270.8, 98, 5.6, 5.6], [263.6, 105.2, 5.6, 5.6], [270.8, 105.2, 5.6, 5.6], [263.6, 112.4, 5.6, 5.6], [270.8, 112.4, 5.6, 5.6], [263.6, 119.6, 5.6, 5.6], [270.8, 119.6, 5.6, 5.6], [249.2, 11.6, 5.6, 5.6], [256.4, 11.6, 5.6, 5.6], [249.2, 18.8, 5.6, 5.6], [256.4, 18.8, 5.6, 5.6], [249.2, 26, 5.6, 5.6], [256.4, 26, 5.6, 5.6], [249.2, 33.2, 5.6, 5.6], [256.4, 33.2, 5.6, 5.6], [249.2, 40.4, 5.6, 5.6], [256.4, 40.4, 5.6, 5.6], [249.2, 47.6, 5.6, 5.6], [256.4, 47.6, 5.6, 5.6], [249.2, 54.8, 5.6, 5.6], [256.4, 54.8, 5.6, 5.6], [249.2, 62, 5.6, 5.6], [256.4, 62, 5.6, 5.6], [249.2, 69.2, 5.6, 5.6], [256.4, 69.2, 5.6, 5.6], [249.2, 76.4, 5.6, 5.6], [256.4, 76.4, 5.6, 5.6], [249.2, 83.6, 5.6, 5.6], [256.4, 83.6, 5.6, 5.6], [249.2, 90.8, 5.6, 5.6], [256.4, 90.8, 5.6, 5.6], [249.2, 98, 5.6, 5.6], [256.4, 98, 5.6, 5.6], [249.2, 105.2, 5.6, 5.6], [256.4, 105.2, 5.6, 5.6], [249.2, 112.4, 5.6, 5.6], [256.4, 112.4, 5.6, 5.6], [249.2, 119.6, 5.6, 5.6], [256.4, 119.6, 5.6, 5.6], [105.2, 141.2, 5.6, 5.6], [112.4, 141.2, 5.6, 5.6], [119.6, 141.2, 5.6, 5.6], [126.8, 141.2, 5.6, 5.6], [105.2, 134, 5.6, 5.6], [112.4, 134, 5.6, 5.6], [119.6, 134, 5.6, 5.6], [126.8, 134, 5.6, 5.6], [33.1742, 76.3742, 5.6516, 5.6516], [33.1742, 83.5742, 5.6516, 5.6516], [33.1742, 90.7742, 5.6516, 5.6516], [33.1742, 97.9742, 5.6516, 5.6516], [33.1742, 105.1742, 5.6516, 5.6516], [33.1742, 112.3742, 5.6516, 5.6516], [33.1742, 119.5742, 5.6516, 5.6516], [33.1742, 126.7742, 5.6516, 5.6516], [33.1742, 133.9742, 5.6516, 5.6516], [33.1742, 141.1742, 5.6516, 5.6516], [33.1742, 69.1742, 5.6516, 5.6516], [40.3742, 69.1742, 5.6516, 5.6516], [40.3742, 76.3742, 5.6516, 5.6516], [40.3742, 83.5742, 5.6516, 5.6516], [40.3742, 90.7742, 5.6516, 5.6516], [40.3742, 97.9742, 5.6516, 5.6516], [40.3742, 105.1742, 5.6516, 5.6516], [40.3742, 112.3742, 5.6516, 5.6516], [40.3742, 119.5742, 5.6516, 5.6516], [40.3742, 126.7742, 5.6516, 5.6516], [40.3742, 133.9742, 5.6516, 5.6516], [40.3742, 141.1742, 5.6516, 5.6516], [83.80551, 127.00551, 5.18898, 5.18898], [198.7742, 97.9742, 5.6516, 5.6516], [76.3742, 126.7742, 5.6516, 5.6516], [69.1742, 126.7742, 5.6516, 5.6516], [76.3742, 133.9742, 5.6516, 5.6516], [69.1742, 133.9742, 5.6516, 5.6516], [61.9742, 133.9742, 5.6516, 5.6516], [47.5742, 133.9742, 5.6516, 5.6516], [54.7742, 133.9742, 5.6516, 5.6516], [3.73074, 97.33074, 6.93852, 6.93852], [4.3742, 76.3742, 5.6516, 5.6516], [3.73074, 68.53074, 6.93852, 6.93852], [4.3742, 61.9742, 5.6516, 5.6516], [18.7742, 133.9742, 5.6516, 5.6516], [11.5742, 133.9742, 5.6516, 5.6516], [25.9742, 133.9742, 5.6516, 5.6516], [3.73074, 82.93074, 6.93852, 6.93852], [54.7742, 126.7742, 5.6516, 5.6516], [47.5742, 126.7742, 5.6516, 5.6516], [61.9742, 126.7742, 5.6516, 5.6516], [25.9742, 25.9742, 5.6516, 5.6516], [4.3742, 133.9742, 5.6516, 5.6516], [25.9742, 126.7742, 5.6516, 5.6516], [11.5742, 126.7742, 5.6516, 5.6516], [18.7742, 126.7742, 5.6516, 5.6516], [33.1742, 25.9742, 5.6516, 5.6516], [3.73074, 126.13074, 6.93852, 6.93852], [126.7742, 119.5742, 5.6516, 5.6516], [76.3742, 119.5742, 5.6516, 5.6516], [69.1742, 119.5742, 5.6516, 5.6516], [61.9742, 119.5742, 5.6516, 5.6516], [47.5742, 119.5742, 5.6516, 5.6516], [54.7742, 119.5742, 5.6516, 5.6516], [40.3742, 25.9742, 5.6516, 5.6516], [47.5742, 25.9742, 5.6516, 5.6516], [25.9742, 69.1742, 5.6516, 5.6516], [47.5742, 69.1742, 5.6516, 5.6516], [18.7742, 119.5742, 5.6516, 5.6516], [11.5742, 119.5742, 5.6516, 5.6516], [25.9742, 119.5742, 5.6516, 5.6516], [4.3742, 119.5742, 5.6516, 5.6516], [148.3742, 112.3742, 5.6516, 5.6516], [76.3742, 112.3742, 5.6516, 5.6516], [69.1742, 112.3742, 5.6516, 5.6516], [54.7742, 112.3742, 5.6516, 5.6516], [47.5742, 112.3742, 5.6516, 5.6516], [61.9742, 112.3742, 5.6516, 5.6516], [25.9742, 112.3742, 5.6516, 5.6516], [11.5742, 112.3742, 5.6516, 5.6516], [18.7742, 112.3742, 5.6516, 5.6516], [25.9742, 83.5742, 5.6516, 5.6516], [11.5742, 83.5742, 5.6516, 5.6516], [3.73074, 111.73074, 6.93852, 6.93852], [119.5742, 105.1742, 5.6516, 5.6516], [76.3742, 105.1742, 5.6516, 5.6516], [69.1742, 105.1742, 5.6516, 5.6516], [61.9742, 105.1742, 5.6516, 5.6516], [47.5742, 105.1742, 5.6516, 5.6516], [54.7742, 105.1742, 5.6516, 5.6516], [18.7742, 83.5742, 5.6516, 5.6516], [18.7742, 90.7742, 5.6516, 5.6516], [61.9742, 83.5742, 5.6516, 5.6516], [54.7742, 83.5742, 5.6516, 5.6516], [47.5742, 83.5742, 5.6516, 5.6516], [61.9742, 90.7742, 5.6516, 5.6516], [54.7742, 90.7742, 5.6516, 5.6516], [47.5742, 90.7742, 5.6516, 5.6516], [18.7742, 105.1742, 5.6516, 5.6516], [11.5742, 105.1742, 5.6516, 5.6516], [25.9742, 105.1742, 5.6516, 5.6516], [4.3742, 105.1742, 5.6516, 5.6516], [162.7742, 97.9742, 5.6516, 5.6516], [76.3742, 97.9742, 5.6516, 5.6516], [69.1742, 97.9742, 5.6516, 5.6516], [25.9742, 97.9742, 5.6516, 5.6516], [11.5742, 97.9742, 5.6516, 5.6516], [54.7742, 97.9742, 5.6516, 5.6516], [47.5742, 97.9742, 5.6516, 5.6516], [61.9742, 97.9742, 5.6516, 5.6516], [25.9742, 90.7742, 5.6516, 5.6516], [11.5742, 90.7742, 5.6516, 5.6516], [18.7742, 97.9742, 5.6516, 5.6516], [3.73074, 25.33074, 6.93852, 6.93852], [4.3742, 90.7742, 5.6516, 5.6516], [169.9742, 90.7742, 5.6516, 5.6516], [76.3742, 90.7742, 5.6516, 5.6516], [69.1742, 90.7742, 5.6516, 5.6516], [4.3742, 33.1742, 5.6516, 5.6516], [191.5742, 83.5742, 5.6516, 5.6516], [76.3742, 83.5742, 5.6516, 5.6516], [69.1742, 83.5742, 5.6516, 5.6516], [3.73074, 39.73074, 6.93852, 6.93852], [4.3742, 47.5742, 5.6516, 5.6516], [3.73074, 54.13074, 6.93852, 6.93852], [169.9742, 76.3742, 5.6516, 5.6516], [61.9742, 76.3742, 5.6516, 5.6516], [54.7742, 76.3742, 5.6516, 5.6516], [47.5742, 76.3742, 5.6516, 5.6516], [76.3742, 76.3742, 5.6516, 5.6516], [69.1742, 76.3742, 5.6516, 5.6516], [69.1742, 25.9742, 5.6516, 5.6516], [76.3742, 69.1742, 5.6516, 5.6516], [69.1742, 69.1742, 5.6516, 5.6516], [69.1742, 61.9742, 5.6516, 5.6516], [177.1742, 90.7742, 5.6516, 5.6516], [76.3742, 61.9742, 5.6516, 5.6516], [155.5742, 54.7742, 5.6516, 5.6516], [76.3742, 54.7742, 5.6516, 5.6516], [69.1742, 54.7742, 5.6516, 5.6516], [141.1742, 47.5742, 5.6516, 5.6516], [76.3742, 47.5742, 5.6516, 5.6516], [69.1742, 47.5742, 5.6516, 5.6516], [119.5742, 40.3742, 5.6516, 5.6516], [25.9742, 76.3742, 5.6516, 5.6516], [11.5742, 76.3742, 5.6516, 5.6516], [76.3742, 40.3742, 5.6516, 5.6516], [69.1742, 40.3742, 5.6516, 5.6516], [191.5742, 40.3742, 5.6516, 5.6516], [191.5742, 54.7742, 5.6516, 5.6516], [191.5742, 61.9742, 5.6516, 5.6516], [191.6462, 69.2462, 5.5076, 5.5076], [177.1742, 33.1742, 5.6516, 5.6516], [18.7742, 76.3742, 5.6516, 5.6516], [76.3742, 33.1742, 5.6516, 5.6516], [69.1742, 33.1742, 5.6516, 5.6516], [191.6462, 76.4462, 5.5076, 5.5076], [191.5742, 90.7742, 5.6516, 5.6516], [191.5742, 25.9742, 5.6516, 5.6516], [191.5742, 33.1742, 5.6516, 5.6516], [191.5742, 47.5742, 5.6516, 5.6516], [198.7742, 54.7742, 5.6516, 5.6516], [198.7742, 61.9742, 5.6516, 5.6516], [198.7742, 69.1742, 5.6516, 5.6516], [105.1742, 25.9742, 5.6516, 5.6516], [198.7742, 76.3742, 5.6516, 5.6516], [76.3742, 25.9742, 5.6516, 5.6516], [198.7742, 83.5742, 5.6516, 5.6516], [198.7742, 90.7742, 5.6516, 5.6516], [198.7742, 25.9742, 5.6516, 5.6516], [198.7742, 33.1742, 5.6516, 5.6516], [198.7742, 40.3742, 5.6516, 5.6516], [198.7742, 47.5742, 5.6516, 5.6516], [205.9742, 97.9742, 5.6516, 5.6516], [205.9742, 54.7742, 5.6516, 5.6516], [205.9742, 61.9742, 5.6516, 5.6516], [205.9742, 69.1742, 5.6516, 5.6516], [205.9742, 76.3742, 5.6516, 5.6516], [205.9742, 83.5742, 5.6516, 5.6516], [205.9742, 90.7742, 5.6516, 5.6516], [205.9742, 25.9742, 5.6516, 5.6516], [205.9742, 33.1742, 5.6516, 5.6516], [40.3742, 11.5742, 5.6516, 5.6516], [47.5742, 11.5742, 5.6516, 5.6516], [205.9742, 40.3742, 5.6516, 5.6516], [205.9742, 47.5742, 5.6516, 5.6516], [213.1742, 97.9742, 5.6516, 5.6516], [213.1742, 54.7742, 5.6516, 5.6516], [83.5742, 40.3742, 5.6516, 5.6516], [90.7742, 40.3742, 5.6516, 5.6516], [83.5742, 47.5742, 5.6516, 5.6516], [90.7742, 47.5742, 5.6516, 5.6516], [83.5742, 54.7742, 5.6516, 5.6516], [90.7742, 54.7742, 5.6516, 5.6516], [97.9742, 47.5742, 5.6516, 5.6516], [97.9742, 54.7742, 5.6516, 5.6516], [90.7742, 61.9742, 5.6516, 5.6516], [97.9742, 61.9742, 5.6516, 5.6516], [105.1742, 54.7742, 5.6516, 5.6516], [105.1742, 47.5742, 5.6516, 5.6516], [105.1742, 61.9742, 5.6516, 5.6516], [112.3742, 54.7742, 5.6516, 5.6516], [112.3742, 47.5742, 5.6516, 5.6516], [105.1742, 40.3742, 5.6516, 5.6516], [97.9742, 40.3742, 5.6516, 5.6516], [213.1742, 61.9742, 5.6516, 5.6516], [90.7742, 33.1742, 5.6516, 5.6516], [97.9742, 33.1742, 5.6516, 5.6516], [83.5742, 33.1742, 5.6516, 5.6516], [83.5742, 25.9742, 5.6516, 5.6516], [90.7742, 25.9742, 5.6516, 5.6516], [213.1742, 69.1742, 5.6516, 5.6516], [83.5742, 61.9742, 5.6516, 5.6516], [83.5742, 69.1742, 5.6516, 5.6516], [213.1742, 76.3742, 5.6516, 5.6516], [213.1742, 83.5742, 5.6516, 5.6516], [213.1742, 90.7742, 5.6516, 5.6516], [213.1742, 25.9742, 5.6516, 5.6516], [213.1742, 33.1742, 5.6516, 5.6516], [213.1742, 40.3742, 5.6516, 5.6516], [90.7742, 83.5742, 5.6516, 5.6516], [213.1742, 47.5742, 5.6516, 5.6516], [97.9742, 83.5742, 5.6516, 5.6516], [105.1742, 83.5742, 5.6516, 5.6516], [112.3742, 83.5742, 5.6516, 5.6516], [220.3742, 97.9742, 5.6516, 5.6516], [220.3742, 54.7742, 5.6516, 5.6516], [220.3742, 61.9742, 5.6516, 5.6516], [119.5742, 61.9742, 5.6516, 5.6516], [112.3742, 61.9742, 5.6516, 5.6516], [126.7742, 61.9742, 5.6516, 5.6516], [220.3742, 69.1742, 5.6516, 5.6516], [83.5742, 76.3742, 5.6516, 5.6516], [83.5742, 83.5742, 5.6516, 5.6516], [83.5742, 90.7742, 5.6516, 5.6516], [90.7742, 105.1742, 5.6516, 5.6516], [90.7742, 97.9742, 5.6516, 5.6516], [105.1742, 97.9742, 5.6516, 5.6516], [97.9742, 97.9742, 5.6516, 5.6516], [97.9742, 105.1742, 5.6516, 5.6516], [83.5742, 105.1742, 5.6516, 5.6516], [83.5742, 97.9742, 5.6516, 5.6516], [105.1742, 90.7742, 5.6516, 5.6516], [112.3742, 90.7742, 5.6516, 5.6516], [105.1742, 105.1742, 5.6516, 5.6516], [83.5742, 112.3742, 5.6516, 5.6516], [90.7742, 112.3742, 5.6516, 5.6516], [83.5742, 119.5742, 5.6516, 5.6516], [220.3742, 76.3742, 5.6516, 5.6516], [220.3742, 83.5742, 5.6516, 5.6516], [90.7742, 119.5742, 5.6516, 5.6516], [97.9742, 119.5742, 5.6516, 5.6516], [97.9742, 112.3742, 5.6516, 5.6516], [105.1742, 112.3742, 5.6516, 5.6516], [112.3742, 97.9742, 5.6516, 5.6516], [119.5742, 97.9742, 5.6516, 5.6516], [119.5742, 90.7742, 5.6516, 5.6516], [126.7742, 90.7742, 5.6516, 5.6516], [126.7742, 83.5742, 5.6516, 5.6516], [119.5742, 83.5742, 5.6516, 5.6516], [133.9742, 83.5742, 5.6516, 5.6516], [220.3742, 90.7742, 5.6516, 5.6516], [220.3742, 25.9742, 5.6516, 5.6516], [220.3742, 33.1742, 5.6516, 5.6516], [220.3742, 40.3742, 5.6516, 5.6516], [141.1742, 61.9742, 5.6516, 5.6516], [133.9742, 61.9742, 5.6516, 5.6516], [220.3742, 47.5742, 5.6516, 5.6516], [126.7742, 54.7742, 5.6516, 5.6516], [227.5742, 97.9742, 5.6516, 5.6516], [141.1742, 54.7742, 5.6516, 5.6516], [133.9742, 54.7742, 5.6516, 5.6516], [119.5742, 54.7742, 5.6516, 5.6516], [119.5742, 47.5742, 5.6516, 5.6516], [126.7742, 47.5742, 5.6516, 5.6516], [90.7742, 90.7742, 5.6516, 5.6516], [97.9742, 90.7742, 5.6516, 5.6516], [126.7742, 97.9742, 5.6516, 5.6516], [133.9742, 90.7742, 5.6516, 5.6516], [141.1742, 90.7742, 5.6516, 5.6516], [141.1742, 83.5742, 5.6516, 5.6516], [155.5742, 90.7742, 5.6516, 5.6516], [191.5742, 97.9742, 5.6516, 5.6516], [177.1742, 97.9742, 5.6516, 5.6516], [169.9742, 97.9742, 5.6516, 5.6516], [177.1742, 105.1742, 5.6516, 5.6516], [177.1742, 112.3742, 5.6516, 5.6516], [169.9742, 112.3742, 5.6516, 5.6516], [162.7742, 112.3742, 5.6516, 5.6516], [227.5742, 54.7742, 5.6516, 5.6516], [3.73074, 140.53074, 6.93852, 6.93852], [227.5742, 61.9742, 5.6516, 5.6516], [18.7742, 141.1742, 5.6516, 5.6516], [25.9742, 141.1742, 5.6516, 5.6516], [11.5742, 141.1742, 5.6516, 5.6516], [227.5742, 69.1742, 5.6516, 5.6516], [227.5742, 76.3742, 5.6516, 5.6516], [47.5742, 141.1742, 5.6516, 5.6516], [61.9742, 141.1742, 5.6516, 5.6516], [54.7742, 141.1742, 5.6516, 5.6516], [227.5742, 83.5742, 5.6516, 5.6516], [69.1742, 141.1742, 5.6516, 5.6516], [76.3742, 141.1742, 5.6516, 5.6516], [227.5742, 90.7742, 5.6516, 5.6516], [227.5742, 25.9742, 5.6516, 5.6516], [227.5742, 33.1742, 5.6516, 5.6516], [227.5742, 40.3742, 5.6516, 5.6516], [227.5742, 47.5742, 5.6516, 5.6516], [234.7742, 97.9742, 5.6516, 5.6516], [234.7742, 54.7742, 5.6516, 5.6516], [234.7742, 61.9742, 5.6516, 5.6516], [234.7742, 69.1742, 5.6516, 5.6516], [234.7742, 76.3742, 5.6516, 5.6516], [234.7742, 83.5742, 5.6516, 5.6516], [234.7742, 90.7742, 5.6516, 5.6516], [234.7742, 25.9742, 5.6516, 5.6516], [169.9742, 119.5742, 5.6516, 5.6516], [162.7742, 119.5742, 5.6516, 5.6516], [155.5742, 119.5742, 5.6516, 5.6516], [148.3742, 119.5742, 5.6516, 5.6516], [141.1742, 119.5742, 5.6516, 5.6516], [133.9742, 119.5742, 5.6516, 5.6516], [112.3742, 119.5742, 5.6516, 5.6516], [105.1742, 119.5742, 5.6516, 5.6516], [119.5742, 119.5742, 5.6516, 5.6516], [119.5742, 112.3742, 5.6516, 5.6516], [112.3742, 112.3742, 5.6516, 5.6516], [126.7742, 112.3742, 5.6516, 5.6516], [133.9742, 112.3742, 5.6516, 5.6516], [155.5742, 112.3742, 5.6516, 5.6516], [141.1742, 112.3742, 5.6516, 5.6516], [169.9742, 105.1742, 5.6516, 5.6516], [162.7742, 105.1742, 5.6516, 5.6516], [155.5742, 105.1742, 5.6516, 5.6516], [148.3742, 105.1742, 5.6516, 5.6516], [141.1742, 105.1742, 5.6516, 5.6516], [133.9742, 105.1742, 5.6516, 5.6516], [126.7742, 105.1742, 5.6516, 5.6516], [112.3742, 105.1742, 5.6516, 5.6516], [133.9742, 97.9742, 5.6516, 5.6516], [141.1742, 97.9742, 5.6516, 5.6516], [148.3742, 97.9742, 5.6516, 5.6516], [155.5742, 97.9742, 5.6516, 5.6516], [162.7742, 90.7742, 5.6516, 5.6516], [148.3742, 90.7742, 5.6516, 5.6516], [234.7742, 33.1742, 5.6516, 5.6516], [155.5742, 83.5742, 5.6516, 5.6516], [234.7742, 40.3742, 5.6516, 5.6516], [169.9742, 83.5742, 5.6516, 5.6516], [234.7742, 47.5742, 5.6516, 5.6516], [241.9742, 97.9742, 5.6516, 5.6516], [241.9742, 54.7742, 5.6516, 5.6516], [241.9742, 61.9742, 5.6516, 5.6516], [241.9742, 69.1742, 5.6516, 5.6516], [241.9742, 76.3742, 5.6516, 5.6516], [241.9742, 83.5742, 5.6516, 5.6516], [169.9742, 69.1742, 5.6516, 5.6516], [241.9742, 90.7742, 5.6516, 5.6516], [155.5742, 61.9742, 5.6516, 5.6516], [169.9742, 61.9742, 5.6516, 5.6516], [184.3742, 54.7742, 5.6516, 5.6516], [169.9742, 54.7742, 5.6516, 5.6516], [162.7742, 54.7742, 5.6516, 5.6516], [148.3742, 54.7742, 5.6516, 5.6516], [177.1742, 47.5742, 5.6516, 5.6516], [162.7742, 47.5742, 5.6516, 5.6516], [169.9742, 47.5742, 5.6516, 5.6516], [177.1742, 40.3742, 5.6516, 5.6516], [169.9742, 40.3742, 5.6516, 5.6516], [162.7742, 40.3742, 5.6516, 5.6516], [155.5742, 40.3742, 5.6516, 5.6516], [155.5742, 47.5742, 5.6516, 5.6516], [148.3742, 40.3742, 5.6516, 5.6516], [148.3742, 47.5742, 5.6516, 5.6516], [133.9742, 47.5742, 5.6516, 5.6516], [141.1742, 40.3742, 5.6516, 5.6516], [133.9742, 40.3742, 5.6516, 5.6516], [126.7742, 40.3742, 5.6516, 5.6516], [112.3742, 40.3742, 5.6516, 5.6516], [105.1742, 33.1742, 5.6516, 5.6516], [119.5742, 33.1742, 5.6516, 5.6516], [112.3742, 33.1742, 5.6516, 5.6516], [126.7742, 33.1742, 5.6516, 5.6516], [133.9742, 33.1742, 5.6516, 5.6516], [141.1742, 33.1742, 5.6516, 5.6516], [148.3742, 33.1742, 5.6516, 5.6516], [155.5742, 33.1742, 5.6516, 5.6516], [162.7742, 33.1742, 5.6516, 5.6516], [169.9742, 33.1742, 5.6516, 5.6516], [177.1742, 25.9742, 5.6516, 5.6516], [169.9742, 25.9742, 5.6516, 5.6516], [162.7742, 25.9742, 5.6516, 5.6516], [155.5742, 25.9742, 5.6516, 5.6516], [141.1742, 25.9742, 5.6516, 5.6516], [148.3742, 25.9742, 5.6516, 5.6516], [133.9742, 25.9742, 5.6516, 5.6516], [126.7742, 25.9742, 5.6516, 5.6516], [119.5742, 25.9742, 5.6516, 5.6516], [112.3742, 25.9742, 5.6516, 5.6516], [97.9742, 25.9742, 5.6516, 5.6516], [241.9742, 25.9742, 5.6516, 5.6516], [241.9742, 33.1742, 5.6516, 5.6516], [241.9742, 40.3742, 5.6516, 5.6516], [241.9742, 47.5742, 5.6516, 5.6516], [191.5742, 105.1742, 5.6516, 5.6516], [198.7742, 105.1742, 5.6516, 5.6516], [205.9742, 105.1742, 5.6516, 5.6516], [213.1742, 105.1742, 5.6516, 5.6516], [220.3742, 105.1742, 5.6516, 5.6516], [227.5742, 105.1742, 5.6516, 5.6516], [234.7742, 105.1742, 5.6516, 5.6516], [241.9742, 105.1742, 5.6516, 5.6516], [191.5742, 112.3742, 5.6516, 5.6516], [198.7742, 112.3742, 5.6516, 5.6516], [47.5742, 4.3742, 5.6516, 5.6516], [54.7742, 4.3742, 5.6516, 5.6516], [54.7742, 11.5742, 5.6516, 5.6516], [47.5742, 18.7742, 5.6516, 5.6516], [40.3742, 18.7742, 5.6516, 5.6516], [205.9742, 112.3742, 5.6516, 5.6516], [213.1742, 112.3742, 5.6516, 5.6516], [220.3742, 112.3742, 5.6516, 5.6516], [227.5742, 112.3742, 5.6516, 5.6516], [234.7742, 112.3742, 5.6516, 5.6516], [241.9742, 112.3742, 5.6516, 5.6516], [177.1742, 54.7742, 5.6516, 5.6516], [198.7742, 119.5742, 5.6516, 5.6516], [205.9742, 119.5742, 5.6516, 5.6516], [213.1742, 119.5742, 5.6516, 5.6516], [220.3742, 119.5742, 5.6516, 5.6516], [227.5742, 119.5742, 5.6516, 5.6516], [234.7742, 119.5742, 5.6516, 5.6516], [241.9742, 119.5742, 5.6516, 5.6516], [184.3742, 40.3742, 5.6516, 5.6516], [184.3742, 33.1742, 5.6516, 5.6516], [184.3742, 25.9742, 5.6516, 5.6516]]
		}, {
			"name":"AD22100-Voltage Output Temperature Sensor with Signal Conditioning",
			"description":"",
			"image":"core\/breadboard\/AD22100.svg",
			"icon":"core\/breadboard\/AD22100.svg",
			"width":"16.527",
			"height":"24.082",
			"points": [[-1, 21.082, 4.16, 3], [6.181, 21.082, 4.157, 3], [13.367, 21.082, 4.16, 3]]
		}, {
			"name":"LCD_CFAX",
			"description":"Graphic LCD module (LCD-00463) DISCONTINUED",
			"image":"core\/breadboard\/sparkfun-displays_lcd_cfax_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-displays_lcd_cfax_breadboard.svg",
			"width":"2682.81",
			"height":"2000",
			"points": [[824.44, 1933.05, 33.93, 33.9], [824.44, 33.05, 33.93, 33.9], [924.44, 1933.05, 33.93, 33.9], [924.44, 33.05, 33.93, 33.9], [1024.44, 1933.05, 33.93, 33.9], [1024.44, 33.05, 33.93, 33.9], [1124.44, 1933.05, 33.93, 33.9], [1124.44, 33.05, 33.93, 33.9], [1224.44, 1933.05, 33.93, 33.9], [1224.44, 33.05, 33.93, 33.9], [1324.44, 1933.05, 33.93, 33.9], [1324.44, 33.05, 33.93, 33.9], [1424.44, 1933.05, 33.93, 33.9], [1424.44, 33.05, 33.93, 33.9], [1524.44, 1933.05, 33.93, 33.9], [1524.44, 33.05, 33.93, 33.9], [1624.44, 1933.05, 33.93, 33.9], [1624.44, 33.05, 33.93, 33.9], [1724.44, 1933.05, 33.93, 33.9], [1724.44, 33.05, 33.93, 33.9], [1824.44, 1933.05, 33.93, 33.9], [1824.44, 33.05, 33.93, 33.9]]
		}, {
			"name":"XBee",
			"description":"XBee embedded RF module.",
			"image":"core\/breadboard\/xbee.svg",
			"icon":"core\/breadboard\/xbee.svg",
			"width":"68.602",
			"height":"91.387",
			"points": [[64.52, 21.834, 4.367, 4.367], [64.52, 29.033, 4.367, 4.368], [64.52, 36.234, 4.367, 4.368], [64.52, 43.435, 4.367, 4.368], [64.52, 50.635, 4.367, 4.369], [64.52, 57.836, 4.367, 4.367], [64.52, 65.037, 4.367, 4.367], [64.52, 72.236, 4.367, 4.367], [64.52, 79.438, 4.367, 4.367], [64.52, 86.635, 4.367, 4.369], [-0.282, 86.639, 4.368, 4.367], [-0.282, 79.439, 4.368, 4.367], [-0.282, 72.238, 4.368, 4.367], [-0.282, 65.037, 4.368, 4.367], [-0.282, 57.838, 4.368, 4.367], [-0.282, 50.637, 4.368, 4.369], [-0.282, 43.435, 4.368, 4.368], [-0.282, 36.235, 4.368, 4.368], [-0.282, 29.034, 4.368, 4.368], [-0.282, 21.833, 4.368, 4.368]]
		}, {
			"name":"150k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_150k.svg",
			"icon":"obsolete\/breadboard\/resistor_150k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"3.5mm Audio Jack",
			"description":"3.5mm Audio JackSimple 3.5mm common PCB mount audio jack. SKU: PRT-08032",
			"image":"core\/breadboard\/sparkfun-connectors_audio-jack-3.5mm-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_audio-jack-3.5mm-smd_breadboard.svg",
			"width":"839.653",
			"height":"600",
			"points": [[302.861, 533.05, 33.93, 33.9], [402.861, 533.05, 33.93, 33.9], [402.861, 33.05, 33.93, 33.9], [502.861, 533.05, 33.93, 33.9], [502.861, 33.05, 33.93, 33.9]]
		}, {
			"name":"150k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_150k.svg",
			"icon":"obsolete\/breadboard\/resistor_150k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"E-Paper Eval Board",
			"description":"\tDescription: E-paper displays are rad. But those 26-pin SMD connectors can be a real pain to solder, so we put together a breakout board to help you integrate this very cool technology into your next project. This board breaks out all of the major pins from the e-paper ribbon connector to a 0.1'' pitch header.Because the e-paper display requires a 35V supply,the breakout also includes a voltage step-up so that you can power the display using either 3.3V or 5V. \ tDocuments:  \ t \ t \ tSchematic \ t \ t \ tEagle Files \ t \ t \ tDatasheet(E-paper display) \ t \ t \ tDatasheet(SMD Connector) \ t \ t \ tExample Code \ t \ t \ tbildr Tutorial",
			"image":"core\/breadboard\/10x2-Epaper-Breakout-Board-v11_breadboard.svg",
			"icon":"core\/breadboard\/10x2-Epaper-Breakout-Board-v11_breadboard.svg",
			"width":"72",
			"height":"93.6",
			"points": [[11.348, 0.548, 6.104, 6.104], [18.548, 0.548, 6.104, 6.104], [25.748, 0.548, 6.104, 6.104], [32.948, 0.548, 6.104, 6.104], [40.148, 0.548, 6.104, 6.104], [47.348, 0.548, 6.104, 6.104], [54.548, 0.548, 6.104, 6.104]]
		}, {
			"name":"YC164",
			"description":"",
			"image":"core\/breadboard\/smd-yc164-8pin_smd_breadboard.svg",
			"icon":"core\/breadboard\/smd-yc164-8pin_smd_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"GS406SMD",
			"description":"50 Channel GS406 Helical GPS Receiver-SMD Connector.The Mating SMD SPECIAL is called SPECIAL for a reason.This package was only made in order to make a dummy gs407 PCB with mating connector(used for testing).sku: GPS-09079",
			"image":"core\/breadboard\/sparkfun-rf_gs406smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_gs406smd_breadboard.svg",
			"width":"500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"DSPIC30F4011",
			"description":"Microchip 16-bit DSP for UAVv2x, not tested",
			"image":"core\/breadboard\/sparkfun-digitalic_tqfp44_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tqfp44_breadboard.svg",
			"width":"2200",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"68 \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_68.svg",
			"icon":"obsolete\/breadboard\/resistor_68.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"ATMEGA128",
			"description":"ATmega128\/128L\/1281\/2561.Note: The ATmega128 pin 1 is PEN and the ATmega256\/1281 pin 1 is PG5.",
			"image":"core\/breadboard\/sparkfun-digitalic_tqfp64_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tqfp64_breadboard.svg",
			"width":"3200",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"HMC1041Z",
			"description":"Honeywell 1-axis magnetometer",
			"image":"core\/breadboard\/sparkfun-sensors_hmc1041z_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_hmc1041z_breadboard.svg",
			"width":"500",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"68 \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_68.svg",
			"icon":"obsolete\/breadboard\/resistor_68.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Alphanumeric LED Display",
			"description":"Alphanumeric LED Display Common anode.Multiple LEDs on some segments.Multiple LED colors available.Works great with A6282 driver IC.Decimal points are unfornately not connected.SKU: COM-09933.",
			"image":"core\/breadboard\/sparkfun-displays_alphanumeric_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-displays_alphanumeric_breadboard.svg",
			"width":"58.895",
			"height":"103.178",
			"points": [[1.405, 13.647, 5.684, 5.684], [1.404, 20.846, 5.686, 5.686], [1.404, 28.046, 5.686, 5.686], [1.404, 35.246, 5.686, 5.686], [1.405, 49.647, 5.684, 5.684], [1.404, 56.846, 5.686, 5.686], [1.404, 71.246, 5.686, 5.686], [1.405, 78.447, 5.684, 5.684], [1.405, 85.647, 5.684, 5.684], [1.404, 92.846, 5.686, 5.686], [51.805, 92.846, 5.686, 5.686], [51.806, 85.647, 5.684, 5.684], [51.806, 78.447, 5.684, 5.684], [51.805, 71.246, 5.686, 5.686], [51.805, 56.846, 5.686, 5.686], [51.806, 49.647, 5.684, 5.684], [51.805, 35.246, 5.686, 5.686], [51.805, 28.046, 5.686, 5.686], [51.805, 20.846, 5.686, 5.686], [51.806, 13.647, 5.684, 5.684]]
		}, {
			"name":"Generic female header-metal rounded-2 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_2.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_2.svg",
			"width":"14.358",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783]]
		}, {
			"name":"SPST Switch",
			"description":"SPST SwitchSimple slide switch .Spark Fun Electronics SKU: COM-00102",
			"image":"core\/breadboard\/sparkfun-electromechanical_switch-spdt-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_switch-spdt-smd_breadboard.svg",
			"width":"583.139",
			"height":"600",
			"points": [[224.605, 533.05, 33.93, 33.9], [324.605, 533.05, 33.93, 33.9], [324.605, 33.05, 33.93, 33.9]]
		}, {
			"name":"ENC28J60",
			"description":"Microchip SPI 10Base ethernet IC",
			"image":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"icon":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"WIZ820io",
			"description":"Plug-in Network Module having W5200 & Mag Jack",
			"image":"core\/breadboard\/WIZ820io_breadboard.svg",
			"icon":"core\/breadboard\/WIZ820io_breadboard.svg",
			"width":"65.196871",
			"height":"76.344751",
			"points": [[0.5706123743351, 41.663243205882, 6.0000012638647, 5.9999999895212], [0.57061237433512, 49.011935815508, 6.0000012638647, 5.9999999895212], [0.5706123743351, 56.156498074866, 6.0000012638647, 5.9999999895212], [58.135389489055, 55.952367724599, 6.0000012638647, 5.9999999895212], [58.135389489055, 49.011935815508, 6.0000012638647, 5.9999999895212], [58.135389489055, 41.86737355615, 6.0000012638647, 5.9999999895212], [58.135389489055, 34.722811296791, 6.0000012638647, 5.9999999895212], [58.339519904356, 27.169988336898, 6.0000012638647, 5.9999999895212], [58.135389489055, 20.02542607754, 6.0000012638647, 5.9999999895212], [0.5706123743351, 20.229556427807, 6.0000012638647, 5.9999999895212], [0.77474278963553, 27.169988336898, 6.0000012638647, 5.9999999895212], [0.77474278963553, 34.518680946524, 6.0000012638647, 5.9999999895212]]
		}, {
			"name":"3.3k \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_3.3k.svg",
			"icon":"obsolete\/breadboard\/resistor_3.3k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"RGB LED(com.cathode, rbg)",
			"description":"A 5mm tri-color LED with red, green and blue inside.Pin order: red-com.cathode-blue-green",
			"image":"core\/breadboard\/led-rgb-4pin-anode-leg.svg",
			"icon":"core\/breadboard\/led-rgb-4pin-anode-leg.svg",
			"width":"23.76",
			"height":"32.55",
			"points": [[35.417, 2.59, 8.5, 4.91], [6.199, 21, 3, 3], [13.399, 21, 3, 3], [20.598, 21, 3, 3]]
		}, {
			"name":"BALUN",
			"description":"0805 footprint balun-Ember 351\/357",
			"image":"core\/breadboard\/sparkfun-rf_balun_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_balun_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"WeIO",
			"description":"WeIO is an innovative open source hardware and software platform for rapid prototyping and creation of wirelessly connected interactive objects using only popular Web languages such as HTML5 or Python.",
			"image":"core\/breadboard\/WeIO_breadboard.svg",
			"icon":"core\/breadboard\/WeIO_breadboard.svg",
			"width":"323",
			"height":"230",
			"points": [[197, 195.43361, 11.0396976, 32.421783], [188, 195.43361, 11.0396976, 32.421783], [179, 195.43361, 11.0396976, 32.421783], [170, 195.43361, 11.0424738, 32.421783], [161, 195.43361, 11.0396976, 32.421783], [152, 195.43361, 11.0396976, 32.421783], [143, 195.43361, 11.0396976, 32.421783], [134, 195.43361, 11.0396976, 32.421783], [125, 195.43361, 11.0396976, 32.421783], [116, 195.43361, 11.0410862, 32.421783], [116, 1.8704257, 11.038312, 32.188089], [179, 1.8704257, 11.0369244, 32.188089], [170, 1.8704257, 11.0438604, 32.188089], [161, 1.8704257, 11.038312, 32.189474], [152, 1.8704257, 11.0410872, 32.188089], [143, 1.8704257, 11.038312, 32.188089], [134, 1.8704257, 11.0396986, 32.188089], [125, 1.8704257, 11.0369244, 32.188089], [89, 1.8707867, 11.0380001, 32.189474], [98, 1.8698759, 11.0380001, 32.188999], [71, 1.8707867, 11.0380001, 32.189474], [80, 1.8707867, 11.0380001, 32.189474], [296, 2, 11.0396948, 32.189474], [287, 1.8707867, 11.0396948, 32.189474], [197, 1.8707867, 11.0396948, 32.189474], [188, 1.8695259, 11.0396948, 32.189474], [278, 1.8707867, 11.0410833, 32.189474], [269, 1.8707867, 11.0383081, 32.189474], [251, 1.8707867, 11.0383081, 32.192236], [242, 1.8707867, 11.0369205, 32.189474], [233, 1.8707867, 11.0410833, 32.189474], [215, 1.8707867, 11.0396948, 32.189474], [224, 1.8707867, 11.0396948, 32.189474], [260, 1.8707867, 11.0369205, 32.189474], [296, 195.43379, 11.0396986, 32.421783], [287, 195.43379, 11.0396986, 32.421783], [278, 195.43379, 11.0396986, 32.421783], [269, 195.43379, 11.0424747, 32.421783], [260, 195.43379, 11.0396986, 32.421783], [251, 195.43379, 11.0396986, 32.421783], [242, 195.43379, 11.0396986, 32.421783], [233, 195.43379, 11.0396986, 32.421783], [224, 195.43379, 11.0396986, 32.421783], [215, 195.43379, 11.0410872, 32.421783]]
		}, {
			"name":"3.3k \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_3.3k.svg",
			"icon":"obsolete\/breadboard\/resistor_3.3k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"555 Timer",
			"description":"The classic 555 general purpose timer\/oscillator.",
			"image":"core\/breadboard\/555timerbreadboard.svg",
			"icon":"core\/breadboard\/555timerbreadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.34], [12.5, 27.66, 5, 6.34], [22.5, 27.66, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [22.5, -1, 5, 6.34], [12.5, -1, 5, 6.34], [2.5, -1, 5, 6.34]]
		}, {
			"name":"TRANSISTOR_NPN",
			"description":"Generic NPN BJT.MMBT2222 is the common NPN we use.Double check against datasheet-not all devices are the same!",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot23-3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot23-3_breadboard.svg",
			"width":"259.118",
			"height":"400",
			"points": [[62.5941, 333.05, 33.93, 33.9], [162.594, 333.05, 33.93, 33.9], [162.594, 33.05, 33.93, 33.9]]
		}, {
			"name":"LSM303DLH",
			"description":"I2C accelerometer\/magnetometer\/tilt compensated compass",
			"image":"core\/breadboard\/sparkfun-sensors_lga28-5x5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga28-5x5_breadboard.svg",
			"width":"1400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic female header-metal rounded-11 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_11.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_11.svg",
			"width":"78.969",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783], [15.556, 1.197, 4.783, 4.783], [22.735, 1.197, 4.783, 4.783], [29.914, 1.197, 4.783, 4.783], [37.093, 1.197, 4.783, 4.783], [44.272, 1.197, 4.783, 4.783], [51.451, 1.197, 4.783, 4.783], [58.63, 1.197, 4.783, 4.783], [65.809, 1.197, 4.783, 4.783], [72.988, 1.197, 4.783, 4.783]]
		}, {
			"name":"Reed switch",
			"description":"Reed switch",
			"image":"core\/breadboard\/reed_switch_leg.svg",
			"icon":"core\/breadboard\/reed_switch_leg.svg",
			"width":"45.002",
			"height":"8.004",
			"points": [[-1, 1.937, 3, 3], [39.642, 1.936, 3, 3]]
		}
	]
},
{
	"page":"4",
	"count": 37,
	"el": [{
			"name":"Battery Holders",
			"description":"Battery HoldersVarious common sizes: AA, AAA, 20mm coin cell and 12mm coin cell.",
			"image":"core\/breadboard\/sparkfun-electromechanical_battcon_245mm_pth_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_battcon_245mm_pth_breadboard.svg",
			"width":"97.646",
			"height":"100.8",
			"points": [[46.674, 95.052, 4.299, 4.297], [46.674, 1.451, 4.299, 4.297]]
		}, {
			"name":"ATTINY45",
			"description":"Atmel 8-pin 2\/4\/8kB flash uC",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Header 5x2",
			"description":"Header 5x2Standard 10-pin dual row 0.1 header.Commonly used with AVR-ISP.Use with Spark Fun Electronics SKU: PRT-00778",
			"image":"core\/breadboard\/sparkfun-connectors_2x5-shrouded_smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_2x5-shrouded_smd_breadboard.svg",
			"width":"57.6",
			"height":"36.918",
			"points": [[12.239, 17.928, 4.296, 4.296], [19.439, 17.928, 4.296, 4.296], [26.639, 17.929, 4.296, 4.296], [33.841, 17.928, 4.296, 4.296], [41.04, 17.928, 4.296, 4.296], [12.239, 25.129, 4.296, 4.296], [19.439, 25.129, 4.296, 4.296], [26.639, 25.129, 4.296, 4.296], [33.841, 25.129, 4.296, 4.296], [41.04, 25.129, 4.296, 4.296]]
		}, {
			"name":"TMP36",
			"description":"Precision degC temp sensor, analog out",
			"image":"core\/breadboard\/tmp36.svg",
			"icon":"core\/breadboard\/tmp36.svg",
			"width":"16.527",
			"height":"24.081",
			"points": [[-1, 21.081, 4.16, 3], [6.181, 21.081, 4.16, 3], [13.367, 21.081, 4.16, 3]]
		}, {
			"name":"DS1302",
			"description":"DS1302 SPI Real Time Clock",
			"image":"core\/breadboard\/DS1302_breadboard.svg",
			"icon":"core\/breadboard\/DS1302_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"Digital Panel Meter, Voltage, DMS-20PC",
			"description":"Digital panel meter by Murata.DMS-20PC class.Can be used for displaying a voltage measurement.Extremely simple to set up and use, extremely accurate.With voltage scaling, can be used in a wide variety of applications.Different color LEDs can be used(blue is shown).Available on Digikey.DMS-20PC Series, 31 \ u20442 Digit, LED Display, Digital Panel Voltmeters combine a preci-sion A\/D converter; a factory-trimmed, highly stable, voltage reference; and a large(0.37 \"\  / 9.4mm), easy-to-read LED display in a single package that is only slightly larger than the display itself.Displays are offered in either red, orange, amber, yellow, green or blue colors.High-intensity and low-power(35mW total)red LEDs are also optional.These low-cost meters are fully self-contained and fully functional.Their subminiature(1.38 \"x 0.88\"x 0.48\"), epoxy-encapsulated cases incorporate built-in color filters and bezels; are moisture and vibration proof; and function well in the harshest environments. Their 12-pin, dual-in-line configuration offers component-like, plug-in convenience and maximum versatility. Operating temperature range is 0 to +60\u00b0C.The meters come with one of four, differential, input voltage ranges: \u00b1200mV, \u00b12V \u00b120V or \u00b1200V. Input impedance is a minimum 800k\u03a9. CMRR is typically 86dB (dc to 60Hz), and CMV is \u00b12V. Input overvoltage protection (on the non-inverting input) is \u00b1250V. Devices are fully calibrated at the factory to an accuracy of \u00b11 count (\u00b10.05% of full scale range) and never require calibration or adjustment.A DISPLAY ENABLE function permits the display to be disabled for \"power-down\"operation. All models have a DISPLAY TEST function. Standard red LED models offer an optional DISPLAY HOLD function.Small size, low cost and adjustment-free reliability make the DMS-20PC Series the best choice for all your 31\u20442 digit, LED, DPM applications.",
			"image":"core\/breadboard\/Digital_Panel_Meter__Voltage__DMS_20PC__.svg",
			"icon":"core\/breadboard\/Digital_Panel_Meter__Voltage__DMS_20PC__.svg",
			"width":"109.167",
			"height":"72",
			"points": [[13.887, 16.142, 4.16, 4.16], [13.887, 23.342, 4.16, 4.16], [13.887, 30.542, 4.16, 4.16], [13.887, 37.743, 4.16, 4.159], [13.887, 44.943, 4.16, 4.16], [13.887, 52.143, 4.16, 4.16], [93.087, 16.142, 4.16, 4.16], [93.087, 23.342, 4.16, 4.16], [93.087, 30.542, 4.16, 4.16], [93.087, 37.743, 4.16, 4.159], [93.087, 44.943, 4.16, 4.16], [93.087, 52.143, 4.16, 4.16]]
		}, {
			"name":"USB connector",
			"description":"USB connector",
			"image":"core\/breadboard\/usb_connector.svg",
			"icon":"core\/breadboard\/usb_connector.svg",
			"width":"67.502",
			"height":"42.52",
			"points": [[59.644, 31.178, 4.16, 7.372], [52.496, 4.002, 4.16, 7.309], [59.644, 4.002, 4.16, 7.309], [52.506, 31.178, 4.159, 7.372], [52.506, 31.178, 4.159, 7.372], [52.506, 31.178, 4.159, 7.372]]
		}, {
			"name":"STARBOARD_PWR",
			"description":"StarbBoard Power padPower pads are designated by the star cutout in the top layer.",
			"image":"core\/breadboard\/sparkfun-connectors_starboard_pwr_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_starboard_pwr_breadboard.svg",
			"width":"458",
			"height":"1400",
			"points": [[212.035, 1333.05, 33.93, 33.9]]
		}, {
			"name":"7-Segment LED Display",
			"description":"",
			"image":"core\/breadboard\/7-segment display.svg",
			"icon":"core\/breadboard\/7-segment display.svg",
			"width":"34.632",
			"height":"52.92",
			"points": [[0.911, -0.994, 4.152, 5.141], [8.07, -0.994, 4.153, 5.141], [15.27, -0.994, 4.151, 5.141], [22.43, -0.994, 4.151, 5.141], [29.58, -0.994, 4.15, 5.141], [29.57, 48.78, 4.151, 5.14], [22.4, 48.78, 4.15, 5.14], [15.211, 48.78, 4.15, 5.14], [8.05, 48.78, 4.153, 5.14], [0.911, 48.78, 4.152, 5.14]]
		}, {
			"name":"Arduino MicroSD Shield",
			"description":"\tAfter taking a figurative lashing from the comments section we're begging for mercy by updating the microSD Shield board. All new microSD shields have a voltage converter chip on-board that converts the Arduino 5V signals to 3.3V signals in accordance with SD specifications. No more 'blown up' SD cards!\tRunning out of memory space in your Arduino project? The microSD Shield equips your Arduino with mass-storage capability, so you can use it for data-logging or other related projects. A microSD quickstart guide is available!\tCommunication with microSD cards is achieved over an SPI interface. The SCK, DI, and DO pins of the microSD socket are broken out to the ATmega168\/328's standard SPI pins (digital 11-13), while the CS pin is broken out to Arduino's D8 pin. If you decide to use one of the many open source FAT libraries (like FAT16 or SDFat) make sure to change the code to reflect the location of the CS pin. Most libraries assume the CS pin is connected to D10; this will have to be changed to D8. Also for the libraries to work pin D10 will have to be set as an output in the 'setup()' section of your sketch. The shield also includes a large prototyping area with a 13x12 grid of 0.1' pitch PTHs.\tThis shield comes populated with a microSD socket,red power indicator LED, and a reset button; but it does not come with headers installed.We recommend the 6 and 8-pin stackable headers.\t\tDocuments: \t\t\tmicroSD Quickstart Guide\t\t\tExample sketch\t\t\tSchematic\t\t\tEagle Files\t\t\tFAT16 Library(Unzip this folder in the Arduino Libraries Folder.Once unzipped you can find an example by going to File->Examples->FAT->FAT_Example in Arduino.You must re-open Arduino after unzipping the folder.",
			"image":"core\/breadboard\/microSD_Shield-v13_breadboard.svg",
			"icon":"core\/breadboard\/microSD_Shield-v13_breadboard.svg",
			"width":"151.2",
			"height":"177.477",
			"points": [[18.548, 11.348, 6.104, 6.104], [18.548, 18.548, 6.104, 6.104], [18.548, 25.748, 6.104, 6.104], [18.548, 32.948, 6.104, 6.104], [18.548, 40.148, 6.104, 6.104], [18.548, 47.348, 6.104, 6.104], [18.548, 54.548, 6.104, 6.104], [18.548, 61.748, 6.104, 6.104], [18.548, 72.548, 6.104, 6.104], [18.548, 79.748, 6.104, 6.104], [18.548, 86.948, 6.104, 6.104], [18.548, 94.148, 6.104, 6.104], [18.548, 101.348, 6.104, 6.104], [18.548, 108.548, 6.104, 6.104], [18.548, 115.748, 6.104, 6.104], [18.548, 122.948, 6.104, 6.104], [126.548, 47.348, 6.104, 6.104], [126.548, 40.148, 6.104, 6.104], [126.548, 32.948, 6.104, 6.104], [126.548, 25.748, 6.104, 6.104], [126.548, 18.548, 6.104, 6.104], [126.548, 11.348, 6.104, 6.104], [126.548, 97.748, 6.104, 6.104], [126.548, 90.548, 6.104, 6.104], [126.548, 83.348, 6.104, 6.104], [126.548, 76.148, 6.104, 6.104], [126.548, 68.948, 6.104, 6.104], [126.548, 61.748, 6.104, 6.104], [140.948, 90.548, 6.104, 6.104], [140.948, 83.348, 6.104, 6.104], [140.948, 47.348, 6.104, 6.104], [140.948, 40.148, 6.104, 6.104], [140.948, 32.948, 6.104, 6.104], [140.948, 25.748, 6.104, 6.104], [140.948, 18.548, 6.104, 6.104], [140.948, 11.348, 6.104, 6.104], [4.148, 122.948, 6.104, 6.104], [4.148, 25.748, 6.104, 6.104], [4.148, 32.948, 6.104, 6.104], [4.148, 40.148, 6.104, 6.104], [4.148, 47.348, 6.104, 6.104], [4.148, 54.548, 6.104, 6.104], [4.148, 61.748, 6.104, 6.104], [4.148, 72.548, 6.104, 6.104], [4.148, 79.748, 6.104, 6.104], [4.148, 86.948, 6.104, 6.104], [4.148, 94.148, 6.104, 6.104], [4.148, 101.348, 6.104, 6.104], [4.148, 108.548, 6.104, 6.104], [140.948, 76.148, 6.104, 6.104], [140.948, 68.948, 6.104, 6.104], [4.148, 115.748, 6.104, 6.104], [140.948, 97.748, 6.104, 6.104], [4.148, 11.348, 6.104, 6.104], [4.148, 18.548, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [29.348, 14.948, 6.104, 6.104], [115.748, 22.148, 6.104, 6.104], [108.548, 22.148, 6.104, 6.104], [101.348, 22.148, 6.104, 6.104], [94.148, 22.148, 6.104, 6.104], [86.948, 22.148, 6.104, 6.104], [79.748, 22.148, 6.104, 6.104], [72.548, 22.148, 6.104, 6.104], [65.348, 22.148, 6.104, 6.104], [58.148, 22.148, 6.104, 6.104], [50.948, 22.148, 6.104, 6.104], [43.748, 22.148, 6.104, 6.104], [36.548, 22.148, 6.104, 6.104], [29.348, 22.148, 6.104, 6.104], [29.348, 29.348, 6.104, 6.104], [36.548, 29.348, 6.104, 6.104], [43.748, 29.348, 6.104, 6.104], [50.948, 29.348, 6.104, 6.104], [58.148, 29.348, 6.104, 6.104], [65.348, 29.348, 6.104, 6.104], [72.548, 29.348, 6.104, 6.104], [79.748, 29.348, 6.104, 6.104], [86.948, 29.348, 6.104, 6.104], [94.148, 29.348, 6.104, 6.104], [101.348, 29.348, 6.104, 6.104], [108.548, 29.348, 6.104, 6.104], [115.748, 29.348, 6.104, 6.104], [115.748, 36.548, 6.104, 6.104], [108.548, 36.548, 6.104, 6.104], [101.348, 36.548, 6.104, 6.104], [94.148, 36.548, 6.104, 6.104], [86.948, 36.548, 6.104, 6.104], [79.748, 36.548, 6.104, 6.104], [72.548, 36.548, 6.104, 6.104], [65.348, 36.548, 6.104, 6.104], [58.148, 36.548, 6.104, 6.104], [50.948, 36.548, 6.104, 6.104], [43.748, 36.548, 6.104, 6.104], [36.548, 36.548, 6.104, 6.104], [29.348, 36.548, 6.104, 6.104], [29.348, 43.748, 6.104, 6.104], [36.548, 43.748, 6.104, 6.104], [43.748, 43.748, 6.104, 6.104], [50.948, 43.748, 6.104, 6.104], [58.148, 43.748, 6.104, 6.104], [65.348, 43.748, 6.104, 6.104], [72.548, 43.748, 6.104, 6.104], [79.748, 43.748, 6.104, 6.104], [86.948, 43.748, 6.104, 6.104], [94.148, 43.748, 6.104, 6.104], [101.348, 43.748, 6.104, 6.104], [108.548, 43.748, 6.104, 6.104], [115.748, 43.748, 6.104, 6.104], [115.748, 50.948, 6.104, 6.104], [108.548, 50.948, 6.104, 6.104], [101.348, 50.948, 6.104, 6.104], [94.148, 50.948, 6.104, 6.104], [86.948, 50.948, 6.104, 6.104], [79.748, 50.948, 6.104, 6.104], [72.548, 50.948, 6.104, 6.104], [65.348, 50.948, 6.104, 6.104], [58.148, 50.948, 6.104, 6.104], [50.948, 50.948, 6.104, 6.104], [43.748, 50.948, 6.104, 6.104], [36.548, 50.948, 6.104, 6.104], [29.348, 50.948, 6.104, 6.104], [29.348, 58.148, 6.104, 6.104], [36.548, 58.148, 6.104, 6.104], [43.748, 58.148, 6.104, 6.104], [50.948, 58.148, 6.104, 6.104], [58.148, 58.148, 6.104, 6.104], [65.348, 58.148, 6.104, 6.104], [72.548, 58.148, 6.104, 6.104], [79.748, 58.148, 6.104, 6.104], [86.948, 58.148, 6.104, 6.104], [94.148, 58.148, 6.104, 6.104], [101.348, 58.148, 6.104, 6.104], [108.548, 58.148, 6.104, 6.104], [115.748, 58.148, 6.104, 6.104], [115.748, 65.348, 6.104, 6.104], [108.548, 65.348, 6.104, 6.104], [101.348, 65.348, 6.104, 6.104], [94.148, 65.348, 6.104, 6.104], [86.948, 65.348, 6.104, 6.104], [79.748, 65.348, 6.104, 6.104], [72.548, 65.348, 6.104, 6.104], [65.348, 65.348, 6.104, 6.104], [58.148, 65.348, 6.104, 6.104], [50.948, 65.348, 6.104, 6.104], [43.748, 65.348, 6.104, 6.104], [36.548, 65.348, 6.104, 6.104], [29.348, 65.348, 6.104, 6.104], [29.348, 72.548, 6.104, 6.104], [36.548, 72.548, 6.104, 6.104], [43.748, 72.548, 6.104, 6.104], [50.948, 72.548, 6.104, 6.104], [58.148, 72.548, 6.104, 6.104], [65.348, 72.548, 6.104, 6.104], [72.548, 72.548, 6.104, 6.104], [79.748, 72.548, 6.104, 6.104], [86.948, 72.548, 6.104, 6.104], [94.148, 72.548, 6.104, 6.104], [101.348, 72.548, 6.104, 6.104], [108.548, 72.548, 6.104, 6.104], [115.748, 72.548, 6.104, 6.104], [115.748, 79.748, 6.104, 6.104], [108.548, 79.748, 6.104, 6.104], [101.348, 79.748, 6.104, 6.104], [94.148, 79.748, 6.104, 6.104], [86.948, 79.748, 6.104, 6.104], [79.748, 79.748, 6.104, 6.104], [72.548, 79.748, 6.104, 6.104], [65.348, 79.748, 6.104, 6.104], [58.148, 79.748, 6.104, 6.104], [50.948, 79.748, 6.104, 6.104], [43.748, 79.748, 6.104, 6.104], [36.548, 79.748, 6.104, 6.104], [29.348, 79.748, 6.104, 6.104], [29.348, 86.948, 6.104, 6.104], [36.548, 86.948, 6.104, 6.104], [43.748, 86.948, 6.104, 6.104], [50.948, 86.948, 6.104, 6.104], [58.148, 86.948, 6.104, 6.104], [65.348, 86.948, 6.104, 6.104], [72.548, 86.948, 6.104, 6.104], [79.748, 86.948, 6.104, 6.104], [86.948, 86.948, 6.104, 6.104], [94.148, 86.948, 6.104, 6.104], [101.348, 86.948, 6.104, 6.104], [108.548, 86.948, 6.104, 6.104], [115.748, 86.948, 6.104, 6.104], [115.748, 94.148, 6.104, 6.104], [108.548, 94.148, 6.104, 6.104], [101.348, 94.148, 6.104, 6.104], [94.148, 94.148, 6.104, 6.104], [86.948, 94.148, 6.104, 6.104], [79.748, 94.148, 6.104, 6.104], [72.548, 94.148, 6.104, 6.104], [65.348, 94.148, 6.104, 6.104], [58.148, 94.148, 6.104, 6.104], [50.948, 94.148, 6.104, 6.104], [43.748, 94.148, 6.104, 6.104], [36.548, 94.148, 6.104, 6.104], [29.348, 94.148, 6.104, 6.104], [29.348, 101.348, 6.104, 6.104], [36.548, 101.348, 6.104, 6.104], [43.748, 101.348, 6.104, 6.104], [50.948, 101.348, 6.104, 6.104], [58.148, 101.348, 6.104, 6.104], [65.348, 101.348, 6.104, 6.104], [72.548, 101.348, 6.104, 6.104], [79.748, 101.348, 6.104, 6.104], [86.948, 101.348, 6.104, 6.104], [94.148, 101.348, 6.104, 6.104], [101.348, 101.348, 6.104, 6.104], [108.548, 101.348, 6.104, 6.104], [115.748, 101.348, 6.104, 6.104], [36.548, 14.948, 6.104, 6.104], [43.748, 14.948, 6.104, 6.104], [50.948, 14.948, 6.104, 6.104], [58.148, 14.948, 6.104, 6.104], [65.348, 14.948, 6.104, 6.104], [72.548, 14.948, 6.104, 6.104], [79.748, 14.948, 6.104, 6.104], [86.948, 14.948, 6.104, 6.104], [94.148, 14.948, 6.104, 6.104], [101.348, 14.948, 6.104, 6.104], [108.548, 14.948, 6.104, 6.104], [115.748, 14.948, 6.104, 6.104]]
		}, {
			"name":"Mystery Part-20 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 20 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part20.svg",
			"icon":"obsolete\/breadboard\/mystery_part20.svg",
			"width":"202",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002], [52.5, 24.672941, 5, 6.3400002], [62.5, 24.672941, 5, 6.3400002], [72.5, 24.672941, 5, 6.3400002], [82.5, 24.672941, 5, 6.3400002], [92.5, 24.672941, 5, 6.3400002], [102.5, 24.672941, 5, 6.3400002], [112.5, 24.672941, 5, 6.3400002], [122.5, 24.672941, 5, 6.3400002], [132.5, 24.672941, 5, 6.3400002], [142.5, 24.672941, 5, 6.3400002], [152.5, 24.672941, 5, 6.3400002], [162.5, 24.672941, 5, 6.3400002], [172.5, 24.672941, 5, 6.3400002], [182.5, 24.672941, 5, 6.3400002], [192.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"RCA",
			"description":"",
			"image":"core\/breadboard\/sparkfun-connectors_rca_lock_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_rca_lock_breadboard.svg",
			"width":"663.139",
			"height":"1000",
			"points": [[264.605, 933.05, 33.93, 33.9], [364.605, 933.05, 33.93, 33.9], [364.605, 33.05, 33.93, 33.9]]
		}, {
			"name":"BATTERY-2",
			"description":"AA and AAA battery holders",
			"image":"core\/breadboard\/sparkfun-electromechanical_battery-aa_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_battery-aa_breadboard.svg",
			"width":"154.08",
			"height":"37.904",
			"points": [[22.664, 14.963, 7.976, 7.976], [1.783, 14.963, 7.976, 7.976], [123.464, 14.963, 7.976, 7.976], [144.343, 14.963, 7.976, 7.976]]
		}, {
			"name":"Mystery Part-8 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 8 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part8.svg",
			"icon":"obsolete\/breadboard\/mystery_part8.svg",
			"width":"82",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002], [52.5, 24.672941, 5, 6.3400002], [62.5, 24.672941, 5, 6.3400002], [72.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"FKIT-RIBBON_CONNECTOR",
			"description":"fabrick.it Conductive Ribbon Connector",
			"image":"core\/breadboard\/sparkfun-electromechanical_fkit-ribbon_connector_03_2mm_r_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_fkit-ribbon_connector_03_2mm_r_breadboard.svg",
			"width":"500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"LMD1820X",
			"description":"LMD1820X H-Bridge-BOB-00747",
			"image":"core\/breadboard\/sparkfun-poweric_to-220-11lead_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_to-220-11lead_breadboard.svg",
			"width":"20.2232",
			"height":"10.4216",
			"points": [[1.5516, 2.6416, 3.5, 3.5], [4.9516, 2.6416, 3.5, 3.5], [8.3516, 2.6416, 3.5, 3.5], [11.7516, 2.6416, 3.5, 3.5], [15.1516, 2.6416, 3.5, 3.5], [-0.1484, 7.7216, 3.5, 3.5], [3.2516, 7.7216, 3.5, 3.5], [6.6516, 7.7216, 3.5, 3.5], [10.0516, 7.7216, 3.5, 3.5], [13.4516, 7.7216, 3.5, 3.5], [16.8516, 7.7216, 3.5, 3.5]]
		}, {
			"name":"MIC2571",
			"description":"Single Cell Switching Regulator-MIC2571",
			"image":"core\/breadboard\/sparkfun-poweric_msop-8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_msop-8_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"linino dogUSB",
			"description":"A type USB connector.Fully compliant with USB Hub specification version 2.0 and is also backward compatible withUSB Hub specification 1.1.Supports automatic switching between bus-power and self-power modes built-in USB 2.0 transceiver.uSD connector with card reader.Supports multiple sectors transfer optimize performance.Supports port-to-slot and read\/write operation.",
			"image":"core\/breadboard\/linino_dogUSB_breadboard.svg",
			"icon":"core\/breadboard\/linino_dogUSB_breadboard.svg",
			"width":"117.641",
			"height":"64.828",
			"points": [[333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [8.738, 0.813, 5.624, 5.624], [23.03, 0.813, 5.624, 5.624], [51.94, 0.813, 5.624, 5.624], [59.141, 0.815, 5.624, 5.624], [59.165, 58.416, 5.624, 5.624], [44.765, 58.414, 5.624, 5.624], [30.363, 58.414, 5.624, 5.624]]
		}, {
			"name":"EDGY",
			"description":"The EDGY motor control is a L293DD breakout board for the use on a breadboard.",
			"image":"core\/breadboard\/EDGY_motor_control.svg",
			"icon":"core\/breadboard\/EDGY_motor_control.svg",
			"width":"75.6",
			"height":"86.4",
			"points": [[63.585, 40.187, 6.104, 6.104], [63.585, 47.387, 6.104, 6.104], [63.585, 76.188, 6.104, 6.104], [56.385, 76.188, 6.104, 6.104], [49.185, 76.188, 6.104, 6.104], [34.784, 76.188, 6.104, 6.104], [20.384, 76.188, 6.104, 6.104], [13.184, 76.188, 6.104, 6.104], [5.983, 40.187, 6.104, 6.104], [5.983, 47.387, 6.104, 6.104], [5.983, 76.188, 6.104, 6.104], [26.005, 9.801, 6.104, 6.104], [16.501, 9.801, 6.104, 6.104], [53.005, 9.801, 6.104, 6.104], [43.501, 9.801, 6.104, 6.104]]
		}, {
			"name":"atmega168 smd",
			"description":"Atmel ATmega168 microcontroller.The hardware hacker favorite.",
			"image":"core\/breadboard\/smd_atmega168.svg",
			"icon":"core\/breadboard\/smd_atmega168.svg",
			"width":"115.195",
			"height":"28.799",
			"points": [[1.318, 22.97, 4.296, 4.297], [8.517, 22.97, 4.296, 4.297], [15.716, 22.97, 4.298, 4.297], [22.917, 22.97, 4.296, 4.297], [30.117, 22.97, 4.296, 4.297], [37.317, 22.97, 4.296, 4.297], [44.516, 22.97, 4.296, 4.297], [51.715, 22.97, 4.298, 4.297], [58.916, 22.97, 4.297, 4.297], [66.115, 22.97, 4.297, 4.297], [73.315, 22.97, 4.297, 4.297], [80.516, 22.97, 4.297, 4.297], [87.716, 22.97, 4.299, 4.297], [94.916, 22.97, 4.297, 4.297], [102.115, 22.97, 4.297, 4.297], [109.314, 22.97, 4.297, 4.297], [109.314, 1.373, 4.297, 4.296], [102.115, 1.373, 4.297, 4.296], [94.916, 1.373, 4.297, 4.296], [87.716, 1.373, 4.299, 4.296], [80.516, 1.373, 4.297, 4.296], [73.315, 1.373, 4.297, 4.296], [66.115, 1.373, 4.297, 4.296], [58.916, 1.373, 4.297, 4.296], [51.715, 1.373, 4.298, 4.296], [44.516, 1.373, 4.296, 4.296], [37.317, 1.373, 4.296, 4.296], [30.117, 1.373, 4.296, 4.296], [22.917, 1.373, 4.296, 4.296], [15.716, 1.373, 4.298, 4.296], [8.517, 1.373, 4.296, 4.296], [1.318, 1.373, 4.296, 4.296]]
		}, {
			"name":"Digital Temperature Sensor Breakout-TMP102",
			"description":"This is a breakout board for the incredibly small TMP102 digital temperature sensor.The TMP102 is a digital sensor(I2C a.k.a.TWI), has a resolution of 0.0625°C, and is accurate up to 0.5°C.The sensor requires very low-current, and is loaded with features.\tCommunication with the TMP102 is achieved through a two-wire serial interface.There is no on-board voltage regulator, so supplied voltage should be between 1.4 to 3.6VDC.Filtering capacitors and pull-up resistors are included as shown.\tFeatures: \t\t\t12-bit, 0.0625°C resolution\t\t\tAccuracy: 0.5°C(-25°C to + 85°C)\t\t\tLow quiescent current\t\t\t\t\t\t\t\t\t10µA Active(max)\t\t\t\t\t\t\t1µA Shutdown(max)\t\t\t\t\t\t1.4V to 3.6VDC supply range\t\t\tTwo-wire serial interface\tDocuments: \t\t\tSchematic\t\t\tTMP102 Datasheet\t\t\tExample Code(ATmega328)\t\t\tWiring Example\t\t\tmbed Example\t\t\tbildr blog-TMP102",
			"image":"core\/breadboard\/TMP102_Breakout-v11_breadboard.svg",
			"icon":"core\/breadboard\/TMP102_Breakout-v11_breadboard.svg",
			"width":"28.8",
			"height":"36",
			"points": [[0.548, 29.348, 6.104, 6.104], [7.748, 29.348, 6.104, 6.104], [14.948, 29.348, 6.104, 6.104], [22.148, 29.348, 6.104, 6.104], [14.948, 0.548, 6.104, 6.104], [7.748, 0.548, 6.104, 6.104]]
		}, {
			"name":"Toggle Switch",
			"description":"Toggle Switch",
			"image":"core\/breadboard\/basic_toggle_switch.svg",
			"icon":"core\/breadboard\/basic_toggle_switch.svg",
			"width":"36.998",
			"height":"37.592",
			"points": [[5.033, 28.32, 4.52, 9.438], [15.032, 28.32, 4.521, 9.438], [25.03, 28.32, 4.521, 9.438]]
		}, {
			"name":"7 Segment Display",
			"description":"7 Segment Display with common cathode.",
			"image":"core\/breadboard\/7segment_9,9.svg",
			"icon":"core\/breadboard\/7segment_9,9.svg",
			"width":"30",
			"height":"38",
			"points": [[1.474, 2.127, 3.8, 3.799], [1.473, 9.326, 3.8, 3.799], [1.473, 16.525, 3.8, 3.799], [1.473, 23.727, 3.8, 3.799], [1.473, 30.926, 3.8, 3.799], [23.073, 2.127, 3.8, 3.799], [23.073, 9.326, 3.8, 3.799], [23.073, 16.525, 3.8, 3.799], [23.073, 23.727, 3.8, 3.799], [23.073, 30.926, 3.8, 3.799]]
		}, {
			"name":"Super Flux RGB LED(com.cathode)",
			"description":"A full color SuperFlux LED.",
			"image":"core\/breadboard\/led-superFlux-rgb.svg",
			"icon":"core\/breadboard\/led-superFlux-rgb.svg",
			"width":"22.5",
			"height":"22.5",
			"points": [[1.779, 2.606, 5.6, 3.802], [16.18, 2.608, 5.6, 3.801], [16.18, 17.007, 5.6, 3.802], [1.779, 17.007, 5.6, 3.802]]
		}, {
			"name":"RESONATOR_NOCAP",
			"description":"",
			"image":"core\/breadboard\/sparkfun-freqctrl_resonator_nocap_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-freqctrl_resonator_nocap_breadboard.svg",
			"width":"292.52",
			"height":"600",
			"points": [[129.295, 533.05, 33.93, 33.9], [129.295, 33.05, 33.93, 33.9]]
		}, {
			"name":"chipKIT \ u2122Pro MX4",
			"description":"The chipKIT \ u2122 Pro MX4 is a microcontroller development board based on the Microchip PIC32MX460F512L, a member of the 32-bit PIC32 microcontroller family.It is compatible with Digilent \ u2019s line of Pmod \ u2122 peripheral modules, and is suitable for use with the Microchip MPLAB \ u00ae IDE tools.The chipKIT Pro MX4 is also compatible for use with the chipKIT \ u2122 MPIDE development environment.ChipKIT and MPIDE is a PIC32 based system compatible with many existing Arduino \ u2122 code examples, reference materials and other resources. \ u00a0 The chipKIT Pro MX4 is designed to be easy to use and suitable for use by anyone from beginners to advanced users for experimenting with electronics and embedded control systems.A built in programming\/debugging circuit compatible with the Microchip MPLAB \ u00ae IDE is provided on the board, so no additional hardware is required for use with MPLAB.The kit contains everything needed to start developing embedded applications using either the MPLAB \ u00ae IDE or the MPIDE. \ u00a0 The chipKIT Pro MX4 provides 74 I\/O pins that support a number of peripheral functions, such as USB controller, UART, SPI and I2C \ u2122 ports as well as five pulse width modulated outputs and five external interrupt inputs.Fifteen of the I\/O pins can be used as analog inputs in addition to their use as digital inputs and outputs.. \ u00a0 The chipKIT Pro MX4 can be powered via USB, or an external power supply that may be either an AC-DC power adapter, or batteries.",
			"image":"core\/breadboard\/chipkit_MX4_breadboard.svg",
			"icon":"core\/breadboard\/chipkit_MX4_breadboard.svg",
			"width":"309.969",
			"height":"273.599",
			"points": [[136.318, 259.765, 5.6, 5.6], [114.716, 259.765, 5.6, 5.6], [129.119, 259.765, 5.6, 5.6], [121.918, 259.765, 5.6, 5.6], [107.517, 259.765, 5.6, 5.6], [101.216, 259.765, 5.6, 5.6], [136.318, 266.765, 5.6, 5.6], [114.716, 266.765, 5.6, 5.6], [129.119, 266.765, 5.6, 5.6], [121.918, 266.765, 5.6, 5.6], [107.517, 266.765, 5.6, 5.6], [101.216, 266.765, 5.6, 5.6], [204.719, 259.765, 5.6, 5.6], [183.117, 259.765, 5.6, 5.6], [197.52, 259.765, 5.6, 5.6], [190.319, 259.765, 5.6, 5.6], [175.917, 259.765, 5.6, 5.6], [169.617, 259.765, 5.6, 5.6], [204.719, 266.765, 5.6, 5.6], [183.117, 266.765, 5.6, 5.6], [197.52, 266.765, 5.6, 5.6], [190.319, 266.765, 5.6, 5.6], [175.917, 266.765, 5.6, 5.6], [169.617, 266.765, 5.6, 5.6], [270.801, 259.765, 5.6, 5.6], [249.199, 259.765, 5.6, 5.6], [263.602, 259.765, 5.6, 5.6], [256.401, 259.765, 5.6, 5.6], [242, 259.765, 5.6, 5.6], [235.699, 259.765, 5.6, 5.6], [270.801, 266.765, 5.6, 5.6], [249.199, 266.765, 5.6, 5.6], [263.602, 266.765, 5.6, 5.6], [256.401, 266.765, 5.6, 5.6], [242, 266.765, 5.6, 5.6], [235.699, 266.765, 5.6, 5.6], [72.351, 1.083, 5.6, 5.6], [50.749, 1.083, 5.6, 5.6], [65.152, 1.083, 5.6, 5.6], [57.951, 1.083, 5.6, 5.6], [43.549, 1.083, 5.6, 5.6], [37.249, 1.083, 5.6, 5.6], [72.351, 8.083, 5.6, 5.6], [50.749, 8.083, 5.6, 5.6], [65.152, 8.083, 5.6, 5.6], [57.951, 8.083, 5.6, 5.6], [43.549, 8.083, 5.6, 5.6], [37.249, 8.083, 5.6, 5.6], [137.151, 0.799, 5.6, 5.6], [115.548, 0.799, 5.6, 5.6], [129.952, 0.799, 5.6, 5.6], [122.75, 0.799, 5.6, 5.6], [108.349, 0.799, 5.6, 5.6], [102.048, 0.799, 5.6, 5.6], [137.151, 7.799, 5.6, 5.6], [115.548, 7.799, 5.6, 5.6], [129.952, 7.799, 5.6, 5.6], [122.75, 7.799, 5.6, 5.6], [108.349, 7.799, 5.6, 5.6], [102.048, 7.799, 5.6, 5.6], [201.951, 0.799, 5.6, 5.6], [180.349, 0.799, 5.6, 5.6], [194.751, 0.799, 5.6, 5.6], [187.55, 0.799, 5.6, 5.6], [173.15, 0.799, 5.6, 5.6], [166.849, 0.799, 5.6, 5.6], [201.951, 7.799, 5.6, 5.6], [180.349, 7.799, 5.6, 5.6], [194.751, 7.799, 5.6, 5.6], [187.55, 7.799, 5.6, 5.6], [173.15, 7.799, 5.6, 5.6], [166.849, 7.799, 5.6, 5.6], [266.75, 0.799, 5.6, 5.6], [245.149, 0.799, 5.6, 5.6], [259.551, 0.799, 5.6, 5.6], [252.35, 0.799, 5.6, 5.6], [237.95, 0.799, 5.6, 5.6], [231.649, 0.799, 5.6, 5.6], [266.75, 7.799, 5.6, 5.6], [245.149, 7.799, 5.6, 5.6], [259.551, 7.799, 5.6, 5.6], [252.35, 7.799, 5.6, 5.6], [237.95, 7.799, 5.6, 5.6], [231.649, 7.799, 5.6, 5.6], [296.569, 51.649, 5.6, 5.6], [296.569, 73.251, 5.6, 5.6], [296.569, 58.849, 5.6, 5.6], [296.569, 66.05, 5.6, 5.6], [296.569, 80.45, 5.6, 5.6], [296.569, 86.751, 5.6, 5.6], [303.569, 51.649, 5.6, 5.6], [303.569, 73.251, 5.6, 5.6], [303.569, 58.849, 5.6, 5.6], [303.569, 66.05, 5.6, 5.6], [303.569, 80.45, 5.6, 5.6], [303.569, 86.751, 5.6, 5.6], [296.569, 116.45, 5.6, 5.6], [296.569, 138.051, 5.6, 5.6], [296.569, 123.649, 5.6, 5.6], [296.569, 130.85, 5.6, 5.6], [296.569, 145.25, 5.6, 5.6], [296.569, 151.551, 5.6, 5.6], [303.569, 116.45, 5.6, 5.6], [303.569, 138.051, 5.6, 5.6], [303.569, 123.649, 5.6, 5.6], [303.569, 130.85, 5.6, 5.6], [303.569, 145.25, 5.6, 5.6], [303.569, 151.551, 5.6, 5.6]]
		}, {
			"name":"uM-FPUv2",
			"description":"uM Floating Point Unit",
			"image":"core\/breadboard\/uM_FPUv2_breadboard.svg",
			"icon":"core\/breadboard\/uM_FPUv2_breadboard.svg",
			"width":"40.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34]]
		}, {
			"name":"STA540",
			"description":"The STA540 is a 4-channel, class AB audio amplifier designed for high quality sound applications.",
			"image":"core\/breadboard\/sparkfun-poweric_multiwatt15_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_multiwatt15_breadboard.svg",
			"width":"1155.04",
			"height":"1400",
			"points": [[210.556, 1333.05, 33.93, 33.9], [310.556, 1333.05, 33.93, 33.9], [310.556, 33.05, 33.93, 33.9], [410.556, 1333.05, 33.93, 33.9], [410.556, 33.05, 33.93, 33.9], [510.556, 1333.05, 33.93, 33.9], [510.556, 33.05, 33.93, 33.9], [610.556, 1333.05, 33.93, 33.9], [610.556, 33.05, 33.93, 33.9], [710.556, 1333.05, 33.93, 33.9], [710.556, 33.05, 33.93, 33.9], [810.556, 1333.05, 33.93, 33.9], [810.556, 33.05, 33.93, 33.9], [910.556, 1333.05, 33.93, 33.9], [910.556, 33.05, 33.93, 33.9]]
		}, {
			"name":"uM-FPUv3",
			"description":"uM Floating Point Unit",
			"image":"core\/breadboard\/uM_FPUv3_breadboard.svg",
			"icon":"core\/breadboard\/uM_FPUv3_breadboard.svg",
			"width":"900",
			"height":"330",
			"points": [[34, 285.6, 32, 45.4], [34, -1, 32, 45.4], [834, 285.6, 32, 45.4], [834, -1, 32, 45.4], [134, 285.6, 32, 45.4], [134, -1, 32, 45.4], [234, 285.6, 32, 45.4], [234, -1, 32, 45.4], [334, 285.6, 32, 45.4], [334, -1, 32, 45.4], [434, 285.6, 32, 45.4], [434, -1, 32, 45.4], [534, 285.6, 32, 45.4], [534, -1, 32, 45.4], [634, 285.6, 32, 45.4], [634, -1, 32, 45.4], [734, 285.6, 32, 45.4], [734, -1, 32, 45.4]]
		}, {
			"name":"LMV324",
			"description":"Jellybean quad op-amp",
			"image":"core\/breadboard\/SOIC-14_breadboard.svg",
			"icon":"core\/breadboard\/SOIC-14_breadboard.svg",
			"width":"50.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Aries 28-6574-10 28W ZIF Socket",
			"description":"Aries 28W ZIF socket(15.24mm bottom pin spacing)",
			"image":"core\/breadboard\/New_Aries_28W_ZIF4.svg",
			"icon":"core\/breadboard\/New_Aries_28W_ZIF4.svg",
			"width": 0,
			"height": 0,
			"points": [[148.17786635697, 5.5127724070905, 9.6316419559902, 27.750411149144], [139.37732132029, 5.3792275660146, 9.6316419559902, 27.538836577017], [130.05909716381, 5.1676529938875, 9.8042016625917, 27.922970855746], [121.25855212714, 5.340212700489, 9.4590822493887, 27.922970855746], [66.902244547677, 46.927101991443, 10.667000195599, 28.44064997555], [112.15190254279, 5.2066678594132, 9.5926270904646, 27.88395599022], [75.702789584352, 46.927101991443, 10.667000195599, 28.095530562347], [103.13978293399, 5.340212700489, 9.6316419559902, 27.750411149144], [84.675894327628, 46.927101991443, 10.8395599022, 28.785769388753], [94.166678190709, 5.340212700489, 9.6316419559902, 27.750411149144], [93.648999070905, 46.927101991443, 10.667000195599, 28.613209682152], [85.193573447433, 5.1676529938875, 9.8042016625917, 28.268090268949], [102.96722322738, 47.099661698044, 10.321880782396, 28.44064997555], [76.432043276284, 5.0341081528117, 9.765186797066, 28.229075403423], [112.32446224939, 47.311236270171, 9.765186797066, 27.538836577017], [67.113819119804, 4.9950932872861, 9.765186797066, 28.268090268949], [121.08599242054, 47.444781111247, 9.9767613691931, 28.095530562347], [130.23165687042, 47.272221404645, 9.4590822493888, 27.405291735941], [139.20476161369, 47.444781111247, 9.6316419559902, 27.405291735941], [148.35042606357, 47.272221404645, 9.4590822493888, 27.405291735941], [157.18998596577, 47.272221404645, 10.28286591687, 28.268090268949], [166.16309070905, 47.272221404645, 9.765186797066, 27.577851442543], [175.0971805868, 46.927101991443, 9.8042016625917, 28.44064997555], [183.936740489, 47.311236270171, 10.110306210269, 27.88395599022], [183.89772562347, 5.1676529938876, 10.149321075795, 27.922970855746], [175.2697402934, 5.340212700489, 9.6316419559902, 27.750411149144], [166.12407584352, 5.340212700489, 9.8042016625917, 28.095530562347], [157.15097110024, 5.340212700489, 9.6316419559902, 28.095530562347]]
		}, {
			"name":"DB25",
			"description":"Various DB25 connectors",
			"image":"core\/breadboard\/sparkfun-connectors_m25vb_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_m25vb_breadboard.svg",
			"width":"2300.46",
			"height":"600",
			"points": [[533.265, 533.05, 33.93, 33.9], [633.265, 533.05, 33.93, 33.9], [633.265, 33.05, 33.93, 33.9], [733.265, 533.05, 33.93, 33.9], [733.265, 33.05, 33.93, 33.9], [833.265, 533.05, 33.93, 33.9], [833.265, 33.05, 33.93, 33.9], [933.265, 533.05, 33.93, 33.9], [933.265, 33.05, 33.93, 33.9], [1033.26, 533.05, 33.93, 33.9], [1033.26, 33.05, 33.93, 33.9], [1133.26, 533.05, 33.93, 33.9], [1133.26, 33.05, 33.93, 33.9], [1233.26, 533.05, 33.93, 33.9], [1233.26, 33.05, 33.93, 33.9], [1333.26, 533.05, 33.93, 33.9], [1333.26, 33.05, 33.93, 33.9], [1433.26, 533.05, 33.93, 33.9], [1433.26, 33.05, 33.93, 33.9], [1533.27, 533.05, 33.93, 33.9], [1533.27, 33.05, 33.93, 33.9], [1633.27, 533.05, 33.93, 33.9], [1633.27, 33.05, 33.93, 33.9], [1733.27, 533.05, 33.93, 33.9], [1733.27, 33.05, 33.93, 33.9]]
		}, {
			"name":"MOSFET-PCHANNEL",
			"description":"Generic PMOSFET",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot23-3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot23-3_breadboard.svg",
			"width":"259.118",
			"height":"400",
			"points": [[62.5941, 333.05, 33.93, 33.9], [162.594, 333.05, 33.93, 33.9], [162.594, 33.05, 33.93, 33.9]]
		}, {
			"name":"X9015",
			"description":"Digital pot.up\/down\/increment control only",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Gas Sensor Breakout Board",
			"description":"Simple breakout board for the MQ-3, MQ-4, MQ-6 and MQ-7 gas sensors.All you need is VCC at 5V, GND, and a resistor to an ADC, that is it.\t\tNote: This is the PCB only.Sensors listed below.\t\tDimensions: 16.8mm diameter\t\tDocuments: \t\t\tSchematic\t\t\tWiring Example\t\t",
			"image":"core\/breadboard\/Gas_Sensor_Breakout-v12_breadboard.svg",
			"icon":"core\/breadboard\/Gas_Sensor_Breakout-v12_breadboard.svg",
			"width":"47.622",
			"height":"47.622",
			"points": [[11.443, 11.443, 5.744, 5.744], [11.443, 30.4351, 5.744, 5.744], [30.4351, 11.443, 5.744, 5.744], [30.4351, 30.4351, 5.744, 5.744], [7.4745, 20.939, 5.744, 5.744], [34.4036, 20.939, 5.744, 5.744], [24.539, 2.93903, 5.744, 5.744], [17.339, 2.93903, 5.744, 5.744], [17.339, 38.939, 5.744, 5.744], [24.539, 38.939, 5.744, 5.744]]
		}, {
			"name":"COMPUTER-PERIPHERAL-POWER",
			"description":"",
			"image":"core\/breadboard\/sparkfun-connectors_computer-peripheral-power-ra_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_computer-peripheral-power-ra_breadboard.svg",
			"width":"67.757",
			"height":"42.402",
			"points": [[36.444, 1.218, 9.13, 9.13], [50.707, 1.218, 9.13, 9.13], [22.182, 1.218, 9.13, 9.13], [7.92, 1.218, 9.13, 9.13]]
		}, {
			"name":"Bare Conductive Touch Board",
			"description":"The Touch Board is a microcontroller board based on the ATmega32u4.Use the Touch Board to change the world around you by turning almost any material or surface into a sensor.Connect anything conductive to one of its 12 electrodes and trigger a sound via its onboard MP3 player, play a MIDI note or do anything else that you might do with an Arduino or Arduino-compatible device.The Touch Board is designed as an easy-to-use platform for a huge range of projects, whether it \ u2019s painting a lightswitch on your wall, making a paper piano or creating a custom interactive surface.",
			"image":"core\/breadboard\/bareconductive_touchboard_breadboard.svg",
			"icon":"core\/breadboard\/bareconductive_touchboard_breadboard.svg",
			"width":"246.898",
			"height":"177.197",
			"points": [[9.315, 2.249, 10.284, 10.284], [9.315, 162.938, 10.284, 10.284], [29.776, 2.25, 10.282, 10.282], [50.236, 2.248, 10.284, 10.284], [70.698, 2.248, 10.284, 10.284], [91.16, 2.248, 10.284, 10.284], [111.62, 2.248, 10.284, 10.284], [132.08, 2.248, 10.284, 10.284], [152.542, 2.248, 10.284, 10.284], [173.003, 2.248, 10.284, 10.284], [193.464, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284], [213.925, 2.248, 10.284, 10.284]]
		}, {
			"name":"NPN-Transistor",
			"description":"A standard NPN-transistor",
			"image":"core\/breadboard\/transistor_npn.svg",
			"icon":"core\/breadboard\/transistor_npn.svg",
			"width":"16.527",
			"height":"24.081",
			"points": [[-1, 21.081, 4.16, 3], [6.181, 21.081, 4.16, 3], [13.367, 21.081, 4.16, 3]]
		}, {
			"name":"Analog Digital MUX Breakout",
			"description":"This is a breakout board for the very handy 16-Channel Analog\/Digital Multiplexer\/Demultiplexer CD74HC4067.This chip is like a rotary switch -it internally routes the common pin(COM in the schematic, SIG on the board) to one of 16 channel pins(CHANxx).It works with both digital and analog signals(the voltage can \ u2019t be higher than VCC), and the connections function in either direction.To control it, connect 4 digital outputs to the chip \ u2019s address select pins(S0-S3), and send it the binary address of the channel you want(see the datasheet for details).This allows you to connect up to 16 sensors to your system using only 5 pins!Features: 2V to 6V operation \ u201cOn \ u201d resistance: 70 Ohms @ 4.5V6ns break-before-make @ 4.5VWide operating temperature range: -55C to 125C",
			"image":"core\/breadboard\/Analog_Digital_MUX_Breakout_breadboard.svg",
			"icon":"core\/breadboard\/Analog_Digital_MUX_Breakout_breadboard.svg",
			"width":"50.4",
			"height":"115.2",
			"points": [[0.548, 108.548, 6.104, 6.104], [0.548, 101.348, 6.104, 6.104], [0.548, 94.148, 6.104, 6.104], [0.548, 86.948, 6.104, 6.104], [0.548, 79.748, 6.104, 6.104], [0.548, 72.548, 6.104, 6.104], [0.548, 65.348, 6.104, 6.104], [0.548, 58.148, 6.104, 6.104], [0.548, 50.948, 6.104, 6.104], [0.548, 43.748, 6.104, 6.104], [0.548, 36.548, 6.104, 6.104], [0.548, 29.348, 6.104, 6.104], [0.548, 22.148, 6.104, 6.104], [0.548, 14.948, 6.104, 6.104], [0.548, 7.748, 6.104, 6.104], [0.548, 0.548, 6.104, 6.104], [43.748, 79.748, 6.104, 6.104], [43.748, 72.548, 6.104, 6.104], [43.748, 65.348, 6.104, 6.104], [43.748, 58.148, 6.104, 6.104], [43.748, 50.948, 6.104, 6.104], [43.748, 43.748, 6.104, 6.104], [43.748, 36.548, 6.104, 6.104], [43.748, 29.348, 6.104, 6.104]]
		}, {
			"name":"TRANSISTOR_PNP",
			"description":"Generic PNP BJT.Double check pinouts against datasheets-not all devices are the same!",
			"image":"core\/breadboard\/transistor_pnp.svg",
			"icon":"core\/breadboard\/transistor_pnp.svg",
			"width":"16.527",
			"height":"24.08",
			"points": [[-1, 22, 4.16, 3], [6.181, 22, 4.16, 3], [13.367, 22, 4.16, 3]]
		}, {
			"name":"RCA",
			"description":"",
			"image":"core\/breadboard\/sparkfun-connectors_rca_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_rca_breadboard.svg",
			"width":"47.746",
			"height":"230.4",
			"points": [[18.123, 224.652, 4.299, 4.296], [25.323, 224.652, 4.3, 4.296], [25.323, 1.452, 4.3, 4.297]]
		}, {
			"name":"DB25",
			"description":"Various DB25 connectors",
			"image":"core\/breadboard\/sparkfun-connectors_m25vp_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_m25vp_breadboard.svg",
			"width":"2300.46",
			"height":"600",
			"points": [[483.265, 533.05, 33.93, 33.9], [583.265, 533.05, 33.93, 33.9], [583.265, 33.05, 33.93, 33.9], [683.265, 533.05, 33.93, 33.9], [683.265, 33.05, 33.93, 33.9], [783.265, 533.05, 33.93, 33.9], [783.265, 33.05, 33.93, 33.9], [883.265, 533.05, 33.93, 33.9], [883.265, 33.05, 33.93, 33.9], [983.265, 533.05, 33.93, 33.9], [983.265, 33.05, 33.93, 33.9], [1083.26, 533.05, 33.93, 33.9], [1083.26, 33.05, 33.93, 33.9], [1183.26, 533.05, 33.93, 33.9], [1183.26, 33.05, 33.93, 33.9], [1283.26, 533.05, 33.93, 33.9], [1283.26, 33.05, 33.93, 33.9], [1383.26, 533.05, 33.93, 33.9], [1383.26, 33.05, 33.93, 33.9], [1483.27, 533.05, 33.93, 33.9], [1483.27, 33.05, 33.93, 33.9], [1583.27, 533.05, 33.93, 33.9], [1583.27, 33.05, 33.93, 33.9], [1683.27, 533.05, 33.93, 33.9], [1683.27, 33.05, 33.93, 33.9], [1783.27, 533.05, 33.93, 33.9], [1783.27, 33.05, 33.93, 33.9]]
		}, {
			"name":"Bluetooth Mate Silver",
			"description":"The Bluetooth Mate is very similar to our BlueSMiRF modem, but it is designed specifically to be used with our Arduino Pros and LilyPad Arduinos.These modems work as a serial(RX\/TX)pipe, and are a great wireless replacement for serial cables.Any serial stream from 9600 to 115200bps can be passed seamlessly from your computer to your target.\tBluetooth Mate has the same pin out as the FTDI Basic, and is meant to plug directly into an Arduino Pro, Pro Mini, or LilyPad Mainboard.Because we 've arranged the pins to do this, you cannot directly plug the Bluetooth Mate to an FTDI Basic board (you' ll have to swap TX and RX).\tThe RN-42 is perfect for short range, battery powered applications.The RN-42 uses only 26uA in sleep mode while still being discoverable and connectable.Multiple user configurable power modes allow the user to dial in the lowest power profile for a given application.If you need longer range, check out the Bluetooth Mate Gold.\tThe Bluetooth Mate has on-board voltage regulators, so it can be powered from any 3.3 to 6VDC power supply.We 've got level shifting all set up so the RX and TX pins on the remote unit are 3-6VDC tolerant. Do not attach this device directly to a serial port. You will need an RS232 to TTL converter circuit if you need to attach this to a computer.\tUnit comes without a connector; if you want to connect it to an Arduino Pro, we' d suggest the 6-pin right-angle female header.\tNote: The hardware reset pin of the RN-42 module is broken out on the bottom side of the board.This pin is mislabeled as 'PIO6', it is actually PIO4.Should you need to reset the Mate, pull this pin high upon power-up, and then toggle it 3 times.\tFeatures: \t\t\tDesigned to work directly with Arduino Pro 's and LilyPad main boards\t\t\tFCC Approved Class 2 Bluetooth® Radio Modem!\t\t\tLow power consumption : 25mA avg\t\t\tHardy frequency hopping scheme-operates in harsh RF environments like WiFi, 802.11g, and Zigbee\t\t\tEncrypted connection\t\t\tFrequency: 2.4~2.524 GHz\t\t\tOperating Voltage: 3.3V-6V\t\t\tSerial communications: 2400-115200bps\t\t\tOperating Temperature: -40 ~ +70C\t\t\tBuilt-in antenna\tDimensions: \t\t\tBoard: 1.75x0.65'\t\t\tDocuments: \t\t\t\tSchematic\t\t\tEagle Files\t\t\tRN-42 AT Command Set\t\t\tRoving Networks Bluetooth® module datasheet\t\t\t\t\tCheck out our Bluetooth Tutorial",
			"image":"core\/breadboard\/ArduinoBluetoothMatev13_breadboard.svg",
			"icon":"core\/breadboard\/ArduinoBluetoothMatev13_breadboard.svg",
			"width":"126",
			"height":"46.8",
			"points": [[119.348, 2.348, 6.104, 6.104], [119.348, 9.548, 6.104, 6.104], [119.348, 16.748, 6.104, 6.104], [119.348, 23.948, 6.104, 6.104], [119.348, 31.148, 6.104, 6.104], [119.348, 38.348, 6.104, 6.104]]
		}, {
			"name":"LEDs",
			"description":"LEDsStandard schematic elements and footprints for 5mm, 3mm, 1206, and 0603 sized LEDs.5mm-Spark Fun Electronics SKU: COM-00529(and others)",
			"image":"core\/breadboard\/sparkfun-led_led-0603_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_led-0603_breadboard.svg",
			"width":"290.556",
			"height":"400",
			"points": [[128.313, 333.05, 33.93, 33.9], [128.313, 33.05, 33.93, 33.9]]
		}, {
			"name":"SN74LVC1G08",
			"description":"Single-gate AND logic",
			"image":"core\/breadboard\/sparkfun-digitalic_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}
	]
}, {
	"page":"5",
	"count": 37,
	"el": [{
			"name":"PCM1803",
			"description":"24-bit ADC",
			"image":"core\/breadboard\/SSOP20_breadboard.svg",
			"icon":"core\/breadboard\/SSOP20_breadboard.svg",
			"width":"72",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"AD8210-High Voltage Birdirectional Current Shunt Monitor",
			"description":"",
			"image":"core\/breadboard\/AD8210.svg",
			"icon":"core\/breadboard\/AD8210.svg",
			"width":"28.8",
			"height":"29.786",
			"points": [[0.852, 22.942, 5.5, 5.5], [8.053, 22.944, 5.5, 5.5], [15.251, 22.944, 5.5, 5.5], [22.447, 22.942, 5.5, 5.5], [22.449, 1.344, 5.5, 5.5], [15.25, 1.344, 5.5, 5.5], [8.053, 1.342, 5.5, 5.5], [0.853, 1.341, 5.5, 5.5]]
		}, {
			"name":"Intel Galileo Gen2",
			"description":"Galileo is a microcontroller board based on the Intel \ u00ae Quark SoC X1000 Application Processor, a 32-bit Intel Pentium-class system on a chip(datasheet).It \ u2019s the first board based on Intel \ u00ae architecture designed to be hardware and software pin-compatible with Arduino shields designed for the Uno R3.Digital pins 0 to 13(and the adjacent AREF and GND pins), Analog inputs 0 to 5, the power header, ICSP header, and the UART port pins(0 and 1), are all in the same locations as on the Arduino Uno R3.This is also known as the Arduino 1.0 pinout.Galileo is designed to support shields that operate at either 3.3V or 5V.The core operating voltage of Galileo is 3.3V.However, a jumper on the board enables voltage translation to 5V at the I\/O pins.This provides support for 5V Uno shields and is the default behavior.By switching the jumper position, the voltage translation can be disabled to provide 3.3V operation at the I\/O pins.Of course, the Galileo board is also software compatible with the Arduino Software Development Environment(IDE), which makes usability and introduction a snap.In addition to Arduino hardware and software compatibility, the Galileo board has several PC industry standard I\/O ports and features to expand native usage and capabilities beyond the Arduino shield ecosystem.A full sized mini-PCI Express slot, 100Mb Ethernet port, Micro-SD slot, RS-232 serial port, USB Host port, USB Client port, and 8MByte NOR flash come standard on the board.Visit the FAQ page for further informations.",
			"image":"core\/breadboard\/intel-arduino-galileo_gen2_breadboard.svg",
			"icon":"core\/breadboard\/intel-arduino-galileo_gen2_breadboard.svg",
			"width":"362.789",
			"height":"210.324",
			"points": [[310.747, 176.316, 5.218, 5.218], [317.947, 176.316, 5.218, 5.218], [325.145, 176.316, 5.218, 5.218], [332.347, 176.316, 5.218, 5.218], [339.544, 176.316, 5.218, 5.218], [346.747, 176.316, 5.218, 5.218], [346.943, 96.954, 5.544, 5.544], [354.143, 96.954, 5.544, 5.544], [346.944, 104.155, 5.542, 5.542], [354.144, 104.155, 5.542, 5.542], [346.944, 111.354, 5.542, 5.542], [354.144, 111.354, 5.542, 5.542], [284.825, 39.516, 5.22, 5.22], [277.623, 39.516, 5.22, 5.22], [270.424, 39.516, 5.22, 5.22], [263.225, 39.516, 5.22, 5.22], [256.025, 39.516, 5.22, 5.22], [248.825, 39.516, 5.22, 5.22], [241.623, 39.516, 5.22, 5.22], [234.424, 39.516, 5.22, 5.22], [227.225, 39.516, 5.22, 5.22], [220.025, 39.516, 5.22, 5.22], [346.746, 39.516, 5.22, 5.22], [339.543, 39.516, 5.22, 5.22], [332.346, 39.516, 5.22, 5.22], [325.144, 39.516, 5.22, 5.22], [317.946, 39.516, 5.22, 5.22], [310.746, 39.516, 5.22, 5.22], [303.543, 39.516, 5.22, 5.22], [296.346, 39.516, 5.22, 5.22], [253.145, 176.316, 5.218, 5.218], [260.347, 176.316, 5.218, 5.218], [267.544, 176.316, 5.218, 5.218], [274.747, 176.316, 5.218, 5.218], [281.947, 176.316, 5.218, 5.218], [289.145, 176.316, 5.218, 5.218], [296.347, 176.316, 5.218, 5.218], [245.947, 176.316, 5.218, 5.218], [321.729, 15.503, 5.544, 5.544], [321.729, 22.702, 5.544, 5.544], [314.53, 15.504, 5.542, 5.542], [314.53, 22.703, 5.542, 5.542], [307.332, 15.504, 5.542, 5.542], [307.332, 22.703, 5.542, 5.542], [300.169, 22.703, 5.542, 5.542], [38.447, 29.333, 5.544, 5.544], [38.448, 22.135, 5.542, 5.542], [38.448, 14.935, 5.542, 5.542], [245.786, 189.477, 5.544, 5.544], [252.985, 189.478, 5.542, 5.542], [260.185, 189.478, 5.542, 5.542], [275.769, 189.478, 5.542, 5.542], [282.968, 189.478, 5.542, 5.542], [106.223, 158.964, 5.542, 5.542], [113.422, 158.964, 5.542, 5.542], [78.64, 203.2, 3.176, 3.176], [74.983, 203.2, 3.176, 3.176], [71.327, 203.2, 3.176, 3.176], [67.67, 203.2, 3.176, 3.176], [64.013, 203.2, 3.176, 3.176], [78.64, 199.544, 3.176, 3.176], [74.983, 199.544, 3.176, 3.176], [71.327, 199.544, 3.176, 3.176], [67.67, 199.544, 3.176, 3.176], [64.013, 199.544, 3.176, 3.176]]
		}, {
			"name":"Arduino Nano(Rev3.0)(ICSP)",
			"description":"The Arduino Nano is a small, complete, and breadboard-friendly board based on the ATmega328(Arduino Nano 3.0)or ATmega168(Arduino Nano 2.x).It has more or less the same functionality of the Arduino Duemilanove, but in a different package.It lacks only a DC power jack, and works with a Mini-B USB cable instead of a standard one.The Nano was designed and is being produced by Gravitech.",
			"image":"core\/breadboard\/Arduino Nano3_breadboard.svg",
			"icon":"core\/breadboard\/Arduino Nano3_breadboard.svg",
			"width":"50.4",
			"height":"127.584",
			"points": [[0.692, 7.892, 5.816, 5.816], [0.692, 15.092, 5.816, 5.816], [0.692, 22.292, 5.816, 5.816], [0.692, 29.492, 5.816, 5.816], [0.692, 36.692, 5.816, 5.816], [0.692, 43.892, 5.816, 5.816], [0.692, 51.092, 5.816, 5.816], [0.692, 58.292, 5.816, 5.816], [0.692, 65.492, 5.816, 5.816], [0.692, 72.692, 5.816, 5.816], [0.692, 79.892, 5.816, 5.816], [0.692, 87.092, 5.816, 5.816], [0.692, 94.292, 5.816, 5.816], [0.692, 101.492, 5.816, 5.816], [0.692, 108.692, 5.816, 5.816], [43.892, 7.892, 5.816, 5.816], [43.892, 15.092, 5.816, 5.816], [43.892, 22.292, 5.816, 5.816], [43.892, 29.492, 5.816, 5.816], [43.892, 36.692, 5.816, 5.816], [43.892, 43.892, 5.816, 5.816], [43.892, 51.092, 5.816, 5.816], [43.892, 58.292, 5.816, 5.816], [43.892, 65.492, 5.816, 5.816], [43.892, 72.692, 5.816, 5.816], [43.892, 79.892, 5.816, 5.816], [43.892, 87.092, 5.816, 5.816], [43.892, 94.292, 5.816, 5.816], [43.892, 101.492, 5.816, 5.816], [43.892, 108.692, 5.816, 5.816], [29.492, 0.98, 5.816, 5.816], [29.492, 8.18, 5.816, 5.816], [22.292, 0.98, 5.816, 5.816], [22.292, 8.18, 5.816, 5.816], [15.092, 0.98, 5.816, 5.816], [15.092, 8.18, 5.816, 5.816]]
		}, {
			"name":"TC7SU04F",
			"description":"Single gate inverter",
			"image":"core\/breadboard\/sparkfun-digitalic_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Humidity Sensor-HIH-4030 Breakout",
			"description":"This is a breakout board for Honeywell's HIH-4030 humidity sensor.The HIH-4030 measures relative humidity( % RH)and delivers it as an analog output voltage.You can connect the output of the sensor directly to an ADC on a microcontroller; and, thanks to the sensor's near linear voltage output, the data is very easy to process.\t\tVoltage applied to the supply pins should be within 4-5.8VDC, and optimally at 5V.The sensor will typically only consume about 200μA.\t\tThis product comes as shown in the picture, with the HIH-4030 soldered onto the breakout board.The pins of the 3-pin header are spaced by 0.1'.\t\tFeatures: \t\t\tNear linear, analog output\t\t\t4-5.8VDC voltage supply\t\t\tAll pins broken out to a 0.1' pitch header\t\t\tLaser trimmed interchangeability\t\t\tLow power design,typical current draw of only 200μA\t\t\tEnhanced accuracy\t\t\tFast response time\t\t\tStable, low drift performance\tDimensions: 0.75 x 0.30'(19.05 x 7.62 mm)\t\tDocuments: \t\t\tSchematic\t\t\tHIH-4030 Humidity Sensor Datasheet",
			"image":"core\/breadboard\/HIH-4030_Breakout-v10_breadboard.svg",
			"icon":"core\/breadboard\/HIH-4030_Breakout-v10_breadboard.svg",
			"width":"54",
			"height":"21.6",
			"points": [[0.548, 0.548, 6.104, 6.104], [0.548, 7.748, 6.104, 6.104], [0.548, 14.948, 6.104, 6.104]]
		}, {
			"name":"74VHC4052",
			"description":"Dual 4: 1 analog mux",
			"image":"core\/breadboard\/sparkfun-analogic_tssop16_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_tssop16_breadboard.svg",
			"width":"800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Triple Axis Gyro Breakout ITG-3200",
			"description":"This is a breakout board for InvenSense's ITG-3200, a groundbreaking triple-axis, digital output gyroscope.The ITG-3200 features three 16-bit analog-to-digital converters(ADCs)for digitizing the gyro outputs, a user-selectable internal low-pass filter bandwidth, and a Fast-Mode I2C(400kHz)interface.Additional features include an embedded temperature sensor and a 2 % accurate internal oscillator.\tThe ITG-3200 can be powered at anywhere between 2.1 and 3.6V.For power supply flexibility, the ITG-3200 has a separate VLOGIC reference pin(labeled VIO), in addition to its analog supply pin(VDD)which sets the logic levels of its serial interface.The VLOGIC voltage may be anywhere from 1.71V min to VDD max.For general use, VLOGIC can be tied to VCC.The normal operating current of the sensor is just 6.5mA.\tCommunication with the ITG-3200 is achieved over a two-wire(I2C)interface.The sensor also features a interrupt output, and an optional clock input.A jumper on the top of the board allows you to easily select the I2C address, by pulling the AD0 pin to either VCC or GND; the board is shipped with this jumper tied to VCC.If you don't plan on using the CLKIN pin, you can short the jumper on the bottom of the board to tie it to GND.\tThis breakout board is shipped as shown in the images.Note that there are two unpopulated resistors on the I2C lines, these can be added later by the customer if desired.\tNot sure which gyro is right for you ? Our Accelerometer and Gyro Buying Guide might help!\tFeatures : \t\t\tDigital-output X-, Y-, and Z-Axis angular rate sensors(gyros)on one integrated circuit\t\t\tDigitally-programmable low-pass filter\t\t\tLow 6.5mA operating current consumption for long battery life\t\t\tWide VDD supply voltage range of 2.1V to 3.6V\t\t\tStandby current: 5μA\t\t\tDigital-output temperature sensor\t\t\tFast Mode I2C(400kHz)serial interface\t\t\tOptional external clock inputs of 32.768kHz or 19.2MHz to synchronize with system clock\t\t\tPins broken out to a breadboard friendly 7-pin 0.1'pitch header Dimensions: 0.70 x 0.55'(17.78 x 13.97mm)\tDocuments: \t\t\tSchematic\t\t\tQuickstart Guide\t\t\tITG-3200 Datasheet\t\t\tExample Code(ATmega328)\t\t\tmbed Example",
			"image":"core\/breadboard\/ITG-3200-v11_breadboard.svg",
			"icon":"core\/breadboard\/ITG-3200-v11_breadboard.svg",
			"width":"50.4",
			"height":"39.6",
			"points": [[0.548, 0.548, 6.104, 6.104], [7.748, 0.548, 6.104, 6.104], [14.948, 0.548, 6.104, 6.104], [22.148, 0.548, 6.104, 6.104], [29.348, 0.548, 6.104, 6.104], [36.548, 0.548, 6.104, 6.104], [43.748, 0.548, 6.104, 6.104]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_eia6032_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_eia6032_breadboard.svg",
			"width":"464.833",
			"height":"400",
			"points": [[215.451, 333.05, 33.93, 33.9], [215.451, 33.05, 33.93, 33.9]]
		}, {
			"name":"ENCODER_2LED",
			"description":"Illuminated Rotary Encoder w\/2 LEDs",
			"image":"core\/breadboard\/sparkfun-electromechanical_encoder_led_2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_encoder_led_2_breadboard.svg",
			"width":"739.681",
			"height":"1200",
			"points": [[152.875, 1133.05, 33.93, 33.9], [252.875, 1133.05, 33.93, 33.9], [252.875, 33.05, 33.93, 33.9], [352.875, 1133.05, 33.93, 33.9], [352.875, 33.05, 33.93, 33.9], [452.875, 1133.05, 33.93, 33.9], [452.875, 33.05, 33.93, 33.9], [552.875, 1133.05, 33.93, 33.9], [552.875, 33.05, 33.93, 33.9]]
		}, {
			"name":"LilyPad LED",
			"description":"A simple, very bright, 250mcd, white LED LilyPad.Light up the night!LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input,output, power, and sensor boards are available.They're even washable!Note: A portion of this sale is given back to Dr.Leah Buechley for continued development and education of e-textiles.Dimensions: 5x11mmThin 0.8mm PCB",
			"image":"core\/breadboard\/LilyPad_LED-v14_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad_LED-v14_breadboard.svg",
			"width":"14.4",
			"height":"36.004",
			"points": [[3.796, 26.838, 6.808, 6.808], [3.796, 2.358, 6.808, 6.808]]
		}, {
			"name":"SWITCH-DPDT",
			"description":"DPDT Version of the COM-00597",
			"image":"core\/breadboard\/sparkfun-electromechanical_mss22_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_mss22_breadboard.svg",
			"width":"500",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"DPAC WiFi Module",
			"description":"DPAC WiFi ModuleFootprint for DPAC wireless module.Not fully tested so double check it.Spark Fun Electronics SKU: (Module)WRL-00665, (Connector)WRL-00673",
			"image":"core\/breadboard\/sparkfun-rf_wlanmodule_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_wlanmodule_breadboard.svg",
			"width":"1800",
			"height":"1600",
			"points": [[33.035, 1533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 1533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 1533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 1533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 1533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 1533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 1533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 1533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 1533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 1533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 1533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 1533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 1533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 1533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 1533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 1533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 1533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 1533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Momentary Switch",
			"description":"Momentary SwitchButton commonly used for reset or general input.Spark Fun Electronics SKU: COM-00097",
			"image":"core\/breadboard\/sparkfun-electromechanical_tactile-pth_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_tactile-pth_breadboard.svg",
			"width":"445.014",
			"height":"600",
			"points": [[155.542, 533.05, 33.93, 33.9], [155.542, 33.05, 33.93, 33.9], [255.542, 533.05, 33.93, 33.9], [255.542, 33.05, 33.93, 33.9]]
		}, {
			"name":"IR Receiver Breakout",
			"description":"This is a very small infrared receiver based on the TSOP85 receiver from Vishay.This receiver has all the filtering and 38kHz demodulation built into the unit.Simply point a IR remote at the receiver, hit a button, and you'll see a stream of 1s and 0s out of the data pin.\t\tDocuments: \t\t\tDatasheet\t\t\tSchematic\t\t\tConsumer IR Information",
			"image":"core\/breadboard\/IR_Receiver_v14_breadboard.svg",
			"icon":"core\/breadboard\/IR_Receiver_v14_breadboard.svg",
			"width":"39.6",
			"height":"28.8",
			"points": [[29.348, 18.548, 6.104, 6.104], [29.348, 11.348, 6.104, 6.104], [29.348, 4.148, 6.104, 6.104]]
		}, {
			"name":"TPA2000D1 Audio Amplifier",
			"description":"2 Watt Filterless Mono Class-D Audio Power Amplifier",
			"image":"core\/breadboard\/TPA2000D1_Audio_Amplifier.svg",
			"icon":"core\/breadboard\/TPA2000D1_Audio_Amplifier.svg",
			"width":"57.496",
			"height":"58.082",
			"points": [[0.912, 0.784, 5.62, 5.62], [8.087, 0.784, 5.62, 5.62], [15.262, 0.784, 5.62, 5.62], [22.439, 0.784, 5.62, 5.62], [29.615, 0.784, 5.62, 5.62], [36.792, 0.784, 5.62, 5.62], [43.965, 0.784, 5.62, 5.62], [51.14, 0.784, 5.62, 5.62], [51.138, 51.181, 5.624, 5.624], [43.963, 51.181, 5.624, 5.624], [36.79, 51.181, 5.624, 5.624], [29.613, 51.181, 5.624, 5.624], [22.438, 51.181, 5.624, 5.624], [15.26, 51.181, 5.624, 5.624], [8.085, 51.181, 5.624, 5.624], [0.909, 51.181, 5.624, 5.624]]
		}, {
			"name":"Chip antenna",
			"description":"Chip antennaSingle endded antenna.Common with smaller chip antennas.CHIP4 package is the GPS Chip Antenna SKU: GPS-08418.CHIP5 package is 2.4GHz chip antenna SKU: WRL-00144.",
			"image":"core\/breadboard\/sparkfun-rf_antenna-chip3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_antenna-chip3_breadboard.svg",
			"width":"243.37",
			"height":"600",
			"points": [[104.72, 533.05, 33.93, 33.9], [104.72, 33.05, 33.93, 33.9]]
		}, {
			"name":"QFN-24",
			"description":"",
			"image":"core\/breadboard\/QFN-24_breadboard.svg",
			"icon":"core\/breadboard\/QFN-24_breadboard.svg",
			"width":"86.4",
			"height":"28.8",
			"points": [[1.45052, 23.0516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 23.0516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 23.0516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 23.0516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 23.0516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 23.0516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 23.0516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 23.0516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 23.0516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 23.0516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 23.0516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 23.0516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Chip antenna",
			"description":"Chip antennaSingle endded antenna.Common with smaller chip antennas.CHIP4 package is the GPS Chip Antenna SKU: GPS-08418.CHIP5 package is 2.4GHz chip antenna SKU: WRL-00144.",
			"image":"core\/breadboard\/sparkfun-rf_antenna-chip4_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_antenna-chip4_breadboard.svg",
			"width":"554.333",
			"height":"400",
			"points": [[260.202, 333.05, 33.93, 33.9], [260.202, 33.05, 33.93, 33.9]]
		}, {
			"name":"Chip antenna",
			"description":"Chip antennaSingle endded antenna.Common with smaller chip antennas.CHIP4 package is the GPS Chip Antenna SKU: GPS-08418.CHIP5 package is 2.4GHz chip antenna SKU: WRL-00144.",
			"image":"core\/breadboard\/sparkfun-rf_antenna-chip5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_antenna-chip5_breadboard.svg",
			"width":"350",
			"height":"400",
			"points": [[158.035, 333.05, 33.93, 33.9], [158.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Chip antenna",
			"description":"Chip antennaSingle endded antenna.Common with smaller chip antennas.CHIP4 package is the GPS Chip Antenna SKU: GPS-08418.CHIP5 package is 2.4GHz chip antenna SKU: WRL-00144.",
			"image":"core\/breadboard\/sparkfun-rf_antenna-chip6_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_antenna-chip6_breadboard.svg",
			"width":"348.622",
			"height":"400",
			"points": [[157.346, 333.05, 33.93, 33.9], [157.346, 33.05, 33.93, 33.9]]
		}, {
			"name":"QFN-28",
			"description":"",
			"image":"core\/breadboard\/QFN-28_breadboard.svg",
			"icon":"core\/breadboard\/QFN-28_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"L6470",
			"description":"3A RMS\/7A peak bipolar stepper motor driver with SPI controland step input in HTSSOP-28 package.",
			"image":"core\/breadboard\/sparkfun-poweric_htssop28_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_htssop28_breadboard.svg",
			"width":"1500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Power Jack",
			"description":"Power JackThis is the standard 5.5mm barrel jack for power.The PTH is the most common, proven, reliable, footprint.All others are experimental.The Slot footprint only works if the mill layer is transmitted to the PCB fab house so be warned.Spark Fun Electronics SKU: PRT-00119.Mating wall wart: TOL-00298(and others)",
			"image":"core\/breadboard\/sparkfun-connectors_power_jack_slot_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_power_jack_slot_breadboard.svg",
			"width":"554.333",
			"height":"1000",
			"points": [[210.202, 933.05, 33.93, 33.9], [310.202, 933.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9]]
		}, {
			"name":"TRRS 3.5mm Jack Breakout",
			"description":"TRRS connectors are the audio-style connectors that you see on some phones, MP3 players and development boards.TRRS stands for  \ u201cTip, Ring, Ring, Sleeve,  \ u201d which reflects the fact that, unlike a standard stereo connector, this actually has three conductors and a ground.Some devices use the extra conductor for a microphone(like hands-free headsets) or to carry a video signal(like in some MP3\/MP4 players).This breakout board makes it easy to add a TRRS jack to your prototype or project by breaking out each conductor to a standard 0.1' spaced header.",
			"image":"core\/breadboard\/TRRS_Breakout-v10.svg",
			"icon":"core\/breadboard\/TRRS_Breakout-v10.svg",
			"width":"41.7",
			"height":"50.4",
			"points": [[9.8, 43.7, 6.2, 6.2], [17, 43.7, 6.2, 6.2], [24.2, 43.7, 6.2, 6.2], [31.4, 43.7, 6.2, 6.2]]
		}, {
			"name":"LED Tactile Button Breakout v10",
			"description":"This simple breakout board makes it easy to use our LED tactile switches in a breadboard, or your next project.",
			"image":"core\/breadboard\/prefix0000_SFE-10467-v10_2.svg",
			"icon":"core\/breadboard\/prefix0000_SFE-10467-v10_2.svg",
			"width":"43.2",
			"height":"57.6",
			"points": [[7.7, 50.9, 6.2, 6.2], [14.9, 50.9, 6.2, 6.2], [22.1, 50.9, 6.2, 6.2], [29.3, 50.9, 6.2, 6.2]]
		}, {
			"name":"2.4GHz Low Power Transceiver",
			"description":"2.4GHz Low Power TransceiverThis is the very popular, low cost, very low power RF transceiver from Nordic Semiconductor.Simple SPI interface.SKU: COM-00690",
			"image":"core\/breadboard\/sparkfun-rf_qfn20_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_qfn20_breadboard.svg",
			"width":"1100",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 333.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"100 \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_100.svg",
			"icon":"obsolete\/breadboard\/resistor_100.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"100 \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_100.svg",
			"icon":"obsolete\/breadboard\/resistor_100.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"LIS3LV02DQ",
			"description":"3-axis 2\/6g I2C\/SPI accelerometer",
			"image":"core\/breadboard\/QFN-28_breadboard.svg",
			"icon":"core\/breadboard\/QFN-28_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"BD10KA5WF-E2",
			"description":"500mA LDO, 1.0V SO-8(COM-10827)",
			"image":"core\/breadboard\/sparkfun-poweric_so08wide_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_so08wide_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"NRF24Z1",
			"description":"2.4GHz transceiver",
			"image":"core\/breadboard\/QFN-36_breadboard.svg",
			"icon":"core\/breadboard\/QFN-36_breadboard.svg",
			"width":"129.6",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968], [116.651, 37.4516, 4.29896, 4.2968], [116.651, 1.4516, 4.29896, 4.2968], [123.851, 37.4516, 4.29896, 4.2968], [123.851, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"chipKIT Basic I\/O Shield",
			"description":"The chipKIT Basic I\/O Shield is an input\/output expansion board designed for use with chipKIT microcontroller boards such as the Uno32 \ u2122 and the Max32 \ u2122. \ u00a0 The Basic I\/O Shield is designed to provide a range of input\/output devices suitable for beginners learning about microcontrollers and various types of I\/O devices, or for use by more advanced user to provide inputs or outputs for their own projects. \ u00a0 The Basic I\/O Shield provides simple digital input devices such as switches and buttons, and digital output devices such as discrete LEDs and high current open FET drivers.It provides more advanced devices such as an I2C EEPROM, an I2C temperature sensor, and organic LED graphic display.A potentiometer is also provided for use as an analog input device.",
			"image":"core\/breadboard\/chipkit_BasicIOShield_breadboard.svg",
			"icon":"core\/breadboard\/chipkit_BasicIOShield_breadboard.svg",
			"width":"194.854",
			"height":"151.257",
			"points": [[114.713, 11.658, 5.6, 5.6], [93.113, 11.658, 5.6, 5.6], [107.514, 11.658, 5.6, 5.6], [100.313, 11.658, 5.6, 5.6], [72.412, 11.658, 5.6, 5.6], [85.913, 11.658, 5.6, 5.6], [65.446, 11.658, 5.6, 5.6], [79.612, 11.658, 5.6, 5.6], [114.713, 4.457, 5.6, 5.6], [93.113, 4.457, 5.6, 5.6], [107.514, 4.457, 5.6, 5.6], [100.313, 4.457, 5.6, 5.6], [72.412, 4.457, 5.6, 5.6], [85.913, 4.457, 5.6, 5.6], [65.446, 4.457, 5.6, 5.6], [79.612, 4.457, 5.6, 5.6], [176.634, 11.658, 5.6, 5.6], [155.033, 11.658, 5.6, 5.6], [169.435, 11.658, 5.6, 5.6], [162.233, 11.658, 5.6, 5.6], [134.333, 11.658, 5.6, 5.6], [147.833, 11.658, 5.6, 5.6], [127.366, 11.658, 5.6, 5.6], [141.532, 11.658, 5.6, 5.6], [176.634, 4.457, 5.6, 5.6], [155.033, 4.457, 5.6, 5.6], [169.435, 4.457, 5.6, 5.6], [162.233, 4.457, 5.6, 5.6], [134.333, 4.457, 5.6, 5.6], [147.833, 4.457, 5.6, 5.6], [127.366, 4.457, 5.6, 5.6], [141.532, 4.457, 5.6, 5.6], [126.8, 141.257, 5.6, 5.6], [119.6, 141.257, 5.6, 5.6], [112.399, 141.257, 5.6, 5.6], [105.2, 141.257, 5.6, 5.6], [97.999, 141.257, 5.6, 5.6], [90.799, 141.257, 5.6, 5.6], [177.2, 141.257, 5.6, 5.6], [169.999, 141.257, 5.6, 5.6], [162.8, 141.257, 5.6, 5.6], [155.601, 141.257, 5.6, 5.6], [148.399, 141.257, 5.6, 5.6], [141.2, 141.257, 5.6, 5.6]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder JumperStandard SMD solder jumper.Used to automate production.Two varients: Normally Open and Normally Closed are the same, but have different paste layers.NC will have a large amount of paste and should jumper during reflow.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s-notrace_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s-notrace_breadboard.svg",
			"width":"243.566",
			"height":"400",
			"points": [[104.818, 333.05, 33.93, 33.9], [104.818, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Board Ethernet",
			"description":"The Arduino Ethernet is a microcontroller board based on the ATmega328(datasheet).It has 14 digital input\/output pins, 6 analog inputs, a 16 MHz crystal oscillator, a RJ45 connection, a power jack, an ICSP header, and a reset button.NB: Pins 10, 11, 12 and 13 are reserved for interfacing with the Ethernet module and should not be used otherwise.This reduces the number of available pins to 9, with 4 available as PWM outputs.An optional Power over Ethernet module can be added to the board as well.The Ethernet differs from other boards in that it does not have an onboard USB-to-serial driver chip, but has a Wiznet Ethernet interface.This is the same interface found on the Ethernet shield.An onboard microSD card reader, which can be used to store files for serving over the network, is accessible through the SD Library.Pin 10 is reserved for the Wiznet interface, SS for the SD card is on Pin 4.The 6-pin serial programming header is compatible with the USB Serial adapter and also with the FTDI USB cables or with Sparkfun and Adafruit FTDI-style basic USB-to-serial breakout boards.It features support for automatic reset, allowing sketches to be uploaded without pressing the reset button on the board.When plugged into a USB to Serial adapter, the Arduino Ethernet is powered from the adapter.",
			"image":"core\/breadboard\/Arduino_Ethernet_breadboard.svg",
			"icon":"core\/breadboard\/Arduino_Ethernet_breadboard.svg",
			"width":"219.996",
			"height":"151.2",
			"points": [[127.52, 4.4, 5.6, 5.6], [120.32, 4.4, 5.6, 5.6], [113.12, 4.4, 5.6, 5.6], [105.919, 4.4, 5.6, 5.6], [98.72, 4.4, 5.6, 5.6], [91.52, 4.4, 5.6, 5.6], [84.32, 4.4, 5.6, 5.6], [77.12, 4.4, 5.6, 5.6], [153.44, 141.2, 5.6, 5.6], [160.64, 141.2, 5.6, 5.6], [167.841, 141.2, 5.6, 5.6], [175.04, 141.2, 5.6, 5.6], [182.24, 141.2, 5.6, 5.6], [189.44, 141.2, 5.6, 5.6], [189.44, 4.4, 5.6, 5.6], [182.24, 4.4, 5.6, 5.6], [175.04, 4.4, 5.6, 5.6], [167.841, 4.4, 5.6, 5.6], [160.64, 4.4, 5.6, 5.6], [153.44, 4.4, 5.6, 5.6], [146.24, 4.4, 5.6, 5.6], [139.04, 4.4, 5.6, 5.6], [185.12, 24.566, 5.6, 5.6], [103.04, 141.2, 5.6, 5.6], [110.24, 141.2, 5.6, 5.6], [117.44, 141.2, 5.6, 5.6], [124.64, 141.2, 5.6, 5.6], [131.841, 141.2, 5.6, 5.6], [139.04, 141.2, 5.6, 5.6], [195.768, 195.768, 6, 6], [195.768, 195.768, 6, 6], [195.768, 195.768, 6, 6], [195.768, 195.768, 6, 6], [195.768, 195.768, 6, 6]]
		}, {
			"name":"DOSonCHIP IC",
			"description":"DOSonCHIP ICThis is the tested schematic and footprint for the DOSonCHIP FAT16 FAT32 IC.Spark Fun Electronics SKU: COM-07956.QFN package also tested\/proven.",
			"image":"core\/breadboard\/sparkfun-digitalic_qfn-24_alt1.pac_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_qfn-24_alt1.pac_breadboard.svg",
			"width":"1200",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 333.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 333.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_cdrh125_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_cdrh125_breadboard.svg",
			"width":"680.444",
			"height":"800",
			"points": [[323.257, 733.05, 33.93, 33.9], [323.257, 33.05, 33.93, 33.9]]
		}, {
			"name":"2.4GHz ANT IC",
			"description":"2.4GHz ANT ICNordic Semiconductor 2.4GHz transceiver that implements the ANT protocol.",
			"image":"core\/breadboard\/sparkfun-rf_mlp-24_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_mlp-24_breadboard.svg",
			"width":"1300",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"MOSFET-PCHANNEL-SOIC8",
			"description":"Generic 8-pin PMOSFET",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Vibration Motor-ROB-08449",
			"description":"Vibration Motor-ROB-08449Physical dimension and wire connections for this powerful vibration motor.Motor has a self adhesive backing.",
			"image":"core\/breadboard\/sparkfun-electromechanical_vibe-motor-10mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_vibe-motor-10mm_breadboard.svg",
			"width":"37.653",
			"height":"34.328",
			"points": [[2.339, 31.573, 5.51, 5.51], [-11.79, 31.573, 5.51, 5.51]]
		}, {
			"name":"Debugger",
			"description":"Need to get all of your Atlas Scientific equipment calibrated and running smoothly in the shortest amount of time ? This Debugger is specially designed to have its pin outs match up directly with all of the Atlas Scientific Circuits.Just plug it into your bread board and your ready to go. \ u2022 Rapid calibration and debugging \ u2022 2 different output voltages(3.3 and 5.0) \ u2022 Header pins directly line up to any Atlas Scientific Circuits \ u2022 This is the exact device used here at Atlas Scientific to test all of our sensors \ u2022 Works as a simple USB to serial converter when not being used to calibrate\/debug",
			"image":"core\/breadboard\/atlas-sientific_Debugger_breadboard.svg",
			"icon":"core\/breadboard\/atlas-sientific_Debugger_breadboard.svg",
			"width":"37.368",
			"height":"65.139",
			"points": [[0.992, 57.017, 6.497, 6.309], [8.292, 56.841, 6.298, 6.298], [29.923, 56.841, 6.298, 6.298], [22.716, 56.842, 6.296, 6.296], [15.536, 56.842, 6.296, 6.296]]
		}, {
			"name":"Arduino Mega Proto Shield",
			"description":"The Arduino Mega now has its very own prototyping shield!The MegaShield mates with the Arduino Mega board and gives the user a prototyping area, two general LEDs, and, most important of all, the Arduino Mega reset switch is brought to the top level.The shield also works with our small breadboards if you don't want to solder to the prototyping area.\t\tThis comes in kit form and must be soldered together by the end user.Please note-we do not ship assembly instructions!All soldering is through-hole(relatively easy)but always check your component orientation before soldering!\t\tKit Includes: \t\t\t1x MegaShield PCB\t\t\t11x 8-pin Arduino Stackable Header\t\t\t1x Bright 5mm Green LED\t\t\t1x Bright 5mm Red LED\t\t\t2x 330 Ohm resistors\t\t\t1x Momentary push button\t\t\t1x 10k resistor\tFeatures: \t\t\tAll Arduino Mega pins are brought to the top level\t\t\t5V and GND power busses\t\t\tPower and stat(connected to D13)LEDs\t\t\tReset Button brought to top level\tDocuments: \t\t\tProtoshield Schematic\t\t\tEagle Files\t\t\tAssembly Tutorial by Bob Gallup\t\t\tArduino Home Page",
			"image":"core\/breadboard\/Mega_Shield-v13_breadboard.svg",
			"icon":"core\/breadboard\/Mega_Shield-v13_breadboard.svg",
			"width":"288",
			"height":"151.2",
			"points": [[115.748, 4.508, 6.104, 6.104], [108.548, 3.788, 6.104, 6.104], [101.348, 4.508, 6.104, 6.104], [94.148, 3.788, 6.104, 6.104], [86.948, 4.508, 6.104, 6.104], [79.748, 3.788, 6.104, 6.104], [72.548, 4.508, 6.104, 6.104], [65.348, 3.788, 6.104, 6.104], [176.948, 4.508, 6.104, 6.104], [169.748, 3.788, 6.104, 6.104], [162.548, 4.508, 6.104, 6.104], [155.348, 3.788, 6.104, 6.104], [148.148, 4.508, 6.104, 6.104], [140.948, 3.788, 6.104, 6.104], [133.748, 4.508, 6.104, 6.104], [126.548, 3.788, 6.104, 6.104], [191.348, 3.788, 6.104, 6.104], [198.548, 4.508, 6.104, 6.104], [205.748, 3.788, 6.104, 6.104], [212.948, 4.508, 6.104, 6.104], [220.148, 3.788, 6.104, 6.104], [227.348, 4.508, 6.104, 6.104], [234.548, 3.788, 6.104, 6.104], [241.748, 4.508, 6.104, 6.104], [205.748, 140.588, 6.104, 6.104], [212.948, 141.308, 6.104, 6.104], [220.148, 140.588, 6.104, 6.104], [227.348, 141.308, 6.104, 6.104], [234.548, 140.588, 6.104, 6.104], [241.748, 141.308, 6.104, 6.104], [248.948, 140.588, 6.104, 6.104], [256.148, 141.308, 6.104, 6.104], [140.948, 140.588, 6.104, 6.104], [148.148, 141.308, 6.104, 6.104], [155.348, 140.588, 6.104, 6.104], [162.548, 141.308, 6.104, 6.104], [169.748, 140.588, 6.104, 6.104], [176.948, 141.308, 6.104, 6.104], [184.148, 140.588, 6.104, 6.104], [191.348, 141.308, 6.104, 6.104], [270.188, 119.348, 6.104, 6.104], [270.908, 112.148, 6.104, 6.104], [270.188, 104.948, 6.104, 6.104], [270.908, 97.748, 6.104, 6.104], [270.188, 90.548, 6.104, 6.104], [270.908, 83.348, 6.104, 6.104], [270.188, 76.148, 6.104, 6.104], [270.908, 68.948, 6.104, 6.104], [270.188, 61.748, 6.104, 6.104], [270.908, 54.548, 6.104, 6.104], [270.188, 47.348, 6.104, 6.104], [270.908, 40.148, 6.104, 6.104], [270.188, 32.948, 6.104, 6.104], [270.908, 25.748, 6.104, 6.104], [270.188, 18.548, 6.104, 6.104], [270.908, 11.348, 6.104, 6.104], [262.988, 119.348, 6.104, 6.104], [263.708, 112.148, 6.104, 6.104], [262.988, 104.948, 6.104, 6.104], [263.708, 97.748, 6.104, 6.104], [262.988, 90.548, 6.104, 6.104], [263.708, 83.348, 6.104, 6.104], [262.988, 76.148, 6.104, 6.104], [263.708, 68.948, 6.104, 6.104], [262.988, 61.748, 6.104, 6.104], [263.708, 54.548, 6.104, 6.104], [262.988, 47.348, 6.104, 6.104], [263.708, 40.148, 6.104, 6.104], [262.988, 32.948, 6.104, 6.104], [263.708, 25.748, 6.104, 6.104], [262.988, 18.548, 6.104, 6.104], [263.708, 11.348, 6.104, 6.104], [90.548, 140.948, 6.104, 6.104], [97.748, 141.668, 6.104, 6.104], [104.948, 140.948, 6.104, 6.104], [112.148, 141.668, 6.104, 6.104], [119.348, 140.948, 6.104, 6.104], [126.548, 141.668, 6.104, 6.104], [262.844, 126.548, 6.104, 6.104], [271.052, 126.548, 6.104, 6.104], [262.844, 4.148, 6.104, 6.104], [271.052, 4.148, 6.104, 6.104], [4.148, 40.148, 6.104, 6.104], [11.348, 40.148, 6.104, 6.104], [18.548, 40.148, 6.104, 6.104], [25.748, 40.148, 6.104, 6.104], [32.948, 40.148, 6.104, 6.104], [40.148, 40.148, 6.104, 6.104], [47.348, 40.148, 6.104, 6.104], [54.548, 40.148, 6.104, 6.104], [61.748, 40.148, 6.104, 6.104], [68.948, 40.148, 6.104, 6.104], [76.148, 40.148, 6.104, 6.104], [83.348, 40.148, 6.104, 6.104], [90.548, 40.148, 6.104, 6.104], [97.748, 40.148, 6.104, 6.104], [104.948, 40.148, 6.104, 6.104], [112.148, 40.148, 6.104, 6.104], [119.348, 40.148, 6.104, 6.104], [126.548, 40.148, 6.104, 6.104], [133.748, 40.148, 6.104, 6.104], [140.948, 40.148, 6.104, 6.104], [148.148, 40.148, 6.104, 6.104], [155.348, 40.148, 6.104, 6.104], [162.548, 40.148, 6.104, 6.104], [169.748, 40.148, 6.104, 6.104], [176.948, 40.148, 6.104, 6.104], [184.148, 40.148, 6.104, 6.104], [191.348, 40.148, 6.104, 6.104], [198.548, 40.148, 6.104, 6.104], [205.748, 40.148, 6.104, 6.104], [212.948, 40.148, 6.104, 6.104], [212.948, 119.348, 6.104, 6.104], [205.748, 119.348, 6.104, 6.104], [198.548, 119.348, 6.104, 6.104], [191.348, 119.348, 6.104, 6.104], [184.148, 119.348, 6.104, 6.104], [176.948, 119.348, 6.104, 6.104], [169.748, 119.348, 6.104, 6.104], [162.548, 119.348, 6.104, 6.104], [155.348, 119.348, 6.104, 6.104], [148.148, 119.348, 6.104, 6.104], [140.948, 119.348, 6.104, 6.104], [133.748, 119.348, 6.104, 6.104], [126.548, 119.348, 6.104, 6.104], [119.348, 119.348, 6.104, 6.104], [112.148, 119.348, 6.104, 6.104], [104.948, 119.348, 6.104, 6.104], [97.748, 119.348, 6.104, 6.104], [90.548, 119.348, 6.104, 6.104], [68.948, 119.348, 6.104, 6.104], [76.148, 119.348, 6.104, 6.104], [83.348, 119.348, 6.104, 6.104], [76.148, 112.148, 6.104, 6.104], [241.748, 47.348, 6.104, 6.104], [241.748, 54.548, 6.104, 6.104], [241.748, 61.748, 6.104, 6.104], [241.748, 68.948, 6.104, 6.104], [241.748, 76.148, 6.104, 6.104], [241.748, 83.348, 6.104, 6.104], [241.748, 90.548, 6.104, 6.104], [241.748, 97.748, 6.104, 6.104], [241.748, 104.948, 6.104, 6.104], [241.748, 112.148, 6.104, 6.104], [83.348, 112.148, 6.104, 6.104], [4.148, 119.348, 6.104, 6.104], [234.548, 47.348, 6.104, 6.104], [234.548, 54.548, 6.104, 6.104], [234.548, 61.748, 6.104, 6.104], [234.548, 68.948, 6.104, 6.104], [234.548, 76.148, 6.104, 6.104], [234.548, 83.348, 6.104, 6.104], [234.548, 90.548, 6.104, 6.104], [234.548, 97.748, 6.104, 6.104], [234.548, 104.948, 6.104, 6.104], [234.548, 112.148, 6.104, 6.104], [11.348, 119.348, 6.104, 6.104], [18.548, 119.348, 6.104, 6.104], [227.348, 112.148, 6.104, 6.104], [227.348, 104.948, 6.104, 6.104], [227.348, 97.748, 6.104, 6.104], [227.348, 90.548, 6.104, 6.104], [227.348, 83.348, 6.104, 6.104], [227.348, 76.148, 6.104, 6.104], [227.348, 68.948, 6.104, 6.104], [227.348, 61.748, 6.104, 6.104], [227.348, 54.548, 6.104, 6.104], [227.348, 47.348, 6.104, 6.104], [25.748, 119.348, 6.104, 6.104], [32.948, 119.348, 6.104, 6.104], [220.148, 47.348, 6.104, 6.104], [220.148, 54.548, 6.104, 6.104], [220.148, 61.748, 6.104, 6.104], [220.148, 68.948, 6.104, 6.104], [220.148, 76.148, 6.104, 6.104], [220.148, 83.348, 6.104, 6.104], [220.148, 90.548, 6.104, 6.104], [220.148, 97.748, 6.104, 6.104], [220.148, 104.948, 6.104, 6.104], [220.148, 112.148, 6.104, 6.104], [212.948, 112.148, 6.104, 6.104], [212.948, 104.948, 6.104, 6.104], [212.948, 97.748, 6.104, 6.104], [212.948, 90.548, 6.104, 6.104], [212.948, 83.348, 6.104, 6.104], [212.948, 76.148, 6.104, 6.104], [212.948, 68.948, 6.104, 6.104], [212.948, 61.748, 6.104, 6.104], [212.948, 54.548, 6.104, 6.104], [212.948, 47.348, 6.104, 6.104], [205.748, 47.348, 6.104, 6.104], [205.748, 54.548, 6.104, 6.104], [205.748, 61.748, 6.104, 6.104], [205.748, 68.948, 6.104, 6.104], [205.748, 76.148, 6.104, 6.104], [205.748, 83.348, 6.104, 6.104], [205.748, 90.548, 6.104, 6.104], [205.748, 97.748, 6.104, 6.104], [205.748, 104.948, 6.104, 6.104], [205.748, 112.148, 6.104, 6.104], [198.548, 112.148, 6.104, 6.104], [198.548, 104.948, 6.104, 6.104], [198.548, 97.748, 6.104, 6.104], [198.548, 90.548, 6.104, 6.104], [198.548, 83.348, 6.104, 6.104], [198.548, 76.148, 6.104, 6.104], [198.548, 68.948, 6.104, 6.104], [198.548, 61.748, 6.104, 6.104], [198.548, 54.548, 6.104, 6.104], [198.548, 47.348, 6.104, 6.104], [191.348, 47.348, 6.104, 6.104], [191.348, 54.548, 6.104, 6.104], [191.348, 61.748, 6.104, 6.104], [191.348, 68.948, 6.104, 6.104], [191.348, 76.148, 6.104, 6.104], [191.348, 83.348, 6.104, 6.104], [191.348, 90.548, 6.104, 6.104], [191.348, 97.748, 6.104, 6.104], [191.348, 104.948, 6.104, 6.104], [191.348, 112.148, 6.104, 6.104], [184.148, 112.148, 6.104, 6.104], [184.148, 104.948, 6.104, 6.104], [184.148, 97.748, 6.104, 6.104], [184.148, 90.548, 6.104, 6.104], [184.148, 83.348, 6.104, 6.104], [184.148, 76.148, 6.104, 6.104], [184.148, 68.948, 6.104, 6.104], [184.148, 61.748, 6.104, 6.104], [184.148, 54.548, 6.104, 6.104], [184.148, 47.348, 6.104, 6.104], [176.948, 47.348, 6.104, 6.104], [176.948, 54.548, 6.104, 6.104], [176.948, 61.748, 6.104, 6.104], [176.948, 68.948, 6.104, 6.104], [176.948, 76.148, 6.104, 6.104], [176.948, 83.348, 6.104, 6.104], [176.948, 90.548, 6.104, 6.104], [176.948, 97.748, 6.104, 6.104], [176.948, 104.948, 6.104, 6.104], [176.948, 112.148, 6.104, 6.104], [169.748, 112.148, 6.104, 6.104], [169.748, 104.948, 6.104, 6.104], [169.748, 97.748, 6.104, 6.104], [169.748, 90.548, 6.104, 6.104], [169.748, 83.348, 6.104, 6.104], [169.748, 76.148, 6.104, 6.104], [169.748, 68.948, 6.104, 6.104], [169.748, 61.748, 6.104, 6.104], [169.748, 54.548, 6.104, 6.104], [169.748, 47.348, 6.104, 6.104], [162.548, 25.748, 6.104, 6.104], [162.548, 32.948, 6.104, 6.104], [162.548, 47.348, 6.104, 6.104], [162.548, 54.548, 6.104, 6.104], [162.548, 61.748, 6.104, 6.104], [162.548, 68.948, 6.104, 6.104], [162.548, 76.148, 6.104, 6.104], [162.548, 83.348, 6.104, 6.104], [162.548, 90.548, 6.104, 6.104], [162.548, 97.748, 6.104, 6.104], [162.548, 104.948, 6.104, 6.104], [162.548, 112.148, 6.104, 6.104], [155.348, 112.148, 6.104, 6.104], [155.348, 104.948, 6.104, 6.104], [155.348, 97.748, 6.104, 6.104], [155.348, 90.548, 6.104, 6.104], [155.348, 83.348, 6.104, 6.104], [155.348, 76.148, 6.104, 6.104], [155.348, 68.948, 6.104, 6.104], [155.348, 61.748, 6.104, 6.104], [155.348, 54.548, 6.104, 6.104], [155.348, 47.348, 6.104, 6.104], [155.348, 32.948, 6.104, 6.104], [155.348, 25.748, 6.104, 6.104], [148.148, 25.748, 6.104, 6.104], [148.148, 32.948, 6.104, 6.104], [148.148, 47.348, 6.104, 6.104], [148.148, 54.548, 6.104, 6.104], [148.148, 61.748, 6.104, 6.104], [148.148, 68.948, 6.104, 6.104], [148.148, 76.148, 6.104, 6.104], [148.148, 83.348, 6.104, 6.104], [148.148, 90.548, 6.104, 6.104], [148.148, 97.748, 6.104, 6.104], [148.148, 104.948, 6.104, 6.104], [148.148, 112.148, 6.104, 6.104], [140.948, 112.148, 6.104, 6.104], [140.948, 104.948, 6.104, 6.104], [140.948, 97.748, 6.104, 6.104], [140.948, 90.548, 6.104, 6.104], [140.948, 83.348, 6.104, 6.104], [140.948, 76.148, 6.104, 6.104], [140.948, 68.948, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 54.548, 6.104, 6.104], [140.948, 47.348, 6.104, 6.104], [140.948, 32.948, 6.104, 6.104], [140.948, 25.748, 6.104, 6.104], [133.748, 25.748, 6.104, 6.104], [133.748, 32.948, 6.104, 6.104], [133.748, 47.348, 6.104, 6.104], [133.748, 54.548, 6.104, 6.104], [133.748, 61.748, 6.104, 6.104], [133.748, 68.948, 6.104, 6.104], [133.748, 76.148, 6.104, 6.104], [133.748, 83.348, 6.104, 6.104], [133.748, 90.548, 6.104, 6.104], [133.748, 97.748, 6.104, 6.104], [133.748, 104.948, 6.104, 6.104], [133.748, 112.148, 6.104, 6.104], [126.548, 112.148, 6.104, 6.104], [126.548, 104.948, 6.104, 6.104], [126.548, 97.748, 6.104, 6.104], [126.548, 90.548, 6.104, 6.104], [126.548, 83.348, 6.104, 6.104], [126.548, 76.148, 6.104, 6.104], [126.548, 68.948, 6.104, 6.104], [126.548, 61.748, 6.104, 6.104], [126.548, 54.548, 6.104, 6.104], [126.548, 47.348, 6.104, 6.104], [126.548, 32.948, 6.104, 6.104], [126.548, 25.748, 6.104, 6.104], [119.348, 25.748, 6.104, 6.104], [119.348, 32.948, 6.104, 6.104], [119.348, 47.348, 6.104, 6.104], [119.348, 54.548, 6.104, 6.104], [119.348, 61.748, 6.104, 6.104], [119.348, 68.948, 6.104, 6.104], [119.348, 76.148, 6.104, 6.104], [119.348, 83.348, 6.104, 6.104], [119.348, 90.548, 6.104, 6.104], [119.348, 97.748, 6.104, 6.104], [119.348, 104.948, 6.104, 6.104], [119.348, 112.148, 6.104, 6.104], [112.148, 112.148, 6.104, 6.104], [112.148, 104.948, 6.104, 6.104], [112.148, 97.748, 6.104, 6.104], [112.148, 90.548, 6.104, 6.104], [112.148, 83.348, 6.104, 6.104], [112.148, 76.148, 6.104, 6.104], [112.148, 68.948, 6.104, 6.104], [112.148, 61.748, 6.104, 6.104], [112.148, 54.548, 6.104, 6.104], [112.148, 47.348, 6.104, 6.104], [112.148, 32.948, 6.104, 6.104], [112.148, 25.748, 6.104, 6.104], [104.948, 25.748, 6.104, 6.104], [104.948, 32.948, 6.104, 6.104], [104.948, 47.348, 6.104, 6.104], [104.948, 54.548, 6.104, 6.104], [104.948, 61.748, 6.104, 6.104], [104.948, 68.948, 6.104, 6.104], [104.948, 76.148, 6.104, 6.104], [104.948, 83.348, 6.104, 6.104], [104.948, 90.548, 6.104, 6.104], [104.948, 97.748, 6.104, 6.104], [104.948, 104.948, 6.104, 6.104], [104.948, 112.148, 6.104, 6.104], [97.748, 112.148, 6.104, 6.104], [97.748, 104.948, 6.104, 6.104], [97.748, 97.748, 6.104, 6.104], [97.748, 90.548, 6.104, 6.104], [97.748, 83.348, 6.104, 6.104], [97.748, 76.148, 6.104, 6.104], [97.748, 68.948, 6.104, 6.104], [97.748, 61.748, 6.104, 6.104], [97.748, 54.548, 6.104, 6.104], [97.748, 47.348, 6.104, 6.104], [97.748, 32.948, 6.104, 6.104], [97.748, 25.748, 6.104, 6.104], [90.548, 25.748, 6.104, 6.104], [90.548, 32.948, 6.104, 6.104], [90.548, 47.348, 6.104, 6.104], [90.548, 54.548, 6.104, 6.104], [90.548, 61.748, 6.104, 6.104], [90.548, 68.948, 6.104, 6.104], [90.548, 83.348, 6.104, 6.104], [90.548, 76.148, 6.104, 6.104], [90.548, 90.548, 6.104, 6.104], [90.548, 97.748, 6.104, 6.104], [90.548, 104.948, 6.104, 6.104], [90.548, 112.148, 6.104, 6.104], [83.348, 104.948, 6.104, 6.104], [83.348, 97.748, 6.104, 6.104], [83.348, 90.548, 6.104, 6.104], [83.348, 83.348, 6.104, 6.104], [83.348, 76.148, 6.104, 6.104], [83.348, 68.948, 6.104, 6.104], [83.348, 61.748, 6.104, 6.104], [83.348, 54.548, 6.104, 6.104], [83.348, 47.348, 6.104, 6.104], [83.348, 32.948, 6.104, 6.104], [83.348, 25.748, 6.104, 6.104], [76.148, 25.748, 6.104, 6.104], [76.148, 32.948, 6.104, 6.104], [76.148, 47.348, 6.104, 6.104], [76.148, 54.548, 6.104, 6.104], [76.148, 61.748, 6.104, 6.104], [76.148, 68.948, 6.104, 6.104], [76.148, 76.148, 6.104, 6.104], [76.148, 90.548, 6.104, 6.104], [76.148, 104.948, 6.104, 6.104], [104.948, 126.548, 6.104, 6.104], [112.148, 126.548, 6.104, 6.104], [119.348, 126.548, 6.104, 6.104], [133.748, 126.548, 6.104, 6.104], [126.548, 126.548, 6.104, 6.104], [76.148, 97.748, 6.104, 6.104], [76.148, 83.348, 6.104, 6.104], [68.948, 25.748, 6.104, 6.104], [68.948, 32.948, 6.104, 6.104], [68.948, 47.348, 6.104, 6.104], [68.948, 54.548, 6.104, 6.104], [68.948, 61.748, 6.104, 6.104], [68.948, 68.948, 6.104, 6.104], [68.948, 76.148, 6.104, 6.104], [68.948, 83.348, 6.104, 6.104], [68.948, 90.548, 6.104, 6.104], [68.948, 97.748, 6.104, 6.104], [68.948, 104.948, 6.104, 6.104], [68.948, 112.148, 6.104, 6.104], [61.748, 112.148, 6.104, 6.104], [61.748, 104.948, 6.104, 6.104], [61.748, 97.748, 6.104, 6.104], [61.748, 90.548, 6.104, 6.104], [61.748, 83.348, 6.104, 6.104], [61.748, 76.148, 6.104, 6.104], [61.748, 68.948, 6.104, 6.104], [61.748, 61.748, 6.104, 6.104], [61.748, 54.548, 6.104, 6.104], [61.748, 47.348, 6.104, 6.104], [61.748, 32.948, 6.104, 6.104], [61.748, 25.748, 6.104, 6.104], [54.548, 18.548, 6.104, 6.104], [54.548, 11.348, 6.104, 6.104], [54.548, 4.148, 6.104, 6.104], [54.548, 25.748, 6.104, 6.104], [54.548, 32.948, 6.104, 6.104], [54.548, 47.348, 6.104, 6.104], [54.548, 54.548, 6.104, 6.104], [54.548, 61.748, 6.104, 6.104], [54.548, 68.948, 6.104, 6.104], [54.548, 83.348, 6.104, 6.104], [54.548, 76.148, 6.104, 6.104], [54.548, 90.548, 6.104, 6.104], [54.548, 97.748, 6.104, 6.104], [54.548, 104.948, 6.104, 6.104], [54.548, 112.148, 6.104, 6.104], [47.348, 112.148, 6.104, 6.104], [47.348, 104.948, 6.104, 6.104], [47.348, 97.748, 6.104, 6.104], [47.348, 90.548, 6.104, 6.104], [47.348, 83.348, 6.104, 6.104], [47.348, 76.148, 6.104, 6.104], [47.348, 68.948, 6.104, 6.104], [47.348, 61.748, 6.104, 6.104], [47.348, 54.548, 6.104, 6.104], [47.348, 47.348, 6.104, 6.104], [47.348, 32.948, 6.104, 6.104], [47.348, 25.748, 6.104, 6.104], [47.348, 18.548, 6.104, 6.104], [40.148, 18.548, 6.104, 6.104], [32.948, 18.548, 6.104, 6.104], [25.748, 18.548, 6.104, 6.104], [18.548, 18.548, 6.104, 6.104], [11.348, 18.548, 6.104, 6.104], [11.348, 25.748, 6.104, 6.104], [11.348, 32.948, 6.104, 6.104], [11.348, 47.348, 6.104, 6.104], [11.348, 54.548, 6.104, 6.104], [11.348, 61.748, 6.104, 6.104], [18.548, 61.748, 6.104, 6.104], [18.548, 54.548, 6.104, 6.104], [18.548, 47.348, 6.104, 6.104], [18.548, 32.948, 6.104, 6.104], [18.548, 25.748, 6.104, 6.104], [25.748, 25.748, 6.104, 6.104], [25.748, 32.948, 6.104, 6.104], [25.748, 47.348, 6.104, 6.104], [25.748, 54.548, 6.104, 6.104], [25.748, 61.748, 6.104, 6.104], [32.948, 61.748, 6.104, 6.104], [32.948, 54.548, 6.104, 6.104], [32.948, 47.348, 6.104, 6.104], [32.948, 32.948, 6.104, 6.104], [32.948, 25.748, 6.104, 6.104], [40.148, 25.748, 6.104, 6.104], [40.148, 32.948, 6.104, 6.104], [40.148, 47.348, 6.104, 6.104], [40.148, 54.548, 6.104, 6.104], [40.148, 61.748, 6.104, 6.104], [40.148, 68.948, 6.104, 6.104], [40.148, 76.148, 6.104, 6.104], [40.148, 83.348, 6.104, 6.104], [40.148, 90.548, 6.104, 6.104], [40.148, 97.748, 6.104, 6.104], [40.148, 112.148, 6.104, 6.104], [40.148, 104.948, 6.104, 6.104], [32.948, 112.148, 6.104, 6.104], [32.948, 104.948, 6.104, 6.104], [32.948, 90.548, 6.104, 6.104], [32.948, 97.748, 6.104, 6.104], [32.948, 83.348, 6.104, 6.104], [32.948, 76.148, 6.104, 6.104], [32.948, 68.948, 6.104, 6.104], [25.748, 68.948, 6.104, 6.104], [18.548, 76.148, 6.104, 6.104], [25.748, 76.148, 6.104, 6.104], [25.748, 83.348, 6.104, 6.104], [18.548, 83.348, 6.104, 6.104], [11.348, 83.348, 6.104, 6.104], [11.348, 90.548, 6.104, 6.104], [11.348, 97.748, 6.104, 6.104], [11.348, 104.948, 6.104, 6.104], [11.348, 112.148, 6.104, 6.104], [25.748, 112.148, 6.104, 6.104], [25.748, 104.948, 6.104, 6.104], [25.748, 97.748, 6.104, 6.104], [25.748, 90.548, 6.104, 6.104], [18.548, 90.548, 6.104, 6.104], [18.548, 97.748, 6.104, 6.104], [18.548, 112.148, 6.104, 6.104], [18.548, 104.948, 6.104, 6.104], [32.948, 11.348, 6.104, 6.104], [25.748, 11.348, 6.104, 6.104], [18.548, 11.348, 6.104, 6.104], [11.348, 11.348, 6.104, 6.104], [11.348, 4.148, 6.104, 6.104], [18.548, 4.148, 6.104, 6.104], [25.748, 4.148, 6.104, 6.104], [47.348, 11.348, 6.104, 6.104], [4.148, 112.148, 6.104, 6.104], [4.148, 104.948, 6.104, 6.104], [4.148, 25.748, 6.104, 6.104], [4.148, 32.948, 6.104, 6.104], [4.148, 18.548, 6.104, 6.104], [4.148, 11.348, 6.104, 6.104], [4.148, 4.148, 6.104, 6.104], [18.548, 68.948, 6.104, 6.104], [11.348, 76.148, 6.104, 6.104]]
		}, {
			"name":"Power Jack",
			"description":"Power JackThis is the standard 5.5mm barrel jack for power.The PTH is the most common, proven, reliable, footprint.All others are experimental.The Slot footprint only works if the mill layer is transmitted to the PCB fab house so be warned.Spark Fun Electronics SKU: PRT-00119.Mating wall wart: TOL-00298(and others)",
			"image":"core\/breadboard\/sparkfun-connectors_power_jack_smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_power_jack_smd_breadboard.svg",
			"width":"554.333",
			"height":"1000",
			"points": [[210.202, 933.05, 33.93, 33.9], [210.202, 33.05, 33.93, 33.9], [310.202, 933.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9]]
		}, {
			"name":"Graphical LCD 128x64",
			"description":"Graphical LCD 128x64 Footprint is not yet proven.Double check it.Spark Fun Electronics SKU: LCD-00710",
			"image":"core\/breadboard\/sparkfun-displays_lcd-g12864_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-displays_lcd-g12864_breadboard.svg",
			"width":"213.175",
			"height":"148.257",
			"points": [[310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9]]
		}
	]
}, {
	"page":"6",
	"count": 37,
	"el": [{
			"name":"ADXL180",
			"description":"Configurable 50-500g 1-axis MEMS accelerometer, digital output",
			"image":"core\/breadboard\/sparkfun-sensors_adxl180_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_adxl180_breadboard.svg",
			"width":"900",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Teensy 3.1",
			"description":"The Teensy is a complete USB-based microcontoller development system, in a very small footprint, capable of implementing many types of projects.All programming is done via the USB port.No special programmer is needed, only a standard micro-USB cable and a PC or Macintosh with a USB port.It has a USB keyboard\/mouse\/joystick emulation stack and can be programmed through Arduino IDE.",
			"image":"core\/breadboard\/teensy_3.1_breadboard.svg",
			"icon":"core\/breadboard\/teensy_3.1_breadboard.svg",
			"width":"103.465",
			"height":"50.598",
			"points": [[97.033, 0.815, 5.816, 5.816], [89.834, 0.815, 5.816, 5.816], [82.634, 0.815, 5.816, 5.816], [75.434, 0.815, 5.816, 5.816], [68.235, 0.815, 5.816, 5.816], [61.033, 0.815, 5.816, 5.816], [53.835, 0.815, 5.816, 5.816], [46.634, 0.815, 5.816, 5.816], [39.434, 0.815, 5.816, 5.816], [32.235, 0.815, 5.816, 5.816], [25.034, 0.815, 5.816, 5.816], [17.834, 0.815, 5.816, 5.816], [10.634, 0.815, 5.816, 5.816], [3.434, 0.815, 5.816, 5.816], [10.634, 9.041, 5.816, 5.816], [32.241, 9.041, 5.816, 5.816], [25.034, 9.041, 5.816, 5.816], [97.033, 44.014, 5.816, 5.816], [89.834, 44.014, 5.816, 5.816], [82.634, 44.014, 5.816, 5.816], [75.434, 44.014, 5.816, 5.816], [68.235, 44.014, 5.816, 5.816], [61.033, 44.014, 5.816, 5.816], [53.835, 44.014, 5.816, 5.816], [46.634, 44.014, 5.816, 5.816], [39.434, 44.014, 5.816, 5.816], [32.235, 44.014, 5.816, 5.816], [25.034, 44.014, 5.816, 5.816], [17.834, 44.014, 5.816, 5.816], [10.634, 44.014, 5.816, 5.816], [3.434, 44.014, 5.816, 5.816], [39.441, 9.042, 5.816, 5.816], [97.035, 29.615, 5.816, 5.816], [97.033, 36.815, 5.816, 5.816], [97.035, 22.415, 5.816, 5.816], [97.033, 8.015, 5.816, 5.816], [97.035, 15.214, 5.816, 5.816]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder JumperStandard SMD solder jumper.Used to automate production.Two varients: Normally Open and Normally Closed are the same, but have different paste layers.NC will have a large amount of paste and should jumper during reflow.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s-trace_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s-trace_breadboard.svg",
			"width":"246.5",
			"height":"400",
			"points": [[106.285, 333.05, 33.93, 33.9], [106.285, 33.05, 33.93, 33.9]]
		}, {
			"name":"LCD-16X2",
			"description":"Standard text-only 16x2 parallel input LCD",
			"image":"core\/breadboard\/sparkfun-displays_lcd-8x2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-displays_lcd-8x2_breadboard.svg",
			"width":"113.961",
			"height":"100.634",
			"points": [[54.012, 3.357, 5.938, 5.938], [54.012, 10.557, 5.938, 5.938], [46.812, 3.357, 5.938, 5.938], [39.612, 3.357, 5.938, 5.938], [32.412, 3.357, 5.938, 5.938], [46.812, 10.557, 5.938, 5.938], [39.612, 10.557, 5.938, 5.938], [32.412, 10.557, 5.938, 5.938], [61.212, 3.357, 5.938, 5.938], [68.412, 3.357, 5.938, 5.938], [75.611, 3.357, 5.938, 5.938], [82.812, 3.357, 5.938, 5.938], [61.212, 10.557, 5.938, 5.938], [68.412, 10.557, 5.938, 5.938], [75.611, 10.557, 5.938, 5.938], [82.812, 10.557, 5.938, 5.938]]
		}, {
			"name":"QFN-32",
			"description":"",
			"image":"core\/breadboard\/QFN-32_breadboard.svg",
			"icon":"core\/breadboard\/QFN-32_breadboard.svg",
			"width":"115.2",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Teensy 3.0",
			"description":"The Teensy is a complete USB-based microcontoller development system, in a very small footprint, capable of implementing many types of projects.All programming is done via the USB port.No special programmer is needed, only a standard micro-USB cable and a PC or Macintosh with a USB port.",
			"image":"core\/breadboard\/Teensy_3.0+pads_breadboard.svg",
			"icon":"core\/breadboard\/Teensy_3.0+pads_breadboard.svg",
			"width":"103.465",
			"height":"50.598",
			"points": [[97.033, 0.815, 5.816, 5.816], [89.834, 0.815, 5.816, 5.816], [82.633, 0.815, 5.816, 5.816], [75.434, 0.815, 5.816, 5.816], [68.235, 0.815, 5.816, 5.816], [61.033, 0.815, 5.816, 5.816], [53.834, 0.815, 5.816, 5.816], [46.634, 0.815, 5.816, 5.816], [39.434, 0.815, 5.816, 5.816], [32.235, 0.815, 5.816, 5.816], [25.034, 0.815, 5.816, 5.816], [17.834, 0.815, 5.816, 5.816], [10.634, 0.815, 5.816, 5.816], [3.434, 0.815, 5.816, 5.816], [10.634, 9.041, 5.816, 5.816], [32.241, 9.041, 5.816, 5.816], [25.034, 9.041, 5.816, 5.816], [97.033, 44.014, 5.816, 5.816], [89.834, 44.014, 5.816, 5.816], [82.633, 44.014, 5.816, 5.816], [75.434, 44.014, 5.816, 5.816], [68.235, 44.014, 5.816, 5.816], [61.033, 44.014, 5.816, 5.816], [53.834, 44.014, 5.816, 5.816], [46.634, 44.014, 5.816, 5.816], [39.434, 44.014, 5.816, 5.816], [32.235, 44.014, 5.816, 5.816], [25.034, 44.014, 5.816, 5.816], [17.834, 44.014, 5.816, 5.816], [10.634, 44.014, 5.816, 5.816], [3.434, 44.014, 5.816, 5.816], [39.441, 9.042, 5.816, 5.816], [97.035, 29.615, 5.816, 5.816], [97.033, 36.815, 5.816, 5.816], [97.035, 22.415, 5.816, 5.816], [97.033, 8.015, 5.816, 5.816], [97.035, 15.214, 5.816, 5.816], [90.08, 8.795, 5.348, 9.084], [82.879, 8.795, 5.35, 9.084], [75.68, 8.795, 5.348, 9.084], [68.479, 8.795, 5.352, 9.084], [61.279, 8.795, 5.348, 9.084], [54.078, 8.795, 5.35, 9.084], [46.879, 8.795, 5.349, 9.084], [90.08, 24.378, 5.348, 9.083], [82.879, 24.378, 5.35, 9.083], [75.68, 24.378, 5.348, 9.083], [68.479, 24.378, 5.352, 9.083], [61.279, 24.378, 5.348, 9.083], [54.078, 24.378, 5.35, 9.083], [46.879, 24.378, 5.349, 9.083]]
		}, {
			"name":"QFN-36",
			"description":"",
			"image":"core\/breadboard\/QFN-36_breadboard.svg",
			"icon":"core\/breadboard\/QFN-36_breadboard.svg",
			"width":"129.6",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968], [116.651, 37.4516, 4.29896, 4.2968], [116.651, 1.4516, 4.29896, 4.2968], [123.851, 37.4516, 4.29896, 4.2968], [123.851, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"7-SEGMENT-DISPLAY",
			"description":"",
			"image":"core\/breadboard\/7segment_13.svg",
			"icon":"core\/breadboard\/7segment_13.svg",
			"width":"35.77",
			"height":"50.232",
			"points": [[30.216, 1.418, 3.8, 3.8], [23.018, 1.417, 3.799, 3.8], [15.818, 1.417, 3.799, 3.8], [8.617, 1.417, 3.799, 3.8], [1.417, 1.417, 3.799, 3.8], [30.217, 44.617, 3.799, 3.8], [23.018, 44.617, 3.799, 3.8], [15.819, 44.617, 3.799, 3.8], [8.618, 44.617, 3.799, 3.8], [1.418, 44.617, 3.799, 3.8], [1.417, 1.417, 3.799, 3.8]]
		}, {
			"name":"NAND256",
			"description":"NAND flash",
			"image":"core\/breadboard\/sparkfun-digitalic_tsop48_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tsop48_breadboard.svg",
			"width":"2400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"VENUS634",
			"description":"Venus634 from SkyTraq",
			"image":"core\/breadboard\/sparkfun-rf_lga44_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_lga44_breadboard.svg",
			"width":"2200",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"STW5093",
			"description":"STW5093-PCM Audio Codec",
			"image":"core\/breadboard\/sparkfun-digitalic_tssop30_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tssop30_breadboard.svg",
			"width":"1500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"USB LiPoly Charger",
			"description":"If you need to charge LiPo batteries, this simple charger will do just that, and do it fast!The USB LiPo Charger is a basic charging circuit that allows you to charge 3.7V LiPo cells at a rate of 500mA or 100mA per hour.It is designed to charge single-cell Li-Ion or Li-Polymer batteries.Check the datasheet below to see if it will work with your battery.\tThe board incorporates a charging circuit, status LED, selectable solder jumper for 500mA or 100mA charging current, external LED footprint, USB input, mounting holes, and various holes for your own connectors.We include a single JST-tpye connector which connects directly to our LiPo batteries.The connector comes unsoldered, so you can use it or not.\tThere is also a'SYS OUT'which allows you to connect the charging circuit directly to your project so you don't need to disconnect the charger each time you want to use it.\tDocuments: \t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet(MCP73831T)\tReplaces: PRT-00726",
			"image":"core\/breadboard\/LiPo-USB-Charger-v21_breadboard.svg",
			"icon":"core\/breadboard\/LiPo-USB-Charger-v21_breadboard.svg",
			"width":"81.612",
			"height":"79.2",
			"points": [[14.48573, 25.51253, 5.04414, 5.04414], [14.48573, 19.84333, 5.04414, 5.04414], [14.48573, 54.31253, 5.04414, 5.04414], [14.48573, 48.64333, 5.04414, 5.04414]]
		}, {
			"name":"USB Connectors",
			"description":"USB ConnectorsUSB-B-PTH is fully proven SKU: PRT-00139USB-miniB is fully proven SKU: PRT-00587USB-A-PCB is untested.USB-A-H is throughly reviewed, but untested.Spark Fun Electronics SKU: PRT-00437USB-B-SMT is throughly reviewed, but untested.Needs silkscreen touching up.USB-A-S has not been used\/testedUSB-MB-H has not been used\/tested",
			"image":"core\/breadboard\/sparkfun-connectors_usb-a-pcb_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-a-pcb_breadboard.svg",
			"width":"783.333",
			"height":"1000",
			"points": [[324.702, 933.05, 33.93, 33.9], [324.702, 33.05, 33.93, 33.9], [424.702, 933.05, 33.93, 33.9], [424.702, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino GSM Shield",
			"description":"The Arduino GSM Shield allows an Arduino board to connect to the internet, make\/receive voice calls and send\/receive SMS messages.The shield uses a radio modem M10 by Quectel(datasheet).It is possible to communicate with the board using AT commands.The GSM library has a large number of methods for communication with the shield.The shield uses digital pins 2 and 3 for software serial communication with the M10.Pin 2 is connected to the M10 \ u2019s TX pin and pin 3 to its RX pin.See these notes for working with an Arduino Mega, Mega ADK, or Leonardo.The modem's PWRKEY pin is connected to Arduino pin 7.The M10 is a Quad-band GSM\/GPRS modem that works at frequencies GSM850MHz, GSM900MHz, DCS1800MHz and PCS1900MHz.It supports TCP\/UDP and HTTP protocols through a GPRS connection.GPRS data downlink and uplink transfer speed maximum is 85.6 kbps.To interface with the cellular network, the board requires a SIM card provided by a network operator.See the getting started page for additional information on SIM usage.The most recent revision of the board uses the 1.0 pinout on rev 3 of the Arduino Uno board.",
			"image":"core\/breadboard\/GSM-Quectel_updateTID_2_v1.3_breadboard.svg",
			"icon":"core\/breadboard\/GSM-Quectel_updateTID_2_v1.3_breadboard.svg",
			"width":"288",
			"height":"151.2",
			"points": [[50.574, 4.494, 5.412, 5.412], [57.774, 4.494, 5.412, 5.412], [64.974, 4.494, 5.412, 5.412], [72.174, 4.494, 5.412, 5.412], [79.374, 4.494, 5.412, 5.412], [86.574, 4.494, 5.412, 5.412], [93.774, 4.494, 5.412, 5.412], [100.974, 4.494, 5.412, 5.412], [108.174, 4.494, 5.412, 5.412], [115.374, 4.494, 5.412, 5.412], [76.493, 141.293, 5.414, 5.414], [83.693, 141.293, 5.414, 5.414], [90.893, 141.293, 5.414, 5.414], [98.093, 141.293, 5.414, 5.414], [105.293, 141.293, 5.414, 5.414], [112.493, 141.293, 5.414, 5.414], [119.693, 141.293, 5.414, 5.414], [126.893, 141.293, 5.414, 5.414], [177.294, 4.494, 5.412, 5.412], [170.094, 4.494, 5.412, 5.412], [162.894, 4.494, 5.412, 5.412], [155.694, 4.494, 5.412, 5.412], [148.494, 4.494, 5.412, 5.412], [141.294, 4.494, 5.412, 5.412], [134.094, 4.494, 5.412, 5.412], [126.894, 4.494, 5.412, 5.412], [141.293, 141.293, 5.414, 5.414], [148.493, 141.293, 5.414, 5.414], [155.693, 141.293, 5.414, 5.414], [162.893, 141.293, 5.414, 5.414], [170.093, 141.293, 5.414, 5.414], [177.293, 141.293, 5.414, 5.414]]
		}, {
			"name":"Arduino",
			"description":"The awesome Arduino microcontroller",
			"image":"obsolete\/breadboard\/controller_arduino_uno_r3.svg",
			"icon":"obsolete\/breadboard\/controller_arduino_uno_r3.svg",
			"width":"212.184",
			"height":"148.032",
			"points": [[67.2933, 3.11, 4.774, 4.773], [74.471, 3.11, 4.774, 4.773], [81.648, 3.11, 4.774, 4.773], [88.825, 3.11, 4.772, 4.773], [96.003, 3.11, 4.772, 4.773], [103.18, 3.11, 4.774, 4.773], [110.359, 3.11, 4.773, 4.773], [117.535, 3.11, 4.772, 4.773], [124.714, 3.11, 4.773, 4.773], [131.892, 3.11, 4.773, 4.773], [146.438, 3.11, 4.772, 4.773], [153.615, 3.11, 4.773, 4.773], [160.792, 3.11, 4.772, 4.773], [167.97, 3.11, 4.772, 4.773], [175.147, 3.11, 4.774, 4.773], [182.324, 3.11, 4.772, 4.773], [189.502, 3.11, 4.771, 4.773], [196.68, 3.11, 4.774, 4.773], [96.043, 139.887, 4.774, 4.771], [103.243, 139.887, 4.774, 4.771], [110.443, 139.887, 4.774, 4.771], [117.642, 139.887, 4.774, 4.771], [124.84, 139.887, 4.773, 4.771], [132.018, 139.887, 4.772, 4.771], [139.196, 139.887, 4.774, 4.771], [146.372, 139.887, 4.773, 4.771], [160.835, 139.887, 4.771, 4.771], [168.012, 139.887, 4.773, 4.771], [175.19, 139.887, 4.773, 4.771], [182.367, 139.887, 4.772, 4.771], [189.544, 139.887, 4.772, 4.771], [196.722, 139.887, 4.771, 4.771]]
		}, {
			"name":"SWITCH-MOMENTARY-2",
			"description":"Various NO switches-pushbuttons, reed, etc",
			"image":"core\/breadboard\/sparkfun-electromechanical_tactile_switch_smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_tactile_switch_smd_breadboard.svg",
			"width":"474.306",
			"height":"600",
			"points": [[170.188, 533.05, 33.93, 33.9], [170.188, 33.05, 33.93, 33.9], [270.188, 533.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9]]
		}, {
			"name":"TS3A5017",
			"description":"Dual-channel 4: 1 analog mux",
			"image":"core\/breadboard\/SO16_breadboard.svg",
			"icon":"core\/breadboard\/SO16_breadboard.svg",
			"width":"57.6",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"25LC640",
			"description":"25LC640 SPI EEPROM",
			"image":"core\/breadboard\/25LC640_breadboard.svg",
			"icon":"core\/breadboard\/25LC640_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"Temperature Sensor(Thermistor)",
			"description":"A 10k NTC Thermistor(Temperature Sensor)",
			"image":"core\/breadboard\/ceramic_disk_thermistor_leg.svg",
			"icon":"core\/breadboard\/ceramic_disk_thermistor_leg.svg",
			"width":"23",
			"height":"22.998",
			"points": [[-1, 11.75, 5, 3], [19, 11.75, 5, 3]]
		}, {
			"name":"RESONATOR-WIDE",
			"description":"",
			"image":"core\/breadboard\/sparkfun-freqctrl_resonator-wide-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-freqctrl_resonator-wide-smd_breadboard.svg",
			"width":"463.78",
			"height":"600",
			"points": [[164.925, 533.05, 33.93, 33.9], [264.925, 533.05, 33.93, 33.9], [264.925, 33.05, 33.93, 33.9]]
		}, {
			"name":"100k \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_100k.svg",
			"icon":"obsolete\/breadboard\/resistor_100k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_cr75_v2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_cr75_v2_breadboard.svg",
			"width":"520.069",
			"height":"600",
			"points": [[243.069, 533.05, 33.93, 33.9], [243.069, 33.05, 33.93, 33.9]]
		}, {
			"name":"100k \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_100k.svg",
			"icon":"obsolete\/breadboard\/resistor_100k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"ATMEGA32U4",
			"description":"Atmel 44-pin 8-bit Microcontroller with 32KBytes of ISP Flash and USB Controller",
			"image":"core\/breadboard\/sparkfun-digitalic_qfn-44-nopad_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_qfn-44-nopad_breadboard.svg",
			"width":"2200",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"POT",
			"description":"",
			"image":"core\/breadboard\/Rotary_Encoder.svg",
			"icon":"core\/breadboard\/Rotary_Encoder.svg",
			"width":"33.046",
			"height":"39.852",
			"points": [[7.215, 35.422, 4.834, 4.5], [14.424, 35.501, 4.835, 4.25], [21.736, 35.626, 4.836, 4.25]]
		}, {
			"name":"LASSEN_IQ_GPS",
			"description":"Lassen iq 12-Channel GPS receiver.Schematic and footprint production proven.Spark Fun Electronics SKU: GPS-00163.Surface mount mating connector: GPS-00170",
			"image":"core\/breadboard\/sparkfun-rf_lassen_iq_gps_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_lassen_iq_gps_breadboard.svg",
			"width":"770.861",
			"height":"800",
			"points": [[118.465, 733.05, 33.93, 33.9], [118.465, 33.05, 33.93, 33.9], [218.465, 733.05, 33.93, 33.9], [218.465, 33.05, 33.93, 33.9], [318.466, 733.05, 33.93, 33.9], [318.466, 33.05, 33.93, 33.9], [418.466, 733.05, 33.93, 33.9], [418.466, 33.05, 33.93, 33.9], [518.466, 733.05, 33.93, 33.9], [518.466, 33.05, 33.93, 33.9], [618.466, 733.05, 33.93, 33.9], [618.466, 33.05, 33.93, 33.9]]
		}, {
			"name":"MN5010HS",
			"description":"MN5010HS GPS Receiver Module.Packagse GR-10 and MN5010HS are NOT tested with this device.",
			"image":"core\/breadboard\/sparkfun-rf_gr-10_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_gr-10_breadboard.svg",
			"width":"1800",
			"height":"800",
			"points": [[33.035, 733.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 733.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 733.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 733.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 733.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 733.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 733.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 733.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 733.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 733.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 733.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 733.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 733.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 733.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 733.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 733.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 733.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 733.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"GogoBoard 4.0",
			"description":"The GoGo board framework is a collection of open-source hardware platforms mainly aimed for educational projects.",
			"image":"core\/breadboard\/gogoboard_4.043282.svg",
			"icon":"core\/breadboard\/gogoboard_4.043282.svg",
			"width":"283.387",
			"height":"180.539",
			"points": [[60.815, 3.392, 6.128, 6.128], [46.176, 3.392, 6.128, 6.128], [171.397, 166.687, 4.771, 4.771], [164.221, 166.687, 4.773, 4.771], [157.023, 166.687, 4.772, 4.771], [149.827, 166.687, 4.771, 4.771], [171.397, 159.51, 4.771, 4.771], [164.221, 159.51, 4.773, 4.771], [157.023, 159.51, 4.772, 4.771], [149.827, 159.51, 4.771, 4.771], [124.242, 166.687, 4.771, 4.771], [117.065, 166.687, 4.773, 4.771], [109.868, 166.687, 4.771, 4.771], [102.671, 166.687, 4.771, 4.771], [124.242, 159.51, 4.771, 4.771], [117.065, 159.51, 4.773, 4.771], [109.868, 159.51, 4.771, 4.771], [102.671, 159.51, 4.771, 4.771], [171.397, 144.896, 4.771, 4.771], [164.221, 144.896, 4.773, 4.771], [157.023, 144.896, 4.772, 4.771], [149.827, 144.896, 4.771, 4.771], [124.242, 144.896, 4.771, 4.771], [117.065, 144.896, 4.773, 4.771], [109.868, 144.896, 4.771, 4.771], [102.671, 144.896, 4.771, 4.771], [60.446, 106.953, 4.771, 4.773], [60.446, 99.756, 4.771, 4.773], [60.446, 92.582, 4.771, 4.771], [267.124, 110.543, 4.771, 4.773], [267.124, 103.364, 4.771, 4.772], [267.124, 96.168, 4.771, 4.772], [267.124, 88.993, 4.771, 4.771], [259.948, 110.543, 4.771, 4.773], [259.948, 103.364, 4.771, 4.772], [259.948, 96.168, 4.771, 4.772], [259.948, 88.993, 4.771, 4.771], [262.549, 25.935, 4.3, 4.3], [262.549, 18.735, 4.3, 4.3], [262.549, 11.535, 4.3, 4.3], [249.442, 25.693, 4.771, 4.773], [249.442, 18.496, 4.771, 4.773], [249.442, 11.322, 4.771, 4.771], [242.267, 25.693, 4.771, 4.773], [242.267, 18.496, 4.771, 4.773], [242.267, 11.322, 4.771, 4.771], [226.543, 25.935, 4.299, 4.3], [226.543, 18.735, 4.299, 4.3], [226.543, 11.535, 4.299, 4.3], [172.601, 25.935, 4.3, 4.3], [172.601, 18.735, 4.3, 4.3], [172.601, 11.535, 4.3, 4.3], [158.672, 25.693, 4.771, 4.773], [158.672, 18.496, 4.771, 4.773], [158.672, 11.322, 4.771, 4.771], [151.497, 25.693, 4.771, 4.773], [151.497, 18.496, 4.771, 4.773], [151.497, 11.322, 4.771, 4.771], [136.536, 25.935, 4.3, 4.3], [136.536, 18.735, 4.3, 4.3], [136.536, 11.535, 4.3, 4.3]]
		}, {
			"name":"ACS712 Low Current Sensor Board v12",
			"description":"This current sensor gives precise current measurement for both AC and DC signals.These are good sensors for metering and measuring overall power consumption of systems.The ACS712 current sensor measures up to 5A of DC or AC current.We added an opamp gain stage for more sensitive current measurements.By adjusting the gain(from 4.27 to 47)you can measure very small currents.\t\tThe ACS712 Low Current Sensor Breakout outputs an analog voltage that varies linearly with sensed current.To calibrate, first set the output offset to the desired level(with zero current on the sense lines, read output with a DVM).Then with a known current input(a 100mA limited supply works well for this), set the output deflection with the gain pot.Sensitivity is then calculated as(Vref-Vdeflect)\/(current input).\t\tThe bandwidth on the ASC712 Low Current Sensor Breakout has been set to 34Hz to reduce noise when using at high gains.The full 80KHz bandwidth that the sensor is capable of can be recovered by removing C1.See schematic for more details.\t\tDocuments: \t\t\tACS712 Datasheet\t\t\tSchematic\t\t\tWiring Example",
			"image":"core\/breadboard\/ACS712 Low Current Sensor Board v12_breadboard.svg",
			"icon":"core\/breadboard\/ACS712 Low Current Sensor Board v12_breadboard.svg",
			"width":"82.8",
			"height":"43.2",
			"points": [[2.44268, 2.44268, 9.51464, 9.51464], [2.44268, 31.24268, 9.51464, 9.51464], [76.328, 25.928, 5.744, 5.744], [76.328, 18.728, 5.744, 5.744], [76.328, 11.528, 5.744, 5.744], [4.328, 15.128, 5.744, 5.744], [4.328, 22.328, 5.744, 5.744]]
		}, {
			"name":"pnp-Powertransistor",
			"description":"A pnp transistor which can drive a higher load",
			"image":"core\/breadboard\/powertransistor_pnp.svg",
			"icon":"core\/breadboard\/powertransistor_pnp.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"Generic female header-2 pins",
			"description":"Generic female header",
			"image":"obsolete\/breadboard\/generic-female-header_bread_2.svg",
			"icon":"obsolete\/breadboard\/generic-female-header_bread_2.svg",
			"width":"14.358",
			"height":"7.178",
			"points": [[1.202, 1.202, 4.775, 4.775], [8.381, 1.202, 4.775, 4.775]]
		}, {
			"name":"ULN2003A",
			"description":"ULN2003A 7-way Darlington Transistor Driver",
			"image":"core\/breadboard\/ULN2003A_breadboard.svg",
			"icon":"core\/breadboard\/ULN2003A_breadboard.svg",
			"width":"800",
			"height":"330",
			"points": [[34, 285.6, 32, 45.4], [34, -1, 32, 45.4], [734, 285.6, 32, 45.4], [734, -1, 32, 45.4], [134, 285.6, 32, 45.4], [134, -1, 32, 45.4], [234, 285.6, 32, 45.4], [234, -1, 32, 45.4], [334, 285.6, 32, 45.4], [334, -1, 32, 45.4], [434, 285.6, 32, 45.4], [434, -1, 32, 45.4], [534, 285.6, 32, 45.4], [534, -1, 32, 45.4], [634, 285.6, 32, 45.4], [634, -1, 32, 45.4]]
		}, {
			"name":"ATMEGA168",
			"description":"Atmel 32-pin 8-bit micro, 16k flash.",
			"image":"core\/breadboard\/sparkfun-digitalic_mlf32_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_mlf32_breadboard.svg",
			"width":"1600",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"A4983",
			"description":"DMOS Microstepping Driver with Translator",
			"image":"core\/breadboard\/sparkfun-poweric_qfn-28-5mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_qfn-28-5mm_breadboard.svg",
			"width":"1500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Pro",
			"description":"The Arduino Pro is a microcontroller board based on the ATmega168(datasheet)or ATmega328(datasheet).The Pro comes in both 3.3V\/8 MHz and 5V\/16 MHz versions.It has 14 digital input\/output pins(of which 6 can be used as PWM outputs), 6 analog inputs, a battery power jack, a power switch , a reset button, and holes for mounting a power jack, an ICSP header, and pin headers.A six pin header can be connected to an FTDI cable or Sparkfun breakout board to provide USB power and communication to the board.The Arduino Pro is intended for semi-permanent installation in objects or exhibitions.The board comes without pre-mounted headers, allowing the use of various types of connectors or direct soldering of wires.The pin layout is compatible with Arduino shields.The 3.3V versions of the Pro can be powered with a battery.The Arduino Pro was designed and manufactured by SparkFun Electronics.",
			"image":"core\/breadboard\/Arduino_Pro_breadboard.svg",
			"icon":"core\/breadboard\/Arduino_Pro_breadboard.svg",
			"width":"155.957",
			"height":"156.79",
			"points": [[138.685, 4.328, 5.744, 5.744], [131.484, 4.328, 5.744, 5.744], [124.284, 4.328, 5.744, 5.744], [117.084, 4.328, 5.744, 5.744], [109.885, 4.328, 5.744, 5.744], [102.685, 4.328, 5.744, 5.744], [95.484, 4.328, 5.744, 5.744], [88.284, 4.328, 5.744, 5.744], [102.685, 141.128, 5.744, 5.744], [109.885, 141.128, 5.744, 5.744], [117.084, 141.128, 5.744, 5.744], [124.284, 141.128, 5.744, 5.744], [131.484, 141.128, 5.744, 5.744], [138.685, 141.128, 5.744, 5.744], [76.404, 4.328, 5.744, 5.744], [69.205, 4.328, 5.744, 5.744], [62.005, 4.328, 5.744, 5.744], [54.805, 4.328, 5.744, 5.744], [47.604, 4.328, 5.744, 5.744], [40.405, 4.328, 5.744, 5.744], [33.205, 4.328, 5.744, 5.744], [26.005, 4.328, 5.744, 5.744], [52.285, 141.128, 5.744, 5.744], [59.484, 141.128, 5.744, 5.744], [66.684, 141.128, 5.744, 5.744], [73.885, 141.128, 5.744, 5.744], [81.085, 141.128, 5.744, 5.744], [88.284, 141.128, 5.744, 5.744], [138.685, 61.928, 5.744, 5.744], [145.885, 61.928, 5.744, 5.744], [138.685, 69.128, 5.744, 5.744], [145.885, 69.128, 5.744, 5.744], [138.685, 76.328, 5.744, 5.744], [145.885, 76.328, 5.744, 5.744], [45.085, 43.928, 5.744, 5.744], [45.085, 36.728, 5.744, 5.744], [9.085, 115.928, 5.744, 5.744], [9.085, 108.44, 5.744, 5.744], [64.762, 168.877, 4.988, 4.988], [70.432, 168.877, 4.988, 4.988], [64.762, 163.209, 4.988, 4.988], [70.432, 163.209, 4.988, 4.988], [64.762, 157.538, 4.988, 4.988], [70.432, 157.538, 4.988, 4.988], [67.03, 149.601, 6.122, 6.122], [67.03, 175.68, 6.122, 6.122], [2.851, 2.851, 6, 6], [2.851, 2.851, 6, 6], [2.851, 2.851, 6, 6], [2.851, 2.851, 6, 6], [2.851, 2.851, 6, 6], [2.851, 2.851, 6, 6]]
		}, {
			"name":"Pre-Assembled Female BNC",
			"description":"We once had a batch of pH Circuits that were not working correctly.After three days of investigating, we finally determined that the BNC connector we were using were to blame.The material it was made out of was bronze, which has poor conductivity properties and was not able to properly transmit the extremely low signal of the pH Sensor.Never underestimate the importance of good connectors.It can mean the difference between good scientific data or no data at all. \ u2022 Pre-Assembled Female BNC Connector \ u2022 Center contact: Gold plated Brass \ u2022 Designed for RF applications \ u2022 Right angle \ u2022 50ohm impedance \ u2022 Designed to be easily connected into a breadboard for rapid development",
			"image":"core\/breadboard\/atlas-sientific_Pre-AssembledFemaleBNC_breadboard.svg",
			"icon":"core\/breadboard\/atlas-sientific_Pre-AssembledFemaleBNC_breadboard.svg",
			"width":"40.9",
			"height":"122.483",
			"points": [[10.212, 2.024, 6.052, 6.052], [17.411, 2.024, 6.052, 6.052], [24.518, 2.015, 6.241, 6.062]]
		}, {
			"name":"PIC24HJ32GP202",
			"description":"",
			"image":"core\/breadboard\/SO-28W_breadboard.svg",
			"icon":"core\/breadboard\/SO-28W_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Screw terminal-2 pins",
			"description":"Screw terminal with 2 pins",
			"image":"core\/breadboard\/screw_terminal_2_100mil_bread.svg",
			"icon":"core\/breadboard\/screw_terminal_2_100mil_bread.svg",
			"width":"200",
			"height":"170",
			"points": [[33.2884, 108.874, 33.5235, 62.0844], [133.2884, 108.874, 33.5235, 62.0844]]
		}, {
			"name":"Thermal Printer",
			"description":"This is a thermal printer like you would find on a cash register or adding machine.It will print simple strings passed to it via TTL serial, bitmap images(poorly)and it even generates several different formats of barcodes!\tThe thermal printer takes 2.25'(57mm)wide thermal paper with a max roll diameter of 1.5'(39mm).Thermal paper is inexpensive and commonly found in most office supply stores in 85ft lengths.You may have to remove some paper from these rolls in order for it to fit into the printer.But, you can always use the excess paper in the printer, since you don't need to have a'core'in the paper for it to work.\tThe back panel has 2 3-pin connectors; one for power and one for serial communications.The thermal printer ships with default 19200bps baud rate.If you' re using this printer in conjunction with an Arduino, you're going to need to connect it to the 'Vin'pin and attach an external power supply, as the printer will draw more current than USB is capable of delivering.We've found that a 5V wall adapter works best(see related products below).\tThe print head has a rated life of 50km!That means this printer can handle a marathon's distance(~30 miles)of printing before the head hits its rated limit.\tUse this printer in any project where you need a hard-copy of the output, or in an art project where you want to keep the output to stick on your fridge, or to build a DIY cash register for your lemonade stand!\tDocuments: \t\t\tProduct Sheet\t\t\tUser Manual\t\t\tCommand Set\t\t\tExample Code\t\t\tTronixstuff Tutorial\t\t\tBildr Tutorial",
			"image":"core\/breadboard\/thermalprinter_breadboard.svg",
			"icon":"core\/breadboard\/thermalprinter_breadboard.svg",
			"width":"240.461",
			"height":"146.197",
			"points": [[128.532, 4.513, 4.997, 3.257], [121.332, 4.513, 5, 3.257], [114.071, 4.513, 5, 3.257], [197.026, 4.513, 5, 3.257], [189.888, 4.513, 4.997, 3.257]]
		}, {
			"name":"LM35 Temperature Sensor",
			"description":"A LM35 temperature sensor with a temperature range from-55 \ u00b0C to 150 \ u00b0C.",
			"image":"core\/breadboard\/lm35.svg",
			"icon":"core\/breadboard\/lm35.svg",
			"width":"16.527",
			"height":"24.082",
			"points": [[-1, 21.082, 4.16, 3], [6.181, 21.082, 4.159, 3], [13.367, 21.082, 4.16, 3]]
		}, {
			"name":"Arduino Mini Proto Shield",
			"description":"This is a small prototyping shield for the Arduino Pro Mini.If your project requires just a little bit more space for your external circuitry, this might be a perfect addition.38 unconnected PTHs are provided for your prototyping needs.\tThe shield fits the small form factor of the Arduino Pro Mini-connecting to the'top'four pins on each side of the Mini(' GND '-' TXO'&'VCC '-' RAW ').There are small buses for VCC, GND and RAW.In addition to the power buses, the serial pins are also broken out on the shield.The analog and digital pins are not broken out on the shield.\tFeatures: \t\t\tVCC, RAW and GND buses\t\t\tSerial(RXI & TXO)pins broken out to small buses\t\t\tWorks with both 5V and 3.3V Pro Mini versions\t\t\tUpholds the Pro Mini's small form factor\t\t\t38 unconnected PTHs for prototyping",
			"image":"core\/breadboard\/ProtoShield-Mini-v12_breadboard.svg",
			"icon":"core\/breadboard\/ProtoShield-Mini-v12_breadboard.svg",
			"width":"50.4",
			"height":"86.4",
			"points": [[0.548, 22.148, 6.104, 6.104], [0.548, 14.948, 6.104, 6.104], [0.548, 7.748, 6.104, 6.104], [0.548, 0.548, 6.104, 6.104], [43.748, 0.548, 6.104, 6.104], [43.748, 7.748, 6.104, 6.104], [43.748, 14.948, 6.104, 6.104], [43.748, 22.148, 6.104, 6.104], [14.948, 36.548, 6.104, 6.104], [14.948, 43.748, 6.104, 6.104], [14.948, 50.948, 6.104, 6.104], [14.948, 29.348, 6.104, 6.104], [7.748, 22.148, 6.104, 6.104], [36.548, 7.748, 6.104, 6.104], [29.348, 7.748, 6.104, 6.104], [29.348, 79.748, 6.104, 6.104], [22.148, 58.148, 6.104, 6.104], [29.348, 58.148, 6.104, 6.104], [22.148, 50.948, 6.104, 6.104], [22.148, 43.748, 6.104, 6.104], [22.148, 65.348, 6.104, 6.104], [29.348, 72.548, 6.104, 6.104], [22.148, 72.548, 6.104, 6.104], [22.148, 79.748, 6.104, 6.104], [14.948, 79.748, 6.104, 6.104], [14.948, 72.548, 6.104, 6.104], [22.148, 22.148, 6.104, 6.104], [14.948, 65.348, 6.104, 6.104], [29.348, 65.348, 6.104, 6.104], [14.948, 58.148, 6.104, 6.104], [7.748, 79.748, 6.104, 6.104], [7.748, 72.548, 6.104, 6.104], [7.748, 65.348, 6.104, 6.104], [7.748, 58.148, 6.104, 6.104], [7.748, 50.948, 6.104, 6.104], [22.148, 36.548, 6.104, 6.104], [7.748, 43.748, 6.104, 6.104], [7.748, 36.548, 6.104, 6.104], [7.748, 29.348, 6.104, 6.104], [36.548, 29.348, 6.104, 6.104], [36.548, 36.548, 6.104, 6.104], [36.548, 43.748, 6.104, 6.104], [36.548, 50.948, 6.104, 6.104], [36.548, 58.148, 6.104, 6.104], [36.548, 65.348, 6.104, 6.104], [36.548, 72.548, 6.104, 6.104], [36.548, 79.748, 6.104, 6.104], [22.148, 29.348, 6.104, 6.104], [36.548, 14.948, 6.104, 6.104], [29.348, 14.948, 6.104, 6.104], [22.148, 14.948, 6.104, 6.104], [14.948, 14.948, 6.104, 6.104], [7.748, 14.948, 6.104, 6.104], [36.548, 0.548, 6.104, 6.104], [29.348, 0.548, 6.104, 6.104], [7.748, 7.748, 6.104, 6.104], [14.948, 7.748, 6.104, 6.104], [7.748, 0.548, 6.104, 6.104], [14.948, 0.548, 6.104, 6.104], [36.548, 22.148, 6.104, 6.104], [29.348, 29.348, 6.104, 6.104], [29.348, 36.548, 6.104, 6.104], [29.348, 43.748, 6.104, 6.104], [29.348, 50.948, 6.104, 6.104]]
		}, {
			"name":"QFN-20-0.4MM",
			"description":"",
			"image":"core\/breadboard\/QFN-20-0.4MM_breadboard.svg",
			"icon":"core\/breadboard\/QFN-20-0.4MM_breadboard.svg",
			"width":"72",
			"height":"28.8",
			"points": [[1.45052, 23.0516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 23.0516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 23.0516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 23.0516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 23.0516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 23.0516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 23.0516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 23.0516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 23.0516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 23.0516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Intel Galileo",
			"description":"Galileo is a microcontroller board based on the Intel \ u00ae Quark SoC X1000 Application Processor, a 32-bit Intel Pentium-class system on a chip(datasheet).It \ u2019s the first board based on Intel \ u00ae architecture designed to be hardware and software pin-compatible with Arduino shields designed for the Uno R3.Digital pins 0 to 13(and the adjacent AREF and GND pins), Analog inputs 0 to 5, the power header, ICSP header, and the UART port pins(0 and 1), are all in the same locations as on the Arduino Uno R3.This is also known as the Arduino 1.0 pinout.Galileo is designed to support shields that operate at either 3.3V or 5V.The core operating voltage of Galileo is 3.3V.However, a jumper on the board enables voltage translation to 5V at the I\/O pins.This provides support for 5V Uno shields and is the default behavior.By switching the jumper position, the voltage translation can be disabled to provide 3.3V operation at the I\/O pins.Of course, the Galileo board is also software compatible with the Arduino Software Development Environment(IDE), which makes usability and introduction a snap.In addition to Arduino hardware and software compatibility, the Galileo board has several PC industry standard I\/O ports and features to expand native usage and capabilities beyond the Arduino shield ecosystem.A full sized mini-PCI Express slot, 100Mb Ethernet port, Micro-SD slot, RS-232 serial port, USB Host port, USB Client port, and 8MByte NOR flash come standard on the board.Visit the FAQ page for further informations.",
			"image":"core\/breadboard\/intel-arduino-galileo_breadboard.svg",
			"icon":"core\/breadboard\/intel-arduino-galileo_breadboard.svg",
			"width":"308.578",
			"height":"210.324",
			"points": [[256.537, 176.316, 5.218, 5.218], [263.737, 176.316, 5.218, 5.218], [270.935, 176.316, 5.218, 5.218], [278.137, 176.316, 5.218, 5.218], [285.334, 176.316, 5.218, 5.218], [292.537, 176.316, 5.218, 5.218], [292.733, 96.954, 5.544, 5.544], [299.933, 96.954, 5.544, 5.544], [292.734, 104.155, 5.542, 5.542], [299.934, 104.155, 5.542, 5.542], [292.734, 111.354, 5.542, 5.542], [299.934, 111.354, 5.542, 5.542], [230.615, 39.516, 5.22, 5.22], [223.413, 39.516, 5.22, 5.22], [216.214, 39.516, 5.22, 5.22], [209.015, 39.516, 5.22, 5.22], [201.815, 39.516, 5.22, 5.22], [194.615, 39.516, 5.22, 5.22], [187.413, 39.516, 5.22, 5.22], [180.214, 39.516, 5.22, 5.22], [173.015, 39.516, 5.22, 5.22], [165.815, 39.516, 5.22, 5.22], [292.536, 39.516, 5.22, 5.22], [285.333, 39.516, 5.22, 5.22], [278.136, 39.516, 5.22, 5.22], [270.934, 39.516, 5.22, 5.22], [263.736, 39.516, 5.22, 5.22], [256.536, 39.516, 5.22, 5.22], [249.333, 39.516, 5.22, 5.22], [242.136, 39.516, 5.22, 5.22], [198.935, 176.316, 5.218, 5.218], [206.137, 176.316, 5.218, 5.218], [213.334, 176.316, 5.218, 5.218], [220.537, 176.316, 5.218, 5.218], [227.737, 176.316, 5.218, 5.218], [234.935, 176.316, 5.218, 5.218], [242.137, 176.316, 5.218, 5.218], [191.737, 176.316, 5.218, 5.218], [267.519, 15.503, 5.544, 5.544], [267.519, 22.702, 5.544, 5.544], [260.32, 15.504, 5.542, 5.542], [260.32, 22.703, 5.542, 5.542], [253.122, 15.504, 5.542, 5.542], [253.122, 22.703, 5.542, 5.542], [245.959, 22.703, 5.542, 5.542], [38.447, 29.333, 5.544, 5.544], [38.448, 22.135, 5.542, 5.542], [38.448, 14.935, 5.542, 5.542], [191.576, 189.477, 5.544, 5.544], [198.775, 189.478, 5.542, 5.542], [205.975, 189.478, 5.542, 5.542], [221.559, 189.478, 5.542, 5.542], [228.758, 189.478, 5.542, 5.542], [106.223, 158.964, 5.542, 5.542], [113.422, 158.964, 5.542, 5.542], [78.64, 203.2, 3.176, 3.176], [74.983, 203.2, 3.176, 3.176], [71.327, 203.2, 3.176, 3.176], [67.67, 203.2, 3.176, 3.176], [64.013, 203.2, 3.176, 3.176], [78.64, 199.544, 3.176, 3.176], [74.983, 199.544, 3.176, 3.176], [71.327, 199.544, 3.176, 3.176], [67.67, 199.544, 3.176, 3.176], [64.013, 199.544, 3.176, 3.176]]
		}
	]
}, {
	"page":"7",
	"count": 37,
	"el": [{
			"name":"RS485_SP491",
			"description":"RS485 transceiver",
			"image":"core\/breadboard\/SOIC-14_breadboard.svg",
			"icon":"core\/breadboard\/SOIC-14_breadboard.svg",
			"width":"50.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Header 1",
			"description":"Header 1Standard 1-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).",
			"image":"core\/breadboard\/sparkfun-connectors_snap-female_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_snap-female_breadboard.svg",
			"width":"8.255",
			"height":"8.255",
			"points": [[1.25425, 1.25425, 5.7465, 5.7465]]
		}, {
			"name":"AMPHENOL-ACJS-MHDR",
			"description":"AMPHENOL-ACJS-MHDR-JACK, 6.35MM, PCB, STEREO)",
			"image":"core\/breadboard\/AMPHENOL-ACJS-MHDR_breadboard.svg",
			"icon":"core\/breadboard\/AMPHENOL-ACJS-MHDR_breadboard.svg",
			"width":"82.813",
			"height":"48.38",
			"points": [[19.49, 38.155, 4.16, 4.16], [19.49, 5.84, 4.16, 4.16], [55.49, 38.155, 4.16, 4.16], [55.49, 5.84, 4.16, 4.16], [37.49, 5.546, 4.16, 4.16], [37.49, 38.155, 4.16, 4.16]]
		}, {
			"name":"Mystery Part-6 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 6 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part6.svg",
			"icon":"obsolete\/breadboard\/mystery_part6.svg",
			"width":"62",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002], [52.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"Generic female header-metal rounded-16 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_16.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_16.svg",
			"width":"114.864",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783], [15.556, 1.197, 4.783, 4.783], [22.735, 1.197, 4.783, 4.783], [29.914, 1.197, 4.783, 4.783], [37.093, 1.197, 4.783, 4.783], [44.272, 1.197, 4.783, 4.783], [51.451, 1.197, 4.783, 4.783], [58.63, 1.197, 4.783, 4.783], [65.809, 1.197, 4.783, 4.783], [72.988, 1.197, 4.783, 4.783], [80.167, 1.197, 4.783, 4.783], [87.346, 1.197, 4.783, 4.783], [94.525, 1.197, 4.783, 4.783], [101.704, 1.197, 4.783, 4.783], [108.883, 1.197, 4.783, 4.783]]
		}, {
			"name":"Mystery Part-5 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 5 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part5.svg",
			"icon":"obsolete\/breadboard\/mystery_part5.svg",
			"width":"52",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"Ceramic Capacitor",
			"description":"0.01 nF multilayered Ceramic Capacitor",
			"image":"core\/breadboard\/ceramic_capacitor_blue_leg.svg",
			"icon":"core\/breadboard\/ceramic_capacitor_blue_leg.svg",
			"width":"18.836",
			"height":"24.827",
			"points": [[1.919, 13.826, 5, 3], [11.919, 13.826, 5, 3]]
		}, {
			"name":"SWITCH-MOMENTARY-2",
			"description":"Various NO switches-pushbuttons, reed, etc",
			"image":"core\/breadboard\/sparkfun-electromechanical_tactile_switch_smd-2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_tactile_switch_smd-2_breadboard.svg",
			"width":"474.306",
			"height":"600",
			"points": [[170.188, 533.05, 33.93, 33.9], [170.188, 33.05, 33.93, 33.9], [270.188, 533.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9]]
		}, {
			"name":"LilyPad Arduino Simple Board",
			"description":"This is the LilyPad Arduino Simple Board.It's controlled by an ATmega328 with the Arduino bootloader.It has fewer pins than the LilyPad Arduino Main Board, a built in power supply socket, and an on\/off switch .Any of our LiPo batteries can be plugged right into the socket.The Simple board is designed to streamline your next sewable project by keeping things simple and giving you more room to work and eliminating the need to sew a power supply.This revision does away with the ISP header and adds a charging circuit based on the MCP73831 IC.\t\tLilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They're even washable!\t\tCan't decide which Arduino is right for you ? Arduino buying guide!\t\tDimensions : \t\t\t50mm outer diameter\t\t\tThin 0.8mm PCB\tDocuments: \t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet(MCP73831T)\t\t\tLeah Buechley's LilyPad Tutorial\t\t\tLilyPad Arduino Documentation\tReplaces: DEV-09725",
			"image":"obsolete\/breadboard\/LilyPad-Simple-v22_breadboard.svg",
			"icon":"obsolete\/breadboard\/LilyPad-Simple-v22_breadboard.svg",
			"width":"141.732",
			"height":"141.732",
			"points": [[270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9], [111.014, 71.414, 6.104, 6.104], [103.814, 71.414, 6.104, 6.104], [111.014, 64.214, 6.104, 6.104], [103.814, 64.214, 6.104, 6.104], [111.014, 57.014, 6.104, 6.104], [103.814, 57.014, 6.104, 6.104]]
		}, {
			"name":"Arduino Mini",
			"description":"The Arduino Mini is a small microcontroller board based on the ATmega168(datasheet), intended for use on breadboards and when space is at a premium.It has 14 digital input\/output pins(of which 6 can be used as PWM outputs), 8 analog inputs, and a 16 MHz crystal oscillator.It can be programmed with the Mini USB adapter or other USB or RS232 to TTL serial adapter.http: \/\/arduino.cc\/en\/Main\/ArduinoBoardMini",
			"image":"obsolete\/breadboard\/controller_arduino_mini.svg",
			"icon":"obsolete\/breadboard\/controller_arduino_mini.svg",
			"width":"50.4",
			"height":"86.649",
			"points": [[15.693, 80.405, 4.774, 4.774], [8.493, 80.405, 4.774, 4.774], [15.693, 73.205, 4.774, 4.774], [8.493, 73.205, 4.774, 4.774], [8.493, 1.205, 4.774, 4.774], [15.693, 1.205, 4.774, 4.774], [22.893, 1.205, 4.774, 4.774], [30.093, 1.205, 4.774, 4.774], [37.293, 1.205, 4.774, 4.774], [37.293, 80.405, 4.774, 4.774], [30.093, 80.405, 4.774, 4.774], [2.091, 81.21, 3.184, 3.184], [2.091, 74.01, 3.184, 3.184], [2.091, 66.81, 3.184, 3.184], [2.091, 59.608, 3.184, 3.184], [2.091, 52.408, 3.184, 3.184], [2.091, 45.208, 3.184, 3.184], [2.091, 38.007, 3.184, 3.184], [2.091, 30.806, 3.184, 3.184], [2.091, 23.606, 3.184, 3.184], [2.091, 16.405, 3.184, 3.184], [2.091, 9.205, 3.184, 3.184], [2.091, 2.004, 3.184, 3.184], [45.3, 2.004, 3.184, 3.184], [45.3, 9.205, 3.184, 3.184], [45.3, 16.405, 3.184, 3.184], [45.3, 23.606, 3.184, 3.184], [45.3, 30.806, 3.184, 3.184], [45.3, 38.007, 3.184, 3.184], [45.3, 45.208, 3.184, 3.184], [45.3, 52.408, 3.184, 3.184], [45.3, 59.608, 3.184, 3.184], [45.3, 66.81, 3.184, 3.184], [45.3, 74.01, 3.184, 3.184], [45.3, 81.21, 3.184, 3.184]]
		}, {
			"name":"LilyPad Arduino Simple Board",
			"description":"This is the LilyPad Arduino Simple Board. It' s controlled by an ATmega328 with the Arduino bootloader.It has fewer pins than the LilyPad Arduino Main Board, a built in power supply socket, and an on\/off switch .Any of our LiPo batteries can be plugged right into the socket.The Simple board is designed to streamline your next sewable project by keeping things simple and giving you more room to work and eliminating the need to sew a power supply.This revision does away with the ISP header and adds a charging circuit based on the MCP73831 IC.LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They 're even washable!",
			"image":"core\/breadboard\/LilyPad-Simple-v25_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad-Simple-v25_breadboard.svg",
			"width":"141.732",
			"height":"141.732",
			"points": [[120.969, 39.416, 11.72, 11.72], [98.239, 13.317, 11.72, 11.72], [65.006, 3.58, 11.72, 11.72], [31.41, 13.385, 11.72, 11.72], [125.81, 73.754, 11.72, 11.72], [47.71, 123.97, 11.72, 11.72], [82.302, 123.97, 11.72, 11.72], [111.43, 105.231, 11.72, 11.72], [18.582, 105.231, 11.72, 11.72], [9.042, 39.445, 11.72, 11.72], [4.48, 73.713, 11.72, 11.72]]
		}, {
			"name":"Ceramic Disk Capacitor",
			"description":"A 220 pF Ceramic Disk Capacitor",
			"image":"obsolete\/breadboard\/ceramic_disk_capacitor_ochre.svg",
			"icon":"obsolete\/breadboard\/ceramic_disk_capacitor_ochre.svg",
			"width":"23",
			"height":"42.75",
			"points": [[-1, 31.75, 5, 12], [19, 31.75, 5, 12]]
		}, {
			"name":"Variable Capacitor",
			"description":"",
			"image":"core\/breadboard\/capacitor_variable_2_legs.svg",
			"icon":"core\/breadboard\/capacitor_variable_2_legs.svg",
			"width":"18.199",
			"height":"17.377",
			"points": [[-0.359, 7.107, 4.392, 4.16], [14.061, 7.199, 4.16, 4.158]]
		}, {
			"name":"DB9 Connector",
			"description":"DB9 ConnectorStandard DB9 (D-Sub 9) serial connector. Can be used for CAN bus as well as RS485 and RS232. Footprint production proven. Spark Fun Electronics SKU : PRT-00429",
			"image":"core\/breadboard\/sparkfun-connectors_db9_male_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_db9_male_breadboard.svg",
			"width":"1420.6",
			"height":"600",
			"points": [[443.335, 533.05, 33.93, 33.9], [543.335, 533.05, 33.93, 33.9], [543.335, 33.05, 33.93, 33.9], [643.335, 533.05, 33.93, 33.9], [643.335, 33.05, 33.93, 33.9], [743.335, 533.05, 33.93, 33.9], [743.335, 33.05, 33.93, 33.9], [843.335, 533.05, 33.93, 33.9], [843.335, 33.05, 33.93, 33.9], [943.335, 533.05, 33.93, 33.9], [943.335, 33.05, 33.93, 33.9]]
		}, {
			"name":"linino dogRJ45",
			"description":"Designed to meet IEEE 802.3 Fast Ethernet switch with auto-crossover, auto-polarity, and auto-negotiation.10\/100 Mbps Fast Ethernet port basic switch feature including port mirroring, broadcast storm support, flow control in full-duplex, and back pressure in half duplex.",
			"image":"core\/breadboard\/linino_dogrj45_breadboard.svg",
			"icon":"core\/breadboard\/linino_dogrj45_breadboard.svg",
			"width":"72.109",
			"height":"64.828",
			"points": [[8.605, 0.816, 5.62, 5.62], [15.805, 0.816, 5.62, 5.62], [23.005, 0.816, 5.62, 5.62], [30.205, 0.816, 5.62, 5.62], [30.203, 58.414, 5.624, 5.624], [23.003, 58.414, 5.624, 5.624], [15.801, 58.414, 5.624, 5.624], [8.602, 58.414, 5.624, 5.624]]
		}, {
			"name":"Battery Holders",
			"description":"Battery HoldersVarious common sizes : AA, AAA, 20mm coin cell and 12mm coin cell.",
			"image":"core\/breadboard\/sparkfun-electromechanical_battery_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_battery_breadboard.svg",
			"width":"653",
			"height":"800",
			"points": [[259.535, 733.05, 33.93, 33.9], [359.535, 733.05, 33.93, 33.9], [359.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"QFN-64",
			"description":"",
			"image":"core\/breadboard\/QFN-64_breadboard.svg",
			"icon":"core\/breadboard\/QFN-64_breadboard.svg",
			"width":"230.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968], [116.651, 37.4516, 4.29896, 4.2968], [116.651, 1.4516, 4.29896, 4.2968], [123.851, 37.4516, 4.29896, 4.2968], [123.851, 1.4516, 4.29896, 4.2968], [131.051, 37.4516, 4.29896, 4.2968], [131.051, 1.4516, 4.29896, 4.2968], [138.251, 37.4516, 4.29896, 4.2968], [138.251, 1.4516, 4.29896, 4.2968], [145.451, 37.4516, 4.29896, 4.2968], [145.451, 1.4516, 4.29896, 4.2968], [152.65, 37.4516, 4.29896, 4.2968], [152.65, 1.4516, 4.29896, 4.2968], [159.85, 37.4516, 4.29896, 4.2968], [159.85, 1.4516, 4.29896, 4.2968], [167.05, 37.4516, 4.29896, 4.2968], [167.05, 1.4516, 4.29896, 4.2968], [174.25, 37.4516, 4.29896, 4.2968], [174.25, 1.4516, 4.29896, 4.2968], [181.45, 37.4516, 4.29896, 4.2968], [181.45, 1.4516, 4.29896, 4.2968], [188.65, 37.4516, 4.29896, 4.2968], [188.65, 1.4516, 4.29896, 4.2968], [195.85, 37.4516, 4.29896, 4.2968], [195.85, 1.4516, 4.29896, 4.2968], [203.05, 37.4516, 4.29896, 4.2968], [203.05, 1.4516, 4.29896, 4.2968], [210.25, 37.4516, 4.29896, 4.2968], [210.25, 1.4516, 4.29896, 4.2968], [217.45, 37.4516, 4.29896, 4.2968], [217.45, 1.4516, 4.29896, 4.2968], [224.65, 37.4516, 4.29896, 4.2968], [224.65, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Generic male header-11 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_11.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_11.svg",
			"width":"79.189",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791], [37.199, 1.204, 4.791, 4.791], [44.398, 1.204, 4.791, 4.791], [51.597, 1.204, 4.791, 4.791], [58.796, 1.204, 4.791, 4.791], [65.995, 1.204, 4.791, 4.791], [73.194, 1.204, 4.791, 4.791]]
		}, {
			"name":"",
			"description":"Painting the Internet of Things Blue. blueIOT is an tiny little board in the size of an SD Card which comes with latest sensors formeasuring acceleration (3 axis), humidity, altitude and temperature. The integrated Bluetooth Low Energy (BLE) module is certified and allows easy communication with smartphones and home gateways. All this runs with a single coin cell battery at 3V while consumingin average 1uA in managed sleep mode. All this is a perfect basis for wearable, fitness tracker, beacons for in door navigation and more. Programming is supported with the Arduino IDE using an FTDI cable. For development there is an SD card slot for recording sensor data up to 32 GByte. For further extension blueIOT comes with exposed PINs for I2C bus, analog and digital I\/Os. OLEDs from Adafruit with I2C bus are supported right away. Further details and sample projects can be found on www.Fab-Lab.eu",
			"image":"core\/breadboard\/Arduino-BLE-LowPower-RevB-final_5_breadboard.svg",
			"icon":"core\/breadboard\/Arduino-BLE-LowPower-RevB-final_5_breadboard.svg",
			"width":"66.6",
			"height":"113.4",
			"points": [[14.948, 105.848, 6.104, 6.104], [22.148, 105.848, 6.104, 6.104], [29.348, 105.848, 6.104, 6.104], [36.548, 105.848, 6.104, 6.104], [43.748, 105.848, 6.104, 6.104], [50.948, 105.848, 6.104, 6.104], [4.148, 69.848, 6.104, 6.104], [4.148, 62.648, 6.104, 6.104], [4.148, 55.448, 6.104, 6.104], [4.148, 48.248, 6.104, 6.104], [4.148, 41.048, 6.104, 6.104], [4.148, 33.848, 6.104, 6.104], [50.948, 98.648, 6.104, 6.104], [43.748, 98.648, 6.104, 6.104], [36.548, 98.648, 6.104, 6.104], [29.348, 98.648, 6.104, 6.104], [22.148, 98.648, 6.104, 6.104], [14.948, 98.648, 6.104, 6.104]]
		}, {
			"name":"ADTL082-Dual JFET Input Op Amps",
			"description":"",
			"image":"core\/breadboard\/ADTL082.svg",
			"icon":"core\/breadboard\/ADTL082.svg",
			"width":"28.8",
			"height":"29.786",
			"points": [[0.852, 22.942, 5.5, 5.5], [8.053, 22.944, 5.5, 5.5], [15.251, 22.944, 5.5, 5.5], [22.447, 22.942, 5.5, 5.5], [22.449, 1.344, 5.5, 5.5], [15.25, 1.344, 5.5, 5.5], [8.053, 1.342, 5.5, 5.5], [0.853, 1.341, 5.5, 5.5]]
		}, {
			"name":"BUTTON-CONDUCTIVE",
			"description":"Used with rubber key pads. This one was designed and proven to work with the PolyCase Key FOB enclosures.",
			"image":"core\/breadboard\/sparkfun-electromechanical_button-conductive-mini_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_button-conductive-mini_breadboard.svg",
			"width":"603.736",
			"height":"600",
			"points": [[284.903, 533.05, 33.93, 33.9], [284.903, 33.05, 33.93, 33.9]]
		}, {
			"name":"ULN2003A",
			"description":"ULN2003A 7-way Darlington Transistor Driver",
			"image":"core\/breadboard\/ULN2003A_breadboard.svg",
			"icon":"core\/breadboard\/ULN2003A_breadboard.svg",
			"width":"800",
			"height":"330",
			"points": [[34, 285.6, 32, 45.4], [34, -1, 32, 45.4], [734, 285.6, 32, 45.4], [734, -1, 32, 45.4], [134, 285.6, 32, 45.4], [134, -1, 32, 45.4], [234, 285.6, 32, 45.4], [234, -1, 32, 45.4], [334, 285.6, 32, 45.4], [334, -1, 32, 45.4], [434, 285.6, 32, 45.4], [434, -1, 32, 45.4], [534, 285.6, 32, 45.4], [534, -1, 32, 45.4], [634, 285.6, 32, 45.4], [634, -1, 32, 45.4]]
		}, {
			"name":"NPN-Transistor",
			"description":"A standard NPN-transistor",
			"image":"core\/breadboard\/transistor_npn.svg",
			"icon":"core\/breadboard\/transistor_npn.svg",
			"width":"16.527",
			"height":"24.081",
			"points": [[-1, 21.081, 4.16, 3], [6.181, 21.081, 4.16, 3], [13.367, 21.081, 4.16, 3]]
		}, {
			"name":"Arduino Pro Mini 3.3V",
			"description":"It' s blue!It 's thin (0.8mm)! It' s the Arduino Pro Mini!SparkFun 's minimal design approach to Arduino. This is a 3.3V Arduino running the 8MHz bootloader (select'Arduino Duemilanove w\/328'within the Arduino software). Arduino Pro Mini does not come with connectors populated so that you can solder in any connector or wire with any orientation you need. We recommend first time Arduino users start with the Duemilanove. It' s a great board that will get you up and running quickly.The Arduino Pro series is meant for users that understand the limitations of system voltage(3.3V), lack of connectors, and USB off board.\tWe really wanted to minimize the cost of an Arduino.The Arduino Pro Mini is like the Arduino Mini(same pin out)but to keep the cost low, we used all SMD components, made it two layer, etc.This board connects directly to the FTDI Basic Breakout board and supports auto-reset.The Arduino Pro Mini also works with the FTDI cable but the FTDI cable does not bring out the DTR pin so the auto-reset feature will not work.\tCan 't decide which Arduino is right for you? Arduino buying guide!\tFeatures:\t\t\tATmega328 running at 8MHz with external resonator (0.5% tolerance)\t\t\tLow-voltage board needs no interfacing circuitry to popular 3.3V devices and modules (GPS, accelerometers, sensors, etc)\t\t\tUSB connection off board\t\t\tSupports auto-reset\t\t\t3.3V regulator\t\t\tMax 150mA output\t\t\tOver current protected\t\t\tReverse polarity protected\t\t\tDC input 3.3V up to 12V\t\t\tOn board Power and Status LEDs\tDimensions:\t\t\t0.7x1.3'(18x33mm)   Less than 2 grams Documents:    Schematic   Eagle Files   Arduino Pro Mini Homepage   Getting Started Tutorial",
			"image":"obsolete\/breadboard\/Arduino-Pro-Mini-v11_breadboard.svg",
			"icon":"obsolete\/breadboard\/Arduino-Pro-Mini-v11_breadboard.svg",
			"width":"50.4",
			"height":"93.6",
			"points": [[40.328, 0.728, 5.744, 5.744], [33.128, 0.728, 5.744, 5.744], [25.928, 0.728, 5.744, 5.744], [18.728, 0.728, 5.744, 5.744], [11.528, 0.728, 5.744, 5.744], [4.328, 0.728, 5.744, 5.744], [36.008, 40.328, 5.744, 5.744], [36.008, 33.128, 5.744, 5.744], [43.928, 7.928, 5.744, 5.744], [43.928, 15.128, 5.744, 5.744], [43.928, 22.328, 5.744, 5.744], [43.928, 29.528, 5.744, 5.744], [43.928, 36.728, 5.744, 5.744], [43.928, 43.928, 5.744, 5.744], [43.928, 51.128, 5.744, 5.744], [43.928, 58.328, 5.744, 5.744], [43.928, 65.528, 5.744, 5.744], [43.928, 72.728, 5.744, 5.744], [43.928, 79.928, 5.744, 5.744], [43.928, 87.128, 5.744, 5.744], [0.728, 87.128, 5.744, 5.744], [0.728, 79.928, 5.744, 5.744], [0.728, 72.728, 5.744, 5.744], [0.728, 65.528, 5.744, 5.744], [0.728, 58.328, 5.744, 5.744], [0.728, 51.128, 5.744, 5.744], [0.728, 43.928, 5.744, 5.744], [0.728, 36.728, 5.744, 5.744], [0.728, 29.528, 5.744, 5.744], [0.728, 22.328, 5.744, 5.744], [0.728, 15.128, 5.744, 5.744], [0.728, 7.928, 5.744, 5.744]]
		}, {
			"name":"green LED-5mm",
			"description":"A generic green LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-green.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-green.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"Square Pushbutton",
			"description":"A generic pushbutton.",
			"image":"core\/breadboard\/Round_Pushbuttonba.svg",
			"icon":"core\/breadboard\/Round_Pushbuttonba.svg",
			"width":"50.609",
			"height":"88.136",
			"points": [[16.353, 83.986, 4.142, 5.146], [30.636, 83.986, 4.158, 5.146]]
		}, {
			"name":"ADNS2610",
			"description":"Optical mouse sensor(SPI)",
			"image":"core\/breadboard\/sparkfun-sensors_adns2610_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_adns2610_breadboard.svg",
			"width":"935",
			"height":"2000",
			"points": [[300.535, 1933.05, 33.93, 33.9], [300.535, 33.05, 33.93, 33.9], [400.535, 1933.05, 33.93, 33.9], [400.535, 33.05, 33.93, 33.9], [500.535, 1933.05, 33.93, 33.9], [500.535, 33.05, 33.93, 33.9], [600.535, 1933.05, 33.93, 33.9], [600.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"11LC160",
			"description":"11LC160 UNI\/O EEPROM",
			"image":"core\/breadboard\/11LC160_breadboard.svg",
			"icon":"core\/breadboard\/11LC160_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"74HC4067",
			"description":"16-channel analog MUX",
			"image":"core\/breadboard\/SSOP24_breadboard.svg",
			"icon":"core\/breadboard\/SSOP24_breadboard.svg",
			"width":"86.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"yellow smd LED",
			"description":"A generic yellow LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-yellow.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-yellow.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"MAGNET",
			"description":"Ceramic disc magnet,COM-08890",
			"image":"core\/breadboard\/sparkfun-electromechanical_magnet-18mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_magnet-18mm_breadboard.svg",
			"width":"51.023",
			"height":"54.728",
			"points": []
		}, {
			"name":"Power plug",
			"description":"power plug",
			"image":"core\/breadboard\/power_plug.svg",
			"icon":"core\/breadboard\/power_plug.svg",
			"width":"49.884",
			"height":"30.065",
			"points": [[44.217, 14.74, 6.667, 7.349], [44.217, 14.74, 6.667, 7.349], [44.217, 7.978, 6.667, 7.348]]
		}, {
			"name":"IRF7507",
			"description":"Dual transistor NMOS\/PMOS in one package.",
			"image":"core\/breadboard\/sparkfun-discretesemi_msop8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_msop8_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Lilypad Battery Connect",
			"description":"The LilyPad Battery Connect simply gives you a connection point for a battery or anything else you might want to plug in to your LilyPad system.It consists of a single 2-pin JST connector on a small LilyPad board with positive and negative terminals.LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They 're even washable!Note: The LilyPad Coin Cell Battery Holder is a design conceived by Felicia Williams of Boulder, Colorado.Also, a portion of this sale is given back to Dr.Leah Buechley for continued development and education of e-textiles.",
			"image":"core\/breadboard\/LilyPad Battery-Connect-v11_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad Battery-Connect-v11_breadboard.svg",
			"width":"28.8",
			"height":"50.4",
			"points": [[333.035, 33.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"TRIMPOT",
			"description":"Various small potentiometers for set-and-forget applications",
			"image":"core\/breadboard\/sparkfun-electromechanical_trimpot-3mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_trimpot-3mm_breadboard.svg",
			"width":"333.972",
			"height":"400",
			"points": [[100.021, 333.05, 33.93, 33.9], [200.021, 333.05, 33.93, 33.9], [200.021, 33.05, 33.93, 33.9]]
		}, {
			"name":"LTC6244",
			"description":"Low-noise, high-speed rail-to-rail CMOS op-amp",
			"image":"core\/breadboard\/sparkfun-analogic_msop8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_msop8_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Ambient Light Sensor(TEMT6000 Breakout Board)",
			"description":"Basic breakout board for the TEMT6000 Ambient Light Sensor.Only what you need, nothing you don' t.Sensor acts like a transistor-the greater the incoming light, the higher the analog voltage on the signal pin.  Documents:    Datasheet   Wiring Example",
			"image":"core\/breadboard\/TEMT6000_Breakout-v12_breadboard.svg",
			"icon":"core\/breadboard\/TEMT6000_Breakout-v12_breadboard.svg",
			"width":"28.8",
			"height":"28.8",
			"points": [[0.548, 18.548, 6.104, 6.104], [0.548, 11.348, 6.104, 6.104], [0.548, 4.148, 6.104, 6.104]]
		}, {
			"name":"25LC1024",
			"description":"25LC1024 SPI EEPROM",
			"image":"core\/breadboard\/25LC1024_breadboard.svg",
			"icon":"core\/breadboard\/25LC1024_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"24LC01",
			"description":"24LC01 I2C EEPROM",
			"image":"core\/breadboard\/24LC01_breadboard.svg",
			"icon":"core\/breadboard\/24LC01_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"24LC02",
			"description":"24LC02 I2C EEPROM",
			"image":"core\/breadboard\/24LC02_breadboard.svg",
			"icon":"core\/breadboard\/24LC02_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"RGB LED(6 legs)",
			"description":"A full-color LED, combined from four colors RGBB.",
			"image":"core\/breadboard\/led-rgb-6pin-leg.svg",
			"icon":"core\/breadboard\/led-rgb-6pin-leg.svg",
			"width":"16.437",
			"height":"46.358",
			"points": [[13.286, 22, 3, 3], [6.143, 22, 3, 3], [6.143, 22, 3, 3], [13.278, 44, 3, 3], [6.122, 44, 3, 3], [6.122, 44, 3, 3]]
		}, {
			"name":"MPR121 Breakout",
			"description":"This is a breakout board for Freescale \ u2019s MPR121QR2.The MPR121 is a capacitive touch sensor controller driven by an I2C interface.The chip can control up to twelve individual electrodes, as well as a simulated thirteenth electrode.The MPR121 also features eight LED driving pins.When these pins are not configured as electrodes, they may be used to drive LEDs.There a four jumpers on the bottom of the board, all of which are set(closed)by default .An address jumper ties the ADD pin to ground, meaning the default I2C address of the chip will be 0x5A.If you need to change the address of the chip(by shorting ADD to a different pin), make sure you open the jumper first.Jumpers also connect SDA, SCL and the interrupt pin to 10k pull-up resistors.If you don \ u2019t require the pull-up resistors you can open the jumpers by cutting the trace connecting them.There is no regulation on the board, so the voltage supplied should be between 2.5 and 3.6VDC.The VREG pin is connected through a 0.1uF capacitor to ground, which means, unless you modify the board, you can \ u2019t operate the MPR121 in low-supply voltage mode(1.71-2.75VDC).",
			"image":"core\/breadboard\/MPR121-Breakout-v13_breadboard.svg",
			"icon":"core\/breadboard\/MPR121-Breakout-v13_breadboard.svg",
			"width":"58.195",
			"height":"86.888",
			"points": [[0.897, 51.233, 6.104, 6.104], [0.897, 29.634, 6.104, 6.104], [0.897, 36.833, 6.104, 6.104], [0.896, 44.032, 6.106, 6.106], [51.298, 0.833, 6.104, 6.104], [51.298, 8.034, 6.104, 6.104], [51.298, 15.233, 6.104, 6.104], [51.298, 22.434, 6.104, 6.104], [51.298, 29.634, 6.104, 6.104], [51.298, 36.833, 6.104, 6.104], [51.297, 44.032, 6.106, 6.106], [51.298, 51.233, 6.104, 6.104], [51.298, 58.432, 6.104, 6.104], [51.298, 65.633, 6.104, 6.104], [51.298, 72.833, 6.104, 6.104], [51.297, 80.032, 6.106, 6.106], [0.897, 22.434, 6.104, 6.104], [0.897, 58.432, 6.104, 6.104]]
		}
	]
}, {
	"page":"8",
	"count": 37,
	"el": [{
			"name":"SMA Antenna Connector",
			"description":"SMA Antenna ConnectorEnd launch SMA connector.The paste layer has been removed so that the connector can be hand soldered onto the board after reflow.",
			"image":"core\/breadboard\/sparkfun-connectors_sma-edge_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_sma-edge_breadboard.svg",
			"width":"499.972",
			"height":"1400",
			"points": [[133.021, 1333.05, 33.93, 33.9], [233.021, 1333.05, 33.93, 33.9], [233.021, 33.05, 33.93, 33.9], [333.021, 1333.05, 33.93, 33.9], [333.021, 33.05, 33.93, 33.9]]
		}, {
			"name":"24LC04",
			"description":"24LC04 I2C EEPROM",
			"image":"core\/breadboard\/24LC04_breadboard.svg",
			"icon":"core\/breadboard\/24LC04_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"Mystery Part-3 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 3 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part3.svg",
			"icon":"obsolete\/breadboard\/mystery_part3.svg",
			"width":"32",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"24LC1025",
			"description":"24LC1025 I2C EEPROM",
			"image":"core\/breadboard\/24LC1025_breadboard.svg",
			"icon":"core\/breadboard\/24LC1025_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"74LVC138AD",
			"description":"3-to-8 decoder",
			"image":"core\/breadboard\/SO16_breadboard.svg",
			"icon":"core\/breadboard\/SO16_breadboard.svg",
			"width":"57.6",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"24LC08",
			"description":"24LC08 I2C EEPROM",
			"image":"core\/breadboard\/24LC08_breadboard.svg",
			"icon":"core\/breadboard\/24LC08_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"Serial Port Connector",
			"description":"Need to connect multiple devices to a single UART(RX\/TX)line ? This Serial Port Connector(Multiplexer)will enable you to do just that, connect up to 4 devices into a single microcontrollers RX\/TX pins. \ u2022 Easily connect up to 4 asynchronous serial devices into a microcontrollers single UART RX\/TX pins \ u2022 Simple layout designed for rapid implementation. \ u2022 Sample code \ u2022 Wiring diagram \ u2022 Easy to use \ u2022 Header pins included(not soldered)",
			"image":"core\/breadboard\/atlas-sientific_Serial Port Connector_breadboard.svg",
			"icon":"core\/breadboard\/atlas-sientific_Serial Port Connector_breadboard.svg",
			"width":"62.136",
			"height":"61.92",
			"points": [[2.289, 1.905, 6.334, 6.334], [2.289, 9.147, 6.334, 6.334], [2.289, 16.347, 6.334, 6.334], [2.289, 23.548, 6.334, 6.334], [2.289, 30.745, 6.334, 6.334], [2.289, 37.946, 6.334, 6.334], [2.289, 45.147, 6.334, 6.334], [53.512, 52.349, 6.334, 6.334], [53.512, 45.169, 6.334, 6.334], [53.512, 37.929, 6.334, 6.334], [53.512, 30.755, 6.334, 6.334], [53.512, 23.433, 6.334, 6.334], [53.512, 16.282, 6.334, 6.334], [53.512, 9.147, 6.334, 6.334], [2.189, 52.344, 6.534, 6.345], [53.412, 1.905, 6.534, 6.346]]
		}, {
			"name":"NDS8434",
			"description":"8-SOIC NMOSFET",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"SWITCH-MOMENTARY-2",
			"description":"Various NO switches-pushbuttons, reed, etc",
			"image":"core\/breadboard\/reed_switch_leg.svg",
			"icon":"core\/breadboard\/reed_switch_leg.svg",
			"width":"45.002",
			"height":"8.004",
			"points": [[-1, 1.937, 3, 3], [39.642, 1.936, 3, 3]]
		}, {
			"name":"Buzzer 12mm",
			"description":"Buzzer 12mmSpark Fun Electronics SKU: Comp-Buzzer",
			"image":"core\/breadboard\/sparkfun-electromechanical_buzzer-ccv-kit_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buzzer-ccv-kit_breadboard.svg",
			"width":"640.944",
			"height":"800",
			"points": [[303.507, 733.05, 33.93, 33.9], [303.507, 33.05, 33.93, 33.9]]
		}, {
			"name":"1M \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_1M.svg",
			"icon":"obsolete\/breadboard\/resistor_1M.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"VNH2SP30",
			"description":"30A motor driver IC",
			"image":"core\/breadboard\/sparkfun-poweric_vnh2sp30_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_vnh2sp30_breadboard.svg",
			"width":"1700",
			"height":"800",
			"points": [[33.035, 733.05, 33.93, 33.9], [133.035, 733.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 733.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 733.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 733.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 733.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 733.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 733.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 733.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 733.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 733.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 733.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 733.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 733.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 733.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 733.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 733.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"1M \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_1M.svg",
			"icon":"obsolete\/breadboard\/resistor_1M.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Generic female header-metal rounded-20 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_20.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_20.svg",
			"width":"143.58",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783], [15.556, 1.197, 4.783, 4.783], [22.735, 1.197, 4.783, 4.783], [29.914, 1.197, 4.783, 4.783], [37.093, 1.197, 4.783, 4.783], [44.272, 1.197, 4.783, 4.783], [51.451, 1.197, 4.783, 4.783], [58.63, 1.197, 4.783, 4.783], [65.809, 1.197, 4.783, 4.783], [72.988, 1.197, 4.783, 4.783], [80.167, 1.197, 4.783, 4.783], [87.346, 1.197, 4.783, 4.783], [94.525, 1.197, 4.783, 4.783], [101.704, 1.197, 4.783, 4.783], [108.883, 1.197, 4.783, 4.783], [116.062, 1.197, 4.783, 4.783], [123.241, 1.197, 4.783, 4.783], [130.42, 1.197, 4.783, 4.783], [137.599, 1.197, 4.783, 4.783]]
		}, {
			"name":"yellow LED-5mm",
			"description":"A generic yellow LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-yellow.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-yellow.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"Generic male header-16 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_16.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_16.svg",
			"width":"115.184",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791], [37.199, 1.204, 4.791, 4.791], [44.398, 1.204, 4.791, 4.791], [51.597, 1.204, 4.791, 4.791], [58.796, 1.204, 4.791, 4.791], [65.995, 1.204, 4.791, 4.791], [73.194, 1.204, 4.791, 4.791], [80.393, 1.204, 4.791, 4.791], [87.592, 1.204, 4.791, 4.791], [94.791, 1.204, 4.791, 4.791], [101.99, 1.204, 4.791, 4.791], [109.189, 1.204, 4.791, 4.791]]
		}, {
			"name":"Dual VNH2SP30 Motor Driver",
			"description":"The Pololu dual high-power motor driver carrier for the VNH2SP30 motor driver integrated circuits from ST.http: \/\/www.pololu.com\/catalog\/product\/708",
			"image":"core\/breadboard\/Dual_VNH2SP30_Motor_Driver_breadboard.svg",
			"icon":"core\/breadboard\/Dual_VNH2SP30_Motor_Driver_breadboard.svg",
			"width":"132.667",
			"height":"132.833",
			"points": [[1.7934965761108, 20.18006496063, 5.9999939698735, 6.0000060226089], [1.8294558973439, 27.387800862864, 5.9999939698735, 6.0000060226089], [1.8294558973439, 34.772014287551, 5.9999939698735, 6.0000060226089], [119.23809557551, 70.770054732898, 5.9999939698735, 6.0000060226089], [1.8294558973439, 41.787017041003, 5.9999939698735, 6.0000060226089], [118.86888601677, 56.555443890376, 5.9999939698735, 6.0000060226089], [1.8294558973439, 48.986625130072, 5.9999939698735, 6.0000060226089], [2.0140606767121, 56.555443890376, 5.9999939698735, 6.0000060226089], [1.8294558973439, 63.385841308211, 5.9999939698735, 6.0000060226089], [2.0140606767121, 70.585449397281, 5.9999939698735, 6.0000060226089], [1.8294558973439, 77.78505748635, 5.9999939698735, 6.0000060226089], [1.8294558973439, 85.353876246654, 5.9999939698735, 6.0000060226089], [1.8294558973439, 92.368879000106, 5.9999939698735, 6.0000060226089], [1.8294558973439, 99.383881753558, 5.9999939698735, 6.0000060226089], [1.8294558973439, 106.58348984263, 5.9999939698735, 6.0000060226089], [1.8294558973439, 113.7830979317, 5.9999939698735, 6.0000060226089], [1.7934965761108, 12.858561023622, 5.9999939698735, 6.0000060226089], [119.05349079614, 27.387800862864, 5.9999939698735, 6.0000060226089], [119.23809557551, 41.787017041003, 5.9999939698735, 6.0000060226089], [119.05349079614, 85.169270911037, 5.9999939698735, 6.0000060226089], [119.05349079614, 99.753092424792, 5.9999939698735, 6.0000060226089]]
		}, {
			"name":"Rectifier Diode",
			"description":"A smd rectifier diode",
			"image":"core\/breadboard\/diode.svg",
			"icon":"core\/breadboard\/diode.svg",
			"width":"29.879",
			"height":"7.2",
			"points": [[-0.989, 1.583, 3, 3], [24.576, 1.583, 3, 3]]
		}, {
			"name":"MP3 Trigger",
			"description":"Created in collaboration with Jamie Robertson, the MP3 Trigger is quite possibly the most versatile, low-cost, low power embedded MP3 Player.The board has 18 external trigger pins that will directly trigger pre-selected MP3 tracks, and a full-duplex serial control port that provides full transport control, remote triggering for up to 256 tracks, and fast real-time volume control.The board plays the MP3 files directly from a FAT16 microSD flash card and supports 192Kbps stereo playback.There is also an on-board navigation switch for local access and playback of all MP3 tracks on the flash card. New for version 2: Aside from more than doubling the number of trigger inputs, the MP3 Trigger v2 now contains a resident bootloader that enables firmware updates directly from the microSD card without requiring a hardware programmer.The PSoC Designer IDE can be used to generate hex files for the bootloader.See the datasheet below for more details on how to use the bootloader. Firmware version 2 also incorporates “Quiet Mode”, a new feature that can be enabled via the serial control port.In this mode, the triggers don’t start tracks directly, but instead produce a serial message indicating which triggers were activated.A host microcontroller(Arduino, for example)can thus monitor the trigger inputs and then start any track or sequence of tracks via the serial control port, making the triggers much more flexible. The board uses a Cypress PSoC CY8C29466-24SXI microcontroller and a VLSI VS1053 audio codec. Board can be powered by an external wall wart, FTDI Basic, or raw 3.3V input(see related items below). Firmware update 2.40 Beta: Check it out here and be sure to leave feedback on the blog post. Firmware update 2.23: compatible with 192kbps audio. We use the most up-to-date firmware on everything we ship out.However, if you have an older v2.xx model(or want to change the baud rate)and wish to have the newest firmware, you can get it here. Instructions on how to update your v2.xx firmware are in the datasheet, but here’s a quick review:    Download and unzip one of the files above.   Copy the resulting hex file to a microSD card and rename it to: “MP3TRIGR.HEX”.It does not need to be the only file on the card – it just needs to have that precise filename.   Insert the microSD card into your MP3 Trigger V2 and turn the power on while holding down the center navigation switch .   Wait for the Status LED to go solid, then cycle the power.You’re now running the new firmware. Please refer to the datasheet for a more detailed description of the Status LED indications when running the bootloader. Features:    Input voltage: 4.5-12VDC   Current Consumption: 45mA idle, 85mA playing   File system: FAT16   Audio out: line level stereo(1\/8'stereo jack), see app note below if connecting to larger stereo jack   Trigger inputs: 3.3-5V, active low inputs with internal pull-ups   Serial: Full duplex, 8N1, 38.4K baud Documents:    Datasheet   Schematic   VLSI Application Note for protecting analog outputs   Firmware Files",
			"image":"core\/breadboard\/mp3-trigger-v22_breadboard.svg",
			"icon":"core\/breadboard\/mp3-trigger-v22_breadboard.svg",
			"width":"165.6",
			"height":"197.703",
			"points": [[148.148, 111.425, 6.104, 6.104], [148.148, 104.225, 6.104, 6.104], [148.148, 97.025, 6.104, 6.104], [148.148, 89.8251, 6.104, 6.104], [148.148, 82.6251, 6.104, 6.104], [148.148, 75.4251, 6.104, 6.104], [79.748, 79.0251, 6.104, 6.104], [86.948, 79.0251, 6.104, 6.104], [94.148, 79.0251, 6.104, 6.104], [101.348, 79.0251, 6.104, 6.104], [108.548, 79.0251, 6.104, 6.104], [0.548, 35.8252, 6.104, 6.104], [0.548, 43.0252, 6.104, 6.104], [0.548, 50.2252, 6.104, 6.104], [0.548, 57.4252, 6.104, 6.104], [0.548, 64.6252, 6.104, 6.104], [0.548, 71.8251, 6.104, 6.104], [0.548, 79.0251, 6.104, 6.104], [0.548, 86.2251, 6.104, 6.104], [0.548, 93.4251, 6.104, 6.104], [0.548, 100.625, 6.104, 6.104], [0.548, 107.825, 6.104, 6.104], [0.548, 115.025, 6.104, 6.104], [0.548, 122.225, 6.104, 6.104], [0.548, 129.425, 6.104, 6.104], [0.548, 136.625, 6.104, 6.104], [0.548, 143.825, 6.104, 6.104], [0.548, 151.025, 6.104, 6.104], [0.548, 158.225, 6.104, 6.104], [7.748, 35.8252, 6.104, 6.104], [7.748, 43.0252, 6.104, 6.104], [7.748, 50.2252, 6.104, 6.104], [7.748, 57.4252, 6.104, 6.104], [7.748, 64.6252, 6.104, 6.104], [7.748, 71.8251, 6.104, 6.104], [7.748, 79.0251, 6.104, 6.104], [7.748, 86.2251, 6.104, 6.104], [7.748, 93.4251, 6.104, 6.104], [7.748, 100.625, 6.104, 6.104], [7.748, 107.825, 6.104, 6.104], [7.748, 115.025, 6.104, 6.104], [7.748, 122.225, 6.104, 6.104], [7.748, 129.425, 6.104, 6.104], [7.748, 136.625, 6.104, 6.104], [7.748, 143.825, 6.104, 6.104], [7.748, 151.025, 6.104, 6.104], [7.748, 158.225, 6.104, 6.104]]
		}, {
			"name":"DSPIC33FJ256GP710",
			"description":"Microchip 16-bit DSP",
			"image":"core\/breadboard\/sparkfun-digitalic_tqfp-100-12x12mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tqfp-100-12x12mm_breadboard.svg",
			"width":"5000",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 533.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9], [3333.03, 533.05, 33.93, 33.9], [3333.03, 33.05, 33.93, 33.9], [3433.03, 533.05, 33.93, 33.9], [3433.03, 33.05, 33.93, 33.9], [3533.03, 533.05, 33.93, 33.9], [3533.03, 33.05, 33.93, 33.9], [3633.03, 533.05, 33.93, 33.9], [3633.03, 33.05, 33.93, 33.9], [3733.03, 533.05, 33.93, 33.9], [3733.03, 33.05, 33.93, 33.9], [3833.03, 533.05, 33.93, 33.9], [3833.03, 33.05, 33.93, 33.9], [3933.03, 533.05, 33.93, 33.9], [3933.03, 33.05, 33.93, 33.9], [4033.03, 533.05, 33.93, 33.9], [4033.03, 33.05, 33.93, 33.9], [4133.03, 533.05, 33.93, 33.9], [4133.03, 33.05, 33.93, 33.9], [4233.03, 533.05, 33.93, 33.9], [4233.03, 33.05, 33.93, 33.9], [4333.03, 533.05, 33.93, 33.9], [4333.03, 33.05, 33.93, 33.9], [4433.03, 533.05, 33.93, 33.9], [4433.03, 33.05, 33.93, 33.9], [4533.03, 533.05, 33.93, 33.9], [4533.03, 33.05, 33.93, 33.9], [4633.03, 533.05, 33.93, 33.9], [4633.03, 33.05, 33.93, 33.9], [4733.03, 533.05, 33.93, 33.9], [4733.03, 33.05, 33.93, 33.9], [4833.03, 533.05, 33.93, 33.9], [4833.03, 33.05, 33.93, 33.9], [4933.03, 533.05, 33.93, 33.9], [4933.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_cr54_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_cr54_breadboard.svg",
			"width":"447.986",
			"height":"600",
			"points": [[207.028, 533.05, 33.93, 33.9], [207.028, 33.05, 33.93, 33.9]]
		}, {
			"name":"Power Screwshield-Easy screw terminals and SMD prototyping",
			"description":"Easy screw terminals and SMD prototyping on Arduino.The plate is adapted to the dimensions of the Arduino Duemilanove Uno, it has a pads area allowing you to easily add additional components necessary to your circuits.The pads area can also receive a mini breadboard for initial testing of your prototypes.The pads are square to facilitate the achievement of solder bridges.The stackable connectors include all such signals from the arduino making them available for your prototypes.The signals are clearly indicated by the silkscreen on the top and bottom.A specific area allows you to solder a SMD component directly on the plate.A molex connector allows power supplies to your installation and your Arduino with a simple ATX PC power supply, your Arduino easily becomes autonomous.For advanced users, when the Arduino is powered by molex plug, a specific pads area receive 12V(if selected by solder bridge located on the shield).It allows you to controle 12V equipments, perfect to controle transistor fans, motors, lamps, LED ribbon, relays,...Finally, the status LED can be used(X)into your prototypes with a cutting track on the bottom(SJ2)The shield can be mounted on the Arduino Mega however, pins 14(TX3)and A7 are difficult to use because partially covered by the shield.Pins A8 to A15,Digital 22 to 53 and Com 15 to 21(rear part of the Mega)are not included on the shield.Documentation and installation guide: direct link The official support forum: forum.snootlab.com          Power ScrewShield diagram.pdfOperating diagram of the Power ScrewShield     Power ScrewShield topside.pdfPower ScrewShield implementation of the components     Eagle PowerScrewShield.zipEagle files of the Power ScrewSchield(schema and board)     Power ScrewShield guide FR.pdfPower ScrewShield assembly guide FR     Power ScrewShield guide EN.pdfPower ScrewShield Assembly guide EN   ",
			"image":"core\/breadboard\/Power Screwshield 1.0a_breadboard.svg",
			"icon":"core\/breadboard\/Power Screwshield 1.0a_breadboard.svg",
			"width":"209.82",
			"height":"226.8",
			"points": [[104.948, 166.148, 6.104, 6.104], [112.148, 166.148, 6.104, 6.104], [119.348, 166.148, 6.104, 6.104], [126.548, 166.148, 6.104, 6.104], [133.748, 166.148, 6.104, 6.104], [140.948, 166.148, 6.104, 6.104], [155.348, 166.148, 6.104, 6.104], [162.548, 166.148, 6.104, 6.104], [169.748, 166.148, 6.104, 6.104], [176.948, 166.148, 6.104, 6.104], [184.148, 166.148, 6.104, 6.104], [191.348, 166.148, 6.104, 6.104], [191.348, 58.148, 6.104, 6.104], [184.148, 58.148, 6.104, 6.104], [176.948, 58.148, 6.104, 6.104], [169.748, 58.148, 6.104, 6.104], [162.548, 58.148, 6.104, 6.104], [155.348, 58.148, 6.104, 6.104], [148.148, 58.148, 6.104, 6.104], [140.948, 58.148, 6.104, 6.104], [129.428, 58.148, 6.104, 6.104], [122.228, 58.148, 6.104, 6.104], [115.028, 58.148, 6.104, 6.104], [107.828, 58.148, 6.104, 6.104], [100.628, 58.148, 6.104, 6.104], [93.428, 58.148, 6.104, 6.104], [86.228, 58.148, 6.104, 6.104], [79.028, 58.148, 6.104, 6.104], [105.128, 180.728, 5.744, 5.744], [112.328, 180.728, 5.744, 5.744], [119.528, 180.728, 5.744, 5.744], [126.728, 180.728, 5.744, 5.744], [133.928, 180.728, 5.744, 5.744], [141.128, 180.728, 5.744, 5.744], [155.528, 180.728, 5.744, 5.744], [162.728, 180.728, 5.744, 5.744], [169.928, 180.728, 5.744, 5.744], [177.128, 180.728, 5.744, 5.744], [184.328, 180.728, 5.744, 5.744], [191.528, 180.728, 5.744, 5.744], [191.528, 43.928, 5.744, 5.744], [184.328, 43.928, 5.744, 5.744], [177.128, 43.928, 5.744, 5.744], [169.928, 43.928, 5.744, 5.744], [162.728, 43.928, 5.744, 5.744], [155.528, 43.928, 5.744, 5.744], [148.328, 43.928, 5.744, 5.744], [141.128, 43.928, 5.744, 5.744], [129.608, 43.928, 5.744, 5.744], [122.408, 43.928, 5.744, 5.744], [115.208, 43.928, 5.744, 5.744], [108.008, 43.928, 5.744, 5.744], [100.808, 43.928, 5.744, 5.744], [93.608, 43.928, 5.744, 5.744], [86.408, 43.928, 5.744, 5.744], [79.208, 43.928, 5.744, 5.744], [18.52334, 155.32334, 6.15332, 6.15332], [47.32334, 68.92334, 6.15332, 6.15332], [54.52334, 68.92334, 6.15332, 6.15332], [61.72334, 68.92334, 6.15332, 6.15332], [68.92334, 68.92334, 6.15332, 6.15332], [76.12334, 68.92334, 6.15332, 6.15332], [83.32334, 68.92334, 6.15332, 6.15332], [90.52334, 68.92334, 6.15332, 6.15332], [97.72334, 68.92334, 6.15332, 6.15332], [104.92334, 68.92334, 6.15332, 6.15332], [112.12334, 68.92334, 6.15332, 6.15332], [119.32334, 68.92334, 6.15332, 6.15332], [126.52334, 68.92334, 6.15332, 6.15332], [133.72334, 68.92334, 6.15332, 6.15332], [140.92334, 68.92334, 6.15332, 6.15332], [148.12334, 68.92334, 6.15332, 6.15332], [155.32334, 68.92334, 6.15332, 6.15332], [162.52334, 68.92334, 6.15332, 6.15332], [169.72334, 68.92334, 6.15332, 6.15332], [176.92334, 68.92334, 6.15332, 6.15332], [184.12334, 68.92334, 6.15332, 6.15332], [191.32334, 68.92334, 6.15332, 6.15332], [198.52334, 68.92334, 6.15332, 6.15332], [76.12334, 155.32334, 6.15332, 6.15332], [76.12334, 148.12334, 6.15332, 6.15332], [76.12334, 140.92334, 6.15332, 6.15332], [76.12334, 133.72334, 6.15332, 6.15332], [76.12334, 126.52334, 6.15332, 6.15332], [76.12334, 119.32334, 6.15332, 6.15332], [76.12334, 112.12334, 6.15332, 6.15332], [76.12334, 104.92334, 6.15332, 6.15332], [76.12334, 97.72334, 6.15332, 6.15332], [76.12334, 90.52334, 6.15332, 6.15332], [76.12334, 83.32334, 6.15332, 6.15332], [76.12334, 76.12334, 6.15332, 6.15332], [68.92334, 68.92334, 6.15332, 6.15332], [68.92334, 76.12334, 6.15332, 6.15332], [68.92334, 83.32334, 6.15332, 6.15332], [68.92334, 90.52334, 6.15332, 6.15332], [68.92334, 97.72334, 6.15332, 6.15332], [68.92334, 104.92334, 6.15332, 6.15332], [68.92334, 112.12334, 6.15332, 6.15332], [68.92334, 119.32334, 6.15332, 6.15332], [68.92334, 126.52334, 6.15332, 6.15332], [68.92334, 133.72334, 6.15332, 6.15332], [68.92334, 140.92334, 6.15332, 6.15332], [68.92334, 148.12334, 6.15332, 6.15332], [47.32334, 32.92334, 6.15332, 6.15332], [54.52334, 32.92334, 6.15332, 6.15332], [61.72334, 32.92334, 6.15332, 6.15332], [32.92334, 32.92334, 6.15332, 6.15332], [40.12334, 32.92334, 6.15332, 6.15332], [47.32334, 32.92334, 6.15332, 6.15332], [32.92334, 32.92334, 6.15332, 6.15332], [25.72334, 32.92334, 6.15332, 6.15332], [18.52334, 32.92334, 6.15332, 6.15332], [33.63228, 18.33228, 6.53544, 6.53544], [23.71108, 18.33228, 6.53544, 6.53544], [13.78968, 18.33228, 6.53544, 6.53544], [3.8685, 18.33228, 6.53544, 6.53544], [86.73228, 201.93228, 6.53544, 6.53544], [96.65388, 201.93228, 6.53544, 6.53544], [106.57428, 201.93228, 6.53544, 6.53544], [116.49628, 201.93228, 6.53544, 6.53544], [126.41728, 201.93228, 6.53544, 6.53544], [136.33928, 201.93228, 6.53544, 6.53544], [150.56828, 201.93228, 6.53544, 6.53544], [160.49028, 201.93228, 6.53544, 6.53544], [170.41028, 201.93228, 6.53544, 6.53544], [180.33228, 201.93228, 6.53544, 6.53544], [190.25428, 201.93228, 6.53544, 6.53544], [200.17428, 201.93228, 6.53544, 6.53544], [198.33228, 18.33228, 6.53544, 6.53544], [188.41028, 18.33228, 6.53544, 6.53544], [178.49028, 18.33228, 6.53544, 6.53544], [168.56828, 18.33228, 6.53544, 6.53544], [158.64728, 18.33228, 6.53544, 6.53544], [148.72528, 18.33228, 6.53544, 6.53544], [138.80528, 18.33228, 6.53544, 6.53544], [128.88328, 18.33228, 6.53544, 6.53544], [118.96228, 18.33228, 6.53544, 6.53544], [109.04028, 18.33228, 6.53544, 6.53544], [99.12028, 18.33228, 6.53544, 6.53544], [89.19828, 18.33228, 6.53544, 6.53544], [79.27738, 18.33228, 6.53544, 6.53544], [69.35578, 18.33228, 6.53544, 6.53544], [59.43468, 18.33228, 6.53544, 6.53544], [49.51338, 18.33228, 6.53544, 6.53544], [32.09449, 189.59449, 7.81102, 7.81102], [46.49449, 189.59449, 7.81102, 7.81102], [85.56441, 188.16441, 5.27118, 5.27118], [83.32334, 148.12334, 6.15332, 6.15332], [83.32334, 140.92334, 6.15332, 6.15332], [191.32334, 76.12334, 6.15332, 6.15332], [83.32334, 133.72334, 6.15332, 6.15332], [83.32334, 126.52334, 6.15332, 6.15332], [83.32334, 119.32334, 6.15332, 6.15332], [83.32334, 112.12334, 6.15332, 6.15332], [83.32334, 104.92334, 6.15332, 6.15332], [83.32334, 97.72334, 6.15332, 6.15332], [83.32334, 90.52334, 6.15332, 6.15332], [83.32334, 83.32334, 6.15332, 6.15332], [61.72334, 148.12334, 6.15332, 6.15332], [61.72334, 140.92334, 6.15332, 6.15332], [61.72334, 133.72334, 6.15332, 6.15332], [61.72334, 126.52334, 6.15332, 6.15332], [184.12334, 76.12334, 6.15332, 6.15332], [25.72334, 148.12334, 6.15332, 6.15332], [18.52334, 140.92334, 6.15332, 6.15332], [18.52334, 148.12334, 6.15332, 6.15332], [61.72334, 119.32334, 6.15332, 6.15332], [176.92334, 76.12334, 6.15332, 6.15332], [198.52334, 148.12334, 6.15332, 6.15332], [198.52334, 140.92334, 6.15332, 6.15332], [198.52334, 133.72334, 6.15332, 6.15332], [198.52334, 126.52334, 6.15332, 6.15332], [198.52334, 119.32334, 6.15332, 6.15332], [198.52334, 112.12334, 6.15332, 6.15332], [198.52334, 104.92334, 6.15332, 6.15332], [198.52334, 97.72334, 6.15332, 6.15332], [198.52334, 90.52334, 6.15332, 6.15332], [61.72334, 112.12334, 6.15332, 6.15332], [169.72334, 76.12334, 6.15332, 6.15332], [191.32334, 148.12334, 6.15332, 6.15332], [191.32334, 140.92334, 6.15332, 6.15332], [191.32334, 133.72334, 6.15332, 6.15332], [191.32334, 126.52334, 6.15332, 6.15332], [191.32334, 119.32334, 6.15332, 6.15332], [191.32334, 112.12334, 6.15332, 6.15332], [191.32334, 104.92334, 6.15332, 6.15332], [191.32334, 97.72334, 6.15332, 6.15332], [191.32334, 90.52334, 6.15332, 6.15332], [61.72334, 104.92334, 6.15332, 6.15332], [162.52334, 76.12334, 6.15332, 6.15332], [184.12334, 148.12334, 6.15332, 6.15332], [184.12334, 140.92334, 6.15332, 6.15332], [184.12334, 133.72334, 6.15332, 6.15332], [184.12334, 126.52334, 6.15332, 6.15332], [184.12334, 119.32334, 6.15332, 6.15332], [184.12334, 112.12334, 6.15332, 6.15332], [184.12334, 104.92334, 6.15332, 6.15332], [184.12334, 97.72334, 6.15332, 6.15332], [184.12334, 90.52334, 6.15332, 6.15332], [61.72334, 97.72334, 6.15332, 6.15332], [155.32334, 76.12334, 6.15332, 6.15332], [176.92334, 148.12334, 6.15332, 6.15332], [176.92334, 140.92334, 6.15332, 6.15332], [176.92334, 133.72334, 6.15332, 6.15332], [176.92334, 126.52334, 6.15332, 6.15332], [176.92334, 119.32334, 6.15332, 6.15332], [176.92334, 112.12334, 6.15332, 6.15332], [176.92334, 104.92334, 6.15332, 6.15332], [176.92334, 97.72334, 6.15332, 6.15332], [176.92334, 90.52334, 6.15332, 6.15332], [61.72334, 90.52334, 6.15332, 6.15332], [148.12334, 76.12334, 6.15332, 6.15332], [169.72334, 148.12334, 6.15332, 6.15332], [169.72334, 140.92334, 6.15332, 6.15332], [169.72334, 133.72334, 6.15332, 6.15332], [169.72334, 126.52334, 6.15332, 6.15332], [169.72334, 119.32334, 6.15332, 6.15332], [169.72334, 112.12334, 6.15332, 6.15332], [169.72334, 104.92334, 6.15332, 6.15332], [169.72334, 97.72334, 6.15332, 6.15332], [169.72334, 90.52334, 6.15332, 6.15332], [61.72334, 83.32334, 6.15332, 6.15332], [140.92334, 76.12334, 6.15332, 6.15332], [162.52334, 148.12334, 6.15332, 6.15332], [162.52334, 140.92334, 6.15332, 6.15332], [162.52334, 133.72334, 6.15332, 6.15332], [162.52334, 126.52334, 6.15332, 6.15332], [162.52334, 119.32334, 6.15332, 6.15332], [162.52334, 112.12334, 6.15332, 6.15332], [162.52334, 104.92334, 6.15332, 6.15332], [162.52334, 97.72334, 6.15332, 6.15332], [162.52334, 90.52334, 6.15332, 6.15332], [83.32334, 76.12334, 6.15332, 6.15332], [133.72334, 76.12334, 6.15332, 6.15332], [155.32334, 148.12334, 6.15332, 6.15332], [155.32334, 140.92334, 6.15332, 6.15332], [155.32334, 133.72334, 6.15332, 6.15332], [155.32334, 126.52334, 6.15332, 6.15332], [155.32334, 119.32334, 6.15332, 6.15332], [155.32334, 112.12334, 6.15332, 6.15332], [155.32334, 104.92334, 6.15332, 6.15332], [155.32334, 97.72334, 6.15332, 6.15332], [155.32334, 90.52334, 6.15332, 6.15332], [126.52334, 76.12334, 6.15332, 6.15332], [148.12334, 148.12334, 6.15332, 6.15332], [148.12334, 140.92334, 6.15332, 6.15332], [148.12334, 133.72334, 6.15332, 6.15332], [148.12334, 126.52334, 6.15332, 6.15332], [148.12334, 119.32334, 6.15332, 6.15332], [148.12334, 112.12334, 6.15332, 6.15332], [148.12334, 104.92334, 6.15332, 6.15332], [148.12334, 97.72334, 6.15332, 6.15332], [148.12334, 90.52334, 6.15332, 6.15332], [47.32334, 54.52334, 6.15332, 6.15332], [119.32334, 76.12334, 6.15332, 6.15332], [140.92334, 148.12334, 6.15332, 6.15332], [140.92334, 140.92334, 6.15332, 6.15332], [140.92334, 133.72334, 6.15332, 6.15332], [140.92334, 126.52334, 6.15332, 6.15332], [140.92334, 119.32334, 6.15332, 6.15332], [140.92334, 112.12334, 6.15332, 6.15332], [140.92334, 104.92334, 6.15332, 6.15332], [140.92334, 97.72334, 6.15332, 6.15332], [140.92334, 90.52334, 6.15332, 6.15332], [40.12334, 40.12334, 6.15332, 6.15332], [112.12334, 76.12334, 6.15332, 6.15332], [133.72334, 148.12334, 6.15332, 6.15332], [133.72334, 140.92334, 6.15332, 6.15332], [133.72334, 133.72334, 6.15332, 6.15332], [133.72334, 126.52334, 6.15332, 6.15332], [133.72334, 119.32334, 6.15332, 6.15332], [133.72334, 112.12334, 6.15332, 6.15332], [133.72334, 104.92334, 6.15332, 6.15332], [133.72334, 97.72334, 6.15332, 6.15332], [133.72334, 90.52334, 6.15332, 6.15332], [32.92334, 40.12334, 6.15332, 6.15332], [104.92334, 76.12334, 6.15332, 6.15332], [126.52334, 148.12334, 6.15332, 6.15332], [126.52334, 140.92334, 6.15332, 6.15332], [126.52334, 133.72334, 6.15332, 6.15332], [126.52334, 126.52334, 6.15332, 6.15332], [126.52334, 119.32334, 6.15332, 6.15332], [126.52334, 112.12334, 6.15332, 6.15332], [126.52334, 104.92334, 6.15332, 6.15332], [126.52334, 97.72334, 6.15332, 6.15332], [126.52334, 90.52334, 6.15332, 6.15332], [25.72334, 40.12334, 6.15332, 6.15332], [97.72334, 76.12334, 6.15332, 6.15332], [119.32334, 148.12334, 6.15332, 6.15332], [119.32334, 140.92334, 6.15332, 6.15332], [119.32334, 133.72334, 6.15332, 6.15332], [119.32334, 126.52334, 6.15332, 6.15332], [119.32334, 119.32334, 6.15332, 6.15332], [119.32334, 112.12334, 6.15332, 6.15332], [119.32334, 104.92334, 6.15332, 6.15332], [119.32334, 97.72334, 6.15332, 6.15332], [119.32334, 90.52334, 6.15332, 6.15332], [11.32334, 40.12334, 6.15332, 6.15332], [90.52334, 76.12334, 6.15332, 6.15332], [112.12334, 148.12334, 6.15332, 6.15332], [112.12334, 140.92334, 6.15332, 6.15332], [112.12334, 133.72334, 6.15332, 6.15332], [112.12334, 126.52334, 6.15332, 6.15332], [112.12334, 119.32334, 6.15332, 6.15332], [112.12334, 112.12334, 6.15332, 6.15332], [112.12334, 104.92334, 6.15332, 6.15332], [112.12334, 97.72334, 6.15332, 6.15332], [112.12334, 90.52334, 6.15332, 6.15332], [22.56441, 105.36441, 5.27118, 5.27118], [104.92334, 148.12334, 6.15332, 6.15332], [104.92334, 140.92334, 6.15332, 6.15332], [104.92334, 133.72334, 6.15332, 6.15332], [104.92334, 126.52334, 6.15332, 6.15332], [104.92334, 119.32334, 6.15332, 6.15332], [104.92334, 112.12334, 6.15332, 6.15332], [104.92334, 104.92334, 6.15332, 6.15332], [104.92334, 97.72334, 6.15332, 6.15332], [104.92334, 90.52334, 6.15332, 6.15332], [40.12334, 119.32334, 6.15332, 6.15332], [11.76441, 47.76441, 5.27118, 5.27118], [18.96441, 47.76441, 5.27118, 5.27118], [26.16441, 47.76441, 5.27118, 5.27118], [33.36441, 47.76441, 5.27118, 5.27118], [22.56441, 54.96441, 5.27118, 5.27118], [29.76441, 54.96441, 5.27118, 5.27118], [15.36441, 54.96441, 5.27118, 5.27118], [33.36441, 112.56441, 5.27118, 5.27118], [36.96441, 54.96441, 5.27118, 5.27118], [36.96441, 105.36441, 5.27118, 5.27118], [29.76441, 105.36441, 5.27118, 5.27118], [15.36441, 105.36441, 5.27118, 5.27118], [11.76441, 112.56441, 5.27118, 5.27118], [18.96441, 112.56441, 5.27118, 5.27118], [26.16441, 112.56441, 5.27118, 5.27118], [198.52334, 76.12334, 6.15332, 6.15332], [25.72334, 140.92334, 6.15332, 6.15332], [112.12334, 83.32334, 6.15332, 6.15332], [25.72334, 126.52334, 6.15332, 6.15332], [18.52334, 126.52334, 6.15332, 6.15332], [11.32334, 119.32334, 6.15332, 6.15332], [61.72334, 76.12334, 6.15332, 6.15332], [54.52334, 76.12334, 6.15332, 6.15332], [47.32334, 76.12334, 6.15332, 6.15332], [68.92334, 47.32334, 6.15332, 6.15332], [11.32334, 133.72334, 6.15332, 6.15332], [104.92334, 83.32334, 6.15332, 6.15332], [25.72334, 133.72334, 6.15332, 6.15332], [32.92334, 148.12334, 6.15332, 6.15332], [40.12334, 140.92334, 6.15332, 6.15332], [40.12334, 133.72334, 6.15332, 6.15332], [40.12334, 126.52334, 6.15332, 6.15332], [11.32334, 148.12334, 6.15332, 6.15332], [18.52334, 133.72334, 6.15332, 6.15332], [18.52334, 119.32334, 6.15332, 6.15332], [40.12334, 148.12334, 6.15332, 6.15332], [32.92334, 140.92334, 6.15332, 6.15332], [32.92334, 133.72334, 6.15332, 6.15332], [32.92334, 126.52334, 6.15332, 6.15332], [32.92334, 119.32334, 6.15332, 6.15332], [11.32334, 140.92334, 6.15332, 6.15332], [11.32334, 126.52334, 6.15332, 6.15332], [25.72334, 119.32334, 6.15332, 6.15332], [54.52334, 54.52334, 6.15332, 6.15332], [54.52334, 61.72334, 6.15332, 6.15332], [126.52334, 83.32334, 6.15332, 6.15332], [18.52334, 40.12334, 6.15332, 6.15332], [47.32334, 61.72334, 6.15332, 6.15332], [119.32334, 83.32334, 6.15332, 6.15332], [155.32334, 83.32334, 6.15332, 6.15332], [198.52334, 83.32334, 6.15332, 6.15332], [148.12334, 83.32334, 6.15332, 6.15332], [191.32334, 83.32334, 6.15332, 6.15332], [140.92334, 83.32334, 6.15332, 6.15332], [184.12334, 83.32334, 6.15332, 6.15332], [133.72334, 83.32334, 6.15332, 6.15332], [176.92334, 83.32334, 6.15332, 6.15332], [61.72334, 54.52334, 6.15332, 6.15332], [169.72334, 83.32334, 6.15332, 6.15332], [162.52334, 83.32334, 6.15332, 6.15332], [61.72334, 61.72334, 6.15332, 6.15332], [68.92334, 54.52334, 6.15332, 6.15332], [68.92334, 61.72334, 6.15332, 6.15332], [25.72334, 155.32334, 6.15332, 6.15332], [32.92334, 155.32334, 6.15332, 6.15332], [40.12334, 155.32334, 6.15332, 6.15332], [47.32334, 155.32334, 6.15332, 6.15332], [54.52334, 155.32334, 6.15332, 6.15332], [61.72334, 155.32334, 6.15332, 6.15332], [68.92334, 155.32334, 6.15332, 6.15332], [83.32334, 155.32334, 6.15332, 6.15332], [90.52334, 155.32334, 6.15332, 6.15332], [97.72334, 155.32334, 6.15332, 6.15332], [104.92334, 155.32334, 6.15332, 6.15332], [112.12334, 155.32334, 6.15332, 6.15332], [119.32334, 155.32334, 6.15332, 6.15332], [126.52334, 155.32334, 6.15332, 6.15332], [133.72334, 155.32334, 6.15332, 6.15332], [140.92334, 155.32334, 6.15332, 6.15332], [148.12334, 155.32334, 6.15332, 6.15332], [155.32334, 155.32334, 6.15332, 6.15332], [162.52334, 155.32334, 6.15332, 6.15332], [169.72334, 155.32334, 6.15332, 6.15332], [176.92334, 155.32334, 6.15332, 6.15332], [184.12334, 155.32334, 6.15332, 6.15332], [191.32334, 155.32334, 6.15332, 6.15332], [198.52334, 155.32334, 6.15332, 6.15332], [54.52334, 83.32334, 6.15332, 6.15332], [47.32334, 83.32334, 6.15332, 6.15332], [54.52334, 90.52334, 6.15332, 6.15332], [47.32334, 90.52334, 6.15332, 6.15332], [54.52334, 97.72334, 6.15332, 6.15332], [47.32334, 97.72334, 6.15332, 6.15332], [54.52334, 104.92334, 6.15332, 6.15332], [47.32334, 104.92334, 6.15332, 6.15332], [54.52334, 112.12334, 6.15332, 6.15332], [47.32334, 112.12334, 6.15332, 6.15332], [54.52334, 119.32334, 6.15332, 6.15332], [47.32334, 119.32334, 6.15332, 6.15332], [54.52334, 126.52334, 6.15332, 6.15332], [47.32334, 126.52334, 6.15332, 6.15332], [54.52334, 133.72334, 6.15332, 6.15332], [47.32334, 133.72334, 6.15332, 6.15332], [54.52334, 140.92334, 6.15332, 6.15332], [47.32334, 140.92334, 6.15332, 6.15332], [54.52334, 148.12334, 6.15332, 6.15332], [47.32334, 148.12334, 6.15332, 6.15332], [90.52334, 83.32334, 6.15332, 6.15332], [97.72334, 83.32334, 6.15332, 6.15332], [90.52334, 90.52334, 6.15332, 6.15332], [97.72334, 90.52334, 6.15332, 6.15332], [90.52334, 97.72334, 6.15332, 6.15332], [97.72334, 97.72334, 6.15332, 6.15332], [90.52334, 104.92334, 6.15332, 6.15332], [97.72334, 104.92334, 6.15332, 6.15332], [90.52334, 112.12334, 6.15332, 6.15332], [97.72334, 112.12334, 6.15332, 6.15332], [90.52334, 119.32334, 6.15332, 6.15332], [97.72334, 119.32334, 6.15332, 6.15332], [90.52334, 126.52334, 6.15332, 6.15332], [97.72334, 126.52334, 6.15332, 6.15332], [90.52334, 133.72334, 6.15332, 6.15332], [97.72334, 133.72334, 6.15332, 6.15332], [90.52334, 140.92334, 6.15332, 6.15332], [97.72334, 140.92334, 6.15332, 6.15332], [90.52334, 148.12334, 6.15332, 6.15332], [97.72334, 148.12334, 6.15332, 6.15332]]
		}, {
			"name":"Crystal",
			"description":"Crystal",
			"image":"core\/breadboard\/crystal_leg.svg",
			"icon":"core\/breadboard\/crystal_leg.svg",
			"width":"28.871",
			"height":"12.855",
			"points": [[4.824, 8.732, 4.146, 3.05], [19.186, 8.732, 4.146, 3.05]]
		}, {
			"name":"Blue LED-5mm",
			"description":"A generic blue LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-blue.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-blue.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"SPST Switch",
			"description":"SPST SwitchSimple slide switch .Spark Fun Electronics SKU: COM-00102",
			"image":"core\/breadboard\/sparkfun-electromechanical_switch-spdt_lock.007s_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_switch-spdt_lock.007s_breadboard.svg",
			"width":"12.906",
			"height":"41.342",
			"points": [[3.401, 13.72, 6.104, 6.104], [3.4, 21.423, 6.106, 6.106], [3.401, 29.128, 6.104, 6.104]]
		}, {
			"name":"Header 2",
			"description":"Header 2Standard 2-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116) , right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).Molex polarized connector foot print use with SKU: PRT-08233 with associated crimp pins and housings.",
			"image":"core\/breadboard\/sparkfun-connectors_springterminal-2.54mm-2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_springterminal-2.54mm-2_breadboard.svg",
			"width":"7.894",
			"height":"10.934",
			"points": [[2.577, 6.257, 3.5, 3.5], [2.577, 1.177, 3.5, 3.5], [5.117, 1.177, 3.5, 3.5], [5.117, 6.257, 3.5, 3.5]]
		}, {
			"name":"Intel Galileo Gen2",
			"description":"Galileo is a microcontroller board based on the Intel \ u00ae Quark SoC X1000 Application Processor, a 32-bit Intel Pentium-class system on a chip(datasheet).It \ u2019s the first board based on Intel \ u00ae architecture designed to be hardware and software pin-compatible with Arduino shields designed for the Uno R3.Digital pins 0 to 13(and the adjacent AREF and GND pins), Analog inputs 0 to 5, the power header, ICSP header, and the UART port pins(0 and 1), are all in the same locations as on the Arduino Uno R3.This is also known as the Arduino 1.0 pinout.Galileo is designed to support shields that operate at either 3.3V or 5V.The core operating voltage of Galileo is 3.3V.However, a jumper on the board enables voltage translation to 5V at the I\/O pins.This provides support for 5V Uno shields and is the default behavior.By switching the jumper position, the voltage translation can be disabled to provide 3.3V operation at the I\/O pins.Of course, the Galileo board is also software compatible with the Arduino Software Development Environment(IDE), which makes usability and introduction a snap.In addition to Arduino hardware and software compatibility, the Galileo board has several PC industry standard I\/O ports and features to expand native usage and capabilities beyond the Arduino shield ecosystem.A full sized mini-PCI Express slot, 100Mb Ethernet port, Micro-SD slot, RS-232 serial port, USB Host port, USB Client port, and 8MByte NOR flash come standard on the board.Visit the FAQ page for further informations.",
			"image":"core\/breadboard\/intel-arduino-galileo_gen2_breadboard.svg",
			"icon":"core\/breadboard\/intel-arduino-galileo_gen2_breadboard.svg",
			"width":"362.789",
			"height":"210.324",
			"points": [[310.747, 176.316, 5.218, 5.218], [317.947, 176.316, 5.218, 5.218], [325.145, 176.316, 5.218, 5.218], [332.347, 176.316, 5.218, 5.218], [339.544, 176.316, 5.218, 5.218], [346.747, 176.316, 5.218, 5.218], [346.943, 96.954, 5.544, 5.544], [354.143, 96.954, 5.544, 5.544], [346.944, 104.155, 5.542, 5.542], [354.144, 104.155, 5.542, 5.542], [346.944, 111.354, 5.542, 5.542], [354.144, 111.354, 5.542, 5.542], [284.825, 39.516, 5.22, 5.22], [277.623, 39.516, 5.22, 5.22], [270.424, 39.516, 5.22, 5.22], [263.225, 39.516, 5.22, 5.22], [256.025, 39.516, 5.22, 5.22], [248.825, 39.516, 5.22, 5.22], [241.623, 39.516, 5.22, 5.22], [234.424, 39.516, 5.22, 5.22], [227.225, 39.516, 5.22, 5.22], [220.025, 39.516, 5.22, 5.22], [346.746, 39.516, 5.22, 5.22], [339.543, 39.516, 5.22, 5.22], [332.346, 39.516, 5.22, 5.22], [325.144, 39.516, 5.22, 5.22], [317.946, 39.516, 5.22, 5.22], [310.746, 39.516, 5.22, 5.22], [303.543, 39.516, 5.22, 5.22], [296.346, 39.516, 5.22, 5.22], [253.145, 176.316, 5.218, 5.218], [260.347, 176.316, 5.218, 5.218], [267.544, 176.316, 5.218, 5.218], [274.747, 176.316, 5.218, 5.218], [281.947, 176.316, 5.218, 5.218], [289.145, 176.316, 5.218, 5.218], [296.347, 176.316, 5.218, 5.218], [245.947, 176.316, 5.218, 5.218], [321.729, 15.503, 5.544, 5.544], [321.729, 22.702, 5.544, 5.544], [314.53, 15.504, 5.542, 5.542], [314.53, 22.703, 5.542, 5.542], [307.332, 15.504, 5.542, 5.542], [307.332, 22.703, 5.542, 5.542], [300.169, 22.703, 5.542, 5.542], [38.447, 29.333, 5.544, 5.544], [38.448, 22.135, 5.542, 5.542], [38.448, 14.935, 5.542, 5.542], [245.786, 189.477, 5.544, 5.544], [252.985, 189.478, 5.542, 5.542], [260.185, 189.478, 5.542, 5.542], [275.769, 189.478, 5.542, 5.542], [282.968, 189.478, 5.542, 5.542], [106.223, 158.964, 5.542, 5.542], [113.422, 158.964, 5.542, 5.542], [78.64, 203.2, 3.176, 3.176], [74.983, 203.2, 3.176, 3.176], [71.327, 203.2, 3.176, 3.176], [67.67, 203.2, 3.176, 3.176], [64.013, 203.2, 3.176, 3.176], [78.64, 199.544, 3.176, 3.176], [74.983, 199.544, 3.176, 3.176], [71.327, 199.544, 3.176, 3.176], [67.67, 199.544, 3.176, 3.176], [64.013, 199.544, 3.176, 3.176]]
		}, {
			"name":"OBD II UART",
			"description":"This board allows you to interface with your car ' s OBD-II bus.It provides you a serial interface using the ELM327 command set and supports all major OBD-II standards such as CAN and JBUS.The board also provides a footprint which mates directly to our FTDI Basic or a Bluetooth Mate.The DB9 connector mates with our DB9 to OBD-II cable listed below.\tOn-Board Diagnostics, Second Generation(OBD-II)is a set of standards for implementing a computer based system to control emissions from vehicles.It was first introduced in the United States in 1994, and became a requirement on all 1996 and newer US vehicles.Other countries, including Canada, parts of the European Union, Japan, Australia, and Brazil adopted similar legislation.A large portion of the modern vehicle fleet supports OBD-II or one of its regional flavors.\tAmong other things, OBD-II requires that each compliant vehicle be equipped with a standard diagnostic connector(DLC)and describes a standard way of communicating with the vehicle’s computer, also known as the ECU(Electronic Control Unit).A wealth of information can be obtained by tapping into the OBD bus, including the status of the malfunction indicator light(MIL), diagnostic trouble codes(DTCs), inspection and maintenance(I\/M)information, freeze frames, VIN, hundreds of real-time parameters, and more.\tSTN1110 is an OBD to UART interpreter that can be used to convert messages between any of the OBD-II protocols currently in use, and UART.It is fully compatible with the de facto industry standard ELM327 command set.Based on a 16-bit processor core, the STN1110 offers more features and better performance than any other ELM327 compatible IC.\tFeatures: \t\t\tFully compatible with the ELM327 AT command set\t\t\tExtended ST command set\t\t\tUART interface(baud rates from 38 bps to 10 Mbps)\t\t\tSecure bootloader for easy firmware updates\t\t\tSupport for all legislated OBD II protocols: \t\t\t\t\t\t\t\t\tISO 15765-4(CAN)\t\t\t\t\t\t\tISO 14230-4(Keyword Protocol 2000)\t\t\t\t\t\t\tISO 9141-2(Asian, European, Chrysler vehicles)\t\t\t\t\t\t\tSAE J1850 VPW(GM vehicles)\t\t\t\t\t\t\tSAE J1850 PWM(Ford vehicles)\t\t\t\t\t\tSupport for non-legislated OBD protocols: \t\t\t\t\t\t\t\t\tISO 15765\t\t\t\t\t\t\tISO 11898(raw CAN)\t\t\t\t\t\tSupport for SAE J1939 OBD protocol\t\t\tSuperior automatic protocol detection algorithm\t\t\tLarge memory buffer\t\t\tVoltage input for battery monitoring\tDocuments: \t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet(STN1110)\t\t\tDatasheet(MCP2551)\t\t\tELM327 Command Set\t\t\tCompatible Software List",
			"image":"core\/breadboard\/OBD-II-UART-v13_breadboard.svg",
			"icon":"core\/breadboard\/OBD-II-UART-v13_breadboard.svg",
			"width":"194.4",
			"height":"145.607",
			"points": [[122.948, 56.1553, 6.104, 6.104], [115.748, 56.1553, 6.104, 6.104], [108.548, 56.1553, 6.104, 6.104], [101.348, 56.1553, 6.104, 6.104], [94.148, 56.1553, 6.104, 6.104], [86.948, 56.1553, 6.104, 6.104], [79.748, 56.1553, 6.104, 6.104], [72.548, 56.1553, 6.104, 6.104], [104.948, 135.355, 6.104, 6.104], [76.148, 135.355, 6.104, 6.104], [112.148, 135.355, 6.104, 6.104], [83.348, 135.355, 6.104, 6.104], [90.548, 135.355, 6.104, 6.104], [97.748, 135.355, 6.104, 6.104], [122.948, 81.355, 6.104, 6.104], [122.948, 74.155, 6.104, 6.104]]
		}, {
			"name":"PICAXE-08",
			"description":"PICAXE-08 from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_08_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_08_breadboard.svg",
			"width":"400",
			"height":"330",
			"points": [[34, 285.6, 32, 45.4], [34, -1, 32, 45.4], [334, 285.6, 32, 45.4], [334, -1, 32, 45.4], [134, 285.6, 32, 45.4], [134, -1, 32, 45.4], [234, 285.6, 32, 45.4], [234, -1, 32, 45.4]]
		}, {
			"name":"DAC Breakout",
			"description":"This is a simple breakout board for Analog Device ' s AD5330 8-bit digital-to-analog converter(DAC).The AD5330 has a parallel interface, and can operate from a 2.5 to 5.5V supply consuming just 115uA(at 3V).  The DB0-7 pins, the parallel data inputs, are used to configure the analog output voltage.CS selects the device, and data is loaded into the input registers on the rising edge of WR.The GAIN pin allows the output range to be set at either 0V to VCC or 0V to 2VCC.  Input data to the AD5330 is double-buffered, allowing simultaneous update of multiple DACs in a system using the LDAC pin.An asynchronous CLR input resets the contents of the input register and the DAC register to all zeros.The AD5330 also incorporates a power-on reset circuit that ensures that the DAC output powers on to 0V and remains there until valid data is written to the device.  This breadboard friendly board breaks out every necessary pin of the AD5330 to 0.1' spaced headers.The board includes a decoupling capacitor,but does not do any voltage regulation; voltage supplied to the board should be within the specified range.  Dimensions: 0.80 x 1.10 '  Documents:    Schematic   AD5330 Datasheet   Arduino Library   Tutorial",
			"image":"core\/breadboard\/ad5330 breakout-v11_breadboard.svg",
			"icon":"core\/breadboard\/ad5330 breakout-v11_breadboard.svg",
			"width":"57.6",
			"height":"79.2",
			"points": [[50.948, 22.148, 6.104, 6.104], [50.948, 29.348, 6.104, 6.104], [50.948, 36.548, 6.104, 6.104], [50.948, 43.748, 6.104, 6.104], [50.948, 50.948, 6.104, 6.104], [50.948, 58.148, 6.104, 6.104], [50.948, 65.348, 6.104, 6.104], [50.948, 72.548, 6.104, 6.104], [0.548, 29.348, 6.104, 6.104], [0.548, 36.548, 6.104, 6.104], [0.548, 43.748, 6.104, 6.104], [0.548, 50.948, 6.104, 6.104], [0.548, 58.148, 6.104, 6.104], [0.548, 65.348, 6.104, 6.104], [0.548, 72.548, 6.104, 6.104], [50.948, 7.748, 6.104, 6.104], [50.948, 0.548, 6.104, 6.104], [0.548, 0.548, 6.104, 6.104], [0.548, 7.748, 6.104, 6.104]]
		}, {
			"name":"7 Segment Display",
			"description":"7 Segment Display with common anode.",
			"image":"core\/breadboard\/7segment_9,9.svg",
			"icon":"core\/breadboard\/7segment_9,9.svg",
			"width":"30",
			"height":"38",
			"points": [[1.474, 2.127, 3.8, 3.799], [1.473, 9.326, 3.8, 3.799], [1.473, 16.525, 3.8, 3.799], [1.473, 23.727, 3.8, 3.799], [1.473, 30.926, 3.8, 3.799], [23.073, 2.127, 3.8, 3.799], [23.073, 9.326, 3.8, 3.799], [23.073, 16.525, 3.8, 3.799], [23.073, 23.727, 3.8, 3.799], [23.073, 30.926, 3.8, 3.799]]
		}, {
			"name":"7 Segment Display",
			"description":"7 Segment Display with common anode.",
			"image":"core\/breadboard\/7segment_100.svg",
			"icon":"core\/breadboard\/7segment_100.svg",
			"width":"256",
			"height":"347",
			"points": [[154.458, 19.535, 3.799, 3.799], [140.059, 19.533, 3.799, 3.801], [125.66, 19.533, 3.799, 3.801], [111.258, 19.533, 3.799, 3.801], [154.46, 322.835, 3.8, 3.799], [140.061, 322.835, 3.799, 3.799], [125.662, 322.835, 3.799, 3.799], [111.26, 322.835, 3.799, 3.799], [96.861, 322.835, 3.799, 3.799], [96.859, 19.533, 3.799, 3.801]]
		}, {
			"name":"AD654-Low Cost Monolithic Voltage-to-Frequency Converter",
			"description":"",
			"image":"core\/breadboard\/AD654.svg",
			"icon":"core\/breadboard\/AD654.svg",
			"width":"28.8",
			"height":"23.76",
			"points": [[1.52, 19.636, 4.16, 5.124], [8.72, 19.636, 4.16, 5.124], [15.919, 19.636, 4.16, 5.124], [23.121, 19.636, 4.159, 5.124], [23.121, -1, 4.159, 5.125], [15.919, -1, 4.16, 5.125], [8.72, -1, 4.16, 5.125], [1.52, -1, 4.16, 5.125]]
		}, {
			"name":"SIM Socket",
			"description":"SIM SocketSocket for SIM cellular cards.Schematic element and footprint production proven.Spark Fun Electronics SKU: PRT-00548",
			"image":"core\/breadboard\/sparkfun-connectors_simholder_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_simholder_breadboard.svg",
			"width":"787.514",
			"height":"600",
			"points": [[226.792, 533.05, 33.93, 33.9], [226.792, 33.05, 33.93, 33.9], [326.792, 533.05, 33.93, 33.9], [326.792, 33.05, 33.93, 33.9], [426.792, 533.05, 33.93, 33.9], [426.792, 33.05, 33.93, 33.9], [526.792, 533.05, 33.93, 33.9], [526.792, 33.05, 33.93, 33.9]]
		}, {
			"name":"TRANSFORMER",
			"description":"Small transformers",
			"image":"core\/breadboard\/sparkfun-poweric_transformer_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_transformer_breadboard.svg",
			"width":"42.021",
			"height":"75.02",
			"points": [[32.067, 31.14, 6.688, 6.688], [3.268, 31.14, 6.688, 6.688], [3.268, 59.94, 6.688, 6.688], [32.067, 59.94, 6.688, 6.688]]
		}, {
			"name":"24LC16",
			"description":"24LC16 I2C EEPROM",
			"image":"core\/breadboard\/24LC16_breadboard.svg",
			"icon":"core\/breadboard\/24LC16_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"SSOP28DB",
			"description":"",
			"image":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"icon":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"SO20W",
			"description":"",
			"image":"core\/breadboard\/SO20W_breadboard.svg",
			"icon":"core\/breadboard\/SO20W_breadboard.svg",
			"width":"72",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"USB Connectors",
			"description":"USB ConnectorsUSB-B-PTH is fully proven SKU: PRT-00139USB-miniB is fully proven SKU: PRT-00587USB-A-PCB is untested.USB-A-H is throughly reviewed, but untested.Spark Fun Electronics SKU: PRT-00437USB-B-SMT is throughly reviewed, but untested.Needs silkscreen touching up.USB-A-S has not been used\/testedUSB-MB-H has not been used\/tested",
			"image":"core\/breadboard\/sparkfun-connectors_usb-b-smt_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-b-smt_breadboard.svg",
			"width":"621.361",
			"height":"800",
			"points": [[193.715, 733.05, 33.93, 33.9], [193.715, 33.05, 33.93, 33.9], [293.716, 733.05, 33.93, 33.9], [293.716, 33.05, 33.93, 33.9], [393.716, 733.05, 33.93, 33.9], [393.716, 33.05, 33.93, 33.9]]
		}, {
			"name":"74HC4051",
			"description":"8: 1 analog mux",
			"image":"core\/breadboard\/SO16_breadboard.svg",
			"icon":"core\/breadboard\/SO16_breadboard.svg",
			"width":"57.6",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"AC Power",
			"description":"A generic ac power symbol",
			"image":"core\/schematic\/acpower.svg",
			"icon":"core\/schematic\/acpower.svg",
			"width":"14.4",
			"height":"28.8",
			"points": [[5.836, -0.75, 2.729, 9.281], [5.883, 23.016, 2.666, 6.783]]
		}, {
			"name":"Variable Capacitor",
			"description":"",
			"image":"core\/breadboard\/capacitor_variable_3_legs.svg",
			"icon":"core\/breadboard\/capacitor_variable_3_legs.svg",
			"width":"32.024",
			"height":"29.13",
			"points": [[13.922, 24.53, 4.16, 5.251], [-0.339, 16.894, 4.881, 4.16], [27.415, 16.762, 5.076, 4.159]]
		}, {
			"name":"DC Motor",
			"description":"Your standard DC Motor",
			"image":"core\/breadboard\/dc_motor_leg.svg",
			"icon":"core\/breadboard\/dc_motor_leg.svg",
			"width":"120.132",
			"height":"55.721",
			"points": [[18.321, 11.551, 3, 3], [18.221, 42.257, 3, 3]]
		}, {
			"name":"JOYSTICK_MINI",
			"description":"Small 5-way tactile joystick, COM-100634UCON SF303GJ26",
			"image":"core\/breadboard\/sparkfun-electromechanical_joystick_mini_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_joystick_mini_breadboard.svg",
			"width":"495.125",
			"height":"600",
			"points": [[80.5975, 533.05, 33.93, 33.9], [80.5975, 33.05, 33.93, 33.9], [180.597, 533.05, 33.93, 33.9], [180.597, 33.05, 33.93, 33.9], [280.597, 533.05, 33.93, 33.9], [280.597, 33.05, 33.93, 33.9], [380.598, 533.05, 33.93, 33.9], [380.598, 33.05, 33.93, 33.9]]
		}, {
			"name":"ISD1900",
			"description":"Voice recorder IC",
			"image":"core\/breadboard\/SO-28W_breadboard.svg",
			"icon":"core\/breadboard\/SO-28W_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"BTM182",
			"description":"BTM-182 Bluetooth Module from Rayson",
			"image":"core\/breadboard\/sparkfun-rf_btm182_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_btm182_breadboard.svg",
			"width":"1600",
			"height":"800",
			"points": [[33.035, 733.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 733.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 733.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 733.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 733.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 733.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 733.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 733.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 733.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 733.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 733.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 733.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 733.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 733.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 733.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 733.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"XPORT-DIRECT",
			"description":"TCP\/IP phy and stack module",
			"image":"core\/breadboard\/sparkfun-boards_xport_direct_module-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-boards_xport_direct_module-smd_breadboard.svg",
			"width":"1491.86",
			"height":"1800",
			"points": [[178.965, 1733.05, 33.93, 33.9], [178.965, 33.05, 33.93, 33.9], [278.965, 1733.05, 33.93, 33.9], [278.965, 33.05, 33.93, 33.9], [378.965, 1733.05, 33.93, 33.9], [378.965, 33.05, 33.93, 33.9], [478.965, 1733.05, 33.93, 33.9], [478.965, 33.05, 33.93, 33.9], [578.965, 1733.05, 33.93, 33.9], [578.965, 33.05, 33.93, 33.9], [678.965, 1733.05, 33.93, 33.9], [678.965, 33.05, 33.93, 33.9], [778.965, 1733.05, 33.93, 33.9], [778.965, 33.05, 33.93, 33.9], [878.965, 1733.05, 33.93, 33.9], [878.965, 33.05, 33.93, 33.9], [978.965, 1733.05, 33.93, 33.9], [978.965, 33.05, 33.93, 33.9], [1078.96, 1733.05, 33.93, 33.9], [1078.96, 33.05, 33.93, 33.9], [1178.97, 1733.05, 33.93, 33.9], [1178.97, 33.05, 33.93, 33.9], [1278.97, 1733.05, 33.93, 33.9], [1278.97, 33.05, 33.93, 33.9]]
		}
	]
}, {
	"page":"9",
	"count": 37,
	"el": [{
			"name":"SN74LS21N",
			"description":"Dual 4-input positive-AND gates",
			"image":"core\/breadboard\/SN74LS21N_breadboard.svg",
			"icon":"core\/breadboard\/SN74LS21N_breadboard.svg",
			"width":"70.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34]]
		}, {
			"name":"220 \ u2126 Resistor",
			"description":"ResistorBasic schematic elements and footprints for 0603, 1206, and PTH resistors.",
			"image":"core\/breadboard\/resistor_220.svg",
			"icon":"core\/breadboard\/resistor_220.svg",
			"width":"42.917",
			"height":"9.71",
			"points": [[-0.5, 2.59, 3, 3], [40.417, 2.59, 3, 3]]
		}, {
			"name":"DB25",
			"description":"Various DB25 connectors",
			"image":"core\/breadboard\/sparkfun-connectors_m25d_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_m25d_breadboard.svg",
			"width":"2300.44",
			"height":"600",
			"points": [[533.255, 533.05, 33.93, 33.9], [633.255, 533.05, 33.93, 33.9], [633.255, 33.05, 33.93, 33.9], [733.255, 533.05, 33.93, 33.9], [733.255, 33.05, 33.93, 33.9], [833.255, 533.05, 33.93, 33.9], [833.255, 33.05, 33.93, 33.9], [933.255, 533.05, 33.93, 33.9], [933.255, 33.05, 33.93, 33.9], [1033.26, 533.05, 33.93, 33.9], [1033.26, 33.05, 33.93, 33.9], [1133.26, 533.05, 33.93, 33.9], [1133.26, 33.05, 33.93, 33.9], [1233.26, 533.05, 33.93, 33.9], [1233.26, 33.05, 33.93, 33.9], [1333.26, 533.05, 33.93, 33.9], [1333.26, 33.05, 33.93, 33.9], [1433.26, 533.05, 33.93, 33.9], [1433.26, 33.05, 33.93, 33.9], [1533.26, 533.05, 33.93, 33.9], [1533.26, 33.05, 33.93, 33.9], [1633.26, 533.05, 33.93, 33.9], [1633.26, 33.05, 33.93, 33.9], [1733.26, 533.05, 33.93, 33.9], [1733.26, 33.05, 33.93, 33.9]]
		}, {
			"name":"MIDI_CONN_FEMALE",
			"description":"MIDI connector, no strain relieve(DIN-5 female)",
			"image":"core\/breadboard\/sparkfun-connectors_din_5_female_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_din_5_female_breadboard.svg",
			"width":"60.523",
			"height":"65.25",
			"points": [[26.78, 6.527, 7.224, 7.224], [47.983, 6.527, 7.224, 7.224], [5.435, 6.527, 7.224, 7.224], [12.635, 6.527, 7.224, 7.224], [40.981, 6.527, 7.224, 7.224]]
		}, {
			"name":"220 \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"core\/breadboard\/resistor_220.svg",
			"icon":"core\/breadboard\/resistor_220.svg",
			"width":"42.917",
			"height":"9.71",
			"points": [[-0.5, 2.59, 3, 3], [40.417, 2.59, 3, 3]]
		}, {
			"name":"Momentary Switch",
			"description":"Momentary SwitchButton commonly used for reset or general input.Spark Fun Electronics SKU: COM-00097",
			"image":"core\/breadboard\/basic_pbutton.svg",
			"icon":"core\/breadboard\/basic_pbutton.svg",
			"width":"24.518",
			"height":"33.002",
			"points": [[19.606, -0.998, 5, 6.25], [19.606, 27.752, 5, 6.25], [-0.394, -0.998, 5, 6.25], [-0.394, 27.752, 5, 6.25]]
		}, {
			"name":"DB25",
			"description":"Various DB25 connectors",
			"image":"core\/breadboard\/sparkfun-connectors_m25h_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_m25h_breadboard.svg",
			"width":"2300.46",
			"height":"600",
			"points": [[533.265, 533.05, 33.93, 33.9], [633.265, 533.05, 33.93, 33.9], [633.265, 33.05, 33.93, 33.9], [733.265, 533.05, 33.93, 33.9], [733.265, 33.05, 33.93, 33.9], [833.265, 533.05, 33.93, 33.9], [833.265, 33.05, 33.93, 33.9], [933.265, 533.05, 33.93, 33.9], [933.265, 33.05, 33.93, 33.9], [1033.26, 533.05, 33.93, 33.9], [1033.26, 33.05, 33.93, 33.9], [1133.26, 533.05, 33.93, 33.9], [1133.26, 33.05, 33.93, 33.9], [1233.26, 533.05, 33.93, 33.9], [1233.26, 33.05, 33.93, 33.9], [1333.26, 533.05, 33.93, 33.9], [1333.26, 33.05, 33.93, 33.9], [1433.26, 533.05, 33.93, 33.9], [1433.26, 33.05, 33.93, 33.9], [1533.27, 533.05, 33.93, 33.9], [1533.27, 33.05, 33.93, 33.9], [1633.27, 533.05, 33.93, 33.9], [1633.27, 33.05, 33.93, 33.9], [1733.27, 533.05, 33.93, 33.9], [1733.27, 33.05, 33.93, 33.9]]
		}, {
			"name":"XPORT-DIRECT",
			"description":"TCP\/IP phy and stack module",
			"image":"core\/breadboard\/sparkfun-boards_xport_direct_module_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-boards_xport_direct_module_breadboard.svg",
			"width":"1460.01",
			"height":"1800",
			"points": [[163.04, 1733.05, 33.93, 33.9], [163.04, 33.05, 33.93, 33.9], [263.04, 1733.05, 33.93, 33.9], [263.04, 33.05, 33.93, 33.9], [363.04, 1733.05, 33.93, 33.9], [363.04, 33.05, 33.93, 33.9], [463.04, 1733.05, 33.93, 33.9], [463.04, 33.05, 33.93, 33.9], [563.04, 1733.05, 33.93, 33.9], [563.04, 33.05, 33.93, 33.9], [663.04, 1733.05, 33.93, 33.9], [663.04, 33.05, 33.93, 33.9], [763.04, 1733.05, 33.93, 33.9], [763.04, 33.05, 33.93, 33.9], [863.04, 1733.05, 33.93, 33.9], [863.04, 33.05, 33.93, 33.9], [963.04, 1733.05, 33.93, 33.9], [963.04, 33.05, 33.93, 33.9], [1063.04, 1733.05, 33.93, 33.9], [1063.04, 33.05, 33.93, 33.9], [1163.04, 1733.05, 33.93, 33.9], [1163.04, 33.05, 33.93, 33.9], [1263.04, 1733.05, 33.93, 33.9], [1263.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Voltage Regulator",
			"description":"Voltage RegulatorStandard 7805 5V regulator.IGO(Input Ground Output).Spark Fun Electronics SKU: COM-00107",
			"image":"core\/breadboard\/sparkfun-poweric_to-92_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_to-92_breadboard.svg",
			"width":"16.527",
			"height":"31.293",
			"points": [[-1, 24.35, 4.16, 7.945], [6.181, 24.35, 4.159, 7.945], [13.367, 24.35, 4.16, 7.945]]
		}, {
			"name":"Rectifier Diode",
			"description":"A smd rectifier diode",
			"image":"core\/breadboard\/diode.svg",
			"icon":"core\/breadboard\/diode.svg",
			"width":"29.879",
			"height":"7.2",
			"points": [[-0.989, 1.583, 3, 3], [24.576, 1.583, 3, 3]]
		}, {
			"name":"PICAXE-18",
			"description":"PICAXE-18 from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_18_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_18_breadboard.svg",
			"width":"90.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [82.5, 27.66, 5, 6.34], [82.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [72.5, 27.66, 5, 6.34], [72.5, -1, 5, 6.34]]
		}, {
			"name":"220 \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"core\/breadboard\/resistor_220.svg",
			"icon":"core\/breadboard\/resistor_220.svg",
			"width":"42.917",
			"height":"9.71",
			"points": [[-0.5, 2.59, 3, 3], [40.417, 2.59, 3, 3]]
		}, {
			"name":"Generic female header-12 pins",
			"description":"Generic female header",
			"image":"obsolete\/breadboard\/generic-female-header_bread_12.svg",
			"icon":"obsolete\/breadboard\/generic-female-header_bread_12.svg",
			"width":"86.148",
			"height":"7.178",
			"points": [[1.202, 1.202, 4.775, 4.775], [8.381, 1.202, 4.775, 4.775], [15.56, 1.202, 4.775, 4.775], [22.739, 1.202, 4.775, 4.775], [29.918, 1.202, 4.775, 4.775], [37.097, 1.202, 4.775, 4.775], [44.276, 1.202, 4.775, 4.775], [51.455, 1.202, 4.775, 4.775], [58.634, 1.202, 4.775, 4.775], [65.813, 1.202, 4.775, 4.775], [72.992, 1.202, 4.775, 4.775], [80.171, 1.202, 4.775, 4.775]]
		}, {
			"name":"white LED-5mm",
			"description":"A generic white LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-white.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-white.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"TCM8240MD",
			"description":"1.3MP color image sensor",
			"image":"core\/breadboard\/sparkfun-sensors_tcm8240md_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_tcm8240md_breadboard.svg",
			"width":"1200",
			"height":"800",
			"points": [[33.035, 733.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 733.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 733.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 733.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 733.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 733.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 733.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 733.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 733.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 733.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 733.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 733.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Resonator",
			"description":"Ceramic resonator _without_ built-in capacitors",
			"image":"core\/breadboard\/resonator-2pin-leg.svg",
			"icon":"core\/breadboard\/resonator-2pin-leg.svg",
			"width":"18.688",
			"height":"23.351",
			"points": [[14.437, 16.549, 4.159, 3], [0.036, 16.549, 4.158, 3]]
		}, {
			"name":"Ceramic Capacitor",
			"description":"0.01 \ u00b5F Ceramic Disk Capacitor",
			"image":"obsolete\/breadboard\/ceramic_disk_capacitor_ochre.svg",
			"icon":"obsolete\/breadboard\/ceramic_disk_capacitor_ochre.svg",
			"width":"23",
			"height":"42.75",
			"points": [[-1, 31.75, 5, 12], [19, 31.75, 5, 12]]
		}, {
			"name":"PIC16F913",
			"description":"",
			"image":"core\/breadboard\/SO-28W_breadboard.svg",
			"icon":"core\/breadboard\/SO-28W_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"USB_MICROB_PLUG",
			"description":"USB Micro-B PlugComes in a variety of packages.Check out Hirose ' s ZX-x0 line: http: \/\/www.hirose.co.jp\/cataloge_hp\/e24200011.pdf",
			"image":"core\/breadboard\/sparkfun-connectors_micro-b-smt_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_micro-b-smt_breadboard.svg",
			"width":"943.653",
			"height":"800",
			"points": [[354.861, 733.05, 33.93, 33.9], [454.861, 733.05, 33.93, 33.9], [454.861, 33.05, 33.93, 33.9], [554.861, 733.05, 33.93, 33.9], [554.861, 33.05, 33.93, 33.9]]
		}, {
			"name":"CAPSENSE_PAD",
			"description":"Generic copper pad for a capacitive touch sensor.",
			"image":"core\/breadboard\/sparkfun-electromechanical_capsense_pad_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_capsense_pad_breadboard.svg",
			"width":"889.069",
			"height":"800",
			"points": [[427.57, 733.05, 33.93, 33.9], [427.57, 33.05, 33.93, 33.9]]
		}, {
			"name":"ID-12_20",
			"description":"RFID reader for ID2, ID12, and ID20 Package",
			"image":"core\/breadboard\/sparkfun-rf_id-12_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_id-12_breadboard.svg",
			"width":"994.347",
			"height":"1200",
			"points": [[230.208, 1133.05, 33.93, 33.9], [330.208, 1133.05, 33.93, 33.9], [330.208, 33.05, 33.93, 33.9], [430.208, 1133.05, 33.93, 33.9], [430.208, 33.05, 33.93, 33.9], [530.208, 1133.05, 33.93, 33.9], [530.208, 33.05, 33.93, 33.9], [630.208, 1133.05, 33.93, 33.9], [630.208, 33.05, 33.93, 33.9], [730.208, 1133.05, 33.93, 33.9], [730.208, 33.05, 33.93, 33.9]]
		}, {
			"name":"Monster Moto Shield",
			"description":"This is essentially a ramped up version of our Ardumoto motor driver shield.For this monster shield we ' ve replaced the L298 H-bridge with a pair of VNH2SP30 full-bridge motor drivers.We ' ve also beefed up the support circuitry so this board is capable of driving a pair of high-current motors!The VIN and motor out are pitched for our 5mm screw terminals(not included), making it easy to connect larger gauge wires.\tNote: When using this board in extreme high-demand applications it may be necessary to improve thermal performance with a heat-sink or fan and to solder the wires directly to the board instead of using a screw terminal(in addition to the myriad other complications present in a 30A system)However, when using the board at currents up to 6A the chips will barely become noticeably warm.\tFeatures: \t\t\tVoltage max: 41V\t\t\tMaximum current rating: 30 A\t\t\tCurrent sensing available to Arduino analog pin\t\t\tMOSFET on-resistance: 19 mΩ(per leg)\t\t\tMaximum PWM frequency: 20 kHz\t\t\tThermal Shutdown\t\t\tUndervoltage and Overvoltage shutdown\tDocuments: \t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet(VNH2SP30)\t\t\tExample Code",
			"image":"core\/breadboard\/MonsterMoto-Shield-v12_breadboard.svg",
			"icon":"core\/breadboard\/MonsterMoto-Shield-v12_breadboard.svg",
			"width":"151.2",
			"height":"169.2",
			"points": [[38.222, 2.222, 9.956, 9.956], [52.622, 2.222, 9.956, 9.956], [88.622, 2.222, 9.956, 9.956], [103.022, 2.222, 9.956, 9.956], [63.422, 157.022, 9.956, 9.956], [77.822, 157.022, 9.956, 9.956], [4.148, 72.548, 6.104, 6.104], [4.148, 79.748, 6.104, 6.104], [4.148, 115.748, 6.104, 6.104], [4.148, 122.948, 6.104, 6.104], [4.148, 130.148, 6.104, 6.104], [4.148, 137.348, 6.104, 6.104], [4.148, 144.548, 6.104, 6.104], [4.148, 151.748, 6.104, 6.104], [140.948, 40.148, 6.104, 6.104], [140.948, 137.348, 6.104, 6.104], [140.948, 130.148, 6.104, 6.104], [140.948, 122.948, 6.104, 6.104], [140.948, 115.748, 6.104, 6.104], [140.948, 108.548, 6.104, 6.104], [140.948, 101.348, 6.104, 6.104], [140.948, 90.548, 6.104, 6.104], [140.948, 83.348, 6.104, 6.104], [140.948, 76.148, 6.104, 6.104], [140.948, 68.948, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 54.548, 6.104, 6.104], [4.148, 86.948, 6.104, 6.104], [4.148, 94.148, 6.104, 6.104], [140.948, 47.348, 6.104, 6.104], [4.148, 65.348, 6.104, 6.104], [140.948, 151.748, 6.104, 6.104], [140.948, 144.548, 6.104, 6.104], [4.148, 101.348, 6.104, 6.104]]
		}, {
			"name":"Resonator",
			"description":"ResonatorSmall SMD resonator.This is the itty bitty 10\/20MHz resonators with built in caps.CSTCE10M0G55 and CSTCE20M0V53.Footprint has been reviewed closely but hasn ' t been tested yet.",
			"image":"core\/breadboard\/sparkfun-freqctrl_resonator-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-freqctrl_resonator-smd_breadboard.svg",
			"width":"274.866",
			"height":"400",
			"points": [[70.4681, 333.05, 33.93, 33.9], [170.468, 333.05, 33.93, 33.9], [170.468, 33.05, 33.93, 33.9]]
		}, {
			"name":"DB25",
			"description":"Various DB25 connectors",
			"image":"core\/breadboard\/sparkfun-connectors_m25v_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_m25v_breadboard.svg",
			"width":"2300.46",
			"height":"600",
			"points": [[533.265, 533.05, 33.93, 33.9], [633.265, 533.05, 33.93, 33.9], [633.265, 33.05, 33.93, 33.9], [733.265, 533.05, 33.93, 33.9], [733.265, 33.05, 33.93, 33.9], [833.265, 533.05, 33.93, 33.9], [833.265, 33.05, 33.93, 33.9], [933.265, 533.05, 33.93, 33.9], [933.265, 33.05, 33.93, 33.9], [1033.26, 533.05, 33.93, 33.9], [1033.26, 33.05, 33.93, 33.9], [1133.26, 533.05, 33.93, 33.9], [1133.26, 33.05, 33.93, 33.9], [1233.26, 533.05, 33.93, 33.9], [1233.26, 33.05, 33.93, 33.9], [1333.26, 533.05, 33.93, 33.9], [1333.26, 33.05, 33.93, 33.9], [1433.26, 533.05, 33.93, 33.9], [1433.26, 33.05, 33.93, 33.9], [1533.27, 533.05, 33.93, 33.9], [1533.27, 33.05, 33.93, 33.9], [1633.27, 533.05, 33.93, 33.9], [1633.27, 33.05, 33.93, 33.9], [1733.27, 533.05, 33.93, 33.9], [1733.27, 33.05, 33.93, 33.9]]
		}, {
			"name":"STARBOARD_PWR",
			"description":"StarbBoard Power padPower pads are designated by the star cutout in the top layer.",
			"image":"core\/breadboard\/sparkfun-connectors_starboard_pwr_wide_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_starboard_pwr_wide_breadboard.svg",
			"width":"660",
			"height":"1000",
			"points": [[313.035, 933.05, 33.93, 33.9]]
		}, {
			"name":"GE865_2",
			"description":"Telit quad cell module(CEL-09720)",
			"image":"core\/breadboard\/sparkfun-rf_ge865_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_ge865_breadboard.svg",
			"width":"3200",
			"height":"1200",
			"points": [[33.035, 1133.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 1133.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 1133.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 1133.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 1133.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 1133.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 1133.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 1133.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 1133.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 1133.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 1133.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 1133.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 1133.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 1133.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 1133.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 1133.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 1133.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 1133.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 1133.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 1133.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 1133.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 1133.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 1133.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 1133.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 1133.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 1133.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 1133.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 1133.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 1133.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 1133.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 1133.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 1133.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"XBEE-1",
			"description":"Xbee module footprints",
			"image":"core\/breadboard\/xbee_realsize.svg",
			"icon":"core\/breadboard\/xbee_realsize.svg",
			"width":"68.604",
			"height":"74.27",
			"points": [[0.655, 69.239, 5.294, 5.294], [0.655, 63.57, 5.294, 5.294], [0.655, 57.9, 5.294, 5.294], [0.655, 52.231, 5.294, 5.294], [0.655, 46.562, 5.294, 5.294], [0.655, 40.892, 5.294, 5.294], [0.655, 35.223, 5.294, 5.294], [0.655, 29.554, 5.294, 5.294], [0.655, 23.884, 5.294, 5.294], [0.655, 18.216, 5.294, 5.294], [63.017, 69.239, 5.294, 5.294], [63.017, 63.57, 5.294, 5.294], [63.017, 57.9, 5.294, 5.294], [63.017, 52.231, 5.294, 5.294], [63.017, 46.562, 5.294, 5.294], [63.017, 40.892, 5.294, 5.294], [63.017, 35.223, 5.294, 5.294], [63.017, 29.554, 5.294, 5.294], [63.017, 23.884, 5.294, 5.294], [63.017, 18.216, 5.294, 5.294]]
		}, {
			"name":"SM5100B",
			"description":"Quad-band GSM modem",
			"image":"core\/breadboard\/sparkfun-rf_sm5100b_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_sm5100b_breadboard.svg",
			"width":"3000",
			"height":"1800",
			"points": [[33.035, 1733.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 1733.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 1733.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 1733.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 1733.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 1733.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 1733.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 1733.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 1733.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 1733.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 1733.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 1733.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 1733.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 1733.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 1733.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 1733.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 1733.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 1733.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 1733.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 1733.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 1733.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 1733.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 1733.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 1733.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 1733.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 1733.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 1733.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 1733.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 1733.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 1733.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"1.5k \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_1.5k.svg",
			"icon":"obsolete\/breadboard\/resistor_1.5k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"1.5k \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_1.5k.svg",
			"icon":"obsolete\/breadboard\/resistor_1.5k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Buzzer 12mm",
			"description":"Buzzer 12mmSpark Fun Electronics SKU: Comp-Buzzer",
			"image":"core\/breadboard\/sparkfun-electromechanical_buzzer-ccv_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buzzer-ccv_breadboard.svg",
			"width":"640.944",
			"height":"800",
			"points": [[303.507, 733.05, 33.93, 33.9], [303.507, 33.05, 33.93, 33.9]]
		}, {
			"name":"Buzzer 12mm",
			"description":"Buzzer 12mmSpark Fun Electronics SKU: Comp-Buzzer",
			"image":"core\/breadboard\/sparkfun-electromechanical_buzzer-cmt1102_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buzzer-cmt1102_breadboard.svg",
			"width":"1030.71",
			"height":"1000",
			"points": [[498.389, 933.05, 33.93, 33.9], [498.389, 33.05, 33.93, 33.9]]
		}, {
			"name":"USB Connectors",
			"description":"USB ConnectorsUSB-B-PTH is fully proven SKU: PRT-00139USB-miniB is fully proven SKU: PRT-00587USB-A-PCB is untested.USB-A-H is throughly reviewed, but untested.Spark Fun Electronics SKU: PRT-00437USB-B-SMT is throughly reviewed, but untested.Needs silkscreen touching up.USB-A-S has not been used\/testedUSB-MB-H has not been used\/tested",
			"image":"core\/breadboard\/sparkfun-connectors_s4b-ph_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_s4b-ph_breadboard.svg",
			"width":"688.167",
			"height":"600",
			"points": [[227.119, 533.05, 33.93, 33.9], [227.119, 33.05, 33.93, 33.9], [327.119, 533.05, 33.93, 33.9], [327.119, 33.05, 33.93, 33.9], [427.119, 533.05, 33.93, 33.9], [427.119, 33.05, 33.93, 33.9]]
		}, {
			"name":"SHIFT REGISTER",
			"description":"8-bit SHIFT REGISTER, output latch",
			"image":"core\/breadboard\/sparkfun-digitalic_lcc20_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_lcc20_breadboard.svg",
			"width":"1000",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_cr75_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_cr75_breadboard.svg",
			"width":"492.403",
			"height":"800",
			"points": [[229.237, 733.05, 33.93, 33.9], [229.237, 33.05, 33.93, 33.9]]
		}, {
			"name":"SIMHOLDER2",
			"description":"Alternate SIM card socket.",
			"image":"core\/breadboard\/sparkfun-connectors_simholder2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_simholder2_breadboard.svg",
			"width":"1369.29",
			"height":"1000",
			"points": [[517.68, 933.05, 33.93, 33.9], [517.68, 33.05, 33.93, 33.9], [617.68, 933.05, 33.93, 33.9], [617.68, 33.05, 33.93, 33.9], [717.68, 933.05, 33.93, 33.9], [717.68, 33.05, 33.93, 33.9], [817.68, 933.05, 33.93, 33.9], [817.68, 33.05, 33.93, 33.9]]
		}, {
			"name":"A6282",
			"description":"16-Channel Constant-Current LED DriverPackages: TSSOP-24, 24-pin QFNLast modified: 8\/20\/10Unproven!",
			"image":"core\/breadboard\/sparkfun-digitalic_qfn-24_alt2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_qfn-24_alt2_breadboard.svg",
			"width":"1300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 333.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 333.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 333.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder Jumper2 way solder jumper",
			"image":"core\/breadboard\/sparkfun-passives_sj_3_paste1_2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_3_paste1_2_breadboard.svg",
			"width":"263",
			"height":"400",
			"points": [[64.535, 333.05, 33.93, 33.9], [164.535, 333.05, 33.93, 33.9], [164.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"V_REG_LD1117VXX",
			"description":"LD1117VXX voltage regulator.We carry the 3.3V version(COM-00526)in TO-220 package.",
			"image":"core\/breadboard\/sparkfun-poweric_78xxl_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_78xxl_breadboard.svg",
			"width":"29.736",
			"height":"56.736",
			"points": [[4.976, 52.136, 5.6, 5.6], [12.176, 52.136, 5.6, 5.6], [19.376, 52.136, 5.6, 5.6]]
		}, {
			"name":"PICAXE-28",
			"description":"PICAXE-28 from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_28_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_28_breadboard.svg",
			"width":"140.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [132.5, 27.66, 5, 6.34], [132.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [72.5, 27.66, 5, 6.34], [72.5, -1, 5, 6.34], [82.5, 27.66, 5, 6.34], [82.5, -1, 5, 6.34], [92.5, 27.66, 5, 6.34], [92.5, -1, 5, 6.34], [102.5, 27.66, 5, 6.34], [102.5, -1, 5, 6.34], [112.5, 27.66, 5, 6.34], [112.5, -1, 5, 6.34], [122.5, 27.66, 5, 6.34], [122.5, -1, 5, 6.34]]
		}, {
			"name":"Screw terminal-2 pins",
			"description":"Screw terminal with 2 pins",
			"image":"core\/breadboard\/screw_terminal_2_100mil_bread.svg",
			"icon":"core\/breadboard\/screw_terminal_2_100mil_bread.svg",
			"width":"200",
			"height":"170",
			"points": [[33.2884, 108.874, 33.5235, 62.0844], [133.2884, 108.874, 33.5235, 62.0844]]
		}, {
			"name":"LTR-301",
			"description":"Through-hole side-receiving IR phototransistor",
			"image":"core\/breadboard\/sparkfun-sensors_ltr-301_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_ltr-301_breadboard.svg",
			"width":"13.232",
			"height":"35.113",
			"points": [[7.722, 31.682, 4.988, 4.988], [0.523, 31.682, 4.988, 4.988]]
		}, {
			"name":"MMDT3904",
			"description":"Dual NPN transistor",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot363_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot363_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Basic FET P-Channel",
			"description":"A MOSFET P-Channel Transistor",
			"image":"core\/breadboard\/mosfet_p_channel.svg",
			"icon":"core\/breadboard\/mosfet_p_channel.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"SCP1000_D01",
			"description":"Barometric pressure sensor.Schematic elements and footprint production proven.Spark Fun Electronics SKU: COM-08128",
			"image":"core\/breadboard\/sparkfun-sensors_scp1000_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_scp1000_breadboard.svg",
			"width":"900",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"24LC32",
			"description":"24LC32 I2C EEPROM",
			"image":"core\/breadboard\/24LC32_breadboard.svg",
			"icon":"core\/breadboard\/24LC32_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}
	]
}, {
	"page":"10",
	"count": 37,
	"el": [{
			"name":"Arduino BT",
			"description":"The Arduino BT is a microcontroller board originally was based on the ATmega168, but now is supplied with the 328(datasheet)and the Bluegiga WT11 bluetooth module(details and datasheet[pdf]).It supports wireless serial communication over bluetooth(but is not compatible with Bluetooth headsets or other audio devices).It has 14 digital input\/output pins(of which 6 can be used as PWM outputs and one can be used to reset the WT11 module), 6 analog inputs, a 16 MHz crystal oscillator, screw terminals for power, an ICSP header, and a reset button.It contains everything needed to support the microcontroller and can be programmed wirelessly over the Bluetooth connection.Instructions are available for getting started with the Arduino BT.",
			"image":"core\/breadboard\/Arduino_bt07_breadboard.svg",
			"icon":"core\/breadboard\/Arduino_bt07_breadboard.svg",
			"width":"230.057",
			"height":"151.2",
			"points": [[213.245, 62.028, 5.544, 5.544], [220.445, 62.028, 5.544, 5.544], [213.246, 69.229, 5.542, 5.542], [220.446, 69.229, 5.542, 5.542], [213.246, 76.429, 5.542, 5.542], [220.446, 76.429, 5.542, 5.542], [151.032, 4.494, 5.412, 5.412], [143.831, 4.494, 5.412, 5.412], [136.631, 4.494, 5.412, 5.412], [129.431, 4.494, 5.412, 5.412], [122.231, 4.494, 5.412, 5.412], [115.032, 4.494, 5.412, 5.412], [107.831, 4.494, 5.412, 5.412], [100.631, 4.494, 5.412, 5.412], [93.431, 4.494, 5.412, 5.412], [86.232, 4.494, 5.412, 5.412], [176.95, 141.293, 5.414, 5.414], [184.15, 141.293, 5.414, 5.414], [191.35, 141.293, 5.414, 5.414], [198.55, 141.293, 5.414, 5.414], [205.75, 141.293, 5.414, 5.414], [212.95, 141.293, 5.414, 5.414], [212.951, 4.494, 5.412, 5.412], [205.751, 4.494, 5.412, 5.412], [198.551, 4.494, 5.412, 5.412], [191.351, 4.494, 5.412, 5.412], [184.151, 4.494, 5.412, 5.412], [176.951, 4.494, 5.412, 5.412], [169.751, 4.494, 5.412, 5.412], [162.551, 4.494, 5.412, 5.412], [184.561, 112.544, 5.312, 5.312], [177.361, 112.544, 5.312, 5.312], [162.55, 141.293, 5.414, 5.414], [155.35, 141.293, 5.414, 5.414], [148.15, 141.293, 5.414, 5.414], [140.95, 141.293, 5.414, 5.414], [133.75, 141.293, 5.414, 5.414], [126.55, 141.293, 5.414, 5.414], [119.35, 141.293, 5.414, 5.414], [112.15, 141.293, 5.414, 5.414]]
		}, {
			"name":"BUTTONPAD-2X2SINGLE",
			"description":"Proto layout and schematic for 2x2 button pad with single color LEDs(used on Simon board).Panelize this device\/fp to a 4x4 pad if needed.Any single-color 5mm LED should be compatible.Spark Fun Electronics SKU: COM-07835.",
			"image":"core\/breadboard\/sparkfun-electromechanical_buttonpad-2x2single-kit_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buttonpad-2x2single-kit_breadboard.svg",
			"width":"2188.42",
			"height":"2400",
			"points": [[727.245, 2333.05, 33.93, 33.9], [727.245, 33.05, 33.93, 33.9], [827.245, 2333.05, 33.93, 33.9], [827.245, 33.05, 33.93, 33.9], [927.245, 2333.05, 33.93, 33.9], [927.245, 33.05, 33.93, 33.9], [1027.25, 2333.05, 33.93, 33.9], [1027.25, 33.05, 33.93, 33.9], [1127.25, 2333.05, 33.93, 33.9], [1127.25, 33.05, 33.93, 33.9], [1227.24, 2333.05, 33.93, 33.9], [1227.24, 33.05, 33.93, 33.9], [1327.24, 2333.05, 33.93, 33.9], [1327.24, 33.05, 33.93, 33.9], [1427.24, 2333.05, 33.93, 33.9], [1427.24, 33.05, 33.93, 33.9]]
		}, {
			"name":"IMU Digital Combo Board 6DOF",
			"description":"This is a simple breakout for the ADXL345 accelerometer and the ITG-3200 gyro.With this board, you get a full 6 degrees of freedom.The sensors communicate over I2C and one INT output pin from each sensor is broken out.If you need a simple and tiny board that gives you 6 degrees of freedom, this would be a good choice.",
			"image":"core\/breadboard\/6DOF-Digital-v10_breadboard.svg",
			"icon":"core\/breadboard\/6DOF-Digital-v10_breadboard.svg",
			"width":"46.8",
			"height":"43.2",
			"points": [[40.148, 36.548, 6.104, 6.104], [40.148, 29.348, 6.104, 6.104], [40.148, 22.148, 6.104, 6.104], [40.148, 14.948, 6.104, 6.104], [40.148, 7.748, 6.104, 6.104], [40.148, 0.548, 6.104, 6.104]]
		}, {
			"name":"TI Launchpad MSP430G2",
			"description":"The LaunchPad is an easy-to-use, affordable, and scalable introduction to the world of microcontrollers and the MSP430 family.See: http: \/\/e2e.ti.com\/group\/msp430launchpad\/w\/default .aspx",
			"image":"obsolete\/breadboard\/TI_Launchpad_MSP430G2__ebb2b2673b63f5dd6__breadboard__98696ce55bfaf674ef9c24f01d976248.svg",
			"icon":"obsolete\/breadboard\/TI_Launchpad_MSP430G2__ebb2b2673b63f5dd6__breadboard__98696ce55bfaf674ef9c24f01d976248.svg",
			"width": 0,
			"height": 0,
			"points": [[112.5683499, 168.7831399, 4.7750001, 4.7750001], [119.7473496, 168.7831399, 4.7750001, 4.7750001], [126.926349, 168.7831399, 4.7750001, 4.7750001], [134.10535, 168.7831399, 4.7750001, 4.7750001], [141.284349, 168.7831399, 4.7750001, 4.7750001], [148.46335, 168.7831399, 4.7750001, 4.7750001], [155.642351, 168.7831399, 4.7750001, 4.7750001], [162.821352, 168.7831399, 4.7750001, 4.7750001], [170.000349, 168.7831399, 4.7750001, 4.7750001], [177.179354, 168.7831399, 4.7750001, 4.7750001], [112.5683499, 7.0715799, 4.7750001, 4.7750001], [119.7473496, 7.0715799, 4.7750001, 4.7750001], [126.926349, 7.0715799, 4.7750001, 4.7750001], [134.10535, 7.0715799, 4.7750001, 4.7750001], [141.284349, 7.0715799, 4.7750001, 4.7750001], [148.46335, 7.0715799, 4.7750001, 4.7750001], [155.642351, 7.0715799, 4.7750001, 4.7750001], [162.821352, 7.0715799, 4.7750001, 4.7750001], [170.000349, 7.0715799, 4.7750001, 4.7750001], [177.179354, 7.0715799, 4.7750001, 4.7750001]]
		}, {
			"name":"PWM Shield",
			"description":"This is the Arduino shield version of our TLC5940 Breakout.The PWM Shield will allow you to generate up to 16 PWM signals from your Arduino by utilizing the power of the TLC5940 IC.All 16 PWM channels are broken out to standard 0.1' headers, which run alongside convenient voltage and ground rails.Because the IC can be daisy-chained, output headers are broken out on one side of the shield and can be connected to our TLC5940 Breakout to further expand your PWM capabilities. Use this board to increase the number of PWM pins available to your microcontroller for applications such as monocolor, multicolor or full-color LED displays, LED signboards, display backlighting, servo control, or any other project where a large number of PWM drivers are necessary. Note: While each 3-pin PWM header is 0.1'spaced, the space between each header is slightly larger in order to accommodate servo connections.In order to make this board suitable for use with servos, 2.2k pull-up resistors have been included on each output as well.Finally, the 2.2k resistor on the Iref pin sets the output current to 17.8mA but a parallel through-hole connection is provided for an additional resistor to increase the current if necessary.To determine the resistor value you need for a given output check the equations provided on the schematic below. Documents:    Schematic   Eagle Files   Datasheet(TLC5940)   Arduino Library   Arduino Example",
			"image":"core\/breadboard\/PWM-Shield-v12_breadboard.svg",
			"icon":"core\/breadboard\/PWM-Shield-v12_breadboard.svg",
			"width":"169.288",
			"height":"151.2",
			"points": [[115.116, 115.748, 6.104, 6.104], [115.116, 108.548, 6.104, 6.104], [115.116, 101.348, 6.104, 6.104], [43.8358, 115.748, 6.104, 6.104], [43.8358, 108.548, 6.104, 6.104], [43.8358, 101.348, 6.104, 6.104], [51.7558, 115.748, 6.104, 6.104], [51.7558, 108.548, 6.104, 6.104], [51.7558, 101.348, 6.104, 6.104], [59.6758, 115.748, 6.104, 6.104], [59.6758, 108.548, 6.104, 6.104], [59.6758, 101.348, 6.104, 6.104], [67.5958, 115.748, 6.104, 6.104], [67.5958, 108.548, 6.104, 6.104], [67.5958, 101.348, 6.104, 6.104], [75.5158, 115.748, 6.104, 6.104], [75.5158, 108.548, 6.104, 6.104], [75.5158, 101.348, 6.104, 6.104], [83.4358, 115.748, 6.104, 6.104], [83.4358, 108.548, 6.104, 6.104], [83.4358, 101.348, 6.104, 6.104], [91.3558, 115.748, 6.104, 6.104], [91.3558, 108.548, 6.104, 6.104], [91.3558, 101.348, 6.104, 6.104], [99.276, 115.748, 6.104, 6.104], [99.276, 108.548, 6.104, 6.104], [99.276, 101.348, 6.104, 6.104], [107.196, 115.748, 6.104, 6.104], [107.196, 108.548, 6.104, 6.104], [107.196, 101.348, 6.104, 6.104], [162.636, 32.948, 6.104, 6.104], [162.636, 40.148, 6.104, 6.104], [162.636, 47.348, 6.104, 6.104], [162.636, 54.548, 6.104, 6.104], [162.636, 61.748, 6.104, 6.104], [162.636, 68.948, 6.104, 6.104], [162.636, 76.148, 6.104, 6.104], [123.036, 115.748, 6.104, 6.104], [123.036, 108.548, 6.104, 6.104], [123.036, 101.348, 6.104, 6.104], [130.956, 115.748, 6.104, 6.104], [130.956, 108.548, 6.104, 6.104], [130.956, 101.348, 6.104, 6.104], [138.876, 115.748, 6.104, 6.104], [138.876, 108.548, 6.104, 6.104], [138.876, 101.348, 6.104, 6.104], [146.796, 115.748, 6.104, 6.104], [146.796, 108.548, 6.104, 6.104], [146.796, 101.348, 6.104, 6.104], [154.716, 115.748, 6.104, 6.104], [154.716, 108.548, 6.104, 6.104], [154.716, 101.348, 6.104, 6.104], [162.636, 115.748, 6.104, 6.104], [162.636, 108.548, 6.104, 6.104], [162.636, 101.348, 6.104, 6.104], [7.95741, 103.26961, 6.58078, 6.58078], [7.95741, 113.19161, 6.58078, 6.58078], [14.48573, 111.91293, 5.04414, 5.04414], [14.48573, 106.24293, 5.04414, 5.04414], [0.63588, 112.148, 6.104, 6.104], [0.63588, 104.948, 6.104, 6.104], [72.6358, 140.948, 6.104, 6.104], [79.8358, 140.948, 6.104, 6.104], [115.836, 140.948, 6.104, 6.104], [123.036, 140.948, 6.104, 6.104], [130.236, 140.948, 6.104, 6.104], [137.436, 140.948, 6.104, 6.104], [144.636, 140.948, 6.104, 6.104], [151.836, 140.948, 6.104, 6.104], [40.2358, 4.148, 6.104, 6.104], [137.436, 4.148, 6.104, 6.104], [130.236, 4.148, 6.104, 6.104], [123.036, 4.148, 6.104, 6.104], [115.836, 4.148, 6.104, 6.104], [108.636, 4.148, 6.104, 6.104], [101.436, 4.148, 6.104, 6.104], [90.6358, 4.148, 6.104, 6.104], [83.4358, 4.148, 6.104, 6.104], [76.2358, 4.148, 6.104, 6.104], [69.0358, 4.148, 6.104, 6.104], [61.8358, 4.148, 6.104, 6.104], [54.6358, 4.148, 6.104, 6.104], [87.0358, 140.948, 6.104, 6.104], [94.2358, 140.948, 6.104, 6.104], [47.4358, 4.148, 6.104, 6.104], [65.4358, 140.948, 6.104, 6.104], [151.836, 4.148, 6.104, 6.104], [144.636, 4.148, 6.104, 6.104]]
		}, {
			"name":"LT1014",
			"description":"Precision quad op-amp.I\/O range includes negative rail.",
			"image":"core\/breadboard\/sparkfun-analogic_so16l_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_so16l_breadboard.svg",
			"width":"800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"DIODE-ZENER",
			"description":"Zener DiodeProduction Part-81993.4V Zener Voltage",
			"image":"core\/breadboard\/sparkfun-discretesemi_smb-diode_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_smb-diode_breadboard.svg",
			"width":"419.292",
			"height":"400",
			"points": [[192.681, 333.05, 33.93, 33.9], [192.681, 33.05, 33.93, 33.9]]
		}, {
			"name":"LCD screen",
			"description":"A standard character display, usually with 2x16 characters.Comes in many colors.",
			"image":"obsolete\/breadboard\/lcd-screen.svg",
			"icon":"obsolete\/breadboard\/lcd-screen.svg",
			"width":"226.772",
			"height":"102.047",
			"points": [[17.043, 1.081, 4.774, 4.774], [24.243, 1.081, 4.774, 4.774], [31.443, 1.081, 4.774, 4.774], [38.643, 1.081, 4.774, 4.774], [45.842, 1.081, 4.774, 4.774], [53.043, 1.081, 4.774, 4.774], [67.443, 1.081, 4.774, 4.774], [74.642, 1.081, 4.774, 4.774], [81.842, 1.081, 4.774, 4.774], [89.043, 1.081, 4.774, 4.774], [96.243, 1.081, 4.774, 4.774], [103.442, 1.081, 4.774, 4.774], [110.642, 1.081, 4.774, 4.774], [117.842, 1.081, 4.774, 4.774], [125.043, 1.081, 4.774, 4.774], [125.043, 1.081, 4.774, 4.774]]
		}, {
			"name":"LilyPad Simple Power",
			"description":"The LilyPad Simple Power is a board that lets you connect a battery(or other power source)and switch it on or off, that ' s it!We provide you with a JST connector and a slide switch .You can solder in your own surface mount(or through-hole) resistor in line with the output, or solder the jumper closed if you don ' t require a resistor.LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input,output, power, and sensor boards are available.They ' re even washable!",
			"image":"core\/breadboard\/LilyPad SimplePower-v13_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad SimplePower-v13_breadboard.svg",
			"width":"28.8",
			"height":"86.4",
			"points": [[125.043, 1.081, 4.774, 4.774], [125.043, 1.081, 4.774, 4.774]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder Jumper2 way solder jumper",
			"image":"core\/breadboard\/sparkfun-passives_sj_3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_3_breadboard.svg",
			"width":"263",
			"height":"400",
			"points": [[64.535, 333.05, 33.93, 33.9], [164.535, 333.05, 33.93, 33.9], [164.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder Jumper2 way solder jumper",
			"image":"core\/breadboard\/sparkfun-passives_sj_2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2_breadboard.svg",
			"width":"298",
			"height":"400",
			"points": [[82.035, 333.05, 33.93, 33.9], [182.035, 333.05, 33.93, 33.9], [182.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Raspberry Pi 2",
			"description":"The RPi2, a faster version of the awesome Raspberry Pi B + ARM Board with 40 pin gipo.Ready for special Raspberry Pi B + and RPi2 Hat(Hardware attached(on)top)",
			"image":"core\/breadboard\/raspberry_pi2_v1.1_breadboard.svg",
			"icon":"core\/breadboard\/raspberry_pi2_v1.1_breadboard.svg",
			"width":"245.968",
			"height":"164.339",
			"points": [[20.627, 9.267, 6.176, 6.176], [27.827, 9.267, 6.176, 6.176], [35.027, 9.267, 6.176, 6.176], [42.227, 9.267, 6.176, 6.176], [49.427, 9.267, 6.176, 6.176], [56.627, 9.267, 6.176, 6.176], [63.827, 9.267, 6.176, 6.176], [71.027, 9.267, 6.176, 6.176], [78.228, 9.267, 6.176, 6.176], [85.427, 9.267, 6.176, 6.176], [92.627, 9.267, 6.176, 6.176], [99.826, 9.266, 6.178, 6.178], [107.027, 9.267, 6.176, 6.176], [114.227, 9.267, 6.176, 6.176], [121.428, 9.267, 6.176, 6.176], [128.626, 9.267, 6.176, 6.176], [135.827, 9.266, 6.178, 6.178], [143.027, 9.267, 6.176, 6.176], [150.226, 9.267, 6.176, 6.176], [157.427, 9.267, 6.176, 6.176], [157.427, 2.068, 6.176, 6.176], [150.226, 2.068, 6.176, 6.176], [143.027, 2.068, 6.176, 6.176], [135.827, 2.067, 6.178, 6.178], [128.626, 2.068, 6.176, 6.176], [121.428, 2.068, 6.176, 6.176], [114.227, 2.068, 6.176, 6.176], [107.027, 2.068, 6.176, 6.176], [99.826, 2.067, 6.178, 6.178], [92.627, 2.068, 6.176, 6.176], [85.427, 2.068, 6.176, 6.176], [78.228, 2.068, 6.176, 6.176], [71.027, 2.068, 6.176, 6.176], [63.827, 2.068, 6.176, 6.176], [56.627, 2.068, 6.176, 6.176], [49.427, 2.068, 6.176, 6.176], [42.227, 2.068, 6.176, 6.176], [35.027, 2.068, 6.176, 6.176], [27.827, 2.068, 6.176, 6.176], [20.627, 2.068, 6.176, 6.176]]
		}, {
			"name":"Triple Axis Magnetometer-HMC5883 Breakout",
			"description":"This is a breakout board for Honeywell ' s HMC5883, a 3-axis digital compass.Communication with the HMC5883 is simple and all done through an I2C interface.There is no on-board regulator, so a regulated voltage of 2.16-3.6VDC should be supplied.The breakout board includes the HMC584843 sensor and all filtering capacitors as shown.The power and 2-wire interface pins are all broken out to a 0.1 \"pitch header.Features:  * Simple I2C interface * 2.16 to 3.6VDC supply range * Low current draw * 5 milli-gauss resolutionDimensions: 0.7x0.7 \"(17.78x17.78mm)",
			"image":"core\/breadboard\/HMC5883L_Breakout-v11_breadboard.svg",
			"icon":"core\/breadboard\/HMC5883L_Breakout-v11_breadboard.svg",
			"width":"50.4",
			"height":"50.4",
			"points": [[32.948, 43.748, 6.104, 6.104], [25.748, 43.748, 6.104, 6.104], [18.548, 43.748, 6.104, 6.104], [11.348, 43.748, 6.104, 6.104]]
		}, {
			"name":"BANANA_CONN",
			"description":"Through-hole banana jack",
			"image":"core\/breadboard\/sparkfun-connectors_banana_conn_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_banana_conn_breadboard.svg",
			"width":"428.597",
			"height":"600",
			"points": [[197.333, 533.05, 33.93, 33.9]]
		}, {
			"name":"Diode",
			"description":"These are standard reverse protection diodes and small signal diodes. SMA package can handle up to about 1A. SOD-323 can handle about 200mA. What the SOD-323 package when ordering, there are some mfgs out there that are 5-pin packages.",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot23-3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot23-3_breadboard.svg",
			"width":"259.118",
			"height":"400",
			"points": [[62.5941, 333.05, 33.93, 33.9], [162.594, 333.05, 33.93, 33.9], [162.594, 33.05, 33.93, 33.9]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder Jumper2 way solder jumper",
			"image":"core\/breadboard\/sparkfun-passives_sj_2w_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2w_breadboard.svg",
			"width":"338",
			"height":"400",
			"points": [[102.035, 333.05, 33.93, 33.9], [202.035, 333.05, 33.93, 33.9], [202.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"SCA3000",
			"description":"2g SPI accelerometer with interrrupt",
			"image":"core\/breadboard\/sparkfun-sensors_sca3000_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_sca3000_breadboard.svg",
			"width":"900",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"QuadStepper",
			"description":"The Quadstepper motor driver board allows you to control up to 4 bipolar stepper motors simultaneously using logic level IO pins. Each motor driver has an output drive capacity of 35V and 2Amps. The board is capable of driving motors in full, half, quarter, eight, and sixteenth-step modes. The logic levels are selectable between 3.3V and 5V by way of a jumper. The bus header allows you to control all four motors with only 6 IO pins by controlling the enable (EN pins) for each motor, although each motor will be activated alone, not simultaneously. Be sure to close all of the'Bus Enable'jumpers on the back of the board in order to use the Bus header.\tThe Quadstepper is a great board for 3D printing applications as well as a host of other applications where it' s necessary to control precise movement from logic level IO pins.\tNote: Although this board can theoretically supply 2A per motor, you will run into heat issues if you do not have proper thermal management(ie-heatsinks).Without heatsinking, you can expect to drive each motor up to 1A, which would be fine for our stepper motors, or something similar.\tFeatures: \t\t\tCan control up to 4 bipolar stepper motors simultaneously.\t\t\tEach motor driver has an output drive capacity of 35V and 2Amps.\t\t\tCapable of driving motors in full, half, quarter, eight, and sixteenth-step modes.\t\t\tPower input(barrel jack)needs to be less than 30V and supply enough current for your specific stepper motors.\t\t\tJumper(labeled '5V')controls power to the motor drivers, logic levels, and VOUT pin, selectable 3.3\/5V.\t\t\tBus header allows you to control all four motors with only 6 IO pins by controlling the enable(EN pins)for each motor\t\t\t2.1mm, center positive barrel jack\tDocuments: \t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet(A4983SETTR-T)",
			"image":"core\/breadboard\/quadstep-v12_breadboard.svg",
			"icon":"core\/breadboard\/quadstep-v12_breadboard.svg",
			"width":"165.373",
			"height":"187.2",
			"points": [[63.80281, 7.50961, 6.58078, 6.58078], [52.87361, 7.50961, 6.58078, 6.58078], [43.78681, 7.50961, 6.58078, 6.58078], [32.85761, 7.50961, 6.58078, 6.58078], [144.321, 86.948, 6.104, 6.104], [137.121, 86.948, 6.104, 6.104], [137.121, 94.148, 6.104, 6.104], [144.321, 94.148, 6.104, 6.104], [31.97881, 173.10961, 6.58078, 6.58078], [42.90811, 173.10961, 6.58078, 6.58078], [51.92281, 173.10961, 6.58078, 6.58078], [62.85211, 173.10961, 6.58078, 6.58078], [76.83481, 173.10961, 6.58078, 6.58078], [87.76441, 173.10961, 6.58078, 6.58078], [96.77861, 173.10961, 6.58078, 6.58078], [107.70861, 173.10961, 6.58078, 6.58078], [108.58661, 7.50961, 6.58078, 6.58078], [97.65761, 7.50961, 6.58078, 6.58078], [88.64281, 7.50961, 6.58078, 6.58078], [77.71391, 7.50961, 6.58078, 6.58078], [137.121, 79.748, 6.104, 6.104], [137.121, 72.548, 6.104, 6.104], [137.121, 65.348, 6.104, 6.104], [137.121, 58.148, 6.104, 6.104], [137.121, 50.948, 6.104, 6.104], [137.121, 43.748, 6.104, 6.104], [137.121, 36.548, 6.104, 6.104], [137.121, 29.348, 6.104, 6.104], [137.121, 101.348, 6.104, 6.104], [137.121, 108.548, 6.104, 6.104], [137.121, 115.748, 6.104, 6.104], [137.121, 122.948, 6.104, 6.104], [137.121, 130.148, 6.104, 6.104], [137.121, 137.348, 6.104, 6.104], [137.121, 144.548, 6.104, 6.104], [137.121, 151.748, 6.104, 6.104], [144.321, 101.348, 6.104, 6.104], [144.321, 108.548, 6.104, 6.104], [144.321, 115.748, 6.104, 6.104], [144.321, 122.948, 6.104, 6.104], [144.321, 130.148, 6.104, 6.104], [144.321, 137.348, 6.104, 6.104], [144.321, 144.548, 6.104, 6.104], [144.321, 151.748, 6.104, 6.104], [144.321, 79.748, 6.104, 6.104], [144.321, 72.548, 6.104, 6.104], [144.321, 65.348, 6.104, 6.104], [144.321, 58.148, 6.104, 6.104], [144.321, 50.948, 6.104, 6.104], [144.321, 43.748, 6.104, 6.104], [144.321, 36.548, 6.104, 6.104], [144.321, 29.348, 6.104, 6.104], [158.721, 115.748, 6.104, 6.104], [158.721, 108.548, 6.104, 6.104], [158.721, 101.348, 6.104, 6.104], [158.721, 94.148, 6.104, 6.104], [158.721, 86.948, 6.104, 6.104], [158.721, 79.748, 6.104, 6.104], [158.721, 72.548, 6.104, 6.104], [158.721, 65.348, 6.104, 6.104]]
		}, {
			"name":"Header 6",
			"description":"Header 6Standard 6-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).Molex polarized connector foot print use with SKU: PRT-08094 with associated crimp pins and housings.NOTES ON THE VARIANTS LOCK and LOCK_LONGPADS...This footprint was designed to help hold the alignment of a through-hole component(i.e.6-pin header)while soldering it into place.You may notice that each hole has been shifted either up or down by 0.005 of an inch from it 's more standard position (which is a perfectly straight line). This slight alteration caused the pins (the squares in the middle) to touch the edges of the holes. Because they are alternating, it causes a brace to hold the component in place. 0.005 has proven to be the perfect amount of off-center position when using our standard breakaway headers.Although looks a little odd when you look at the bare footprint, once you have a header in there, the alteration is very hard to notice. Also,if you push a header all the way into place, it is covered up entirely on the bottom side. This idea of altering the position of holes to aid alignment will be further integrated into the Sparkfun Library for other footprints. It can help hold any component with 3 or more connection pins.",
			"image":"core\/breadboard\/sparkfun-connectors_molex-1x6-ra_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_molex-1x6-ra_breadboard.svg",
			"width":"15.367",
			"height":"8.6233",
			"points": [[-0.3904, 5.9596, 3.4478, 3.4478], [2.1496, 5.9596, 3.4478, 3.4478], [4.6896, 5.9596, 3.4478, 3.4478], [7.2296, 5.9596, 3.4478, 3.4478], [9.7696, 5.9596, 3.4478, 3.4478], [12.3096, 5.9596, 3.4478, 3.4478]]
		}, {
			"name":"SIMHOLDER3",
			"description":"Alternate SIM card socket",
			"image":"core\/breadboard\/sparkfun-connectors_simholder3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_simholder3_breadboard.svg",
			"width":"1369.29",
			"height":"1000",
			"points": [[567.68, 933.05, 33.93, 33.9], [567.68, 33.05, 33.93, 33.9], [667.68, 933.05, 33.93, 33.9], [667.68, 33.05, 33.93, 33.9], [767.68, 933.05, 33.93, 33.9], [767.68, 33.05, 33.93, 33.9]]
		}, {
			"name":"LEDs",
			"description":"LEDsStandard schematic elements and footprints for 5mm, 3mm, 1206, and 0603 sized LEDs. 5mm-Spark Fun Electronics SKU : COM-00529 (and others)",
			"image":"core\/breadboard\/sparkfun-led_led10mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_led10mm_breadboard.svg",
			"width":"28.348",
			"height":"68.336",
			"points": [[9.104, 65.822, 4.152, 2.722], [16.303, 65.822, 4.154, 2.722]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206. Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_0805_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_0805_breadboard.svg",
			"width":"302.375",
			"height":"400",
			"points": [[134.222, 333.05, 33.93, 33.9], [134.222, 33.05, 33.93, 33.9]]
		}, {
			"name":"Diode",
			"description":"DiodeThese are standard reverse protection diodes and small signal diodes. SMA package can handle up to about 1A. SOD-323 can handle about 200mA. What the SOD-323 package when ordering, there are some mfgs out there that are 5-pin packages.",
			"image":"core\/breadboard\/sparkfun-discretesemi_sma-diode_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sma-diode_breadboard.svg",
			"width":"419.292",
			"height":"400",
			"points": [[192.681, 333.05, 33.93, 33.9], [192.681, 33.05, 33.93, 33.9]]
		}, {
			"name":"Diode",
			"description":"DiodeThese are standard reverse protection diodes and small signal diodes. SMA package can handle up to about 1A. SOD-323 can handle about 200mA. What the SOD-323 package when ordering, there are some mfgs out there that are 5-pin packages.",
			"image":"core\/breadboard\/sparkfun-discretesemi_smb-diode_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_smb-diode_breadboard.svg",
			"width":"419.292",
			"height":"400",
			"points": [[192.681, 333.05, 33.93, 33.9], [192.681, 33.05, 33.93, 33.9]]
		}, {
			"name":"F25",
			"description":"25 Pin male connector. PCB edge mount for regular PCB thicknesses. This connector will connect directly to the back of a PC parallel port or through a normal DB25 extension cable (M\/F). SKU: PRT-08287",
			"image":"core\/breadboard\/sparkfun-connectors_f25vb_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_f25vb_breadboard.svg",
			"width":"2300.46",
			"height":"600",
			"points": [[533.265, 533.05, 33.93, 33.9], [633.265, 533.05, 33.93, 33.9], [633.265, 33.05, 33.93, 33.9], [733.265, 533.05, 33.93, 33.9], [733.265, 33.05, 33.93, 33.9], [833.265, 533.05, 33.93, 33.9], [833.265, 33.05, 33.93, 33.9], [933.265, 533.05, 33.93, 33.9], [933.265, 33.05, 33.93, 33.9], [1033.26, 533.05, 33.93, 33.9], [1033.26, 33.05, 33.93, 33.9], [1133.26, 533.05, 33.93, 33.9], [1133.26, 33.05, 33.93, 33.9], [1233.26, 533.05, 33.93, 33.9], [1233.26, 33.05, 33.93, 33.9], [1333.26, 533.05, 33.93, 33.9], [1333.26, 33.05, 33.93, 33.9], [1433.26, 533.05, 33.93, 33.9], [1433.26, 33.05, 33.93, 33.9], [1533.27, 533.05, 33.93, 33.9], [1533.27, 33.05, 33.93, 33.9], [1633.27, 533.05, 33.93, 33.9], [1633.27, 33.05, 33.93, 33.9], [1733.27, 533.05, 33.93, 33.9], [1733.27, 33.05, 33.93, 33.9]]
		}, {
			"name":"RFID Reader",
			"description":"Simple RFID reader module with internal antenna",
			"image":"core\/breadboard\/rfid_reader_id12.svg",
			"icon":"core\/breadboard\/rfid_reader_id12.svg",
			"width":"57.193",
			"height":"66.686",
			"points": [[36.558637395628, 62.338287844888, 4.1145155119722, 5.0110479021626]]
		}, {
			"name":"DOSonCHIP IC",
			"description":"DOSonCHIP ICThis is the tested schematic and footprint for the DOSonCHIP FAT16 FAT32 IC. Spark Fun Electronics SKU : COM-07956. QFN package also tested\/proven.",
			"image":"core\/breadboard\/QFN-24_breadboard.svg",
			"icon":"core\/breadboard\/QFN-24_breadboard.svg",
			"width":"86.4",
			"height":"28.8",
			"points": [[1.45052, 23.0516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 23.0516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 23.0516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 23.0516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 23.0516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 23.0516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 23.0516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 23.0516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 23.0516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 23.0516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 23.0516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 23.0516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"MPL3115A2",
			"description":"Altimeter\/Pressure Sensor, I2C, 1.95V-3.6V supply, 50 to 110kPa",
			"image":"core\/breadboard\/sparkfun-sensors_lga8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga8_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"HEF4094",
			"description":"(Identical part HCF4094)The HEF4094 is an 8-stage serial shift register. It has a storage latch associated with each stage for strobing data from the serial input to parallel buffered 3-state outputs. The parallel outputs may be connected directly to common bus lines. Data is shifted on positive-going clock transitions. The data in each shift register stage is transferred to the storage register when the strobe input is HIGH. Data in the storage register appears at the outputs whenever the output enable signal is HIGH.Two serial outputs are available for cascading a number of HEF4094 devices. Serial data is available at QS on positive-going clock edges to allow high-speed operation in cascaded systems with a fast clock rise time. The same serial data is available at Q' S on the next negative going clock edge.This is used for cascading HEF4094 devices when the clock has a slow rise time.It operates over a recommended VDD power supply range of 3 V to 15 V referenced to VSS(usually ground).Unused inputs must be connected to VDD, VSS, or another input.",
			"image":"core\/breadboard\/HEF4094228f.svg",
			"icon":"core\/breadboard\/HEF4094228f.svg",
			"width":"57.6",
			"height":"23.76",
			"points": [[1.52, 19.636, 4.16, 5.124], [8.72, 19.636, 4.16, 5.124], [15.92, 19.636, 4.159, 5.124], [23.119, 19.636, 4.16, 5.124], [30.319, 19.636, 4.16, 5.124], [37.521, 19.636, 4.159, 5.124], [44.719, 19.636, 4.16, 5.124], [51.919, 19.636, 4.16, 5.124], [51.919, -1, 4.16, 5.125], [37.521, -1, 4.159, 5.125], [30.319, -1, 4.16, 5.125], [23.119, -1, 4.16, 5.125], [15.92, -1, 4.159, 5.125], [8.5105454545455, -1, 4.16, 5.125], [1.52, -1.1047272727273, 4.16, 5.125], [1.52, -1.1047272727273, 4.16, 5.125], [44.719, -1.1047272727273, 4.16, 5.125], [44.719, -1.1047272727273, 4.16, 5.125], [44.719, -1.1047272727273, 4.16, 5.125], [44.719, -1.1047272727273, 4.16, 5.125], [44.719, -1.1047272727273, 4.16, 5.125]]
		}, {
			"name":"V_REG_TPS61040",
			"description":"",
			"image":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"SOIC-14",
			"description":"",
			"image":"core\/breadboard\/SOIC-14_breadboard.svg",
			"icon":"core\/breadboard\/SOIC-14_breadboard.svg",
			"width":"50.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"F25",
			"description":"25 Pin male connector.PCB edge mount for regular PCB thicknesses.This connector will connect directly to the back of a PC parallel port or through a normal DB25 extension cable(M\/F).SKU: PRT-08287",
			"image":"core\/breadboard\/sparkfun-connectors_f25vp_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_f25vp_breadboard.svg",
			"width":"2300.46",
			"height":"600",
			"points": [[483.265, 533.05, 33.93, 33.9], [583.265, 533.05, 33.93, 33.9], [583.265, 33.05, 33.93, 33.9], [683.265, 533.05, 33.93, 33.9], [683.265, 33.05, 33.93, 33.9], [783.265, 533.05, 33.93, 33.9], [783.265, 33.05, 33.93, 33.9], [883.265, 533.05, 33.93, 33.9], [883.265, 33.05, 33.93, 33.9], [983.265, 533.05, 33.93, 33.9], [983.265, 33.05, 33.93, 33.9], [1083.26, 533.05, 33.93, 33.9], [1083.26, 33.05, 33.93, 33.9], [1183.26, 533.05, 33.93, 33.9], [1183.26, 33.05, 33.93, 33.9], [1283.26, 533.05, 33.93, 33.9], [1283.26, 33.05, 33.93, 33.9], [1383.26, 533.05, 33.93, 33.9], [1383.26, 33.05, 33.93, 33.9], [1483.27, 533.05, 33.93, 33.9], [1483.27, 33.05, 33.93, 33.9], [1583.27, 533.05, 33.93, 33.9], [1583.27, 33.05, 33.93, 33.9], [1683.27, 533.05, 33.93, 33.9], [1683.27, 33.05, 33.93, 33.9], [1783.27, 533.05, 33.93, 33.9], [1783.27, 33.05, 33.93, 33.9]]
		}, {
			"name":"LilyPad Temperature Sensor",
			"description":"Detecting temperature changes has never been easier.The MCP9700 is a small thermistor type temperature sensor.This sensor will output 0.5V at 0 degrees C, 0.75V at 25 C, and 10mV per degree C.Doing an analog to digital conversion on the signal line will allow you to establish the local ambient temperature.Detect physical touch based on body heat and ambient conditions with this small sensor.LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They 're even washable!Note: A portion of this sale is given back to Dr. Leah Buechley for continued development and education of e-textiles.Dimensions:20mm outer diameterThin 0.8mm PCB",
			"image":"core\/breadboard\/LilyPad-Temp-v12_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad-Temp-v12_breadboard.svg",
			"width":"56.693",
			"height":"56.693",
			"points": [[6.233, 35.714, 6.808, 6.808], [24.942, 3.399, 6.808, 6.808], [43.651, 35.714, 6.808, 6.808]]
		}, {
			"name":"Header 6",
			"description":"Header 6Standard 6-pin 0.1 header. Use with straight break away headers (SKU : PRT-00116), right angle break away headers (PRT-00553), swiss pins (PRT-00743), machine pins (PRT-00117), and female headers (PRT-00115). Molex polarized connector foot print use with SKU : PRT-08094 with associated crimp pins and housings.NOTES ON THE VARIANTS LOCK and LOCK_LONGPADS...This footprint was designed to help hold the alignment of a through-hole component (i.e. 6-pin header) while soldering it into place. You may notice that each hole has been shifted either up or down by 0.005 of an inch from it' s more standard position(which is a perfectly straight line).This slight alteration caused the pins(the squares in the middle)to touch the edges of the holes.Because they are alternating, it causes a brace to hold the component in place.0.005 has proven to be the perfect amount of off-center position when using our standard breakaway headers.Although looks a little odd when you look at the bare footprint, once you have a header in there, the alteration is very hard to notice.Also, if you push a header all the way into place, it is covered up entirely on the bottom side.This idea of altering the position of holes to aid alignment will be further integrated into the Sparkfun Library for other footprints.It can help hold any component with 3 or more connection pins.",
			"image":"core\/breadboard\/sparkfun-connectors_em406_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_em406_breadboard.svg",
			"width":"529.75",
			"height":"600",
			"points": [[97.91, 533.05, 33.93, 33.9], [97.91, 33.05, 33.93, 33.9], [197.91, 533.05, 33.93, 33.9], [197.91, 33.05, 33.93, 33.9], [297.91, 533.05, 33.93, 33.9], [297.91, 33.05, 33.93, 33.9], [397.91, 533.05, 33.93, 33.9], [397.91, 33.05, 33.93, 33.9]]
		}, {
			"name":"74HC4052",
			"description":"Dual 4: 1 analog mux",
			"image":"core\/breadboard\/SO16_breadboard.svg",
			"icon":"core\/breadboard\/SO16_breadboard.svg",
			"width":"57.6",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"AD725",
			"description":"RGB component to NTSC\/PAL Encoder",
			"image":"core\/breadboard\/sparkfun-analogic_so16l_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_so16l_breadboard.svg",
			"width":"800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Package:",
			"description":"L3G4200D Three-axis, digital output gyroscopeThe L3G4200D is a low-power three-axis angular rate sensor, has a full scale of \ u00b1250\/ \ u00b1500\/ \ u00b12000 dps and is capable of measuring rates with a user-selectable bandwidth.It includes a sensing element and an IC interface capable of providing the measured angular rate to the external world through a digital interface(I2C\/SPI).Package: 4x4x1.1 LGA-16(LGA16-4x4.PAC)",
			"image":"core\/breadboard\/sparkfun-sensors_lga16-4x4_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga16-4x4_breadboard.svg",
			"width":"800",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"white smd LED",
			"description":"A generic white LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-white.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-white.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"STARBOARD_GND",
			"description":"StarBoard ground PadStarboard pads sans the star cutout in top layer",
			"image":"core\/breadboard\/sparkfun-connectors_starboard_ground_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_starboard_ground_breadboard.svg",
			"width":"458",
			"height":"1400",
			"points": [[212.035, 1333.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Intel Galileo Shield\/2 PCB",
			"description":"Plain half PCB Shaped to fit an Arduino Intel Galileo \"Shield \"",
			"image":"core\/icon\/plain_pcb.svg",
			"icon":"core\/icon\/plain_pcb.svg",
			"width": 0,
			"height": 0,
			"points": []
		}, {
			"name":"TRANSISTOR_NPN",
			"description":"Generic NPN BJT.MMBT2222 is the common NPN we use.Double check against datasheet-not all devices are the same!",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot23_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot23_breadboard.svg",
			"width":"259",
			"height":"400",
			"points": [[62.535, 333.05, 33.93, 33.9], [162.535, 333.05, 33.93, 33.9], [162.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"Rotary Potentiometer(Small)",
			"description":"A rotary adjustable resistor(potentiometer).",
			"image":"obsolete\/breadboard\/pot-small.svg",
			"icon":"obsolete\/breadboard\/pot-small.svg",
			"width":"19.145",
			"height":"40.625",
			"points": [[0.317, 37.39, 4.152, 4.235], [7.517, 37.39, 4.153, 4.235], [14.723, 37.39, 4.152, 4.235]]
		}, {
			"name":"Header 1",
			"description":"Header 1Standard 1-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).",
			"image":"core\/breadboard\/sparkfun-connectors_luxeon-pad_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_luxeon-pad_breadboard.svg",
			"width":"353.543",
			"height":"400",
			"points": [[159.807, 333.05, 33.93, 33.9]]
		}, {
			"name":"24LC256",
			"description":"24LC256 I2C EEPROM",
			"image":"core\/breadboard\/24LC256_breadboard.svg",
			"icon":"core\/breadboard\/24LC256_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"INVERTER",
			"description":"Single inverter, SOT23-5",
			"image":"core\/breadboard\/sparkfun-digitalic_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"DIP-Relay-D31A",
			"description":"Dip-Relay",
			"image":"core\/breadboard\/DIP_Relay_D31A_breadboard.svg",
			"icon":"core\/breadboard\/DIP_Relay_D31A_breadboard.svg",
			"width": 0,
			"height": 0,
			"points": [[47, 25, 5, 5], [56, 24, 4, 7], [56, -1, 4, 6], [47, -1, 4, 6], [11, -1, 4, 6], [2, 24, 5, 6], [2, -1, 5, 6], [11, 25, 5, 5]]
		}
	]
}, {
	"page":"11",
	"count": 37,
	"el": [{
			"name":"FT232RQ",
			"description":"USB to USART.Non-stock item, unproven FP for this part.",
			"image":"core\/breadboard\/QFN-32_breadboard.svg",
			"icon":"core\/breadboard\/QFN-32_breadboard.svg",
			"width":"115.2",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"BUTTONPAD-2X2",
			"description":"Proven layout and schematic for 2x2 button pad.Panelize this device\/fp to a 4x4 pad if needed.Spark Fun Electronics SKU: COM-07835.Compatible common cathode tri-color LED SKU: COM-00105",
			"image":"core\/breadboard\/sparkfun-electromechanical_buttonpad-2x2-special_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buttonpad-2x2-special_breadboard.svg",
			"width":"2188.42",
			"height":"2400",
			"points": [[527.245, 2333.05, 33.93, 33.9], [527.245, 33.05, 33.93, 33.9], [627.245, 2333.05, 33.93, 33.9], [627.245, 33.05, 33.93, 33.9], [727.245, 2333.05, 33.93, 33.9], [727.245, 33.05, 33.93, 33.9], [827.245, 2333.05, 33.93, 33.9], [827.245, 33.05, 33.93, 33.9], [927.245, 2333.05, 33.93, 33.9], [927.245, 33.05, 33.93, 33.9], [1027.24, 2333.05, 33.93, 33.9], [1027.24, 33.05, 33.93, 33.9], [1127.24, 2333.05, 33.93, 33.9], [1127.24, 33.05, 33.93, 33.9], [1227.24, 2333.05, 33.93, 33.9], [1227.24, 33.05, 33.93, 33.9], [1327.24, 2333.05, 33.93, 33.9], [1327.24, 33.05, 33.93, 33.9], [1427.24, 2333.05, 33.93, 33.9], [1427.24, 33.05, 33.93, 33.9], [1527.25, 2333.05, 33.93, 33.9], [1527.25, 33.05, 33.93, 33.9], [1627.25, 2333.05, 33.93, 33.9], [1627.25, 33.05, 33.93, 33.9]]
		}, {
			"name":"Screw terminal-2 pins",
			"description":"Screw terminal with 2 pins",
			"image":"core\/breadboard\/screw_terminal_2_100mil_bread.svg",
			"icon":"core\/breadboard\/screw_terminal_2_100mil_bread.svg",
			"width":"200",
			"height":"170",
			"points": [[33.2884, 108.874, 33.5235, 62.0844], [133.2884, 108.874, 33.5235, 62.0844]]
		}, {
			"name":"DC-DC_CONVERTER",
			"description":"APTS006A0X-SRZ Step-down 6A variable voltage switching module(TOL-09275)",
			"image":"core\/breadboard\/sparkfun-poweric_dc-dc_converter_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_dc-dc_converter_breadboard.svg",
			"width":"500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic male header-14 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_14.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_14.svg",
			"width":"100.786",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791], [37.199, 1.204, 4.791, 4.791], [44.398, 1.204, 4.791, 4.791], [51.597, 1.204, 4.791, 4.791], [58.796, 1.204, 4.791, 4.791], [65.995, 1.204, 4.791, 4.791], [73.194, 1.204, 4.791, 4.791], [80.393, 1.204, 4.791, 4.791], [87.592, 1.204, 4.791, 4.791], [94.791, 1.204, 4.791, 4.791]]
		}, {
			"name":"SO-24W",
			"description":"",
			"image":"core\/breadboard\/SO-24W_breadboard.svg",
			"icon":"core\/breadboard\/SO-24W_breadboard.svg",
			"width":"86.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Arduino Esplora(Rev4)",
			"description":"The Arduino Esplora is a microcontroller board derived from the Arduino Leonardo.The Esplora differs from all preceding Arduino boards in that it provides a number of built-in, ready-to-use setof onboard sensors for interaction.It 's designed for people who want to get up and running with Arduino without having to learn about the electronics first. For a step-by-step introduction to the Esplora, check out the Getting Started with Esplora guide.The Esplora has onboard sound and light outputs, and several input sensors, including a joystick, a slider, a temperature sensor, an accelerometer, a microphone, and a light sensor. It also has the potential to expand its capabilities with two Tinkerkit input and output connectors, and a socket for a color TFT LCD screen.Like the Leonardo board, the Esplora uses an Atmega32U4 AVR microcontroller with 16 MHz crystal oscillator and a micro USB connection capable of acting as a USB client device, like a mouse or a keyboard.In the upper left corner of the board there is a reset pushbutton, that you can use to restart the board. There are four status LEDS : ON [green] indicates whether the board is receiving power supply L [yellow] connected directly to the microcontroller, accessible through pin 13 RX and TX [yellow] indicates the data being transmitted or received over the USB communication The board contains everything needed to support the microcontroller; simply connect it to a computer with a USB cable to get started.The Esplora has built-in USB communication; it can appear to a connected computer as a mouse or keyboard, in addition to a virtual (CDC) serial \/ COM port. This has other implications for the behavior of the board; these are detailed on the getting started page.",
			"image":"core\/breadboard\/Arduino_Esplora_breadboard.svg",
			"icon":"core\/breadboard\/Arduino_Esplora_breadboard.svg",
			"width":"464.93",
			"height":"199.055",
			"points": [[305.431, 68.116, 5.554, 5.554], [305.431, 75.316, 5.554, 5.554], [305.43, 82.515, 5.556, 5.556], [305.431, 89.716, 5.554, 5.554], [305.431, 96.917, 5.554, 5.554], [305.431, 104.117, 5.554, 5.554], [305.431, 111.316, 5.554, 5.554], [305.432, 118.516, 5.552, 5.552], [305.431, 125.716, 5.554, 5.554], [305.431, 132.915, 5.554, 5.554], [154.231, 68.116, 5.554, 5.554], [154.231, 75.316, 5.554, 5.554], [154.23, 82.515, 5.556, 5.556], [154.231, 89.716, 5.554, 5.554], [154.231, 96.917, 5.554, 5.554], [154.231, 104.117, 5.554, 5.554], [154.231, 111.316, 5.554, 5.554], [154.232, 118.516, 5.552, 5.552], [154.231, 125.716, 5.554, 5.554], [154.231, 132.915, 5.554, 5.554], [273.189, -8.7399, 6, 6], [265.992, -15.9369, 6, 6], [258.803, -23.1259, 6, 6], [303.43, -8.7389, 6, 6], [296.232, -15.9369, 6, 6], [289.042, -23.1269, 6, 6], [175.063, -8.7389, 6, 6], [167.865, -15.9369, 6, 6], [160.675, -23.1269, 6, 6], [205.303, -8.7389, 6, 6], [198.105, -15.9369, 6, 6], [190.915, -23.1269, 6, 6]]
		}, {
			"name":"ULN2803A",
			"description":"ULN2803A 8-way Darlington Transistor Driver",
			"image":"core\/breadboard\/ULN2803A_breadboard.svg",
			"icon":"core\/breadboard\/ULN2803A_breadboard.svg",
			"width":"900",
			"height":"330",
			"points": [[34, 285.6, 32, 45.4], [34, -1, 32, 45.4], [834, 285.6, 32, 45.4], [834, -1, 32, 45.4], [134, 285.6, 32, 45.4], [134, -1, 32, 45.4], [234, 285.6, 32, 45.4], [234, -1, 32, 45.4], [334, 285.6, 32, 45.4], [334, -1, 32, 45.4], [434, 285.6, 32, 45.4], [434, -1, 32, 45.4], [534, 285.6, 32, 45.4], [534, -1, 32, 45.4], [634, 285.6, 32, 45.4], [634, -1, 32, 45.4], [734, 285.6, 32, 45.4], [734, -1, 32, 45.4]]
		}, {
			"name":"47 \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_47.svg",
			"icon":"obsolete\/breadboard\/resistor_47.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Single-Chip USB to UART Bridge",
			"description":"Single-Chip USB to UART BridgeSource: www.silabs.com .. CP2103.pdf. Spark Fun Electronics SKU : COM-00309",
			"image":"core\/breadboard\/sparkfun-digitalic_mlp28_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_mlp28_breadboard.svg",
			"width":"1500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"47 \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_47.svg",
			"icon":"obsolete\/breadboard\/resistor_47.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Electrolytic Capacitor",
			"description":"1000\u00b5F electrolytic capacitor",
			"image":"core\/breadboard\/electrolytic_capacitor_1000uF_35v_leg.svg",
			"icon":"core\/breadboard\/electrolytic_capacitor_1000uF_35v_leg.svg",
			"width":"51.183",
			"height":"98.261",
			"points": [[28.139, 92.261, 5, 3], [18.139, 92.261, 5, 3]]
		}, {
			"name":"Header 2",
			"description":"Header 2Standard 2-pin 0.1 header. Use with straight break away headers (SKU : PRT-00116), right angle break away headers (PRT-00553), swiss pins (PRT-00743), machine pins (PRT-00117), and female headers (PRT-00115). Molex polarized connector foot print use with SKU : PRT-08233 with associated crimp pins and housings.",
			"image":"core\/breadboard\/sparkfun-connectors_r_sw_th_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_r_sw_th_breadboard.svg",
			"width":"928.583",
			"height":"1000",
			"points": [[397.327, 933.05, 33.93, 33.9], [397.327, 33.05, 33.93, 33.9], [497.327, 933.05, 33.93, 33.9], [497.327, 33.05, 33.93, 33.9]]
		}, {
			"name":"MAGJACK-POE",
			"description":"PoE compatible MagJack",
			"image":"core\/breadboard\/sparkfun-connectors_magjack-poe_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_magjack-poe_breadboard.svg",
			"width":"841.236",
			"height":"1000",
			"points": [[53.653, 933.05, 33.93, 33.9], [53.653, 33.05, 33.93, 33.9], [153.653, 933.05, 33.93, 33.9], [153.653, 33.05, 33.93, 33.9], [253.653, 933.05, 33.93, 33.9], [253.653, 33.05, 33.93, 33.9], [353.653, 933.05, 33.93, 33.9], [353.653, 33.05, 33.93, 33.9], [453.653, 933.05, 33.93, 33.9], [453.653, 33.05, 33.93, 33.9], [553.653, 933.05, 33.93, 33.9], [553.653, 33.05, 33.93, 33.9], [653.653, 933.05, 33.93, 33.9], [653.653, 33.05, 33.93, 33.9], [753.653, 933.05, 33.93, 33.9], [753.653, 33.05, 33.93, 33.9]]
		}, {
			"name":"Mystery Part-18 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want. With 18 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part18.svg",
			"icon":"obsolete\/breadboard\/mystery_part18.svg",
			"width":"182",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002], [52.5, 24.672941, 5, 6.3400002], [62.5, 24.672941, 5, 6.3400002], [72.5, 24.672941, 5, 6.3400002], [82.5, 24.672941, 5, 6.3400002], [92.5, 24.672941, 5, 6.3400002], [102.5, 24.672941, 5, 6.3400002], [112.5, 24.672941, 5, 6.3400002], [122.5, 24.672941, 5, 6.3400002], [132.5, 24.672941, 5, 6.3400002], [142.5, 24.672941, 5, 6.3400002], [152.5, 24.672941, 5, 6.3400002], [162.5, 24.672941, 5, 6.3400002], [172.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"ADM1087",
			"description":"The ADM1085-ADM1088 are Simple Sequencing\u2122 circuits which provide a time delay between the enabling of voltage regulators at power-up in multiple supply systems. When the output voltage of the first regulator reaches a preset threshold, a time delay is initiated before an enable signal allows subsequent regulators to power-up. Any number of these devices can be cascaded with regulators to allow sequencing of multiple power supplies.",
			"image":"core\/breadboard\/sparkfun-poweric_sc-70_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_sc-70_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"pinocc.io protoboard",
			"description":"Get building with external sensors and displays! Plug them in or solder them on to create swappable hardware interfaces.",
			"image":"core\/breadboard\/pinoccio-proto_breadboard.svg",
			"icon":"core\/breadboard\/pinoccio-proto_breadboard.svg",
			"width":"72",
			"height":"122.4",
			"points": [[2.24, 29.96, 4.88, 4.88], [2.24, 35.63, 4.88, 4.88], [2.24, 41.299, 4.88, 4.88], [2.24, 46.967, 4.88, 4.88], [2.24, 52.637, 4.88, 4.88], [2.24, 58.306, 4.88, 4.88], [2.24, 63.976, 4.88, 4.88], [2.24, 69.645, 4.88, 4.88], [2.24, 75.314, 4.88, 4.88], [2.24, 80.984, 4.88, 4.88], [2.24, 86.653, 4.88, 4.88], [2.24, 92.322, 4.88, 4.88], [2.24, 97.991, 4.88, 4.88], [2.24, 103.661, 4.88, 4.88], [2.24, 109.33, 4.88, 4.88], [2.24, 114.999, 4.88, 4.88], [64.88, 29.96, 4.88, 4.88], [64.88, 35.63, 4.88, 4.88], [64.88, 41.299, 4.88, 4.88], [64.88, 46.967, 4.88, 4.88], [64.88, 52.637, 4.88, 4.88], [64.88, 58.306, 4.88, 4.88], [64.88, 63.976, 4.88, 4.88], [64.88, 69.645, 4.88, 4.88], [64.88, 75.314, 4.88, 4.88], [64.88, 80.984, 4.88, 4.88], [64.88, 86.653, 4.88, 4.88], [64.88, 92.322, 4.88, 4.88], [64.88, 97.991, 4.88, 4.88], [64.88, 103.661, 4.88, 4.88], [64.88, 109.33, 4.88, 4.88], [64.88, 114.999, 4.88, 4.88], [4.148, 8.684, 6.104, 6.104], [4.148, 15.884, 6.104, 6.104], [4.148, 23.084, 6.104, 6.104], [61.748, 8.684, 6.104, 6.104], [61.748, 15.884, 6.104, 6.104], [61.748, 23.084, 6.104, 6.104], [18.548, 109.484, 6.104, 6.104], [25.748, 109.484, 6.104, 6.104], [32.948, 109.484, 6.104, 6.104], [40.148, 109.484, 6.104, 6.104], [47.348, 109.484, 6.104, 6.104], [18.548, 102.284, 6.104, 6.104], [25.748, 102.284, 6.104, 6.104], [32.948, 102.284, 6.104, 6.104], [40.148, 102.284, 6.104, 6.104], [47.348, 102.284, 6.104, 6.104], [18.548, 95.084, 6.104, 6.104], [25.748, 95.084, 6.104, 6.104], [32.948, 95.084, 6.104, 6.104], [40.148, 95.084, 6.104, 6.104], [47.348, 95.084, 6.104, 6.104], [18.548, 87.884, 6.104, 6.104], [25.748, 87.884, 6.104, 6.104], [32.948, 87.884, 6.104, 6.104], [40.148, 87.884, 6.104, 6.104], [47.348, 87.884, 6.104, 6.104], [18.548, 80.684, 6.104, 6.104], [25.748, 80.684, 6.104, 6.104], [32.948, 80.684, 6.104, 6.104], [40.148, 80.684, 6.104, 6.104], [47.348, 80.684, 6.104, 6.104], [18.548, 73.484, 6.104, 6.104], [25.748, 73.484, 6.104, 6.104], [32.948, 73.484, 6.104, 6.104], [40.148, 73.484, 6.104, 6.104], [47.348, 73.484, 6.104, 6.104], [18.548, 66.284, 6.104, 6.104], [25.748, 66.284, 6.104, 6.104], [32.948, 66.284, 6.104, 6.104], [40.148, 66.284, 6.104, 6.104], [47.348, 66.284, 6.104, 6.104], [18.548, 59.084, 6.104, 6.104], [25.748, 59.084, 6.104, 6.104], [32.948, 59.084, 6.104, 6.104], [40.148, 59.084, 6.104, 6.104], [47.348, 59.084, 6.104, 6.104], [18.548, 51.884, 6.104, 6.104], [25.748, 51.884, 6.104, 6.104], [32.948, 51.884, 6.104, 6.104], [40.148, 51.884, 6.104, 6.104], [47.348, 51.884, 6.104, 6.104], [18.548, 44.684, 6.104, 6.104], [25.748, 44.684, 6.104, 6.104], [32.948, 44.684, 6.104, 6.104], [40.148, 44.684, 6.104, 6.104], [47.348, 44.684, 6.104, 6.104], [18.548, 37.484, 6.104, 6.104], [25.748, 37.484, 6.104, 6.104], [32.948, 37.484, 6.104, 6.104], [40.148, 37.484, 6.104, 6.104], [47.348, 37.484, 6.104, 6.104], [18.548, 30.284, 6.104, 6.104], [25.748, 30.284, 6.104, 6.104], [32.948, 30.284, 6.104, 6.104], [40.148, 30.284, 6.104, 6.104], [47.348, 30.284, 6.104, 6.104], [18.548, 23.084, 6.104, 6.104], [25.748, 23.084, 6.104, 6.104], [32.948, 23.084, 6.104, 6.104], [40.148, 23.084, 6.104, 6.104], [47.348, 23.084, 6.104, 6.104], [54.548, 23.084, 6.104, 6.104], [11.348, 23.084, 6.104, 6.104], [18.548, 15.884, 6.104, 6.104], [25.748, 15.884, 6.104, 6.104], [32.948, 15.884, 6.104, 6.104], [40.148, 15.884, 6.104, 6.104], [47.348, 15.884, 6.104, 6.104], [54.548, 15.884, 6.104, 6.104], [11.348, 15.884, 6.104, 6.104], [18.548, 8.684, 6.104, 6.104], [25.748, 8.684, 6.104, 6.104], [32.948, 8.684, 6.104, 6.104], [40.148, 8.684, 6.104, 6.104], [47.348, 8.684, 6.104, 6.104], [54.548, 8.684, 6.104, 6.104], [11.348, 8.684, 6.104, 6.104], [18.548, 1.484, 6.104, 6.104], [25.748, 1.484, 6.104, 6.104], [32.948, 1.484, 6.104, 6.104], [40.148, 1.484, 6.104, 6.104], [47.348, 1.484, 6.104, 6.104], [54.548, 1.484, 6.104, 6.104], [61.748, 1.484, 6.104, 6.104], [4.148, 1.484, 6.104, 6.104], [11.348, 1.484, 6.104, 6.104]]
		}, {
			"name":"MN5010HS",
			"description":"MN5010HS GPS Receiver Module. Packagse GR-10 and MN5010HS are NOT tested with this device.",
			"image":"core\/breadboard\/sparkfun-rf_mn5010hs_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_mn5010hs_breadboard.svg",
			"width":"1800",
			"height":"800",
			"points": [[33.035, 733.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 733.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 733.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 733.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 733.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 733.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 733.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 733.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 733.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 733.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 733.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 733.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 733.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 733.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 733.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 733.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 733.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 733.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"GAS_SENSOR",
			"description":"MQ-3 alcohol gas sensor . FP not tested. SEN-08880.",
			"image":"core\/breadboard\/sparkfun-sensors_mq-3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_mq-3_breadboard.svg",
			"width":"861.417",
			"height":"1200",
			"points": [[313.744, 1133.05, 33.93, 33.9], [313.744, 33.05, 33.93, 33.9], [413.744, 1133.05, 33.93, 33.9], [413.744, 33.05, 33.93, 33.9], [513.744, 1133.05, 33.93, 33.9], [513.744, 33.05, 33.93, 33.9]]
		}, {
			"name":"Diode",
			"description":"DiodeThese are standard reverse protection diodes and small signal diodes. SMA package can handle up to about 1A. SOD-323 can handle about 200mA. What the SOD-323 package when ordering, there are some mfgs out there that are 5-pin packages.",
			"image":"core\/breadboard\/sparkfun-discretesemi_sod-323_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sod-323_breadboard.svg",
			"width":"307.694",
			"height":"400",
			"points": [[136.882, 333.05, 33.93, 33.9], [136.882, 33.05, 33.93, 33.9]]
		}, {
			"name":"AD22151-Linear Output Magnetic Field Sensor",
			"description":"",
			"image":"core\/breadboard\/AD22151.svg",
			"icon":"core\/breadboard\/AD22151.svg",
			"width":"28.8",
			"height":"29.786",
			"points": [[0.852, 22.942, 5.5, 5.5], [8.053, 22.944, 5.5, 5.5], [15.251, 22.944, 5.5, 5.5], [22.447, 22.942, 5.5, 5.5], [22.449, 1.344, 5.5, 5.5], [15.25, 1.344, 5.5, 5.5], [8.053, 1.342, 5.5, 5.5], [0.853, 1.341, 5.5, 5.5]]
		}, {
			"name":"white LED-5mm",
			"description":"A generic white LED (~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-white.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-white.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"24LC64",
			"description":"24LC64 I2C EEPROM",
			"image":"core\/breadboard\/24LC64_breadboard.svg",
			"icon":"core\/breadboard\/24LC64_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"640x480 CMOS Color Camera",
			"description":"640x480 CMOS Color CameraFootprint proven. Spark Fun Electronics Camera SKU : SEN-00637, Mating Connector SKU : SEN-00638",
			"image":"core\/breadboard\/sparkfun-sensors_camera_cmos_plug_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_camera_cmos_plug_breadboard.svg",
			"width":"1000",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"SN74LS32N",
			"description":"Quad 2-input positive-OR gates",
			"image":"core\/breadboard\/SN74LS32N_breadboard.svg",
			"icon":"core\/breadboard\/SN74LS32N_breadboard.svg",
			"width":"70",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [62.5, 27.66, 5, 6.3400002], [62.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [42.5, 27.66, 5, 6.3400002], [42.5, -1, 5, 6.3400002], [52.5, 27.66, 5, 6.3400002], [52.5, -1, 5, 6.3400002]]
		}, {
			"name":"ZXLD1360",
			"description":"Adjustable constant current switching driver for high-power LEDs",
			"image":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"LQFP-80",
			"description":"WIZnet W5100TCP\/IP PHY Embedded ChipSee SparkFun catalog # COM-09471Package: LQFP-80,10x10mm, 0.4mm pitch",
			"image":"core\/breadboard\/sparkfun-digitalic_lqfp-80_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_lqfp-80_breadboard.svg",
			"width":"4000",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 533.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9], [3333.03, 533.05, 33.93, 33.9], [3333.03, 33.05, 33.93, 33.9], [3433.03, 533.05, 33.93, 33.9], [3433.03, 33.05, 33.93, 33.9], [3533.03, 533.05, 33.93, 33.9], [3533.03, 33.05, 33.93, 33.9], [3633.03, 533.05, 33.93, 33.9], [3633.03, 33.05, 33.93, 33.9], [3733.03, 533.05, 33.93, 33.9], [3733.03, 33.05, 33.93, 33.9], [3833.03, 533.05, 33.93, 33.9], [3833.03, 33.05, 33.93, 33.9], [3933.03, 533.05, 33.93, 33.9], [3933.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"USB UART",
			"description":"USB UARTThis is the simplified version of the FT232RL unit. Only what you need, nothing you don' t.Spark Fun Electronics SKU: COM-00650",
			"image":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"icon":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"6400BG_HEATSINK",
			"description":"Multiwatt heatsink, PRT-09576",
			"image":"core\/breadboard\/sparkfun-electromechanical_6400bg_heatsink_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_6400bg_heatsink_breadboard.svg",
			"width":"119.52",
			"height":"199.979",
			"points": []
		}, {
			"name":"OpenLog",
			"description":"OpenLog is an open source data logger.Simple to use, simple to change.We wanted to create a serial logger that just worked.Power up this device and it will start logging any received serial data at 9600bps.",
			"image":"core\/breadboard\/OpenLog_breadboard.svg",
			"icon":"core\/breadboard\/OpenLog_breadboard.svg",
			"width":"44.3508",
			"height":"68.3972",
			"points": [[1.12343, 61.7452, 6.104, 6.104], [8.3234, 61.7452, 6.104, 6.104], [15.5234, 61.7452, 6.104, 6.104], [22.7234, 61.7452, 6.104, 6.104], [29.9234, 61.7452, 6.104, 6.104], [37.1234, 61.7452, 6.104, 6.104], [8.3234, 14.9452, 6.104, 6.104], [15.5234, 14.9452, 6.104, 6.104], [22.7234, 14.9452, 6.104, 6.104], [29.9234, 14.9452, 6.104, 6.104]]
		}, {
			"name":"SparkFun-microSD Transflash",
			"description":"https: \/\/www.sparkfun.com\/products\/544Breakout board for the microSD socket that is not much bigger than your fingernail.Compatible with the SPI interface found on any SD card, this tiny form factor was created for cell phone storage and is perfect for your next MP3 project!Board comes fully assembled and tested.The bare socket is available.",
			"image":"core\/breadboard\/sparkfun_storage_microsd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun_storage_microsd_breadboard.svg",
			"width":"77.208654",
			"height":"83.055117",
			"points": [[77.66556, 73.164494, 8.8254032, 8.6537924], [77.62686, 63.786594, 8.8254032, 8.6537924], [77.66557, 54.533464, 8.8254032, 8.6537924], [77.76016, 45.237314, 8.8254032, 8.6537924], [77.64383, 36.086984, 8.8254032, 8.6537924], [77.63368, 26.746397, 8.8254032, 8.6537924], [77.59166, 17.57984, 8.8254032, 8.6537924]]
		}, {
			"name":"RS232 Transceiver",
			"description":"RS232 TransceiverVery common IC.This is generically called 'MAX232', but works with the 3V equivalent MAX3232 generic ICs.Field tested and mother approved.Spark Fun Electronics SKU: COM-00316(DIP)and COM-00589(SMD)",
			"image":"core\/breadboard\/SO16_breadboard.svg",
			"icon":"core\/breadboard\/SO16_breadboard.svg",
			"width":"57.6",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Basic Servo",
			"description":"A generic servo.",
			"image":"core\/breadboard\/servo.svg",
			"icon":"core\/breadboard\/servo.svg",
			"width":"113.976032",
			"height":"91.7024",
			"points": [[99.897032, 72.0194, 3, 3], [100.006032, 69.1964, 3, 3], [99.897032, 66.4134, 3, 3]]
		}, {
			"name":"POT",
			"description":"",
			"image":"core\/breadboard\/sparkfun-electromechanical_3362u_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_3362u_breadboard.svg",
			"width":"22.175",
			"height":"27.27",
			"points": [[0.728, 23.436, 6.104, 6.104], [7.928, 23.436, 6.104, 6.104], [15.128, 23.436, 6.104, 6.104]]
		}, {
			"name":"ArduPilot Mega",
			"description":"The ArduPilot Mega is the newest version of autopilot board designed by Chris Anderson and Jordi Muñoz of DIY Drones.This latest revision uses the ATmega2560 in place of the ATmega1280.\t\tArduPilot Mega is a fully programmable autopilot that requires a GPS module and sensors to create a functioning Unmanned Aerial Vehicle(UAV).The autopilot handles both stabilization and navigation, eliminating the need for a separate stabilization system.It also supports a 'fly-by-wire' mode that can stabilize an aircraft when flying manually under RC control, making it easier and safer to fly.The hardware and software are all open source.The board comes with all the surface-mount parts already soldered, but requires the user to solder on connectors.RC processing firmware is already loaded, but the autopilot software must be downloaded and loaded onto the board by the user.It can be programmed with the Arduino IDE.\t\tWe recommend the following items to accompany this product: \t\t\t\t\t\tuBlox 5 GPS module and adapter\t\t\t\t\tFTDI Basic or FTDI cable for programming\t\tOther necessary elements, including aircraft recommendations, can be found at the project 's home page.\t\t\t\t\tFeatures:\t\t\t\t\t\t\t\t\t\tController designed to be used with autonomous aircraft, car or boat.\t\t\t\t\t\t\tBased on a 16MHz Atmega2560 processor.\t\t\t\t\t\t\tBuilt-in hardware failsafe that uses a separate circuit (multiplexer chip and ATMega328 processor) to transfer control from the RC system to the autopilot and back again. Includes ability to reboot the main processor in mid-flight\t\t\t\t\t\t\tDual-processor design with 32 MIPS of onboard power\t\t\t\t\t\t\tSupports of 3D waypoints and mission commands (limited only by memory)\t\t\t\t\t\t\tComes with a 6-pin GPS connector (EM406 style). \t\t\t\t\t\t\tHas 16 spare analog inputs (with ADC on each) and 40 spare digital input\/outputs to add additional sensors\t\t\t\t\t\t\tFour dedicated serial ports for two-way telemetry (using optional XBee modules) and expansion\t\t\t\t\t\t\t\t\t\t\tCan be powered by either the RC receiver or a separate battery\t\t\t\t\t\t\tHardware-driven servo control, which means less processor overhead, tighter response and no jitters\t\t\t\t\t\t\tEight RC channels (including the autopilot on\/off channel) can be processed by the autopilot. \t\t\t\t\t\t\tLEDs for power, failsafe status, autopilot status and GPS lock\t\t\t\t\t\t\tFull autopilot software, including IMU and groundstation\/mission planning code,  are available at DIY Drones. Code supports autonomous takeoff and landing. \t\t\t\tDimensions: 40mm x 69mm\tDocuments:\t\t\tSchematic\t\t\tEagle Files\t\t\tExample Firmware-reads in 8 channels and outputs 8 channels\t\t\tExample Dancing Firmware-Video\t\t\tArduPilot Project Homepage\t\t\tSoftware and instructions: DIY Drones Community\tReplaces: GPS-09710",
			"image":"core\/breadboard\/ArduPilotMega_v15_breadboard.svg",
			"icon":"core\/breadboard\/ArduPilotMega_v15_breadboard.svg",
			"width":"194.545",
			"height":"115.2",
			"points": [[14.948, 108.548, 6.104, 6.104], [14.948, 101.348, 6.104, 6.104], [14.948, 94.148, 6.104, 6.104], [14.948, 86.948, 6.104, 6.104], [14.948, 79.748, 6.104, 6.104], [14.948, 72.548, 6.104, 6.104], [14.948, 65.348, 6.104, 6.104], [14.948, 58.148, 6.104, 6.104], [7.748, 108.548, 6.104, 6.104], [7.748, 101.348, 6.104, 6.104], [7.748, 94.148, 6.104, 6.104], [7.748, 86.948, 6.104, 6.104], [7.748, 79.748, 6.104, 6.104], [7.748, 72.548, 6.104, 6.104], [7.748, 65.348, 6.104, 6.104], [7.748, 58.148, 6.104, 6.104], [0.548, 108.548, 6.104, 6.104], [0.548, 101.348, 6.104, 6.104], [0.548, 94.148, 6.104, 6.104], [0.548, 86.948, 6.104, 6.104], [0.548, 79.748, 6.104, 6.104], [0.548, 72.548, 6.104, 6.104], [0.548, 65.348, 6.104, 6.104], [0.548, 58.148, 6.104, 6.104], [14.948, 50.948, 6.104, 6.104], [14.948, 43.748, 6.104, 6.104], [14.948, 36.548, 6.104, 6.104], [14.948, 29.348, 6.104, 6.104], [14.948, 22.148, 6.104, 6.104], [14.948, 14.948, 6.104, 6.104], [14.948, 7.748, 6.104, 6.104], [14.948, 0.548, 6.104, 6.104], [7.748, 50.948, 6.104, 6.104], [7.748, 43.748, 6.104, 6.104], [7.748, 36.548, 6.104, 6.104], [7.748, 29.348, 6.104, 6.104], [7.748, 22.148, 6.104, 6.104], [7.748, 14.948, 6.104, 6.104], [7.748, 7.748, 6.104, 6.104], [7.748, 0.548, 6.104, 6.104], [0.548, 50.948, 6.104, 6.104], [0.548, 43.748, 6.104, 6.104], [0.548, 36.548, 6.104, 6.104], [0.548, 29.348, 6.104, 6.104], [0.548, 22.148, 6.104, 6.104], [0.548, 14.948, 6.104, 6.104], [0.548, 7.748, 6.104, 6.104], [0.548, 0.548, 6.104, 6.104], [58.148, 0.548, 6.104, 6.104], [65.348, 0.548, 6.104, 6.104], [72.548, 0.548, 6.104, 6.104], [79.748, 0.548, 6.104, 6.104], [86.948, 0.548, 6.104, 6.104], [94.148, 0.548, 6.104, 6.104], [101.348, 0.548, 6.104, 6.104], [108.548, 0.548, 6.104, 6.104], [115.748, 0.548, 6.104, 6.104], [122.948, 0.548, 6.104, 6.104], [130.148, 0.548, 6.104, 6.104], [137.348, 0.548, 6.104, 6.104], [144.548, 0.548, 6.104, 6.104], [151.748, 0.548, 6.104, 6.104], [101.348, 7.748, 6.104, 6.104], [108.548, 7.748, 6.104, 6.104], [115.748, 7.748, 6.104, 6.104], [122.948, 7.748, 6.104, 6.104], [130.148, 7.748, 6.104, 6.104], [137.348, 7.748, 6.104, 6.104], [144.548, 7.748, 6.104, 6.104], [151.748, 7.748, 6.104, 6.104], [151.748, 101.348, 6.104, 6.104], [144.548, 101.348, 6.104, 6.104], [137.348, 101.348, 6.104, 6.104], [130.148, 101.348, 6.104, 6.104], [122.948, 101.348, 6.104, 6.104], [115.748, 101.348, 6.104, 6.104], [108.548, 101.348, 6.104, 6.104], [151.748, 108.548, 6.104, 6.104], [144.548, 108.548, 6.104, 6.104], [137.348, 108.548, 6.104, 6.104], [130.148, 108.548, 6.104, 6.104], [122.948, 108.548, 6.104, 6.104], [115.748, 108.548, 6.104, 6.104], [108.548, 108.548, 6.104, 6.104], [187.748, 22.148, 6.104, 6.104], [187.748, 29.348, 6.104, 6.104], [187.748, 36.548, 6.104, 6.104], [187.748, 43.748, 6.104, 6.104], [187.748, 50.948, 6.104, 6.104], [187.748, 58.148, 6.104, 6.104], [187.748, 65.348, 6.104, 6.104], [187.748, 72.548, 6.104, 6.104], [187.748, 79.748, 6.104, 6.104], [180.548, 79.748, 6.104, 6.104], [187.748, 0.548, 6.104, 6.104], [187.748, 7.748, 6.104, 6.104], [187.748, 14.948, 6.104, 6.104], [101.348, 101.348, 6.104, 6.104], [94.148, 101.348, 6.104, 6.104], [86.948, 101.348, 6.104, 6.104], [79.748, 101.348, 6.104, 6.104], [72.548, 101.348, 6.104, 6.104], [65.348, 101.348, 6.104, 6.104], [29.348, 108.548, 6.104, 6.104], [36.548, 108.548, 6.104, 6.104], [101.348, 108.548, 6.104, 6.104], [94.148, 108.548, 6.104, 6.104], [86.948, 108.548, 6.104, 6.104], [79.748, 108.548, 6.104, 6.104], [72.548, 108.548, 6.104, 6.104], [65.348, 108.548, 6.104, 6.104], [158.948, 108.548, 6.104, 6.104], [158.948, 101.348, 6.104, 6.104], [158.948, 94.148, 6.104, 6.104], [158.948, 86.948, 6.104, 6.104], [166.148, 0.548, 6.104, 6.104], [173.348, 0.548, 6.104, 6.104], [166.148, 7.748, 6.104, 6.104], [173.348, 7.748, 6.104, 6.104], [166.148, 14.948, 6.104, 6.104], [173.348, 14.948, 6.104, 6.104], [29.348, 7.748, 6.104, 6.104], [29.348, 0.548, 6.104, 6.104], [36.548, 7.748, 6.104, 6.104], [36.548, 0.548, 6.104, 6.104], [43.748, 7.748, 6.104, 6.104], [43.748, 0.548, 6.104, 6.104]]
		}, {
			"name":"CRYSTAL-kHz",
			"description":"Crystal oscillator, used in watches and other timing applications, typically 32.768KHZ",
			"image":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"icon":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"width":"15.457",
			"height":"43.819",
			"points": [[2.451, 39.819, 4.152, 3], [9.651, 39.819, 4.152, 3]]
		}, {
			"name":"EM406 GPS Connector",
			"description":"EM406 GPS ConnectorProven layout and schematic for EM406 connector. Spark Fun Electronics SKU : GPS-00579",
			"image":"core\/breadboard\/sparkfun-connectors_em406_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_em406_breadboard.svg",
			"width":"529.75",
			"height":"600",
			"points": [[97.91, 533.05, 33.93, 33.9], [97.91, 33.05, 33.93, 33.9], [197.91, 533.05, 33.93, 33.9], [197.91, 33.05, 33.93, 33.9], [297.91, 533.05, 33.93, 33.9], [297.91, 33.05, 33.93, 33.9], [397.91, 533.05, 33.93, 33.9], [397.91, 33.05, 33.93, 33.9]]
		}, {
			"name":"Electrolytic Capacitor",
			"description":"A smd electrolytic capacitor.",
			"image":"core\/breadboard\/electrolytic_capacitor_small_leg.svg",
			"icon":"core\/breadboard\/electrolytic_capacitor_small_leg.svg",
			"width":"19.686",
			"height":"48.266",
			"points": [[12.39, 44.19, 5, 3], [2.39, 44.19, 5, 3]]
		}, {
			"name":"LM2621",
			"description":"Step-up switching regulator IC",
			"image":"core\/breadboard\/sparkfun-poweric_msop-8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_msop-8_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Header 11",
			"description":"Header 11Standard 11-pin 0.1 header. Use with straight break away headers (SKU : PRT-00116), right angle break away headers (PRT-00553), swiss pins (PRT-00743), machine pins (PRT-00117), and female headers (PRT-00115).",
			"image":"core\/breadboard\/sparkfun-connectors_1x11_smd_pthcombo_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_1x11_smd_pthcombo_breadboard.svg",
			"width":"28.1686",
			"height":"4.9276",
			"points": [[0.00715, -0.44755, 2.7239, 2.7239], [2.54965, 2.65125, 2.7239, 2.7239], [5.08715, -0.44755, 2.7239, 2.7239], [7.62965, 2.65125, 2.7239, 2.7239], [10.16715, -0.44755, 2.7239, 2.7239], [12.70965, 2.65125, 2.7239, 2.7239], [15.24715, -0.44755, 2.7239, 2.7239], [17.78965, 2.65125, 2.7239, 2.7239], [20.32715, -0.44755, 2.7239, 2.7239], [22.86965, 2.65125, 2.7239, 2.7239], [25.40715, -0.44755, 2.7239, 2.7239]]
		}, {
			"name":"25LC256",
			"description":"25LC256 SPI EEPROM",
			"image":"core\/breadboard\/25LC256_breadboard.svg",
			"icon":"core\/breadboard\/25LC256_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"atmega168",
			"description":"Atmel ATmega168 microcontroller. The hardware hacker favorite.",
			"image":"core\/breadboard\/atmega_breadboard_8e4b4f3e54f56b3f712afc6a8e6a8a71.svg",
			"icon":"core\/breadboard\/atmega_breadboard_8e4b4f3e54f56b3f712afc6a8e6a8a71.svg",
			"width":"1400",
			"height":"330",
			"points": [[34, 285.6, 32, 45.4], [34, -1, 32, 45.4], [1334, 285.6, 32, 45.4], [1334, -1, 32, 45.4], [134, -1, 32, 45.4], [234, -1, 32, 45.4], [334, -1, 32, 45.4], [434, -1, 32, 45.4], [534, -1, 32, 45.4], [634, -1, 32, 45.4], [734, -1, 32, 45.4], [834, -1, 32, 45.4], [934, -1, 32, 45.4], [1034, -1, 32, 45.4], [1134, -1, 32, 45.4], [1234, -1, 32, 45.4], [134, 285.6, 32, 45.4], [234, 285.6, 32, 45.4], [334, 285.6, 32, 45.4], [434, 285.6, 32, 45.4], [534, 285.6, 32, 45.4], [634, 285.6, 32, 45.4], [734, 285.6, 32, 45.4], [834, 285.6, 32, 45.4], [934, 285.6, 32, 45.4], [1034, 285.6, 32, 45.4], [1134, 285.6, 32, 45.4], [1234, 285.6, 32, 45.4]]
		}
	]
}, {
	"page":"12",
	"count": 37,
	"el": [{
			"name":"25LC010",
			"description":"25LC010 SPI EEPROM",
			"image":"core\/breadboard\/25LC010_breadboard.svg",
			"icon":"core\/breadboard\/25LC010_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"Generic female header-metal rounded-14 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_14.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_14.svg",
			"width":"100.506",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783], [15.556, 1.197, 4.783, 4.783], [22.735, 1.197, 4.783, 4.783], [29.914, 1.197, 4.783, 4.783], [37.093, 1.197, 4.783, 4.783], [44.272, 1.197, 4.783, 4.783], [51.451, 1.197, 4.783, 4.783], [58.63, 1.197, 4.783, 4.783], [65.809, 1.197, 4.783, 4.783], [72.988, 1.197, 4.783, 4.783], [80.167, 1.197, 4.783, 4.783], [87.346, 1.197, 4.783, 4.783], [94.525, 1.197, 4.783, 4.783]]
		}, {
			"name":"ATMEGA8U2",
			"description":"Atmel 32-pin 8-bit Microcontroller with 8\/16\/32K Bystes of ISP Flash and USB Controller. ATmega8U2, ATmega16U2, and ATmega32U2",
			"image":"core\/breadboard\/sparkfun-digitalic_tqfp32-08_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tqfp32-08_breadboard.svg",
			"width":"1600",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"ID-12_20",
			"description":"RFID reader for ID2, ID12, and ID20 Package",
			"image":"core\/breadboard\/sparkfun-rf_id-12_lock_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_id-12_lock_breadboard.svg",
			"width":"994.347",
			"height":"1200",
			"points": [[230.208, 1133.05, 33.93, 33.9], [230.208, 33.05, 33.93, 33.9], [330.208, 1133.05, 33.93, 33.9], [330.208, 33.05, 33.93, 33.9], [430.208, 1133.05, 33.93, 33.9], [430.208, 33.05, 33.93, 33.9], [530.208, 1133.05, 33.93, 33.9], [530.208, 33.05, 33.93, 33.9], [630.208, 1133.05, 33.93, 33.9], [630.208, 33.05, 33.93, 33.9], [730.208, 1133.05, 33.93, 33.9], [730.208, 33.05, 33.93, 33.9]]
		}, {
			"name":"NCP1400 Step-Up Breakout",
			"description":"The NCP1400 is a 3.3V DC-DC converter. The breakout board will accept voltage inputs between 1 and 3 Volts (such as 1 or 2 AA batteries) and output a constant, low ripple 3.3V output capable of sourcing up to 100 mA. This board is great for supplying power to 3.3V sensors or providing 3.3V from a a single AA battery.\t\tThe breakout board includes the necessary peripheral components. The input, ouput and ground pins are broken out on a 0.1' grid to allow easy access on a breadboard.  Documents:    Schematic   Datasheet",
			"image":"core\/breadboard\/NCP1400_5V_Step-Up_v11_breadboard.svg",
			"icon":"core\/breadboard\/NCP1400_5V_Step-Up_v11_breadboard.svg",
			"width":"43.2",
			"height":"39.6",
			"points": [[11.528, 33.128, 5.744, 5.744], [18.728, 33.128, 5.744, 5.744], [25.928, 33.128, 5.744, 5.744]]
		}, {
			"name":"V-REFERENCE",
			"description":"Zener diode",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot23-3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot23-3_breadboard.svg",
			"width":"259.118",
			"height":"400",
			"points": [[62.5941, 333.05, 33.93, 33.9], [162.594, 333.05, 33.93, 33.9], [162.594, 33.05, 33.93, 33.9]]
		}, {
			"name":"ENCODER-QUADRATURE",
			"description":"quadrature encoder from Top-Up, part # EC16PHBF-B-20F-24-24C-16Y",
			"image":"core\/breadboard\/potentiometer.svg",
			"icon":"core\/breadboard\/potentiometer.svg",
			"width":"42.539",
			"height":"84.941",
			"points": [[4.38, 75.739, 4.979, 10.203], [18.78, 75.739, 4.979, 10.203], [33.181, 75.739, 4.979, 10.203]]
		}, {
			"name":"Screw terminal-2 pins",
			"description":"Screw terminal with 2 pins",
			"image":"core\/breadboard\/screw_terminal_2_100mil_bread.svg",
			"icon":"core\/breadboard\/screw_terminal_2_100mil_bread.svg",
			"width":"200",
			"height":"170",
			"points": [[33.2884, 108.874, 33.5235, 62.0844], [133.2884, 108.874, 33.5235, 62.0844]]
		}, {
			"name":"Antenna",
			"description":"Random Wire Antenna",
			"image":"core\/breadboard\/antenna.svg",
			"icon":"core\/breadboard\/antenna.svg",
			"width":"40.32",
			"height":"123.121",
			"points": [[33.457, 119.457, 7.609, 4.041]]
		}, {
			"name":"SWITCH_SPDT",
			"description":"Side-actuated SPDT slide switch , as used on the Arduino Pro",
			"image":"core\/breadboard\/sparkfun-electromechanical_kps-1290_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_kps-1290_breadboard.svg",
			"width":"27.557",
			"height":"24.754",
			"points": [[4.671, 20.506, 3.813, 5.273], [11.871, 20.506, 3.815, 5.273], [19.069, 20.506, 3.813, 5.273]]
		}, {
			"name":"BLUETOOTH-RN41",
			"description":"Bluetooth SMD module",
			"image":"core\/breadboard\/sparkfun-rf_rn41_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_rn41_breadboard.svg",
			"width":"1800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"15 \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_15.svg",
			"icon":"obsolete\/breadboard\/resistor_15.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"NPN-Transistor",
			"description":"A standard NPN-transistor",
			"image":"core\/breadboard\/transistor_npn.svg",
			"icon":"core\/breadboard\/transistor_npn.svg",
			"width":"16.527",
			"height":"24.081",
			"points": [[-1, 21.081, 4.16, 3], [6.181, 21.081, 4.16, 3], [13.367, 21.081, 4.16, 3]]
		}, {
			"name":"Zener Diode",
			"description":"A standard zener diode",
			"image":"core\/breadboard\/diode.svg",
			"icon":"core\/breadboard\/diode.svg",
			"width":"29.879",
			"height":"7.2",
			"points": [[-0.989, 1.583, 3, 3], [24.576, 1.583, 3, 3]]
		}, {
			"name":"15 \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_15.svg",
			"icon":"obsolete\/breadboard\/resistor_15.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Diode",
			"description":"DiodeThese are standard reverse protection diodes and small signal diodes.SMA package can handle up to about 1A.SOD-323 can handle about 200mA.What the SOD-323 package when ordering, there are some mfgs out there that are 5-pin packages.",
			"image":"core\/breadboard\/sparkfun-discretesemi_sma-diode-kit_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sma-diode-kit_breadboard.svg",
			"width":"419.292",
			"height":"400",
			"points": [[192.681, 333.05, 33.93, 33.9], [192.681, 33.05, 33.93, 33.9]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder Jumper2 way solder jumper",
			"image":"core\/breadboard\/sparkfun-passives_sj_3_paste1_2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_3_paste1_2_breadboard.svg",
			"width":"263",
			"height":"400",
			"points": [[64.535, 333.05, 33.93, 33.9], [164.535, 333.05, 33.93, 33.9], [164.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"Voltage Regulator-Variable",
			"description":"Variable DC Voltage Regulator",
			"image":"core\/breadboard\/voltage_regulator_vreg.svg",
			"icon":"core\/breadboard\/voltage_regulator_vreg.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"PCF8575C",
			"description":"PCF8575C I\/O Expander.",
			"image":"core\/breadboard\/sparkfun-digitalic_so-24dw_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_so-24dw_breadboard.svg",
			"width":"1200",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"RGB LED-(4 legs)",
			"description":"A 5mm tri-color LED with red, green and blue inside.",
			"image":"core\/breadboard\/led-rgb-4pin-anode-leg.svg",
			"icon":"core\/breadboard\/led-rgb-4pin-anode-leg.svg",
			"width":"23.76",
			"height":"32.55",
			"points": [[1133.04, 33.05, 33.93, 33.9], [6.199, 21, 3, 3], [13.399, 21, 3, 3], [20.598, 21, 3, 3]]
		}, {
			"name":"Mystery Part-12 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 12 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part12.svg",
			"icon":"obsolete\/breadboard\/mystery_part12.svg",
			"width":"122",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002], [52.5, 24.672941, 5, 6.3400002], [62.5, 24.672941, 5, 6.3400002], [72.5, 24.672941, 5, 6.3400002], [82.5, 24.672941, 5, 6.3400002], [92.5, 24.672941, 5, 6.3400002], [102.5, 24.672941, 5, 6.3400002], [112.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"TSSOP20",
			"description":"",
			"image":"core\/breadboard\/SSOP20_breadboard.svg",
			"icon":"core\/breadboard\/SSOP20_breadboard.svg",
			"width":"72",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"ATMEGA168",
			"description":"Atmel 32-pin 8-bit micro, 16k flash.",
			"image":"core\/breadboard\/sparkfun-digitalic_tqfp32-08_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tqfp32-08_breadboard.svg",
			"width":"1600",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"APA3010SF4C",
			"description":"Right-angle 880nm SMT infrared LED",
			"image":"core\/breadboard\/sparkfun-led_apa3010sf4c_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_apa3010sf4c_breadboard.svg",
			"width":"252.431",
			"height":"400",
			"points": [[59.2506, 333.05, 33.93, 33.9], [159.251, 333.05, 33.93, 33.9], [159.251, 33.05, 33.93, 33.9]]
		}, {
			"name":"LED_BARGRAPH_10",
			"description":"10-Segment LED Bar GraphSFE part numbers: COM-09935(red, Vf = 2.1V, Ifmax = 20mA)COM-09936(yellow, Vf = 2.1V, Ifmax = 20mA)COM-09937(blue, Vf = 3.4V, Ifmax = 20mA)COM-09938(green, Vf = 3.4V, Ifmax = 20mA)",
			"image":"core\/breadboard\/sparkfun-led_led_bargaph_10_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_led_bargaph_10_breadboard.svg",
			"width":"72.576",
			"height":"29.375",
			"points": [[1.376, 22.976, 5.024, 5.024], [8.576, 22.976, 5.024, 5.024], [44.576, 22.976, 5.024, 5.024], [51.776, 22.976, 5.024, 5.024], [15.776, 22.976, 5.024, 5.024], [22.976, 22.976, 5.024, 5.024], [37.376, 22.976, 5.024, 5.024], [30.176, 22.976, 5.024, 5.024], [58.975, 22.976, 5.024, 5.024], [66.176, 22.976, 5.024, 5.024], [66.176, 1.376, 5.024, 5.024], [58.975, 1.376, 5.024, 5.024], [51.776, 1.376, 5.024, 5.024], [44.576, 1.376, 5.024, 5.024], [37.376, 1.376, 5.024, 5.024], [30.176, 1.376, 5.024, 5.024], [22.976, 1.376, 5.024, 5.024], [15.776, 1.376, 5.024, 5.024], [8.576, 1.376, 5.024, 5.024], [1.376, 1.376, 5.024, 5.024]]
		}, {
			"name":"NRF24LE1",
			"description":"2.4GHz transceiver",
			"image":"core\/breadboard\/QFN-32_breadboard.svg",
			"icon":"core\/breadboard\/QFN-32_breadboard.svg",
			"width":"115.2",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"TOUCH",
			"description":"Electrode for resistive touch detection",
			"image":"core\/breadboard\/sparkfun-sensors_touch2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_touch2_breadboard.svg",
			"width":"64.693",
			"height":"68.097",
			"points": [[25.097, 30.137, 4.42, 4.42], [15.017, 30.137, 4.42, 4.42], [4.937, 30.137, 4.42, 4.42], [17.917, 30.12, 4.42, 4.42], [28.697, 9.977, 4.42, 4.42], [28.697, -0.103, 4.42, 4.42]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_0603_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_0603_breadboard.svg",
			"width":"310.25",
			"height":"400",
			"points": [[138.16, 333.05, 33.93, 33.9], [138.16, 33.05, 33.93, 33.9]]
		}, {
			"name":"AVR 10-pin ICSP Header",
			"description":"AVR 10-pin ICSP Header This is the standard AVR In Circuit Serial Programming header.Minimal, but includes pin one indicator.Works with standard Olimex programmers.Also look for the 6-pin reduced version.Spark Fun Electronics SKU: PRT-00778",
			"image":"core\/breadboard\/sparkfun-connectors_avr_icsp_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_avr_icsp_breadboard.svg",
			"width":"57.6",
			"height":"36.918",
			"points": [[12.239, 17.928, 4.296, 4.296], [19.439, 17.928, 4.296, 4.296], [26.639, 17.929, 4.296, 4.296], [33.841, 17.928, 4.296, 4.296], [41.04, 17.928, 4.296, 4.296], [12.239, 25.129, 4.296, 4.296], [19.439, 25.129, 4.296, 4.296], [26.639, 25.129, 4.296, 4.296], [33.841, 25.129, 4.296, 4.296], [41.04, 25.129, 4.296, 4.296]]
		}, {
			"name":"25LC020",
			"description":"25LC020 SPI EEPROM",
			"image":"core\/breadboard\/25LC020_breadboard.svg",
			"icon":"core\/breadboard\/25LC020_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"7 Segment Display",
			"description":"7 Segment Display with common anode.",
			"image":"core\/breadboard\/7segment_56,9.svg",
			"icon":"core\/breadboard\/7segment_56,9.svg",
			"width":"138",
			"height":"200",
			"points": [[80.838, 12.447, 3.799, 3.799], [73.639, 12.445, 3.799, 3.801], [66.44, 12.445, 3.799, 3.801], [59.239, 12.445, 3.799, 3.801], [52.04, 12.445, 3.799, 3.801], [80.84, 182.809, 3.799, 3.799], [73.641, 182.809, 3.799, 3.799], [66.442, 182.809, 3.799, 3.799], [59.241, 182.809, 3.799, 3.799], [52.042, 182.809, 3.799, 3.799]]
		}, {
			"name":"white smd LED",
			"description":"A generic white LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-white.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-white.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"ST-GYRO-PR",
			"description":"",
			"image":"core\/breadboard\/sparkfun-sensors_lga28-4x5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga28-4x5_breadboard.svg",
			"width":"1400",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 333.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 333.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 333.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 333.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"TRIMPOT",
			"description":"Various small potentiometers for set-and-forget applications",
			"image":"core\/breadboard\/sparkfun-electromechanical_trimpot-5mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_trimpot-5mm_breadboard.svg",
			"width":"409.722",
			"height":"600",
			"points": [[137.896, 533.05, 33.93, 33.9], [237.896, 533.05, 33.93, 33.9], [237.896, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic male header-3 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_3.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_3.svg",
			"width":"21.597",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791]]
		}, {
			"name":"pinocc.io scout",
			"description":"The Arduino-compatible atomic unit of Pinoccio: Every Field Scout can talk to any other Field Scout via radio(up to about 100m away).The built-in temperature sensor and RGB LED are perfect for starter projects.",
			"image":"core\/breadboard\/pinoccio_breadboard.svg",
			"icon":"core\/breadboard\/pinoccio_breadboard.svg",
			"width":"72.426",
			"height":"147.834",
			"points": [[56.025, 26.703, 6.104, 6.104], [63.223, 26.703, 6.104, 6.104], [5.876, 13.022, 6.104, 6.104], [5.876, 20.223, 6.104, 6.104], [2.24, 33.794, 4.88, 4.88], [2.24, 39.464, 4.88, 4.88], [2.24, 45.133, 4.88, 4.88], [2.24, 50.802, 4.88, 4.88], [2.24, 56.472, 4.88, 4.88], [2.24, 62.141, 4.88, 4.88], [2.24, 67.81, 4.88, 4.88], [2.24, 73.48, 4.88, 4.88], [2.241, 79.15, 4.878, 4.878], [2.24, 84.818, 4.88, 4.88], [2.24, 90.488, 4.88, 4.88], [2.241, 96.158, 4.878, 4.878], [2.24, 101.826, 4.88, 4.88], [2.24, 107.495, 4.88, 4.88], [2.24, 113.165, 4.88, 4.88], [2.24, 118.834, 4.88, 4.88], [64.88, 33.794, 4.88, 4.88], [64.88, 39.464, 4.88, 4.88], [64.88, 45.133, 4.88, 4.88], [64.88, 50.802, 4.88, 4.88], [64.88, 56.472, 4.88, 4.88], [64.88, 62.141, 4.88, 4.88], [64.88, 67.81, 4.88, 4.88], [64.88, 73.48, 4.88, 4.88], [64.881, 79.15, 4.878, 4.878], [64.88, 84.818, 4.88, 4.88], [64.88, 90.488, 4.88, 4.88], [64.881, 96.158, 4.878, 4.878], [64.88, 101.826, 4.88, 4.88], [64.88, 107.495, 4.88, 4.88], [64.88, 113.165, 4.88, 4.88], [64.88, 118.834, 4.88, 4.88]]
		}, {
			"name":"Inductor",
			"description":"Inductor",
			"image":"core\/breadboard\/inductor_leg.svg",
			"icon":"core\/breadboard\/inductor_leg.svg",
			"width":"30.839",
			"height":"12.688",
			"points": [[64.88, 118.834, 4.88, 4.88], [25.848, 5.888, 5.989, 4.5]]
		}, {
			"name":"Variable Capacitor",
			"description":"",
			"image":"core\/breadboard\/capacitor_variable_2_legs.svg",
			"icon":"core\/breadboard\/capacitor_variable_2_legs.svg",
			"width":"18.199",
			"height":"17.377",
			"points": [[-0.359, 7.107, 4.392, 4.16], [14.061, 7.199, 4.16, 4.158]]
		}, {
			"name":"Arduino Nano(Rev3.0)",
			"description":"The Arduino Nano is a small, complete, and breadboard-friendly board based on the ATmega328(Arduino Nano 3.0)or ATmega168(Arduino Nano 2.x).It has more or less the same functionality of the Arduino Duemilanove, but in a different package.It lacks only a DC power jack, and works with a Mini-B USB cable instead of a standard one.The Nano was designed and is being produced by Gravitech.",
			"image":"core\/breadboard\/Arduino Nano3_breadboard.svg",
			"icon":"core\/breadboard\/Arduino Nano3_breadboard.svg",
			"width":"50.4",
			"height":"127.584",
			"points": [[0.692, 7.892, 5.816, 5.816], [0.692, 15.092, 5.816, 5.816], [0.692, 22.292, 5.816, 5.816], [0.692, 29.492, 5.816, 5.816], [0.692, 36.692, 5.816, 5.816], [0.692, 43.892, 5.816, 5.816], [0.692, 51.092, 5.816, 5.816], [0.692, 58.292, 5.816, 5.816], [0.692, 65.492, 5.816, 5.816], [0.692, 72.692, 5.816, 5.816], [0.692, 79.892, 5.816, 5.816], [0.692, 87.092, 5.816, 5.816], [0.692, 94.292, 5.816, 5.816], [0.692, 101.492, 5.816, 5.816], [0.692, 108.692, 5.816, 5.816], [43.892, 7.892, 5.816, 5.816], [43.892, 15.092, 5.816, 5.816], [43.892, 22.292, 5.816, 5.816], [43.892, 29.492, 5.816, 5.816], [43.892, 36.692, 5.816, 5.816], [43.892, 43.892, 5.816, 5.816], [43.892, 51.092, 5.816, 5.816], [43.892, 58.292, 5.816, 5.816], [43.892, 65.492, 5.816, 5.816], [43.892, 72.692, 5.816, 5.816], [43.892, 79.892, 5.816, 5.816], [43.892, 87.092, 5.816, 5.816], [43.892, 94.292, 5.816, 5.816], [43.892, 101.492, 5.816, 5.816], [43.892, 108.692, 5.816, 5.816], [29.492, 0.98, 5.816, 5.816], [29.492, 8.18, 5.816, 5.816], [22.292, 0.98, 5.816, 5.816], [22.292, 8.18, 5.816, 5.816], [15.092, 0.98, 5.816, 5.816], [15.092, 8.18, 5.816, 5.816]]
		}, {
			"name":"Unproven",
			"description":"Single-chip, Li-ion and Li-pol charger IC with autonomous USB-port and AC-adapter supply management.Datasheet: http: \/\/focus.ti.com\/lit\/ds\/symlink\/bq24022.pdfUnprovenLast modified: 8\/16\/10",
			"image":"core\/breadboard\/sparkfun-poweric_drc-10_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_drc-10_breadboard.svg",
			"width":"600",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"74 * 32",
			"description":"Single 2-input OR gate",
			"image":"core\/breadboard\/sparkfun-digitalic_sot353_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sot353_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}
	]
}, {
	"page":"13",
	"count": 37,
	"el": [{
			"name":"green LED-5mm",
			"description":"A generic green LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-green.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-green.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"50-PIN-CENTRONICS-F",
			"description":"Female SCSI connector",
			"image":"core\/breadboard\/sparkfun-connectors_50-pin-centronics-f_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_50-pin-centronics-f_breadboard.svg",
			"width":"2500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"RF24G Header",
			"description":"RF24G Header This is the header for connections to the RF24G Transceiver(SparkFun Electronics SKU: WRL-00151), used in the Breakout Board for RF24G Transceiver(SparkFun Electronics SKU: BOB-00196).This footprint has not yet been proven in production.",
			"image":"core\/breadboard\/sparkfun-rf_rf24g-2x5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_rf24g-2x5_breadboard.svg",
			"width":"3.4798",
			"height":"7.1628",
			"points": [[0.969, 4.6866, 2.7826, 2.7826], [-0.281, 4.6866, 2.7826, 2.7826], [-0.281, 3.4366, 2.7826, 2.7826], [-0.281, 2.1866, 2.7826, 2.7826], [-0.281, 0.9366, 2.7826, 2.7826], [-0.281, -0.3134, 2.7826, 2.7826], [0.969, -0.3134, 2.7826, 2.7826], [0.969, 0.9366, 2.7826, 2.7826], [0.969, 2.1866, 2.7826, 2.7826], [0.969, 3.4366, 2.7826, 2.7826]]
		}, {
			"name":"7-SEGMENT-4DIGIT-YOUNGSUN",
			"description":"This is a part for the 4-Digit 7-segment LEDs from Young Sun.Different from the Digikey LEDs, all 16 pins are used.The LONGPADS Variant is used for a test jig, but you may like it because there is more pad to solder to.If you are concerned about routing space, the standard works just fine though.",
			"image":"core\/breadboard\/sparkfun-displays_7-segment-4digit-youngsun_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-displays_7-segment-4digit-youngsun_breadboard.svg",
			"width":"114.256",
			"height":"36.644",
			"points": [[29.101, 29.895, 5.654, 5.654], [36.301, 29.895, 5.654, 5.654], [43.501, 29.895, 5.654, 5.654], [50.701, 29.895, 5.654, 5.654], [57.901, 29.895, 5.654, 5.654], [65.102, 29.895, 5.654, 5.654], [79.501, 29.895, 5.654, 5.654], [72.301, 29.895, 5.654, 5.654], [79.501, 1.095, 5.654, 5.654], [43.501, 1.095, 5.654, 5.654], [50.701, 1.095, 5.654, 5.654], [57.901, 1.095, 5.654, 5.654], [72.301, 1.095, 5.654, 5.654], [65.102, 1.095, 5.654, 5.654], [36.301, 1.095, 5.654, 5.654], [29.101, 1.095, 5.654, 5.654]]
		}, {
			"name":"LM34 Temperature Sensor",
			"description":"A LM34 temperature sensor with a temperature range from-40 \ u00b0C to 125 \ u00b0C.",
			"image":"core\/breadboard\/lm34.svg",
			"icon":"core\/breadboard\/lm34.svg",
			"width":"16.527",
			"height":"24.082",
			"points": [[-1, 21.082, 4.16, 3], [6.181, 21.082, 4.159, 3], [13.367, 21.082, 4.16, 3]]
		}, {
			"name":"WS2801",
			"description":"WS28013 Channel Constant Current LED Driver with programmable PWM outputs.Datasheet: http: \/\/www.sparkfun.com\/datasheets\/Components\/LED\/WS2801.pdf",
			"image":"core\/breadboard\/sparkfun-digitalic_sop-14_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sop-14_breadboard.svg",
			"width":"700",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Header 4",
			"description":"Header 4Standard 4-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).Molex polarized connector foot print use with SKU: PRT-08231 with associated crimp pins and housings.1MM SMD Version SKU: PRT-10208",
			"image":"core\/breadboard\/sparkfun-connectors_1x04-1mm-ra_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_1x04-1mm-ra_breadboard.svg",
			"width":"467.708",
			"height":"600",
			"points": [[116.889, 533.05, 33.93, 33.9], [116.889, 33.05, 33.93, 33.9], [216.889, 533.05, 33.93, 33.9], [216.889, 33.05, 33.93, 33.9], [316.889, 533.05, 33.93, 33.9], [316.889, 33.05, 33.93, 33.9]]
		}, {
			"name":"HMC5883L",
			"description":"3 Axis Digital Compass IC",
			"image":"core\/breadboard\/sparkfun-sensors_16lpcc_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_16lpcc_breadboard.svg",
			"width":"800",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Variable Capacitor",
			"description":"",
			"image":"core\/breadboard\/capacitor_variable_2_legs.svg",
			"icon":"core\/breadboard\/capacitor_variable_2_legs.svg",
			"width":"18.199",
			"height":"17.377",
			"points": [[-0.359, 7.107, 4.392, 4.16], [14.061, 7.199, 4.16, 4.158]]
		}, {
			"name":"Lt 1528",
			"description":"High current voltage regulator commonly used with GM862 cellular module.Spark Fun Electronics SKU: COM-00311.Footprint may need to have the large paste aperature reduced.",
			"image":"core\/breadboard\/sparkfun-poweric_q5-dd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_q5-dd_breadboard.svg",
			"width":"405",
			"height":"600",
			"points": [[85.535, 533.05, 33.93, 33.9], [85.535, 33.05, 33.93, 33.9], [185.535, 533.05, 33.93, 33.9], [185.535, 33.05, 33.93, 33.9], [285.535, 533.05, 33.93, 33.9], [285.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"FLO-30 Circuit",
			"description":"Reading liquid flow may not appear to be such a challenge to the embedded systems engineer.It certainly seems easy enough to do , however, as the saying goes, 'the devil is in the details '.In order to achieve true scientific grade liquid flow readings you simply cannot just count pulses.The FLO-30 Flow Meter Circuit has been designed around quality components.The flow meters that the FLO-30 can interface with are of the highest quality.The firmware on the FLO-30 Flow Meter Circuit is a very fast, real time operating system capable of managing the complex timing events needed to accurately read and report flow rates without ever missing a beat. \ u2022 Supports 3 types of flow meter \ u2022 TurboFlow-226000 Polypropylene: 800 ml\/min to 7.6 LPM Accurate to \ u00b1 1mL\/min \ u2022 RotoFlow-155421 Polypropylene: 15.14 LPM to 75.70 LPM Accurate to \ u00b1 5mL\/min \ u2022 RotoFlow-194761 Brass: 11.35 LPM to 113.56 LPM Accurate to \ u00b1 15mL\/min \ u2022 Scientific grade results \ u2022 Food Safe \ u2022 Gasoline Safe \ u2022 Diesel Safe \ u2022 Kerosene Safe \ u2022 Calculates total volume flow, L\/minute, L\/hour \ u2022 Enable\/disable flow meter \ u2022 Flow indicator LED blinks with each turn of the flow meter \ u2022 Built in total volume flow alarm \ u2022 Single reading or continuous reading modes \ u2022 Simple asynchronous serial connectivity(voltage swing 0-VCC) \ u2022 Simple instruction set consisting of only 12 commands \ u2022 Micro footprint circuitry \ u2022 Debugging LED 's \ u2022 2.5V to 5.5V operational voltage \ u2022 Low power consumption \ u2022 Dimensions: 14mm X 20.3mm(0.55'X0.79')",
			"image":"core\/breadboard\/atlas-sientific_FLO-30 Circuit_breadboard.svg",
			"icon":"core\/breadboard\/atlas-sientific_FLO-30 Circuit_breadboard.svg",
			"width":"39.465",
			"height":"58.038",
			"points": [[23.978, 0.133, 6.02, 6.02], [16.761, 0.132, 6.022, 6.022], [9.549, 51.67, 6.02, 6.02], [16.755, 51.67, 6.02, 6.02], [9.455, 0.133, 6.207, 6.03], [23.884, 51.659, 6.208, 6.029]]
		}, {
			"name":"Arduino Mega 2560(Rev3)",
			"description":"The Arduino Mega 2560 is a microcontroller board based on the ATmega2560(datasheet).It has 54 digital input\/output pins(of which 14 can be used as PWM outputs), 16 analog inputs, 4 UARTs(hardware serial ports), a 16 MHz crystal oscillator, a USB connection, a power jack, an ICSP header, and a reset button.It contains everything needed to support the microcontroller;simply connect it to a computer with a USB cable or power it with a AC-to-DC adapter or battery to get started.The Mega is compatible with most shields designed for the Arduino Duemilanove or Diecimila.The Mega 2560 is an update to the Arduino Mega, which it replaces.The Mega2560 differs from all preceding boards in that it does not use the FTDI USB-to-serial driver chip.Instead, it features the ATmega16U2 programmed as a USB-to-serial converter.Revision 3 of the board has the following new features: 1.0 pinout: added SDA and SCL pins that are near to the AREF pin and two other new pins placed near to the RESET pin, the IOREF that allow the shields to adapt to the voltage provided from the board.In future, shields will be compatible both with the board that use the AVR, which operate with 5V and with the Arduino Due that operate with 3.3V.The second one is a not connected pin, that is reserved for future purposes.Stronger RESET circuit.Atmega 16U2 replace the 8U2.",
			"image":"core\/breadboard\/Arduino_MEGA_2560-Rev3_breadboard.svg",
			"icon":"core\/breadboard\/Arduino_MEGA_2560-Rev3_breadboard.svg",
			"width":"305.973",
			"height":"151.2",
			"points": [[224.162, 141.39, 5.22, 5.22], [231.362, 141.39, 5.22, 5.22], [238.561, 141.39, 5.22, 5.22], [245.763, 141.39, 5.22, 5.22], [252.963, 141.39, 5.22, 5.22], [260.162, 141.39, 5.22, 5.22], [267.362, 141.39, 5.22, 5.22], [274.561, 141.39, 5.22, 5.22], [159.362, 141.39, 5.22, 5.22], [166.561, 141.39, 5.22, 5.22], [173.763, 141.39, 5.22, 5.22], [180.963, 141.39, 5.22, 5.22], [188.162, 141.39, 5.22, 5.22], [195.362, 141.39, 5.22, 5.22], [202.561, 141.39, 5.22, 5.22], [209.763, 141.39, 5.22, 5.22], [260.162, 4.59, 5.22, 5.22], [252.963, 4.59, 5.22, 5.22], [245.763, 4.59, 5.22, 5.22], [238.561, 4.59, 5.22, 5.22], [231.362, 4.59, 5.22, 5.22], [224.162, 4.59, 5.22, 5.22], [216.963, 4.59, 5.22, 5.22], [209.763, 4.59, 5.22, 5.22], [68.641, 4.59, 5.22, 5.22], [75.842, 4.59, 5.22, 5.22], [83.042, 4.59, 5.22, 5.22], [90.242, 4.59, 5.22, 5.22], [97.442, 4.59, 5.22, 5.22], [104.642, 4.59, 5.22, 5.22], [111.842, 4.59, 5.22, 5.22], [119.042, 4.59, 5.22, 5.22], [126.242, 4.59, 5.22, 5.22], [133.442, 4.59, 5.22, 5.22], [94.562, 141.39, 5.22, 5.22], [101.762, 141.39, 5.22, 5.22], [108.963, 141.39, 5.22, 5.22], [116.162, 141.39, 5.22, 5.22], [123.362, 141.39, 5.22, 5.22], [130.562, 141.39, 5.22, 5.22], [137.762, 141.39, 5.22, 5.22], [144.963, 141.39, 5.22, 5.22], [195.362, 4.59, 5.22, 5.22], [188.162, 4.59, 5.22, 5.22], [180.963, 4.59, 5.22, 5.22], [173.763, 4.59, 5.22, 5.22], [166.561, 4.59, 5.22, 5.22], [159.362, 4.59, 5.22, 5.22], [152.162, 4.59, 5.22, 5.22], [144.963, 4.59, 5.22, 5.22], [281.512, 4.339, 5.722, 5.722], [288.712, 4.339, 5.722, 5.722], [281.512, 11.539, 5.722, 5.722], [288.712, 11.539, 5.722, 5.722], [281.512, 18.739, 5.722, 5.722], [288.712, 18.739, 5.722, 5.722], [281.512, 25.939, 5.722, 5.722], [288.712, 25.939, 5.722, 5.722], [281.512, 33.139, 5.722, 5.722], [288.712, 33.139, 5.722, 5.722], [281.512, 40.339, 5.722, 5.722], [288.712, 40.339, 5.722, 5.722], [281.512, 47.539, 5.722, 5.722], [288.712, 47.539, 5.722, 5.722], [281.512, 54.739, 5.722, 5.722], [288.712, 54.739, 5.722, 5.722], [281.512, 61.939, 5.722, 5.722], [288.712, 61.939, 5.722, 5.722], [281.512, 69.139, 5.722, 5.722], [288.712, 69.139, 5.722, 5.722], [281.512, 76.339, 5.722, 5.722], [288.712, 76.339, 5.722, 5.722], [281.512, 83.539, 5.722, 5.722], [288.712, 83.539, 5.722, 5.722], [281.512, 90.739, 5.722, 5.722], [288.712, 90.739, 5.722, 5.722], [281.512, 97.939, 5.722, 5.722], [288.712, 97.939, 5.722, 5.722], [281.512, 105.139, 5.722, 5.722], [288.712, 105.139, 5.722, 5.722], [281.512, 112.339, 5.722, 5.722], [288.712, 112.339, 5.722, 5.722], [281.512, 119.539, 5.722, 5.722], [288.712, 119.539, 5.722, 5.722], [281.512, 126.739, 5.722, 5.722], [288.712, 126.739, 5.722, 5.722]]
		}, {
			"name":"Generic female header-5 pins",
			"description":"Generic female header",
			"image":"obsolete\/breadboard\/generic-female-header_bread_5.svg",
			"icon":"obsolete\/breadboard\/generic-female-header_bread_5.svg",
			"width":"35.895",
			"height":"7.178",
			"points": [[1.202, 1.202, 4.775, 4.775], [8.381, 1.202, 4.775, 4.775], [15.56, 1.202, 4.775, 4.775], [22.739, 1.202, 4.775, 4.775], [29.918, 1.202, 4.775, 4.775]]
		}, {
			"name":"white LED-5mm",
			"description":"A generic white LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-white.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-white.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"Venus638FLPX-L GPS Receiver",
			"description":"Venus638FLPX-L GPS ReceiverVenus638FLPx is a high performance, low cost, singlechip GPS receiver targeting mobile consumer and cellularhandset applications.It offers very low powerconsumption, high sensitivity, and best in class signalacquisition and time-to-first-fix performance.Venus638FLPx contains all the necessary components ofa complete GPS receiver, includes 1.2dB cascadedsystem NF RF front-end, GPS baseband signal processor, 0.5ppm TCXO, 32.768kHz RTC crystal, RTC LDOregulator, and passive components.It requires very lowexternal component count and takes up only 100mm2PCB footprint.Dedicated massive-correlator signal parameter searchengine within the baseband enables rapid search of all theavailable satellites and acquisition of very weak signal.Anadvanced track engine allows weak signal tracking andpositioning in harsh environments such as urban canyonsand under deep foliage.The self-contained architecture keeps GPS processing offthe host and allows integration into applications with verylittle resource.FEATURES20Hz update rate-148dBm cold start sensitivity-165dBm tracking sensitivity29 second cold start TTFF3.5 second TTFF with AGPS1 second hot start2.5m accuracyMultipath detection and suppressionJamming detection and mitigationSBAS(WAAS\/EGNOS)support7-day extended ephemeris AGPS67mW full power navigationWorks directly with active or passive antennaInternal flash for optional 75K point data loggingSupports external SPI flash memory data loggingComplete receiver in 10mm x 10mm x 1.3mm sizeContains LNA, SAW Filter, TCXO, RTC Xtal, LDOPb-free RoHS compliant",
			"image":"core\/breadboard\/sparkfun-rf_venus638flpx_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_venus638flpx_breadboard.svg",
			"width":"3500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 533.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9], [3333.03, 533.05, 33.93, 33.9], [3333.03, 33.05, 33.93, 33.9], [3433.03, 533.05, 33.93, 33.9], [3433.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"SO-28W",
			"description":"",
			"image":"core\/breadboard\/SO-28W_breadboard.svg",
			"icon":"core\/breadboard\/SO-28W_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Netduino Plus2",
			"description":"An open-source electronics platform using the.NET Micro Framework",
			"image":"core\/breadboard\/NetduinoPlus2.svg",
			"icon":"core\/breadboard\/NetduinoPlus2.svg",
			"width":"203.671",
			"height":"151.234",
			"points": [[74.804, 5.011, 4.775, 4.773], [81.884, 5.011, 4.772, 4.773], [60.401, 5.011, 4.775, 4.773], [67.481, 5.011, 4.772, 4.773], [88.964, 5.011, 4.773, 4.773], [96.243, 5.011, 4.774, 4.773], [103.52, 5.011, 4.773, 4.773], [110.502, 5.011, 4.773, 4.773], [117.884, 5.011, 4.773, 4.773], [125.055, 5.011, 4.774, 4.773], [136.538, 4.912, 4.773, 4.773], [143.709, 4.912, 4.775, 4.773], [150.691, 4.912, 4.772, 4.773], [158.072, 4.912, 4.773, 4.773], [165.255, 4.912, 4.774, 4.773], [172.326, 4.912, 4.772, 4.773], [179.608, 4.912, 4.771, 4.773], [186.891, 4.912, 4.775, 4.773], [100.433, 141.622, 4.775, 4.772], [93.231, 141.622, 4.775, 4.772], [86.03, 141.622, 4.775, 4.772], [107.731, 141.622, 4.775, 4.772], [115.033, 141.622, 4.774, 4.772], [122.015, 141.622, 4.772, 4.772], [129.387, 141.622, 4.773, 4.772], [136.568, 141.622, 4.773, 4.772], [150.742, 141.723, 4.771, 4.771], [158.013, 141.723, 4.774, 4.771], [165.295, 141.723, 4.773, 4.771], [172.276, 141.723, 4.772, 4.771], [179.648, 141.723, 4.773, 4.771], [186.83, 141.723, 4.771, 4.771]]
		}, {
			"name":"GS406SMD",
			"description":"50 Channel GS406 Helical GPS Receiver-SMD Connector.The Mating SMD SPECIAL is called SPECIAL for a reason.This package was only made in order to make a dummy gs407 PCB with mating connector(used for testing).sku: GPS-09079",
			"image":"core\/breadboard\/sparkfun-rf_gs406-mating_smd____special_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_gs406-mating_smd____special_breadboard.svg",
			"width":"500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"LilyPad Buzzer",
			"description":"This is a small buzzer for the LilyPad system.Use 2 I\/O pins on the LilyPad main board and create different noises based on the different frequency of I\/O toggling.Loud enough to hear inside a pocket but not obtrusively loud.Please note: This is an inductive buzzer meaning that is will act as a short to ground if you are not actively driving it.We recommend you put both I\/O pins to low(0V)when the buzzer is not used.Also, it' s come to our attention that washing these buzzers will damage them.Until we 've figured out a solution to this, avoid washing any portion of your project that contains one of these buzzers.LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They' re even washable!Note: A portion of this sale is given back to Dr.Leah Buechley for continued development and education of e-textiles.Dimensions: 20mm outer diameterThin 0.8mm PCB",
			"image":"core\/breadboard\/Buzzer-v15_breadboard.svg",
			"icon":"core\/breadboard\/Buzzer-v15_breadboard.svg",
			"width":"56.693",
			"height":"56.693",
			"points": [[6.518, 14.312, 6.808, 6.808], [43.339, 35.573, 6.808, 6.808]]
		}, {
			"name":"RSR 03MB102 Breadboard",
			"description":"A breadboard for easily prototyping circuits",
			"image":"core\/breadboard\/breadboard2.svg",
			"icon":"core\/breadboard\/breadboard2.svg",
			"width":"468.238",
			"height":"151.2",
			"points": [[9.92, 114.2, 4.394, 4.394], [9.92, 107, 4.394, 4.394], [9.92, 99.8, 4.394, 4.394], [9.92, 92.6, 4.394, 4.394], [9.92, 85.4, 4.392, 4.392], [9.92, 63.8, 4.394, 4.394], [9.92, 56.6, 4.394, 4.394], [9.92, 49.4, 4.394, 4.394], [9.92, 42.2, 4.394, 4.394], [9.92, 35, 4.394, 4.394], [17.12, 114.2, 4.394, 4.394], [17.12, 107, 4.394, 4.394], [17.12, 99.8, 4.394, 4.394], [17.12, 92.6, 4.394, 4.394], [17.12, 85.4, 4.392, 4.392], [17.12, 63.8, 4.394, 4.394], [17.12, 56.6, 4.394, 4.394], [17.12, 49.4, 4.394, 4.394], [17.12, 42.2, 4.394, 4.394], [17.12, 35, 4.394, 4.394], [24.32, 114.2, 4.394, 4.394], [24.32, 107, 4.394, 4.394], [24.32, 99.8, 4.394, 4.394], [24.32, 92.6, 4.394, 4.394], [24.32, 85.4, 4.392, 4.392], [24.32, 63.8, 4.394, 4.394], [24.32, 56.6, 4.394, 4.394], [24.32, 49.4, 4.394, 4.394], [24.32, 42.2, 4.394, 4.394], [24.32, 35, 4.394, 4.394], [31.52, 114.2, 4.394, 4.394], [31.52, 107, 4.394, 4.394], [31.52, 99.8, 4.394, 4.394], [31.52, 92.6, 4.394, 4.394], [31.52, 85.4, 4.392, 4.392], [31.52, 63.8, 4.394, 4.394], [31.52, 56.6, 4.394, 4.394], [31.52, 49.4, 4.394, 4.394], [31.52, 42.2, 4.394, 4.394], [31.52, 35, 4.394, 4.394], [38.72, 114.2, 4.394, 4.394], [38.72, 107, 4.394, 4.394], [38.72, 99.8, 4.394, 4.394], [38.72, 92.6, 4.394, 4.394], [38.72, 85.4, 4.392, 4.392], [38.72, 63.8, 4.394, 4.394], [38.72, 56.6, 4.394, 4.394], [38.72, 49.4, 4.394, 4.394], [38.72, 42.2, 4.394, 4.394], [38.72, 35, 4.394, 4.394], [45.92, 114.2, 4.394, 4.394], [45.92, 107, 4.394, 4.394], [45.92, 99.8, 4.394, 4.394], [45.92, 92.6, 4.394, 4.394], [45.92, 85.4, 4.392, 4.392], [45.92, 63.8, 4.394, 4.394], [45.92, 56.6, 4.394, 4.394], [45.92, 49.4, 4.394, 4.394], [45.92, 42.2, 4.394, 4.394], [45.92, 35, 4.394, 4.394], [53.12, 114.2, 4.394, 4.394], [53.12, 107, 4.394, 4.394], [53.12, 99.8, 4.394, 4.394], [53.12, 92.6, 4.394, 4.394], [53.12, 85.4, 4.392, 4.392], [53.12, 63.8, 4.394, 4.394], [53.12, 56.6, 4.394, 4.394], [53.12, 49.4, 4.394, 4.394], [53.12, 42.2, 4.394, 4.394], [53.12, 35, 4.394, 4.394], [60.32, 114.2, 4.394, 4.394], [60.32, 107, 4.394, 4.394], [60.32, 99.8, 4.394, 4.394], [60.32, 92.6, 4.394, 4.394], [60.32, 85.4, 4.392, 4.392], [60.32, 63.8, 4.394, 4.394], [60.32, 56.6, 4.394, 4.394], [60.32, 49.4, 4.394, 4.394], [60.32, 42.2, 4.394, 4.394], [60.32, 35, 4.394, 4.394], [67.52, 114.2, 4.394, 4.394], [67.52, 107, 4.394, 4.394], [67.52, 99.8, 4.394, 4.394], [67.52, 92.6, 4.394, 4.394], [67.52, 85.4, 4.392, 4.392], [67.52, 63.8, 4.394, 4.394], [67.52, 56.6, 4.394, 4.394], [67.52, 49.4, 4.394, 4.394], [67.52, 42.2, 4.394, 4.394], [67.52, 35, 4.394, 4.394], [74.72, 114.2, 4.394, 4.394], [74.72, 107, 4.394, 4.394], [74.72, 99.8, 4.394, 4.394], [74.72, 92.6, 4.394, 4.394], [74.72, 85.4, 4.392, 4.392], [74.72, 63.8, 4.394, 4.394], [74.72, 56.6, 4.394, 4.394], [74.72, 49.4, 4.394, 4.394], [74.72, 42.2, 4.394, 4.394], [74.72, 35, 4.394, 4.394], [81.919, 114.2, 4.394, 4.394], [81.919, 107, 4.394, 4.394], [81.919, 99.8, 4.394, 4.394], [81.919, 92.6, 4.394, 4.394], [81.919, 85.4, 4.392, 4.392], [81.919, 63.8, 4.394, 4.394], [81.919, 56.6, 4.394, 4.394], [81.919, 49.4, 4.394, 4.394], [81.919, 42.2, 4.394, 4.394], [81.919, 35, 4.394, 4.394], [89.12, 114.2, 4.394, 4.394], [89.12, 107, 4.394, 4.394], [89.12, 99.8, 4.394, 4.394], [89.12, 92.6, 4.394, 4.394], [89.12, 85.4, 4.392, 4.392], [89.12, 63.8, 4.394, 4.394], [89.12, 56.6, 4.394, 4.394], [89.12, 49.4, 4.394, 4.394], [89.12, 42.2, 4.394, 4.394], [89.12, 35, 4.394, 4.394], [96.319, 114.2, 4.394, 4.394], [96.319, 107, 4.394, 4.394], [96.319, 99.8, 4.394, 4.394], [96.319, 92.6, 4.394, 4.394], [96.319, 85.4, 4.392, 4.392], [96.319, 63.8, 4.394, 4.394], [96.319, 56.6, 4.394, 4.394], [96.319, 49.4, 4.394, 4.394], [96.319, 42.2, 4.394, 4.394], [96.319, 35, 4.394, 4.394], [103.52, 114.2, 4.394, 4.394], [103.52, 107, 4.394, 4.394], [103.52, 99.8, 4.394, 4.394], [103.52, 92.6, 4.394, 4.394], [103.52, 85.4, 4.392, 4.392], [103.52, 63.8, 4.394, 4.394], [103.52, 56.6, 4.394, 4.394], [103.52, 49.4, 4.394, 4.394], [103.52, 42.2, 4.394, 4.394], [103.52, 35, 4.394, 4.394], [110.719, 114.2, 4.394, 4.394], [110.719, 107, 4.394, 4.394], [110.719, 99.8, 4.394, 4.394], [110.719, 92.6, 4.394, 4.394], [110.719, 85.4, 4.392, 4.392], [110.719, 63.8, 4.394, 4.394], [110.719, 56.6, 4.394, 4.394], [110.719, 49.4, 4.394, 4.394], [110.719, 42.2, 4.394, 4.394], [110.719, 35, 4.394, 4.394], [117.919, 114.2, 4.394, 4.394], [117.919, 107, 4.394, 4.394], [117.919, 99.8, 4.394, 4.394], [117.919, 92.6, 4.394, 4.394], [117.919, 85.4, 4.392, 4.392], [117.919, 63.8, 4.394, 4.394], [117.919, 56.6, 4.394, 4.394], [117.919, 49.4, 4.394, 4.394], [117.919, 42.2, 4.394, 4.394], [117.919, 35, 4.394, 4.394], [125.119, 114.2, 4.394, 4.394], [125.119, 107, 4.394, 4.394], [125.119, 99.8, 4.394, 4.394], [125.119, 92.6, 4.394, 4.394], [125.119, 85.4, 4.392, 4.392], [125.119, 63.8, 4.394, 4.394], [125.119, 56.6, 4.394, 4.394], [125.119, 49.4, 4.394, 4.394], [125.119, 42.2, 4.394, 4.394], [125.119, 35, 4.394, 4.394], [132.319, 114.2, 4.394, 4.394], [132.319, 107, 4.394, 4.394], [132.319, 99.8, 4.394, 4.394], [132.319, 92.6, 4.394, 4.394], [132.319, 85.4, 4.392, 4.392], [132.319, 63.8, 4.394, 4.394], [132.319, 56.6, 4.394, 4.394], [132.319, 49.4, 4.394, 4.394], [132.319, 42.2, 4.394, 4.394], [132.319, 35, 4.394, 4.394], [139.52, 114.2, 4.394, 4.394], [139.52, 107, 4.394, 4.394], [139.52, 99.8, 4.394, 4.394], [139.52, 92.6, 4.394, 4.394], [139.52, 85.4, 4.392, 4.392], [139.52, 63.8, 4.394, 4.394], [139.52, 56.6, 4.394, 4.394], [139.52, 49.4, 4.394, 4.394], [139.52, 42.2, 4.394, 4.394], [139.52, 35, 4.394, 4.394], [146.719, 114.2, 4.394, 4.394], [146.719, 107, 4.394, 4.394], [146.719, 99.8, 4.394, 4.394], [146.719, 92.6, 4.394, 4.394], [146.719, 85.4, 4.392, 4.392], [146.719, 63.8, 4.394, 4.394], [146.719, 56.6, 4.394, 4.394], [146.719, 49.4, 4.394, 4.394], [146.719, 42.2, 4.394, 4.394], [146.719, 35, 4.394, 4.394], [153.919, 114.2, 4.394, 4.394], [153.919, 107, 4.394, 4.394], [153.919, 99.8, 4.394, 4.394], [153.919, 92.6, 4.394, 4.394], [153.919, 85.4, 4.392, 4.392], [153.919, 63.8, 4.394, 4.394], [153.919, 56.6, 4.394, 4.394], [153.919, 49.4, 4.394, 4.394], [153.919, 42.2, 4.394, 4.394], [153.919, 35, 4.394, 4.394], [161.119, 114.2, 4.394, 4.394], [161.119, 107, 4.394, 4.394], [161.119, 99.8, 4.394, 4.394], [161.119, 92.6, 4.394, 4.394], [161.119, 85.4, 4.392, 4.392], [161.119, 63.8, 4.394, 4.394], [161.119, 56.6, 4.394, 4.394], [161.119, 49.4, 4.394, 4.394], [161.119, 42.2, 4.394, 4.394], [161.119, 35, 4.394, 4.394], [168.319, 114.2, 4.394, 4.394], [168.319, 107, 4.394, 4.394], [168.319, 99.8, 4.394, 4.394], [168.319, 92.6, 4.394, 4.394], [168.319, 85.4, 4.392, 4.392], [168.319, 63.8, 4.394, 4.394], [168.319, 56.6, 4.394, 4.394], [168.319, 49.4, 4.394, 4.394], [168.319, 42.2, 4.394, 4.394], [168.319, 35, 4.394, 4.394], [175.519, 114.2, 4.394, 4.394], [175.519, 107, 4.394, 4.394], [175.519, 99.8, 4.394, 4.394], [175.519, 92.6, 4.394, 4.394], [175.519, 85.4, 4.392, 4.392], [175.519, 63.8, 4.394, 4.394], [175.519, 56.6, 4.394, 4.394], [175.519, 49.4, 4.394, 4.394], [175.519, 42.2, 4.394, 4.394], [175.519, 35, 4.394, 4.394], [182.719, 114.2, 4.394, 4.394], [182.719, 107, 4.394, 4.394], [182.719, 99.8, 4.394, 4.394], [182.719, 92.6, 4.394, 4.394], [182.719, 85.4, 4.392, 4.392], [182.719, 63.8, 4.394, 4.394], [182.719, 56.6, 4.394, 4.394], [182.719, 49.4, 4.394, 4.394], [182.719, 42.2, 4.394, 4.394], [182.719, 35, 4.394, 4.394], [189.919, 114.2, 4.394, 4.394], [189.919, 107, 4.394, 4.394], [189.919, 99.8, 4.394, 4.394], [189.919, 92.6, 4.394, 4.394], [189.919, 85.4, 4.392, 4.392], [189.919, 63.8, 4.394, 4.394], [189.919, 56.6, 4.394, 4.394], [189.919, 49.4, 4.394, 4.394], [189.919, 42.2, 4.394, 4.394], [189.919, 35, 4.394, 4.394], [197.119, 114.2, 4.394, 4.394], [197.119, 107, 4.394, 4.394], [197.119, 99.8, 4.394, 4.394], [197.119, 92.6, 4.394, 4.394], [197.119, 85.4, 4.392, 4.392], [197.119, 63.8, 4.394, 4.394], [197.119, 56.6, 4.394, 4.394], [197.119, 49.4, 4.394, 4.394], [197.119, 42.2, 4.394, 4.394], [197.119, 35, 4.394, 4.394], [204.319, 114.2, 4.394, 4.394], [204.319, 107, 4.394, 4.394], [204.319, 99.8, 4.394, 4.394], [204.319, 92.6, 4.394, 4.394], [204.319, 85.4, 4.392, 4.392], [204.319, 63.8, 4.394, 4.394], [204.319, 56.6, 4.394, 4.394], [204.319, 49.4, 4.394, 4.394], [204.319, 42.2, 4.394, 4.394], [204.319, 35, 4.394, 4.394], [211.519, 114.2, 4.394, 4.394], [211.519, 107, 4.394, 4.394], [211.519, 99.8, 4.394, 4.394], [211.519, 92.6, 4.394, 4.394], [211.519, 85.4, 4.392, 4.392], [211.519, 63.8, 4.394, 4.394], [211.519, 56.6, 4.394, 4.394], [211.519, 49.4, 4.394, 4.394], [211.519, 42.2, 4.394, 4.394], [211.519, 35, 4.394, 4.394], [218.719, 114.2, 4.394, 4.394], [218.719, 107, 4.394, 4.394], [218.719, 99.8, 4.394, 4.394], [218.719, 92.6, 4.394, 4.394], [218.719, 85.4, 4.392, 4.392], [218.719, 63.8, 4.394, 4.394], [218.719, 56.6, 4.394, 4.394], [218.719, 49.4, 4.394, 4.394], [218.719, 42.2, 4.394, 4.394], [218.719, 35, 4.394, 4.394], [225.919, 114.2, 4.394, 4.394], [225.919, 107, 4.394, 4.394], [225.919, 99.8, 4.394, 4.394], [225.919, 92.6, 4.394, 4.394], [225.919, 85.4, 4.392, 4.392], [225.919, 63.8, 4.394, 4.394], [225.919, 56.6, 4.394, 4.394], [225.919, 49.4, 4.394, 4.394], [225.919, 42.2, 4.394, 4.394], [225.919, 35, 4.394, 4.394], [233.119, 114.2, 4.394, 4.394], [233.119, 107, 4.394, 4.394], [233.119, 99.8, 4.394, 4.394], [233.119, 92.6, 4.394, 4.394], [233.119, 85.4, 4.392, 4.392], [233.119, 63.8, 4.394, 4.394], [233.119, 56.6, 4.394, 4.394], [233.119, 49.4, 4.394, 4.394], [233.119, 42.2, 4.394, 4.394], [233.119, 35, 4.394, 4.394], [240.319, 114.2, 4.394, 4.394], [240.319, 107, 4.394, 4.394], [240.319, 99.8, 4.394, 4.394], [240.319, 92.6, 4.394, 4.394], [240.319, 85.4, 4.392, 4.392], [240.319, 63.8, 4.394, 4.394], [240.319, 56.6, 4.394, 4.394], [240.319, 49.4, 4.394, 4.394], [240.319, 42.2, 4.394, 4.394], [240.319, 35, 4.394, 4.394], [247.519, 114.2, 4.394, 4.394], [247.519, 107, 4.394, 4.394], [247.519, 99.8, 4.394, 4.394], [247.519, 92.6, 4.394, 4.394], [247.519, 85.4, 4.392, 4.392], [247.519, 63.8, 4.394, 4.394], [247.519, 56.6, 4.394, 4.394], [247.519, 49.4, 4.394, 4.394], [247.519, 42.2, 4.394, 4.394], [247.519, 35, 4.394, 4.394], [254.718, 114.2, 4.394, 4.394], [254.718, 107, 4.394, 4.394], [254.718, 99.8, 4.394, 4.394], [254.718, 92.6, 4.394, 4.394], [254.718, 85.4, 4.392, 4.392], [254.718, 63.8, 4.394, 4.394], [254.718, 56.6, 4.394, 4.394], [254.718, 49.4, 4.394, 4.394], [254.718, 42.2, 4.394, 4.394], [254.718, 35, 4.394, 4.394], [261.918, 114.2, 4.394, 4.394], [261.918, 107, 4.394, 4.394], [261.918, 99.8, 4.394, 4.394], [261.918, 92.6, 4.394, 4.394], [261.918, 85.4, 4.392, 4.392], [261.918, 63.8, 4.394, 4.394], [261.918, 56.6, 4.394, 4.394], [261.918, 49.4, 4.394, 4.394], [261.918, 42.2, 4.394, 4.394], [261.918, 35, 4.394, 4.394], [269.119, 114.2, 4.394, 4.394], [269.119, 107, 4.394, 4.394], [269.119, 99.8, 4.394, 4.394], [269.119, 92.6, 4.394, 4.394], [269.119, 85.4, 4.392, 4.392], [269.119, 63.8, 4.394, 4.394], [269.119, 56.6, 4.394, 4.394], [269.119, 49.4, 4.394, 4.394], [269.119, 42.2, 4.394, 4.394], [269.119, 35, 4.394, 4.394], [276.318, 114.2, 4.394, 4.394], [276.318, 107, 4.394, 4.394], [276.318, 99.8, 4.394, 4.394], [276.318, 92.6, 4.394, 4.394], [276.318, 85.4, 4.392, 4.392], [276.318, 63.8, 4.394, 4.394], [276.318, 56.6, 4.394, 4.394], [276.318, 49.4, 4.394, 4.394], [276.318, 42.2, 4.394, 4.394], [276.318, 35, 4.394, 4.394], [283.519, 114.2, 4.394, 4.394], [283.519, 107, 4.394, 4.394], [283.519, 99.8, 4.394, 4.394], [283.519, 92.6, 4.394, 4.394], [283.519, 85.4, 4.392, 4.392], [283.519, 63.8, 4.394, 4.394], [283.519, 56.6, 4.394, 4.394], [283.519, 49.4, 4.394, 4.394], [283.519, 42.2, 4.394, 4.394], [283.519, 35, 4.394, 4.394], [290.718, 114.2, 4.394, 4.394], [290.718, 107, 4.394, 4.394], [290.718, 99.8, 4.394, 4.394], [290.718, 92.6, 4.394, 4.394], [290.718, 85.4, 4.392, 4.392], [290.718, 63.8, 4.394, 4.394], [290.718, 56.6, 4.394, 4.394], [290.718, 49.4, 4.394, 4.394], [290.718, 42.2, 4.394, 4.394], [290.718, 35, 4.394, 4.394], [297.917, 114.2, 4.394, 4.394], [297.917, 107, 4.394, 4.394], [297.917, 99.8, 4.394, 4.394], [297.917, 92.6, 4.394, 4.394], [297.917, 85.4, 4.392, 4.392], [297.917, 63.8, 4.394, 4.394], [297.917, 56.6, 4.394, 4.394], [297.917, 49.4, 4.394, 4.394], [297.917, 42.2, 4.394, 4.394], [297.917, 35, 4.394, 4.394], [305.119, 114.2, 4.394, 4.394], [305.119, 107, 4.394, 4.394], [305.119, 99.8, 4.394, 4.394], [305.119, 92.6, 4.394, 4.394], [305.119, 85.4, 4.392, 4.392], [305.119, 63.8, 4.394, 4.394], [305.119, 56.6, 4.394, 4.394], [305.119, 49.4, 4.394, 4.394], [305.119, 42.2, 4.394, 4.394], [305.119, 35, 4.394, 4.394], [312.318, 114.2, 4.394, 4.394], [312.318, 107, 4.394, 4.394], [312.318, 99.8, 4.394, 4.394], [312.318, 92.6, 4.394, 4.394], [312.318, 85.4, 4.392, 4.392], [312.318, 63.8, 4.394, 4.394], [312.318, 56.6, 4.394, 4.394], [312.318, 49.4, 4.394, 4.394], [312.318, 42.2, 4.394, 4.394], [312.318, 35, 4.394, 4.394], [319.519, 114.2, 4.394, 4.394], [319.519, 107, 4.394, 4.394], [319.519, 99.8, 4.394, 4.394], [319.519, 92.6, 4.394, 4.394], [319.519, 85.4, 4.392, 4.392], [319.519, 63.8, 4.394, 4.394], [319.519, 56.6, 4.394, 4.394], [319.519, 49.4, 4.394, 4.394], [319.519, 42.2, 4.394, 4.394], [319.519, 35, 4.394, 4.394], [326.718, 114.2, 4.394, 4.394], [326.718, 107, 4.394, 4.394], [326.718, 99.8, 4.394, 4.394], [326.718, 92.6, 4.394, 4.394], [326.718, 85.4, 4.392, 4.392], [326.718, 63.8, 4.394, 4.394], [326.718, 56.6, 4.394, 4.394], [326.718, 49.4, 4.394, 4.394], [326.718, 42.2, 4.394, 4.394], [326.718, 35, 4.394, 4.394], [333.917, 114.2, 4.394, 4.394], [333.917, 107, 4.394, 4.394], [333.917, 99.8, 4.394, 4.394], [333.917, 92.6, 4.394, 4.394], [333.917, 85.4, 4.392, 4.392], [333.917, 63.8, 4.394, 4.394], [333.917, 56.6, 4.394, 4.394], [333.917, 49.4, 4.394, 4.394], [333.917, 42.2, 4.394, 4.394], [333.917, 35, 4.394, 4.394], [341.119, 114.2, 4.394, 4.394], [341.119, 107, 4.394, 4.394], [341.119, 99.8, 4.394, 4.394], [341.119, 92.6, 4.394, 4.394], [341.119, 85.4, 4.392, 4.392], [341.119, 63.8, 4.394, 4.394], [341.119, 56.6, 4.394, 4.394], [341.119, 49.4, 4.394, 4.394], [341.119, 42.2, 4.394, 4.394], [341.119, 35, 4.394, 4.394], [348.318, 114.2, 4.394, 4.394], [348.318, 107, 4.394, 4.394], [348.318, 99.8, 4.394, 4.394], [348.318, 92.6, 4.394, 4.394], [348.318, 85.4, 4.392, 4.392], [348.318, 63.8, 4.394, 4.394], [348.318, 56.6, 4.394, 4.394], [348.318, 49.4, 4.394, 4.394], [348.318, 42.2, 4.394, 4.394], [348.318, 35, 4.394, 4.394], [355.519, 114.2, 4.394, 4.394], [355.519, 107, 4.394, 4.394], [355.519, 99.8, 4.394, 4.394], [355.519, 92.6, 4.394, 4.394], [355.519, 85.4, 4.392, 4.392], [355.519, 63.8, 4.394, 4.394], [355.519, 56.6, 4.394, 4.394], [355.519, 49.4, 4.394, 4.394], [355.519, 42.2, 4.394, 4.394], [355.519, 35, 4.394, 4.394], [362.718, 114.2, 4.394, 4.394], [362.718, 107, 4.394, 4.394], [362.718, 99.8, 4.394, 4.394], [362.718, 92.6, 4.394, 4.394], [362.718, 85.4, 4.392, 4.392], [362.718, 63.8, 4.394, 4.394], [362.718, 56.6, 4.394, 4.394], [362.718, 49.4, 4.394, 4.394], [362.718, 42.2, 4.394, 4.394], [362.718, 35, 4.394, 4.394], [369.917, 114.2, 4.394, 4.394], [369.917, 107, 4.394, 4.394], [369.917, 99.8, 4.394, 4.394], [369.917, 92.6, 4.394, 4.394], [369.917, 85.4, 4.392, 4.392], [369.917, 63.8, 4.394, 4.394], [369.917, 56.6, 4.394, 4.394], [369.917, 49.4, 4.394, 4.394], [369.917, 42.2, 4.394, 4.394], [369.917, 35, 4.394, 4.394], [377.119, 114.2, 4.394, 4.394], [377.119, 107, 4.394, 4.394], [377.119, 99.8, 4.394, 4.394], [377.119, 92.6, 4.394, 4.394], [377.119, 85.4, 4.392, 4.392], [377.119, 63.8, 4.394, 4.394], [377.119, 56.6, 4.394, 4.394], [377.119, 49.4, 4.394, 4.394], [377.119, 42.2, 4.394, 4.394], [377.119, 35, 4.394, 4.394], [384.318, 114.2, 4.394, 4.394], [384.318, 107, 4.394, 4.394], [384.318, 99.8, 4.394, 4.394], [384.318, 92.6, 4.394, 4.394], [384.318, 85.4, 4.392, 4.392], [384.318, 63.8, 4.394, 4.394], [384.318, 56.6, 4.394, 4.394], [384.318, 49.4, 4.394, 4.394], [384.318, 42.2, 4.394, 4.394], [384.318, 35, 4.394, 4.394], [391.517, 114.2, 4.394, 4.394], [391.517, 107, 4.394, 4.394], [391.517, 99.8, 4.394, 4.394], [391.517, 92.6, 4.394, 4.394], [391.517, 85.4, 4.392, 4.392], [391.517, 63.8, 4.394, 4.394], [391.517, 56.6, 4.394, 4.394], [391.517, 49.4, 4.394, 4.394], [391.517, 42.2, 4.394, 4.394], [391.517, 35, 4.394, 4.394], [398.718, 114.2, 4.394, 4.394], [398.718, 107, 4.394, 4.394], [398.718, 99.8, 4.394, 4.394], [398.718, 92.6, 4.394, 4.394], [398.718, 85.4, 4.392, 4.392], [398.718, 63.8, 4.394, 4.394], [398.718, 56.6, 4.394, 4.394], [398.718, 49.4, 4.394, 4.394], [398.718, 42.2, 4.394, 4.394], [398.718, 35, 4.394, 4.394], [405.917, 114.2, 4.394, 4.394], [405.917, 107, 4.394, 4.394], [405.917, 99.8, 4.394, 4.394], [405.917, 92.6, 4.394, 4.394], [405.917, 85.4, 4.392, 4.392], [405.917, 63.8, 4.394, 4.394], [405.917, 56.6, 4.394, 4.394], [405.917, 49.4, 4.394, 4.394], [405.917, 42.2, 4.394, 4.394], [405.917, 35, 4.394, 4.394], [413.119, 114.2, 4.394, 4.394], [413.119, 107, 4.394, 4.394], [413.119, 99.8, 4.394, 4.394], [413.119, 92.6, 4.394, 4.394], [413.119, 85.4, 4.392, 4.392], [413.119, 63.8, 4.394, 4.394], [413.119, 56.6, 4.394, 4.394], [413.119, 49.4, 4.394, 4.394], [413.119, 42.2, 4.394, 4.394], [413.119, 35, 4.394, 4.394], [420.318, 114.2, 4.394, 4.394], [420.318, 107, 4.394, 4.394], [420.318, 99.8, 4.394, 4.394], [420.318, 92.6, 4.394, 4.394], [420.318, 85.4, 4.392, 4.392], [420.318, 63.8, 4.394, 4.394], [420.318, 56.6, 4.394, 4.394], [420.318, 49.4, 4.394, 4.394], [420.318, 42.2, 4.394, 4.394], [420.318, 35, 4.394, 4.394], [427.517, 114.2, 4.394, 4.394], [427.517, 107, 4.394, 4.394], [427.517, 99.8, 4.394, 4.394], [427.517, 92.6, 4.394, 4.394], [427.517, 85.4, 4.392, 4.392], [427.517, 63.8, 4.394, 4.394], [427.517, 56.6, 4.394, 4.394], [427.517, 49.4, 4.394, 4.394], [427.517, 42.2, 4.394, 4.394], [427.517, 35, 4.394, 4.394], [434.718, 114.2, 4.394, 4.394], [434.718, 107, 4.394, 4.394], [434.718, 99.8, 4.394, 4.394], [434.718, 92.6, 4.394, 4.394], [434.718, 85.4, 4.392, 4.392], [434.718, 63.8, 4.394, 4.394], [434.718, 56.6, 4.394, 4.394], [434.718, 49.4, 4.394, 4.394], [434.718, 42.2, 4.394, 4.394], [434.718, 35, 4.394, 4.394], [441.917, 114.2, 4.394, 4.394], [441.917, 107, 4.394, 4.394], [441.917, 99.8, 4.394, 4.394], [441.917, 92.6, 4.394, 4.394], [441.917, 85.4, 4.392, 4.392], [441.917, 63.8, 4.394, 4.394], [441.917, 56.6, 4.394, 4.394], [441.917, 49.4, 4.394, 4.394], [441.917, 42.2, 4.394, 4.394], [441.917, 35, 4.394, 4.394], [449.119, 114.2, 4.394, 4.394], [449.119, 107, 4.394, 4.394], [449.119, 99.8, 4.394, 4.394], [449.119, 92.6, 4.394, 4.394], [449.119, 85.4, 4.392, 4.392], [449.119, 63.8, 4.394, 4.394], [449.119, 56.6, 4.394, 4.394], [449.119, 49.4, 4.394, 4.394], [449.119, 42.2, 4.394, 4.394], [449.119, 35, 4.394, 4.394], [456.318, 114.2, 4.394, 4.394], [456.318, 107, 4.394, 4.394], [456.318, 99.8, 4.394, 4.394], [456.318, 92.6, 4.394, 4.394], [456.318, 85.4, 4.392, 4.392], [456.318, 63.8, 4.394, 4.394], [456.318, 56.6, 4.394, 4.394], [456.318, 49.4, 4.394, 4.394], [456.318, 42.2, 4.394, 4.394], [456.318, 35, 4.394, 4.394], [24.333, 143, 4.392, 4.392], [24.333, 135.8, 4.394, 4.394], [24.333, 13.4, 4.394, 4.394], [24.333, 6.2, 4.394, 4.394], [31.534, 143, 4.392, 4.392], [31.534, 135.8, 4.394, 4.394], [31.534, 13.4, 4.394, 4.394], [31.534, 6.2, 4.394, 4.394], [38.733, 143, 4.392, 4.392], [38.733, 135.8, 4.394, 4.394], [38.733, 13.4, 4.394, 4.394], [38.733, 6.2, 4.394, 4.394], [45.934, 143, 4.392, 4.392], [45.934, 135.8, 4.394, 4.394], [45.934, 13.4, 4.394, 4.394], [45.934, 6.2, 4.394, 4.394], [53.133, 143, 4.392, 4.392], [53.133, 135.8, 4.394, 4.394], [53.133, 13.4, 4.394, 4.394], [53.133, 6.2, 4.394, 4.394], [67.533, 143, 4.392, 4.392], [67.533, 135.8, 4.394, 4.394], [67.533, 13.4, 4.394, 4.394], [67.533, 6.2, 4.394, 4.394], [74.733, 143, 4.392, 4.392], [74.733, 135.8, 4.394, 4.394], [74.733, 13.4, 4.394, 4.394], [74.733, 6.2, 4.394, 4.394], [81.933, 143, 4.392, 4.392], [81.933, 135.8, 4.394, 4.394], [81.933, 13.4, 4.394, 4.394], [81.933, 6.2, 4.394, 4.394], [89.133, 143, 4.392, 4.392], [89.133, 135.8, 4.394, 4.394], [89.133, 13.4, 4.394, 4.394], [89.133, 6.2, 4.394, 4.394], [96.333, 143, 4.392, 4.392], [96.333, 135.8, 4.394, 4.394], [96.333, 13.4, 4.394, 4.394], [96.333, 6.2, 4.394, 4.394], [110.733, 143, 4.392, 4.392], [110.733, 135.8, 4.394, 4.394], [110.733, 13.4, 4.394, 4.394], [110.733, 6.2, 4.394, 4.394], [117.933, 143, 4.392, 4.392], [117.933, 135.8, 4.394, 4.394], [117.933, 13.4, 4.394, 4.394], [117.933, 6.2, 4.394, 4.394], [125.133, 143, 4.392, 4.392], [125.133, 135.8, 4.394, 4.394], [125.133, 13.4, 4.394, 4.394], [125.133, 6.2, 4.394, 4.394], [132.333, 143, 4.392, 4.392], [132.333, 135.8, 4.394, 4.394], [132.333, 13.4, 4.394, 4.394], [132.333, 6.2, 4.394, 4.394], [139.533, 143, 4.392, 4.392], [139.533, 135.8, 4.394, 4.394], [139.533, 13.4, 4.394, 4.394], [139.533, 6.2, 4.394, 4.394], [153.933, 143, 4.392, 4.392], [153.933, 135.8, 4.394, 4.394], [153.933, 13.4, 4.394, 4.394], [153.933, 6.2, 4.394, 4.394], [161.133, 143, 4.392, 4.392], [161.133, 135.8, 4.394, 4.394], [161.133, 13.4, 4.394, 4.394], [161.133, 6.2, 4.394, 4.394], [168.333, 143, 4.392, 4.392], [168.333, 135.8, 4.394, 4.394], [168.333, 13.4, 4.394, 4.394], [168.333, 6.2, 4.394, 4.394], [175.533, 143, 4.392, 4.392], [175.533, 135.8, 4.394, 4.394], [175.533, 13.4, 4.394, 4.394], [175.533, 6.2, 4.394, 4.394], [182.733, 143, 4.392, 4.392], [182.733, 135.8, 4.394, 4.394], [182.733, 13.4, 4.394, 4.394], [182.733, 6.2, 4.394, 4.394], [197.133, 143, 4.392, 4.392], [197.133, 135.8, 4.394, 4.394], [197.133, 13.4, 4.394, 4.394], [197.133, 6.2, 4.394, 4.394], [204.333, 143, 4.392, 4.392], [204.333, 135.8, 4.394, 4.394], [204.333, 13.4, 4.394, 4.394], [204.333, 6.2, 4.394, 4.394], [211.533, 143, 4.392, 4.392], [211.533, 135.8, 4.394, 4.394], [211.533, 13.4, 4.394, 4.394], [211.533, 6.2, 4.394, 4.394], [218.732, 143, 4.392, 4.392], [218.732, 135.8, 4.394, 4.394], [218.732, 13.4, 4.394, 4.394], [218.732, 6.2, 4.394, 4.394], [225.932, 143, 4.392, 4.392], [225.932, 135.8, 4.394, 4.394], [225.932, 13.4, 4.394, 4.394], [225.932, 6.2, 4.394, 4.394], [240.332, 143, 4.392, 4.392], [240.332, 135.8, 4.394, 4.394], [240.332, 13.4, 4.394, 4.394], [240.332, 6.2, 4.394, 4.394], [247.532, 143, 4.392, 4.392], [247.532, 135.8, 4.394, 4.394], [247.532, 13.4, 4.394, 4.394], [247.532, 6.2, 4.394, 4.394], [254.732, 143, 4.392, 4.392], [254.732, 135.8, 4.394, 4.394], [254.732, 13.4, 4.394, 4.394], [254.732, 6.2, 4.394, 4.394], [261.931, 143, 4.392, 4.392], [261.931, 135.8, 4.394, 4.394], [261.931, 13.4, 4.394, 4.394], [261.931, 6.2, 4.394, 4.394], [269.132, 143, 4.392, 4.392], [269.132, 135.8, 4.394, 4.394], [269.132, 13.4, 4.394, 4.394], [269.132, 6.2, 4.394, 4.394], [283.532, 143, 4.392, 4.392], [283.532, 135.8, 4.394, 4.394], [283.532, 13.4, 4.394, 4.394], [283.532, 6.2, 4.394, 4.394], [290.732, 143, 4.392, 4.392], [290.732, 135.8, 4.394, 4.394], [290.732, 13.4, 4.394, 4.394], [290.732, 6.2, 4.394, 4.394], [297.931, 143, 4.392, 4.392], [297.931, 135.8, 4.394, 4.394], [297.931, 13.4, 4.394, 4.394], [297.931, 6.2, 4.394, 4.394], [305.132, 143, 4.392, 4.392], [305.132, 135.8, 4.394, 4.394], [305.132, 13.4, 4.394, 4.394], [305.132, 6.2, 4.394, 4.394], [312.332, 143, 4.392, 4.392], [312.332, 135.8, 4.394, 4.394], [312.332, 13.4, 4.394, 4.394], [312.332, 6.2, 4.394, 4.394], [326.732, 143, 4.392, 4.392], [326.732, 135.8, 4.394, 4.394], [326.732, 13.4, 4.394, 4.394], [326.732, 6.2, 4.394, 4.394], [333.931, 143, 4.392, 4.392], [333.931, 135.8, 4.394, 4.394], [333.931, 13.4, 4.394, 4.394], [333.931, 6.2, 4.394, 4.394], [341.132, 143, 4.392, 4.392], [341.132, 135.8, 4.394, 4.394], [341.132, 13.4, 4.394, 4.394], [341.132, 6.2, 4.394, 4.394], [348.332, 143, 4.392, 4.392], [348.332, 135.8, 4.394, 4.394], [348.332, 13.4, 4.394, 4.394], [348.332, 6.2, 4.394, 4.394], [355.531, 143, 4.392, 4.392], [355.531, 135.8, 4.394, 4.394], [355.531, 13.4, 4.394, 4.394], [355.531, 6.2, 4.394, 4.394], [369.931, 143, 4.392, 4.392], [369.931, 135.8, 4.394, 4.394], [369.931, 13.4, 4.394, 4.394], [369.931, 6.2, 4.394, 4.394], [377.13, 143, 4.392, 4.392], [377.13, 135.8, 4.394, 4.394], [377.13, 13.4, 4.394, 4.394], [377.13, 6.2, 4.394, 4.394], [384.332, 143, 4.392, 4.392], [384.332, 135.8, 4.394, 4.394], [384.332, 13.4, 4.394, 4.394], [384.332, 6.2, 4.394, 4.394], [391.531, 143, 4.392, 4.392], [391.531, 135.8, 4.394, 4.394], [391.531, 13.4, 4.394, 4.394], [391.531, 6.2, 4.394, 4.394], [398.732, 143, 4.392, 4.392], [398.732, 135.8, 4.394, 4.394], [398.732, 13.4, 4.394, 4.394], [398.732, 6.2, 4.394, 4.394], [413.13, 143, 4.392, 4.392], [413.13, 135.8, 4.394, 4.394], [413.13, 13.4, 4.394, 4.394], [413.13, 6.2, 4.394, 4.394], [420.332, 143, 4.392, 4.392], [420.332, 135.8, 4.394, 4.394], [420.332, 13.4, 4.394, 4.394], [420.332, 6.2, 4.394, 4.394], [427.531, 143, 4.392, 4.392], [427.531, 135.8, 4.394, 4.394], [427.531, 13.4, 4.394, 4.394], [427.531, 6.2, 4.394, 4.394], [434.732, 143, 4.392, 4.392], [434.732, 135.8, 4.394, 4.394], [434.732, 13.4, 4.394, 4.394], [434.732, 6.2, 4.394, 4.394], [441.931, 143, 4.392, 4.392], [441.931, 135.8, 4.394, 4.394], [441.931, 13.4, 4.394, 4.394], [441.931, 6.2, 4.394, 4.394]]
		}, {
			"name":"PCA9306",
			"description":"Bidirectional I2C level shifter.NOT compatible with all available part number pinout schemes-DOUBLE CHECK!!!",
			"image":"core\/breadboard\/sparkfun-digitalic_psop-8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_psop-8_breadboard.svg",
			"width":"400",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino LilyPad",
			"description":"The LilyPad Arduino is a microcontroller board designed for wearables and e-textiles.It can be sewn to fabric and similarly mounted power supplies, sensors and actuators with conductive thread.",
			"image":"obsolete\/breadboard\/Arduino_LilyPad7f6.svg",
			"icon":"obsolete\/breadboard\/Arduino_LilyPad7f6.svg",
			"width":"144",
			"height":"143.999",
			"points": [[5.9, 60.215, 5.336, 5.336], [51.279, 130.822, 5.334, 5.334], [11.041, 95.955, 5.334, 5.334], [11.039, 42.713, 5.336, 5.336], [20.901, 27.37, 5.334, 5.334], [34.685, 15.424, 5.336, 5.336], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334], [69.332, 5.251, 5.334, 5.334]]
		}, {
			"name":"HEX_CONVERTER",
			"description":"Just what it says.",
			"image":"core\/breadboard\/SO16_breadboard.svg",
			"icon":"core\/breadboard\/SO16_breadboard.svg",
			"width":"57.6",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"BAV99",
			"description":"Two small signal silicon diodes connected anode to cathode.Connections to all three nodes available.",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot23_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot23_breadboard.svg",
			"width":"259",
			"height":"400",
			"points": [[62.535, 333.05, 33.93, 33.9], [162.535, 333.05, 33.93, 33.9], [162.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"V_REG_MIC5235",
			"description":"",
			"image":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"GEIGER_TUBE",
			"description":"LND712 Geiger Tube(COM-08875)",
			"image":"core\/breadboard\/sparkfun-sensors_geiger_tube_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_geiger_tube_breadboard.svg",
			"width":"2449.24",
			"height":"1000",
			"points": [[1207.65, 933.05, 33.93, 33.9], [1207.65, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Uno(Rev3)-ICSP",
			"description":"The Arduino Uno is a microcontroller board based on the ATmega328(datasheet).It has 14 digital input\/output pins(of which 6 can be used as PWM outputs), 6 analog inputs, a 16 MHz ceramic resonator, a USB connection, a power jack, an ICSP header, and a reset button.It contains everything needed to support the microcontroller;simply connect it to a computer with a USB cable or power it with a AC-to-DC adapter or battery to get started.The Uno differs from all preceding boards in that it does not use the FTDI USB-to-serial driver chip.Instead, it features the Atmega16U2(Atmega8U2 up to version R2)programmed as a USB-to-serial converter.Revision 2 of the Uno board has a resistor pulling the 8U2 HWB line to ground, making it easier to put into DFU mode.Revision 3 of the board has the following new features: 1.0 pinout: added SDA and SCL pins that are near to the AREF pin and two other new pins placed near to the RESET pin, the IOREF that allow the shields to adapt to the voltage provided from the board.In future, shields will be compatible both with the board that use the AVR, which operate with 5V and with the Arduino Due that operate with 3.3V.The second one is a not connected pin, that is reserved for future purposes.Stronger RESET circuit.Atmega 16U2 replace the 8U2. \"Uno \"means one in Italian and is named to mark the upcoming release of Arduino 1.0. The Uno and version 1.0 will be the reference versions of Arduino, moving forward. The Uno is the latest in a series of USB Arduino boards, and the reference model for the Arduino platform; for a comparison with previous versions, see the index of Arduino boards.",
			"image":"core\/breadboard\/arduino_uno(rev3)-icsp_breadboard.svg",
			"icon":"core\/breadboard\/arduino_uno(rev3)-icsp_breadboard.svg",
			"width":"212.372",
			"height":"151.2",
			"points": [[159.362, 141.39, 5.22, 5.22], [166.562, 141.39, 5.22, 5.22], [173.762, 141.39, 5.22, 5.22], [180.963, 141.39, 5.22, 5.22], [188.162, 141.39, 5.22, 5.22], [195.362, 141.39, 5.22, 5.22], [195.561, 62.028, 5.544, 5.544], [202.76, 62.028, 5.544, 5.544], [195.562, 69.229, 5.542, 5.542], [202.761, 69.229, 5.542, 5.542], [195.562, 76.429, 5.542, 5.542], [202.761, 76.429, 5.542, 5.542], [74.241, 13.789, 5.542, 5.542], [74.24, 20.988, 5.544, 5.544], [67.041, 13.789, 5.542, 5.542], [67.04, 20.988, 5.544, 5.544], [59.84, 13.789, 5.542, 5.542], [59.839, 20.988, 5.544, 5.544], [133.441, 4.59, 5.22, 5.22], [126.242, 4.59, 5.22, 5.22], [119.042, 4.59, 5.22, 5.22], [111.842, 4.59, 5.22, 5.22], [104.642, 4.59, 5.22, 5.22], [97.442, 4.59, 5.22, 5.22], [90.242, 4.59, 5.22, 5.22], [83.042, 4.59, 5.22, 5.22], [75.842, 4.59, 5.22, 5.22], [68.641, 4.59, 5.22, 5.22], [195.362, 4.59, 5.22, 5.22], [188.162, 4.59, 5.22, 5.22], [180.963, 4.59, 5.22, 5.22], [173.762, 4.59, 5.22, 5.22], [166.562, 4.59, 5.22, 5.22], [159.362, 4.59, 5.22, 5.22], [152.162, 4.59, 5.22, 5.22], [144.963, 4.59, 5.22, 5.22], [101.762, 141.39, 5.22, 5.22], [94.562, 141.39, 5.22, 5.22], [108.963, 141.39, 5.22, 5.22], [116.162, 141.39, 5.22, 5.22], [123.362, 141.39, 5.22, 5.22], [130.562, 141.39, 5.22, 5.22], [137.762, 141.39, 5.22, 5.22], [144.963, 141.39, 5.22, 5.22]]
		}, {
			"name":"Arduino",
			"description":"The awesome Arduino microcontroller",
			"image":"obsolete\/breadboard\/controller_arduino_diecimila.svg",
			"icon":"obsolete\/breadboard\/controller_arduino_diecimila.svg",
			"width":"212.184",
			"height":"148.032",
			"points": [[81.648, 3.11, 4.774, 4.773], [88.825, 3.11, 4.772, 4.773], [96.003, 3.11, 4.772, 4.773], [103.18, 3.11, 4.774, 4.773], [110.359, 3.11, 4.773, 4.773], [117.535, 3.11, 4.772, 4.773], [124.714, 3.11, 4.773, 4.773], [131.892, 3.11, 4.773, 4.773], [146.438, 3.11, 4.772, 4.773], [153.615, 3.11, 4.773, 4.773], [160.792, 3.11, 4.772, 4.773], [167.97, 3.11, 4.772, 4.773], [175.147, 3.11, 4.774, 4.773], [182.324, 3.11, 4.772, 4.773], [189.502, 3.11, 4.771, 4.773], [196.68, 3.11, 4.774, 4.773], [110.443, 139.887, 4.774, 4.771], [117.642, 139.887, 4.774, 4.771], [124.84, 139.887, 4.773, 4.771], [132.018, 139.887, 4.772, 4.771], [139.196, 139.887, 4.774, 4.771], [146.372, 139.887, 4.773, 4.771], [160.835, 139.887, 4.771, 4.771], [168.012, 139.887, 4.773, 4.771], [175.19, 139.887, 4.773, 4.771], [182.367, 139.887, 4.772, 4.771], [189.544, 139.887, 4.772, 4.771], [196.722, 139.887, 4.771, 4.771]]
		}, {
			"name":"L298",
			"description":"L298 Dual Full Bridge Driver",
			"image":"core\/breadboard\/sparkfun-poweric_multiwatt15_6400bgheatsink_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_multiwatt15_6400bgheatsink_breadboard.svg",
			"width":"1860.24",
			"height":"3000",
			"points": [[563.155, 2933.05, 33.93, 33.9], [663.155, 2933.05, 33.93, 33.9], [663.155, 33.05, 33.93, 33.9], [763.155, 2933.05, 33.93, 33.9], [763.155, 33.05, 33.93, 33.9], [863.155, 2933.05, 33.93, 33.9], [863.155, 33.05, 33.93, 33.9], [963.155, 2933.05, 33.93, 33.9], [963.155, 33.05, 33.93, 33.9], [1063.15, 2933.05, 33.93, 33.9], [1063.15, 33.05, 33.93, 33.9], [1163.15, 2933.05, 33.93, 33.9], [1163.15, 33.05, 33.93, 33.9], [1263.15, 2933.05, 33.93, 33.9], [1263.15, 33.05, 33.93, 33.9]]
		}, {
			"name":"PL-2303XA",
			"description":"Prolific USB chip, requires 12MHz xtal",
			"image":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"icon":"core\/breadboard\/SSOP28DB_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"STARBOARD_GND",
			"description":"StarBoard ground PadStarboard pads sans the star cutout in top layer",
			"image":"core\/breadboard\/sparkfun-connectors_starboard_ground_small_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_starboard_ground_small_breadboard.svg",
			"width":"324",
			"height":"800",
			"points": [[145.035, 733.05, 33.93, 33.9]]
		}, {
			"name":"PICAXE-28X2-3V",
			"description":"PICAXE-28X2-3V from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_28X2_3V_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_28X2_3V_breadboard.svg",
			"width":"140.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [132.5, 27.66, 5, 6.34], [132.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [72.5, 27.66, 5, 6.34], [72.5, -1, 5, 6.34], [82.5, 27.66, 5, 6.34], [82.5, -1, 5, 6.34], [92.5, 27.66, 5, 6.34], [92.5, -1, 5, 6.34], [102.5, 27.66, 5, 6.34], [102.5, -1, 5, 6.34], [112.5, 27.66, 5, 6.34], [112.5, -1, 5, 6.34], [122.5, 27.66, 5, 6.34], [122.5, -1, 5, 6.34]]
		}, {
			"name":"A6282",
			"description":"16-Channel Constant-Current LED DriverPackages: TSSOP-24, 24-pin QFNLast modified: 8\/20\/10Unproven!",
			"image":"core\/breadboard\/sparkfun-digitalic_tssop-24_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tssop-24_breadboard.svg",
			"width":"1300",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"TRANSISTOR_NPN",
			"description":"Generic NPN BJT. MMBT2222 is the common NPN we use. Double check against datasheet- not all devices are the same!",
			"image":"core\/breadboard\/transistor_npn.svg",
			"icon":"core\/breadboard\/transistor_npn.svg",
			"width":"16.527",
			"height":"24.081",
			"points": [[-1, 21.081, 4.16, 3], [6.181, 21.081, 4.16, 3], [13.367, 21.081, 4.16, 3]]
		}, {
			"name":"24LC01",
			"description":"24LC01 I2C EEPROM",
			"image":"core\/breadboard\/24LC01_breadboard.svg",
			"icon":"core\/breadboard\/24LC01_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"Ethernet Pro",
			"description":"Ever wonder what would happen if you stacked an Ethernet shield on an Arduino Pro microcontroller and ran over it with a steam roller? Well, it would probably just break. But in a cartoon world it might turn into the Ethernet Pro! The Ethernet Pro is an Arduino-sized, shield-compatible microcontroller with all of the functionality of the Ethernet shield built right in!The Ethernet Pro is based on the same hardware as the Ethernet shield (Wiznet W5100) in the same configuration so it is a drop-in replacement for the 'Arduino\/Ethernet double-stack', and works with all of the existing Ethernet shield libraries and code. This board features the'Optiboot'bootloader, so be sure to select 'Arduino Uno' in the Arduino IDE when you program it. The board can be programmed using either an FTDI Basic or the ATmega8U2 breakout (w\/ USB-to-Serial firmware).\tDocuments: \t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet (W5100)\t\t\tArduino EthernetShield Page",
			"image":"core\/breadboard\/Arduino-Ethernet-v11_breadboard.svg",
			"icon":"core\/breadboard\/Arduino-Ethernet-v11_breadboard.svg",
			"width":"211.257",
			"height":"151.2",
			"points": [[157.805, 140.948, 6.104, 6.104], [165.005, 140.948, 6.104, 6.104], [172.205, 140.948, 6.104, 6.104], [179.405, 140.948, 6.104, 6.104], [186.605, 140.948, 6.104, 6.104], [193.805, 140.948, 6.104, 6.104], [132.605, 4.148, 6.104, 6.104], [125.405, 4.148, 6.104, 6.104], [118.205, 4.148, 6.104, 6.104], [111.005, 4.148, 6.104, 6.104], [103.805, 4.148, 6.104, 6.104], [96.6054, 4.148, 6.104, 6.104], [89.4054, 4.148, 6.104, 6.104], [82.2054, 4.148, 6.104, 6.104], [193.805, 4.148, 6.104, 6.104], [186.605, 4.148, 6.104, 6.104], [179.405, 4.148, 6.104, 6.104], [172.205, 4.148, 6.104, 6.104], [165.005, 4.148, 6.104, 6.104], [157.805, 4.148, 6.104, 6.104], [150.605, 4.148, 6.104, 6.104], [143.405, 4.148, 6.104, 6.104], [193.805, 61.748, 6.104, 6.104], [201.005, 61.748, 6.104, 6.104], [193.805, 68.948, 6.104, 6.104], [201.005, 68.948, 6.104, 6.104], [193.805, 76.148, 6.104, 6.104], [201.005, 76.148, 6.104, 6.104], [107.405, 140.948, 6.104, 6.104], [114.605, 140.948, 6.104, 6.104], [121.805, 140.948, 6.104, 6.104], [129.005, 140.948, 6.104, 6.104], [136.205, 140.948, 6.104, 6.104], [143.405, 140.948, 6.104, 6.104]]
		}, {
			"name":"BUTTONPAD-4X4",
			"description":"Proto layout and schematic for 4x4 button pad. Spark Fun Electronics SKU : COM-07835. Compatible common cathode tri-color LED SKU : COM-00105",
			"image":"core\/breadboard\/sparkfun-electromechanical_buttonpad-4x4-special_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buttonpad-4x4-special_breadboard.svg",
			"width":"4800",
			"height":"4600",
			"points": [[33.035, 4533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 4533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 4533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 4533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 4533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 4533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 4533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 4533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 4533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 4533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 4533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 4533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 4533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 4533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 4533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 4533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 4533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 4533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 4533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 4533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 4533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 4533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 4533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 4533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 4533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 4533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 4533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 4533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 4533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 4533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 4533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 4533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 4533.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9], [3333.03, 4533.05, 33.93, 33.9], [3333.03, 33.05, 33.93, 33.9], [3433.03, 4533.05, 33.93, 33.9], [3433.03, 33.05, 33.93, 33.9], [3533.03, 4533.05, 33.93, 33.9], [3533.03, 33.05, 33.93, 33.9], [3633.03, 4533.05, 33.93, 33.9], [3633.03, 33.05, 33.93, 33.9], [3733.03, 4533.05, 33.93, 33.9], [3733.03, 33.05, 33.93, 33.9], [3833.03, 4533.05, 33.93, 33.9], [3833.03, 33.05, 33.93, 33.9], [3933.03, 4533.05, 33.93, 33.9], [3933.03, 33.05, 33.93, 33.9], [4033.03, 4533.05, 33.93, 33.9], [4033.03, 33.05, 33.93, 33.9], [4133.03, 4533.05, 33.93, 33.9], [4133.03, 33.05, 33.93, 33.9], [4233.03, 4533.05, 33.93, 33.9], [4233.03, 33.05, 33.93, 33.9], [4333.03, 4533.05, 33.93, 33.9], [4333.03, 33.05, 33.93, 33.9], [4433.03, 4533.05, 33.93, 33.9], [4433.03, 33.05, 33.93, 33.9], [4533.03, 4533.05, 33.93, 33.9], [4533.03, 33.05, 33.93, 33.9], [4633.03, 4533.05, 33.93, 33.9], [4633.03, 33.05, 33.93, 33.9], [4733.03, 4533.05, 33.93, 33.9], [4733.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"Dual Op-Amp",
			"description":"Generic op-amp footprint",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Arduino USB Host Shield",
			"description":"\t This new version corrects the pin out for the GPX and RESET pins. The USB Host Shield contains all of the digital logic and analog circuitry necessary to implement a full-speed USB peripheral\/host controller with your Arduino. This means you could use your Arduino to interface with and control any USB slave device-thumbdrives, digital cameras, bluetooth dongles, and much more!\tA four-wire serial interface is used to communicate with the host controller chip, so the shield connects the Arduino' s hardware SPI pins(D10-13)to the MAX3421E.A USB type A female connector is wired up to the IC, and it also supplies 5V as any normal USB port would.\tThe Host Shield takes its power from the 'Vin' pin on your Arduino.Power from that pin is regulated to both 5V and 3.3V on the shield.All SPI signals are sent through a hex converter to step them down to 3.3V.\tDocuments: \t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet(MAX3421E)\t\t\tProjects and Code(Thanks Oleg!)\tReplaces: DEV-09628",
			"image":"core\/breadboard\/USBHostShield-v13_breadboard.svg",
			"icon":"core\/breadboard\/USBHostShield-v13_breadboard.svg",
			"width":"151.2",
			"height":"169.2",
			"points": [[22.148, 108.548, 6.104, 6.104], [29.348, 108.548, 6.104, 6.104], [36.548, 108.548, 6.104, 6.104], [43.748, 108.548, 6.104, 6.104], [50.948, 108.548, 6.104, 6.104], [58.148, 108.548, 6.104, 6.104], [65.348, 108.548, 6.104, 6.104], [72.548, 108.548, 6.104, 6.104], [79.748, 108.548, 6.104, 6.104], [86.948, 108.548, 6.104, 6.104], [94.148, 108.548, 6.104, 6.104], [101.348, 108.548, 6.104, 6.104], [108.548, 108.548, 6.104, 6.104], [115.748, 108.548, 6.104, 6.104], [122.948, 108.548, 6.104, 6.104], [130.148, 108.548, 6.104, 6.104], [140.948, 90.548, 6.104, 6.104], [140.948, 83.348, 6.104, 6.104], [140.948, 47.348, 6.104, 6.104], [140.948, 40.148, 6.104, 6.104], [140.948, 32.948, 6.104, 6.104], [140.948, 25.748, 6.104, 6.104], [140.948, 18.548, 6.104, 6.104], [140.948, 11.348, 6.104, 6.104], [4.148, 122.948, 6.104, 6.104], [4.148, 25.748, 6.104, 6.104], [4.148, 32.948, 6.104, 6.104], [4.148, 40.148, 6.104, 6.104], [4.148, 47.348, 6.104, 6.104], [4.148, 54.548, 6.104, 6.104], [4.148, 61.748, 6.104, 6.104], [4.148, 72.548, 6.104, 6.104], [4.148, 79.748, 6.104, 6.104], [4.148, 86.948, 6.104, 6.104], [4.148, 94.148, 6.104, 6.104], [4.148, 101.348, 6.104, 6.104], [4.148, 108.548, 6.104, 6.104], [140.948, 76.148, 6.104, 6.104], [140.948, 68.948, 6.104, 6.104], [4.148, 115.748, 6.104, 6.104], [140.948, 97.748, 6.104, 6.104], [4.148, 11.348, 6.104, 6.104], [4.148, 18.548, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [22.148, 115.748, 6.104, 6.104], [22.148, 122.948, 6.104, 6.104], [22.148, 130.148, 6.104, 6.104], [22.148, 137.348, 6.104, 6.104], [22.148, 144.548, 6.104, 6.104], [22.148, 151.748, 6.104, 6.104], [22.148, 158.948, 6.104, 6.104], [29.348, 115.748, 6.104, 6.104], [29.348, 122.948, 6.104, 6.104], [29.348, 130.148, 6.104, 6.104], [29.348, 137.348, 6.104, 6.104], [29.348, 144.548, 6.104, 6.104], [29.348, 151.748, 6.104, 6.104], [29.348, 158.948, 6.104, 6.104], [36.548, 158.948, 6.104, 6.104], [43.748, 158.948, 6.104, 6.104], [50.948, 158.948, 6.104, 6.104], [58.148, 158.948, 6.104, 6.104], [65.348, 158.948, 6.104, 6.104], [72.548, 158.948, 6.104, 6.104], [79.748, 158.948, 6.104, 6.104], [86.948, 158.948, 6.104, 6.104], [94.148, 158.948, 6.104, 6.104], [101.348, 158.948, 6.104, 6.104], [108.548, 158.948, 6.104, 6.104], [115.748, 158.948, 6.104, 6.104], [122.948, 158.948, 6.104, 6.104], [130.148, 158.948, 6.104, 6.104], [130.148, 115.748, 6.104, 6.104], [130.148, 122.948, 6.104, 6.104], [130.148, 130.148, 6.104, 6.104], [130.148, 137.348, 6.104, 6.104], [130.148, 144.548, 6.104, 6.104], [130.148, 151.748, 6.104, 6.104], [36.548, 115.748, 6.104, 6.104], [36.548, 122.948, 6.104, 6.104], [36.548, 130.148, 6.104, 6.104], [36.548, 137.348, 6.104, 6.104], [36.548, 144.548, 6.104, 6.104], [36.548, 151.748, 6.104, 6.104], [43.748, 151.748, 6.104, 6.104], [43.748, 144.548, 6.104, 6.104], [43.748, 137.348, 6.104, 6.104], [43.748, 130.148, 6.104, 6.104], [43.748, 122.948, 6.104, 6.104], [43.748, 115.748, 6.104, 6.104], [50.948, 115.748, 6.104, 6.104], [50.948, 122.948, 6.104, 6.104], [50.948, 130.148, 6.104, 6.104], [50.948, 137.348, 6.104, 6.104], [50.948, 144.548, 6.104, 6.104], [50.948, 151.748, 6.104, 6.104], [58.148, 151.748, 6.104, 6.104], [58.148, 144.548, 6.104, 6.104], [58.148, 137.348, 6.104, 6.104], [58.148, 130.148, 6.104, 6.104], [58.148, 122.948, 6.104, 6.104], [58.148, 115.748, 6.104, 6.104], [65.348, 115.748, 6.104, 6.104], [65.348, 122.948, 6.104, 6.104], [65.348, 130.148, 6.104, 6.104], [65.348, 137.348, 6.104, 6.104], [65.348, 144.548, 6.104, 6.104], [65.348, 151.748, 6.104, 6.104], [72.548, 151.748, 6.104, 6.104], [79.748, 151.748, 6.104, 6.104], [86.948, 151.748, 6.104, 6.104], [94.148, 151.748, 6.104, 6.104], [101.348, 151.748, 6.104, 6.104], [108.548, 151.748, 6.104, 6.104], [115.748, 151.748, 6.104, 6.104], [122.948, 151.748, 6.104, 6.104], [122.948, 144.548, 6.104, 6.104], [122.948, 137.348, 6.104, 6.104], [122.948, 130.148, 6.104, 6.104], [122.948, 122.948, 6.104, 6.104], [122.948, 115.748, 6.104, 6.104], [115.748, 115.748, 6.104, 6.104], [108.548, 115.748, 6.104, 6.104], [101.348, 115.748, 6.104, 6.104], [94.148, 115.748, 6.104, 6.104], [86.948, 115.748, 6.104, 6.104], [79.748, 115.748, 6.104, 6.104], [72.548, 115.748, 6.104, 6.104], [72.548, 122.948, 6.104, 6.104], [79.748, 122.948, 6.104, 6.104], [86.948, 122.948, 6.104, 6.104], [94.148, 122.948, 6.104, 6.104], [101.348, 122.948, 6.104, 6.104], [108.548, 122.948, 6.104, 6.104], [115.748, 122.948, 6.104, 6.104], [115.748, 130.148, 6.104, 6.104], [115.748, 137.348, 6.104, 6.104], [115.748, 144.548, 6.104, 6.104], [108.548, 144.548, 6.104, 6.104], [101.348, 144.548, 6.104, 6.104], [94.148, 144.548, 6.104, 6.104], [86.948, 144.548, 6.104, 6.104], [79.748, 144.548, 6.104, 6.104], [72.548, 144.548, 6.104, 6.104], [72.548, 137.348, 6.104, 6.104], [72.548, 130.148, 6.104, 6.104], [79.748, 130.148, 6.104, 6.104], [86.948, 130.148, 6.104, 6.104], [94.148, 130.148, 6.104, 6.104], [101.348, 130.148, 6.104, 6.104], [108.548, 130.148, 6.104, 6.104], [108.548, 137.348, 6.104, 6.104], [101.348, 137.348, 6.104, 6.104], [94.148, 137.348, 6.104, 6.104], [86.948, 137.348, 6.104, 6.104], [79.748, 137.348, 6.104, 6.104]]
		}, {
			"name":"Wiring",
			"description":"Wiring microcontroller",
			"image":"core\/breadboard\/controller_wiring.svg",
			"icon":"core\/breadboard\/controller_wiring.svg",
			"width":"260.625",
			"height":"170.813",
			"points": [[202.254, 8.267, 4.771, 4.772], [209.43, 8.267, 4.772, 4.772], [216.607, 8.267, 4.771, 4.772], [223.781, 8.267, 4.771, 4.772], [230.958, 8.267, 4.772, 4.772], [238.135, 8.267, 4.771, 4.772], [73.302, 8.275, 4.773, 4.771], [80.478, 8.275, 4.772, 4.771], [87.655, 8.275, 4.771, 4.771], [94.831, 8.275, 4.773, 4.771], [102.008, 8.275, 4.771, 4.771], [109.183, 8.275, 4.772, 4.771], [116.36, 8.275, 4.771, 4.771], [123.538, 8.275, 4.771, 4.771], [8.456, 8.275, 4.773, 4.771], [15.631, 8.275, 4.772, 4.771], [22.808, 8.275, 4.772, 4.771], [29.984, 8.275, 4.773, 4.771], [37.161, 8.275, 4.771, 4.771], [44.336, 8.275, 4.772, 4.771], [51.513, 8.275, 4.773, 4.771], [58.69, 8.275, 4.771, 4.771], [137.707, 8.275, 4.771, 4.771], [144.881, 8.275, 4.772, 4.771], [152.059, 8.275, 4.771, 4.771], [159.234, 8.275, 4.771, 4.771], [166.412, 8.275, 4.771, 4.771], [173.586, 8.275, 4.771, 4.771], [180.764, 8.275, 4.772, 4.771], [187.941, 8.275, 4.771, 4.771], [8.456, 158.211, 4.773, 4.771], [15.631, 158.211, 4.772, 4.771], [22.808, 158.211, 4.772, 4.771], [29.984, 158.211, 4.773, 4.771], [37.161, 158.211, 4.771, 4.771], [44.336, 158.211, 4.772, 4.771], [51.513, 158.211, 4.773, 4.771], [58.69, 158.211, 4.771, 4.771], [73.302, 158.211, 4.773, 4.771], [80.478, 158.211, 4.772, 4.771], [87.655, 158.211, 4.771, 4.771], [94.831, 158.211, 4.773, 4.771], [102.008, 158.211, 4.771, 4.771], [109.183, 158.211, 4.772, 4.771], [116.36, 158.211, 4.771, 4.771], [123.538, 158.211, 4.771, 4.771], [137.707, 158.211, 4.771, 4.771], [144.881, 158.211, 4.772, 4.771], [152.059, 158.211, 4.771, 4.771], [159.234, 158.211, 4.771, 4.771], [166.412, 158.211, 4.771, 4.771], [173.586, 158.211, 4.771, 4.771], [180.764, 158.211, 4.772, 4.771], [187.941, 158.211, 4.771, 4.771], [8.622, 75.377, 4.772, 4.771], [8.622, 68.201, 4.772, 4.771], [216.607, 158.211, 4.771, 4.771], [223.781, 158.211, 4.771, 4.771], [230.958, 158.211, 4.772, 4.771], [238.135, 158.211, 4.771, 4.771], [13.943, 123.707, 4.772, 4.771], [13.943, 116.531, 4.772, 4.771], [13.943, 109.355, 4.772, 4.771], [13.943, 102.18, 4.772, 4.773], [13.943, 95.002, 4.772, 4.771], [13.943, 87.825, 4.772, 4.771]]
		}, {
			"name":"LITTLEBITS_FEMALE",
			"description":"Female end for LittleBits boards",
			"image":"core\/breadboard\/sparkfun-connectors_little_bits_female_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_little_bits_female_breadboard.svg",
			"width":"637.014",
			"height":"400",
			"points": [[251.542, 333.05, 33.93, 33.9], [351.542, 333.05, 33.93, 33.9], [351.542, 33.05, 33.93, 33.9]]
		}, {
			"name":"Piezo Speaker",
			"description":"Piezo",
			"image":"core\/breadboard\/piezo_sensor.svg",
			"icon":"core\/breadboard\/piezo_sensor.svg",
			"width":"78.585",
			"height":"67.749",
			"points": [[33.194, 65, 3, 3], [40.392, 65, 3, 3]]
		}, {
			"name":"680k \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_680k.svg",
			"icon":"obsolete\/breadboard\/resistor_680k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"25LC040",
			"description":"25LC040 SPI EEPROM",
			"image":"core\/breadboard\/25LC040_breadboard.svg",
			"icon":"core\/breadboard\/25LC040_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}
	]
}, {
	"page":"14",
	"count": 37,
	"el": [{
			"name":"680k \ u2126 Resistor",
			"description":"A generic resistor(0.25W)",
			"image":"obsolete\/breadboard\/resistor_680k.svg",
			"icon":"obsolete\/breadboard\/resistor_680k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"PNP-Transistor",
			"description":"A standard smd PNP signal transistor",
			"image":"core\/breadboard\/transistor_pnp.svg",
			"icon":"core\/breadboard\/transistor_pnp.svg",
			"width":"16.527",
			"height":"24.08",
			"points": [[-1, 22, 4.16, 3], [6.181, 22, 4.16, 3], [13.367, 22, 4.16, 3]]
		}, {
			"name":"Generic female header-11 pins",
			"description":"Generic female header",
			"image":"obsolete\/breadboard\/generic-female-header_bread_11.svg",
			"icon":"obsolete\/breadboard\/generic-female-header_bread_11.svg",
			"width":"78.969",
			"height":"7.178",
			"points": [[1.202, 1.202, 4.775, 4.775], [8.381, 1.202, 4.775, 4.775], [15.56, 1.202, 4.775, 4.775], [22.739, 1.202, 4.775, 4.775], [29.918, 1.202, 4.775, 4.775], [37.097, 1.202, 4.775, 4.775], [44.276, 1.202, 4.775, 4.775], [51.455, 1.202, 4.775, 4.775], [58.634, 1.202, 4.775, 4.775], [65.813, 1.202, 4.775, 4.775], [72.992, 1.202, 4.775, 4.775]]
		}, {
			"name":"Generic male header-4 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_4.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_4.svg",
			"width":"28.796",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791]]
		}, {
			"name":"Electrolytic Capacitor",
			"description":"electrolytic capacitor",
			"image":"core\/breadboard\/electrolytic_capacitor_220uF_35v_leg.svg",
			"icon":"core\/breadboard\/electrolytic_capacitor_220uF_35v_leg.svg",
			"width":"31.495",
			"height":"59.901",
			"points": [[18.296, 50.901, 5, 3], [8.296, 50.901, 5, 3]]
		}, {
			"name":"Voltage Regulator LDO",
			"description":"Voltage Regulator LDOStandard 150mA LDO voltage regulator in SOT-23 layout.Micrel part MIC5205.BP(by-pass)pin is used to lower output noise with 470pF cap.",
			"image":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"SPEAKER",
			"description":"General speakers.",
			"image":"core\/breadboard\/sparkfun-electromechanical_pcb_mount_speaker_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_pcb_mount_speaker_breadboard.svg",
			"width":"71.01",
			"height":"80.156",
			"points": [[29.049, 75.196, 5.96, 5.96], [36.275, 75.196, 5.96, 5.96]]
		}, {
			"name":"MAX6675",
			"description":"K-type thermocouple ADC, SPI output",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"LM2931",
			"description":"LDO regulator with reverse battery protection-very durable!",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"TMP36 Temperature Sensor",
			"description":"A TMP36 temperature sensor with a range from-40 \ u00b0C to 150 \ u00b0C.",
			"image":"core\/breadboard\/tmp36.svg",
			"icon":"core\/breadboard\/tmp36.svg",
			"width":"16.527",
			"height":"24.081",
			"points": [[-1, 21.081, 4.16, 3], [6.181, 21.081, 4.16, 3], [13.367, 21.081, 4.16, 3]]
		}, {
			"name":"LEDs",
			"description":"LEDsStandard schematic elements and footprints for 5mm, 3mm, 1206, and 0603 sized LEDs.5mm-Spark Fun Electronics SKU: COM-00529(and others)",
			"image":"core\/breadboard\/sparkfun-led_fkit-led-1206_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_fkit-led-1206_breadboard.svg",
			"width":"374.972",
			"height":"400",
			"points": [[170.521, 333.05, 33.93, 33.9], [170.521, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Fio(Funnel I\/O)",
			"description":"The Arduino Funnel I\/O(Fio)is a board designed by Shigeru Kobayashi, based on the original design from LilyPad.Funnel is a toolkit to sketch your idea physically, and consists of software libraries and hardware.By using Funnel, the user can interface to sensors and\/or actuators with various programming languages such as ActionScript 3, Processing, and Ruby.Arduino Fio is compatible with Funnel.It has connections for a Lithium Polymer battery and includes a charge circuit over USB.An XBee socket is available on the bottom of the board.The Fio has been designed to be wirelessly reprogrammable.Checkout our tutorial on wireless bootloading!",
			"image":"core\/breadboard\/Arduino-Fio-v22_breadboard.svg",
			"icon":"core\/breadboard\/Arduino-Fio-v22_breadboard.svg",
			"width":"186.504",
			"height":"79.297",
			"points": [[94.148, 4.246, 6.104, 6.104], [86.948, 4.246, 6.104, 6.104], [79.746, 4.246, 6.104, 6.104], [72.548, 4.246, 6.104, 6.104], [65.347, 4.246, 6.104, 6.104], [58.148, 4.246, 6.104, 6.104], [50.948, 4.246, 6.104, 6.104], [43.746, 4.246, 6.104, 6.104], [36.548, 4.246, 6.104, 6.104], [29.347, 4.246, 6.104, 6.104], [22.148, 4.246, 6.104, 6.104], [14.948, 4.246, 6.104, 6.104], [7.746, 4.246, 6.104, 6.104], [0.548, 4.246, 6.104, 6.104], [148.148, 47.445, 6.104, 6.104], [148.148, 54.646, 6.104, 6.104], [25.746, 29.446, 6.104, 6.104], [32.948, 29.446, 6.104, 6.104], [25.746, 36.646, 6.104, 6.104], [32.948, 36.646, 6.104, 6.104], [25.746, 43.845, 6.104, 6.104], [32.948, 43.845, 6.104, 6.104], [94.148, 69.046, 6.104, 6.104], [86.948, 69.046, 6.104, 6.104], [79.746, 69.046, 6.104, 6.104], [72.548, 69.046, 6.104, 6.104], [65.347, 69.046, 6.104, 6.104], [58.148, 69.046, 6.104, 6.104], [50.948, 69.046, 6.104, 6.104], [43.746, 69.046, 6.104, 6.104], [36.548, 69.046, 6.104, 6.104], [29.347, 69.046, 6.104, 6.104], [22.148, 69.046, 6.104, 6.104], [14.948, 69.046, 6.104, 6.104], [7.746, 69.046, 6.104, 6.104], [0.548, 69.046, 6.104, 6.104], [148.148, 22.246, 6.104, 6.104], [148.148, 29.446, 6.104, 6.104], [108.548, 45.646, 6.104, 6.104], [115.748, 45.646, 6.104, 6.104], [115.748, 25.846, 6.104, 6.104], [108.548, 25.846, 6.104, 6.104]]
		}, {
			"name":"Resettable Fuse PTC",
			"description":"Resettable Fuse PTCResettable Fuse.Spark Fun Electronics SKU: COM-08357",
			"image":"core\/breadboard\/sparkfun-poweric_ptc_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_ptc_breadboard.svg",
			"width":"7.8232",
			"height":"3.2512",
			"points": [[-0.2983, -0.0443, 3.3398, 3.3398], [4.7817, -0.0443, 3.3398, 3.3398]]
		}, {
			"name":"SSM2220-Audio Dual Matched PNP Transistor",
			"description":"",
			"image":"core\/breadboard\/SSM2220.svg",
			"icon":"core\/breadboard\/SSM2220.svg",
			"width":"28.8",
			"height":"29.786",
			"points": [[0.852, 22.942, 5.5, 5.5], [8.053, 22.944, 5.5, 5.5], [15.251, 22.944, 5.5, 5.5], [22.447, 22.942, 5.5, 5.5], [22.449, 1.344, 5.5, 5.5], [15.25, 1.344, 5.5, 5.5], [8.053, 1.342, 5.5, 5.5], [0.853, 1.341, 5.5, 5.5]]
		}, {
			"name":"FKIT-SNAP_CONNECTOR",
			"description":"Snap connector for Fabrick.it products",
			"image":"core\/breadboard\/sparkfun-electromechanical_fkit-snap_female_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_fkit-snap_female_breadboard.svg",
			"width":"1094.1",
			"height":"1000",
			"points": [[480.083, 933.05, 33.93, 33.9], [580.083, 933.05, 33.93, 33.9], [580.083, 33.05, 33.93, 33.9]]
		}, {
			"name":"NCP303LSN09",
			"description":"Power-on uC reset controller",
			"image":"core\/breadboard\/sparkfun-digitalic_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Pushbutton",
			"description":"A generic pushbutton.",
			"image":"core\/breadboard\/basic_pbutton.svg",
			"icon":"core\/breadboard\/basic_pbutton.svg",
			"width":"24.518",
			"height":"33.002",
			"points": [[19.606, -0.998, 5, 6.25], [19.606, 27.752, 5, 6.25], [-0.394, -0.998, 5, 6.25], [-0.394, 27.752, 5, 6.25]]
		}, {
			"name":"OSCILLATOR",
			"description":"3.2x2.5 oscillators",
			"image":"core\/breadboard\/sparkfun-freqctrl_crystal-smd-5x3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-freqctrl_crystal-smd-5x3_breadboard.svg",
			"width":"310.236",
			"height":"400",
			"points": [[88.1531, 333.05, 33.93, 33.9], [88.1531, 33.05, 33.93, 33.9], [188.153, 333.05, 33.93, 33.9], [188.153, 33.05, 33.93, 33.9]]
		}, {
			"name":"TRANSISTOR_NPN",
			"description":"Generic NPN BJT.MMBT2222 is the common NPN we use.Double check against datasheet-not all devices are the same!",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot89_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot89_breadboard.svg",
			"width":"294.551",
			"height":"400",
			"points": [[80.3106, 333.05, 33.93, 33.9], [80.3106, 33.05, 33.93, 33.9], [180.311, 333.05, 33.93, 33.9], [180.311, 33.05, 33.93, 33.9]]
		}, {
			"name":"CMA3000-D01",
			"description":"3-axis 2\/8g I2c\/SPI accelerometer",
			"image":"core\/breadboard\/sparkfun-sensors_cma3000_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_cma3000_breadboard.svg",
			"width":"400",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Header 5",
			"description":"Header 5Standard 5-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).Molex polarized connector foot print use with SKU: PRT-08230 with associated crimp pins and housings.",
			"image":"core\/breadboard\/sparkfun-connectors_1x05-1mm-ra_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_1x05-1mm-ra_breadboard.svg",
			"width":"507.083",
			"height":"600",
			"points": [[86.5765, 533.05, 33.93, 33.9], [186.576, 533.05, 33.93, 33.9], [186.576, 33.05, 33.93, 33.9], [286.577, 533.05, 33.93, 33.9], [286.577, 33.05, 33.93, 33.9], [386.577, 533.05, 33.93, 33.9], [386.577, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Color LCD Shield",
			"description":"The Color LCD Shield, recommended by and designed in partnership with an SFE customer, provides an easy method of connecting the popular Nokia 6100 LCD to your Arduino USB or Pro.The board comes as shown with the 128x128 mini color LCD, as well as a backlight driver circuit(boosts to 7V), and three momentary push-buttons(tied through a jumper to pins D3-5).\t\tThe Nokia 6100 LCD is controlled through a 9-bit SPI interface.The control pins of the LCD are connected to the hardware SPI pins of the Arduino(D13-SCK, D11-DIO), the CS pin is tied to D9 and the reset pin is connected to D8.Voltage from the '5V' pin of the Arduino is boosted to 7V to power the LCD backlight.\t\tThe Nokia 6100 LCD is included with the Color LCD Shield.Headers are not soldered on, we recommend the 6 and 8-pin stackable headers.\t\tDocuments: \t\t\tSchematic\t\t\tExample Code\t\t\tExample Arduino Library(Thanks Peter!)\t\t\tExample Arduino Code(Thanks Mark!)",
			"image":"core\/breadboard\/Color-LCD-Shield-v14_breadboard.svg",
			"icon":"core\/breadboard\/Color-LCD-Shield-v14_breadboard.svg",
			"width":"169.2",
			"height":"151.2",
			"points": [[115.748, 140.948, 6.104, 6.104], [122.948, 140.948, 6.104, 6.104], [130.148, 140.948, 6.104, 6.104], [137.348, 140.948, 6.104, 6.104], [144.548, 140.948, 6.104, 6.104], [151.748, 140.948, 6.104, 6.104], [101.348, 4.148, 6.104, 6.104], [108.548, 4.148, 6.104, 6.104], [115.748, 4.148, 6.104, 6.104], [122.948, 4.148, 6.104, 6.104], [130.148, 4.148, 6.104, 6.104], [137.348, 4.148, 6.104, 6.104], [144.548, 4.148, 6.104, 6.104], [151.748, 4.148, 6.104, 6.104], [40.148, 4.148, 6.104, 6.104], [47.348, 4.148, 6.104, 6.104], [54.548, 4.148, 6.104, 6.104], [61.748, 4.148, 6.104, 6.104], [68.948, 4.148, 6.104, 6.104], [76.148, 4.148, 6.104, 6.104], [83.348, 4.148, 6.104, 6.104], [90.548, 4.148, 6.104, 6.104], [101.348, 140.948, 6.104, 6.104], [94.148, 140.948, 6.104, 6.104], [86.948, 140.948, 6.104, 6.104], [79.748, 140.948, 6.104, 6.104], [72.548, 140.948, 6.104, 6.104], [65.348, 140.948, 6.104, 6.104]]
		}, {
			"name":"ADXL345",
			"description":"3-axis SPI\/I2C 2\/4\/8\/16g accelerometer",
			"image":"core\/breadboard\/sparkfun-sensors_lga14_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga14_breadboard.svg",
			"width":"700",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Header 6",
			"description":"Header 6Standard 6-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).Molex polarized connector foot print use with SKU: PRT-08094 with associated crimp pins and housings.NOTES ON THE VARIANTS LOCK and LOCK_LONGPADS...This footprint was designed to help hold the alignment of a through-hole component(i.e.6-pin header)while soldering it into place.You may notice that each hole has been shifted either up or down by 0.005 of an inch from it 's more standard position (which is a perfectly straight line). This slight alteration caused the pins (the squares in the middle) to touch the edges of the holes. Because they are alternating, it causes a brace to hold the component in place. 0.005 has proven to be the perfect amount of off-center position when using our standard breakaway headers.Although looks a little odd when you look at the bare footprint, once you have a header in there, the alteration is very hard to notice. Also,if you push a header all the way into place, it is covered up entirely on the bottom side. This idea of altering the position of holes to aid alignment will be further integrated into the Sparkfun Library for other footprints. It can help hold any component with 3 or more connection pins.",
			"image":"core\/breadboard\/sparkfun-connectors_molex-1x6_lock_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_molex-1x6_lock_breadboard.svg",
			"width":"15.367",
			"height":"5.715",
			"points": [[-0.3904, 1.3876, 3.4478, 3.4478], [2.1496, 1.6416, 3.4478, 3.4478], [4.6896, 1.3876, 3.4478, 3.4478], [7.2296, 1.6416, 3.4478, 3.4478], [9.7696, 1.3876, 3.4478, 3.4478], [12.3096, 1.6416, 3.4478, 3.4478]]
		}, {
			"name":"AVR ISP 6 Pin",
			"description":"AVR ISP 6 PinThis is the reduced ISP connector for AVR programming. Common on Arduino. This footprint will take up less PCB space and can be used with a 10-pin to 6-pin adapter such as SKU: BOB-08508",
			"image":"core\/breadboard\/sparkfun-connectors_2x3-ns_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_2x3-ns_breadboard.svg",
			"width":"43.197",
			"height":"36.918",
			"points": [[12.251, 25.065, 4.296, 4.296], [12.251, 17.865, 4.296, 4.296], [19.451, 25.125, 4.296, 4.296], [19.451, 17.865, 4.296, 4.296], [26.652, 25.125, 4.296, 4.296], [26.652, 17.865, 4.296, 4.296]]
		}, {
			"name":"USB Connectors",
			"description":"USB ConnectorsUSB-B-PTH is fully proven SKU : PRT-00139USB-miniB is fully proven SKU : PRT-00587USB-A-PCB is untested.USB-A-H is throughly reviewed, but untested. Spark Fun Electronics SKU : PRT-00437USB-B-SMT is throughly reviewed, but untested. Needs silkscreen touching up.USB-A-S has not been used\/testedUSB-MB-H has not been used\/tested",
			"image":"core\/breadboard\/sparkfun-connectors_usb-b-pth-vertical_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-b-pth-vertical_breadboard.svg",
			"width":"593.375",
			"height":"800",
			"points": [[179.722, 733.05, 33.93, 33.9], [179.722, 33.05, 33.93, 33.9], [279.722, 733.05, 33.93, 33.9], [279.722, 33.05, 33.93, 33.9], [379.722, 733.05, 33.93, 33.9], [379.722, 33.05, 33.93, 33.9]]
		}, {
			"name":"MAX323",
			"description":"Dual low-voltage SPST analog switch",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Bluetooth Module Breakout-Roving Networks (RN-41)",
			"description":"\tThis is a simple breakout for the Roving Networks Bluetooth module. All pertinent pins are broken out and labeled. This new version' s headers are unpopulated.Check below for appropriate headers.\t\tThe module from Roving Networks is powerful, small, and very easy to use.This Bluetooth module is designed to replace serial cables.The Bluetooth stack is completely encapsulated.The end user just sees serial characters being transmitted back and forth.Press the 'A' character from a terminal program on your computer and an 'A' will be pushed out the TX pin of the Bluetooth module.\tDo not attach this device directly to a serial port.You will need an RS232 to TTL converter circuit if you need to attach this device to a computer.\tFeatures: \t\t\tFully qualified Bluetooth module\t\t\tFCC Certified\t\t\tFully configurable UART\t\t\tUART Data rates up to 3Mbps\t\t\tOver air data rate of 721kbps to 2.0Mbps\t\t\tLow power sleep mode\t\t\tCompatible with all Bluetooth products that support SPP(almost all do )\t\t\tIncludes support for BCSP, DUN, LAN, GAP SDP, RFCOMM, and L2CAP protocols\t\t\t3.3V operation\t\t\tStatus pin\t\t\tBluetooth Technology v2.0 compatible\t\t\tClass 1 power output\tDimensions: 1.0x0.9' Documents:    Schematic   Eagle Files   RN-41 Datasheet   RN-41 AT Command Set   PIC Example   Tutorial(interfacing a 3.3V device to a 5V micro) Replaces: WRL-10144",
			"image":"core\/breadboard\/RN41-v14_breadboard.svg",
			"icon":"core\/breadboard\/RN41-v14_breadboard.svg",
			"width":"86.0882",
			"height":"64.8",
			"points": [[79.4362, 58.148, 6.104, 6.104], [72.2362, 58.148, 6.104, 6.104], [65.0362, 58.148, 6.104, 6.104], [57.8362, 58.148, 6.104, 6.104], [50.6362, 58.148, 6.104, 6.104], [43.4362, 58.148, 6.104, 6.104], [36.2362, 58.148, 6.104, 6.104], [29.0362, 58.148, 6.104, 6.104], [21.8362, 58.148, 6.104, 6.104], [14.6362, 58.148, 6.104, 6.104], [14.6362, 0.548, 6.104, 6.104], [21.8362, 0.548, 6.104, 6.104], [29.0362, 0.548, 6.104, 6.104], [36.2362, 0.548, 6.104, 6.104], [43.4362, 0.548, 6.104, 6.104], [50.6362, 0.548, 6.104, 6.104], [57.8362, 0.548, 6.104, 6.104], [65.0362, 0.548, 6.104, 6.104], [72.2362, 0.548, 6.104, 6.104], [79.4362, 0.548, 6.104, 6.104]]
		}, {
			"name":"MCP73831",
			"description":"Miniature single cell, fully integrated Li-Ion, Li-polymer charge management controllerhttp: \/\/ww1.microchip.com\/downloads\/en\/DeviceDoc\/21984a.pdf",
			"image":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_sot23-5_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Resonator",
			"description":"Ceramic resonator with built-in capacitors",
			"image":"core\/breadboard\/resonator-3pin-leg.svg",
			"icon":"core\/breadboard\/resonator-3pin-leg.svg",
			"width":"18.688",
			"height":"23.351",
			"points": [[14.437, 16.549, 4.159, 3], [7.237, 16.549, 4.16, 3], [0.036, 16.549, 4.16, 3]]
		}, {
			"name":"EEPROM-I2C",
			"description":"I2C EEPROM chips, 24LC256(and others)",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"POT_SWITCH",
			"description":"Potentiometer w\/switch .",
			"image":"core\/breadboard\/sparkfun-electromechanical_pot_pth_switch_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_pot_pth_switch_breadboard.svg",
			"width":"734.167",
			"height":"1200",
			"points": [[250.118, 1133.05, 33.93, 33.9], [350.118, 1133.05, 33.93, 33.9], [350.118, 33.05, 33.93, 33.9], [450.118, 1133.05, 33.93, 33.9], [450.118, 33.05, 33.93, 33.9]]
		}, {
			"name":"HDJD-S822-QR999",
			"description":"Avago RGB color sensor, analog out",
			"image":"core\/breadboard\/sparkfun-sensors_qfn-16-_rounded0thermal-pad__breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_qfn-16-_rounded0thermal-pad__breadboard.svg",
			"width":"900",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic male header-5 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_5.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_5.svg",
			"width":"35.995",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791]]
		}, {
			"name":"RS485",
			"description":"RS485 transceiver",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Nokia 6100 Color LCD",
			"description":"Nokia 6100 Color LCDSchematic element and footprint production proven but could use some touching up.Spark Fun Electronics SKU: LCD-00569.Mating SMD connector: LCD-00570",
			"image":"core\/breadboard\/sparkfun-displays_nokia6100_lcd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-displays_nokia6100_lcd_breadboard.svg",
			"width":"1600",
			"height":"2200",
			"points": [[583.035, 2133.05, 33.93, 33.9], [583.035, 33.05, 33.93, 33.9], [683.035, 2133.05, 33.93, 33.9], [683.035, 33.05, 33.93, 33.9], [783.035, 2133.05, 33.93, 33.9], [783.035, 33.05, 33.93, 33.9], [883.035, 2133.05, 33.93, 33.9], [883.035, 33.05, 33.93, 33.9], [983.035, 2133.05, 33.93, 33.9], [983.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"CD4048B",
			"description":"CMOS Multifunction Expandable 8-Input Gate",
			"image":"core\/breadboard\/CD4048B_1.svg",
			"icon":"core\/breadboard\/CD4048B_1.svg",
			"width":"800",
			"height":"330",
			"points": [[34, 285.6, 32, 45.4], [34, -1, 32, 45.4], [734, 285.6, 32, 45.4], [734, -1, 32, 45.4], [134, -1, 32, 45.4], [234, -1, 32, 45.4], [334, -1, 32, 45.4], [434, -1, 32, 45.4], [534, -1, 32, 45.4], [634, -1, 32, 45.4], [134, 285.6, 32, 45.4], [234, 285.6, 32, 45.4], [334, 285.6, 32, 45.4], [434, 285.6, 32, 45.4], [534, 285.6, 32, 45.4], [634, 285.6, 32, 45.4]]
		}, {
			"name":"LilyPad Light Sensor",
			"description":"This is a simple to use light sensor that outputs an analog value from 0 to 5V.With exposure to daylight, this sensor will output 5V.Covering the sensor with your hand, the sensor will output 0V.In a normal indoor lighting situation, the sensor will output from 1 to 2V.LilyPad is a wearable e-textile technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They 're even washable!Note: A portion of this sale is given back to Dr. Leah Buechley for continued development and education of e-textiles.Dimensions:20mm outer diameterThin 0.8mm PCB",
			"image":"core\/breadboard\/LilyPad-Light Sensor-v13_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad-Light Sensor-v13_breadboard.svg",
			"width":"56.693",
			"height":"56.693",
			"points": [[43.367, 35.573, 6.808, 6.808], [6.546, 35.573, 6.808, 6.808], [24.942, 3.682, 6.808, 6.808]]
		}, {
			"name":"Arduino Wireless SD Shield",
			"description":"The Wireless SD shield allows an Arduino board to communicate wirelessly using a wireless module. It is based on the Xbee modules from Digi, but can use any module with the same footprint. The module can communicate up to 100 feet indoors or 300 feet outdoors (with line-of-sight). It can be used as a serial\/usb replacement or you can put it into a command mode and configure it for a variety of broadcast and mesh networking options. The shields breaks out each of the Xbee' s pins to a through-hole solder pad.Included on board is a SD card slot.When using the SD Library to access the card, Pin 4 is CS and cannot be used otherwise.SPI also relies on pins 11, 12, and 13 for communication.Also on board is a switch allowing for control via USB or the microcontroller.",
			"image":"core\/breadboard\/Wireless_SD_v3_breadboard.svg",
			"icon":"core\/breadboard\/Wireless_SD_v3_breadboard.svg",
			"width":"194.4",
			"height":"151.2",
			"points": [[141.2, 141.2, 5.6, 5.6], [148.4, 141.2, 5.6, 5.6], [155.6, 141.2, 5.6, 5.6], [162.8, 141.2, 5.6, 5.6], [170, 141.2, 5.6, 5.6], [177.2, 141.2, 5.6, 5.6], [177.56, 62, 5.6, 5.6], [184.76, 62, 5.6, 5.6], [177.56, 69.2, 5.6, 5.6], [184.76, 69.2, 5.6, 5.6], [177.56, 76.4, 5.6, 5.6], [184.76, 76.4, 5.6, 5.6], [115.28, 11.6, 5.6, 5.6], [108.08, 11.6, 5.6, 5.6], [100.88, 11.6, 5.6, 5.6], [93.68, 11.6, 5.6, 5.6], [86.48, 11.6, 5.6, 5.6], [79.28, 11.6, 5.6, 5.6], [72.08, 11.6, 5.6, 5.6], [64.88, 11.6, 5.6, 5.6], [115.28, 4.4, 5.6, 5.6], [108.08, 4.4, 5.6, 5.6], [100.88, 4.4, 5.6, 5.6], [93.68, 4.4, 5.6, 5.6], [86.48, 4.4, 5.6, 5.6], [79.28, 4.4, 5.6, 5.6], [72.08, 4.4, 5.6, 5.6], [64.88, 4.4, 5.6, 5.6], [141.2, 134, 5.6, 5.6], [148.4, 134, 5.6, 5.6], [155.6, 134, 5.6, 5.6], [162.8, 134, 5.6, 5.6], [170, 134, 5.6, 5.6], [177.2, 134, 5.6, 5.6], [177.2, 4.4, 5.6, 5.6], [170, 4.4, 5.6, 5.6], [162.8, 4.4, 5.6, 5.6], [155.6, 4.4, 5.6, 5.6], [148.4, 4.4, 5.6, 5.6], [141.2, 4.4, 5.6, 5.6], [134, 4.4, 5.6, 5.6], [126.8, 4.4, 5.6, 5.6], [177.2, 11.6, 5.6, 5.6], [170, 11.6, 5.6, 5.6], [162.8, 11.6, 5.6, 5.6], [155.6, 11.6, 5.6, 5.6], [148.4, 11.6, 5.6, 5.6], [141.2, 11.6, 5.6, 5.6], [134, 11.6, 5.6, 5.6], [126.8, 11.6, 5.6, 5.6], [9.8, 105.2, 5.6, 5.6], [17, 105.2, 5.6, 5.6], [24.2, 105.2, 5.6, 5.6], [31.4, 105.2, 5.6, 5.6], [38.6, 105.2, 5.6, 5.6], [45.8, 105.2, 5.6, 5.6], [53, 105.2, 5.6, 5.6], [60.2, 105.2, 5.6, 5.6], [67.4, 105.2, 5.6, 5.6], [74.6, 105.2, 5.6, 5.6], [74.6, 26, 5.6, 5.6], [67.4, 26, 5.6, 5.6], [60.2, 26, 5.6, 5.6], [53, 26, 5.6, 5.6], [45.8, 26, 5.6, 5.6], [38.6, 26, 5.6, 5.6], [31.4, 26, 5.6, 5.6], [24.2, 26, 5.6, 5.6], [17, 26, 5.6, 5.6], [9.8, 26, 5.6, 5.6], [90.8, 141.2, 5.6, 5.6], [98, 141.2, 5.6, 5.6], [105.2, 141.2, 5.6, 5.6], [112.4, 141.2, 5.6, 5.6], [119.6, 141.2, 5.6, 5.6], [126.8, 141.2, 5.6, 5.6], [90.8, 134, 5.6, 5.6], [98, 134, 5.6, 5.6], [105.2, 134, 5.6, 5.6], [112.4, 134, 5.6, 5.6], [119.6, 134, 5.6, 5.6], [126.8, 134, 5.6, 5.6], [96.33465, 56.73465, 5.3307, 5.3307], [96.33465, 35.13465, 5.3307, 5.3307], [96.33465, 42.33465, 5.3307, 5.3307], [96.33465, 49.53465, 5.3307, 5.3307], [96.33465, 63.93465, 5.3307, 5.3307], [96.33465, 71.13465, 5.3307, 5.3307], [96.33465, 78.33465, 5.3307, 5.3307], [139.53465, 35.13465, 5.3307, 5.3307], [125.13465, 35.13465, 5.3307, 5.3307], [96.33465, 85.53465, 5.3307, 5.3307], [110.73465, 35.13465, 5.3307, 5.3307], [96.33465, 92.73465, 5.3307, 5.3307], [96.33465, 99.93465, 5.3307, 5.3307], [96.33465, 107.13465, 5.3307, 5.3307], [96.33465, 114.33465, 5.3307, 5.3307], [89.13465, 56.73465, 5.3307, 5.3307], [89.13465, 63.93465, 5.3307, 5.3307], [89.13465, 71.13465, 5.3307, 5.3307], [89.13465, 78.33465, 5.3307, 5.3307], [89.13465, 85.53465, 5.3307, 5.3307], [117.93465, 35.13465, 5.3307, 5.3307], [103.53465, 35.13465, 5.3307, 5.3307], [139.53465, 42.33465, 5.3307, 5.3307], [125.13465, 42.33465, 5.3307, 5.3307], [110.73465, 42.33465, 5.3307, 5.3307], [89.13465, 92.73465, 5.3307, 5.3307], [132.33465, 35.13465, 5.3307, 5.3307], [117.93465, 42.33465, 5.3307, 5.3307], [103.53465, 42.33465, 5.3307, 5.3307], [139.53465, 49.53465, 5.3307, 5.3307], [125.13465, 49.53465, 5.3307, 5.3307], [110.73465, 49.53465, 5.3307, 5.3307], [89.13465, 99.93465, 5.3307, 5.3307], [132.33465, 49.53465, 5.3307, 5.3307], [117.93465, 49.53465, 5.3307, 5.3307], [103.53465, 49.53465, 5.3307, 5.3307], [139.53465, 56.73465, 5.3307, 5.3307], [125.13465, 56.73465, 5.3307, 5.3307], [110.73465, 56.73465, 5.3307, 5.3307], [89.13465, 107.13465, 5.3307, 5.3307], [132.33465, 56.73465, 5.3307, 5.3307], [117.93465, 56.73465, 5.3307, 5.3307], [103.53465, 56.73465, 5.3307, 5.3307], [139.53465, 63.93465, 5.3307, 5.3307], [125.13465, 63.93465, 5.3307, 5.3307], [110.73465, 63.93465, 5.3307, 5.3307], [89.13465, 114.33465, 5.3307, 5.3307], [132.33465, 63.93465, 5.3307, 5.3307], [117.93465, 63.93465, 5.3307, 5.3307], [103.53465, 63.93465, 5.3307, 5.3307], [139.53465, 71.13465, 5.3307, 5.3307], [125.13465, 71.13465, 5.3307, 5.3307], [110.73465, 71.13465, 5.3307, 5.3307], [89.13465, 35.13465, 5.3307, 5.3307], [132.33465, 71.13465, 5.3307, 5.3307], [117.93465, 71.13465, 5.3307, 5.3307], [103.53465, 71.13465, 5.3307, 5.3307], [139.53465, 78.33465, 5.3307, 5.3307], [125.13465, 78.33465, 5.3307, 5.3307], [110.73465, 78.33465, 5.3307, 5.3307], [89.13465, 42.33465, 5.3307, 5.3307], [132.33465, 78.33465, 5.3307, 5.3307], [117.93465, 78.33465, 5.3307, 5.3307], [103.53465, 78.33465, 5.3307, 5.3307], [139.53465, 85.53465, 5.3307, 5.3307], [125.13465, 85.53465, 5.3307, 5.3307], [110.73465, 85.53465, 5.3307, 5.3307], [89.13465, 49.53465, 5.3307, 5.3307], [132.33465, 85.53465, 5.3307, 5.3307], [117.93465, 85.53465, 5.3307, 5.3307], [103.53465, 85.53465, 5.3307, 5.3307], [139.53465, 92.73465, 5.3307, 5.3307], [125.13465, 92.73465, 5.3307, 5.3307], [110.73465, 92.73465, 5.3307, 5.3307], [132.33465, 42.33465, 5.3307, 5.3307], [132.33465, 92.73465, 5.3307, 5.3307], [117.93465, 92.73465, 5.3307, 5.3307], [103.53465, 92.73465, 5.3307, 5.3307], [139.53465, 99.93465, 5.3307, 5.3307], [125.13465, 99.93465, 5.3307, 5.3307], [110.73465, 99.93465, 5.3307, 5.3307], [132.33465, 99.93465, 5.3307, 5.3307], [117.93465, 99.93465, 5.3307, 5.3307], [103.53465, 99.93465, 5.3307, 5.3307], [139.53465, 107.13465, 5.3307, 5.3307], [125.13465, 107.13465, 5.3307, 5.3307], [110.73465, 107.13465, 5.3307, 5.3307], [132.33465, 107.13465, 5.3307, 5.3307], [117.93465, 107.13465, 5.3307, 5.3307], [103.53465, 107.13465, 5.3307, 5.3307], [139.53465, 114.33465, 5.3307, 5.3307], [125.13465, 114.33465, 5.3307, 5.3307], [110.73465, 114.33465, 5.3307, 5.3307], [132.33465, 114.33465, 5.3307, 5.3307], [117.93465, 114.33465, 5.3307, 5.3307], [103.53465, 114.33465, 5.3307, 5.3307]]
		}, {
			"name":"Solenoid",
			"description":"",
			"image":"core\/breadboard\/solenoid.svg",
			"icon":"core\/breadboard\/solenoid.svg",
			"width":"47.369",
			"height":"112.672",
			"points": [[18.013, 110, 3, 3], [25.234, 110, 3, 3]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_b82462g_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_b82462g_breadboard.svg",
			"width":"456.028",
			"height":"600",
			"points": [[211.049, 533.05, 33.93, 33.9], [211.049, 33.05, 33.93, 33.9]]
		}, {
			"name":"AD8397",
			"description":"Rail-to-rail high current output op-amp",
			"image":"core\/breadboard\/sparkfun-analogic_so08-epad_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_so08-epad_breadboard.svg",
			"width":"500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}
	]
}, {
	"page":"15",
	"count": 37,
	"el": [{
			"name":"MAG3110",
			"description":"3-axis digital(I2C) magnetometer",
			"image":"core\/breadboard\/sparkfun-sensors_dfn-10_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_dfn-10_breadboard.svg",
			"width":"500",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic female header-6 pins",
			"description":"Generic female header",
			"image":"obsolete\/breadboard\/generic-female-header_bread_6.svg",
			"icon":"obsolete\/breadboard\/generic-female-header_bread_6.svg",
			"width":"43.074",
			"height":"7.178",
			"points": [[1.202, 1.202, 4.775, 4.775], [8.381, 1.202, 4.775, 4.775], [15.56, 1.202, 4.775, 4.775], [22.739, 1.202, 4.775, 4.775], [29.918, 1.202, 4.775, 4.775], [37.097, 1.202, 4.775, 4.775]]
		}, {
			"name":"LM393",
			"description":"Low-voltage comparator",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_c0402_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_c0402_breadboard.svg",
			"width":"278.75",
			"height":"400",
			"points": [[122.41, 333.05, 33.93, 33.9], [122.41, 33.05, 33.93, 33.9]]
		}, {
			"name":"V_REG_LD1085",
			"description":"LD1085 3A low-drop positive voltage regulator, adjustableThe LD1085xx is a low drop voltage regulator able to provide up to 3 A of output current.Dropout is guaranteed at a maximum of 1.2 V at the maximum output current, decreasing at lower loads.The LD1085xx is pin to pin compatible with the older 3-terminal adjustable regulators, but has better performances in term of drop and output tolerance.Available PackagesD2PAK\/A-3-pin w\/tabs, SMD",
			"image":"core\/breadboard\/sparkfun-poweric_d2pack_a_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_d2pack_a_breadboard.svg",
			"width":"680.306",
			"height":"1000",
			"points": [[273.188, 933.05, 33.93, 33.9], [273.188, 33.05, 33.93, 33.9], [373.188, 933.05, 33.93, 33.9], [373.188, 33.05, 33.93, 33.9]]
		}, {
			"name":"Voltage Regulator",
			"description":"Voltage RegulatorStandard LM317 adjustable voltage regulator.AOI(Adjust Output Input).Google 'LM317 Calculator' for easy to use app to get the two resistor values needed.240\/720 for 5V output.240\/390 for 3.3V output.Spark Fun Electronics SKU: COM-00527",
			"image":"core\/breadboard\/voltage_regulator_vreg.svg",
			"icon":"core\/breadboard\/voltage_regulator_vreg.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"MCP130",
			"description":"Open-drain microcontroller supervisor chip",
			"image":"core\/breadboard\/sparkfun-digitalic_sot23-3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sot23-3_breadboard.svg",
			"width":"259.118",
			"height":"400",
			"points": [[62.5941, 333.05, 33.93, 33.9], [162.594, 333.05, 33.93, 33.9], [162.594, 33.05, 33.93, 33.9]]
		}, {
			"name":"Buzzer 12mm",
			"description":"Buzzer 12mmSpark Fun Electronics SKU: Comp-Buzzer",
			"image":"core\/breadboard\/sparkfun-electromechanical_buzzer-12mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buzzer-12mm_breadboard.svg",
			"width":"664.569",
			"height":"800",
			"points": [[315.319, 733.05, 33.93, 33.9], [315.319, 33.05, 33.93, 33.9]]
		}, {
			"name":"Power Jack",
			"description":"Power JackThis is the standard 5.5mm barrel jack for power.The PTH is the most common, proven, reliable, footprint.All others are experimental.The Slot footprint only works if the mill layer is transmitted to the PCB fab house so be warned.Spark Fun Electronics SKU: PRT-00119.Mating wall wart: TOL-00298(and others)",
			"image":"core\/breadboard\/sparkfun-connectors_power_jack_pth_lock_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_power_jack_pth_lock_breadboard.svg",
			"width":"554.333",
			"height":"1000",
			"points": [[210.202, 933.05, 33.93, 33.9], [310.202, 933.05, 33.93, 33.9], [310.202, 33.05, 33.93, 33.9]]
		}, {
			"name":"Schottky Diode",
			"description":"A standard schottky barrier rectifier diode",
			"image":"core\/breadboard\/diode.svg",
			"icon":"core\/breadboard\/diode.svg",
			"width":"29.879",
			"height":"7.2",
			"points": [[-0.989, 1.583, 3, 3], [24.576, 1.583, 3, 3]]
		}, {
			"name":"LIGHTPIPE-7511",
			"description":"Lightpipes provide High Contrast and Wide Viewing Angle for GreaterVisibility",
			"image":"core\/breadboard\/sparkfun-led_lightpipe-7511_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_lightpipe-7511_breadboard.svg",
			"width":"376",
			"height":"800",
			"points": []
		}, {
			"name":"BUTTONPAD-2X2",
			"description":"Proven layout and schematic for 2x2 button pad.Panelize this device\/fp to a 4x4 pad if needed.Spark Fun Electronics SKU: COM-07835.Compatible common cathode tri-color LED SKU: COM-00105",
			"image":"core\/breadboard\/sparkfun-electromechanical_buttonpad-2x2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buttonpad-2x2_breadboard.svg",
			"width":"2188.42",
			"height":"2400",
			"points": [[127.245, 2333.05, 33.93, 33.9], [127.245, 33.05, 33.93, 33.9], [227.245, 2333.05, 33.93, 33.9], [227.245, 33.05, 33.93, 33.9], [327.245, 2333.05, 33.93, 33.9], [327.245, 33.05, 33.93, 33.9], [427.245, 2333.05, 33.93, 33.9], [427.245, 33.05, 33.93, 33.9], [527.245, 2333.05, 33.93, 33.9], [527.245, 33.05, 33.93, 33.9], [627.245, 2333.05, 33.93, 33.9], [627.245, 33.05, 33.93, 33.9], [727.245, 2333.05, 33.93, 33.9], [727.245, 33.05, 33.93, 33.9], [827.245, 2333.05, 33.93, 33.9], [827.245, 33.05, 33.93, 33.9], [927.245, 2333.05, 33.93, 33.9], [927.245, 33.05, 33.93, 33.9], [1027.24, 2333.05, 33.93, 33.9], [1027.24, 33.05, 33.93, 33.9], [1127.25, 2333.05, 33.93, 33.9], [1127.25, 33.05, 33.93, 33.9], [1227.25, 2333.05, 33.93, 33.9], [1227.25, 33.05, 33.93, 33.9], [1327.25, 2333.05, 33.93, 33.9], [1327.25, 33.05, 33.93, 33.9], [1427.25, 2333.05, 33.93, 33.9], [1427.25, 33.05, 33.93, 33.9], [1527.25, 2333.05, 33.93, 33.9], [1527.25, 33.05, 33.93, 33.9], [1627.25, 2333.05, 33.93, 33.9], [1627.25, 33.05, 33.93, 33.9], [1727.25, 2333.05, 33.93, 33.9], [1727.25, 33.05, 33.93, 33.9], [1827.25, 2333.05, 33.93, 33.9], [1827.25, 33.05, 33.93, 33.9], [1927.25, 2333.05, 33.93, 33.9], [1927.25, 33.05, 33.93, 33.9], [2027.25, 2333.05, 33.93, 33.9], [2027.25, 33.05, 33.93, 33.9]]
		}, {
			"name":"LilyPad Tri-Color LED",
			"description":"Blink any color you need!Use the Tri-Color LED board as a simple indicator, or by pulsing the red, green, and blue channels, you can create any color.Very bright output.This is a common anode design-to turn on a channel you simply need to ground one of the R\/G\/B pins to illuminate that channel.LilyPad is a wearable technology developed by Leah Buechley and cooperatively designed by Leah and SparkFun.Each LilyPad was creatively designed to have large connecting pads to allow them to be sewn into clothing.Various input, output, power, and sensor boards are available.They 're even washable!Note: A portion of this sale is given back to Dr. Leah Buechley for continued development and education of e-textiles.Dimensions:20mm outer diameterThin 0.8mm PCB",
			"image":"core\/breadboard\/Tricolor-LED v16_breadboard.svg",
			"icon":"core\/breadboard\/Tricolor-LED v16_breadboard.svg",
			"width":"56.693",
			"height":"56.693",
			"points": [[6.511, 35.598, 6.808, 6.808], [43.374, 35.598, 6.808, 6.808], [24.942, 46.182, 6.808, 6.808], [24.942, 3.703, 6.808, 6.808]]
		}, {
			"name":"Battery Holders",
			"description":"Battery HoldersVarious common sizes : AA, AAA, 20mm coin cell and 12mm coin cell.",
			"image":"core\/breadboard\/sparkfun-electromechanical_battcon_12mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_battcon_12mm_breadboard.svg",
			"width":"762.792",
			"height":"800",
			"points": [[314.431, 733.05, 33.93, 33.9], [414.431, 733.05, 33.93, 33.9], [414.431, 33.05, 33.93, 33.9]]
		}, {
			"name":"Basic FET P-Channel",
			"description":"A MOSFET P-Channel Transistor",
			"image":"core\/breadboard\/mosfet_p_channel.svg",
			"icon":"core\/breadboard\/mosfet_p_channel.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"Header 1",
			"description":"Header 1Standard 1-pin 0.1 header. Use with straight break away headers (SKU : PRT-00116), right angle break away headers (PRT-00553), swiss pins (PRT-00743), machine pins (PRT-00117), and female headers (PRT-00115).",
			"image":"core\/breadboard\/sparkfun-connectors_smtra-256-8-6_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_smtra-256-8-6_breadboard.svg",
			"width":"6.6548",
			"height":"4.3434",
			"points": [[-0.4666, 0.3716, 3.6002, 3.6002], [3.5212, 0.3716, 3.6002, 3.6002], [-1, -1, 8.6548, 6.3434]]
		}, {
			"name":"Netduino Plus",
			"description":"An open-source electronics platform using the .NET Micro Framework",
			"image":"core\/breadboard\/NetduinoPlus.svg",
			"icon":"core\/breadboard\/NetduinoPlus.svg",
			"width":"201.78256",
			"height":"151.2",
			"points": [[72.951, 5.0094, 4.774, 4.773], [80.029, 5.0094, 4.772, 4.773], [87.107, 5.0094, 4.772, 4.773], [94.384, 5.0094, 4.774, 4.773], [101.66, 5.0094, 4.773, 4.773], [108.64, 5.0094, 4.772, 4.773], [116.02, 5.0094, 4.773, 4.773], [123.19, 5.0094, 4.773, 4.773], [134.67, 4.9103, 4.772, 4.773], [141.84, 4.9103, 4.773, 4.773], [148.82, 4.9103, 4.772, 4.773], [156.2, 4.9103, 4.772, 4.773], [163.38, 4.9103, 4.774, 4.773], [170.45, 4.9103, 4.772, 4.773], [177.73, 4.9103, 4.771, 4.773], [185.01, 4.9103, 4.774, 4.773], [98.573, 141.59, 4.774, 4.771], [105.87, 141.59, 4.774, 4.771], [113.17, 141.59, 4.773, 4.771], [120.15, 141.59, 4.772, 4.771], [127.52, 141.59, 4.774, 4.771], [134.7, 141.59, 4.773, 4.771], [148.87, 141.69, 4.771, 4.771], [156.14, 141.69, 4.773, 4.771], [163.42, 141.69, 4.773, 4.771], [170.4, 141.69, 4.772, 4.771], [177.77, 141.69, 4.772, 4.771], [184.95, 141.69, 4.771, 4.771]]
		}, {
			"name":"AD5206 Digital Potentiometer",
			"description":"Digital potentiometer. 6 channels with SPI-compatible interface.",
			"image":"core\/breadboard\/AD5206_Digital_Potentiometer__1569b6e5e5.svg",
			"icon":"core\/breadboard\/AD5206_Digital_Potentiometer__1569b6e5e5.svg",
			"width":"86.4",
			"height":"23.76",
			"points": [[1.52, 19.636, 4.16, 5.124], [1.52, -1, 4.16, 5.125], [80.72, 19.636, 4.159, 5.124], [80.72, -1, 4.159, 5.125], [8.72, 19.636, 4.159, 5.124], [8.72, -1, 4.159, 5.125], [15.92, 19.636, 4.16, 5.124], [15.92, -1, 4.16, 5.125], [23.12, 19.636, 4.16, 5.124], [23.12, -1, 4.16, 5.125], [30.32, 19.636, 4.16, 5.124], [30.32, -1, 4.16, 5.125], [37.52, 19.636, 4.16, 5.124], [37.52, -1, 4.16, 5.125], [44.72, 19.636, 4.159, 5.124], [44.72, -1, 4.159, 5.125], [51.92, 19.636, 4.16, 5.124], [51.92, -1, 4.16, 5.125], [59.12, 19.636, 4.16, 5.124], [59.12, -1, 4.16, 5.125], [66.32, 19.636, 4.16, 5.124], [66.32, -1, 4.16, 5.125], [73.52, 19.636, 4.16, 5.124], [73.52, -1, 4.16, 5.125]]
		}, {
			"name":"AS3400",
			"description":"Active noise cancellation chip.Stereo in, stereo out, two microphones.Single alkaline cell power.",
			"image":"core\/breadboard\/sparkfun-analogic_qfn-24_alt2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_qfn-24_alt2_breadboard.svg",
			"width":"1300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 333.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 333.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 333.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Hex Inverter Schmitt Trigger SN74HC14",
			"description":"A Hex inverting Schmitt trigger",
			"image":"core\/breadboard\/SN74HC14N_Schmitt_Trigger_breadboard.svg",
			"icon":"core\/breadboard\/SN74HC14N_Schmitt_Trigger_breadboard.svg",
			"width":"50.4",
			"height":"23.76",
			"points": [[1.52, 19.636, 4.16, 5.124], [1.52, -1, 4.16, 5.125], [44.72, 19.636, 4.158, 5.124], [44.72, -1, 4.158, 5.125], [8.72, 19.636, 4.158, 5.124], [8.72, -1, 4.158, 5.125], [15.92, 19.636, 4.16, 5.124], [15.92, -1, 4.16, 5.125], [23.12, 19.636, 4.16, 5.124], [23.12, -1, 4.16, 5.125], [30.32, 19.636, 4.16, 5.124], [30.32, -1, 4.16, 5.125], [37.52, 19.636, 4.16, 5.124], [37.52, -1, 4.16, 5.125]]
		}, {
			"name":"Modified Pico",
			"description":"Arduino compatible microcontroller. http:\/\/www.modifiedelectronics.com",
			"image":"core\/breadboard\/controller_pico.svg",
			"icon":"core\/breadboard\/controller_pico.svg",
			"width":"50.4",
			"height":"118.8",
			"points": [[1.469, 1.442, 4.324, 4.304], [1.469, 73.509, 4.299, 4.313], [1.469, 8.637, 4.316, 4.281], [1.492, 80.712, 4.296, 4.295], [1.469, 30.241, 4.318, 4.276], [1.469, 37.461, 4.316, 4.264], [1.469, 15.838, 4.298, 4.268], [1.469, 44.659, 4.322, 4.308], [1.469, 51.88, 4.313, 4.274], [1.469, 59.062, 4.283, 4.324], [1.469, 23.048, 4.324, 4.26], [1.469, 66.257, 4.299, 4.324], [44.384, 1.426, 4.281, 4.286], [44.372, 37.455, 4.293, 4.305], [44.394, 30.242, 4.271, 4.287], [44.358, 23.028, 4.307, 4.324], [44.385, 51.855, 4.279, 4.304], [44.36, 15.842, 4.305, 4.266], [44.385, 73.475, 4.278, 4.346], [44.364, 66.259, 4.301, 4.339], [44.378, 59.068, 4.287, 4.313], [44.361, 44.679, 4.304, 4.276], [44.351, 8.62, 4.313, 4.295], [44.362, 80.714, 4.303, 4.287]]
		}, {
			"name":"Serial Alphanumeric Display Driver",
			"description":"\tThe Serial Alphanumeric Display Driver allows you to communicate with alphanumeric displays over a simple SPI interface. Based on the A6282 IC, these boards work well with all of our alphanumeric displays and we have even provided a library listed below.\tYou can daisy-chain as many displays as you would like to create scrolling messages. Each board has both input and output headers that connect to each other. All you need to do is define the number of displays and your message. Check the example code below.\tNote: This product includes only the carrier board. You will need to provide your own alphanumeric display. Check the related products below for ones that will work.\tDocuments:\t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet (A6282)\t\t\tExample Arduino Code\t\t\tArduino Library",
			"image":"core\/breadboard\/AlphaNumericDisplay-v13_breadboard.svg",
			"icon":"core\/breadboard\/AlphaNumericDisplay-v13_breadboard.svg",
			"width":"82.2953",
			"height":"151.2",
			"points": [[-14.9067, 267.503, 4.83465, 10.50392], [-22.1067, 281.903, 4.83465, 10.50392], [-29.3066, 296.303, 4.83465, 10.50392], [-36.5066, 310.703, 4.83465, 10.50392], [-43.7066, 325.103, 4.83465, 10.50392], [-50.9066, 339.503, 4.83465, 10.50392], [29.4724, 109.182, 10.50392, 4.83465], [29.4724, 116.382, 10.50392, 4.83465], [29.4724, 123.582, 10.50392, 4.83465], [29.4724, 130.782, 10.50392, 4.83465], [29.4724, 137.982, 10.50392, 4.83465], [29.4724, 145.182, 10.50392, 4.83465], [64.50868, 18.75748, 5.68504, 5.68504], [64.50868, 25.95748, 5.68504, 5.68504], [64.50868, 33.15748, 5.68504, 5.68504], [64.50868, 40.35748, 5.68504, 5.68504], [64.50868, 54.75748, 5.68504, 5.68504], [64.50868, 61.95748, 5.68504, 5.68504], [64.50868, 76.35748, 5.68504, 5.68504], [64.50868, 83.55748, 5.68504, 5.68504], [64.50868, 90.75748, 5.68504, 5.68504], [64.50868, 97.95748, 5.68504, 5.68504], [14.10868, 97.95748, 5.68504, 5.68504], [14.10868, 90.75748, 5.68504, 5.68504], [14.10868, 83.55748, 5.68504, 5.68504], [14.10868, 76.35748, 5.68504, 5.68504], [14.10868, 61.95748, 5.68504, 5.68504], [14.10868, 54.75748, 5.68504, 5.68504], [14.10868, 40.35748, 5.68504, 5.68504], [14.10868, 33.15748, 5.68504, 5.68504], [14.10868, 25.95748, 5.68504, 5.68504], [14.10868, 18.75748, 5.68504, 5.68504]]
		}, {
			"name":"ZG2100M",
			"description":"WiFi transceiver module",
			"image":"core\/breadboard\/sparkfun-rf_zg2100m_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_zg2100m_breadboard.svg",
			"width":"1800",
			"height":"1600",
			"points": [[33.035, 1533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 1533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 1533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 1533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 1533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 1533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 1533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 1533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 1533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 1533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 1533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 1533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 1533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 1533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 1533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 1533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 1533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 1533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"VS1000",
			"description":"OGG Vorbis codec",
			"image":"core\/breadboard\/LQFP-48_breadboard.svg",
			"icon":"core\/breadboard\/LQFP-48_breadboard.svg",
			"width":"172.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968], [116.651, 37.4516, 4.29896, 4.2968], [116.651, 1.4516, 4.29896, 4.2968], [123.851, 37.4516, 4.29896, 4.2968], [123.851, 1.4516, 4.29896, 4.2968], [131.051, 37.4516, 4.29896, 4.2968], [131.051, 1.4516, 4.29896, 4.2968], [138.251, 37.4516, 4.29896, 4.2968], [138.251, 1.4516, 4.29896, 4.2968], [145.451, 37.4516, 4.29896, 4.2968], [145.451, 1.4516, 4.29896, 4.2968], [152.65, 37.4516, 4.29896, 4.2968], [152.65, 1.4516, 4.29896, 4.2968], [159.85, 37.4516, 4.29896, 4.2968], [159.85, 1.4516, 4.29896, 4.2968], [167.05, 37.4516, 4.29896, 4.2968], [167.05, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Jumper",
			"description":"JumperBasic 0.1 spaced jumper. Use with breakaway headers.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s_breadboard.svg",
			"width":"246.307",
			"height":"400",
			"points": [[106.189, 333.05, 33.93, 33.9], [106.189, 33.05, 33.93, 33.9]]
		}, {
			"name":"LSM303 Breakout Board-Tilt-Compensated Compass",
			"description":"\tThe LSM303DLH is a triple axis accelerometer combined with a triple axis magnetic sensor. This breakout board uses the LSM303DLH to give a you the data you need to feed into a microcontroller and calculate tilt-compensated output.\tFeatures:\t\t\t+- 2\/4\/8 g dynamically selectable full-scale\t\t\t+-1.3 to +- 8.1 gauss magnetic field full-scale\t\t\t16-bit data out\t\t\tI2C interface\t\t\tEmbedded self-test\tDocuments:\t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet\t\t\tApplication Notes",
			"image":"core\/breadboard\/LSM303 breakout board-v11_breadboard.svg",
			"icon":"core\/breadboard\/LSM303 breakout board-v11_breadboard.svg",
			"width":"57.6",
			"height":"57.6",
			"points": [[0.548, 14.948, 6.104, 6.104], [0.548, 22.148, 6.104, 6.104], [0.548, 29.348, 6.104, 6.104], [0.548, 36.548, 6.104, 6.104], [50.948, 36.548, 6.104, 6.104], [50.948, 29.348, 6.104, 6.104], [50.948, 22.148, 6.104, 6.104], [50.948, 14.948, 6.104, 6.104]]
		}, {
			"name":"COMPUTER-PERIPHERAL-POWER",
			"description":"",
			"image":"core\/breadboard\/sparkfun-connectors_computer-peripheral-power_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_computer-peripheral-power_breadboard.svg",
			"width":"67.176",
			"height":"37.835",
			"points": [[21.788, 21.416, 9.2, 9.2], [7.388, 21.416, 9.2, 9.2], [36.188, 21.416, 9.2, 9.2], [50.588, 21.416, 9.2, 9.2]]
		}, {
			"name":"STM32F40x",
			"description":"STM32F405xx and STM32F407xx microcontroller in LQFP64 pinout. ARM Cortex-M4 32b MCU+FPU",
			"image":"core\/breadboard\/Frode_3.svg",
			"icon":"core\/breadboard\/Frode_3.svg",
			"width":"3300",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 533.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"LM4871",
			"description":"3W audio amplifier",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Unproven!",
			"description":"Stand-alone Linear Li-ion\/Li-polymer Charge Management ControllerPackages: DFN-10, MSOP-10Last modified: 8\/17\/10Unproven!",
			"image":"core\/breadboard\/sparkfun-poweric_msop-10_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_msop-10_breadboard.svg",
			"width":"500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"3-Axis Accelerometer Breakout",
			"description":"Accelerometer for sensing three-dimensional orientation\/acceleration on a breakout board. Compatible to the ADXL3xx series of sensor chips.",
			"image":"obsolete\/breadboard\/accelerometer-adxl.svg",
			"icon":"obsolete\/breadboard\/accelerometer-adxl.svg",
			"width":"51.024",
			"height":"51.084",
			"points": [[2.351, 4.847, 4.774, 4.774], [2.351, 12.151, 4.774, 4.774], [2.351, 19.454, 4.774, 4.774], [2.351, 26.758, 4.774, 4.774], [2.351, 34.06, 4.774, 4.774], [2.351, 41.363, 4.774, 4.774]]
		}, {
			"name":"Tri-Color LED SMD",
			"description":"Tri-Color LED SMDProven layout and schematic for triple color LED in SMD package-common anode. Spark Fun Electronics SKU : COM-07844",
			"image":"core\/breadboard\/sparkfun-led_led-tricolor-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_led-tricolor-smd_breadboard.svg",
			"width":"333.972",
			"height":"400",
			"points": [[100.021, 333.05, 33.93, 33.9], [100.021, 33.05, 33.93, 33.9], [200.021, 333.05, 33.93, 33.9], [200.021, 33.05, 33.93, 33.9]]
		}, {
			"name":"Jumper",
			"description":"JumperBasic 0.1 spaced jumper. Use with breakaway headers.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s-no_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s-no_breadboard.svg",
			"width":"243.565",
			"height":"400",
			"points": [[104.817, 333.05, 33.93, 33.9], [104.817, 33.05, 33.93, 33.9]]
		}, {
			"name":"Mini-USB _B_ connector with 5th pin broken out.",
			"description":"Mini-USB B connector with 5th pin broken out.Created new symbol breaking out 5th ID pin in mini\/micro USB connector spec. See: http:\/\/en.wikipedia.org\/wiki\/Mini_usb#Cables. Uses same footprint as 4-pin symbol. Also added pins to connect to mounting \/ shield pads if required (probably not generally needed as signals aren' t shielded once they leave the connector).",
			"image":"core\/breadboard\/sparkfun-connectors_usb-minib_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-minib_breadboard.svg",
			"width":"639.292",
			"height":"800",
			"points": [[102.681, 733.05, 33.93, 33.9], [202.681, 733.05, 33.93, 33.9], [202.681, 33.05, 33.93, 33.9], [302.681, 733.05, 33.93, 33.9], [302.681, 33.05, 33.93, 33.9], [402.681, 733.05, 33.93, 33.9], [402.681, 33.05, 33.93, 33.9], [502.681, 733.05, 33.93, 33.9], [502.681, 33.05, 33.93, 33.9]]
		}, {
			"name":"RGB LED(com.anode, rbg)",
			"description":"A 5mm tri-color LED with red, green and blue inside.Pin order: red-com.anode-blue-green",
			"image":"core\/breadboard\/led-rgb-4pin-anode-leg.svg",
			"icon":"core\/breadboard\/led-rgb-4pin-anode-leg.svg",
			"width":"23.76",
			"height":"32.55",
			"points": [[502.681, 33.05, 33.93, 33.9], [6.199, 21, 3, 3], [13.399, 21, 3, 3], [20.598, 21, 3, 3]]
		}, {
			"name":"FTDI Basic Programmer",
			"description":"This is the LilyPad revision of our FTDI Basic.It is the same as our other FTDI Basic, but has a purple LilyPad board which is half the thickness. This is a basic breakout board for the FTDI FT232RL USB to serial IC.The pinout of this board matches the FTDI cable to work with official Arduino and cloned 5V Arduino boards.It can also be used for general serial applications.The major difference with this board is that it brings out the DTR pin as opposed to the RTS pin of the FTDI cable.The DTR pin allows an Arduino target to auto-reset when a new Sketch is downloaded.This is a really nice feature to have and allows a sketch to be downloaded without having to hit the reset button.This board will auto reset any Arduino board that has the reset pin brought out to a 6-pin connector.  The pins labeled BLK and GRN correspond to the colored wires on the FTDI cable.The black wire on the FTDI cable is GND, green is CTS.Use these BLK and GRN pins to align the FTDI basic board with your Arduino target.  This board has TX and RX LEDs that make it a bit better to use over the FTDI cable.You can actually see serial traffic on the LEDs to verify if the board is working.  This board was designed to decrease the cost of Arduino development and increase ease of use(the auto-reset feature rocks!).Our Arduino Pro boards and LilyPads use this type of connector.  One of the nice features of this board is a jumper on the back of the board that allows the board to be configured to either 3.3V or 5V(both power output and IO level).This board ship as 5V, but you can cut the default trace and add a solder jumper if you need to switch to 3.3V. Note: A portion of this sale is given back to Dr.Leah Buechley for continued development and education of e-textiles.  Documents:    Schematic   Eagle Files   FTDI Drivers",
			"image":"core\/breadboard\/FTDI Basic-v13_lily_breadboard.svg",
			"icon":"core\/breadboard\/FTDI Basic-v13_lily_breadboard.svg",
			"width":"77.9242",
			"height":"43.2",
			"points": [[4.328, 36.728, 5.744, 5.744], [4.328, 29.528, 5.744, 5.744], [4.328, 22.328, 5.744, 5.744], [4.328, 15.128, 5.744, 5.744], [4.328, 7.928, 5.744, 5.744], [4.328, 0.728, 5.744, 5.744]]
		}, {
			"name":"M5450 LED Driver",
			"description":"The M5450 is a monolithic MOS integrated circuit produced with an N-channel silicon gate technology.A single pin controls the LED display brightness by setting a reference current through a variable resistor connected to Vdd or to a separate supply of 13.2V maximum.",
			"image":"core\/breadboard\/M5450_LED_Driver_breadboard.svg",
			"icon":"core\/breadboard\/M5450_LED_Driver_breadboard.svg",
			"width":"2000",
			"height":"630",
			"points": [[34, 585.6, 32, 45.4], [34, -1, 32, 45.4], [1934, 585.6, 32, 45.4], [1934, -1, 32, 45.4], [134, -1, 32, 45.4], [234, -1, 32, 45.4], [334, -1, 32, 45.4], [434, -1, 32, 45.4], [534, -1, 32, 45.4], [634, -1, 32, 45.4], [734, -1, 32, 45.4], [834, -1, 32, 45.4], [934, -1, 32, 45.4], [1034, -1, 32, 45.4], [1134, -1, 32, 45.4], [1234, -1, 32, 45.4], [1334, -1, 32, 45.4], [1434, -1, 32, 45.4], [1534, -1, 32, 45.4], [1634, -1, 32, 45.4], [1734, -1, 32, 45.4], [1834, -1, 32, 45.4], [134, 585.6, 32, 45.4], [234, 585.6, 32, 45.4], [334, 585.6, 32, 45.4], [434, 585.6, 32, 45.4], [534, 585.6, 32, 45.4], [634, 585.6, 32, 45.4], [734, 585.6, 32, 45.4], [834, 585.6, 32, 45.4], [934, 585.6, 32, 45.4], [1034, 585.6, 32, 45.4], [1134, 585.6, 32, 45.4], [1234, 585.6, 32, 45.4], [1334, 585.6, 32, 45.4], [1434, 585.6, 32, 45.4], [1534, 585.6, 32, 45.4], [1634, 585.6, 32, 45.4], [1734, 585.6, 32, 45.4], [1834, 585.6, 32, 45.4]]
		}, {
			"name":"Generic male header-10 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_10.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_10.svg",
			"width":"71.99",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791], [37.199, 1.204, 4.791, 4.791], [44.398, 1.204, 4.791, 4.791], [51.597, 1.204, 4.791, 4.791], [58.796, 1.204, 4.791, 4.791], [65.995, 1.204, 4.791, 4.791]]
		}, {
			"name":"PICAXE-14M",
			"description":"PICAXE-14M from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_14M_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_14M_breadboard.svg",
			"width":"70.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34]]
		}, {
			"name":"Generic male header-2 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_2.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_2.svg",
			"width":"14.398",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791]]
		}, {
			"name":"Battery Holders",
			"description":"Battery HoldersVarious common sizes: AA, AAA, 20mm coin cell and 12mm coin cell.",
			"image":"core\/breadboard\/sparkfun-electromechanical_battery_20mm_pth_compact_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_battery_20mm_pth_compact_breadboard.svg",
			"width":"66.223",
			"height":"58.225",
			"points": [[-0.64, 22.528, 7.976, 7.976], [58.887, 22.528, 7.976, 7.976]]
		}, {
			"name":"Header 6",
			"description":"Header 6Standard 6-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).Molex polarized connector foot print use with SKU: PRT-08094 with associated crimp pins and housings.NOTES ON THE VARIANTS LOCK and LOCK_LONGPADS...This footprint was designed to help hold the alignment of a through-hole component(i.e.6-pin header)while soldering it into place.You may notice that each hole has been shifted either up or down by 0.005 of an inch from it 's more standard position (which is a perfectly straight line). This slight alteration caused the pins (the squares in the middle) to touch the edges of the holes. Because they are alternating, it causes a brace to hold the component in place. 0.005 has proven to be the perfect amount of off-center position when using our standard breakaway headers.Although looks a little odd when you look at the bare footprint, once you have a header in there, the alteration is very hard to notice. Also,if you push a header all the way into place, it is covered up entirely on the bottom side. This idea of altering the position of holes to aid alignment will be further integrated into the Sparkfun Library for other footprints. It can help hold any component with 3 or more connection pins.",
			"image":"core\/breadboard\/sparkfun-connectors_1x06-smd-female_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_1x06-smd-female_breadboard.svg",
			"width":"15.4032",
			"height":"11.4",
			"points": [[12.5416, 8.24, 3.02, 4.16], [10.0016, 8.24, 3.02, 4.16], [7.4616, 8.24, 3.02, 4.16], [4.9216, 8.24, 3.02, 4.16], [2.3816, 8.24, 3.02, 4.16], [-0.1584, 8.24, 3.02, 4.16], [-0.1584, -1, 3.02, 4.16], [2.3816, -1, 3.02, 4.16], [4.9216, -1, 3.02, 4.16], [7.4616, -1, 3.02, 4.16], [10.0016, -1, 3.02, 4.16], [12.5416, -1, 3.02, 4.16]]
		}, {
			"name":"dquidio board",
			"description":"the dquidio board. for more information visit:http:\/\/www.dquid.com\/landing\/dquid-io",
			"image":"core\/breadboard\/dquidio_breadboard.svg",
			"icon":"core\/breadboard\/dquidio_breadboard.svg",
			"width":"141.66",
			"height":"144.447",
			"points": [[36.251, 130.378, 4.16, 5.125], [136.639, 88.081, 5.125, 4.16], [101.057, 137.599, 4.16, 5.125], [0.063, 23.196, 5.125, 4.16], [136.639, 80.88, 5.125, 4.16], [136.639, 73.681, 5.125, 4.156], [136.639, 66.48, 5.125, 4.16], [136.639, 59.28, 5.125, 4.16], [136.639, 52.081, 5.125, 4.16], [136.639, 44.881, 5.125, 4.159], [136.639, 37.68, 5.125, 4.156], [136.639, 30.48, 5.125, 4.16], [136.639, 23.28, 5.125, 4.16], [0.063, 87.997, 5.125, 4.16], [0.063, 80.796, 5.125, 4.16], [0.063, 73.597, 5.125, 4.156], [0.063, 66.396, 5.125, 4.16], [0.063, 59.196, 5.125, 4.16], [0.063, 51.997, 5.125, 4.16], [0.063, 44.797, 5.125, 4.159], [0.063, 37.596, 5.125, 4.156], [0.063, 30.396, 5.125, 4.16], [43.452, 130.378, 4.16, 5.125], [50.652, 130.378, 4.16, 5.125], [57.852, 130.378, 4.16, 5.125], [65.052, 130.378, 4.16, 5.125], [72.252, 130.378, 4.16, 5.125], [79.451, 130.378, 4.16, 5.125], [86.652, 130.378, 4.16, 5.125], [93.852, 130.378, 4.16, 5.125], [101.053, 130.378, 4.16, 5.125], [36.256, 137.599, 4.16, 5.125], [43.455, 137.599, 4.16, 5.125], [50.656, 137.599, 4.16, 5.125], [57.855, 137.599, 4.16, 5.125], [65.057, 137.599, 4.16, 5.125], [72.256, 137.599, 4.16, 5.125], [79.455, 137.599, 4.16, 5.125], [86.656, 137.599, 4.16, 5.125], [93.855, 137.599, 4.16, 5.125]]
		}
	]
}, {
	"page":"16",
	"count": 37,
	"el": [{
			"name":"EDISON",
			"description":"The Intel\u00ae Edison is a compact computing platform that' s small by design so you can easily integrate it into projects.It 's primarily designed for \"Internet of Things\"projects and is pretty powerful for its small size. The Edison has a bunch of features that makes it appealing for makers of all skill levels. It uses a 22 nm Intel SoC that includes a dual core, dual threaded Intel Atom CPU at 500MHz and a 32-bit Intel\u00ae Quark microctroller which runs at 100 MHz. It' s a lot of power for a board that 's about the size of an LED Matrix.The board supports 40 GPIOs and includes 1 GB LPDDR3, 4 GB EMMC, and has dual-band WiFI and BTLE-which makes it essentially wireless.The tiny Edison fits nicely onto a breakout board-sort of like a tiny IoT sparrow into a very small nest-so you can expose the native 1.8 V I\/O of the Edison. The breakout board has a power supply, USB serial, USB OTG port and power switch, an I\/O header, and a battery charger. Together, there' s seamless device-to-device and device-to-cloud communication.",
			"image":"core\/breadboard\/intel_edison_minibreakout_breadboard.svg",
			"icon":"core\/breadboard\/intel_edison_minibreakout_breadboard.svg",
			"width":"174.398",
			"height":"82.541",
			"points": []
		}, {
			"name":"OSCILLATOR",
			"description":"Generic 5x3 and 7x5 oscillators",
			"image":"core\/breadboard\/sparkfun-freqctrl_crystal-osc-smd-5x3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-freqctrl_crystal-osc-smd-5x3_breadboard.svg",
			"width":"330.461",
			"height":"400",
			"points": [[98.2653, 333.05, 33.93, 33.9], [98.2653, 33.05, 33.93, 33.9], [198.265, 333.05, 33.93, 33.9], [198.265, 33.05, 33.93, 33.9]]
		}, {
			"name":"LUXEON-REBEL",
			"description":"Luxeon Rebel single-color high output LED",
			"image":"core\/breadboard\/sparkfun-led_luxeon-rebel_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_luxeon-rebel_breadboard.svg",
			"width":"393.583",
			"height":"600",
			"points": [[129.826, 533.05, 33.93, 33.9], [229.826, 533.05, 33.93, 33.9], [229.826, 33.05, 33.93, 33.9]]
		}, {
			"name":"Basic Force Sensing Resistor(FSR)",
			"description":"A generic force sensitive resistor",
			"image":"core\/breadboard\/basic_fsr.svg",
			"icon":"core\/breadboard\/basic_fsr.svg",
			"width":"70",
			"height":"218.5",
			"points": [[26.02, 212.338, 8, 7.162], [35.981, 212.286, 8, 7.217]]
		}, {
			"name":"AVR 10-pin ICSP Header",
			"description":"AVR 10-pin ICSP Header This is the standard AVR In Circuit Serial Programming header.Minimal, but includes pin one indicator.Works with standard Olimex programmers.Also look for the 6-pin reduced version.Spark Fun Electronics SKU: PRT-00778",
			"image":"core\/breadboard\/sparkfun-connectors_avr_icsp_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_avr_icsp_breadboard.svg",
			"width":"57.6",
			"height":"36.918",
			"points": [[12.239, 17.928, 4.296, 4.296], [19.439, 17.928, 4.296, 4.296], [26.639, 17.929, 4.296, 4.296], [33.841, 17.928, 4.296, 4.296], [41.04, 17.928, 4.296, 4.296], [12.239, 25.129, 4.296, 4.296], [19.439, 25.129, 4.296, 4.296], [26.639, 25.129, 4.296, 4.296], [33.841, 25.129, 4.296, 4.296], [41.04, 25.129, 4.296, 4.296]]
		}, {
			"name":"USB Connectors",
			"description":"USB ConnectorsUSB-B-PTH is fully proven SKU: PRT-00139USB-miniB is fully proven SKU: PRT-00587USB-A-PCB is untested.USB-A-H is throughly reviewed, but untested.Spark Fun Electronics SKU: PRT-00437USB-B-SMT is throughly reviewed, but untested.Needs silkscreen touching up.USB-A-S has not been used\/testedUSB-MB-H has not been used\/tested",
			"image":"core\/breadboard\/sparkfun-connectors_usb-b-pth_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-b-pth_breadboard.svg",
			"width":"593.375",
			"height":"800",
			"points": [[179.722, 733.05, 33.93, 33.9], [179.722, 33.05, 33.93, 33.9], [279.722, 733.05, 33.93, 33.9], [279.722, 33.05, 33.93, 33.9], [379.722, 733.05, 33.93, 33.9], [379.722, 33.05, 33.93, 33.9]]
		}, {
			"name":"25LC080",
			"description":"25LC080 SPI EEPROM",
			"image":"core\/breadboard\/25LC080_breadboard.svg",
			"icon":"core\/breadboard\/25LC080_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"Arduino Pro Mini v13",
			"description":"It 's blue! It' s thin!It 's the Arduino Pro Mini! SparkFun' s minimal design approach to Arduino.This is a 5V Arduino running the 16MHz bootloader.Arduino Pro Mini does not come with connectors populated so that you can solder in any connector or wire with any orientation you need.We recommend first time Arduino users start with the Uno R3.It 's a great board that will get you up and running quickly. The Arduino Pro series is meant for users that understand the limitations of system voltage (5V), lack of connectors, and USB off board.We really wanted to minimize the cost of an Arduino. In order to accomplish this we used all SMD components, made it two layer, etc. This board connects directly to the FTDI Basic Breakout board and supports auto-reset. The Arduino Pro Mini also works with the FTDI cable but the FTDI cable does not bring out the DTR pin so the auto-reset feature will not work. There is a voltage regulator on board so it can accept voltage up to 12VDC. If you' re supplying unregulated power to the board, be sure to connect to the \"RAW \"pin on not VCC.The latest and greatest version of this board breaks out the ADC6 and ADC7 pins as well as adds footprints for optional I2C pull-up resistors!We also took the opportunity to slap it with the OSHW logo.",
			"image":"core\/breadboard\/Arduino-Pro-Mini-v13_breadboard.svg",
			"icon":"core\/breadboard\/Arduino-Pro-Mini-v13_breadboard.svg",
			"width":"50.4",
			"height":"93.6",
			"points": [[40.148, 0.548, 6.104, 6.104], [32.948, 0.548, 6.104, 6.104], [25.748, 0.548, 6.104, 6.104], [18.548, 0.548, 6.104, 6.104], [11.348, 0.548, 6.104, 6.104], [4.148, 0.548, 6.104, 6.104], [35.468, 39.788, 6.104, 6.104], [35.468, 32.588, 6.104, 6.104], [43.748, 7.748, 6.104, 6.104], [43.748, 14.948, 6.104, 6.104], [43.748, 22.148, 6.104, 6.104], [43.748, 29.348, 6.104, 6.104], [43.748, 36.548, 6.104, 6.104], [43.748, 43.748, 6.104, 6.104], [43.748, 50.948, 6.104, 6.104], [43.748, 58.148, 6.104, 6.104], [43.748, 65.348, 6.104, 6.104], [43.748, 72.548, 6.104, 6.104], [43.748, 79.748, 6.104, 6.104], [43.748, 86.948, 6.104, 6.104], [0.548, 86.948, 6.104, 6.104], [0.548, 79.748, 6.104, 6.104], [0.548, 72.548, 6.104, 6.104], [0.548, 65.348, 6.104, 6.104], [0.548, 58.148, 6.104, 6.104], [0.548, 50.948, 6.104, 6.104], [0.548, 43.748, 6.104, 6.104], [0.548, 36.548, 6.104, 6.104], [0.548, 29.348, 6.104, 6.104], [0.548, 22.148, 6.104, 6.104], [0.548, 14.948, 6.104, 6.104], [0.548, 7.748, 6.104, 6.104]]
		}, {
			"name":"Arduino Fio(Funnel I\/O)",
			"description":"The Arduino Funnel I\/O(Fio)is a board designed by Shigeru Kobayashi, based on the original design from LilyPad.Funnel is a toolkit to sketch your idea physically, and consists of software libraries and hardware.By using Funnel, the user can interface to sensors and\/or actuators with various programming languages such as ActionScript 3, Processing, and Ruby.Arduino Fio is compatible with Funnel.It has connections for a Lithium Polymer battery and includes a charge circuit over USB.An XBee socket is available on the bottom of the board.The Fio has been designed to be wirelessly reprogrammable.Checkout our tutorial on wireless bootloading!",
			"image":"core\/breadboard\/Arduino-Fio-v22_bottom_breadboard.svg",
			"icon":"core\/breadboard\/Arduino-Fio-v22_bottom_breadboard.svg",
			"width":"186.504",
			"height":"79.297",
			"points": [[94.148, 69.045, 6.104, 6.104], [86.948, 69.045, 6.104, 6.104], [79.746, 69.045, 6.104, 6.104], [72.548, 69.045, 6.104, 6.104], [65.347, 69.045, 6.104, 6.104], [58.148, 69.045, 6.104, 6.104], [50.948, 69.045, 6.104, 6.104], [43.746, 69.045, 6.104, 6.104], [36.548, 69.045, 6.104, 6.104], [29.347, 69.045, 6.104, 6.104], [22.148, 69.045, 6.104, 6.104], [14.948, 69.045, 6.104, 6.104], [7.746, 69.045, 6.104, 6.104], [0.548, 69.045, 6.104, 6.104], [148.148, 25.845, 6.104, 6.104], [148.148, 18.645, 6.104, 6.104], [25.746, 43.844, 6.104, 6.104], [32.948, 43.844, 6.104, 6.104], [25.746, 36.645, 6.104, 6.104], [32.948, 36.645, 6.104, 6.104], [25.746, 29.446, 6.104, 6.104], [32.948, 29.446, 6.104, 6.104], [94.148, 4.245, 6.104, 6.104], [86.948, 4.245, 6.104, 6.104], [79.746, 4.245, 6.104, 6.104], [72.548, 4.245, 6.104, 6.104], [65.347, 4.245, 6.104, 6.104], [58.148, 4.245, 6.104, 6.104], [50.948, 4.245, 6.104, 6.104], [43.746, 4.245, 6.104, 6.104], [36.548, 4.245, 6.104, 6.104], [29.347, 4.245, 6.104, 6.104], [22.148, 4.245, 6.104, 6.104], [14.948, 4.245, 6.104, 6.104], [7.746, 4.245, 6.104, 6.104], [0.548, 4.245, 6.104, 6.104], [148.148, 51.045, 6.104, 6.104], [148.148, 43.844, 6.104, 6.104], [108.548, 27.645, 6.104, 6.104], [115.748, 27.645, 6.104, 6.104], [115.748, 47.444, 6.104, 6.104], [108.548, 47.444, 6.104, 6.104]]
		}, {
			"name":"Capacitor",
			"description":"CapacitorStandard 0603 ceramic capacitor, and 0.1 leaded capacitor.",
			"image":"core\/breadboard\/sparkfun-passives_axial-5mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_axial-5mm_breadboard.svg",
			"width":"6.8796",
			"height":"1.8796",
			"points": [[-0.7551, -0.7551, 3.3898, 3.3898], [4.2449, -0.7551, 3.3898, 3.3898]]
		}, {
			"name":"MOSFET-NCHANNEL-SOIC8",
			"description":"IRF9410 and NDS8434 SOIC-8 parts.",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Chip antenna",
			"description":"Chip antennaSingle endded antenna.Common with smaller chip antennas.CHIP4 package is the GPS Chip Antenna SKU: GPS-08418.CHIP5 package is 2.4GHz chip antenna SKU: WRL-00144.",
			"image":"core\/breadboard\/sparkfun-rf_antenna-chip2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_antenna-chip2_breadboard.svg",
			"width":"239",
			"height":"400",
			"points": [[102.535, 333.05, 33.93, 33.9], [102.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"SPM0204UD5",
			"description":"Ultrasonic range sensor",
			"image":"core\/breadboard\/sparkfun-sensors_spm0204ud5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_spm0204ud5_breadboard.svg",
			"width":"400.389",
			"height":"400",
			"points": [[133.23, 333.05, 33.93, 33.9], [133.23, 33.05, 33.93, 33.9], [233.23, 333.05, 33.93, 33.9], [233.23, 33.05, 33.93, 33.9]]
		}, {
			"name":"MAGJACK-2",
			"description":"RJ-45 with LEDs",
			"image":"core\/breadboard\/sparkfun-connectors_magjack-19938_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_magjack-19938_breadboard.svg",
			"width":"841.236",
			"height":"1000",
			"points": [[103.653, 933.05, 33.93, 33.9], [103.653, 33.05, 33.93, 33.9], [203.653, 933.05, 33.93, 33.9], [203.653, 33.05, 33.93, 33.9], [303.653, 933.05, 33.93, 33.9], [303.653, 33.05, 33.93, 33.9], [403.653, 933.05, 33.93, 33.9], [403.653, 33.05, 33.93, 33.9], [503.653, 933.05, 33.93, 33.9], [503.653, 33.05, 33.93, 33.9], [603.653, 933.05, 33.93, 33.9], [603.653, 33.05, 33.93, 33.9], [703.653, 933.05, 33.93, 33.9], [703.653, 33.05, 33.93, 33.9]]
		}, {
			"name":"SIM908",
			"description":"",
			"image":"core\/breadboard\/sim908_sim908_breadboard.svg",
			"icon":"core\/breadboard\/sim908_sim908_breadboard.svg",
			"width":"176.25",
			"height":"174.2",
			"points": [[2.5419999999999, 154.063, 3.739, 3.68], [2.5419999999999, 17.282, 3.739, 3.68], [2.5419999999999, 146.864, 3.739, 3.682], [2.5419999999999, 139.665, 3.739, 3.682], [2.5419999999999, 132.466, 3.739, 3.682], [2.5419999999999, 125.267, 3.739, 3.682], [2.5419999999999, 118.067, 3.739, 3.682], [2.5419999999999, 110.868, 3.739, 3.682], [2.5419999999999, 103.671, 3.739, 3.68], [2.5419999999999, 96.472, 3.739, 3.681], [2.5419999999999, 89.272, 3.739, 3.68], [2.5419999999999, 82.073, 3.739, 3.68], [2.5419999999999, 74.874, 3.739, 3.68], [2.5419999999999, 67.675, 3.739, 3.68], [2.5419999999999, 60.475, 3.739, 3.68], [2.5419999999999, 53.276, 3.739, 3.682], [2.5419999999999, 46.079, 3.739, 3.68], [2.5419999999999, 38.878, 3.739, 3.682], [2.5419999999999, 31.679, 3.739, 3.682], [2.5419999999999, 24.481, 3.739, 3.68], [168.144, 154.095, 3.737, 3.701], [168.144, 17.331, 3.737, 3.7], [168.144, 146.897, 3.737, 3.701], [168.144, 139.698, 3.737, 3.701], [168.144, 132.501, 3.737, 3.699], [168.144, 125.302, 3.737, 3.701], [168.144, 118.105, 3.737, 3.701], [168.144, 110.907, 3.737, 3.699], [168.144, 103.708, 3.737, 3.701], [168.144, 96.511, 3.737, 3.701], [168.144, 89.312, 3.737, 3.701], [168.144, 82.114, 3.737, 3.7], [168.144, 74.915, 3.737, 3.701], [168.144, 67.718, 3.737, 3.701], [168.144, 60.52, 3.737, 3.699], [168.144, 53.321, 3.737, 3.701], [168.144, 46.124, 3.737, 3.699], [168.144, 38.925, 3.737, 3.701], [168.144, 31.726, 3.737, 3.701], [168.144, 24.529, 3.737, 3.7], [16.947, 168.452, 3.683, 3.738], [24.149, 168.452, 3.684, 3.738], [31.349, 168.452, 3.685, 3.738], [38.551, 168.452, 3.684, 3.738], [45.753, 168.452, 3.684, 3.738], [52.954, 168.452, 3.684, 3.738], [60.155, 168.452, 3.683, 3.738], [67.358, 168.452, 3.683, 3.738], [74.558, 168.452, 3.685, 3.738], [81.76, 168.452, 3.684, 3.738], [88.962, 168.452, 3.683, 3.738], [96.163, 168.452, 3.684, 3.738], [103.365, 168.452, 3.683, 3.738], [110.567, 168.452, 3.683, 3.738], [117.767, 168.452, 3.685, 3.738], [124.969, 168.452, 3.684, 3.738], [132.171, 168.452, 3.683, 3.738], [139.372, 168.452, 3.684, 3.738], [146.573, 168.452, 3.684, 3.738], [153.776, 168.452, 3.683, 3.738], [153.822, 2.853, 3.699, 3.738], [146.62, 2.853, 3.7, 3.738], [132.216, 2.853, 3.7, 3.738], [125.012, 2.853, 3.7, 3.738], [117.81, 2.853, 3.701, 3.738], [110.609, 2.853, 3.699, 3.738], [103.406, 2.853, 3.699, 3.738], [96.203, 2.853, 3.701, 3.738], [89.002, 2.853, 3.7, 3.738], [81.799, 2.853, 3.701, 3.738], [74.596, 2.853, 3.701, 3.738], [67.395, 2.853, 3.7, 3.738], [60.194, 2.853, 3.699, 3.738], [52.989, 2.853, 3.701, 3.738], [45.787, 2.853, 3.701, 3.738], [38.586, 2.853, 3.7, 3.738], [31.383, 2.853, 3.701, 3.738], [24.18, 2.853, 3.701, 3.738], [16.979, 2.853, 3.7, 3.738], [139.417, 2.853, 3.701, 3.738]]
		}, {
			"name":"MLX90614",
			"description":"Non-contact PIR I2C interface temperature sensor",
			"image":"core\/breadboard\/sparkfun-sensors_to-39_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_to-39_breadboard.svg",
			"width":"568.597",
			"height":"800",
			"points": [[217.333, 733.05, 33.93, 33.9], [217.333, 33.05, 33.93, 33.9], [317.333, 733.05, 33.93, 33.9], [317.333, 33.05, 33.93, 33.9]]
		}, {
			"name":"SWITCH-DPDT",
			"description":"DPDT Version of the COM-00597",
			"image":"core\/breadboard\/sparkfun-electromechanical_ayz0202_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_ayz0202_breadboard.svg",
			"width":"485.097",
			"height":"400",
			"points": [[125.583, 333.05, 33.93, 33.9], [125.583, 33.05, 33.93, 33.9], [225.583, 333.05, 33.93, 33.9], [225.583, 33.05, 33.93, 33.9], [325.583, 333.05, 33.93, 33.9], [325.583, 33.05, 33.93, 33.9]]
		}, {
			"name":"Mystery Part-10 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 10 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part10.svg",
			"icon":"obsolete\/breadboard\/mystery_part10.svg",
			"width":"102",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002], [52.5, 24.672941, 5, 6.3400002], [62.5, 24.672941, 5, 6.3400002], [72.5, 24.672941, 5, 6.3400002], [82.5, 24.672941, 5, 6.3400002], [92.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"Momentary Switch",
			"description":"Momentary SwitchButton commonly used for reset or general input.Spark Fun Electronics SKU: COM-00097",
			"image":"core\/breadboard\/sparkfun-electromechanical_tactile_switch_smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_tactile_switch_smd_breadboard.svg",
			"width":"474.306",
			"height":"600",
			"points": [[170.188, 533.05, 33.93, 33.9], [170.188, 33.05, 33.93, 33.9], [270.188, 533.05, 33.93, 33.9], [270.188, 33.05, 33.93, 33.9]]
		}, {
			"name":"STA540",
			"description":"The STA540 is a 4-channel, class AB audio amplifier designed for high quality sound applications.",
			"image":"core\/breadboard\/sparkfun-poweric_multiwatt15_6400bgheatsink_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_multiwatt15_6400bgheatsink_breadboard.svg",
			"width":"1860.24",
			"height":"3000",
			"points": [[563.155, 2933.05, 33.93, 33.9], [663.155, 2933.05, 33.93, 33.9], [663.155, 33.05, 33.93, 33.9], [763.155, 2933.05, 33.93, 33.9], [763.155, 33.05, 33.93, 33.9], [863.155, 2933.05, 33.93, 33.9], [863.155, 33.05, 33.93, 33.9], [963.155, 2933.05, 33.93, 33.9], [963.155, 33.05, 33.93, 33.9], [1063.15, 2933.05, 33.93, 33.9], [1063.15, 33.05, 33.93, 33.9], [1163.15, 2933.05, 33.93, 33.9], [1163.15, 33.05, 33.93, 33.9], [1263.15, 2933.05, 33.93, 33.9], [1263.15, 33.05, 33.93, 33.9]]
		}, {
			"name":"V_REG_MIC5216",
			"description":"500mA LDO, MSOP8 for better dissipation",
			"image":"core\/breadboard\/sparkfun-poweric_msop8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_msop8_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Zener Diode",
			"description":"A standard zener diode",
			"image":"core\/breadboard\/diode.svg",
			"icon":"core\/breadboard\/diode.svg",
			"width":"29.879",
			"height":"7.2",
			"points": [[-0.989, 1.583, 3, 3], [24.576, 1.583, 3, 3]]
		}, {
			"name":"Shift Register Breakout-74HC595",
			"description":"This is a breakout for the SOIC version of the 74HC595 shift register IC.Clock in data and latch it to free up IO pins on your micro.All pins from the IC are broken out to standard 0.1' spaced headers.The Serial in and out pins are on opposite sides of the board with the remaining pins carried over so that multiple shift register boards can be chained together. Documents:    Schematic   Eagle Files   Datasheet(MM74HC595M)   bildr blog-74HC595 Project",
			"image":"core\/breadboard\/74HC595 Shift Reg Breakout-v11_breadboard.svg",
			"icon":"core\/breadboard\/74HC595 Shift Reg Breakout-v11_breadboard.svg",
			"width":"64.8",
			"height":"86.4",
			"points": [[0.548, 14.948, 6.104, 6.104], [0.548, 22.148, 6.104, 6.104], [0.548, 29.348, 6.104, 6.104], [0.548, 36.548, 6.104, 6.104], [0.548, 43.748, 6.104, 6.104], [0.548, 50.948, 6.104, 6.104], [0.548, 58.148, 6.104, 6.104], [0.548, 65.348, 6.104, 6.104], [14.948, 0.548, 6.104, 6.104], [22.148, 0.548, 6.104, 6.104], [29.348, 0.548, 6.104, 6.104], [36.548, 0.548, 6.104, 6.104], [43.748, 0.548, 6.104, 6.104], [50.948, 0.548, 6.104, 6.104], [58.148, 0.548, 6.104, 6.104], [14.948, 79.748, 6.104, 6.104], [22.148, 79.748, 6.104, 6.104], [29.348, 79.748, 6.104, 6.104], [36.548, 79.748, 6.104, 6.104], [43.748, 79.748, 6.104, 6.104], [50.948, 79.748, 6.104, 6.104], [58.148, 79.748, 6.104, 6.104]]
		}, {
			"name":"SCANTOOL",
			"description":"STN1110-Multiprotocol OBD II to UART Interpreter, QFN Package Change Log DateAuthorChange Aug 23, 2010vit @ scantool.netCreated device",
			"image":"core\/breadboard\/sparkfun-digitalic__stn_scantool_qfn-28-s_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic__stn_scantool_qfn-28-s_breadboard.svg",
			"width":"1500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"LCD-16X2",
			"description":"Standard text-only 16x2 parallel input LCD",
			"image":"core\/breadboard\/sparkfun-displays_lcd-16x2_nosilk_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-displays_lcd-16x2_nosilk_breadboard.svg",
			"width":"227.348",
			"height":"108.684",
			"points": [[19.913, 10.384, 6.104, 6.104], [27.114, 10.384, 6.104, 6.104], [34.313, 10.384, 6.104, 6.104], [41.513, 10.384, 6.104, 6.104], [48.713, 10.384, 6.104, 6.104], [55.913, 10.384, 6.104, 6.104], [63.114, 10.384, 6.104, 6.104], [70.313, 10.384, 6.104, 6.104], [77.513, 10.384, 6.104, 6.104], [84.713, 10.384, 6.104, 6.104], [91.913, 10.384, 6.104, 6.104], [99.114, 10.384, 6.104, 6.104], [106.313, 10.384, 6.104, 6.104], [113.513, 10.384, 6.104, 6.104], [120.714, 10.384, 6.104, 6.104], [127.913, 10.384, 6.104, 6.104]]
		}, {
			"name":"VS1002",
			"description":"MP3 decoder",
			"image":"core\/breadboard\/LQFP-48_breadboard.svg",
			"icon":"core\/breadboard\/LQFP-48_breadboard.svg",
			"width":"172.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968], [102.251, 37.4516, 4.29896, 4.2968], [102.251, 1.4516, 4.29896, 4.2968], [109.451, 37.4516, 4.29896, 4.2968], [109.451, 1.4516, 4.29896, 4.2968], [116.651, 37.4516, 4.29896, 4.2968], [116.651, 1.4516, 4.29896, 4.2968], [123.851, 37.4516, 4.29896, 4.2968], [123.851, 1.4516, 4.29896, 4.2968], [131.051, 37.4516, 4.29896, 4.2968], [131.051, 1.4516, 4.29896, 4.2968], [138.251, 37.4516, 4.29896, 4.2968], [138.251, 1.4516, 4.29896, 4.2968], [145.451, 37.4516, 4.29896, 4.2968], [145.451, 1.4516, 4.29896, 4.2968], [152.65, 37.4516, 4.29896, 4.2968], [152.65, 1.4516, 4.29896, 4.2968], [159.85, 37.4516, 4.29896, 4.2968], [159.85, 1.4516, 4.29896, 4.2968], [167.05, 37.4516, 4.29896, 4.2968], [167.05, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Generic female header-metal rounded-8 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_8.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_8.svg",
			"width":"57.432",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783], [15.556, 1.197, 4.783, 4.783], [22.735, 1.197, 4.783, 4.783], [29.914, 1.197, 4.783, 4.783], [37.093, 1.197, 4.783, 4.783], [44.272, 1.197, 4.783, 4.783], [51.451, 1.197, 4.783, 4.783]]
		}, {
			"name":"blueIOT core",
			"description":"Painting the Internet of Things Blue.blueIOT is an tiny little board in the size of an SD Card which comes with latest sensors formeasuring acceleration(3 axis), humidity, altitude and temperature.The integrated Bluetooth Low Energy(BLE)module is certified and allows easy communication with smartphones and home gateways.All this runs with a single coin cell battery at 3V while consumingin average 1uA in managed sleep mode.All this is a perfect basis for wearable, fitness tracker, beacons for in door navigation and more.Programming is supported with the Arduino IDE using an FTDI cable.For development there is an SD card slot for recording sensor data up to 32 GByte.For further extension blueIOT comes with exposed PINs for I2C bus,analog and digital I\/Os.OLEDs from Adafruit with I2C bus are supported right away.Further details and sample projects can be found on www.Fab-Lab.eu",
			"image":"core\/breadboard\/blueIOT_Rc1-final_breadboard.svg",
			"icon":"core\/breadboard\/blueIOT_Rc1-final_breadboard.svg",
			"width":"61.2",
			"height":"66.6",
			"points": [[2.348, 59.048, 6.104, 6.104], [2.348, 51.848, 6.104, 6.104], [2.348, 44.648, 6.104, 6.104], [2.348, 37.448, 6.104, 6.104], [2.348, 30.248, 6.104, 6.104], [2.348, 23.048, 6.104, 6.104], [2.348, 15.848, 6.104, 6.104], [2.348, 8.648, 6.104, 6.104], [2.348, 1.448, 6.104, 6.104], [52.747, 59.048, 6.104, 6.104], [52.747, 51.848, 6.104, 6.104], [52.747, 44.648, 6.104, 6.104], [52.747, 37.448, 6.104, 6.104], [52.747, 30.248, 6.104, 6.104], [52.747, 23.048, 6.104, 6.104], [52.747, 15.848, 6.104, 6.104], [52.747, 8.648, 6.104, 6.104], [52.747, 1.448, 6.104, 6.104], [45.548, 59.048, 6.104, 6.104]]
		}, {
			"name":"DIODE-ZENER",
			"description":"Zener DiodeProduction Part-81993.4V Zener Voltage",
			"image":"core\/breadboard\/sparkfun-discretesemi_sod-323_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sod-323_breadboard.svg",
			"width":"307.694",
			"height":"400",
			"points": [[136.882, 333.05, 33.93, 33.9], [136.882, 33.05, 33.93, 33.9]]
		}, {
			"name":"LTE-302",
			"description":"Through-hole side-firing 940nm IR LED",
			"image":"core\/breadboard\/sparkfun-led_lte-302_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-led_lte-302_breadboard.svg",
			"width":"13.232",
			"height":"35.113",
			"points": [[7.722, 31.682, 4.988, 4.988], [0.523, 31.682, 4.988, 4.988]]
		}, {
			"name":"Battery Holders",
			"description":"Battery HoldersVarious common sizes: AA, AAA, 20mm coin cell and 12mm coin cell.",
			"image":"core\/breadboard\/sparkfun-electromechanical_battcon_20mm_4legs_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_battcon_20mm_4legs_breadboard.svg",
			"width":"1059.46",
			"height":"1200",
			"points": [[412.764, 1133.05, 33.93, 33.9], [512.764, 1133.05, 33.93, 33.9], [512.764, 33.05, 33.93, 33.9], [612.764, 1133.05, 33.93, 33.9], [612.764, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic female header-metal rounded-4 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_4.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_4.svg",
			"width":"28.716",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783], [15.556, 1.197, 4.783, 4.783], [22.735, 1.197, 4.783, 4.783]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_panasonic_c_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_panasonic_c_breadboard.svg",
			"width":"16.725",
			"height":"32.901",
			"points": [[4.492, 30.058, 2.744, 3.844], [9.488, 30.058, 2.744, 3.844]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_panasonic_d_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_panasonic_d_breadboard.svg",
			"width":"21.156",
			"height":"41.847",
			"points": [[12.367, 36.878, 3.192, 5.969], [5.118, 36.878, 3.24, 5.969]]
		}, {
			"name":"USB Connectors",
			"description":"USB ConnectorsUSB-B-PTH is fully proven SKU: PRT-00139USB-miniB is fully proven SKU: PRT-00587USB-A-PCB is untested.USB-A-H is throughly reviewed, but untested.Spark Fun Electronics SKU: PRT-00437USB-B-SMT is throughly reviewed, but untested.Needs silkscreen touching up.USB-A-S has not been used\/testedUSB-MB-H has not been used\/tested",
			"image":"core\/breadboard\/sparkfun-connectors_usb-mb-h_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-mb-h_breadboard.svg",
			"width":"514.236",
			"height":"800",
			"points": [[90.153, 733.05, 33.93, 33.9], [190.153, 733.05, 33.93, 33.9], [190.153, 33.05, 33.93, 33.9], [290.153, 733.05, 33.93, 33.9], [290.153, 33.05, 33.93, 33.9], [390.153, 733.05, 33.93, 33.9], [390.153, 33.05, 33.93, 33.9]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_panasonic_e_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_panasonic_e_breadboard.svg",
			"width":"27.779",
			"height":"54.838",
			"points": [[8.669, 49.869, 3.103, 5.969], [16.008, 49.869, 3.007, 5.969]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_panasonic_g_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_panasonic_g_breadboard.svg",
			"width":"35.149",
			"height":"69.147",
			"points": [[8.492, 63.672, 3.563, 6.438], [23.094, 63.672, 3.563, 6.438]]
		}, {
			"name":"TPS6211 *",
			"description":"TPS62112: 1.5A Step-Down Converter",
			"image":"core\/breadboard\/sparkfun-poweric_qfn16-4x4_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_qfn16-4x4_breadboard.svg",
			"width":"900",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"V_REG_MC33269",
			"description":"",
			"image":"core\/breadboard\/sparkfun-poweric_dpak_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_dpak_breadboard.svg",
			"width":"333.016",
			"height":"600",
			"points": [[99.543, 533.05, 33.93, 33.9], [199.543, 533.05, 33.93, 33.9], [199.543, 33.05, 33.93, 33.9]]
		}
	]
}, {
	"page":"17",
	"count": 37,
	"el": [{
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_vishay_c_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_vishay_c_breadboard.svg",
			"width":"283.5",
			"height":"600",
			"points": [[124.785, 533.05, 33.93, 33.9], [124.785, 33.05, 33.93, 33.9]]
		}, {
			"name":"SOLAR-IXYS",
			"description":"",
			"image":"core\/breadboard\/sparkfun-sensors_solarbit-12x1_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_solarbit-12x1_breadboard.svg",
			"width":"1101.58",
			"height":"600",
			"points": [[533.827, 533.05, 33.93, 33.9], [533.827, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Motor Shield",
			"description":"The new version of this shield allows for either 3.3 or 5v logic, a separate and more robust VIN connection, and the PWM input has moved to pin 3. This is a motor shield for Arduino that will control two DC motors.Based on the L298 H-bridge, the Ardumoto can drive up to 2 amps per channel.The board takes its power from the same Vin line as the Arduino board, includes blue and yellow LEDs to indicate active direction, and all driver lines are diode protected from back EMF.  Control for motor attached to OUT1\/2 is connected to digital line 12(direction A)and digital line 3(PWM A).  Control for motor attached to OUT3\/4 is connected to digital line 13(direction B)and digital line 11(PWM B).  Compatible screw terminals and connectors are listed below.  Documents:    Schematic   Eagle Files   L298 H Bridge data sheet   Example Arduino sketch   Assembly Guide   Quickstart Guide Replaces: DEV-09213",
			"image":"core\/breadboard\/Ardumoto v13_breadboard.svg",
			"icon":"core\/breadboard\/Ardumoto v13_breadboard.svg",
			"width":"169.2",
			"height":"151.2",
			"points": [[29.348, 122.948, 6.104, 6.104], [29.348, 115.748, 6.104, 6.104], [7.50961, 122.70961, 6.58078, 6.58078], [7.50961, 112.78761, 6.58078, 6.58078], [7.50961, 54.30961, 6.58078, 6.58078], [7.50961, 64.23081, 6.58078, 6.58078], [7.50961, 74.15211, 6.58078, 6.58078], [7.50961, 84.07371, 6.58078, 6.58078], [22.148, 58.148, 6.104, 6.104], [22.148, 65.348, 6.104, 6.104], [22.148, 72.548, 6.104, 6.104], [22.148, 79.748, 6.104, 6.104], [72.548, 140.948, 6.104, 6.104], [79.748, 140.948, 6.104, 6.104], [115.748, 140.948, 6.104, 6.104], [122.948, 140.948, 6.104, 6.104], [130.148, 140.948, 6.104, 6.104], [137.348, 140.948, 6.104, 6.104], [144.548, 140.948, 6.104, 6.104], [151.748, 140.948, 6.104, 6.104], [40.148, 4.148, 6.104, 6.104], [137.348, 4.148, 6.104, 6.104], [130.148, 4.148, 6.104, 6.104], [122.948, 4.148, 6.104, 6.104], [115.748, 4.148, 6.104, 6.104], [108.548, 4.148, 6.104, 6.104], [101.348, 4.148, 6.104, 6.104], [90.548, 4.148, 6.104, 6.104], [83.348, 4.148, 6.104, 6.104], [76.148, 4.148, 6.104, 6.104], [68.948, 4.148, 6.104, 6.104], [61.748, 4.148, 6.104, 6.104], [54.548, 4.148, 6.104, 6.104], [86.948, 140.948, 6.104, 6.104], [94.148, 140.948, 6.104, 6.104], [47.348, 4.148, 6.104, 6.104], [65.348, 140.948, 6.104, 6.104], [151.748, 4.148, 6.104, 6.104], [144.548, 4.148, 6.104, 6.104], [101.348, 140.948, 6.104, 6.104], [151.748, 40.148, 6.104, 6.104], [151.748, 32.948, 6.104, 6.104], [151.748, 25.748, 6.104, 6.104], [151.748, 18.548, 6.104, 6.104], [151.748, 112.148, 6.104, 6.104], [151.748, 104.948, 6.104, 6.104], [151.748, 97.748, 6.104, 6.104], [151.748, 90.548, 6.104, 6.104], [151.748, 83.348, 6.104, 6.104], [151.748, 76.148, 6.104, 6.104], [151.748, 68.948, 6.104, 6.104], [151.748, 61.748, 6.104, 6.104], [115.748, 97.748, 6.104, 6.104], [115.748, 90.548, 6.104, 6.104], [115.748, 83.348, 6.104, 6.104], [115.748, 76.148, 6.104, 6.104], [115.748, 68.948, 6.104, 6.104], [115.748, 61.748, 6.104, 6.104], [115.748, 54.548, 6.104, 6.104], [115.748, 47.348, 6.104, 6.104], [115.748, 40.148, 6.104, 6.104], [115.748, 32.948, 6.104, 6.104], [115.748, 25.748, 6.104, 6.104], [115.748, 18.548, 6.104, 6.104], [115.748, 126.548, 6.104, 6.104], [115.748, 119.348, 6.104, 6.104], [115.748, 112.148, 6.104, 6.104], [115.748, 104.948, 6.104, 6.104], [108.548, 126.548, 6.104, 6.104], [122.948, 97.748, 6.104, 6.104], [122.948, 90.548, 6.104, 6.104], [122.948, 83.348, 6.104, 6.104], [122.948, 76.148, 6.104, 6.104], [122.948, 68.948, 6.104, 6.104], [122.948, 61.748, 6.104, 6.104], [122.948, 54.548, 6.104, 6.104], [122.948, 47.348, 6.104, 6.104], [122.948, 40.148, 6.104, 6.104], [122.948, 32.948, 6.104, 6.104], [122.948, 25.748, 6.104, 6.104], [122.948, 18.548, 6.104, 6.104], [122.948, 126.548, 6.104, 6.104], [122.948, 119.348, 6.104, 6.104], [122.948, 112.148, 6.104, 6.104], [122.948, 104.948, 6.104, 6.104], [108.548, 119.348, 6.104, 6.104], [130.148, 97.748, 6.104, 6.104], [130.148, 90.548, 6.104, 6.104], [130.148, 83.348, 6.104, 6.104], [130.148, 76.148, 6.104, 6.104], [130.148, 68.948, 6.104, 6.104], [130.148, 61.748, 6.104, 6.104], [130.148, 54.548, 6.104, 6.104], [130.148, 47.348, 6.104, 6.104], [130.148, 40.148, 6.104, 6.104], [130.148, 32.948, 6.104, 6.104], [130.148, 126.548, 6.104, 6.104], [130.148, 119.348, 6.104, 6.104], [130.148, 112.148, 6.104, 6.104], [130.148, 104.948, 6.104, 6.104], [108.548, 112.148, 6.104, 6.104], [137.348, 97.748, 6.104, 6.104], [137.348, 90.548, 6.104, 6.104], [137.348, 83.348, 6.104, 6.104], [137.348, 76.148, 6.104, 6.104], [137.348, 68.948, 6.104, 6.104], [137.348, 61.748, 6.104, 6.104], [137.348, 54.548, 6.104, 6.104], [137.348, 47.348, 6.104, 6.104], [137.348, 40.148, 6.104, 6.104], [137.348, 32.948, 6.104, 6.104], [137.348, 25.748, 6.104, 6.104], [137.348, 18.548, 6.104, 6.104], [137.348, 126.548, 6.104, 6.104], [137.348, 119.348, 6.104, 6.104], [137.348, 112.148, 6.104, 6.104], [137.348, 104.948, 6.104, 6.104], [108.548, 104.948, 6.104, 6.104], [144.548, 97.748, 6.104, 6.104], [144.548, 90.548, 6.104, 6.104], [144.548, 83.348, 6.104, 6.104], [144.548, 76.148, 6.104, 6.104], [144.548, 68.948, 6.104, 6.104], [144.548, 61.748, 6.104, 6.104], [144.548, 54.548, 6.104, 6.104], [144.548, 47.348, 6.104, 6.104], [144.548, 40.148, 6.104, 6.104], [144.548, 32.948, 6.104, 6.104], [144.548, 25.748, 6.104, 6.104], [144.548, 18.548, 6.104, 6.104], [144.548, 126.548, 6.104, 6.104], [144.548, 119.348, 6.104, 6.104], [144.548, 112.148, 6.104, 6.104], [144.548, 104.948, 6.104, 6.104], [108.548, 97.748, 6.104, 6.104], [108.548, 47.348, 6.104, 6.104], [86.948, 32.948, 6.104, 6.104], [101.348, 25.748, 6.104, 6.104], [79.748, 25.748, 6.104, 6.104], [101.348, 18.548, 6.104, 6.104], [108.548, 90.548, 6.104, 6.104], [108.548, 40.148, 6.104, 6.104], [79.748, 32.948, 6.104, 6.104], [94.148, 32.948, 6.104, 6.104], [86.948, 25.748, 6.104, 6.104], [94.148, 18.548, 6.104, 6.104], [151.748, 54.548, 6.104, 6.104], [108.548, 32.948, 6.104, 6.104], [101.348, 32.948, 6.104, 6.104], [94.148, 25.748, 6.104, 6.104], [86.948, 18.548, 6.104, 6.104], [151.748, 47.348, 6.104, 6.104], [108.548, 25.748, 6.104, 6.104], [158.948, 97.748, 6.104, 6.104], [158.948, 90.548, 6.104, 6.104], [158.948, 83.348, 6.104, 6.104], [158.948, 76.148, 6.104, 6.104], [158.948, 68.948, 6.104, 6.104], [158.948, 61.748, 6.104, 6.104], [158.948, 54.548, 6.104, 6.104], [158.948, 47.348, 6.104, 6.104], [79.748, 18.548, 6.104, 6.104], [158.948, 112.148, 6.104, 6.104], [158.948, 104.948, 6.104, 6.104], [108.548, 18.548, 6.104, 6.104]]
		}, {
			"name":"Barometric Pressure Sensor",
			"description":"SCP1000 Barometric Pressure sensor.Can sense air pressure and temperature.SPI interface.",
			"image":"core\/breadboard\/Barometric_Pressure_Sensor__2eaec138e035.svg",
			"icon":"core\/breadboard\/Barometric_Pressure_Sensor__2eaec138e035.svg",
			"width":"54",
			"height":"59.04",
			"points": [[2.351, 4.847, 4.774, 4.774], [2.351, 12.151, 4.774, 4.774], [2.351, 19.454, 4.774, 4.774], [2.351, 26.758, 4.774, 4.774], [2.351, 34.06, 4.774, 4.774], [2.35, 41.362, 4.776, 4.776], [2.35, 48.566, 4.776, 4.776]]
		}, {
			"name":"EM408_OUTLINE",
			"description":"This device is only the outline of the EM408 GPS receiver.The device is intended to give thedesigner an idea of what how the receiver will fit on the board.THIS DEVICE DOES NOT PROVIDE ANY ELECTRICAL CONNECTION TO THE BOARD!Include the EM408_CON device in order to connect the EM408 to your design.",
			"image":"core\/breadboard\/sparkfun-rf_em408_outline_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_em408_outline_breadboard.svg",
			"width":"2090.83",
			"height":"1800",
			"points": []
		}, {
			"name":"PIC16F883",
			"description":"",
			"image":"core\/breadboard\/SO-28W_breadboard.svg",
			"icon":"core\/breadboard\/SO-28W_breadboard.svg",
			"width":"100.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968], [87.8509, 37.4516, 4.29896, 4.2968], [87.8509, 1.4516, 4.29896, 4.2968], [95.0509, 37.4516, 4.29896, 4.2968], [95.0509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"EP2C8_PQ208",
			"description":"Altera Cyclone2 FPGA, PQFP-208",
			"image":"core\/breadboard\/sparkfun-digitalic_pqfp208_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_pqfp208_breadboard.svg",
			"width":"10400",
			"height":"1000",
			"points": [[33.035, 933.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 933.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 933.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 933.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 933.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 933.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 933.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 933.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 933.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 933.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 933.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 933.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 933.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 933.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 933.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 933.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 933.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 933.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 933.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 933.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 933.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 933.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 933.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 933.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 933.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 933.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 933.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 933.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 933.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 933.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 933.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 933.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 933.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9], [3333.03, 933.05, 33.93, 33.9], [3333.03, 33.05, 33.93, 33.9], [3433.03, 933.05, 33.93, 33.9], [3433.03, 33.05, 33.93, 33.9], [3533.03, 933.05, 33.93, 33.9], [3533.03, 33.05, 33.93, 33.9], [3633.03, 933.05, 33.93, 33.9], [3633.03, 33.05, 33.93, 33.9], [3733.03, 933.05, 33.93, 33.9], [3733.03, 33.05, 33.93, 33.9], [3833.03, 933.05, 33.93, 33.9], [3833.03, 33.05, 33.93, 33.9], [3933.03, 933.05, 33.93, 33.9], [3933.03, 33.05, 33.93, 33.9], [4033.03, 933.05, 33.93, 33.9], [4033.03, 33.05, 33.93, 33.9], [4133.03, 933.05, 33.93, 33.9], [4133.03, 33.05, 33.93, 33.9], [4233.03, 933.05, 33.93, 33.9], [4233.03, 33.05, 33.93, 33.9], [4333.03, 933.05, 33.93, 33.9], [4333.03, 33.05, 33.93, 33.9], [4433.03, 933.05, 33.93, 33.9], [4433.03, 33.05, 33.93, 33.9], [4533.03, 933.05, 33.93, 33.9], [4533.03, 33.05, 33.93, 33.9], [4633.03, 933.05, 33.93, 33.9], [4633.03, 33.05, 33.93, 33.9], [4733.03, 933.05, 33.93, 33.9], [4733.03, 33.05, 33.93, 33.9], [4833.03, 933.05, 33.93, 33.9], [4833.03, 33.05, 33.93, 33.9], [4933.03, 933.05, 33.93, 33.9], [4933.03, 33.05, 33.93, 33.9], [5033.03, 933.05, 33.93, 33.9], [5033.03, 33.05, 33.93, 33.9], [5133.03, 933.05, 33.93, 33.9], [5133.03, 33.05, 33.93, 33.9], [5233.03, 933.05, 33.93, 33.9], [5233.03, 33.05, 33.93, 33.9], [5333.03, 933.05, 33.93, 33.9], [5333.03, 33.05, 33.93, 33.9], [5433.03, 933.05, 33.93, 33.9], [5433.03, 33.05, 33.93, 33.9], [5533.03, 933.05, 33.93, 33.9], [5533.03, 33.05, 33.93, 33.9], [5633.03, 933.05, 33.93, 33.9], [5633.03, 33.05, 33.93, 33.9], [5733.03, 933.05, 33.93, 33.9], [5733.03, 33.05, 33.93, 33.9], [5833.03, 933.05, 33.93, 33.9], [5833.03, 33.05, 33.93, 33.9], [5933.03, 933.05, 33.93, 33.9], [5933.03, 33.05, 33.93, 33.9], [6033.03, 933.05, 33.93, 33.9], [6033.03, 33.05, 33.93, 33.9], [6133.03, 933.05, 33.93, 33.9], [6133.03, 33.05, 33.93, 33.9], [6233.03, 933.05, 33.93, 33.9], [6233.03, 33.05, 33.93, 33.9], [6333.03, 933.05, 33.93, 33.9], [6333.03, 33.05, 33.93, 33.9], [6433.03, 933.05, 33.93, 33.9], [6433.03, 33.05, 33.93, 33.9], [6533.03, 933.05, 33.93, 33.9], [6533.03, 33.05, 33.93, 33.9], [6633.03, 933.05, 33.93, 33.9], [6633.03, 33.05, 33.93, 33.9], [6733.03, 933.05, 33.93, 33.9], [6733.03, 33.05, 33.93, 33.9], [6833.03, 933.05, 33.93, 33.9], [6833.03, 33.05, 33.93, 33.9], [6933.03, 933.05, 33.93, 33.9], [6933.03, 33.05, 33.93, 33.9], [7033.03, 933.05, 33.93, 33.9], [7033.03, 33.05, 33.93, 33.9], [7133.03, 933.05, 33.93, 33.9], [7133.03, 33.05, 33.93, 33.9], [7233.03, 933.05, 33.93, 33.9], [7233.03, 33.05, 33.93, 33.9], [7333.03, 933.05, 33.93, 33.9], [7333.03, 33.05, 33.93, 33.9], [7433.03, 933.05, 33.93, 33.9], [7433.03, 33.05, 33.93, 33.9], [7533.03, 933.05, 33.93, 33.9], [7533.03, 33.05, 33.93, 33.9], [7633.03, 933.05, 33.93, 33.9], [7633.03, 33.05, 33.93, 33.9], [7733.03, 933.05, 33.93, 33.9], [7733.03, 33.05, 33.93, 33.9], [7833.03, 933.05, 33.93, 33.9], [7833.03, 33.05, 33.93, 33.9], [7933.03, 933.05, 33.93, 33.9], [7933.03, 33.05, 33.93, 33.9], [8033.03, 933.05, 33.93, 33.9], [8033.03, 33.05, 33.93, 33.9], [8133.03, 933.05, 33.93, 33.9], [8133.03, 33.05, 33.93, 33.9], [8233.03, 933.05, 33.93, 33.9], [8233.03, 33.05, 33.93, 33.9], [8333.03, 933.05, 33.93, 33.9], [8333.03, 33.05, 33.93, 33.9], [8433.03, 933.05, 33.93, 33.9], [8433.03, 33.05, 33.93, 33.9], [8533.03, 933.05, 33.93, 33.9], [8533.03, 33.05, 33.93, 33.9], [8633.03, 933.05, 33.93, 33.9], [8633.03, 33.05, 33.93, 33.9], [8733.03, 933.05, 33.93, 33.9], [8733.03, 33.05, 33.93, 33.9], [8833.03, 933.05, 33.93, 33.9], [8833.03, 33.05, 33.93, 33.9], [8933.03, 933.05, 33.93, 33.9], [8933.03, 33.05, 33.93, 33.9], [9033.03, 933.05, 33.93, 33.9], [9033.03, 33.05, 33.93, 33.9], [9133.03, 933.05, 33.93, 33.9], [9133.03, 33.05, 33.93, 33.9], [9233.03, 933.05, 33.93, 33.9], [9233.03, 33.05, 33.93, 33.9], [9333.03, 933.05, 33.93, 33.9], [9333.03, 33.05, 33.93, 33.9], [9433.03, 933.05, 33.93, 33.9], [9433.03, 33.05, 33.93, 33.9], [9533.03, 933.05, 33.93, 33.9], [9533.03, 33.05, 33.93, 33.9], [9633.03, 933.05, 33.93, 33.9], [9633.03, 33.05, 33.93, 33.9], [9733.03, 933.05, 33.93, 33.9], [9733.03, 33.05, 33.93, 33.9], [9833.03, 933.05, 33.93, 33.9], [9833.03, 33.05, 33.93, 33.9], [9933.03, 933.05, 33.93, 33.9], [9933.03, 33.05, 33.93, 33.9], [10033, 933.05, 33.93, 33.9], [10033, 33.05, 33.93, 33.9], [10133, 933.05, 33.93, 33.9], [10133, 33.05, 33.93, 33.9], [10233, 933.05, 33.93, 33.9], [10233, 33.05, 33.93, 33.9], [10333, 933.05, 33.93, 33.9], [10333, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino ProtoShield",
			"description":"Riding on the waves of the very popular Arduino USB board is this small prototyping shield.Originally spawned with collaboration between the folks at SFE and ITP @ NYU, the ProtoShield mates with the Arduino USB board and gives the user a small soldering area, two general LEDs, access to a BlueSMiRF socket, a general pushbutton switch , and most important of all-the Arduino reset switch is brought to the top level.A ProtoShield quickstart guide is available!  This comes in kit form and must be soldered together by the end user.Please note-we do not ship assembly instructions, but you can find a big, clean photographed assembly guide here!There are a few tutorials on assembly listed below.All soldering is through-hole(relatively easy)but always check your component orientation before soldering!  The kit is pictured with the bread-board option.We highly recommend this breadboard!See the related items below for all the colorful options of breadboards you have.  Kit Includes:    1x ProtoShield bare PCB   2x Stackable Headers 6-pin   2x Stackable Headers 8-pin   2x 5mm Basic Yellow LEDs   2x 330 Ohm resistors   1x 10k resistor   2x Momentary push buttons   2x 0.1uF Ceramic Capacitors Features:     All Arduino pins are brought to the top level   5V, GND, and Vin pins are exposed as well   BlueSMiRF socket for wireless communication between Arduinos   2 general use LEDs   1 general use button   Reset button brought to top level Documents:    ProtoShield Quickstart Guide   Assembly Instructions   ProtoShield Schematic   Arduino Home Page   Assembly Tutorial by Bob Gallup   ProtoShield Eagle Files Standalone Circuit Board: BatchPCB: Arduino ProtoShield",
			"image":"core\/breadboard\/ProtoShield-v25_breadboard.svg",
			"icon":"core\/breadboard\/ProtoShield-v25_breadboard.svg",
			"width":"183.6",
			"height":"151.2",
			"points": [[12.248, 18.728, 5.744, 5.744], [2.528, 131.768, 5.744, 5.744], [7.928, 69.128, 5.744, 5.744], [65.528, 141.128, 5.744, 5.744], [72.728, 141.128, 5.744, 5.744], [79.928, 141.128, 5.744, 5.744], [87.128, 141.128, 5.744, 5.744], [94.328, 141.128, 5.744, 5.744], [101.528, 141.128, 5.744, 5.744], [151.928, 4.328, 5.744, 5.744], [144.728, 4.328, 5.744, 5.744], [137.528, 4.328, 5.744, 5.744], [130.328, 4.328, 5.744, 5.744], [123.128, 4.328, 5.744, 5.744], [115.928, 4.328, 5.744, 5.744], [108.728, 4.328, 5.744, 5.744], [101.528, 4.328, 5.744, 5.744], [151.928, 141.128, 5.744, 5.744], [144.728, 141.128, 5.744, 5.744], [137.528, 141.128, 5.744, 5.744], [130.328, 141.128, 5.744, 5.744], [123.128, 141.128, 5.744, 5.744], [115.928, 141.128, 5.744, 5.744], [90.008, 4.328, 5.744, 5.744], [82.808, 4.328, 5.744, 5.744], [75.608, 4.328, 5.744, 5.744], [68.408, 4.328, 5.744, 5.744], [61.208, 4.328, 5.744, 5.744], [54.008, 4.328, 5.744, 5.744], [46.808, 4.328, 5.744, 5.744], [39.608, 4.328, 5.744, 5.744], [33.128, 29.528, 5.744, 5.744], [40.328, 29.528, 5.744, 5.744], [47.528, 29.528, 5.744, 5.744], [54.728, 29.528, 5.744, 5.744], [61.928, 29.528, 5.744, 5.744], [69.128, 29.528, 5.744, 5.744], [76.328, 29.528, 5.744, 5.744], [83.528, 29.528, 5.744, 5.744], [90.728, 29.528, 5.744, 5.744], [97.928, 29.528, 5.744, 5.744], [105.128, 29.528, 5.744, 5.744], [112.328, 29.528, 5.744, 5.744], [119.528, 29.528, 5.744, 5.744], [126.728, 29.528, 5.744, 5.744], [133.928, 29.528, 5.744, 5.744], [141.128, 29.528, 5.744, 5.744], [33.128, 115.928, 5.744, 5.744], [40.328, 115.928, 5.744, 5.744], [47.528, 115.928, 5.744, 5.744], [54.728, 115.928, 5.744, 5.744], [61.928, 115.928, 5.744, 5.744], [69.128, 115.928, 5.744, 5.744], [76.328, 115.928, 5.744, 5.744], [83.528, 115.928, 5.744, 5.744], [90.728, 115.928, 5.744, 5.744], [97.928, 115.928, 5.744, 5.744], [105.128, 115.928, 5.744, 5.744], [112.328, 115.928, 5.744, 5.744], [119.528, 115.928, 5.744, 5.744], [126.728, 115.928, 5.744, 5.744], [133.928, 115.928, 5.744, 5.744], [141.128, 115.928, 5.744, 5.744], [171.368, 40.328, 5.744, 5.744], [171.368, 33.128, 5.744, 5.744], [171.368, 25.928, 5.744, 5.744], [171.368, 18.728, 5.744, 5.744], [171.368, 11.528, 5.744, 5.744], [171.368, 4.328, 5.744, 5.744], [141.2, 36.8, 5.6, 5.6], [141.2, 44, 5.6, 5.6], [141.2, 108.8, 5.6, 5.6], [141.2, 101.6, 5.6, 5.6], [141.2, 94.4, 5.6, 5.6], [141.2, 87.2, 5.6, 5.6], [141.2, 80, 5.6, 5.6], [141.2, 72.8, 5.6, 5.6], [141.2, 65.6, 5.6, 5.6], [141.2, 58.4, 5.6, 5.6], [141.2, 51.2, 5.6, 5.6], [134, 36.8, 5.6, 5.6], [134, 44, 5.6, 5.6], [134, 108.8, 5.6, 5.6], [134, 101.6, 5.6, 5.6], [134, 94.4, 5.6, 5.6], [134, 87.2, 5.6, 5.6], [134, 80, 5.6, 5.6], [134, 72.8, 5.6, 5.6], [134, 65.6, 5.6, 5.6], [134, 58.4, 5.6, 5.6], [134, 51.2, 5.6, 5.6], [126.8, 36.8, 5.6, 5.6], [126.8, 44, 5.6, 5.6], [126.8, 108.8, 5.6, 5.6], [126.8, 101.6, 5.6, 5.6], [126.8, 94.4, 5.6, 5.6], [126.8, 87.2, 5.6, 5.6], [126.8, 80, 5.6, 5.6], [126.8, 72.8, 5.6, 5.6], [126.8, 65.6, 5.6, 5.6], [126.8, 58.4, 5.6, 5.6], [126.8, 51.2, 5.6, 5.6], [119.6, 36.8, 5.6, 5.6], [119.6, 44, 5.6, 5.6], [119.6, 108.8, 5.6, 5.6], [119.6, 101.6, 5.6, 5.6], [119.6, 94.4, 5.6, 5.6], [119.6, 87.2, 5.6, 5.6], [119.6, 80, 5.6, 5.6], [119.6, 72.8, 5.6, 5.6], [119.6, 65.6, 5.6, 5.6], [119.6, 58.4, 5.6, 5.6], [119.6, 51.2, 5.6, 5.6], [112.4, 36.8, 5.6, 5.6], [112.4, 44, 5.6, 5.6], [112.4, 108.8, 5.6, 5.6], [112.4, 101.6, 5.6, 5.6], [112.4, 94.4, 5.6, 5.6], [112.4, 87.2, 5.6, 5.6], [112.4, 80, 5.6, 5.6], [112.4, 72.8, 5.6, 5.6], [112.4, 65.6, 5.6, 5.6], [112.4, 58.4, 5.6, 5.6], [112.4, 51.2, 5.6, 5.6], [105.2, 36.8, 5.6, 5.6], [105.2, 44, 5.6, 5.6], [105.2, 108.8, 5.6, 5.6], [105.2, 101.6, 5.6, 5.6], [105.2, 94.4, 5.6, 5.6], [105.2, 87.2, 5.6, 5.6], [105.2, 80, 5.6, 5.6], [105.2, 72.8, 5.6, 5.6], [105.2, 65.6, 5.6, 5.6], [105.2, 58.4, 5.6, 5.6], [105.2, 51.2, 5.6, 5.6], [98, 36.8, 5.6, 5.6], [98, 44, 5.6, 5.6], [98, 108.8, 5.6, 5.6], [98, 101.6, 5.6, 5.6], [98, 94.4, 5.6, 5.6], [98, 87.2, 5.6, 5.6], [98, 80, 5.6, 5.6], [98, 72.8, 5.6, 5.6], [98, 65.6, 5.6, 5.6], [98, 58.4, 5.6, 5.6], [98, 51.2, 5.6, 5.6], [90.8, 36.8, 5.6, 5.6], [90.8, 44, 5.6, 5.6], [90.8, 108.8, 5.6, 5.6], [90.8, 101.6, 5.6, 5.6], [90.8, 94.4, 5.6, 5.6], [90.8, 87.2, 5.6, 5.6], [90.8, 80, 5.6, 5.6], [90.8, 72.8, 5.6, 5.6], [90.8, 65.6, 5.6, 5.6], [90.8, 58.4, 5.6, 5.6], [90.8, 51.2, 5.6, 5.6], [83.6, 36.8, 5.6, 5.6], [83.6, 44, 5.6, 5.6], [83.6, 108.8, 5.6, 5.6], [83.6, 101.6, 5.6, 5.6], [83.6, 94.4, 5.6, 5.6], [83.6, 87.2, 5.6, 5.6], [83.6, 80, 5.6, 5.6], [83.6, 72.8, 5.6, 5.6], [83.6, 65.6, 5.6, 5.6], [83.6, 58.4, 5.6, 5.6], [83.6, 51.2, 5.6, 5.6], [76.4, 36.8, 5.6, 5.6], [76.4, 44, 5.6, 5.6], [76.4, 108.8, 5.6, 5.6], [76.4, 101.6, 5.6, 5.6], [76.4, 94.4, 5.6, 5.6], [76.4, 87.2, 5.6, 5.6], [76.4, 80, 5.6, 5.6], [76.4, 72.8, 5.6, 5.6], [76.4, 65.6, 5.6, 5.6], [76.4, 58.4, 5.6, 5.6], [76.4, 51.2, 5.6, 5.6], [69.2, 36.8, 5.6, 5.6], [69.2, 44, 5.6, 5.6], [69.2, 108.8, 5.6, 5.6], [69.2, 101.6, 5.6, 5.6], [69.2, 94.4, 5.6, 5.6], [69.2, 87.2, 5.6, 5.6], [69.2, 80, 5.6, 5.6], [69.2, 72.8, 5.6, 5.6], [69.2, 65.6, 5.6, 5.6], [69.2, 58.4, 5.6, 5.6], [69.2, 51.2, 5.6, 5.6], [62, 36.8, 5.6, 5.6], [62, 44, 5.6, 5.6], [62, 108.8, 5.6, 5.6], [62, 101.6, 5.6, 5.6], [62, 94.4, 5.6, 5.6], [62, 87.2, 5.6, 5.6], [62, 80, 5.6, 5.6], [62, 72.8, 5.6, 5.6], [62, 65.6, 5.6, 5.6], [62, 58.4, 5.6, 5.6], [62, 51.2, 5.6, 5.6], [54.8, 36.8, 5.6, 5.6], [54.8, 44, 5.6, 5.6], [54.8, 108.8, 5.6, 5.6], [54.8, 101.6, 5.6, 5.6], [54.8, 94.4, 5.6, 5.6], [54.8, 87.2, 5.6, 5.6], [54.8, 80, 5.6, 5.6], [54.8, 72.8, 5.6, 5.6], [54.8, 65.6, 5.6, 5.6], [54.8, 58.4, 5.6, 5.6], [54.8, 51.2, 5.6, 5.6], [47.6, 36.8, 5.6, 5.6], [47.6, 44, 5.6, 5.6], [47.6, 108.8, 5.6, 5.6], [47.6, 101.6, 5.6, 5.6], [47.6, 94.4, 5.6, 5.6], [47.6, 87.2, 5.6, 5.6], [47.6, 80, 5.6, 5.6], [47.6, 72.8, 5.6, 5.6], [47.6, 65.6, 5.6, 5.6], [47.6, 58.4, 5.6, 5.6], [47.6, 51.2, 5.6, 5.6], [40.4, 36.8, 5.6, 5.6], [40.4, 44, 5.6, 5.6], [40.4, 108.8, 5.6, 5.6], [40.4, 101.6, 5.6, 5.6], [40.4, 94.4, 5.6, 5.6], [40.4, 87.2, 5.6, 5.6], [40.4, 80, 5.6, 5.6], [40.4, 72.8, 5.6, 5.6], [40.4, 65.6, 5.6, 5.6], [40.4, 58.4, 5.6, 5.6], [40.4, 51.2, 5.6, 5.6], [33.2, 36.8, 5.6, 5.6], [33.2, 44, 5.6, 5.6], [33.2, 108.8, 5.6, 5.6], [33.2, 101.6, 5.6, 5.6], [33.2, 94.4, 5.6, 5.6], [33.2, 87.2, 5.6, 5.6], [33.2, 80, 5.6, 5.6], [33.2, 72.8, 5.6, 5.6], [33.2, 65.6, 5.6, 5.6], [33.2, 58.4, 5.6, 5.6], [33.2, 51.2, 5.6, 5.6]]
		}, {
			"name":"BUTTONPAD-4X4",
			"description":"Proto layout and schematic for 4x4 button pad.Spark Fun Electronics SKU: COM-07835.Compatible common cathode tri-color LED SKU: COM-00105",
			"image":"core\/breadboard\/sparkfun-electromechanical_buttonpad-4x4_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_buttonpad-4x4_breadboard.svg",
			"width":"4800",
			"height":"4600",
			"points": [[33.035, 4533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 4533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 4533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 4533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 4533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 4533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 4533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 4533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 4533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 4533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 4533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 4533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 4533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 4533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 4533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 4533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 4533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 4533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 4533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 4533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 4533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 4533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 4533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 4533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 4533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 4533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 4533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 4533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 4533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 4533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 4533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 4533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 4533.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9], [3333.03, 4533.05, 33.93, 33.9], [3333.03, 33.05, 33.93, 33.9], [3433.03, 4533.05, 33.93, 33.9], [3433.03, 33.05, 33.93, 33.9], [3533.03, 4533.05, 33.93, 33.9], [3533.03, 33.05, 33.93, 33.9], [3633.03, 4533.05, 33.93, 33.9], [3633.03, 33.05, 33.93, 33.9], [3733.03, 4533.05, 33.93, 33.9], [3733.03, 33.05, 33.93, 33.9], [3833.03, 4533.05, 33.93, 33.9], [3833.03, 33.05, 33.93, 33.9], [3933.03, 4533.05, 33.93, 33.9], [3933.03, 33.05, 33.93, 33.9], [4033.03, 4533.05, 33.93, 33.9], [4033.03, 33.05, 33.93, 33.9], [4133.03, 4533.05, 33.93, 33.9], [4133.03, 33.05, 33.93, 33.9], [4233.03, 4533.05, 33.93, 33.9], [4233.03, 33.05, 33.93, 33.9], [4333.03, 4533.05, 33.93, 33.9], [4333.03, 33.05, 33.93, 33.9], [4433.03, 4533.05, 33.93, 33.9], [4433.03, 33.05, 33.93, 33.9], [4533.03, 4533.05, 33.93, 33.9], [4533.03, 33.05, 33.93, 33.9], [4633.03, 4533.05, 33.93, 33.9], [4633.03, 33.05, 33.93, 33.9], [4733.03, 4533.05, 33.93, 33.9], [4733.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"Raspberry Pi B rev1",
			"description":"The awesome Raspberry Pi ARM Board",
			"image":"core\/breadboard\/raspberry_pi_rev1_breadboard.svg",
			"icon":"core\/breadboard\/raspberry_pi_rev1_breadboard.svg",
			"width":"260.031",
			"height":"177.412",
			"points": [[19.369, 19.422, 4.285, 4.283], [19.369, 12.268, 4.285, 4.283], [12.218, 19.422, 4.283, 4.283], [12.218, 12.268, 4.283, 4.283], [5.063, 19.422, 4.284, 4.283], [5.063, 12.268, 4.284, 4.283], [40.748, 19.385, 4.284, 4.283], [40.748, 12.233, 4.284, 4.281], [33.595, 19.385, 4.282, 4.283], [33.595, 12.233, 4.282, 4.281], [26.441, 19.385, 4.284, 4.283], [26.441, 12.233, 4.284, 4.281], [62.181, 19.242, 4.283, 4.284], [62.181, 12.089, 4.283, 4.283], [55.028, 19.242, 4.284, 4.284], [55.028, 12.089, 4.284, 4.283], [47.876, 19.242, 4.283, 4.284], [47.876, 12.089, 4.283, 4.283], [83.615, 19.242, 4.285, 4.284], [83.615, 12.089, 4.285, 4.283], [76.463, 19.242, 4.284, 4.284], [76.463, 12.089, 4.284, 4.283], [69.31, 19.242, 4.284, 4.284], [69.31, 12.089, 4.284, 4.283], [90.854, 19.101, 4.284, 4.283], [90.854, 11.949, 4.284, 4.281]]
		}, {
			"name":"Header 8",
			"description":"Header 8Standard 8-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).",
			"image":"core\/breadboard\/sparkfun-connectors_1x08_smd_combined_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_1x08_smd_combined_breadboard.svg",
			"width":"63.133",
			"height":"43.2",
			"points": [[5.646, 37.452, 4.299, 4.297], [5.646, 1.452, 4.299, 4.297], [12.846, 37.452, 4.299, 4.297], [12.846, 1.452, 4.299, 4.297], [20.046, 37.452, 4.299, 4.297], [20.046, 1.452, 4.299, 4.297], [27.245, 37.452, 4.3, 4.297], [27.245, 1.452, 4.3, 4.297], [34.446, 37.452, 4.299, 4.297], [34.446, 1.452, 4.299, 4.297], [41.646, 37.452, 4.299, 4.297], [41.646, 1.452, 4.299, 4.297], [48.846, 37.452, 4.299, 4.297], [48.846, 1.452, 4.299, 4.297], [56.046, 37.452, 4.299, 4.297], [56.046, 1.452, 4.299, 4.297]]
		}, {
			"name":"EDISON",
			"description":"The Intel \ u00ae Edison is a compact computing platform that 's small by design so you can easily integrate it into projects. It' s primarily designed for  \"Internet of Things \"projects and is pretty powerful for its small size. The Edison has a bunch of features that makes it appealing for makers of all skill levels. It uses a 22 nm Intel SoC that includes a dual core, dual threaded Intel Atom CPU at 500MHz and a 32-bit Intel\u00ae Quark microctroller which runs at 100 MHz. It's a lot of power for a board that's about the size of an LED Matrix.The board supports 40 GPIOs and includes 1 GB LPDDR3, 4 GB EMMC, and has dual-band WiFI and BTLE-which makes it essentially wireless.The tiny Edison fits nicely onto a breakout board-sort of like a tiny IoT sparrow into a very small nest-so you can expose the native 1.8 V I\/O of the Edison. The breakout board has a power supply, USB serial, USB OTG port and power switch, an I\/O header, and a battery charger. Together, there's seamless device-to-device and device-to-cloud communication.",
			"image":"core\/breadboard\/intel_edison_minibreakout_bottom_breadboard.svg",
			"icon":"core\/breadboard\/intel_edison_minibreakout_bottom_breadboard.svg",
			"width":"174.398",
			"height":"82.541",
			"points": []
		}, {
			"name":"ET312 GPS Receiver",
			"description":"ET312 GPS ReceiverProven layout and schematic for SiRF III ET312 GPS receiver. This footprint has been tweaked significantly to work with the ET312. This footprint has been fully qualified. Spark Fun Electronics SKU : GPS-08268.",
			"image":"core\/breadboard\/sparkfun-rf_et312_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_et312_breadboard.svg",
			"width":"1318.25",
			"height":"1200",
			"points": [[342.16, 1133.05, 33.93, 33.9], [442.16, 1133.05, 33.93, 33.9], [442.16, 33.05, 33.93, 33.9], [542.16, 1133.05, 33.93, 33.9], [542.16, 33.05, 33.93, 33.9], [642.16, 1133.05, 33.93, 33.9], [642.16, 33.05, 33.93, 33.9], [742.16, 1133.05, 33.93, 33.9], [742.16, 33.05, 33.93, 33.9], [842.16, 1133.05, 33.93, 33.9], [842.16, 33.05, 33.93, 33.9], [942.16, 1133.05, 33.93, 33.9], [942.16, 33.05, 33.93, 33.9]]
		}, {
			"name":"AD5206 Digital Potentiometer",
			"description":"Digital potentiometer. 6 channels with SPI-compatible interface.",
			"image":"core\/breadboard\/AD5206_Digital_Potentiometer__1569b6e5e5.svg",
			"icon":"core\/breadboard\/AD5206_Digital_Potentiometer__1569b6e5e5.svg",
			"width":"86.4",
			"height":"23.76",
			"points": [[1.52, 19.636, 4.16, 5.124], [1.52, -1, 4.16, 5.125], [80.72, 19.636, 4.159, 5.124], [80.72, -1, 4.159, 5.125], [8.72, 19.636, 4.159, 5.124], [8.72, -1, 4.159, 5.125], [15.92, 19.636, 4.16, 5.124], [15.92, -1, 4.16, 5.125], [23.12, 19.636, 4.16, 5.124], [23.12, -1, 4.16, 5.125], [30.32, 19.636, 4.16, 5.124], [30.32, -1, 4.16, 5.125], [37.52, 19.636, 4.16, 5.124], [37.52, -1, 4.16, 5.125], [44.72, 19.636, 4.159, 5.124], [44.72, -1, 4.159, 5.125], [51.92, 19.636, 4.16, 5.124], [51.92, -1, 4.16, 5.125], [59.12, 19.636, 4.16, 5.124], [59.12, -1, 4.16, 5.125], [66.32, 19.636, 4.16, 5.124], [66.32, -1, 4.16, 5.125], [73.52, 19.636, 4.16, 5.124], [73.52, -1, 4.16, 5.125]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder JumperStandard SMD solder jumper. Used to automate production. Two varients : Normally Open and Normally Closed are the same, but have different paste layers. NC will have a large amount of paste and should jumper during reflow.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s_breadboard.svg",
			"width":"246.307",
			"height":"400",
			"points": [[106.189, 333.05, 33.93, 33.9], [106.189, 33.05, 33.93, 33.9]]
		}, {
			"name":"Blue smd LED",
			"description":"A generic blue LED (~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-blue.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-blue.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"RFID USB Reader",
			"description":"RFID USB Reader is a simple to use, USB to serial base unit for the ID-2, ID-12, and ID-20 readers. Simply plug a reader into the headers and attach a miniUSB cable. Open a terminal program of your choice at 9600bps 8N1, then scan your 125kHz ID tag and the unique 32-bit ID will be shown on the screen. The unit is based on a FTDI chip and comes with a read LED and buzzer.\tThis new revision uses SMD headers for the RFID module, and has a solder jumper which allows you to disable or enable the buzzer.\t\tNote: This product does not come with the RFID reader. Check below for compatible readers.\t\tDimensions: 1.4x1.2x0.57'  Documents:    Schematic   Eagle Files   USB FTDI Drivers for Linux, MAC, and PC Replaces: SEN-08852",
			"image":"core\/breadboard\/RFID_USB_Reader-v14_breadboard.svg",
			"icon":"core\/breadboard\/RFID_USB_Reader-v14_breadboard.svg",
			"width":"113.924",
			"height":"86.4",
			"points": [[107.452, 65.528, 5.744, 5.744], [107.452, 58.328, 5.744, 5.744], [107.452, 51.128, 5.744, 5.744], [107.452, 43.928, 5.744, 5.744], [107.452, 36.728, 5.744, 5.744], [107.452, 29.528, 5.744, 5.744], [107.452, 22.328, 5.744, 5.744], [107.452, 15.128, 5.744, 5.744]]
		}, {
			"name":"RN-131G",
			"description":"Roving Netowrks WiFLy GSX Module",
			"image":"core\/breadboard\/sparkfun-rf_rn-131g_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_rn-131g_breadboard.svg",
			"width":"2200",
			"height":"1200",
			"points": [[33.035, 1133.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 1133.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 1133.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 1133.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 1133.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 1133.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 1133.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 1133.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 1133.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 1133.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 1133.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 1133.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 1133.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 1133.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 1133.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 1133.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 1133.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 1133.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 1133.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 1133.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 1133.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 1133.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"GM862 Cellular Module with GPS",
			"description":"GM862 Cellular Module with GPSProven layout and schematic for GM862 cellular module with SiRF III GPS.Spark Fun Electronics SKU: CEL-07917",
			"image":"core\/breadboard\/sparkfun-rf_gm862_connector_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_gm862_connector_breadboard.svg",
			"width":"180",
			"height":"72",
			"points": [[1.451, 66.252, 4.299, 4.297], [1.451, 1.452, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 66.252, 4.299, 4.297], [8.65, 1.452, 4.299, 4.297], [15.851, 66.252, 4.299, 4.297], [15.851, 1.452, 4.299, 4.297], [23.05, 66.252, 4.299, 4.297], [23.05, 1.452, 4.299, 4.297], [30.25, 66.252, 4.299, 4.297], [30.25, 1.452, 4.299, 4.297], [37.451, 66.252, 4.299, 4.297], [37.451, 1.452, 4.299, 4.297], [44.65, 66.252, 4.299, 4.297], [44.65, 1.452, 4.299, 4.297], [51.851, 66.252, 4.299, 4.297], [51.851, 1.452, 4.299, 4.297], [59.05, 66.252, 4.299, 4.297], [59.05, 1.452, 4.299, 4.297], [66.25, 66.252, 4.299, 4.297], [66.25, 1.452, 4.299, 4.297], [73.451, 66.252, 4.299, 4.297], [73.451, 1.452, 4.299, 4.297], [80.651, 66.252, 4.299, 4.297], [80.651, 1.452, 4.299, 4.297], [87.851, 66.252, 4.299, 4.297], [87.851, 1.452, 4.299, 4.297], [95.051, 66.252, 4.299, 4.297], [95.051, 1.452, 4.299, 4.297], [102.251, 66.252, 4.299, 4.297], [102.251, 1.452, 4.299, 4.297], [109.451, 66.252, 4.299, 4.297], [109.451, 1.452, 4.299, 4.297], [116.65, 66.252, 4.299, 4.297], [116.65, 1.452, 4.299, 4.297], [123.852, 66.252, 4.299, 4.297], [123.852, 1.452, 4.299, 4.297], [131.051, 66.252, 4.299, 4.297], [131.051, 1.452, 4.299, 4.297], [138.251, 66.252, 4.299, 4.297], [138.251, 1.452, 4.299, 4.297], [145.451, 66.252, 4.299, 4.297], [145.451, 1.452, 4.299, 4.297], [152.65, 66.252, 4.299, 4.297], [152.65, 1.452, 4.299, 4.297], [159.85, 66.252, 4.299, 4.297], [159.85, 1.452, 4.299, 4.297], [167.051, 66.252, 4.299, 4.297], [167.051, 1.452, 4.299, 4.297], [174.25, 66.252, 4.299, 4.297], [174.25, 1.452, 4.299, 4.297]]
		}, {
			"name":"PNP-Transistor",
			"description":"A standard PNP signal transistor",
			"image":"core\/breadboard\/transistor_pnp.svg",
			"icon":"core\/breadboard\/transistor_pnp.svg",
			"width":"16.527",
			"height":"24.08",
			"points": [[-1, 22, 4.16, 3], [6.181, 22, 4.16, 3], [13.367, 22, 4.16, 3]]
		}, {
			"name":"TRANSISTOR_NPN_2",
			"description":"Alternate TO-92 NPN BJT",
			"image":"core\/breadboard\/transistor_npn.svg",
			"icon":"core\/breadboard\/transistor_npn.svg",
			"width":"16.527",
			"height":"24.081",
			"points": [[-1, 21.081, 4.16, 3], [6.181, 21.081, 4.16, 3], [13.367, 21.081, 4.16, 3]]
		}, {
			"name":"SI1120",
			"description":"Si1120: Proximity\/Ambient Light Sensor",
			"image":"core\/breadboard\/sparkfun-sensors_odfn_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_odfn_breadboard.svg",
			"width":"500",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder JumperStandard SMD solder jumper.Used to automate production.Two varients: Normally Open and Normally Closed are the same, but have different paste layers.NC will have a large amount of paste and should jumper during reflow.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s-no_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s-no_breadboard.svg",
			"width":"243.565",
			"height":"400",
			"points": [[104.817, 333.05, 33.93, 33.9], [104.817, 33.05, 33.93, 33.9]]
		}, {
			"name":"S1133 Si Photodiode",
			"description":"S1133 photodiode with low dark current by Hamamatsu.",
			"image":"core\/breadboard\/S1133_Si_Photodiode_BB.svg",
			"icon":"core\/breadboard\/S1133_Si_Photodiode_BB.svg",
			"width":"31.49606",
			"height":"61.023619",
			"points": []
		}, {
			"name":"Generic male header-12 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_12.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_12.svg",
			"width":"86.388",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791], [37.199, 1.204, 4.791, 4.791], [44.398, 1.204, 4.791, 4.791], [51.597, 1.204, 4.791, 4.791], [58.796, 1.204, 4.791, 4.791], [65.995, 1.204, 4.791, 4.791], [73.194, 1.204, 4.791, 4.791], [80.393, 1.204, 4.791, 4.791]]
		}, {
			"name":"Arduino Micro(Rev3)",
			"description":"The Arduino Micro is a microcontroller board based on the ATmega32u4(datasheet), developed in conjunction with Adafruit.It has 20 digital input\/output pins(of which 7 can be used as PWM outputs and 12 as analog inputs), a 16 MHz crystal oscillator, a micro USB connection, an ICSP header, and a reset button.It contains everything needed to support the microcontroller; simply connect it to a computer with a micro USB cable to get started.It has a form factor that enables it to be easily placed on a breadboard.The Micro is similar to the Arduino Leonardo in that the ATmega32u4 has built-in USB communication,eliminating the need for a secondary processor.This allows the Micro to appear to a connected computer as a mouse and keyboard, in addition to a virtual(CDC)serial\/COM port.It also has other implications for the behavior of the board; these are detailed on the getting started page.",
			"image":"core\/breadboard\/Arduino_Micro_Rev03_breadboard.svg",
			"icon":"core\/breadboard\/Arduino_Micro_Rev03_breadboard.svg",
			"width":"142.824",
			"height":"50.4",
			"points": [[118.445, 36.823, 5.556, 5.556], [118.445, 29.623, 5.556, 5.556], [125.645, 36.823, 5.556, 5.556], [125.645, 29.623, 5.556, 5.556], [132.844, 36.822, 5.558, 5.558], [132.844, 29.622, 5.558, 5.558], [129.259, 0.837, 5.528, 5.528], [122.06, 0.837, 5.528, 5.528], [114.859, 0.837, 5.528, 5.528], [107.659, 0.837, 5.528, 5.528], [100.459, 0.837, 5.528, 5.528], [93.259, 0.837, 5.528, 5.528], [86.06, 0.837, 5.528, 5.528], [78.859, 0.837, 5.528, 5.528], [71.659, 0.837, 5.528, 5.528], [64.459, 0.837, 5.528, 5.528], [57.259, 0.837, 5.528, 5.528], [50.059, 0.837, 5.528, 5.528], [42.859, 0.837, 5.528, 5.528], [35.659, 0.837, 5.528, 5.528], [28.459, 0.837, 5.528, 5.528], [21.259, 0.837, 5.528, 5.528], [14.059, 0.837, 5.528, 5.528], [129.259, 44.036, 5.528, 5.528], [122.06, 44.036, 5.528, 5.528], [114.859, 44.036, 5.528, 5.528], [107.659, 44.036, 5.528, 5.528], [100.459, 44.036, 5.528, 5.528], [93.259, 44.036, 5.528, 5.528], [71.659, 44.036, 5.528, 5.528], [64.459, 44.036, 5.528, 5.528], [57.259, 44.036, 5.528, 5.528], [50.059, 44.036, 5.528, 5.528], [42.859, 44.036, 5.528, 5.528], [35.659, 44.036, 5.528, 5.528], [28.459, 44.036, 5.528, 5.528], [21.259, 44.036, 5.528, 5.528], [14.059, 44.036, 5.528, 5.528]]
		}, {
			"name":"General purpose bipolar Timer",
			"description":"General purpose bipolar Timer",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_eia3216_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_eia3216_breadboard.svg",
			"width":"404.861",
			"height":"400",
			"points": [[185.465, 333.05, 33.93, 33.9], [185.465, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic female header-20 pins",
			"description":"Generic female header",
			"image":"obsolete\/breadboard\/generic-female-header_bread_20.svg",
			"icon":"obsolete\/breadboard\/generic-female-header_bread_20.svg",
			"width":"143.58",
			"height":"7.178",
			"points": [[1.202, 1.202, 4.775, 4.775], [8.381, 1.202, 4.775, 4.775], [15.56, 1.202, 4.775, 4.775], [22.739, 1.202, 4.775, 4.775], [29.918, 1.202, 4.775, 4.775], [37.097, 1.202, 4.775, 4.775], [44.276, 1.202, 4.775, 4.775], [51.455, 1.202, 4.775, 4.775], [58.634, 1.202, 4.775, 4.775], [65.813, 1.202, 4.775, 4.775], [72.992, 1.202, 4.775, 4.775], [80.171, 1.202, 4.775, 4.775], [87.35, 1.202, 4.775, 4.775], [94.529, 1.202, 4.775, 4.775], [101.708, 1.202, 4.775, 4.775], [108.887, 1.202, 4.775, 4.775], [116.066, 1.202, 4.775, 4.775], [123.245, 1.202, 4.775, 4.775], [130.424, 1.202, 4.775, 4.775], [137.603, 1.202, 4.775, 4.775]]
		}, {
			"name":"mbed",
			"description":"A powerful microcontroller board based on the NXP LPC processor with an ARM Cortex core.See http: \/\/mbed.org for more info.",
			"image":"core\/breadboard\/controller_mbed.svg",
			"icon":"core\/breadboard\/controller_mbed.svg",
			"width":"153.105",
			"height":"73",
			"points": [[7.108, 66.385, 4.16, 4.375], [7.108, 1.997, 4.16, 4.302], [143.907, 66.385, 4.16, 4.375], [143.907, 1.997, 4.16, 4.302], [14.308, 66.385, 4.159, 4.375], [14.308, 1.997, 4.159, 4.302], [21.509, 66.385, 4.16, 4.375], [21.509, 1.997, 4.16, 4.302], [28.709, 66.385, 4.159, 4.375], [28.709, 1.997, 4.159, 4.302], [35.908, 66.385, 4.16, 4.375], [35.908, 1.997, 4.16, 4.302], [43.108, 66.385, 4.16, 4.375], [43.108, 1.997, 4.16, 4.302], [50.308, 66.385, 4.159, 4.375], [50.308, 1.997, 4.159, 4.302], [57.509, 66.385, 4.16, 4.375], [57.509, 1.997, 4.16, 4.302], [64.709, 66.385, 4.159, 4.375], [64.709, 1.997, 4.159, 4.302], [71.908, 66.385, 4.16, 4.375], [71.908, 1.997, 4.16, 4.302], [79.108, 66.385, 4.16, 4.375], [79.108, 1.997, 4.16, 4.302], [86.309, 66.385, 4.16, 4.375], [86.309, 1.997, 4.16, 4.302], [93.509, 66.385, 4.16, 4.375], [93.509, 1.997, 4.16, 4.302], [100.708, 66.385, 4.158, 4.375], [100.708, 1.997, 4.158, 4.302], [107.907, 66.385, 4.16, 4.375], [107.907, 1.997, 4.16, 4.302], [115.109, 66.385, 4.16, 4.375], [115.109, 1.997, 4.16, 4.302], [122.31, 66.385, 4.157, 4.375], [122.31, 1.997, 4.157, 4.302], [129.509, 66.385, 4.16, 4.375], [129.509, 1.997, 4.16, 4.302], [136.708, 66.385, 4.158, 4.375], [136.708, 1.997, 4.158, 4.302]]
		}, {
			"name":"FTDI_BASIC",
			"description":"FTDI Basic header with labels",
			"image":"core\/breadboard\/sparkfun-connectors_ftdi_basic_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_ftdi_basic_breadboard.svg",
			"width":"800",
			"height":"400",
			"points": [[283.035, 333.05, 33.93, 33.9], [283.035, 33.05, 33.93, 33.9], [383.035, 333.05, 33.93, 33.9], [383.035, 33.05, 33.93, 33.9], [483.035, 333.05, 33.93, 33.9], [483.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Raspberry Pi B rev2",
			"description":"The awesome Raspberry Pi ARM Board",
			"image":"core\/breadboard\/raspberry_pi_rev2_breadboard.svg",
			"icon":"core\/breadboard\/raspberry_pi_rev2_breadboard.svg",
			"width":"260.031",
			"height":"177.412",
			"points": [[19.369, 19.422, 4.285, 4.283], [19.369, 12.268, 4.285, 4.283], [12.218, 19.422, 4.283, 4.283], [12.218, 12.268, 4.283, 4.283], [5.063, 19.422, 4.284, 4.283], [5.063, 12.268, 4.284, 4.283], [40.748, 19.385, 4.284, 4.283], [40.748, 12.233, 4.284, 4.281], [33.595, 19.385, 4.283, 4.283], [33.595, 12.233, 4.283, 4.281], [26.441, 19.385, 4.284, 4.283], [26.441, 12.233, 4.284, 4.281], [62.181, 19.242, 4.284, 4.284], [62.181, 12.089, 4.284, 4.283], [55.028, 19.242, 4.284, 4.284], [55.028, 12.089, 4.284, 4.283], [47.876, 19.242, 4.283, 4.284], [47.876, 12.089, 4.283, 4.283], [83.615, 19.242, 4.285, 4.284], [83.615, 12.089, 4.285, 4.283], [76.463, 19.242, 4.284, 4.284], [76.463, 12.089, 4.284, 4.283], [69.31, 19.242, 4.284, 4.284], [69.31, 12.089, 4.284, 4.283], [90.854, 19.101, 4.284, 4.283], [90.854, 11.949, 4.284, 4.281]]
		}, {
			"name":"4 x AAA Battery Mount",
			"description":"A 4 x AAA battery pack(4.8 Volts with recharables)",
			"image":"core\/breadboard\/batterypack_4xAAA.svg",
			"icon":"core\/breadboard\/batterypack_4xAAA.svg",
			"width":"153.1",
			"height":"132.767",
			"points": [[146.467, 101.505, 4.999, 3], [149.426, 24.906, 5, 3]]
		}, {
			"name":"Header 1",
			"description":"Header 1Standard 1-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).",
			"image":"core\/breadboard\/sparkfun-connectors_snap-male_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_snap-male_breadboard.svg",
			"width":"500",
			"height":"600",
			"points": [[233.035, 533.05, 33.93, 33.9]]
		}, {
			"name":"MOSFET-NCHANNEL",
			"description":"Generic NMOS footprint",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot323_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot323_breadboard.svg",
			"width":"247.307",
			"height":"400",
			"points": [[56.6885, 333.05, 33.93, 33.9], [156.689, 333.05, 33.93, 33.9], [156.689, 33.05, 33.93, 33.9]]
		}, {
			"name":"Adafruit Atmega32u4 Breakout Board",
			"description":"",
			"image":"core\/breadboard\/Adafruit_Atmega32u4_Breakout.svg",
			"icon":"core\/breadboard\/Adafruit_Atmega32u4_Breakout.svg",
			"width":"150.23597",
			"height":"65.196851",
			"points": [[139.38999998, 22.7278501, 5.744, 5.744], [139.38999998, 29.9378503, 5.744, 5.744], [139.38999998, 37.1278493, 5.744, 5.744], [132.19000998, 22.7278525, 5.744, 5.744], [132.19000998, 29.9378503, 5.744, 5.744], [132.19000998, 37.1278493, 5.744, 5.744], [20.76710955, 58.54697359, 5.744, 5.744], [27.96711055, 58.54697359, 5.744, 5.744], [35.16711155, 58.54697359, 5.744, 5.744], [42.37711055, 58.54697359, 5.744, 5.744], [49.56710855, 58.54697359, 5.744, 5.744], [56.76710955, 58.54697359, 5.744, 5.744], [63.96710655, 58.54697359, 5.744, 5.744], [71.16711155, 58.54697359, 5.744, 5.744], [78.36710755, 58.54697359, 5.744, 5.744], [85.56711255, 58.54697359, 5.744, 5.744], [92.76710955, 58.54697359, 5.744, 5.744], [99.96710955, 58.54697359, 5.744, 5.744], [107.16710955, 58.54697359, 5.744, 5.744], [114.36710955, 58.54697359, 5.744, 5.744], [121.56710955, 58.54697359, 5.744, 5.744], [128.76710955, 58.54697359, 5.744, 5.744], [20.76710955, 1.16183597, 5.744, 5.744], [27.96711055, 1.16183597, 5.744, 5.744], [35.16711155, 1.16183597, 5.744, 5.744], [42.36710755, 1.16183597, 5.744, 5.744], [49.56710855, 1.16183597, 5.744, 5.744], [56.76710955, 1.16183597, 5.744, 5.744], [63.96710655, 1.16183597, 5.744, 5.744], [71.16711155, 1.16183597, 5.744, 5.744], [78.36710755, 1.16183597, 5.744, 5.744], [85.56711255, 1.16183597, 5.744, 5.744], [92.76710955, 1.16183597, 5.744, 5.744], [99.96710955, 1.16183597, 5.744, 5.744], [107.16710955, 1.16183597, 5.744, 5.744], [114.36710955, 1.16183597, 5.744, 5.744], [121.56710955, 1.16183597, 5.744, 5.744], [128.76710955, 1.16183597, 5.744, 5.744]]
		}, {
			"name":"SPST Switch",
			"description":"SPST SwitchSimple slide switch .Spark Fun Electronics SKU: COM-00102",
			"image":"core\/breadboard\/sparkfun-electromechanical_switch-spdt_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_switch-spdt_breadboard.svg",
			"width":"12.906",
			"height":"41.342",
			"points": [[3.401, 13.72, 6.104, 6.104], [3.4, 21.423, 6.106, 6.106], [3.401, 29.128, 6.104, 6.104]]
		}, {
			"name":"BASIC Stamp 1",
			"description":"It 's amazing what you can accomplish with this well-proven microcontroller and its simple PBASIC 1 language. All vital components (processor, clock source, memory, power regulator) are provided on the BS1' s tiny PCB; just connect power and go!The BASIC Stamp 1(BS1-IC) is an ideal fit for applications that don 't require the speed, I\/O, and memory of the BASIC Stamp 2 series of microcontrollers.",
			"image":"core\/breadboard\/BASIC_Stamp_1.svg",
			"icon":"core\/breadboard\/BASIC_Stamp_1.svg",
			"width":"32.681",
			"height":"100.64",
			"points": [[3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104], [3.401, 29.128, 6.104, 6.104]]
		}, {
			"name":"Photocell (LDR)",
			"description":"A generic light dependent resistor (LDR)",
			"image":"core\/breadboard\/ldr.svg",
			"icon":"core\/breadboard\/ldr.svg",
			"width":"24.328",
			"height":"10.932",
			"points": [[-0.716, 3.284, 3, 3], [20.885, 3.284, 3, 3]]
		}, {
			"name":"Max Power IR LED Kit",
			"description":"\tInfrared LEDs are awesome. Along with an IR receiver they can be used for remote control and even basic remote data communication. The only problem is that your Arduino won' t drive them to their full potential.The Max Power IR LED kit solves this problem by providing you with everything you need to drive a 950nm IR LED properly.Simply solder together this easy through-hole kit and you can switch the LED using a transistor. Once the kit is assembled, simply provide it with voltage(5V), ground, and connect the CTL pin to a digital pin on your Arduino, and you can drive this kit just like a normal LED.Although the LED won 't be visible to your naked eye, you can use a video camera, cell phone camera, or digital camera to see if the LED is working properly.\tNote: This revision fixes our mistake from the last version and should now source the 50mA maximum current that the LED is rated for.\tDocuments:\t\t\tSchematic\t\t\tEagle Files\t\t\tDatasheet (IR LED)\tReplaces: KIT-10662",
			"image":"core\/breadboard\/PowerIR-v11_breadboard.svg",
			"icon":"core\/breadboard\/PowerIR-v11_breadboard.svg",
			"width":"28.8",
			"height":"54",
			"points": [[18.548, 47.348, 6.104, 6.104], [11.348, 47.348, 6.104, 6.104], [4.148, 47.348, 6.104, 6.104]]
		}, {
			"name":"Diode",
			"description":"DiodeThese are standard reverse protection diodes and small signal diodes. SMA package can handle up to about 1A. SOD-323 can handle about 200mA. What the SOD-323 package when ordering, there are some mfgs out there that are 5-pin packages.",
			"image":"core\/breadboard\/diode.svg",
			"icon":"core\/breadboard\/diode.svg",
			"width":"29.879",
			"height":"7.2",
			"points": [[-0.989, 1.583, 3, 3], [24.576, 1.583, 3, 3]]
		}, {
			"name":"SOLAR-IXYS",
			"description":"",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"USB Connectors",
			"description":"USB ConnectorsUSB-B-PTH is fully proven SKU : PRT-00139USB-miniB is fully proven SKU : PRT-00587USB-A-PCB is untested.USB-A-H is throughly reviewed, but untested. Spark Fun Electronics SKU : PRT-00437USB-B-SMT is throughly reviewed, but untested. Needs silkscreen touching up.USB-A-S has not been used\/testedUSB-MB-H has not been used\/tested",
			"image":"core\/breadboard\/sparkfun-connectors_usb-minib-nostop_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-minib-nostop_breadboard.svg",
			"width":"639.292",
			"height":"800",
			"points": [[102.681, 733.05, 33.93, 33.9], [202.681, 733.05, 33.93, 33.9], [202.681, 33.05, 33.93, 33.9], [302.681, 733.05, 33.93, 33.9], [302.681, 33.05, 33.93, 33.9], [402.681, 733.05, 33.93, 33.9], [402.681, 33.05, 33.93, 33.9], [502.681, 733.05, 33.93, 33.9], [502.681, 33.05, 33.93, 33.9]]
		}, {
			"name":"PICAXE-18A",
			"description":"PICAXE-18A from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_18A_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_18A_breadboard.svg",
			"width":"90.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [82.5, 27.66, 5, 6.34], [82.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [72.5, 27.66, 5, 6.34], [72.5, -1, 5, 6.34]]
		}, {
			"name":"Ceramic Capacitor",
			"description":"0.1\u00b5F Ceramic Disk Capacitor",
			"image":"obsolete\/breadboard\/ceramic_disk_capacitor_ochre.svg",
			"icon":"obsolete\/breadboard\/ceramic_disk_capacitor_ochre.svg",
			"width":"23",
			"height":"42.75",
			"points": [[-1, 31.75, 5, 12], [19, 31.75, 5, 12]]
		}, {
			"name":"A4950",
			"description":"Full-Bridge DMOS PWM Motor Driver",
			"image":"core\/breadboard\/A4950_42.svg",
			"icon":"core\/breadboard\/A4950_42.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}
	]
}, {
	"page":"18",
	"count": 37,
	"el": [{
			"name":"POT_SWITCH",
			"description":"Potentiometer w\/ switch.",
			"image":"core\/breadboard\/sparkfun-electromechanical_pot_pth_switch_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_pot_pth_switch_breadboard.svg",
			"width":"734.167",
			"height":"1200",
			"points": [[250.118, 1133.05, 33.93, 33.9], [350.118, 1133.05, 33.93, 33.9], [350.118, 33.05, 33.93, 33.9], [450.118, 1133.05, 33.93, 33.9], [450.118, 33.05, 33.93, 33.9]]
		}, {
			"name":"D.O. Circuit",
			"description":"Our modern understanding of how oxygen dissolves in water comes from the work of Dr. Ray Weiss. At the time when he published his findings, January 12, 1970, virtually no one had a computer. The equation he developed was so complex; he had to publish lengthy look-up tables so people could determine the correct dissolved oxygen levels quickly. At the time, Dissolved Oxygen was an exotic parameter that could only be accurately measured by governments and universities. Who would ever need to know such information anyway? Today, D.O. readings are used in so many different industries it would be ridiculous to list them all here. The Atlas Scientific D.O. Circuit is our fifth generation Dissolved Oxygen Circuit. The Atlas Scientific Dissolved Oxygen Circuit has been designed specifically to help engineers manufacture their own, custom built, scientific equipment. An easy to use data protocol and a simple instruction set means the Atlas Scientific D.O. Circuit takes only minutes to set up.The Atlas Scientific Dissolved Oxygen Circuit is designed for both continuous and intermittent readings. After calibration, the Dissolved Oxygen Sensor can be immersed in a liquid and operate continuously for 12 months before recalibration is recommended.\u2022 Full range D.O. readings +\/- 0.1\u2022 Accuracy within two significant figures (XX.XX Mg\/L)\u2022 Temperature dependent or temperature independent readings\u2022 Fresh water\/Saltwater\/Brackish water readings\u2022 Conductivity dependent or conductivity independent readings\u2022 Simple 5 second calibration\u2022 Data output is in Mg\/L\u2022 Dimensions: 13.9 mm X 20 mm (0.54'X0.78')",
			"image":"core\/breadboard\/atlas-sientific_D.O. Circuit_breadboard.svg",
			"icon":"core\/breadboard\/atlas-sientific_D.O. Circuit_breadboard.svg",
			"width":"39.465",
			"height":"58.038",
			"points": [[24.046, 0.133, 6.02, 6.02], [16.723, 0.133, 6.02, 6.02], [9.549, 51.669, 6.02, 6.02], [16.724, 51.669, 6.02, 6.02], [9.455, 0.133, 6.207, 6.03], [23.857, 51.657, 6.207, 6.031]]
		}, {
			"name":"BGB203_BLUETOOTH",
			"description":"Bluetooth SMD IC",
			"image":"core\/breadboard\/sparkfun-rf_bgb203_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_bgb203_breadboard.svg",
			"width":"2500",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"PICAXE-18M",
			"description":"PICAXE-18M from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_18M_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_18M_breadboard.svg",
			"width":"90.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [82.5, 27.66, 5, 6.34], [82.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [72.5, 27.66, 5, 6.34], [72.5, -1, 5, 6.34]]
		}, {
			"name":"MOSFET-NCHANNEL",
			"description":"Generic NMOS footprint",
			"image":"core\/breadboard\/transistor_pnp.svg",
			"icon":"core\/breadboard\/transistor_pnp.svg",
			"width":"16.527",
			"height":"24.08",
			"points": [[-1, 22, 4.16, 3], [6.181, 22, 4.16, 3], [13.367, 22, 4.16, 3]]
		}, {
			"name":"Battery Holders",
			"description":"Battery HoldersVarious common sizes : AA, AAA, 20mm coin cell and 12mm coin cell.",
			"image":"core\/breadboard\/sparkfun-electromechanical_lipo-1100mah_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_lipo-1100mah_breadboard.svg",
			"width":"96.953",
			"height":"167.043",
			"points": [[86.98, 1.046, 11.607, 4.618], [86.98, 7.525, 11.607, 4.618]]
		}, {
			"name":"LIS331",
			"description":"3-axis 6\/12\/24g SPI\/I2C accelerometer",
			"image":"core\/breadboard\/sparkfun-sensors_lga16-3mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga16-3mm_breadboard.svg",
			"width":"800",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"LY530AL",
			"description":"Single-axis 300deg\/s gyro w\/available 4x amplified output",
			"image":"core\/breadboard\/sparkfun-sensors_lga16_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga16_breadboard.svg",
			"width":"800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"AD9835",
			"description":"50MHz DDS waveform generator",
			"image":"core\/breadboard\/sparkfun-analogic_tssop16_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_tssop16_breadboard.svg",
			"width":"800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Variable Capacitor",
			"description":"",
			"image":"core\/breadboard\/capacitor_variable_3_legs.svg",
			"icon":"core\/breadboard\/capacitor_variable_3_legs.svg",
			"width":"32.024",
			"height":"29.13",
			"points": [[13.922, 24.53, 4.16, 5.251], [-0.339, 16.894, 4.881, 4.16], [27.415, 16.762, 5.076, 4.159]]
		}, {
			"name":"Generic male header-18 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_18.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_18.svg",
			"width":"129.582",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791], [37.199, 1.204, 4.791, 4.791], [44.398, 1.204, 4.791, 4.791], [51.597, 1.204, 4.791, 4.791], [58.796, 1.204, 4.791, 4.791], [65.995, 1.204, 4.791, 4.791], [73.194, 1.204, 4.791, 4.791], [80.393, 1.204, 4.791, 4.791], [87.592, 1.204, 4.791, 4.791], [94.791, 1.204, 4.791, 4.791], [101.99, 1.204, 4.791, 4.791], [109.189, 1.204, 4.791, 4.791], [116.388, 1.204, 4.791, 4.791], [123.587, 1.204, 4.791, 4.791]]
		}, {
			"name":"NC7WZ07",
			"description":"Ultra-high speed dual open-drain output buffer (non-inverting)",
			"image":"core\/breadboard\/sparkfun-digitalic_sc70-6_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sc70-6_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors. Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties. Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer. The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_eia3528-kit_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_eia3528-kit_breadboard.svg",
			"width":"412.722",
			"height":"400",
			"points": [[189.396, 333.05, 33.93, 33.9], [189.396, 33.05, 33.93, 33.9]]
		}, {
			"name":"Triple Axis Accelerometer",
			"description":"Triple Axis AccelerometerAnalog Devices ADXL330 +\/-3g 2.4V-5.25V Analog output. Spark Fun Electronics SKU : COM-00730. Center pad paste layer has been reduced to avoid shorting.",
			"image":"core\/breadboard\/sparkfun-sensors_lfcsp-16_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lfcsp-16_breadboard.svg",
			"width":"900",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"MCP2551",
			"description":"CAN transceiver",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"PICAXE-18X",
			"description":"PICAXE-18X from Revolution Education Ltd",
			"image":"core\/breadboard\/PICAXE_18X_breadboard.svg",
			"icon":"core\/breadboard\/PICAXE_18X_breadboard.svg",
			"width":"90.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [82.5, 27.66, 5, 6.34], [82.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [72.5, 27.66, 5, 6.34], [72.5, -1, 5, 6.34]]
		}, {
			"name":"Header 6",
			"description":"Header 6Standard 6-pin 0.1 header. Use with straight break away headers (SKU : PRT-00116), right angle break away headers (PRT-00553), swiss pins (PRT-00743), machine pins (PRT-00117), and female headers (PRT-00115). Molex polarized connector foot print use with SKU : PRT-08094 with associated crimp pins and housings.NOTES ON THE VARIANTS LOCK and LOCK_LONGPADS...This footprint was designed to help hold the alignment of a through-hole component (i.e. 6-pin header) while soldering it into place. You may notice that each hole has been shifted either up or down by 0.005 of an inch from it' s more standard position(which is a perfectly straight line).This slight alteration caused the pins(the squares in the middle)to touch the edges of the holes.Because they are alternating, it causes a brace to hold the component in place.0.005 has proven to be the perfect amount of off-center position when using our standard breakaway headers.Although looks a little odd when you look at the bare footprint, once you have a header in there, the alteration is very hard to notice.Also, if you push a header all the way into place, it is covered up entirely on the bottom side.This idea of altering the position of holes to aid alignment will be further integrated into the Sparkfun Library for other footprints.It can help hold any component with 3 or more connection pins.",
			"image":"core\/breadboard\/sparkfun-connectors_1x06-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_1x06-smd_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"GPS Antenna Amp",
			"description":"GPS Antenna AmpFilter and Amp built into one.Very small package.",
			"image":"core\/breadboard\/sparkfun-rf_alm-1412_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_alm-1412_breadboard.svg",
			"width":"500",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Fio(Funnel I\/O)",
			"description":"The Arduino Funnel I\/O(Fio)is a board designed by Shigeru Kobayashi, based on the original design from LilyPad.Funnel is a toolkit to sketch your idea physically, and consists of software libraries and hardware.By using Funnel, the user can interface to sensors and\/or actuators with various programming languages such as ActionScript 3, Processing, and Ruby.Arduino Fio is compatible with Funnel.It has connections for a Lithium Polymer battery and includes a charge circuit over USB.An XBee socket is available on the bottom of the board.The Fio has been designed to be wirelessly reprogrammable.Checkout our tutorial on wireless bootloading!",
			"image":"core\/breadboard\/Arduino-Fio-v22_bottom_breadboard.svg",
			"icon":"core\/breadboard\/Arduino-Fio-v22_bottom_breadboard.svg",
			"width":"186.504",
			"height":"79.297",
			"points": [[94.148, 69.045, 6.104, 6.104], [86.948, 69.045, 6.104, 6.104], [79.746, 69.045, 6.104, 6.104], [72.548, 69.045, 6.104, 6.104], [65.347, 69.045, 6.104, 6.104], [58.148, 69.045, 6.104, 6.104], [50.948, 69.045, 6.104, 6.104], [43.746, 69.045, 6.104, 6.104], [36.548, 69.045, 6.104, 6.104], [29.347, 69.045, 6.104, 6.104], [22.148, 69.045, 6.104, 6.104], [14.948, 69.045, 6.104, 6.104], [7.746, 69.045, 6.104, 6.104], [0.548, 69.045, 6.104, 6.104], [148.148, 25.845, 6.104, 6.104], [148.148, 18.645, 6.104, 6.104], [25.746, 43.844, 6.104, 6.104], [32.948, 43.844, 6.104, 6.104], [25.746, 36.645, 6.104, 6.104], [32.948, 36.645, 6.104, 6.104], [25.746, 29.446, 6.104, 6.104], [32.948, 29.446, 6.104, 6.104], [94.148, 4.245, 6.104, 6.104], [86.948, 4.245, 6.104, 6.104], [79.746, 4.245, 6.104, 6.104], [72.548, 4.245, 6.104, 6.104], [65.347, 4.245, 6.104, 6.104], [58.148, 4.245, 6.104, 6.104], [50.948, 4.245, 6.104, 6.104], [43.746, 4.245, 6.104, 6.104], [36.548, 4.245, 6.104, 6.104], [29.347, 4.245, 6.104, 6.104], [22.148, 4.245, 6.104, 6.104], [14.948, 4.245, 6.104, 6.104], [7.746, 4.245, 6.104, 6.104], [0.548, 4.245, 6.104, 6.104], [148.148, 51.045, 6.104, 6.104], [148.148, 43.844, 6.104, 6.104], [108.548, 27.645, 6.104, 6.104], [115.748, 27.645, 6.104, 6.104], [115.748, 47.444, 6.104, 6.104], [108.548, 47.444, 6.104, 6.104]]
		}, {
			"name":"SPEAKJET",
			"description":"Speech synthesis chip-COM-09578",
			"image":"core\/breadboard\/sparkfun-digitalic_soic-18_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_soic-18_breadboard.svg",
			"width":"900",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"AD7302",
			"description":"8-bit parallel input, dual output DAC",
			"image":"core\/breadboard\/sparkfun-analogic_tssop20_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_tssop20_breadboard.svg",
			"width":"1000",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"MMA7361",
			"description":"3-axis 1.5\/6g analog output accelerometer",
			"image":"core\/breadboard\/sparkfun-sensors_lga14_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga14_breadboard.svg",
			"width":"700",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Header 2",
			"description":"Header 2Standard 2-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).Molex polarized connector foot print use with SKU: PRT-08233 with associated crimp pins and housings.",
			"image":"core\/breadboard\/sparkfun-connectors_jst-2-smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_jst-2-smd_breadboard.svg",
			"width":"542.694",
			"height":"600",
			"points": [[204.382, 533.05, 33.93, 33.9], [204.382, 33.05, 33.93, 33.9], [304.382, 533.05, 33.93, 33.9], [304.382, 33.05, 33.93, 33.9]]
		}, {
			"name":"AT42QT1012",
			"description":"One channel capacitive touch sense",
			"image":"core\/breadboard\/sparkfun-sensors_sot-23-6_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_sot-23-6_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"AD5330",
			"description":"8-bit parallel input DAC",
			"image":"core\/breadboard\/sparkfun-analogic_tssop20_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_tssop20_breadboard.svg",
			"width":"1000",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"AVR ISP 6 Pin",
			"description":"AVR ISP 6 PinThis is the reduced ISP connector for AVR programming. Common on Arduino. This footprint will take up less PCB space and can be used with a 10-pin to 6-pin adapter such as SKU: BOB-08508",
			"image":"core\/breadboard\/sparkfun-connectors_2x3_lock_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_2x3_lock_breadboard.svg",
			"width":"43.197",
			"height":"36.918",
			"points": [[12.251, 25.065, 4.296, 4.296], [12.251, 17.865, 4.296, 4.296], [19.451, 25.125, 4.296, 4.296], [19.451, 17.865, 4.296, 4.296], [26.652, 25.125, 4.296, 4.296], [26.652, 17.865, 4.296, 4.296]]
		}, {
			"name":"Variable Capacitor",
			"description":"",
			"image":"core\/breadboard\/capacitor_variable_3_legs.svg",
			"icon":"core\/breadboard\/capacitor_variable_3_legs.svg",
			"width":"32.024",
			"height":"29.13",
			"points": [[13.922, 24.53, 4.16, 5.251], [-0.339, 16.894, 4.881, 4.16], [27.415, 16.762, 5.076, 4.159]]
		}, {
			"name":"TOUCH",
			"description":"Electrode for resistive touch detection",
			"image":"core\/breadboard\/sparkfun-sensors_touch1_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_touch1_breadboard.svg",
			"width":"46.8",
			"height":"49.264",
			"points": [[6.818, 21.189, 4.422, 4.422], [21.189, 21.189, 4.422, 4.422]]
		}, {
			"name":"STM32F103",
			"description":"Medium density Cortex-M3 microcontroller. http:\/\/www.st.com\/internet\/com\/TECHNICAL_RESOURCES\/TECHNICAL_LITERATURE\/DATASHEET\/CD00161566.pdf",
			"image":"core\/breadboard\/STM32F103_breadboard.svg",
			"icon":"core\/breadboard\/STM32F103_breadboard.svg",
			"width":"2400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"KA78R05 Low Dropout Voltage Regulator",
			"description":"A low-dropout or LDO regulator is a DC linear voltage regulator which can operate with a very small input\u2013output differential voltage. The advantages of a low dropout voltage include a lower minimum operating voltage, higher efficiency operation and lower heat dissipation. [Wikipedia]",
			"image":"core\/breadboard\/low_dropout_voltage_regulator_TO220_4_breadboard.svg",
			"icon":"core\/breadboard\/low_dropout_voltage_regulator_TO220_4_breadboard.svg",
			"width":"28.35",
			"height":"48.756",
			"points": [[1.192, 46.707, 4.16, 2.726], [8.39, 46.707, 4.16, 2.726], [15.589, 46.707, 4.16, 2.726], [22.789, 46.707, 4.16, 2.726]]
		}, {
			"name":"EB-85A Connector",
			"description":"EB-85A ConnectorProven layout and schematic for ETek 5Hz GPS receiver connector. Spark Fun Electronics SKU : GPS-08297",
			"image":"core\/breadboard\/sparkfun-connectors_eb-85a_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_eb-85a_breadboard.svg",
			"width":"554.333",
			"height":"600",
			"points": [[60.2015, 533.05, 33.93, 33.9], [60.2015, 33.05, 33.93, 33.9], [160.202, 533.05, 33.93, 33.9], [160.202, 33.05, 33.93, 33.9], [260.202, 533.05, 33.93, 33.9], [260.202, 33.05, 33.93, 33.9], [360.202, 533.05, 33.93, 33.9], [360.202, 33.05, 33.93, 33.9], [460.202, 533.05, 33.93, 33.9], [460.202, 33.05, 33.93, 33.9]]
		}, {
			"name":"33k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_33k.svg",
			"icon":"obsolete\/breadboard\/resistor_33k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"Arduino Yun",
			"description":"The new Arduino Yun is a microcontroller board based on the ATmega32u4 (datasheet) and the Atheros AR9331. The Atheros processor supports a Linux distribution based on OpenWRT named Linino. The board has built-in Ethernet and WiFi support, a USB-A port, micro-SD card slot, 20 digital input\/output pins (of which 7 can be used as PWM outputs and 12 as analog inputs), a 16 MHz crystal oscillator, a micro USB connection, an ICSP header, and a 3 reset buttons.",
			"image":"core\/breadboard\/arduino_Yun(rev1)_breadboard.svg",
			"icon":"core\/breadboard\/arduino_Yun(rev1)_breadboard.svg",
			"width":"207.024",
			"height":"151.536",
			"points": [[155.17, 144.07, 2, 2], [162.354, 144.07, 2, 2], [169.536, 144.07, 2, 2], [176.721, 144.07, 2, 2], [183.901, 144.07, 2, 2], [191.084, 144.07, 2, 2], [191.446, 64.519, 2, 2], [198.625, 64.519, 2, 2], [191.446, 71.751, 2, 2], [198.625, 71.751, 2, 2], [191.446, 78.982, 2, 2], [198.625, 78.982, 2, 2], [129.311, 6.663, 2, 2], [122.129, 6.663, 2, 2], [114.946, 6.663, 2, 2], [107.762, 6.663, 2, 2], [100.58, 6.663, 2, 2], [93.396, 6.663, 2, 2], [86.213, 6.663, 2, 2], [79.031, 6.663, 2, 2], [71.847, 6.663, 2, 2], [64.663, 6.663, 2, 2], [191.084, 6.663, 2, 2], [183.901, 6.663, 2, 2], [176.721, 6.663, 2, 2], [169.536, 6.663, 2, 2], [162.354, 6.663, 2, 2], [155.17, 6.663, 2, 2], [147.987, 6.663, 2, 2], [140.805, 6.663, 2, 2], [97.705, 144.07, 2, 2], [90.523, 144.07, 2, 2], [104.891, 144.07, 2, 2], [112.073, 144.07, 2, 2], [119.254, 144.07, 2, 2], [126.438, 144.07, 2, 2], [133.622, 144.07, 2, 2], [140.805, 144.07, 2, 2]]
		}, {
			"name":"Thumb Joystick",
			"description":"Thumb JoystickJoystick commonly found in PS2 controllers. Two pots and a select switch. Footprint proven. Spark Fun Electronics SKU : COM-09032",
			"image":"core\/breadboard\/sparkfun-electromechanical_joystick_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_joystick_breadboard.svg",
			"width":"1284.4",
			"height":"1400",
			"points": [[325.235, 1333.05, 33.93, 33.9], [325.235, 33.05, 33.93, 33.9], [425.235, 1333.05, 33.93, 33.9], [425.235, 33.05, 33.93, 33.9], [525.235, 1333.05, 33.93, 33.9], [525.235, 33.05, 33.93, 33.9], [625.235, 1333.05, 33.93, 33.9], [625.235, 33.05, 33.93, 33.9], [725.235, 1333.05, 33.93, 33.9], [725.235, 33.05, 33.93, 33.9], [825.235, 1333.05, 33.93, 33.9], [825.235, 33.05, 33.93, 33.9], [925.235, 1333.05, 33.93, 33.9], [925.235, 33.05, 33.93, 33.9]]
		}, {
			"name":"33k \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_33k.svg",
			"icon":"obsolete\/breadboard\/resistor_33k.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"white LED-5mm",
			"description":"A generic white LED (~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-white.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-white.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"DB9 Connector",
			"description":"DB9 ConnectorStandard DB9 (D-Sub 9) serial connector. Can be used for CAN bus as well as RS485 and RS232. Footprint production proven. Spark Fun Electronics SKU : PRT-00429",
			"image":"core\/breadboard\/sparkfun-connectors_db9_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_db9_breadboard.svg",
			"width":"1420.6",
			"height":"600",
			"points": [[443.335, 533.05, 33.93, 33.9], [543.335, 533.05, 33.93, 33.9], [543.335, 33.05, 33.93, 33.9], [643.335, 533.05, 33.93, 33.9], [643.335, 33.05, 33.93, 33.9], [743.335, 533.05, 33.93, 33.9], [743.335, 33.05, 33.93, 33.9], [843.335, 533.05, 33.93, 33.9], [843.335, 33.05, 33.93, 33.9], [943.335, 533.05, 33.93, 33.9], [943.335, 33.05, 33.93, 33.9]]
		}, {
			"name":"Voltage Regulator",
			"description":"Voltage RegulatorStandard LM317 adjustable voltage regulator. AOI (Adjust Output Input). Google 'LM317 Calculator' for easy to use app to get the two resistor values needed. 240\/720 for 5V output. 240\/390 for 3.3V output. Spark Fun Electronics SKU : COM-00527",
			"image":"core\/breadboard\/sparkfun-poweric_sot223_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_sot223_breadboard.svg",
			"width":"333",
			"height":"600",
			"points": [[99.535, 533.05, 33.93, 33.9], [99.535, 33.05, 33.93, 33.9], [199.535, 533.05, 33.93, 33.9], [199.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic female header-metal rounded-12 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_12.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_12.svg",
			"width":"86.148",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783], [15.556, 1.197, 4.783, 4.783], [22.735, 1.197, 4.783, 4.783], [29.914, 1.197, 4.783, 4.783], [37.093, 1.197, 4.783, 4.783], [44.272, 1.197, 4.783, 4.783], [51.451, 1.197, 4.783, 4.783], [58.63, 1.197, 4.783, 4.783], [65.809, 1.197, 4.783, 4.783], [72.988, 1.197, 4.783, 4.783], [80.167, 1.197, 4.783, 4.783]]
		}, {
			"name":"SWITCH-MOMENTARY-2",
			"description":"Various NO switches- pushbuttons, reed, etc",
			"image":"core\/breadboard\/sparkfun-electromechanical_tactile-pth-12mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_tactile-pth-12mm_breadboard.svg",
			"width":"672.44",
			"height":"800",
			"points": [[269.255, 733.05, 33.93, 33.9], [269.255, 33.05, 33.93, 33.9], [369.255, 733.05, 33.93, 33.9], [369.255, 33.05, 33.93, 33.9]]
		}, {
			"name":"SPI_FLASH-X25XX",
			"description":"8pin SPI Flash series x25xx. Works with devices like W25X32 and BR25L32",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"CRYSTAL",
			"description":"Various standard crystals. Proven footprints. Spark Fun Electronics SKU : COM-00534",
			"image":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"icon":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"width":"15.457",
			"height":"43.819",
			"points": [[2.451, 39.819, 4.152, 3], [9.651, 39.819, 4.152, 3]]
		}, {
			"name":"SV74LV4052APWR",
			"description":"Dual 4:1 analog mux",
			"image":"core\/breadboard\/sparkfun-analogic_tssop16_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_tssop16_breadboard.svg",
			"width":"800",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"AUDIO-JACK2",
			"description":"Stereo audio jack with bypass switches.",
			"image":"core\/breadboard\/sparkfun-connectors_audio-jack_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_audio-jack_breadboard.svg",
			"width":"686.75",
			"height":"800",
			"points": [[226.41, 733.05, 33.93, 33.9], [326.41, 733.05, 33.93, 33.9], [326.41, 33.05, 33.93, 33.9], [426.41, 733.05, 33.93, 33.9], [426.41, 33.05, 33.93, 33.9]]
		}
	]
}, {
	"page":"19",
	"count": 37,
	"el": [{
			"name":"MCP4725",
			"description":"The MCP4725 is a low-power, high accuracy, single channel, buffered voltage output 12-bit Digital-to-Analog Convertor (DAC) with non-volatile memory (EEPROM). Its on-board precision output amplifier allows it to achieve rail-to-rail analog output.",
			"image":"core\/breadboard\/sparkfun-analogic_sot23-6_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-analogic_sot23-6_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"MAX7456",
			"description":"Monochrome NTSC\/PAL on-screen display generator (SPI)",
			"image":"core\/breadboard\/sparkfun-digitalic_tssop28_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tssop28_breadboard.svg",
			"width":"1400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"CRYSTAL",
			"description":"Various standard crystals. Proven footprints. Spark Fun Electronics SKU : COM-00534",
			"image":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"icon":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"width":"15.457",
			"height":"43.819",
			"points": [[2.451, 39.819, 4.152, 3], [9.651, 39.819, 4.152, 3]]
		}, {
			"name":"NJM2670",
			"description":"Dual H-bridge driver",
			"image":"core\/breadboard\/SO-24W_breadboard.svg",
			"icon":"core\/breadboard\/SO-24W_breadboard.svg",
			"width":"86.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968], [51.8505, 37.4516, 4.29896, 4.2968], [51.8505, 1.4516, 4.29896, 4.2968], [59.0505, 37.4516, 4.29896, 4.2968], [59.0505, 1.4516, 4.29896, 4.2968], [66.2505, 37.4516, 4.29896, 4.2968], [66.2505, 1.4516, 4.29896, 4.2968], [73.4509, 37.4516, 4.29896, 4.2968], [73.4509, 1.4516, 4.29896, 4.2968], [80.6509, 37.4516, 4.29896, 4.2968], [80.6509, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Arduino Mega",
			"description":"The biggest, baddest Arduino board yet.",
			"image":"obsolete\/breadboard\/controller_arduino_mega.svg",
			"icon":"obsolete\/breadboard\/controller_arduino_mega.svg",
			"width":"306.072",
			"height":"148.031",
			"points": [[81.639, 3.123, 4.772, 4.771], [88.814, 3.123, 4.771, 4.771], [95.991, 3.123, 4.772, 4.771], [103.166, 3.123, 4.774, 4.771], [110.344, 3.123, 4.772, 4.771], [117.519, 3.123, 4.771, 4.771], [124.697, 3.123, 4.773, 4.771], [131.873, 3.123, 4.772, 4.771], [146.416, 3.123, 4.771, 4.771], [153.591, 3.123, 4.773, 4.771], [160.768, 3.123, 4.771, 4.771], [167.944, 3.123, 4.771, 4.771], [175.12, 3.123, 4.773, 4.771], [182.296, 3.123, 4.772, 4.771], [189.473, 3.123, 4.771, 4.771], [196.649, 3.123, 4.772, 4.771], [110.428, 139.875, 4.772, 4.771], [117.626, 139.875, 4.773, 4.771], [124.823, 139.875, 4.773, 4.771], [132, 139.875, 4.771, 4.771], [139.176, 139.875, 4.774, 4.771], [146.35, 139.875, 4.772, 4.771], [160.811, 139.875, 4.771, 4.771], [167.987, 139.875, 4.772, 4.771], [175.163, 139.875, 4.772, 4.771], [182.339, 139.875, 4.771, 4.771], [189.515, 139.875, 4.772, 4.771], [196.691, 139.875, 4.771, 4.771], [211.239, 3.123, 4.771, 4.771], [218.413, 3.123, 4.772, 4.771], [225.59, 3.123, 4.772, 4.771], [232.766, 3.123, 4.771, 4.771], [239.942, 3.123, 4.771, 4.771], [247.118, 3.123, 4.771, 4.771], [254.294, 3.123, 4.773, 4.771], [261.472, 3.123, 4.772, 4.771], [282.984, 10.3, 4.771, 4.771], [290.16, 10.3, 4.773, 4.771], [282.984, 17.478, 4.771, 4.771], [290.16, 17.478, 4.773, 4.771], [282.984, 24.653, 4.771, 4.771], [290.16, 24.653, 4.773, 4.771], [282.984, 31.83, 4.771, 4.771], [290.16, 31.83, 4.773, 4.771], [282.984, 39.005, 4.771, 4.771], [290.16, 39.005, 4.773, 4.771], [282.984, 46.182, 4.771, 4.771], [290.16, 46.182, 4.773, 4.771], [282.984, 53.358, 4.772, 4.771], [290.16, 53.358, 4.773, 4.771], [282.982, 60.537, 4.772, 4.771], [290.16, 60.537, 4.773, 4.771], [282.982, 67.714, 4.771, 4.771], [290.16, 67.714, 4.773, 4.771], [282.986, 74.888, 4.772, 4.771], [290.16, 74.888, 4.773, 4.771], [282.988, 82.06, 4.771, 4.771], [290.16, 82.06, 4.773, 4.771], [282.984, 89.235, 4.772, 4.772], [290.16, 89.235, 4.773, 4.772], [282.984, 96.412, 4.771, 4.771], [290.16, 96.412, 4.773, 4.771], [282.984, 103.589, 4.771, 4.771], [290.16, 103.589, 4.773, 4.771], [282.984, 110.764, 4.772, 4.772], [290.16, 110.764, 4.773, 4.772], [282.984, 117.939, 4.771, 4.773], [290.16, 117.939, 4.773, 4.773], [282.984, 125.119, 4.772, 4.772], [290.16, 125.119, 4.773, 4.772], [203.868, 139.874, 4.772, 4.771], [211.044, 139.874, 4.771, 4.771], [225.501, 139.874, 4.772, 4.771], [232.68, 139.874, 4.771, 4.771], [239.855, 139.874, 4.771, 4.771], [247.03, 139.874, 4.772, 4.771], [254.206, 139.874, 4.771, 4.771], [261.384, 139.874, 4.771, 4.771], [268.536, 139.874, 4.772, 4.771], [275.735, 139.874, 4.771, 4.771], [282.984, 3.122, 4.771, 4.771], [290.16, 3.122, 4.773, 4.771]]
		}, {
			"name":"LM 358 Dual Op-Amp",
			"description":"The classic LM 358 Dual Operational Amplifier (Op-Amp). The analog swiss-army knife.",
			"image":"core\/breadboard\/lm358_bread.svg",
			"icon":"core\/breadboard\/lm358_bread.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [22.5, -1, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [2.5, -1, 5, 6.3400002]]
		}, {
			"name":"680 \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_680.svg",
			"icon":"obsolete\/breadboard\/resistor_680.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"MCP42xxx",
			"description":"SPI controlled dual digital potentiometer by Microchip",
			"image":"core\/breadboard\/SOIC-14_breadboard.svg",
			"icon":"core\/breadboard\/SOIC-14_breadboard.svg",
			"width":"50.4",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968], [30.2505, 37.4516, 4.29896, 4.2968], [30.2505, 1.4516, 4.29896, 4.2968], [37.4505, 37.4516, 4.29896, 4.2968], [37.4505, 1.4516, 4.29896, 4.2968], [44.6505, 37.4516, 4.29896, 4.2968], [44.6505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"Generic male header-8 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_8.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_8.svg",
			"width":"57.592",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791], [37.199, 1.204, 4.791, 4.791], [44.398, 1.204, 4.791, 4.791], [51.597, 1.204, 4.791, 4.791]]
		}, {
			"name":"680 \u2126 Resistor",
			"description":"A generic resistor (0.25W)",
			"image":"obsolete\/breadboard\/resistor_680.svg",
			"icon":"obsolete\/breadboard\/resistor_680.svg",
			"width":"42.917",
			"height":"9.45",
			"points": [[-1, 2.59, 8.5, 4.91], [35.417, 2.59, 8.5, 4.91]]
		}, {
			"name":"3.5mm Audio Jack",
			"description":"Simple 3.5mm common PCB mount audio jack. SKU: PRT-08032",
			"image":"core\/breadboard\/sparkfun-connectors_audio-jack_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_audio-jack_breadboard.svg",
			"width":"686.75",
			"height":"800",
			"points": [[226.41, 733.05, 33.93, 33.9], [326.41, 733.05, 33.93, 33.9], [326.41, 33.05, 33.93, 33.9], [426.41, 733.05, 33.93, 33.9], [426.41, 33.05, 33.93, 33.9]]
		}, {
			"name":"Carrier Card expansion area",
			"description":"The Carrier Card is a prototype board for use with the Carrier Board. This Carrier Card can be separated into two parts. Both parts have a series of +3V pins along their left edge and a series of GND pins along their right edge. All the header pins on the top row are labeled and connected to a free hole below. There's a mounting hole to fasten the right side to the center of the bottom ABS shell.",
			"image":"core\/breadboard\/jlpcb-089_breadboard.svg",
			"icon":"core\/breadboard\/jlpcb-089_breadboard.svg",
			"width":"340.838",
			"height":"93.6",
			"points": [[325.565, 4.4, 5.6, 5.6], [318.365, 3.68, 5.6, 5.6], [311.165, 4.4, 5.6, 5.6], [303.965, 3.68, 5.6, 5.6], [296.765, 4.4, 5.6, 5.6], [289.565, 3.68, 5.6, 5.6], [275.165, 4.4, 5.6, 5.6], [267.965, 3.68, 5.6, 5.6], [260.765, 4.4, 5.6, 5.6], [253.565, 3.68, 5.6, 5.6], [246.365, 4.4, 5.6, 5.6], [239.165, 3.68, 5.6, 5.6], [124.055, 11.69, 5.42, 5.42], [109.655, 11.69, 5.42, 5.42], [95.2554, 11.69, 5.42, 5.42], [116.855, 11.69, 5.42, 5.42], [188.855, 11.69, 5.42, 5.42], [275.255, 11.69, 5.42, 5.42], [268.055, 11.69, 5.42, 5.42], [260.855, 11.69, 5.42, 5.42], [253.655, 11.69, 5.42, 5.42], [246.455, 11.69, 5.42, 5.42], [59.2554, 11.69, 5.42, 5.42], [44.8554, 11.69, 5.42, 5.42], [30.4554, 11.69, 5.42, 5.42], [52.0554, 11.69, 5.42, 5.42], [37.6554, 11.69, 5.42, 5.42], [102.455, 11.69, 5.42, 5.42], [88.0554, 11.69, 5.42, 5.42], [217.655, 11.69, 5.42, 5.42], [224.855, 11.69, 5.42, 5.42], [210.455, 11.69, 5.42, 5.42], [203.255, 11.69, 5.42, 5.42], [239.255, 11.69, 5.42, 5.42], [325.655, 11.69, 5.42, 5.42], [318.455, 11.69, 5.42, 5.42], [311.255, 11.69, 5.42, 5.42], [304.055, 11.69, 5.42, 5.42], [296.855, 11.69, 5.42, 5.42], [23.2554, 11.69, 5.42, 5.42], [196.055, 11.69, 5.42, 5.42], [289.655, 11.69, 5.42, 5.42], [15.9936, 15.2282, 5.5436, 5.5436], [8.7936, 8.0282, 5.5436, 5.5436], [8.7936, 15.2282, 5.5436, 5.5436], [8.7936, 0.8282, 5.5436, 5.5436], [80.7936, 8.0282, 5.5436, 5.5436], [80.7936, 15.2282, 5.5436, 5.5436], [80.7936, 0.8282, 5.5436, 5.5436], [73.5936, 8.0282, 5.5436, 5.5436], [73.5936, 0.8282, 5.5436, 5.5436], [66.3936, 8.0282, 5.5436, 5.5436], [66.3936, 15.2282, 5.5436, 5.5436], [66.3936, 0.8282, 5.5436, 5.5436], [181.5932, 0.8282, 5.5436, 5.5436], [332.7932, 0.8282, 5.5436, 5.5436], [145.5932, 8.0282, 5.5436, 5.5436], [145.5932, 0.8282, 5.5436, 5.5436], [145.5932, 15.2282, 5.5436, 5.5436], [15.9936, 8.0282, 5.5436, 5.5436], [15.9936, 0.8282, 5.5436, 5.5436], [138.3932, 15.2282, 5.5436, 5.5436], [131.1932, 15.2282, 5.5436, 5.5436], [131.1932, 8.0282, 5.5436, 5.5436], [131.1932, 0.8282, 5.5436, 5.5436], [138.3932, 8.0282, 5.5436, 5.5436], [138.3932, 0.8282, 5.5436, 5.5436], [332.7932, 8.0282, 5.5436, 5.5436], [332.7932, 15.2282, 5.5436, 5.5436], [152.7932, 0.8282, 5.5436, 5.5436], [152.7932, 8.0282, 5.5436, 5.5436], [181.5932, 8.0282, 5.5436, 5.5436], [181.5932, 15.2282, 5.5436, 5.5436], [174.3932, 15.2282, 5.5436, 5.5436], [167.1932, 15.2282, 5.5436, 5.5436], [159.9932, 15.2282, 5.5436, 5.5436], [159.9932, 8.0282, 5.5436, 5.5436], [159.9932, 0.8282, 5.5436, 5.5436], [59.32981, 4.56441, 5.27118, 5.27118], [52.12981, 4.56441, 5.27118, 5.27118], [44.92981, 4.56441, 5.27118, 5.27118], [37.72981, 4.56441, 5.27118, 5.27118], [30.52981, 4.56441, 5.27118, 5.27118], [23.32981, 4.56441, 5.27118, 5.27118], [224.92941, 4.56441, 5.27118, 5.27118], [217.72941, 4.56441, 5.27118, 5.27118], [210.52941, 4.56441, 5.27118, 5.27118], [203.32941, 4.56441, 5.27118, 5.27118], [196.12941, 4.56441, 5.27118, 5.27118], [188.92941, 4.56441, 5.27118, 5.27118], [124.12941, 4.56441, 5.27118, 5.27118], [116.92941, 4.56441, 5.27118, 5.27118], [109.72941, 4.56441, 5.27118, 5.27118], [102.52941, 4.56441, 5.27118, 5.27118], [95.32981, 4.56441, 5.27118, 5.27118], [88.12981, 4.56441, 5.27118, 5.27118], [210.3932, 65.6282, 5.5436, 5.5436], [325.5932, 87.2282, 5.5436, 5.5436], [325.5932, 80.0282, 5.5436, 5.5436], [325.5932, 72.8282, 5.5436, 5.5436], [325.5932, 65.6282, 5.5436, 5.5436], [282.3932, 65.6282, 5.5436, 5.5436], [318.3932, 87.2282, 5.5436, 5.5436], [318.3932, 80.0282, 5.5436, 5.5436], [318.3932, 72.8282, 5.5436, 5.5436], [318.3932, 65.6282, 5.5436, 5.5436], [311.1932, 87.2282, 5.5436, 5.5436], [311.1932, 80.0282, 5.5436, 5.5436], [303.9932, 87.2282, 5.5436, 5.5436], [296.7932, 87.2282, 5.5436, 5.5436], [303.9932, 72.8282, 5.5436, 5.5436], [296.7932, 72.8282, 5.5436, 5.5436], [311.1932, 72.8282, 5.5436, 5.5436], [311.1932, 65.6282, 5.5436, 5.5436], [275.1932, 65.6282, 5.5436, 5.5436], [267.9932, 72.8282, 5.5436, 5.5436], [282.3932, 87.2282, 5.5436, 5.5436], [275.1932, 87.2282, 5.5436, 5.5436], [282.3932, 72.8282, 5.5436, 5.5436], [275.1932, 72.8282, 5.5436, 5.5436], [303.9932, 80.0282, 5.5436, 5.5436], [296.7932, 80.0282, 5.5436, 5.5436], [289.5932, 80.0282, 5.5436, 5.5436], [289.5932, 87.2282, 5.5436, 5.5436], [303.9932, 65.6282, 5.5436, 5.5436], [296.7932, 65.6282, 5.5436, 5.5436], [289.5932, 65.6282, 5.5436, 5.5436], [289.5932, 72.8282, 5.5436, 5.5436], [275.1932, 80.0282, 5.5436, 5.5436], [282.3932, 80.0282, 5.5436, 5.5436], [267.9932, 87.2282, 5.5436, 5.5436], [224.7932, 65.6282, 5.5436, 5.5436], [267.9932, 65.6282, 5.5436, 5.5436], [260.7932, 65.6282, 5.5436, 5.5436], [253.5932, 87.2282, 5.5436, 5.5436], [231.9932, 87.2282, 5.5436, 5.5436], [260.7932, 87.2282, 5.5436, 5.5436], [239.1932, 87.2282, 5.5436, 5.5436], [246.3932, 87.2282, 5.5436, 5.5436], [253.5932, 72.8282, 5.5436, 5.5436], [231.9932, 72.8282, 5.5436, 5.5436], [260.7932, 72.8282, 5.5436, 5.5436], [239.1932, 72.8282, 5.5436, 5.5436], [246.3932, 72.8282, 5.5436, 5.5436], [217.5932, 87.2282, 5.5436, 5.5436], [195.9932, 87.2282, 5.5436, 5.5436], [224.7932, 87.2282, 5.5436, 5.5436], [203.1932, 87.2282, 5.5436, 5.5436], [210.3932, 87.2282, 5.5436, 5.5436], [217.5932, 72.8282, 5.5436, 5.5436], [195.9932, 72.8282, 5.5436, 5.5436], [224.7932, 72.8282, 5.5436, 5.5436], [203.1932, 72.8282, 5.5436, 5.5436], [210.3932, 72.8282, 5.5436, 5.5436], [239.1932, 65.6282, 5.5436, 5.5436], [231.9932, 65.6282, 5.5436, 5.5436], [217.5932, 65.6282, 5.5436, 5.5436], [246.3932, 65.6282, 5.5436, 5.5436], [217.5932, 80.0282, 5.5436, 5.5436], [253.5932, 80.0282, 5.5436, 5.5436], [231.9932, 80.0282, 5.5436, 5.5436], [260.7932, 80.0282, 5.5436, 5.5436], [239.1932, 80.0282, 5.5436, 5.5436], [246.3932, 80.0282, 5.5436, 5.5436], [253.5932, 65.6282, 5.5436, 5.5436], [195.9932, 80.0282, 5.5436, 5.5436], [210.3932, 80.0282, 5.5436, 5.5436], [203.1932, 80.0282, 5.5436, 5.5436], [267.9932, 80.0282, 5.5436, 5.5436], [224.7932, 80.0282, 5.5436, 5.5436], [123.9932, 87.2282, 5.5436, 5.5436], [95.1936, 87.2282, 5.5436, 5.5436], [66.3936, 87.2282, 5.5436, 5.5436], [109.5932, 87.2282, 5.5436, 5.5436], [80.7936, 87.2282, 5.5436, 5.5436], [123.9932, 72.8282, 5.5436, 5.5436], [95.1936, 72.8282, 5.5436, 5.5436], [66.3936, 72.8282, 5.5436, 5.5436], [109.5932, 72.8282, 5.5436, 5.5436], [80.7936, 72.8282, 5.5436, 5.5436], [123.9932, 58.4282, 5.5436, 5.5436], [95.1936, 58.4282, 5.5436, 5.5436], [66.3936, 58.4282, 5.5436, 5.5436], [109.5932, 58.4282, 5.5436, 5.5436], [80.7936, 58.4282, 5.5436, 5.5436], [131.1932, 87.2282, 5.5436, 5.5436], [102.3932, 87.2282, 5.5436, 5.5436], [73.5936, 87.2282, 5.5436, 5.5436], [116.7932, 87.2282, 5.5436, 5.5436], [87.9936, 87.2282, 5.5436, 5.5436], [131.1932, 72.8282, 5.5436, 5.5436], [102.3932, 72.8282, 5.5436, 5.5436], [73.5936, 72.8282, 5.5436, 5.5436], [116.7932, 72.8282, 5.5436, 5.5436], [87.9936, 72.8282, 5.5436, 5.5436], [131.1932, 58.4282, 5.5436, 5.5436], [102.3932, 58.4282, 5.5436, 5.5436], [73.5936, 58.4282, 5.5436, 5.5436], [116.7932, 58.4282, 5.5436, 5.5436], [87.9936, 58.4282, 5.5436, 5.5436], [203.1932, 65.6282, 5.5436, 5.5436], [188.7932, 87.2282, 5.5436, 5.5436], [188.7932, 72.8282, 5.5436, 5.5436], [195.9932, 65.6282, 5.5436, 5.5436], [188.7932, 80.0282, 5.5436, 5.5436], [123.9932, 80.0282, 5.5436, 5.5436], [95.1936, 80.0282, 5.5436, 5.5436], [66.3936, 80.0282, 5.5436, 5.5436], [109.5932, 80.0282, 5.5436, 5.5436], [80.7936, 80.0282, 5.5436, 5.5436], [123.9932, 65.6282, 5.5436, 5.5436], [95.1936, 65.6282, 5.5436, 5.5436], [66.3936, 65.6282, 5.5436, 5.5436], [109.5932, 65.6282, 5.5436, 5.5436], [80.7936, 65.6282, 5.5436, 5.5436], [123.9932, 51.2282, 5.5436, 5.5436], [95.1936, 51.2282, 5.5436, 5.5436], [66.3936, 51.2282, 5.5436, 5.5436], [109.5932, 51.2282, 5.5436, 5.5436], [80.7936, 51.2282, 5.5436, 5.5436], [131.1932, 80.0282, 5.5436, 5.5436], [102.3932, 80.0282, 5.5436, 5.5436], [73.5936, 80.0282, 5.5436, 5.5436], [116.7932, 80.0282, 5.5436, 5.5436], [87.9936, 80.0282, 5.5436, 5.5436], [131.1932, 65.6282, 5.5436, 5.5436], [102.3932, 65.6282, 5.5436, 5.5436], [73.5936, 65.6282, 5.5436, 5.5436], [116.7932, 65.6282, 5.5436, 5.5436], [87.9936, 65.6282, 5.5436, 5.5436], [131.1932, 51.2282, 5.5436, 5.5436], [102.3932, 51.2282, 5.5436, 5.5436], [73.5936, 51.2282, 5.5436, 5.5436], [116.7932, 51.2282, 5.5436, 5.5436], [87.9936, 51.2282, 5.5436, 5.5436], [325.5932, 58.4282, 5.5436, 5.5436], [296.7932, 58.4282, 5.5436, 5.5436], [267.9932, 58.4282, 5.5436, 5.5436], [239.1932, 58.4282, 5.5436, 5.5436], [210.3932, 58.4282, 5.5436, 5.5436], [181.5932, 58.4282, 5.5436, 5.5436], [188.7932, 22.4282, 5.5436, 5.5436], [325.5932, 44.0282, 5.5436, 5.5436], [296.7932, 44.0282, 5.5436, 5.5436], [267.9932, 44.0282, 5.5436, 5.5436], [239.1932, 44.0282, 5.5436, 5.5436], [210.3932, 44.0282, 5.5436, 5.5436], [181.5932, 44.0282, 5.5436, 5.5436], [246.3932, 22.4282, 5.5436, 5.5436], [325.5932, 29.6282, 5.5436, 5.5436], [296.7932, 29.6282, 5.5436, 5.5436], [267.9932, 29.6282, 5.5436, 5.5436], [239.1932, 29.6282, 5.5436, 5.5436], [210.3932, 29.6282, 5.5436, 5.5436], [181.5932, 29.6282, 5.5436, 5.5436], [303.9932, 22.4282, 5.5436, 5.5436], [325.5932, 51.2282, 5.5436, 5.5436], [296.7932, 51.2282, 5.5436, 5.5436], [267.9932, 51.2282, 5.5436, 5.5436], [239.1932, 51.2282, 5.5436, 5.5436], [210.3932, 51.2282, 5.5436, 5.5436], [181.5932, 51.2282, 5.5436, 5.5436], [217.5932, 22.4282, 5.5436, 5.5436], [325.5932, 36.8282, 5.5436, 5.5436], [296.7932, 36.8282, 5.5436, 5.5436], [267.9932, 36.8282, 5.5436, 5.5436], [239.1932, 36.8282, 5.5436, 5.5436], [210.3932, 36.8282, 5.5436, 5.5436], [181.5932, 36.8282, 5.5436, 5.5436], [275.1932, 22.4282, 5.5436, 5.5436], [318.3932, 58.4282, 5.5436, 5.5436], [289.5932, 58.4282, 5.5436, 5.5436], [260.7932, 58.4282, 5.5436, 5.5436], [231.9932, 58.4282, 5.5436, 5.5436], [203.1932, 58.4282, 5.5436, 5.5436], [210.3932, 22.4282, 5.5436, 5.5436], [303.9932, 36.8282, 5.5436, 5.5436], [318.3932, 44.0282, 5.5436, 5.5436], [289.5932, 44.0282, 5.5436, 5.5436], [260.7932, 44.0282, 5.5436, 5.5436], [231.9932, 44.0282, 5.5436, 5.5436], [203.1932, 44.0282, 5.5436, 5.5436], [267.9932, 22.4282, 5.5436, 5.5436], [275.1932, 36.8282, 5.5436, 5.5436], [318.3932, 29.6282, 5.5436, 5.5436], [289.5932, 29.6282, 5.5436, 5.5436], [260.7932, 29.6282, 5.5436, 5.5436], [231.9932, 29.6282, 5.5436, 5.5436], [203.1932, 29.6282, 5.5436, 5.5436], [325.5932, 22.4282, 5.5436, 5.5436], [246.3932, 36.8282, 5.5436, 5.5436], [318.3932, 51.2282, 5.5436, 5.5436], [289.5932, 51.2282, 5.5436, 5.5436], [260.7932, 51.2282, 5.5436, 5.5436], [231.9932, 51.2282, 5.5436, 5.5436], [203.1932, 51.2282, 5.5436, 5.5436], [239.1932, 22.4282, 5.5436, 5.5436], [217.5932, 36.8282, 5.5436, 5.5436], [318.3932, 36.8282, 5.5436, 5.5436], [289.5932, 36.8282, 5.5436, 5.5436], [260.7932, 36.8282, 5.5436, 5.5436], [231.9932, 36.8282, 5.5436, 5.5436], [203.1932, 36.8282, 5.5436, 5.5436], [296.7932, 22.4282, 5.5436, 5.5436], [188.7932, 36.8282, 5.5436, 5.5436], [311.1932, 58.4282, 5.5436, 5.5436], [282.3932, 58.4282, 5.5436, 5.5436], [253.5932, 58.4282, 5.5436, 5.5436], [224.7932, 58.4282, 5.5436, 5.5436], [195.9932, 58.4282, 5.5436, 5.5436], [203.1932, 22.4282, 5.5436, 5.5436], [188.7932, 51.2282, 5.5436, 5.5436], [311.1932, 44.0282, 5.5436, 5.5436], [282.3932, 44.0282, 5.5436, 5.5436], [253.5932, 44.0282, 5.5436, 5.5436], [224.7932, 44.0282, 5.5436, 5.5436], [195.9932, 44.0282, 5.5436, 5.5436], [260.7932, 22.4282, 5.5436, 5.5436], [282.3932, 22.4282, 5.5436, 5.5436], [311.1932, 29.6282, 5.5436, 5.5436], [282.3932, 29.6282, 5.5436, 5.5436], [253.5932, 29.6282, 5.5436, 5.5436], [224.7932, 29.6282, 5.5436, 5.5436], [195.9932, 29.6282, 5.5436, 5.5436], [318.3932, 22.4282, 5.5436, 5.5436], [224.7932, 22.4282, 5.5436, 5.5436], [311.1932, 51.2282, 5.5436, 5.5436], [282.3932, 51.2282, 5.5436, 5.5436], [253.5932, 51.2282, 5.5436, 5.5436], [224.7932, 51.2282, 5.5436, 5.5436], [195.9932, 51.2282, 5.5436, 5.5436], [231.9932, 22.4282, 5.5436, 5.5436], [188.7932, 65.6282, 5.5436, 5.5436], [311.1932, 36.8282, 5.5436, 5.5436], [282.3932, 36.8282, 5.5436, 5.5436], [253.5932, 36.8282, 5.5436, 5.5436], [224.7932, 36.8282, 5.5436, 5.5436], [195.9932, 36.8282, 5.5436, 5.5436], [289.5932, 22.4282, 5.5436, 5.5436], [181.5932, 87.2282, 5.5436, 5.5436], [303.9932, 58.4282, 5.5436, 5.5436], [275.1932, 58.4282, 5.5436, 5.5436], [246.3932, 58.4282, 5.5436, 5.5436], [217.5932, 58.4282, 5.5436, 5.5436], [188.7932, 58.4282, 5.5436, 5.5436], [195.9932, 22.4282, 5.5436, 5.5436], [181.5932, 80.0282, 5.5436, 5.5436], [303.9932, 44.0282, 5.5436, 5.5436], [275.1932, 44.0282, 5.5436, 5.5436], [246.3932, 44.0282, 5.5436, 5.5436], [217.5932, 44.0282, 5.5436, 5.5436], [188.7932, 44.0282, 5.5436, 5.5436], [253.5932, 22.4282, 5.5436, 5.5436], [181.5932, 72.8282, 5.5436, 5.5436], [303.9932, 29.6282, 5.5436, 5.5436], [275.1932, 29.6282, 5.5436, 5.5436], [246.3932, 29.6282, 5.5436, 5.5436], [217.5932, 29.6282, 5.5436, 5.5436], [188.7932, 29.6282, 5.5436, 5.5436], [311.1932, 22.4282, 5.5436, 5.5436], [181.5932, 65.6282, 5.5436, 5.5436], [303.9932, 51.2282, 5.5436, 5.5436], [275.1932, 51.2282, 5.5436, 5.5436], [246.3932, 51.2282, 5.5436, 5.5436], [217.5932, 51.2282, 5.5436, 5.5436], [159.9932, 65.6282, 5.5436, 5.5436], [159.9932, 51.2282, 5.5436, 5.5436], [159.9932, 72.8282, 5.5436, 5.5436], [159.9932, 58.4282, 5.5436, 5.5436], [152.7932, 65.6282, 5.5436, 5.5436], [152.7932, 51.2282, 5.5436, 5.5436], [152.7932, 72.8282, 5.5436, 5.5436], [152.7932, 58.4282, 5.5436, 5.5436], [174.3932, 65.6282, 5.5436, 5.5436], [174.3932, 51.2282, 5.5436, 5.5436], [174.3932, 72.8282, 5.5436, 5.5436], [174.3932, 58.4282, 5.5436, 5.5436], [167.1932, 65.6282, 5.5436, 5.5436], [167.1932, 51.2282, 5.5436, 5.5436], [167.1932, 72.8282, 5.5436, 5.5436], [167.1932, 58.4282, 5.5436, 5.5436], [109.5932, 36.8282, 5.5436, 5.5436], [80.7936, 36.8282, 5.5436, 5.5436], [51.9936, 36.8282, 5.5436, 5.5436], [23.1936, 36.8282, 5.5436, 5.5436], [44.7936, 65.6282, 5.5436, 5.5436], [15.9936, 65.6282, 5.5436, 5.5436], [152.7932, 36.8282, 5.5436, 5.5436], [152.7932, 22.4282, 5.5436, 5.5436], [109.5932, 22.4282, 5.5436, 5.5436], [80.7936, 22.4282, 5.5436, 5.5436], [51.9936, 22.4282, 5.5436, 5.5436], [23.1936, 22.4282, 5.5436, 5.5436], [44.7936, 51.2282, 5.5436, 5.5436], [15.9936, 51.2282, 5.5436, 5.5436], [37.5936, 80.0282, 5.5436, 5.5436], [167.1932, 80.0282, 5.5436, 5.5436], [109.5932, 44.0282, 5.5436, 5.5436], [80.7936, 44.0282, 5.5436, 5.5436], [51.9936, 44.0282, 5.5436, 5.5436], [23.1936, 44.0282, 5.5436, 5.5436], [44.7936, 72.8282, 5.5436, 5.5436], [15.9936, 72.8282, 5.5436, 5.5436], [152.7932, 44.0282, 5.5436, 5.5436], [152.7932, 29.6282, 5.5436, 5.5436], [109.5932, 29.6282, 5.5436, 5.5436], [80.7936, 29.6282, 5.5436, 5.5436], [51.9936, 29.6282, 5.5436, 5.5436], [23.1936, 29.6282, 5.5436, 5.5436], [44.7936, 58.4282, 5.5436, 5.5436], [15.9936, 58.4282, 5.5436, 5.5436], [37.5936, 87.2282, 5.5436, 5.5436], [167.1932, 87.2282, 5.5436, 5.5436], [116.7932, 36.8282, 5.5436, 5.5436], [87.9936, 36.8282, 5.5436, 5.5436], [59.1936, 36.8282, 5.5436, 5.5436], [30.3936, 36.8282, 5.5436, 5.5436], [51.9936, 65.6282, 5.5436, 5.5436], [23.1936, 65.6282, 5.5436, 5.5436], [159.9932, 36.8282, 5.5436, 5.5436], [159.9932, 22.4282, 5.5436, 5.5436], [116.7932, 22.4282, 5.5436, 5.5436], [87.9936, 22.4282, 5.5436, 5.5436], [59.1936, 22.4282, 5.5436, 5.5436], [30.3936, 22.4282, 5.5436, 5.5436], [51.9936, 51.2282, 5.5436, 5.5436], [23.1936, 51.2282, 5.5436, 5.5436], [44.7936, 80.0282, 5.5436, 5.5436], [15.9936, 80.0282, 5.5436, 5.5436], [116.7932, 44.0282, 5.5436, 5.5436], [87.9936, 44.0282, 5.5436, 5.5436], [59.1936, 44.0282, 5.5436, 5.5436], [30.3936, 44.0282, 5.5436, 5.5436], [51.9936, 72.8282, 5.5436, 5.5436], [23.1936, 72.8282, 5.5436, 5.5436], [159.9932, 44.0282, 5.5436, 5.5436], [159.9932, 29.6282, 5.5436, 5.5436], [116.7932, 29.6282, 5.5436, 5.5436], [87.9936, 29.6282, 5.5436, 5.5436], [59.1936, 29.6282, 5.5436, 5.5436], [30.3936, 29.6282, 5.5436, 5.5436], [51.9936, 58.4282, 5.5436, 5.5436], [23.1936, 58.4282, 5.5436, 5.5436], [44.7936, 87.2282, 5.5436, 5.5436], [15.9936, 87.2282, 5.5436, 5.5436], [123.9932, 36.8282, 5.5436, 5.5436], [95.1936, 36.8282, 5.5436, 5.5436], [66.3936, 36.8282, 5.5436, 5.5436], [37.5936, 36.8282, 5.5436, 5.5436], [59.1936, 65.6282, 5.5436, 5.5436], [30.3936, 65.6282, 5.5436, 5.5436], [167.1932, 36.8282, 5.5436, 5.5436], [167.1932, 22.4282, 5.5436, 5.5436], [123.9932, 22.4282, 5.5436, 5.5436], [95.1936, 22.4282, 5.5436, 5.5436], [66.3936, 22.4282, 5.5436, 5.5436], [37.5936, 22.4282, 5.5436, 5.5436], [59.1936, 51.2282, 5.5436, 5.5436], [30.3936, 51.2282, 5.5436, 5.5436], [51.9936, 80.0282, 5.5436, 5.5436], [23.1936, 80.0282, 5.5436, 5.5436], [123.9932, 44.0282, 5.5436, 5.5436], [95.1936, 44.0282, 5.5436, 5.5436], [66.3936, 44.0282, 5.5436, 5.5436], [37.5936, 44.0282, 5.5436, 5.5436], [59.1936, 72.8282, 5.5436, 5.5436], [30.3936, 72.8282, 5.5436, 5.5436], [167.1932, 44.0282, 5.5436, 5.5436], [167.1932, 29.6282, 5.5436, 5.5436], [123.9932, 29.6282, 5.5436, 5.5436], [95.1936, 29.6282, 5.5436, 5.5436], [66.3936, 29.6282, 5.5436, 5.5436], [37.5936, 29.6282, 5.5436, 5.5436], [59.1936, 58.4282, 5.5436, 5.5436], [30.3936, 58.4282, 5.5436, 5.5436], [51.9936, 87.2282, 5.5436, 5.5436], [23.1936, 87.2282, 5.5436, 5.5436], [131.1932, 36.8282, 5.5436, 5.5436], [102.3932, 36.8282, 5.5436, 5.5436], [73.5936, 36.8282, 5.5436, 5.5436], [44.7936, 36.8282, 5.5436, 5.5436], [15.9936, 36.8282, 5.5436, 5.5436], [37.5936, 65.6282, 5.5436, 5.5436], [174.3932, 36.8282, 5.5436, 5.5436], [174.3932, 22.4282, 5.5436, 5.5436], [131.1932, 22.4282, 5.5436, 5.5436], [102.3932, 22.4282, 5.5436, 5.5436], [73.5936, 22.4282, 5.5436, 5.5436], [44.7936, 22.4282, 5.5436, 5.5436], [15.9936, 22.4282, 5.5436, 5.5436], [37.5936, 51.2282, 5.5436, 5.5436], [59.1936, 80.0282, 5.5436, 5.5436], [30.3936, 80.0282, 5.5436, 5.5436], [131.1932, 44.0282, 5.5436, 5.5436], [102.3932, 44.0282, 5.5436, 5.5436], [73.5936, 44.0282, 5.5436, 5.5436], [44.7936, 44.0282, 5.5436, 5.5436], [15.9936, 44.0282, 5.5436, 5.5436], [37.5936, 72.8282, 5.5436, 5.5436], [174.3932, 44.0282, 5.5436, 5.5436], [174.3932, 29.6282, 5.5436, 5.5436], [131.1932, 29.6282, 5.5436, 5.5436], [102.3932, 29.6282, 5.5436, 5.5436], [73.5936, 29.6282, 5.5436, 5.5436], [44.7936, 29.6282, 5.5436, 5.5436], [15.9936, 29.6282, 5.5436, 5.5436], [37.5936, 58.4282, 5.5436, 5.5436], [59.1936, 87.2282, 5.5436, 5.5436], [30.3936, 87.2282, 5.5436, 5.5436], [181.5932, 22.4282, 5.5436, 5.5436], [174.3932, 80.0282, 5.5436, 5.5436], [174.3932, 87.2282, 5.5436, 5.5436], [159.9932, 87.2282, 5.5436, 5.5436], [159.9932, 80.0282, 5.5436, 5.5436], [152.7932, 87.2282, 5.5436, 5.5436], [152.7932, 80.0282, 5.5436, 5.5436], [8.7936, 22.4282, 5.5436, 5.5436], [332.7932, 29.6282, 5.5436, 5.5436], [332.7932, 51.2282, 5.5436, 5.5436], [8.7936, 29.6282, 5.5436, 5.5436], [332.7932, 36.8282, 5.5436, 5.5436], [332.7932, 44.0282, 5.5436, 5.5436], [8.7936, 36.8282, 5.5436, 5.5436], [332.7932, 58.4282, 5.5436, 5.5436], [145.5932, 51.2282, 5.5436, 5.5436], [8.7936, 44.0282, 5.5436, 5.5436], [332.7932, 65.6282, 5.5436, 5.5436], [145.5932, 72.8282, 5.5436, 5.5436], [8.7936, 51.2282, 5.5436, 5.5436], [332.7932, 72.8282, 5.5436, 5.5436], [8.7936, 87.2282, 5.5436, 5.5436], [8.7936, 58.4282, 5.5436, 5.5436], [332.7932, 80.0282, 5.5436, 5.5436], [8.7936, 80.0282, 5.5436, 5.5436], [8.7936, 65.6282, 5.5436, 5.5436], [8.7936, 72.8282, 5.5436, 5.5436], [332.7932, 87.2282, 5.5436, 5.5436], [145.5932, 58.4282, 5.5436, 5.5436], [145.5932, 29.6282, 5.5436, 5.5436], [145.5932, 22.4282, 5.5436, 5.5436], [145.5932, 65.6282, 5.5436, 5.5436], [145.5932, 36.8282, 5.5436, 5.5436], [145.5932, 44.0282, 5.5436, 5.5436], [145.5932, 80.0282, 5.5436, 5.5436], [138.3932, 87.2282, 5.5436, 5.5436], [145.5932, 87.2282, 5.5436, 5.5436], [138.3932, 80.0282, 5.5436, 5.5436], [138.3932, 58.4282, 5.5436, 5.5436], [138.3932, 65.6282, 5.5436, 5.5436], [138.3932, 72.8282, 5.5436, 5.5436], [138.3932, 44.0282, 5.5436, 5.5436], [138.3932, 51.2282, 5.5436, 5.5436], [138.3932, 36.8282, 5.5436, 5.5436], [138.3932, 22.4282, 5.5436, 5.5436], [138.3932, 29.6282, 5.5436, 5.5436], [332.7932, 22.4282, 5.5436, 5.5436]]
		}, {
			"name":"9 Degrees of Freedom-Sensor Stick",
			"description":"The 9DOF Sensor stick is a very small sensor board with 9 degrees of freedom. It includes the ADXL345 accelerometer, the HMC5883L magnetometer, and the ITG-3200 gyro. The 'stick' has a simple I2C interface and a mounting hole for attaching it to your project. Also, the board is a mere 0.036' thick(0.093' overall), allowing it to be easily mounted in just about any application.\t\t\tDimensions: 1.37x0.42'. Replaces: SEN-10321",
			"image":"core\/breadboard\/9DoF-Stick-v13_breadboard.svg",
			"icon":"core\/breadboard\/9DoF-Stick-v13_breadboard.svg",
			"width":"97.2",
			"height":"28.8",
			"points": [[0.548, 0.548, 6.104, 6.104], [0.548, 7.748, 6.104, 6.104], [0.548, 14.948, 6.104, 6.104], [0.548, 22.148, 6.104, 6.104]]
		}, {
			"name":"COPERNICUS",
			"description":"Copernicus II GPS-Trimble recommended layout and paste layer.Footprint production proven.Spark Fun Electronics SKU: GPS-07951",
			"image":"core\/breadboard\/sparkfun-rf_copernicus_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_copernicus_breadboard.svg",
			"width":"1400",
			"height":"1200",
			"points": [[33.035, 1133.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 1133.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 1133.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 1133.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 1133.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 1133.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 1133.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 1133.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 1133.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 1133.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 1133.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 1133.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 1133.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 1133.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"SWITCH-MOMENTARY-2",
			"description":"Various NO switches-pushbuttons, reed, etc",
			"image":"core\/breadboard\/sparkfun-electromechanical_tactile_switch_tall_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_tactile_switch_tall_breadboard.svg",
			"width":"574.028",
			"height":"600",
			"points": [[220.049, 533.05, 33.93, 33.9], [220.049, 33.05, 33.93, 33.9], [320.049, 533.05, 33.93, 33.9], [320.049, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Modkit Shield",
			"description":"The Modkit MotoProto Shield for Arduino that makes it easy to connect up to 4 sensors and control two DC motors as well as a 16X2 character LCD.The sensor jacks accept 2.5mm cables and provide access to VCC, GND, and an analog input. Sensors can be soldered to a 2.5mm cable and you can begin plug-and-play prototyping with a wide assortment of our sensors including line sensors, ultrasonic distance sensors, light sensors, photo interrupter, etc.There is also a large programmable button and a space for an i2c header to connect more advanced sensors such as an accelerometer. The motor driver circuit is based on the L298 H-bridge and can drive up to 2 amps per channel.The board takes its power from the same Vin line as the Arduino board, includes blue and yellow LEDs to indicate active direction, and all driver lines are diode protected from back EMF. Modkit develops a drag-and-drop graphical programming environment inspired by Scratch for Arduino and Arduino compatible boards, making it easier than ever to program your physical project.The Modkit MotoProto Shield is well suited for general projects, prototyping, and educational robotics.  For a limited time, purchase a Modkit MotoProto Shield and receive a free invite to try Modkit 's programming environment before it is released to the public. The shield can also be programmed with the Arduino development environment.\tDocuments:\t\t\tSchematic\t\t\tEagle Files\t\t\tExample Code\t\t\tDatasheet (L298)\t\t\tModkit Software",
			"image":"core\/breadboard\/Modkit Shield-v1a_breadboard.svg",
			"icon":"core\/breadboard\/Modkit Shield-v1a_breadboard.svg",
			"width":"151.2",
			"height":"232.276",
			"points": [[120.795, 160.966, 6.104, 6.104], [120.795, 153.766, 6.104, 6.104], [120.795, 146.566, 6.104, 6.104], [120.795, 139.366, 6.104, 6.104], [15.00491, 208.89561, 6.58078, 6.58078], [15.00491, 219.82561, 6.58078, 6.58078], [16.66091, 4.05584, 6.58078, 6.58078], [16.66091, 14.98511, 6.58078, 6.58078], [131.612, 22.0176, 6.104, 6.104], [131.612, 29.2176, 6.104, 6.104], [131.612, 36.4176, 6.104, 6.104], [131.612, 43.6176, 6.104, 6.104], [131.612, 50.8176, 6.104, 6.104], [131.612, 58.0176, 6.104, 6.104], [131.612, 65.2176, 6.104, 6.104], [131.612, 72.4177, 6.104, 6.104], [131.612, 79.6177, 6.104, 6.104], [131.612, 86.8177, 6.104, 6.104], [131.612, 94.0177, 6.104, 6.104], [131.612, 101.218, 6.104, 6.104], [131.612, 108.418, 6.104, 6.104], [131.612, 115.618, 6.104, 6.104], [131.612, 122.818, 6.104, 6.104], [131.612, 130.018, 6.104, 6.104], [140.955, 102.646, 6.104, 6.104], [140.955, 95.4462, 6.104, 6.104], [140.955, 59.4462, 6.104, 6.104], [140.955, 52.2462, 6.104, 6.104], [140.955, 45.0462, 6.104, 6.104], [140.955, 37.8462, 6.104, 6.104], [140.955, 30.6462, 6.104, 6.104], [140.955, 23.4462, 6.104, 6.104], [4.15534, 135.046, 6.104, 6.104], [4.15534, 37.8462, 6.104, 6.104], [4.15534, 45.0462, 6.104, 6.104], [4.15534, 52.2462, 6.104, 6.104], [4.15534, 59.4462, 6.104, 6.104], [4.15534, 66.6462, 6.104, 6.104], [4.15534, 73.8462, 6.104, 6.104], [4.15534, 84.6462, 6.104, 6.104], [4.15534, 91.8462, 6.104, 6.104], [4.15534, 99.046, 6.104, 6.104], [4.15534, 106.246, 6.104, 6.104], [4.15534, 113.446, 6.104, 6.104], [4.15534, 120.646, 6.104, 6.104], [140.955, 88.2462, 6.104, 6.104], [140.955, 81.0462, 6.104, 6.104], [4.15534, 127.846, 6.104, 6.104], [140.955, 109.846, 6.104, 6.104], [4.15534, 23.4462, 6.104, 6.104], [4.15534, 30.6462, 6.104, 6.104], [140.955, 73.8462, 6.104, 6.104]]
		}, {
			"name":"TEST-POINT",
			"description":"Bare copper test points for troubleshooting or ICT",
			"image":"core\/breadboard\/sparkfun-passives_pad.02x.02_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_pad.02x.02_breadboard.svg",
			"width":"220",
			"height":"400",
			"points": [[93.035, 333.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Prototyping Shield",
			"description":"The Arduino Prototyping Shield makes it easy for you to design custom circuits. You can solder parts to the prototyping area to create your project, or use it with a small solderless breadboard (not included) to quickly test circuit ideas without having to solder. It' s got extra connections for all of the Arduino I\/O pins, and it 's got space to mount through-hole and surface mount integrated circuits. It' s a convenient way to make your custom circuit and Arduino into a single module.",
			"image":"core\/breadboard\/Proto_shield_REV3_breadboard.svg",
			"icon":"core\/breadboard\/Proto_shield_REV3_breadboard.svg",
			"width":"194.4",
			"height":"151.2",
			"points": [[141.2, 141.2, 5.6, 5.6], [148.4, 141.2, 5.6, 5.6], [155.6, 141.2, 5.6, 5.6], [162.8, 141.2, 5.6, 5.6], [170, 141.2, 5.6, 5.6], [177.2, 141.2, 5.6, 5.6], [177.58835, 62.02835, 5.5433, 5.5433], [184.78835, 62.02835, 5.5433, 5.5433], [177.58835, 69.22835, 5.5433, 5.5433], [184.78835, 69.22835, 5.5433, 5.5433], [177.58835, 76.42835, 5.5433, 5.5433], [184.78835, 76.42835, 5.5433, 5.5433], [177.29354, 4.49354, 5.41292, 5.41292], [170.09354, 4.49354, 5.41292, 5.41292], [162.89354, 4.49354, 5.41292, 5.41292], [155.69354, 4.49354, 5.41292, 5.41292], [148.49354, 4.49354, 5.41292, 5.41292], [141.29354, 4.49354, 5.41292, 5.41292], [134.09354, 4.49354, 5.41292, 5.41292], [126.89354, 4.49354, 5.41292, 5.41292], [76.49354, 141.29354, 5.41292, 5.41292], [83.69354, 141.29354, 5.41292, 5.41292], [90.89354, 141.29354, 5.41292, 5.41292], [98.09354, 141.29354, 5.41292, 5.41292], [105.29354, 141.29354, 5.41292, 5.41292], [112.49354, 141.29354, 5.41292, 5.41292], [119.69354, 141.29354, 5.41292, 5.41292], [126.89354, 141.29354, 5.41292, 5.41292], [115.37354, 4.49354, 5.41292, 5.41292], [108.17354, 4.49354, 5.41292, 5.41292], [100.97354, 4.49354, 5.41292, 5.41292], [93.77354, 4.49354, 5.41292, 5.41292], [86.57354, 4.49354, 5.41292, 5.41292], [79.37354, 4.49354, 5.41292, 5.41292], [72.17354, 4.49354, 5.41292, 5.41292], [64.97354, 4.49354, 5.41292, 5.41292], [57.77354, 4.49354, 5.41292, 5.41292], [50.57354, 4.49354, 5.41292, 5.41292], [115.37354, 11.69354, 5.41292, 5.41292], [108.17354, 11.69354, 5.41292, 5.41292], [100.97354, 11.69354, 5.41292, 5.41292], [93.77354, 11.69354, 5.41292, 5.41292], [86.57354, 11.69354, 5.41292, 5.41292], [79.37354, 11.69354, 5.41292, 5.41292], [72.17354, 11.69354, 5.41292, 5.41292], [64.97354, 11.69354, 5.41292, 5.41292], [57.77354, 11.69354, 5.41292, 5.41292], [50.57354, 11.69354, 5.41292, 5.41292], [177.29354, 11.69354, 5.41292, 5.41292], [170.09354, 11.69354, 5.41292, 5.41292], [162.89354, 11.69354, 5.41292, 5.41292], [155.69354, 11.69354, 5.41292, 5.41292], [148.49354, 11.69354, 5.41292, 5.41292], [141.29354, 11.69354, 5.41292, 5.41292], [134.09354, 11.69354, 5.41292, 5.41292], [126.89354, 11.69354, 5.41292, 5.41292], [141.2, 134, 5.6, 5.6], [148.4, 134, 5.6, 5.6], [155.6, 134, 5.6, 5.6], [162.8, 134, 5.6, 5.6], [170, 134, 5.6, 5.6], [177.2, 134, 5.6, 5.6], [76.49354, 134.09354, 5.41292, 5.41292], [83.69354, 134.09354, 5.41292, 5.41292], [90.89354, 134.09354, 5.41292, 5.41292], [98.09354, 134.09354, 5.41292, 5.41292], [105.29354, 134.09354, 5.41292, 5.41292], [112.49354, 134.09354, 5.41292, 5.41292], [119.69354, 134.09354, 5.41292, 5.41292], [126.89354, 134.09354, 5.41292, 5.41292], [33.12205, 76.32205, 5.7559, 5.7559], [33.12205, 83.52205, 5.7559, 5.7559], [33.12205, 90.72205, 5.7559, 5.7559], [33.12205, 97.92205, 5.7559, 5.7559], [33.12205, 105.12205, 5.7559, 5.7559], [33.12205, 112.32205, 5.7559, 5.7559], [33.12205, 119.52205, 5.7559, 5.7559], [33.12205, 126.72205, 5.7559, 5.7559], [33.12205, 133.92205, 5.7559, 5.7559], [33.12205, 141.12205, 5.7559, 5.7559], [33.12205, 70.92205, 5.7559, 5.7559], [40.32205, 70.92205, 5.7559, 5.7559], [40.32205, 76.32205, 5.7559, 5.7559], [40.32205, 83.52205, 5.7559, 5.7559], [40.32205, 90.72205, 5.7559, 5.7559], [40.32205, 97.92205, 5.7559, 5.7559], [40.32205, 105.12205, 5.7559, 5.7559], [40.32205, 112.32205, 5.7559, 5.7559], [40.32205, 119.52205, 5.7559, 5.7559], [40.32205, 126.72205, 5.7559, 5.7559], [40.32205, 133.92205, 5.7559, 5.7559], [40.32205, 141.12205, 5.7559, 5.7559], [69.12205, 126.72205, 5.7559, 5.7559], [141.12205, 61.92205, 5.7559, 5.7559], [148.32205, 83.52205, 5.7559, 5.7559], [148.32205, 69.12205, 5.7559, 5.7559], [61.92205, 133.92205, 5.7559, 5.7559], [47.52205, 133.92205, 5.7559, 5.7559], [54.72205, 133.92205, 5.7559, 5.7559], [3.73074, 97.33074, 6.93852, 6.93852], [4.32205, 76.32205, 5.7559, 5.7559], [18.72205, 133.92205, 5.7559, 5.7559], [11.52205, 133.92205, 5.7559, 5.7559], [25.92205, 133.92205, 5.7559, 5.7559], [3.73074, 82.93074, 6.93852, 6.93852], [54.72205, 126.72205, 5.7559, 5.7559], [47.52205, 126.72205, 5.7559, 5.7559], [61.92205, 126.72205, 5.7559, 5.7559], [155.52205, 69.12205, 5.7559, 5.7559], [162.72205, 61.92205, 5.7559, 5.7559], [4.32205, 133.92205, 5.7559, 5.7559], [25.92205, 126.72205, 5.7559, 5.7559], [11.52205, 126.72205, 5.7559, 5.7559], [18.72205, 126.72205, 5.7559, 5.7559], [162.72205, 69.12205, 5.7559, 5.7559], [3.73074, 126.13074, 6.93852, 6.93852], [126.72205, 119.52205, 5.7559, 5.7559], [76.32205, 119.52205, 5.7559, 5.7559], [69.12205, 119.52205, 5.7559, 5.7559], [61.92205, 119.52205, 5.7559, 5.7559], [47.52205, 119.52205, 5.7559, 5.7559], [54.72205, 119.52205, 5.7559, 5.7559], [155.52205, 76.32205, 5.7559, 5.7559], [162.72205, 76.32205, 5.7559, 5.7559], [155.52205, 83.52205, 5.7559, 5.7559], [148.32205, 76.32205, 5.7559, 5.7559], [18.72205, 119.52205, 5.7559, 5.7559], [11.52205, 119.52205, 5.7559, 5.7559], [25.92205, 119.52205, 5.7559, 5.7559], [4.32205, 119.52205, 5.7559, 5.7559], [148.32205, 112.32205, 5.7559, 5.7559], [76.32205, 112.32205, 5.7559, 5.7559], [69.12205, 112.32205, 5.7559, 5.7559], [54.72205, 112.32205, 5.7559, 5.7559], [47.52205, 112.32205, 5.7559, 5.7559], [61.92205, 112.32205, 5.7559, 5.7559], [61.92205, 69.12205, 5.7559, 5.7559], [61.92205, 61.92205, 5.7559, 5.7559], [25.92205, 112.32205, 5.7559, 5.7559], [11.52205, 112.32205, 5.7559, 5.7559], [18.72205, 112.32205, 5.7559, 5.7559], [25.92205, 83.52205, 5.7559, 5.7559], [11.52205, 83.52205, 5.7559, 5.7559], [3.73074, 111.73074, 6.93852, 6.93852], [119.52205, 105.12205, 5.7559, 5.7559], [76.32205, 105.12205, 5.7559, 5.7559], [69.12205, 105.12205, 5.7559, 5.7559], [61.92205, 105.12205, 5.7559, 5.7559], [47.52205, 105.12205, 5.7559, 5.7559], [54.72205, 105.12205, 5.7559, 5.7559], [18.72205, 83.52205, 5.7559, 5.7559], [18.72205, 90.72205, 5.7559, 5.7559], [61.92205, 83.52205, 5.7559, 5.7559], [54.72205, 83.52205, 5.7559, 5.7559], [47.52205, 83.52205, 5.7559, 5.7559], [61.92205, 90.72205, 5.7559, 5.7559], [54.72205, 90.72205, 5.7559, 5.7559], [47.52205, 90.72205, 5.7559, 5.7559], [18.72205, 105.12205, 5.7559, 5.7559], [11.52205, 105.12205, 5.7559, 5.7559], [25.92205, 105.12205, 5.7559, 5.7559], [4.32205, 105.12205, 5.7559, 5.7559], [162.72205, 97.92205, 5.7559, 5.7559], [76.32205, 97.92205, 5.7559, 5.7559], [69.12205, 97.92205, 5.7559, 5.7559], [25.92205, 97.92205, 5.7559, 5.7559], [11.52205, 97.92205, 5.7559, 5.7559], [54.72205, 97.92205, 5.7559, 5.7559], [47.52205, 97.92205, 5.7559, 5.7559], [61.92205, 97.92205, 5.7559, 5.7559], [25.92205, 90.72205, 5.7559, 5.7559], [11.52205, 90.72205, 5.7559, 5.7559], [61.92205, 54.72205, 5.7559, 5.7559], [61.92205, 47.52205, 5.7559, 5.7559], [18.72205, 97.92205, 5.7559, 5.7559], [61.92205, 40.32205, 5.7559, 5.7559], [4.32205, 90.72205, 5.7559, 5.7559], [169.92205, 90.72205, 5.7559, 5.7559], [76.32205, 90.72205, 5.7559, 5.7559], [69.12205, 90.72205, 5.7559, 5.7559], [61.92205, 33.12205, 5.7559, 5.7559], [177.12205, 83.52205, 5.7559, 5.7559], [76.32205, 83.52205, 5.7559, 5.7559], [69.12205, 83.52205, 5.7559, 5.7559], [61.92205, 25.92205, 5.7559, 5.7559], [169.92205, 76.32205, 5.7559, 5.7559], [61.92205, 76.32205, 5.7559, 5.7559], [54.72205, 76.32205, 5.7559, 5.7559], [47.52205, 76.32205, 5.7559, 5.7559], [76.32205, 76.32205, 5.7559, 5.7559], [69.12205, 76.32205, 5.7559, 5.7559], [69.12205, 25.92205, 5.7559, 5.7559], [76.32205, 69.12205, 5.7559, 5.7559], [69.12205, 69.12205, 5.7559, 5.7559], [69.12205, 61.92205, 5.7559, 5.7559], [76.32205, 61.92205, 5.7559, 5.7559], [155.52205, 54.72205, 5.7559, 5.7559], [76.32205, 54.72205, 5.7559, 5.7559], [69.12205, 54.72205, 5.7559, 5.7559], [141.12205, 47.52205, 5.7559, 5.7559], [76.32205, 47.52205, 5.7559, 5.7559], [69.12205, 47.52205, 5.7559, 5.7559], [119.52205, 40.32205, 5.7559, 5.7559], [25.92205, 76.32205, 5.7559, 5.7559], [11.52205, 76.32205, 5.7559, 5.7559], [76.32205, 40.32205, 5.7559, 5.7559], [69.12205, 40.32205, 5.7559, 5.7559], [177.12205, 33.12205, 5.7559, 5.7559], [18.72205, 76.32205, 5.7559, 5.7559], [76.32205, 33.12205, 5.7559, 5.7559], [69.12205, 33.12205, 5.7559, 5.7559], [105.12205, 25.92205, 5.7559, 5.7559], [76.32205, 25.92205, 5.7559, 5.7559], [83.52205, 40.32205, 5.7559, 5.7559], [90.72205, 40.32205, 5.7559, 5.7559], [83.52205, 47.52205, 5.7559, 5.7559], [90.72205, 47.52205, 5.7559, 5.7559], [83.52205, 54.72205, 5.7559, 5.7559], [90.72205, 54.72205, 5.7559, 5.7559], [97.92205, 47.52205, 5.7559, 5.7559], [97.92205, 54.72205, 5.7559, 5.7559], [90.72205, 61.92205, 5.7559, 5.7559], [97.92205, 61.92205, 5.7559, 5.7559], [105.12205, 54.72205, 5.7559, 5.7559], [105.12205, 47.52205, 5.7559, 5.7559], [105.12205, 61.92205, 5.7559, 5.7559], [112.32205, 54.72205, 5.7559, 5.7559], [112.32205, 47.52205, 5.7559, 5.7559], [105.12205, 40.32205, 5.7559, 5.7559], [97.92205, 40.32205, 5.7559, 5.7559], [90.72205, 33.12205, 5.7559, 5.7559], [97.92205, 33.12205, 5.7559, 5.7559], [83.52205, 33.12205, 5.7559, 5.7559], [83.52205, 25.92205, 5.7559, 5.7559], [90.72205, 25.92205, 5.7559, 5.7559], [83.52205, 61.92205, 5.7559, 5.7559], [83.52205, 69.12205, 5.7559, 5.7559], [90.72205, 83.52205, 5.7559, 5.7559], [97.92205, 83.52205, 5.7559, 5.7559], [105.12205, 83.52205, 5.7559, 5.7559], [112.32205, 83.52205, 5.7559, 5.7559], [119.52205, 61.92205, 5.7559, 5.7559], [112.32205, 61.92205, 5.7559, 5.7559], [126.72205, 61.92205, 5.7559, 5.7559], [83.52205, 76.32205, 5.7559, 5.7559], [83.52205, 83.52205, 5.7559, 5.7559], [83.52205, 90.72205, 5.7559, 5.7559], [90.72205, 105.12205, 5.7559, 5.7559], [90.72205, 97.92205, 5.7559, 5.7559], [105.12205, 97.92205, 5.7559, 5.7559], [97.92205, 97.92205, 5.7559, 5.7559], [97.92205, 105.12205, 5.7559, 5.7559], [83.52205, 105.12205, 5.7559, 5.7559], [83.52205, 97.92205, 5.7559, 5.7559], [105.12205, 90.72205, 5.7559, 5.7559], [112.32205, 90.72205, 5.7559, 5.7559], [105.12205, 105.12205, 5.7559, 5.7559], [83.52205, 112.32205, 5.7559, 5.7559], [90.72205, 112.32205, 5.7559, 5.7559], [83.52205, 119.52205, 5.7559, 5.7559], [90.72205, 119.52205, 5.7559, 5.7559], [97.92205, 119.52205, 5.7559, 5.7559], [97.92205, 112.32205, 5.7559, 5.7559], [105.12205, 112.32205, 5.7559, 5.7559], [112.32205, 97.92205, 5.7559, 5.7559], [119.52205, 97.92205, 5.7559, 5.7559], [119.52205, 90.72205, 5.7559, 5.7559], [126.72205, 90.72205, 5.7559, 5.7559], [126.72205, 83.52205, 5.7559, 5.7559], [119.52205, 83.52205, 5.7559, 5.7559], [133.92205, 83.52205, 5.7559, 5.7559], [148.32205, 61.92205, 5.7559, 5.7559], [133.92205, 61.92205, 5.7559, 5.7559], [126.72205, 54.72205, 5.7559, 5.7559], [141.12205, 54.72205, 5.7559, 5.7559], [133.92205, 54.72205, 5.7559, 5.7559], [119.52205, 54.72205, 5.7559, 5.7559], [119.52205, 47.52205, 5.7559, 5.7559], [126.72205, 47.52205, 5.7559, 5.7559], [90.72205, 90.72205, 5.7559, 5.7559], [97.92205, 90.72205, 5.7559, 5.7559], [126.72205, 97.92205, 5.7559, 5.7559], [133.92205, 90.72205, 5.7559, 5.7559], [141.12205, 90.72205, 5.7559, 5.7559], [141.12205, 83.52205, 5.7559, 5.7559], [155.52205, 90.72205, 5.7559, 5.7559], [177.12205, 90.72205, 5.7559, 5.7559], [177.12205, 97.92205, 5.7559, 5.7559], [169.92205, 97.92205, 5.7559, 5.7559], [177.12205, 105.12205, 5.7559, 5.7559], [177.12205, 112.32205, 5.7559, 5.7559], [169.92205, 112.32205, 5.7559, 5.7559], [162.72205, 112.32205, 5.7559, 5.7559], [3.73074, 140.53074, 6.93852, 6.93852], [18.72205, 141.12205, 5.7559, 5.7559], [25.92205, 141.12205, 5.7559, 5.7559], [11.52205, 141.12205, 5.7559, 5.7559], [47.52205, 141.12205, 5.7559, 5.7559], [61.92205, 141.12205, 5.7559, 5.7559], [54.72205, 141.12205, 5.7559, 5.7559], [169.92205, 119.52205, 5.7559, 5.7559], [162.72205, 119.52205, 5.7559, 5.7559], [155.52205, 119.52205, 5.7559, 5.7559], [148.32205, 119.52205, 5.7559, 5.7559], [141.12205, 119.52205, 5.7559, 5.7559], [133.92205, 119.52205, 5.7559, 5.7559], [112.32205, 119.52205, 5.7559, 5.7559], [105.12205, 119.52205, 5.7559, 5.7559], [119.52205, 119.52205, 5.7559, 5.7559], [119.52205, 112.32205, 5.7559, 5.7559], [112.32205, 112.32205, 5.7559, 5.7559], [126.72205, 112.32205, 5.7559, 5.7559], [133.92205, 112.32205, 5.7559, 5.7559], [155.52205, 112.32205, 5.7559, 5.7559], [141.12205, 112.32205, 5.7559, 5.7559], [169.92205, 105.12205, 5.7559, 5.7559], [162.72205, 105.12205, 5.7559, 5.7559], [155.52205, 105.12205, 5.7559, 5.7559], [148.32205, 105.12205, 5.7559, 5.7559], [141.12205, 105.12205, 5.7559, 5.7559], [133.92205, 105.12205, 5.7559, 5.7559], [126.72205, 105.12205, 5.7559, 5.7559], [112.32205, 105.12205, 5.7559, 5.7559], [133.92205, 97.92205, 5.7559, 5.7559], [141.12205, 97.92205, 5.7559, 5.7559], [148.32205, 97.92205, 5.7559, 5.7559], [155.52205, 97.92205, 5.7559, 5.7559], [162.72205, 90.72205, 5.7559, 5.7559], [148.32205, 90.72205, 5.7559, 5.7559], [162.72205, 83.52205, 5.7559, 5.7559], [169.92205, 83.52205, 5.7559, 5.7559], [169.92205, 69.12205, 5.7559, 5.7559], [155.52205, 61.92205, 5.7559, 5.7559], [169.92205, 61.92205, 5.7559, 5.7559], [177.12205, 54.72205, 5.7559, 5.7559], [169.92205, 54.72205, 5.7559, 5.7559], [162.72205, 54.72205, 5.7559, 5.7559], [148.32205, 54.72205, 5.7559, 5.7559], [177.12205, 47.52205, 5.7559, 5.7559], [162.72205, 47.52205, 5.7559, 5.7559], [169.92205, 47.52205, 5.7559, 5.7559], [177.12205, 40.32205, 5.7559, 5.7559], [169.92205, 40.32205, 5.7559, 5.7559], [162.72205, 40.32205, 5.7559, 5.7559], [155.52205, 40.32205, 5.7559, 5.7559], [155.52205, 47.52205, 5.7559, 5.7559], [148.32205, 40.32205, 5.7559, 5.7559], [148.32205, 47.52205, 5.7559, 5.7559], [133.92205, 47.52205, 5.7559, 5.7559], [141.12205, 40.32205, 5.7559, 5.7559], [133.92205, 40.32205, 5.7559, 5.7559], [126.72205, 40.32205, 5.7559, 5.7559], [112.32205, 40.32205, 5.7559, 5.7559], [105.12205, 33.12205, 5.7559, 5.7559], [119.52205, 33.12205, 5.7559, 5.7559], [112.32205, 33.12205, 5.7559, 5.7559], [126.72205, 33.12205, 5.7559, 5.7559], [133.92205, 33.12205, 5.7559, 5.7559], [141.12205, 33.12205, 5.7559, 5.7559], [148.32205, 33.12205, 5.7559, 5.7559], [155.52205, 33.12205, 5.7559, 5.7559], [162.72205, 33.12205, 5.7559, 5.7559], [169.92205, 33.12205, 5.7559, 5.7559], [177.12205, 25.92205, 5.7559, 5.7559], [169.92205, 25.92205, 5.7559, 5.7559], [162.72205, 25.92205, 5.7559, 5.7559], [155.52205, 25.92205, 5.7559, 5.7559], [141.12205, 25.92205, 5.7559, 5.7559], [148.32205, 25.92205, 5.7559, 5.7559], [133.92205, 25.92205, 5.7559, 5.7559], [126.72205, 25.92205, 5.7559, 5.7559], [119.52205, 25.92205, 5.7559, 5.7559], [112.32205, 25.92205, 5.7559, 5.7559], [97.92205, 25.92205, 5.7559, 5.7559]]
		}, {
			"name":"TEST-POINT",
			"description":"Bare copper test points for troubleshooting or ICT",
			"image":"core\/breadboard\/sparkfun-passives_pad.03x.03_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_pad.03x.03_breadboard.svg",
			"width":"230",
			"height":"400",
			"points": [[98.035, 333.05, 33.93, 33.9]]
		}, {
			"name":"Generic male header-20 pins",
			"description":"Generic male header",
			"image":"obsolete\/breadboard\/generic-male-header_bread_20.svg",
			"icon":"obsolete\/breadboard\/generic-male-header_bread_20.svg",
			"width":"143.98",
			"height":"7.199",
			"points": [[1.204, 1.204, 4.791, 4.791], [8.403, 1.204, 4.791, 4.791], [15.602, 1.204, 4.791, 4.791], [22.801, 1.204, 4.791, 4.791], [30, 1.204, 4.791, 4.791], [37.199, 1.204, 4.791, 4.791], [44.398, 1.204, 4.791, 4.791], [51.597, 1.204, 4.791, 4.791], [58.796, 1.204, 4.791, 4.791], [65.995, 1.204, 4.791, 4.791], [73.194, 1.204, 4.791, 4.791], [80.393, 1.204, 4.791, 4.791], [87.592, 1.204, 4.791, 4.791], [94.791, 1.204, 4.791, 4.791], [101.99, 1.204, 4.791, 4.791], [109.189, 1.204, 4.791, 4.791], [116.388, 1.204, 4.791, 4.791], [123.587, 1.204, 4.791, 4.791], [130.786, 1.204, 4.791, 4.791], [137.985, 1.204, 4.791, 4.791]]
		}, {
			"name":"Thumb Joystick",
			"description":"This is the breakout board for the thumb joystick.Pins are broken out to a 0.1' header and includes 4 mounting holes in the corners.  Dimensions: 1'x 1.25'",
			"image":"core\/breadboard\/Joystick-Breakout-v11_breadboard.svg",
			"icon":"core\/breadboard\/Joystick-Breakout-v11_breadboard.svg",
			"width":"72",
			"height":"90",
			"points": [[47.528, 83.528, 5.744, 5.744], [40.328, 83.528, 5.744, 5.744], [33.128, 83.528, 5.744, 5.744], [25.928, 83.528, 5.744, 5.744], [18.728, 83.528, 5.744, 5.744]]
		}, {
			"name":"RGB LED(com.cathode, rgb)",
			"description":"A 5mm tri-color LED with red, green and blue inside.",
			"image":"core\/breadboard\/led-rgb-4pin-anode-leg.svg",
			"icon":"core\/breadboard\/led-rgb-4pin-anode-leg.svg",
			"width":"23.76",
			"height":"32.55",
			"points": [[18.728, 83.528, 5.744, 5.744], [6.199, 21, 3, 3], [13.399, 21, 3, 3], [20.598, 21, 3, 3]]
		}, {
			"name":"RELAY",
			"description":"SPDT relay(COM-00101)",
			"image":"core\/breadboard\/sparkfun-electromechanical_relay-g5q_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_relay-g5q_breadboard.svg",
			"width":"58.176",
			"height":"63.3",
			"points": [[7.886, 59.786, 6.404, 6.404], [51.086, 59.786, 6.404, 6.404], [51.086, 38.186, 6.404, 6.404], [0.686, 38.186, 6.404, 6.404], [22.286, 38.186, 6.404, 6.404]]
		}, {
			"name":"AVR ISP 6 Pin",
			"description":"AVR ISP 6 PinThis is the reduced ISP connector for AVR programming.Common on Arduino.This footprint will take up less PCB space and can be used with a 10-pin to 6-pin adapter such as SKU: BOB-08508",
			"image":"core\/breadboard\/sparkfun-connectors_2x3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_2x3_breadboard.svg",
			"width":"43.197",
			"height":"36.918",
			"points": [[12.251, 25.065, 4.296, 4.296], [12.251, 17.865, 4.296, 4.296], [19.451, 25.125, 4.296, 4.296], [19.451, 17.865, 4.296, 4.296], [26.652, 25.125, 4.296, 4.296], [26.652, 17.865, 4.296, 4.296]]
		}, {
			"name":"Voltage Regulator-5V",
			"description":"5V DC Voltage Regulator",
			"image":"core\/breadboard\/voltage_regulator_vreg.svg",
			"icon":"core\/breadboard\/voltage_regulator_vreg.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"yellow LED-5mm",
			"description":"A generic yellow LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-yellow.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-yellow.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"Battery block 9V",
			"description":"Your standard 9 Volts battery block",
			"image":"core\/breadboard\/Battery_block_9V85_leg.svg",
			"icon":"core\/breadboard\/Battery_block_9V85_leg.svg",
			"width":"95.269",
			"height":"151.872",
			"points": [[94, 15.158, 3.256, 4.998], [94, 7.958, 3.256, 5]]
		}, {
			"name":"UNBUFFERED_INVERTER",
			"description":"FAIRCHILD Unbuffered Inverter.Used for external clock sourcesDigikey P\/N NC7SPU04P5XCT-ND",
			"image":"core\/breadboard\/sparkfun-digitalic_sc70_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sc70_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"SPST Switch",
			"description":"SPST SwitchSimple slide switch .Spark Fun Electronics SKU: COM-00102",
			"image":"core\/breadboard\/sparkfun-electromechanical_switch-spst-smd-a_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_switch-spst-smd-a_breadboard.svg",
			"width":"583.139",
			"height":"600",
			"points": [[124.605, 533.05, 33.93, 33.9], [224.605, 533.05, 33.93, 33.9], [224.605, 33.05, 33.93, 33.9], [324.605, 533.05, 33.93, 33.9], [324.605, 33.05, 33.93, 33.9], [424.605, 533.05, 33.93, 33.9], [424.605, 33.05, 33.93, 33.9]]
		}, {
			"name":"Header 1",
			"description":"Header 1Standard 1-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116) , right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).",
			"image":"core\/breadboard\/sparkfun-connectors_pad-1.5x4.5_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_pad-1.5x4.5_breadboard.svg",
			"width":"259.055",
			"height":"400",
			"points": [[112.563, 333.05, 33.93, 33.9]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder JumperStandard SMD solder jumper.Used to automate production.Two varients: Normally Open and Normally Closed are the same, but have different paste layers.NC will have a large amount of paste and should jumper during reflow.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s_breadboard.svg",
			"width":"246.307",
			"height":"400",
			"points": [[106.189, 333.05, 33.93, 33.9], [106.189, 33.05, 33.93, 33.9]]
		}, {
			"name":"DeuLigne 1.1-The Snootlab 's LCD shield for Arduino",
			"description":"\tThe LCD shield for Arduino by Snootlab LCD 2x16 characters alphanumeric for ArduinoPrincipal features :2 lines of 16 characters dispaly1 joystick 5 positions (up, down, left, right, action) using only one analog input pin (A0 defaut, can be changed if necessary)I2C managed display; all the digital input\/output of the Arduino are availableOne library availableSoftware configured backlight (can be unactivated)Contrast control on the shieldStrong mechanical mounting of the display maintained by spacers and screwsReset buton on top of the shield This new 1.1 release has now three holes compatible with Arduino making mechanical connection between the Arduino-Shield-LCD very strong and make it embeddable on robots. Assembly guide : link Library on GitHub : linkOur libraries are available for Arduino and Arduino 1.0 (select the branch on Github). The official support forum: forum.snootlab.com",
			"image":"core\/breadboard\/LeDeuligne1.1_breadboard.svg",
			"icon":"core\/breadboard\/LeDeuligne1.1_breadboard.svg",
			"width":"230.4",
			"height":"180",
			"points": [[176.948, 169.748, 6.104, 6.104], [184.148, 169.748, 6.104, 6.104], [191.348, 169.748, 6.104, 6.104], [198.548, 169.748, 6.104, 6.104], [205.748, 169.748, 6.104, 6.104], [212.948, 169.748, 6.104, 6.104], [151.208, 18.728, 5.744, 5.744], [144.008, 18.728, 5.744, 5.744], [136.808, 18.728, 5.744, 5.744], [129.608, 18.728, 5.744, 5.744], [122.408, 18.728, 5.744, 5.744], [115.208, 18.728, 5.744, 5.744], [108.008, 18.728, 5.744, 5.744], [100.808, 18.728, 5.744, 5.744], [213.128, 18.728, 5.744, 5.744], [205.928, 18.728, 5.744, 5.744], [198.728, 18.728, 5.744, 5.744], [191.528, 18.728, 5.744, 5.744], [184.328, 18.728, 5.744, 5.744], [177.128, 18.728, 5.744, 5.744], [169.928, 18.728, 5.744, 5.744], [162.728, 18.728, 5.744, 5.744], [126.728, 155.528, 5.744, 5.744], [133.928, 155.528, 5.744, 5.744], [141.128, 155.528, 5.744, 5.744], [148.328, 155.528, 5.744, 5.744], [155.528, 155.528, 5.744, 5.744], [162.728, 155.528, 5.744, 5.744], [177.128, 155.528, 5.744, 5.744], [184.328, 155.528, 5.744, 5.744], [191.528, 155.528, 5.744, 5.744], [198.728, 155.528, 5.744, 5.744], [205.928, 155.528, 5.744, 5.744], [213.128, 155.528, 5.744, 5.744], [155.348, 4.148, 6.104, 6.104], [148.148, 4.148, 6.104, 6.104], [140.948, 4.148, 6.104, 6.104], [133.748, 4.148, 6.104, 6.104], [126.548, 4.148, 6.104, 6.104], [119.348, 4.148, 6.104, 6.104], [112.148, 4.148, 6.104, 6.104], [104.948, 4.148, 6.104, 6.104], [212.948, 4.148, 6.104, 6.104], [205.748, 4.148, 6.104, 6.104], [198.548, 4.148, 6.104, 6.104], [191.348, 4.148, 6.104, 6.104], [184.148, 4.148, 6.104, 6.104], [176.948, 4.148, 6.104, 6.104], [169.748, 4.148, 6.104, 6.104], [162.548, 4.148, 6.104, 6.104], [126.548, 169.748, 6.104, 6.104], [133.748, 169.748, 6.104, 6.104], [140.948, 169.748, 6.104, 6.104], [148.148, 169.748, 6.104, 6.104], [155.348, 169.748, 6.104, 6.104], [162.548, 169.748, 6.104, 6.104]]
		}, {
			"name":"Blue LED-5mm",
			"description":"A generic blue LED (~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-blue.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-blue.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"Battery Holders",
			"description":"Battery HoldersVarious common sizes : AA, AAA, 20mm coin cell and 12mm coin cell.",
			"image":"core\/breadboard\/sparkfun-electromechanical_battery-aaa_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_battery-aaa_breadboard.svg",
			"width":"132.859",
			"height":"32.684",
			"points": [[23.057, 12.57, 7.544, 7.544], [1.457, 12.57, 7.544, 7.544], [102.257, 12.57, 7.544, 7.544], [123.857, 12.57, 7.544, 7.544]]
		}, {
			"name":"TRANSISTOR_NPN",
			"description":"Generic NPN BJT. MMBT2222 is the common NPN we use. Double check against datasheet- not all devices are the same!",
			"image":"core\/breadboard\/sparkfun-discretesemi_sot223_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-discretesemi_sot223_breadboard.svg",
			"width":"333",
			"height":"600",
			"points": [[99.535, 533.05, 33.93, 33.9], [99.535, 33.05, 33.93, 33.9], [199.535, 533.05, 33.93, 33.9], [199.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"TRANSFORMER",
			"description":"Small transformers",
			"image":"core\/breadboard\/sparkfun-poweric_transformer_smd_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_transformer_smd_breadboard.svg",
			"width":"391.476",
			"height":"600",
			"points": [[78.7732, 533.05, 33.93, 33.9], [78.7732, 33.05, 33.93, 33.9], [178.773, 533.05, 33.93, 33.9], [178.773, 33.05, 33.93, 33.9], [278.773, 533.05, 33.93, 33.9], [278.773, 33.05, 33.93, 33.9]]
		}, {
			"name":"ATMEGA128",
			"description":"ATmega128\/128L\/1281\/2561. Note: The ATmega128 pin 1 is PEN and the ATmega256\/1281 pin 1 is PG5.",
			"image":"core\/breadboard\/sparkfun-digitalic_tqfp64_14x14mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tqfp64_14x14mm_breadboard.svg",
			"width":"3200",
			"height":"800",
			"points": [[33.035, 733.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 733.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 733.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 733.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 733.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 733.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 733.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 733.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 733.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 733.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 733.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 733.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 733.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 733.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 733.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 733.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 733.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 733.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 733.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 733.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 733.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 733.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 733.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 733.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 733.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 733.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 733.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 733.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 733.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 733.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 733.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 733.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"Logic Level Converter",
			"description":"If you' ve ever tried to connect a 3.3V device to a 5V system, you know what a challenge it can be.The SparkFun logic level converter is a small device that safely steps down 5V signals to 3.3V and steps up 3.3V to 5V.This level converter also works with 2.8V and 1.8V devices.Each level converter has the capability of converting 4 pins on the high side to 4 pins on the low side.Two inputs and two outputs are provided for each side.  Bread board friendly!Can be used with normal serial, I2C, SPI, and any other digital signal.Does not work with an analog signal.  The level converter is very easy to use.The board needs to be powered from the two voltages sources(high voltage and low voltage)that your system is using.High voltage(5V for example)to the 'HV' pin, low voltage(2.8V for example)to 'LV', and ground from the system to the 'GND' pin.  Pins are labeled as Inputs and Outputs.These are relative to the board.A digital one going into the RXI pin on the 5V side will show up on the RXO pin on the 3.3V side as 3.3V.A digital one going into the TXI pin on the 3.3V side will show up on the TXO pin on the 5V side as 5V.  Dimensions: 0.5x0.6'  Documents: Schematic",
			"image":"core\/breadboard\/Level-Converter-v11_breadboard.svg",
			"icon":"core\/breadboard\/Level-Converter-v11_breadboard.svg",
			"width":"43.2",
			"height":"36",
			"points": [[36.728, 29.528, 5.744, 5.744], [29.528, 29.528, 5.744, 5.744], [22.328, 29.528, 5.744, 5.744], [15.128, 29.528, 5.744, 5.744], [7.928, 29.528, 5.744, 5.744], [0.728, 29.528, 5.744, 5.744], [0.728, 0.728, 5.744, 5.744], [7.928, 0.728, 5.744, 5.744], [15.128, 0.728, 5.744, 5.744], [22.328, 0.728, 5.744, 5.744], [29.528, 0.728, 5.744, 5.744], [36.728, 0.728, 5.744, 5.744]]
		}, {
			"name":"Mystery Part-16 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 16 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part16.svg",
			"icon":"obsolete\/breadboard\/mystery_part16.svg",
			"width":"162",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002], [52.5, 24.672941, 5, 6.3400002], [62.5, 24.672941, 5, 6.3400002], [72.5, 24.672941, 5, 6.3400002], [82.5, 24.672941, 5, 6.3400002], [92.5, 24.672941, 5, 6.3400002], [102.5, 24.672941, 5, 6.3400002], [112.5, 24.672941, 5, 6.3400002], [122.5, 24.672941, 5, 6.3400002], [132.5, 24.672941, 5, 6.3400002], [142.5, 24.672941, 5, 6.3400002], [152.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"**  * Unproven!!! **  *",
			"description":"connector for 10x2 16-segment E-paper Display(LCD-10150) **  * Unproven!!! **  *",
			"image":"core\/breadboard\/sparkfun-connectors_ffc26_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_ffc26_breadboard.svg",
			"width":"1543.72",
			"height":"600",
			"points": [[104.895, 533.05, 33.93, 33.9], [104.895, 33.05, 33.93, 33.9], [204.895, 533.05, 33.93, 33.9], [204.895, 33.05, 33.93, 33.9], [304.895, 533.05, 33.93, 33.9], [304.895, 33.05, 33.93, 33.9], [404.895, 533.05, 33.93, 33.9], [404.895, 33.05, 33.93, 33.9], [504.895, 533.05, 33.93, 33.9], [504.895, 33.05, 33.93, 33.9], [604.895, 533.05, 33.93, 33.9], [604.895, 33.05, 33.93, 33.9], [704.895, 533.05, 33.93, 33.9], [704.895, 33.05, 33.93, 33.9], [804.895, 533.05, 33.93, 33.9], [804.895, 33.05, 33.93, 33.9], [904.895, 533.05, 33.93, 33.9], [904.895, 33.05, 33.93, 33.9], [1004.89, 533.05, 33.93, 33.9], [1004.89, 33.05, 33.93, 33.9], [1104.89, 533.05, 33.93, 33.9], [1104.89, 33.05, 33.93, 33.9], [1204.89, 533.05, 33.93, 33.9], [1204.89, 33.05, 33.93, 33.9], [1304.89, 533.05, 33.93, 33.9], [1304.89, 33.05, 33.93, 33.9], [1404.89, 533.05, 33.93, 33.9], [1404.89, 33.05, 33.93, 33.9]]
		}, {
			"name":"Mystery Part-7 pins",
			"description":"A dummy, proxy, ersatz, stand-in part for whatever you want.With 7 pins on a 100 mil inline pin header footprint.",
			"image":"obsolete\/breadboard\/mystery_part7.svg",
			"icon":"obsolete\/breadboard\/mystery_part7.svg",
			"width":"72",
			"height":"30",
			"points": [[2.5, 24.672941, 5, 6.3400002], [12.5, 24.672941, 5, 6.3400002], [22.5, 24.672941, 5, 6.3400002], [32.5, 24.672941, 5, 6.3400002], [42.5, 24.672941, 5, 6.3400002], [52.5, 24.672941, 5, 6.3400002], [62.5, 24.672941, 5, 6.3400002]]
		}, {
			"name":"2.4GHz Transceiver",
			"description":"2.4GHz TransceiverThis is the very popular, low power RF transceiver from Nordic Semiconductor.Used in the Nike + iPod product.SKU: COM-00300",
			"image":"core\/breadboard\/sparkfun-rf_mlp-24_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_mlp-24_breadboard.svg",
			"width":"1300",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Motor Driver 1A Dual TB6612FNG",
			"description":"The TB6612FNG motor driver can control up to two DC motors at a constant current of 1.2A(3.2A peak).Two input signals(IN1 and IN2)can be used to control the motor in one of four function modes-CW, CCW, short-brake, and stop.The two motor outputs(A and B)can be separately controlled, the speed of each motor is controlled via a PWM input signal with a frequency up to 100kHz.The STBY pin should be pulled high to take the motor out of standby mode.Logic supply voltage(VCC)can be in the range of 2.7-5.5VDC, while the motor supply(VM)is limited to a maximum voltage of 15VDC.The output current is rated up to 1.2A per channel(or up to 3.2A for a short, single pulse).Board comes with all components installed as shown.Decoupling capacitors are included on both supply lines.All pins of the TB6612FNG are broken out to two 0.1' pitch headers; the pins are arranged such that input pins are on one side and output pins are on the other.Features: -Power supply voltage: VM = 15V max, VCC = 2.7-5.5V-Output current: Iout = 1.2A(average)\/3.2A(peak)-Standby control to save power-CW\/CCW\/short brake\/stop motor control modes-Built-in thermal shutdown circuit and low voltage detecting circuit-All pins of the TB6612FNG broken out to 0.1' spaced pins-Filtering capacitors on both supply lines",
			"image":"core\/breadboard\/TB6612FNG Breakout v11.svg",
			"icon":"core\/breadboard\/TB6612FNG Breakout v11.svg",
			"width":"57.6",
			"height":"57.6",
			"points": [[4.1, 50.9, 6.2, 6.2], [4.1, 43.7, 6.2, 6.2], [4.1, 36.5, 6.2, 6.2], [4.1, 29.3, 6.2, 6.2], [4.1, 22.1, 6.2, 6.2], [4.1, 14.9, 6.2, 6.2], [4.1, 7.7, 6.2, 6.2], [4.1, 0.5, 6.2, 6.2], [47.3, 0.5, 6.2, 6.2], [47.3, 7.7, 6.2, 6.2], [47.3, 14.9, 6.2, 6.2], [47.3, 22.1, 6.2, 6.2], [47.3, 29.3, 6.2, 6.2], [47.3, 36.5, 6.2, 6.2], [47.3, 43.7, 6.2, 6.2], [47.3, 50.9, 6.2, 6.2]]
		}
	]
}, {
	"page":"20",
	"count": 37,
	"el": [{
			"name":"Solder Jumper",
			"description":"Solder JumperStandard SMD solder jumper.Used to automate production.Two varients: Normally Open and Normally Closed are the same, but have different paste layers.NC will have a large amount of paste and should jumper during reflow.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s-no_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s-no_breadboard.svg",
			"width":"243.565",
			"height":"400",
			"points": [[104.817, 333.05, 33.93, 33.9], [104.817, 33.05, 33.93, 33.9]]
		}, {
			"name":"FKIT-SNAP_CONNECTOR",
			"description":"Snap connector for Fabrick.it products",
			"image":"core\/breadboard\/sparkfun-electromechanical_fkit-snap_male_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_fkit-snap_male_breadboard.svg",
			"width":"1094.1",
			"height":"1000",
			"points": [[480.083, 933.05, 33.93, 33.9], [580.083, 933.05, 33.93, 33.9], [580.083, 33.05, 33.93, 33.9]]
		}, {
			"name":"USB_MICROB_PLUG",
			"description":"USB Micro-B PlugComes in a variety of packages.Check out Hirose 's ZX-x0 line: http:\/\/www.hirose.co.jp\/cataloge_hp\/e24200011.pdf",
			"image":"core\/breadboard\/sparkfun-connectors_micro-b-ra-smt_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_micro-b-ra-smt_breadboard.svg",
			"width":"943.611",
			"height":"800",
			"points": [[354.841, 733.05, 33.93, 33.9], [454.841, 733.05, 33.93, 33.9], [454.841, 33.05, 33.93, 33.9], [554.841, 733.05, 33.93, 33.9], [554.841, 33.05, 33.93, 33.9]]
		}, {
			"name":"Jumper",
			"description":"JumperBasic 0.1 spaced jumper. Use with breakaway headers.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s_breadboard.svg",
			"width":"246.307",
			"height":"400",
			"points": [[106.189, 333.05, 33.93, 33.9], [106.189, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Cap Sense Shield",
			"description":"\tThe MPR121 IC is a great way to build simple capacitive touch interfaces, and now it' s even easier to incorporate into your Arduino projects with the touch shield.The touch shield has 9 capacitive touch pads, with headers for the remaining 3 electrode connections.With this shield you can have a total of 12 touch sensitive buttons.An on-board logic level converter allows it to work with 5V and 3.3V Arduino boards.Simply solder on some header pins and stack it on to your Arduino for a convenient input device.Check below for some example code to get you started. Documents:    Schematic   Eagle Files   Example Code",
			"image":"core\/breadboard\/Touch_Shield-v11_breadboard.svg",
			"icon":"core\/breadboard\/Touch_Shield-v11_breadboard.svg",
			"width":"151.2",
			"height":"169.2",
			"points": [[140.948, 140.948, 6.104, 6.104], [140.948, 148.148, 6.104, 6.104], [140.948, 155.348, 6.104, 6.104], [140.948, 90.548, 6.104, 6.104], [140.948, 83.348, 6.104, 6.104], [140.948, 47.348, 6.104, 6.104], [140.948, 40.148, 6.104, 6.104], [140.948, 32.948, 6.104, 6.104], [140.948, 25.748, 6.104, 6.104], [140.948, 18.548, 6.104, 6.104], [140.948, 11.348, 6.104, 6.104], [4.148, 122.948, 6.104, 6.104], [4.148, 25.748, 6.104, 6.104], [4.148, 32.948, 6.104, 6.104], [4.148, 40.148, 6.104, 6.104], [4.148, 47.348, 6.104, 6.104], [4.148, 54.548, 6.104, 6.104], [4.148, 61.748, 6.104, 6.104], [4.148, 72.548, 6.104, 6.104], [4.148, 79.748, 6.104, 6.104], [4.148, 86.948, 6.104, 6.104], [4.148, 94.148, 6.104, 6.104], [4.148, 101.348, 6.104, 6.104], [4.148, 108.548, 6.104, 6.104], [140.948, 76.148, 6.104, 6.104], [140.948, 68.948, 6.104, 6.104], [4.148, 115.748, 6.104, 6.104], [140.948, 97.748, 6.104, 6.104], [4.148, 11.348, 6.104, 6.104], [4.148, 18.548, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104]]
		}, {
			"name":"linino one",
			"description":"The Linino \ u2122 ONE is a MIPS board based on the Atheros AR9331 and the ATmega32u4(datasheet).The Atheros processor supports Linino, a Linux distribution based on OpenWRT.The board has built-in WiFi support, 20 digital input\/output pins(of which 7 can be used as PWM outputs and 12 as analog inputs), a 16 MHz crystal oscillator, a micro USB connection, an ICSP header, 2 reset buttons and 1 user button.",
			"image":"core\/breadboard\/linino_one(rev1)_breadboard.svg",
			"icon":"core\/breadboard\/linino_one(rev1)_breadboard.svg",
			"width":"205.344",
			"height":"64.828",
			"points": [[140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [140.948, 61.748, 6.104, 6.104], [11.268, 0.816, 5.62, 5.62], [18.47, 0.816, 5.62, 5.62], [25.669, 0.816, 5.62, 5.62], [32.869, 0.816, 5.62, 5.62], [40.069, 0.816, 5.62, 5.62], [47.269, 0.816, 5.62, 5.62], [54.469, 0.816, 5.62, 5.62], [61.669, 0.816, 5.62, 5.62], [68.87, 0.816, 5.62, 5.62], [76.073, 0.816, 5.62, 5.62], [83.269, 0.816, 5.62, 5.62], [97.655, 0.813, 5.624, 5.624], [111.947, 0.813, 5.624, 5.624], [140.857, 0.813, 5.624, 5.624], [148.058, 0.815, 5.624, 5.624], [148.082, 58.416, 5.624, 5.624], [133.682, 58.414, 5.624, 5.624], [119.28, 58.414, 5.624, 5.624], [83.267, 58.414, 5.624, 5.624], [61.667, 58.414, 5.624, 5.624], [54.467, 58.414, 5.624, 5.624], [47.267, 58.414, 5.624, 5.624], [40.067, 58.414, 5.624, 5.624], [32.867, 58.414, 5.624, 5.624], [25.667, 58.414, 5.624, 5.624], [18.466, 58.414, 5.624, 5.624], [11.265, 58.414, 5.624, 5.624]]
		}, {
			"name":"ws2812b",
			"description":"WS2812B 5050 RGB LED with Integrated Driver Chip",
			"image":"core\/breadboard\/ws2812b_breadboard.svg",
			"icon":"core\/breadboard\/ws2812b_breadboard.svg",
			"width":"21.6",
			"height":"43.2",
			"points": [[1.451, 37.454, 4.299, 4.297], [1.45, 1.452, 4.299, 4.297], [15.851, 37.454, 4.299, 4.297], [15.851, 1.452, 4.299, 4.297]]
		}, {
			"name":"Voltage Regulator-5V",
			"description":"5V DC Voltage Regulator",
			"image":"core\/breadboard\/voltage_regulator_vreg.svg",
			"icon":"core\/breadboard\/voltage_regulator_vreg.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"XLR3_NCFAH2",
			"description":"XLR connector",
			"image":"core\/breadboard\/sparkfun-connectors_xlr3_nc3fah2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_xlr3_nc3fah2_breadboard.svg",
			"width":"904.375",
			"height":"1200",
			"points": [[385.222, 1133.05, 33.93, 33.9], [385.222, 33.05, 33.93, 33.9], [485.222, 1133.05, 33.93, 33.9], [485.222, 33.05, 33.93, 33.9]]
		}, {
			"name":"Arduino Voicebox Shield(Stephen Hawking in a box)",
			"description":"The VoiceBox Shield can be mounted on top of your Arduino USB Board or Pro, to give it access to all capabilities of the SpeakJet voice and sound synthesizer.The Voice Box Shield uses the SpeakJet chip to convert serial commands into a great robot-sounding voice.  Populated on the VoiceBox Shield are the 18-DIP SpeakJet IC and a two stage audio amplifier with a potentiometer to set the gain.You can connect a speaker directly to the 'SPK+\/-' pins,	and get your Arduino-bot talking with very minimal work!  You can control the SpeakJet through either its serial line, or the eight event input lines which are connected to digital pins 5-12.A 3-way jumper allows you to connect either the software(D2)or hardware(D1)TX pin of the Arduino to the SpeakJet 's serial input.\t\tAlso included on the shield are a 13x7 grid of 0.1' pitch through-holes for prototyping, the Arduino's reset button.Headers are not included, we recommend the 6 and 8-pin stackable headers.  Documents:    Schematic   Example Code   Listen to the SpeakJet!(YouTube)   Talking Wireless Server Tutorial   SpeakJet User ' s Guide   SpeakJet Dictionary   Tutorial on adding the TTS256 text to speech IC to the shield Replaces: DEV-09624",
			"image":"core\/breadboard\/Arduino Voice Shield-v16_breadboard.svg",
			"icon":"core\/breadboard\/Arduino Voice Shield-v16_breadboard.svg",
			"width":"151.2",
			"height":"176.904",
			"points": [[101.348, 11.852, 6.104, 6.104], [108.548, 11.852, 6.104, 6.104], [140.948, 98.252, 6.104, 6.104], [140.948, 91.052, 6.104, 6.104], [140.948, 55.052, 6.104, 6.104], [140.948, 47.852, 6.104, 6.104], [140.948, 40.652, 6.104, 6.104], [140.948, 33.452, 6.104, 6.104], [140.948, 26.252, 6.104, 6.104], [140.948, 19.052, 6.104, 6.104], [4.148, 130.652, 6.104, 6.104], [4.148, 33.452, 6.104, 6.104], [4.148, 40.652, 6.104, 6.104], [4.148, 47.852, 6.104, 6.104], [4.148, 55.052, 6.104, 6.104], [4.148, 62.252, 6.104, 6.104], [4.148, 69.452, 6.104, 6.104], [4.148, 80.252, 6.104, 6.104], [4.148, 87.452, 6.104, 6.104], [4.148, 94.652, 6.104, 6.104], [4.148, 101.852, 6.104, 6.104], [4.148, 109.052, 6.104, 6.104], [4.148, 116.252, 6.104, 6.104], [140.948, 83.852, 6.104, 6.104], [140.948, 76.652, 6.104, 6.104], [4.148, 123.452, 6.104, 6.104], [140.948, 105.452, 6.104, 6.104], [4.148, 19.052, 6.104, 6.104], [4.148, 26.252, 6.104, 6.104], [140.948, 69.452, 6.104, 6.104], [32.948, 80.252, 6.104, 6.104], [40.148, 80.252, 6.104, 6.104], [47.348, 80.252, 6.104, 6.104], [54.548, 80.252, 6.104, 6.104], [61.748, 80.252, 6.104, 6.104], [76.148, 80.252, 6.104, 6.104], [83.348, 80.252, 6.104, 6.104], [90.548, 80.252, 6.104, 6.104], [97.748, 80.252, 6.104, 6.104], [104.948, 80.252, 6.104, 6.104], [112.148, 80.252, 6.104, 6.104], [119.348, 80.252, 6.104, 6.104], [119.348, 73.052, 6.104, 6.104], [112.148, 73.052, 6.104, 6.104], [104.948, 73.052, 6.104, 6.104], [97.748, 73.052, 6.104, 6.104], [90.548, 73.052, 6.104, 6.104], [83.348, 73.052, 6.104, 6.104], [76.148, 73.052, 6.104, 6.104], [68.948, 73.052, 6.104, 6.104], [61.748, 73.052, 6.104, 6.104], [54.548, 73.052, 6.104, 6.104], [47.348, 73.052, 6.104, 6.104], [40.148, 73.052, 6.104, 6.104], [32.948, 73.052, 6.104, 6.104], [32.948, 65.852, 6.104, 6.104], [40.148, 65.852, 6.104, 6.104], [47.348, 65.852, 6.104, 6.104], [54.548, 65.852, 6.104, 6.104], [61.748, 65.852, 6.104, 6.104], [68.948, 65.852, 6.104, 6.104], [76.148, 65.852, 6.104, 6.104], [83.348, 65.852, 6.104, 6.104], [90.548, 65.852, 6.104, 6.104], [97.748, 65.852, 6.104, 6.104], [104.948, 65.852, 6.104, 6.104], [112.148, 65.852, 6.104, 6.104], [119.348, 65.852, 6.104, 6.104], [119.348, 58.652, 6.104, 6.104], [112.148, 58.652, 6.104, 6.104], [104.948, 58.652, 6.104, 6.104], [97.748, 58.652, 6.104, 6.104], [90.548, 58.652, 6.104, 6.104], [83.348, 58.652, 6.104, 6.104], [76.148, 58.652, 6.104, 6.104], [68.948, 58.652, 6.104, 6.104], [61.748, 58.652, 6.104, 6.104], [54.548, 58.652, 6.104, 6.104], [47.348, 58.652, 6.104, 6.104], [40.148, 58.652, 6.104, 6.104], [32.948, 58.652, 6.104, 6.104], [32.948, 51.452, 6.104, 6.104], [40.148, 51.452, 6.104, 6.104], [47.348, 51.452, 6.104, 6.104], [54.548, 51.452, 6.104, 6.104], [90.548, 51.452, 6.104, 6.104], [97.748, 51.452, 6.104, 6.104], [104.948, 51.452, 6.104, 6.104], [112.148, 51.452, 6.104, 6.104], [119.348, 51.452, 6.104, 6.104], [119.348, 44.252, 6.104, 6.104], [112.148, 44.252, 6.104, 6.104], [104.948, 44.252, 6.104, 6.104], [97.748, 44.252, 6.104, 6.104], [90.548, 44.252, 6.104, 6.104], [54.548, 44.252, 6.104, 6.104], [47.348, 44.252, 6.104, 6.104], [40.148, 44.252, 6.104, 6.104], [32.948, 44.252, 6.104, 6.104], [32.948, 37.052, 6.104, 6.104], [47.348, 37.052, 6.104, 6.104], [40.148, 37.052, 6.104, 6.104], [54.548, 37.052, 6.104, 6.104], [90.548, 37.052, 6.104, 6.104], [97.748, 37.052, 6.104, 6.104], [104.948, 37.052, 6.104, 6.104], [112.148, 37.052, 6.104, 6.104], [119.348, 37.052, 6.104, 6.104], [68.948, 80.252, 6.104, 6.104]]
		}, {
			"name":"Capacitor Polarized",
			"description":"Capacitor PolarizedThese are standard SMD and PTH capacitors.Normally 10uF, 47uF, and 100uF in electrolytic and tantalum varieties.Always verify the external diameter of the through hole cap, it varies with capacity, voltage, and manufacturer.The EIA devices should be standard.",
			"image":"core\/breadboard\/sparkfun-passives_eia3216-kit_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_eia3216-kit_breadboard.svg",
			"width":"404.861",
			"height":"400",
			"points": [[185.465, 333.05, 33.93, 33.9], [185.465, 33.05, 33.93, 33.9]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder Jumper2 way solder jumper",
			"image":"core\/breadboard\/sparkfun-passives_sj_3_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_3_breadboard.svg",
			"width":"263",
			"height":"400",
			"points": [[64.535, 333.05, 33.93, 33.9], [164.535, 333.05, 33.93, 33.9], [164.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"SI470X",
			"description":"FM receiver IC.Tested with Si4703.You really only need SEN, RST, SCLK, and SDIO to get a full FM radio working.Antenna comes from headphone jack.See BOB-10344.",
			"image":"core\/breadboard\/sparkfun-rf_si470x_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_si470x_breadboard.svg",
			"width":"1100",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 333.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Peppermill Power Board",
			"description":"The Peppermill Power Board(PPB)lets you turn a geared DC motor into a human-powered device.It also doubles as a sensor that provides information about the direction and rate of turn.HOW TO USEAttach the terminals of a geared DC motor to the grey connector.Use the white switch to select the maximum operating voltage for your target circuit(2.5, 3.3 or 5.0 Volts), and connect the PPB to your target circuit using the header pins.The pins labelled V + and GND provide a regulated power supply, and pins Speed and Direction can be connected to analog inputs on a microcontroller.The PPB has a built-in PIC microcontroller and an array of LEDs to provide instant feedback about the direction and rate of turn.To use this feature, set the black switch to CAL(Calibrate).Give the motor a quick turn, until you see the LEDs light up briefly.Set the switch to RUN, and when you turn the motor the LEDs should light up in a sequence that matches the direction and rate of turn.",
			"image":"core\/breadboard\/Peppermill_Power_Board__a40e6dc7c979bcff.svg",
			"icon":"core\/breadboard\/Peppermill_Power_Board__a40e6dc7c979bcff.svg",
			"width":"180",
			"height":"180",
			"points": [[60.676, 151.95, 4.663, 6.104], [51.744, 152.061, 4.726, 5.975], [42.706, 152.038, 4.726, 5.71], [105.598, 151.949, 4.866, 6.01], [87.565, 152.086, 4.705, 5.986], [132.691, 152.055, 4.708, 6.014], [123.636, 152.082, 4.639, 5.877], [114.621, 152.11, 4.857, 5.628], [42.849788567222, 21.155244731301, 6, 6], [50.302342326841, 21.12050975091, 6, 6]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder Jumper2 way solder jumper",
			"image":"core\/breadboard\/sparkfun-passives_sj_2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2_breadboard.svg",
			"width":"298",
			"height":"400",
			"points": [[82.035, 333.05, 33.93, 33.9], [182.035, 333.05, 33.93, 33.9], [182.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"220 \ u2126 Resistor",
			"description":"A generic resistor",
			"image":"core\/breadboard\/resistor_220.svg",
			"icon":"core\/breadboard\/resistor_220.svg",
			"width":"42.917",
			"height":"9.71",
			"points": [[-0.5, 2.59, 3, 3], [40.417, 2.59, 3, 3]]
		}, {
			"name":"NPN-Transistor",
			"description":"A standard NPN-transistor",
			"image":"core\/breadboard\/transistor_npn.svg",
			"icon":"core\/breadboard\/transistor_npn.svg",
			"width":"16.527",
			"height":"24.081",
			"points": [[-1, 21.081, 4.16, 3], [6.181, 21.081, 4.16, 3], [13.367, 21.081, 4.16, 3]]
		}, {
			"name":"BASIC Stamp 2 sx",
			"description":"The BASIC Stamp 2 serves as the brains inside of electronics projects and applications that require a programmable microcontroller.It is able to control and monitor timers, keypads, motors, sensors, switches, relays, lights, and more.Programming is performed in an easy-to-learn language called PBASIC.",
			"image":"core\/breadboard\/BASIC_Stamp_2.svg",
			"icon":"core\/breadboard\/BASIC_Stamp_2.svg",
			"width":"45.358",
			"height":"86.4",
			"points": [[13.367, 21.081, 4.16, 3], [41.233, 1.85, 5.125, 4.16], [41.233, 1.85, 5.125, 4.16], [41.233, 81.05, 5.125, 4.16], [41.233, 81.05, 5.125, 4.16], [41.233, 9.05, 5.125, 4.16], [41.233, 9.05, 5.125, 4.16], [41.233, 16.25, 5.125, 4.16], [41.233, 16.25, 5.125, 4.16], [41.233, 23.45, 5.125, 4.16], [41.233, 23.45, 5.125, 4.16], [41.233, 30.65, 5.125, 4.16], [41.233, 30.65, 5.125, 4.16], [41.233, 37.851, 5.125, 4.16], [41.233, 37.851, 5.125, 4.16], [41.233, 45.05, 5.125, 4.16], [41.233, 45.05, 5.125, 4.16], [41.233, 52.251, 5.125, 4.16], [41.233, 52.251, 5.125, 4.16], [41.233, 59.45, 5.125, 4.16], [41.233, 59.45, 5.125, 4.16], [41.233, 66.649, 5.125, 4.16], [41.233, 66.649, 5.125, 4.16], [41.233, 73.851, 5.125, 4.16]]
		}, {
			"name":"Jumper",
			"description":"JumperBasic 0.1 spaced jumper.Use with breakaway headers.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s-no_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s-no_breadboard.svg",
			"width":"243.565",
			"height":"400",
			"points": [[104.817, 333.05, 33.93, 33.9], [104.817, 33.05, 33.93, 33.9]]
		}, {
			"name":"Solder Jumper",
			"description":"Solder Jumper2 way solder jumper",
			"image":"core\/breadboard\/sparkfun-passives_sj_2w_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2w_breadboard.svg",
			"width":"338",
			"height":"400",
			"points": [[102.035, 333.05, 33.93, 33.9], [202.035, 333.05, 33.93, 33.9], [202.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"IDG1215",
			"description":"Invensense dual-axis 67 deg gyro, COM-09071",
			"image":"core\/breadboard\/sparkfun-sensors_idg500_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_idg500_breadboard.svg",
			"width":"1500",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 333.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 333.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 333.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 333.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 333.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"Blue smd LED",
			"description":"A generic blue LED(~1.8V)",
			"image":"core\/breadboard\/LED-5mm-red-leg.svg",
			"icon":"core\/breadboard\/LED-5mm-red-leg.svg",
			"width":"21.467",
			"height":"40.565",
			"points": [[3.793, 34.307, 4.989, 3], [13.793, 34.307, 4.992, 3]]
		}, {
			"name":"DS1302",
			"description":"DS1302 SPI Real Time Clock",
			"image":"core\/breadboard\/DS1302_breadboard.svg",
			"icon":"core\/breadboard\/DS1302_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"SN74LS14N",
			"description":"Hex Inverter Schmitt Trigger",
			"image":"core\/breadboard\/SN74LS14N_breadboard.svg",
			"icon":"core\/breadboard\/SN74LS14N_breadboard.svg",
			"width":"70.0",
			"height":"33.0",
			"points": [[2.5, 27.66, 5, 6.34], [2.5, -1, 5, 6.34], [62.5, 27.66, 5, 6.34], [62.5, -1, 5, 6.34], [12.5, 27.66, 5, 6.34], [12.5, -1, 5, 6.34], [22.5, 27.66, 5, 6.34], [22.5, -1, 5, 6.34], [32.5, 27.66, 5, 6.34], [32.5, -1, 5, 6.34], [42.5, 27.66, 5, 6.34], [42.5, -1, 5, 6.34], [52.5, 27.66, 5, 6.34], [52.5, -1, 5, 6.34]]
		}, {
			"name":"DS1307",
			"description":"DS1307 I2C Real Time Clock",
			"image":"core\/breadboard\/DS1307_breadboard.svg",
			"icon":"core\/breadboard\/DS1307_breadboard.svg",
			"width":"40",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.3400002], [2.5, -1, 5, 6.3400002], [32.5, 27.66, 5, 6.3400002], [32.5, -1, 5, 6.3400002], [12.5, 27.66, 5, 6.3400002], [12.5, -1, 5, 6.3400002], [22.5, 27.66, 5, 6.3400002], [22.5, -1, 5, 6.3400002]]
		}, {
			"name":"GE863 Cellular Module with GPS",
			"description":"GE863 Cellular Module with GPSProto layout and schematic for GE863 cellular module with SiRF III GPS.Spark Fun Electronics SKU: CEL-08246",
			"image":"core\/breadboard\/sparkfun-rf_ge863_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_ge863_breadboard.svg",
			"width":"4200",
			"height":"1600",
			"points": [[33.035, 1533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 1533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 1533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 1533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 1533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 1533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 1533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 1533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 1533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 1533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 1533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 1533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 1533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 1533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 1533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 1533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9], [1633.04, 1533.05, 33.93, 33.9], [1633.04, 33.05, 33.93, 33.9], [1733.04, 1533.05, 33.93, 33.9], [1733.04, 33.05, 33.93, 33.9], [1833.04, 1533.05, 33.93, 33.9], [1833.04, 33.05, 33.93, 33.9], [1933.04, 1533.05, 33.93, 33.9], [1933.04, 33.05, 33.93, 33.9], [2033.04, 1533.05, 33.93, 33.9], [2033.04, 33.05, 33.93, 33.9], [2133.03, 1533.05, 33.93, 33.9], [2133.03, 33.05, 33.93, 33.9], [2233.03, 1533.05, 33.93, 33.9], [2233.03, 33.05, 33.93, 33.9], [2333.03, 1533.05, 33.93, 33.9], [2333.03, 33.05, 33.93, 33.9], [2433.03, 1533.05, 33.93, 33.9], [2433.03, 33.05, 33.93, 33.9], [2533.03, 1533.05, 33.93, 33.9], [2533.03, 33.05, 33.93, 33.9], [2633.03, 1533.05, 33.93, 33.9], [2633.03, 33.05, 33.93, 33.9], [2733.03, 1533.05, 33.93, 33.9], [2733.03, 33.05, 33.93, 33.9], [2833.03, 1533.05, 33.93, 33.9], [2833.03, 33.05, 33.93, 33.9], [2933.03, 1533.05, 33.93, 33.9], [2933.03, 33.05, 33.93, 33.9], [3033.03, 1533.05, 33.93, 33.9], [3033.03, 33.05, 33.93, 33.9], [3133.03, 1533.05, 33.93, 33.9], [3133.03, 33.05, 33.93, 33.9], [3233.03, 1533.05, 33.93, 33.9], [3233.03, 33.05, 33.93, 33.9], [3333.03, 1533.05, 33.93, 33.9], [3333.03, 33.05, 33.93, 33.9], [3433.03, 1533.05, 33.93, 33.9], [3433.03, 33.05, 33.93, 33.9], [3533.03, 1533.05, 33.93, 33.9], [3533.03, 33.05, 33.93, 33.9], [3633.03, 1533.05, 33.93, 33.9], [3633.03, 33.05, 33.93, 33.9], [3733.03, 1533.05, 33.93, 33.9], [3733.03, 33.05, 33.93, 33.9], [3833.03, 1533.05, 33.93, 33.9], [3833.03, 33.05, 33.93, 33.9], [3933.03, 1533.05, 33.93, 33.9], [3933.03, 33.05, 33.93, 33.9], [4033.03, 1533.05, 33.93, 33.9], [4033.03, 33.05, 33.93, 33.9], [4133.03, 1533.05, 33.93, 33.9], [4133.03, 33.05, 33.93, 33.9]]
		}, {
			"name":"_h3_MPL115A1(SPI)and MPL115A2(I2C)Miniature Digital Barometer__h3_",
			"description":"MPL115A1(SPI)and MPL115A2(I2C)Miniature Digital Barometer5.0x3.0x1.2mm LGA Package",
			"image":"core\/breadboard\/sparkfun-sensors_lga8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga8_breadboard.svg",
			"width":"400",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"TPS6214X",
			"description":"3-17V, 2A Step Down Converter",
			"image":"core\/breadboard\/sparkfun-poweric_qfn16-3x3mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_qfn16-3x3mm_breadboard.svg",
			"width":"900",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"microSD Socket",
			"description":"microSD SocketPush-push type uSD socket. Schematic element and footprint production proven. Spark Fun Electronics SKU : PRT-00127. tDoc lines correctly indicate media card edge positions when inserting (unlocked, locked, depressed).",
			"image":"core\/breadboard\/sparkfun-connectors_micro-sd-socket-pp_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_micro-sd-socket-pp_breadboard.svg",
			"width":"743.653",
			"height":"800",
			"points": [[104.862, 733.05, 33.93, 33.9], [104.862, 33.05, 33.93, 33.9], [204.862, 733.05, 33.93, 33.9], [204.862, 33.05, 33.93, 33.9], [304.861, 733.05, 33.93, 33.9], [304.861, 33.05, 33.93, 33.9], [404.862, 733.05, 33.93, 33.9], [404.862, 33.05, 33.93, 33.9], [504.862, 733.05, 33.93, 33.9], [504.862, 33.05, 33.93, 33.9], [604.861, 733.05, 33.93, 33.9], [604.861, 33.05, 33.93, 33.9]]
		}, {
			"name":"ISZ500",
			"description":"ISZ500 Single axis gyro",
			"image":"core\/breadboard\/sparkfun-sensors_qfn-28_6x8_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_qfn-28_6x8_breadboard.svg",
			"width":"1400",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 333.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 333.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 333.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 333.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 333.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 333.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 333.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"BUTTON-MAGNETIC",
			"description":"Magnetic metal snaps. 18mm is DEV-08682.",
			"image":"core\/breadboard\/sparkfun-electromechanical_button-10mm_breadboard-male.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_button-10mm_breadboard-male.svg",
			"width":"11.857",
			"height":"30.34",
			"points": [[3.598, 12.393, 5.554, 5.554]]
		}, {
			"name":"JUMPER-3-OLD",
			"description":"",
			"image":"core\/breadboard\/sparkfun-passives_sj_3_paste1_2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_3_paste1_2_breadboard.svg",
			"width":"263",
			"height":"400",
			"points": [[64.535, 333.05, 33.93, 33.9], [164.535, 333.05, 33.93, 33.9], [164.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"CRYSTAL",
			"description":"Various standard crystals. Proven footprints. Spark Fun Electronics SKU : COM-00534",
			"image":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"icon":"core\/breadboard\/CRYSTAL_-_kHz_breadboard.svg",
			"width":"15.457",
			"height":"43.819",
			"points": [[2.451, 39.819, 4.152, 3], [9.651, 39.819, 4.152, 3]]
		}, {
			"name":"Parallax Propeller D40",
			"description":"The Propeller chip makes it easy to rapidly develop embedded applications. Its eight processors (cogs) can operate simultaneously, either independently or cooperatively, sharing common resources through a central hub. The developer has full control over how and when each cog is employed; there is no compiler-driven or operating system-driven splitting of tasks among multiple cogs. A shared system clock keeps each cog on the same time reference, allowing for true deterministic timing and synchronization. Two programming languages are available: the easy-to-learn high-level Spin, and Propeller Assembly which can execute at up to 160 MIPS (20 MIPS per cog).",
			"image":"core\/breadboard\/Parallax_Propeller.svg",
			"icon":"core\/breadboard\/Parallax_Propeller.svg",
			"width":"144",
			"height":"45.359",
			"points": [[1.52, 41.236, 4.16, 5.124], [1.52, -1, 4.16, 5.125], [138.32, 41.236, 4.16, 5.124], [138.32, -1, 4.16, 5.125], [8.72, 41.236, 4.159, 5.124], [8.72, -1, 4.159, 5.125], [15.92, 41.236, 4.16, 5.124], [15.92, -1, 4.16, 5.125], [23.12, 41.236, 4.16, 5.124], [23.12, -1, 4.16, 5.125], [30.32, 41.236, 4.16, 5.124], [30.32, -1, 4.16, 5.125], [37.52, 41.236, 4.16, 5.124], [37.52, -1, 4.16, 5.125], [44.72, 41.236, 4.159, 5.124], [44.72, -1, 4.159, 5.125], [51.92, 41.236, 4.16, 5.124], [51.92, -1, 4.16, 5.125], [59.12, 41.236, 4.16, 5.124], [59.12, -1, 4.16, 5.125], [66.32, 41.236, 4.16, 5.124], [66.32, -1, 4.16, 5.125], [73.52, 41.236, 4.161, 5.124], [73.52, -1, 4.161, 5.125], [80.72, 41.236, 4.159, 5.124], [80.72, -1, 4.159, 5.125], [87.919, 41.236, 4.16, 5.124], [87.919, -1, 4.16, 5.125], [95.119, 41.236, 4.161, 5.124], [95.119, -1, 4.161, 5.125], [102.32, 41.236, 4.16, 5.124], [102.32, -1, 4.16, 5.125], [109.52, 41.236, 4.161, 5.124], [109.52, -1, 4.161, 5.125], [116.72, 41.236, 4.159, 5.124], [116.72, -1, 4.159, 5.125], [123.919, 41.236, 4.16, 5.124], [123.919, -1, 4.16, 5.125], [131.119, 41.236, 4.161, 5.124], [131.119, -1, 4.161, 5.125]]
		}, {
			"name":"LilyPad Coin Cell Battery Holder",
			"description":"If you' re looking for a simple way to add a battery to your LilyPad project, the LilyPad Coin Cell Battery Holder might do the trick.It 's a simple board which holds a 20mm coin cell battery (such as a CR2032) and gives you 4 connection points (two positive and two negative) for sewing into your project.Note: The LilyPad Coin Cell Battery Holder is a design conceived by Felicia Williams of Boulder, Colorado. Also, a portion of this sale is given back to Dr. Leah Buechley for continued development and education of e-textiles.",
			"image":"core\/breadboard\/LilyPad Coincell-Battery-v17_breadboard.svg",
			"icon":"core\/breadboard\/LilyPad Coincell-Battery-v17_breadboard.svg",
			"width":"72.7142",
			"height":"82.1383",
			"points": [[61.22219, 61.08899, 9.67622, 9.67622], [11.54219, 61.08899, 9.67622, 9.67622], [61.22219, 11.40899, 9.67622, 9.67622], [11.54219, 11.40899, 9.67622, 9.67622]]
		}, {
			"name":"Arduino Joystick Shield",
			"description":"\tThe Joystick Shield sits on top of your Arduino and turns it into a simple controller. Five momentary push buttons (4+ joystick select button) and a two-axis thumb joystick gives your Arduino functionality on the level of old Nintendo controllers.\tPlease note: This is an older version of the PCB that does not have the prototyping area. The examples and assembly guides still apply. We' re just trying to give these PCBs a happy home before we move on to the next revision.  The momentary push buttons are connected to Arduino digital pins 2-6; when pressed they will pull the pin low(utilizing the internal pull-ups of the Arduino).Vertical movement of the joystick will produce a proportional analog voltage on analog pin 0, likewise, horizontal movement of the joystick can be tracked on analog pin 1.  This product is only the Joystick Shield PCB-you 'll need to purchase the buttons and joystick separately, and assemble the controller yourself. Here' s what you 'll need in addition to the shield:\t\t\t4 x Momentary Push Button Switch-12mm Square\t\t\t1 x Thumb Joystick\t\t\t1 x Mini Push Button Switch (breaks out Arduino' s reset switch )   2 x 6-pin Arduino Stackable Header   2 x 8-pin Arduino Stackable Header Documents:    Joystick Assembly Tutorial   Joystick Quickstart Guide   Schematic   Eagle Files   Arduino Sample Sketch",
			"image":"core\/breadboard\/Joystick_Shield-v14_breadboard.svg",
			"icon":"core\/breadboard\/Joystick_Shield-v14_breadboard.svg",
			"width":"151.2",
			"height":"241.2",
			"points": [[140.948, 162.548, 6.104, 6.104], [140.948, 155.348, 6.104, 6.104], [140.948, 119.348, 6.104, 6.104], [140.948, 112.148, 6.104, 6.104], [140.948, 104.948, 6.104, 6.104], [140.948, 97.748, 6.104, 6.104], [140.948, 90.548, 6.104, 6.104], [140.948, 83.348, 6.104, 6.104], [4.148, 194.948, 6.104, 6.104], [4.148, 97.748, 6.104, 6.104], [4.148, 104.948, 6.104, 6.104], [4.148, 112.148, 6.104, 6.104], [4.148, 119.348, 6.104, 6.104], [4.148, 126.548, 6.104, 6.104], [4.148, 133.748, 6.104, 6.104], [4.148, 144.548, 6.104, 6.104], [4.148, 151.748, 6.104, 6.104], [4.148, 158.948, 6.104, 6.104], [4.148, 166.148, 6.104, 6.104], [4.148, 173.348, 6.104, 6.104], [4.148, 180.548, 6.104, 6.104], [140.948, 169.748, 6.104, 6.104], [4.148, 83.348, 6.104, 6.104], [4.148, 90.548, 6.104, 6.104]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_cdrh3d28_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_cdrh3d28_breadboard.svg",
			"width":"404.694",
			"height":"600",
			"points": [[185.382, 533.05, 33.93, 33.9], [185.382, 33.05, 33.93, 33.9]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_cdrh2d09_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_cdrh2d09_breadboard.svg",
			"width":"321.153",
			"height":"400",
			"points": [[143.612, 333.05, 33.93, 33.9], [143.612, 33.05, 33.93, 33.9]]
		}, {
			"name":"2.5mm Audio Jack",
			"description":"2.5mm Audio JackSimple 2.5mm common PCB mount audio jack.SKU: PRT-08032",
			"image":"core\/breadboard\/sparkfun-connectors_stereojack2.5mm_specia_pogopins_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_stereojack2.5mm_specia_pogopins_breadboard.svg",
			"width":"655.403",
			"height":"600",
			"points": [[260.736, 533.05, 33.93, 33.9], [260.736, 33.05, 33.93, 33.9], [360.736, 533.05, 33.93, 33.9], [360.736, 33.05, 33.93, 33.9]]
		}, {
			"name":"Jumper",
			"description":"JumperBasic 0.1 spaced jumper.Use with breakaway headers.",
			"image":"core\/breadboard\/sparkfun-passives_sj_2s-no-ns_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_2s-no-ns_breadboard.svg",
			"width":"260.433",
			"height":"400",
			"points": [[113.252, 333.05, 33.93, 33.9], [113.252, 33.05, 33.93, 33.9]]
		}, {
			"name":"H-Bridge",
			"description":"Quadruple Half H-Bridge Motor Driver.Drive two motors with 1.1A with this chip.(SN754410 data sheet from TI here http: \/\/focus.ti.com\/lit\/ds\/symlink\/sn754410.pdf)",
			"image":"core\/breadboard\/h-bridge.svg",
			"icon":"core\/breadboard\/h-bridge.svg",
			"width":"80",
			"height":"33",
			"points": [[2.5, 27.66, 5, 6.34], [12.5, 27.66, 5, 6.34], [22.5, 27.66, 5, 6.34], [32.5, 27.66, 5, 6.34], [42.5, 27.66, 5, 6.34], [52.5, 27.66, 5, 6.34], [62.5, 27.66, 5, 6.34], [72.5, 27.66, 5, 6.34], [72.5, -1, 5, 6.34], [62.5, -1, 5, 6.34], [52.5, -1, 5, 6.34], [42.5, -1, 5, 6.34], [32.5, -1, 5, 6.34], [22.5, -1, 5, 6.34], [12.5, -1, 5, 6.34], [2.5, -1, 5, 6.34]]
		}, {
			"name":"yellow smd LED",
			"description":"A generic yellow LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-yellow.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-yellow.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"USB Connectors",
			"description":"USB ConnectorsUSB-B-PTH is fully proven SKU: PRT-00139USB-miniB is fully proven SKU: PRT-00587USB-A-PCB is untested.USB-A-H is throughly reviewed, but untested.Spark Fun Electronics SKU: PRT-00437USB-B-SMT is throughly reviewed, but untested.Needs silkscreen touching up.USB-A-S has not been used\/testedUSB-MB-H has not been used\/tested",
			"image":"core\/breadboard\/sparkfun-connectors_usb-a-s-silk-female_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_usb-a-s-silk-female_breadboard.svg",
			"width":"743.889",
			"height":"1000",
			"points": [[304.98, 933.05, 33.93, 33.9], [304.98, 33.05, 33.93, 33.9], [404.98, 933.05, 33.93, 33.9], [404.98, 33.05, 33.93, 33.9]]
		}, {
			"name":"RELAY-2",
			"description":"SPDT relay(COM-00100)",
			"image":"core\/breadboard\/sparkfun-electromechanical_relay-g5v_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_relay-g5v_breadboard.svg",
			"width":"36.576",
			"height":"34.917",
			"points": [[2.251, 32.731, 3.276, 3.185], [9.449, 32.731, 3.275, 3.186], [31.049, 32.731, 3.275, 3.186], [31.049, 12.35, 3.275, 2.478], [9.449, 12.35, 3.275, 2.478], [2.251, 12.35, 3.276, 2.479]]
		}
	]
}, {
	"page":"21",
	"count": 37,
	"el": [{
			"name":"Arduino Ethernet Shield",
			"description":"Ethernet shield for the awesome Arduino microcontroller.",
			"image":"obsolete\/breadboard\/Arduino_Ethernet_Shield__1f9aa78a3d98991.svg",
			"icon":"obsolete\/breadboard\/Arduino_Ethernet_Shield__1f9aa78a3d98991.svg",
			"width":"212.184",
			"height":"148.032",
			"points": [[81.648, 3.11, 4.774, 4.773], [88.825, 3.11, 4.771, 4.773], [96.003, 3.11, 4.771, 4.773], [103.18, 3.11, 4.774, 4.773], [110.359, 3.11, 4.773, 4.773], [117.535, 3.11, 4.771, 4.773], [124.714, 3.11, 4.771, 4.773], [131.892, 3.11, 4.773, 4.773], [146.438, 3.11, 4.772, 4.773], [153.615, 3.11, 4.771, 4.773], [160.792, 3.11, 4.771, 4.773], [167.97, 3.11, 4.772, 4.773], [175.147, 3.11, 4.774, 4.773], [182.324, 3.11, 4.771, 4.773], [189.502, 3.11, 4.771, 4.773], [196.68, 3.11, 4.774, 4.773], [110.443, 139.887, 4.774, 4.771], [117.642, 139.887, 4.774, 4.771], [124.84, 139.887, 4.771, 4.771], [132.018, 139.887, 4.772, 4.771], [139.196, 139.887, 4.774, 4.771], [146.372, 139.887, 4.771, 4.771], [160.835, 139.887, 4.771, 4.771], [168.012, 139.887, 4.773, 4.771], [175.19, 139.887, 4.773, 4.771], [182.367, 139.887, 4.771, 4.771], [189.544, 139.887, 4.771, 4.771], [196.722, 139.887, 4.771, 4.771]]
		}, {
			"name":"Electrolytic Capacitor",
			"description":"A smd electrolytic capacitor.",
			"image":"core\/breadboard\/electrolytic_capacitor_small_leg.svg",
			"icon":"core\/breadboard\/electrolytic_capacitor_small_leg.svg",
			"width":"19.686",
			"height":"48.266",
			"points": [[12.39, 44.19, 5, 3], [2.39, 44.19, 5, 3]]
		}, {
			"name":"Humidity and Temperature Sensor RHT03",
			"description":"Digital relative humidity & temperature sensor RHT03",
			"image":"core\/breadboard\/Humidity_and_Temperature_Sensor_RHT03_6.svg",
			"icon":"core\/breadboard\/Humidity_and_Temperature_Sensor_RHT03_6.svg",
			"width":"13",
			"height":"23",
			"points": [[0.78522875816993, 19.730326797386, 3.4111111111111, 3.4111111111111], [3.3750326797386, 19.730326797386, 3.4111111111111, 3.4111111111111], [5.8320261437909, 19.796732026144, 3.4111111111111, 3.4111111111111], [8.4218300653595, 19.730326797386, 3.4111111111111, 3.4111111111111]]
		}, {
			"name":"Capacitor",
			"description":"CapacitorStandard 0603 ceramic capacitor, and 0.1 leaded capacitor.",
			"image":"core\/breadboard\/sparkfun-passives_0402-cap_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_0402-cap_breadboard.svg",
			"width":"278.75",
			"height":"400",
			"points": [[122.41, 333.05, 33.93, 33.9], [122.41, 33.05, 33.93, 33.9]]
		}, {
			"name":"ADXL327-Small, Low Power,  # -Axis + \/-2G Accelerometer",
			"description":"",
			"image":"core\/breadboard\/ADXL327.svg",
			"icon":"core\/breadboard\/ADXL327.svg",
			"width":"57.318",
			"height":"29.786",
			"points": [[0.742, 22.943, 5.5, 5.5], [7.943, 22.945, 5.5, 5.5], [15.14, 22.945, 5.5, 5.5], [22.243, 22.943, 5.5, 5.5], [29.445, 22.945, 5.5, 5.5], [36.643, 22.945, 5.5, 5.5], [43.827, 22.941, 5.5, 5.5], [51.025, 22.941, 5.5, 5.5], [51.023, 1.341, 5.5, 5.5], [43.827, 1.339, 5.5, 5.5], [36.641, 1.345, 5.5, 5.5], [29.445, 1.343, 5.5, 5.5], [22.243, 1.341, 5.5, 5.5], [15.139, 1.345, 5.5, 5.5], [7.943, 1.343, 5.5, 5.5], [0.742, 1.341, 5.5, 5.5]]
		}, {
			"name":"TRIMPOT",
			"description":"Various small potentiometers for set-and-forget applications",
			"image":"core\/breadboard\/sparkfun-electromechanical_3386u_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_3386u_breadboard.svg",
			"width":"27.59",
			"height":"28.311",
			"points": [[3.543, 25.013, 6.104, 6.104], [10.743, 25.013, 6.104, 6.104], [17.943, 25.013, 6.104, 6.104]]
		}, {
			"name":"Voltage Regulator",
			"description":"Voltage RegulatorStandard 7805 5V regulator.IGO(Input Ground Output).Spark Fun Electronics SKU: COM-00107",
			"image":"core\/breadboard\/voltage_regulator_vreg.svg",
			"icon":"core\/breadboard\/voltage_regulator_vreg.svg",
			"width":"36.998",
			"height":"62.317",
			"points": [[6.501, 59, 5, 3], [16.499, 59, 5, 3], [26.497, 59, 5, 3]]
		}, {
			"name":"LIS302DL",
			"description":"3-axis I2C\/SPI 2\/8g accelerometer",
			"image":"core\/breadboard\/sparkfun-sensors_lga14_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_lga14_breadboard.svg",
			"width":"700",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 333.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Barometric Pressure Sensor-BMP085 Breakout",
			"description":"This is a simple breakout board for the BMP085 high-precision, low-power barometric pressure sensor.The BMP085 offers a measuring range of 300 to 1100 hPa with an absolute accuracy of down to 0.03 hPa.It 's based on piezo-resistive technology for EMC robustness, high accuracy and linearity as well as long term stability. This sensor supports a voltage supply between 1.8 and 3.6VDC. It is designed to be connected directly to a micro-controller via the I²C bus\tThis breadboard-friendly board breaks out all pins of the BMP085 to a 6-pin 0.1' pitch header.The analog and digital supplies(VDDD and VDDA)of the BMP085 are tied together and broken out to a single pin.We ' ve also put two 4.7k pull-up resistors on the I2C lines.  Features:    Digital two wire(I2C)interface   Wide barometric pressure range   Flexible supply voltage range   Ultra-low power consumption   Low noise measurement   Fully calibrated   Temperature measurement included   Ultra-flat, small footprint Dimensions:    0.65 x 0.65' (16.5 x 16.5 mm)",
			"image":"core\/breadboard\/BMP085 Breakout-v13_breadboard.svg",
			"icon":"core\/breadboard\/BMP085 Breakout-v13_breadboard.svg",
			"width":"43.2",
			"height":"43.2",
			"points": [[0.548, 0.548, 6.104, 6.104], [7.748, 0.548, 6.104, 6.104], [14.948, 0.548, 6.104, 6.104], [22.148, 0.548, 6.104, 6.104], [29.348, 0.548, 6.104, 6.104], [36.548, 0.548, 6.104, 6.104]]
		}, {
			"name":"OBDII",
			"description":"OBDII connector footprint",
			"image":"core\/breadboard\/sparkfun-connectors_obdii_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_obdii_breadboard.svg",
			"width":"1853.54",
			"height":"1400",
			"points": [[559.805, 1333.05, 33.93, 33.9], [559.805, 33.05, 33.93, 33.9], [659.805, 1333.05, 33.93, 33.9], [659.805, 33.05, 33.93, 33.9], [759.805, 1333.05, 33.93, 33.9], [759.805, 33.05, 33.93, 33.9], [859.805, 1333.05, 33.93, 33.9], [859.805, 33.05, 33.93, 33.9], [959.805, 1333.05, 33.93, 33.9], [959.805, 33.05, 33.93, 33.9], [1059.8, 1333.05, 33.93, 33.9], [1059.8, 33.05, 33.93, 33.9], [1159.8, 1333.05, 33.93, 33.9], [1159.8, 33.05, 33.93, 33.9], [1259.8, 1333.05, 33.93, 33.9], [1259.8, 33.05, 33.93, 33.9]]
		}, {
			"name":"GainSpan WiFi Breakout",
			"description":"This is a breakout for the GS1011 ultra low-power wireless chip from GainSpan.The GS1011 device is a highly integrated ultra low power wireless single chip which contains an 802.11b radio, media access controller(MAC)and baseband processor, on-chip flash memory and SRAM, and an applications processor all on a single package.Along with its embedded software stack it offers a highly scalable, reliable, manageable and secure wireless link to meet the growing demand of wireless sensor networks utilizing the broadly accepted IEEE 802.11b, g, n standards infrastructure. Features:    Supports IEEE 802.11   Seamlessly integrates with existing 802.11b\/g infrastructure and utilizes the 802.11 security, manageability, ease-of-use, and quality of service   802.11i\/WPA2 Authentication, AES Hardware encryption   Optimized for battery powered application with very low power consumption for multiple years of battery life   Range 200-300M + Outdoor(Typical Estimate)   Two 32-bit ARM7 CPU @ 44MHz,1 for applications(APP): 1 dedicated to radio(WLAN)   2 UART, I2C, 2 SPI, 2 ADC, 1 PWM, and 32 GPIO   Operates at 3.3V Documents:    Schematic   Eagle Files   Datasheet(GS1011)   Command Set",
			"image":"core\/breadboard\/gs1011_breakout-v11_breadboard.svg",
			"icon":"core\/breadboard\/gs1011_breakout-v11_breadboard.svg",
			"width":"190.476",
			"height":"115.2",
			"points": [[169.424, 108.548, 6.104, 6.104], [162.224, 108.548, 6.104, 6.104], [155.024, 108.548, 6.104, 6.104], [147.824, 108.548, 6.104, 6.104], [183.824, 43.748, 6.104, 6.104], [183.824, 50.948, 6.104, 6.104], [183.824, 58.148, 6.104, 6.104], [183.824, 65.348, 6.104, 6.104], [140.624, 108.548, 6.104, 6.104], [133.424, 108.548, 6.104, 6.104], [126.224, 108.548, 6.104, 6.104], [119.024, 108.548, 6.104, 6.104], [111.824, 108.548, 6.104, 6.104], [104.624, 108.548, 6.104, 6.104], [97.424, 108.548, 6.104, 6.104], [90.224, 108.548, 6.104, 6.104], [83.024, 108.548, 6.104, 6.104], [75.824, 108.548, 6.104, 6.104], [68.624, 108.548, 6.104, 6.104], [61.424, 108.548, 6.104, 6.104], [54.224, 108.548, 6.104, 6.104], [47.024, 108.548, 6.104, 6.104], [75.824, 0.548, 6.104, 6.104], [83.024, 0.548, 6.104, 6.104], [90.224, 0.548, 6.104, 6.104], [97.424, 0.548, 6.104, 6.104], [104.624, 0.548, 6.104, 6.104], [111.824, 0.548, 6.104, 6.104], [119.024, 0.548, 6.104, 6.104], [126.224, 0.548, 6.104, 6.104], [133.424, 0.548, 6.104, 6.104], [140.624, 0.548, 6.104, 6.104], [147.824, 0.548, 6.104, 6.104], [47.024, 0.548, 6.104, 6.104], [54.224, 0.548, 6.104, 6.104], [61.424, 0.548, 6.104, 6.104], [68.624, 0.548, 6.104, 6.104], [169.424, 0.548, 6.104, 6.104], [162.224, 0.548, 6.104, 6.104], [155.024, 0.548, 6.104, 6.104]]
		}, {
			"name":"INVERTER",
			"description":"Single inverter, SOT23-5",
			"image":"core\/breadboard\/sparkfun-digitalic_sc70_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_sc70_breadboard.svg",
			"width":"300",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Slide Potentiometer",
			"description":"A sliding adjustable resistor(potentiometer).",
			"image":"core\/breadboard\/pot-slider.svg",
			"icon":"core\/breadboard\/pot-slider.svg",
			"width":"246.614",
			"height":"39.858",
			"points": [[36.034, 35.676, 4.141, 5.15], [194.429, 35.676, 4.145, 5.15], [208.83, 35.676, 4.145, 5.15]]
		}, {
			"name":"G3VM-61E1",
			"description":"Omron NO solid state relay",
			"image":"core\/breadboard\/sparkfun-electromechanical_g3vm-61e1_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_g3vm-61e1_breadboard.svg",
			"width":"500",
			"height":"800",
			"points": [[133.035, 733.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 733.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 733.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Header 2",
			"description":"Header 2Standard 2-pin 0.1 header.Use with straight break away headers(SKU: PRT-00116), right angle break away headers(PRT-00553), swiss pins(PRT-00743), machine pins(PRT-00117), and female headers(PRT-00115).Molex polarized connector foot print use with SKU: PRT-08233 with associated crimp pins and housings.",
			"image":"core\/breadboard\/sparkfun-connectors_screwterminal-3.5mm-2_lock_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-connectors_screwterminal-3.5mm-2_lock_breadboard.svg",
			"width":"481.056",
			"height":"600",
			"points": [[223.563, 533.05, 33.93, 33.9], [223.563, 33.05, 33.93, 33.9]]
		}, {
			"name":"JUMPER-3",
			"description":"",
			"image":"core\/breadboard\/sparkfun-passives_sj_3_paste1_2_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_sj_3_paste1_2_breadboard.svg",
			"width":"263",
			"height":"400",
			"points": [[64.535, 333.05, 33.93, 33.9], [164.535, 333.05, 33.93, 33.9], [164.535, 33.05, 33.93, 33.9]]
		}, {
			"name":"PIC 16F877A",
			"description":"Microchip PIC 16F877A microcontroller",
			"image":"core\/breadboard\/PIC_16F877A_breadboard.svg",
			"icon":"core\/breadboard\/PIC_16F877A_breadboard.svg",
			"width":"2000",
			"height":"622.222",
			"points": [[34, 585.6, 32, 45.4], [34, -1, 32, 45.4], [1934, 585.6, 32, 45.4], [134, -1, 32, 45.4], [234, -1, 32, 45.4], [434, -1, 32, 45.4], [534, -1, 32, 45.4], [634, -1, 32, 45.4], [734, -1, 32, 45.4], [834, -1, 32, 45.4], [934, -1, 32, 45.4], [1034, -1, 32, 45.4], [1134, -1, 32, 45.4], [1234, -1, 32, 45.4], [1334, -1, 32, 45.4], [1434, -1, 32, 45.4], [1534, -1, 32, 45.4], [1634, -1, 32, 45.4], [1734, -1, 32, 45.4], [134, 585.6, 32, 45.4], [234, 585.6, 32, 45.4], [334, 585.6, 32, 45.4], [434, 585.6, 32, 45.4], [534, 585.6, 32, 45.4], [634, 585.6, 32, 45.4], [734, 585.6, 32, 45.4], [834, 585.6, 32, 45.4], [934, 585.6, 32, 45.4], [1034, 585.6, 32, 45.4], [1134, 585.6, 32, 45.4], [1234, 585.6, 32, 45.4], [1334, 585.6, 32, 45.4], [1434, 585.6, 32, 45.4], [1534, 585.6, 32, 45.4], [1634, 585.6, 32, 45.4], [1734, 585.6, 32, 45.4], [1834, 585.6, 32, 45.4], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084], [1930.4560139707, -4.8543778285493, 33.434184675835, 49.993101033089], [1837.9292730845, -1, 32, 45.4], [331.24186858764, 2.9292730844794, 31.617035621884, 39.533615245084]]
		}, {
			"name":"Ceramic Capacitor",
			"description":"100 nF multilayer Ceramic Capacitor",
			"image":"core\/breadboard\/ceramic_capacitor_blue_leg.svg",
			"icon":"core\/breadboard\/ceramic_capacitor_blue_leg.svg",
			"width":"18.836",
			"height":"24.827",
			"points": [[1.919, 13.826, 5, 3], [11.919, 13.826, 5, 3]]
		}, {
			"name":"OP482-Low Power, High Speed JFET Quad Operational Amplifier",
			"description":"",
			"image":"core\/breadboard\/OP482.svg",
			"icon":"core\/breadboard\/OP482.svg",
			"width":"50.764",
			"height":"23.76",
			"points": [[51.92, 19.636, 4.16, 5.124], [51.92, -1, 4.16, 5.125], [8.72, 19.636, 4.16, 5.124], [8.72, -1, 4.16, 5.125], [15.92, 19.636, 4.16, 5.124], [15.92, -1, 4.16, 5.125], [23.12, 19.636, 4.156, 5.124], [23.12, -1, 4.156, 5.125], [30.32, 19.636, 4.16, 5.124], [30.32, -1, 4.16, 5.125], [37.52, 19.636, 4.16, 5.124], [37.52, -1, 4.16, 5.125], [44.72, 19.636, 4.16, 5.124], [44.72, -1, 4.16, 5.125]]
		}, {
			"name":"7-SEGMENT-4DIGIT",
			"description":"",
			"image":"core\/breadboard\/sparkfun-displays_7-segment-4digit_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-displays_7-segment-4digit_breadboard.svg",
			"width":"114.48",
			"height":"36.863",
			"points": [[29.07, 29.862, 5.94, 5.94], [36.27, 29.862, 5.94, 5.94], [43.47, 29.862, 5.94, 5.94], [50.67, 29.862, 5.94, 5.94], [57.87, 29.862, 5.94, 5.94], [65.07, 29.862, 5.94, 5.94], [72.27, 29.862, 5.94, 5.94], [79.47, 29.862, 5.94, 5.94], [79.47, 1.062, 5.94, 5.94], [65.07, 1.062, 5.94, 5.94], [50.67, 1.062, 5.94, 5.94], [43.47, 1.062, 5.94, 5.94], [36.27, 1.062, 5.94, 5.94], [29.07, 1.062, 5.94, 5.94]]
		}, {
			"name":"chipKIT Motor Shield",
			"description":"The chipKIT \ u2122 Motor Shield is an expansion board for use with the chipKIT Uno32 and chipKIT uC32.It provides additional circuitry and connectors for the Uno32 and uC32 to drive various motors types. \ u00a0 The chipKIT Motor Shield is designed to drive DC motors, servo motors, and stepper motors.It also provides additional I\/O via an I2C I\/O extender.",
			"image":"core\/breadboard\/chipkit_MotorShield_breadboard.svg",
			"icon":"core\/breadboard\/chipkit_MotorShield_breadboard.svg",
			"width":"194.457",
			"height":"151.256",
			"points": [[114.713, 11.658, 5.6, 5.6], [93.113, 11.658, 5.6, 5.6], [107.514, 11.658, 5.6, 5.6], [100.313, 11.658, 5.6, 5.6], [72.413, 11.658, 5.6, 5.6], [85.914, 11.658, 5.6, 5.6], [65.446, 11.658, 5.6, 5.6], [79.613, 11.658, 5.6, 5.6], [114.713, 4.457, 5.6, 5.6], [93.113, 4.457, 5.6, 5.6], [107.514, 4.457, 5.6, 5.6], [100.313, 4.457, 5.6, 5.6], [72.413, 4.457, 5.6, 5.6], [85.914, 4.457, 5.6, 5.6], [65.446, 4.457, 5.6, 5.6], [79.613, 4.457, 5.6, 5.6], [176.634, 11.658, 5.6, 5.6], [155.033, 11.658, 5.6, 5.6], [169.435, 11.658, 5.6, 5.6], [162.233, 11.658, 5.6, 5.6], [134.333, 11.658, 5.6, 5.6], [147.833, 11.658, 5.6, 5.6], [127.366, 11.658, 5.6, 5.6], [141.532, 11.658, 5.6, 5.6], [176.634, 4.457, 5.6, 5.6], [155.033, 4.457, 5.6, 5.6], [169.435, 4.457, 5.6, 5.6], [162.233, 4.457, 5.6, 5.6], [134.333, 4.457, 5.6, 5.6], [147.833, 4.457, 5.6, 5.6], [127.366, 4.457, 5.6, 5.6], [141.532, 4.457, 5.6, 5.6], [126.8, 141.256, 5.6, 5.6], [119.6, 141.256, 5.6, 5.6], [112.399, 141.256, 5.6, 5.6], [105.2, 141.256, 5.6, 5.6], [97.999, 141.256, 5.6, 5.6], [90.8, 141.256, 5.6, 5.6], [177.2, 134.057, 5.6, 5.6], [170.001, 134.057, 5.6, 5.6], [162.8, 134.057, 5.6, 5.6], [155.601, 134.057, 5.6, 5.6], [148.399, 134.057, 5.602, 5.6], [141.2, 134.057, 5.6, 5.6], [177.2, 141.256, 5.6, 5.6], [170.001, 141.256, 5.6, 5.6], [162.8, 141.256, 5.6, 5.6], [155.601, 141.256, 5.6, 5.6], [148.399, 141.256, 5.602, 5.6], [141.2, 141.256, 5.6, 5.6]]
		}, {
			"name":"Generic female header-metal rounded-18 pins",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic-female-header-rounded_bread_18.svg",
			"icon":"obsolete\/breadboard\/generic-female-header-rounded_bread_18.svg",
			"width":"129.222",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783], [8.377, 1.197, 4.783, 4.783], [15.556, 1.197, 4.783, 4.783], [22.735, 1.197, 4.783, 4.783], [29.914, 1.197, 4.783, 4.783], [37.093, 1.197, 4.783, 4.783], [44.272, 1.197, 4.783, 4.783], [51.451, 1.197, 4.783, 4.783], [58.63, 1.197, 4.783, 4.783], [65.809, 1.197, 4.783, 4.783], [72.988, 1.197, 4.783, 4.783], [80.167, 1.197, 4.783, 4.783], [87.346, 1.197, 4.783, 4.783], [94.525, 1.197, 4.783, 4.783], [101.704, 1.197, 4.783, 4.783], [108.883, 1.197, 4.783, 4.783], [116.062, 1.197, 4.783, 4.783], [123.241, 1.197, 4.783, 4.783]]
		}, {
			"name":"Breakout Board for Electret Microphone",
			"description":"Ready to add audio to your next project ? This small breakout board couples a small electret microphone with a 100x opamp to amplify the sounds of voice, door knocks, etc loud enough to be picked up by a microcontroller ' s Analog to Digital converter.Unit comes fully assembled as shown.Works from 2.7V up to 5.5V.  Documents:    Schematic   Example PIC ADC Code   OPA344 Datasheet   Example Audio LED control project by Adam Greig",
			"image":"core\/breadboard\/Amplified-Mic-Electret-v14_breadboard.svg",
			"icon":"core\/breadboard\/Amplified-Mic-Electret-v14_breadboard.svg",
			"width":"46.8",
			"height":"28.8",
			"points": [[40.148, 18.548, 6.104, 6.104], [40.148, 11.348, 6.104, 6.104], [40.148, 4.148, 6.104, 6.104]]
		}, {
			"name":"white smd LED",
			"description":"A generic white LED(~1.8V)",
			"image":"obsolete\/breadboard\/LED-5mm-white.svg",
			"icon":"obsolete\/breadboard\/LED-5mm-white.svg",
			"width":"21.467",
			"height":"74.754",
			"points": [[3.793, 64.307, 4.989, 11.442], [13.793, 64.307, 4.992, 11.442]]
		}, {
			"name":"Ceramic Capacitor",
			"description":"100 nF multilayer Ceramic Capacitor",
			"image":"core\/breadboard\/ceramic_capacitor_blue_leg.svg",
			"icon":"core\/breadboard\/ceramic_capacitor_blue_leg.svg",
			"width":"18.836",
			"height":"24.827",
			"points": [[1.919, 13.826, 5, 3], [11.919, 13.826, 5, 3]]
		}, {
			"name":"MICROCONTROLLER",
			"description":"MICROCONTROLLER8 Kbytes FLASH1 kbytes SRAM512 bytes EEPROMUSART6-channel 10 bit ADC2-channel 8 bit ADC",
			"image":"core\/breadboard\/sparkfun-digitalic_tqfp32-08_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-digitalic_tqfp32-08_breadboard.svg",
			"width":"1600",
			"height":"600",
			"points": [[33.035, 533.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 533.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 533.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 533.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 533.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 533.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9], [633.035, 533.05, 33.93, 33.9], [633.035, 33.05, 33.93, 33.9], [733.035, 533.05, 33.93, 33.9], [733.035, 33.05, 33.93, 33.9], [833.035, 533.05, 33.93, 33.9], [833.035, 33.05, 33.93, 33.9], [933.035, 533.05, 33.93, 33.9], [933.035, 33.05, 33.93, 33.9], [1033.04, 533.05, 33.93, 33.9], [1033.04, 33.05, 33.93, 33.9], [1133.04, 533.05, 33.93, 33.9], [1133.04, 33.05, 33.93, 33.9], [1233.04, 533.05, 33.93, 33.9], [1233.04, 33.05, 33.93, 33.9], [1333.04, 533.05, 33.93, 33.9], [1333.04, 33.05, 33.93, 33.9], [1433.04, 533.05, 33.93, 33.9], [1433.04, 33.05, 33.93, 33.9], [1533.04, 533.05, 33.93, 33.9], [1533.04, 33.05, 33.93, 33.9]]
		}, {
			"name":"LM2931_FIXED",
			"description":"LDO regulator with reverse battery protection-very durable!",
			"image":"core\/breadboard\/sparkfun-poweric_dpak_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-poweric_dpak_breadboard.svg",
			"width":"333.016",
			"height":"600",
			"points": [[99.543, 533.05, 33.93, 33.9], [199.543, 533.05, 33.93, 33.9], [199.543, 33.05, 33.93, 33.9]]
		}, {
			"name":"LMV358",
			"description":"Jellybean rail-to-rail output op-amp",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"MSGEQ7",
			"description":"7-band graphic equalizer",
			"image":"core\/breadboard\/SO08_breadboard.svg",
			"icon":"core\/breadboard\/SO08_breadboard.svg",
			"width":"28.8",
			"height":"43.2",
			"points": [[1.45052, 37.4516, 4.29896, 4.2968], [1.45052, 1.4516, 4.29896, 4.2968], [8.65052, 37.4516, 4.29896, 4.2968], [8.65052, 1.4516, 4.29896, 4.2968], [15.8505, 37.4516, 4.29896, 4.2968], [15.8505, 1.4516, 4.29896, 4.2968], [23.0505, 37.4516, 4.29896, 4.2968], [23.0505, 1.4516, 4.29896, 4.2968]]
		}, {
			"name":"MIC",
			"description":"Omni-directional electret microphone.9.7mm standard diameter.",
			"image":"core\/breadboard\/sparkfun-sensors_mic-9.7mm_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_mic-9.7mm_breadboard.svg",
			"width":"581.889",
			"height":"600",
			"points": [[273.979, 533.05, 33.93, 33.9], [273.979, 33.05, 33.93, 33.9]]
		}, {
			"name":"GP-2106",
			"description":"GP-2106 GPS SiRF IV",
			"image":"core\/breadboard\/sparkfun-rf_gp-2106_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-rf_gp-2106_breadboard.svg",
			"width":"400",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"Generic female header-metal rounded",
			"description":"Generic female header-metal rounded",
			"image":"obsolete\/breadboard\/generic_female_header_metal_rounded.svg",
			"icon":"obsolete\/breadboard\/generic_female_header_metal_rounded.svg",
			"width":"7.179",
			"height":"7.178",
			"points": [[1.198, 1.197, 4.783, 4.783]]
		}, {
			"name":"DCM01 Reflective Blood Sensor",
			"description":"DCM01 Reflective Blood SensorUNPROVENSensor head for Pulse Oximeter.Contains IR and visible red LEDs, and PIN photodiode.http: \/\/www.apmkr.com\/bio-device\/DCM01_datasheet.pdf",
			"image":"core\/breadboard\/sparkfun-sensors_dcm01_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_dcm01_breadboard.svg",
			"width":"395.929",
			"height":"400",
			"points": [[131, 333.05, 33.93, 33.9], [131, 33.05, 33.93, 33.9], [231, 333.05, 33.93, 33.9], [231, 33.05, 33.93, 33.9]]
		}, {
			"name":"TI Launchpad MSP430G2",
			"description":"The LaunchPad is an easy-to-use, affordable, and scalable introduction to the world of microcontrollers and the MSP430 family.See: http: \/\/e2e.ti.com\/group\/msp430launchpad\/w\/default .aspx",
			"image":"core\/breadboard\/TI_Launchpad_MSP430G2.1_breadboard.svg",
			"icon":"core\/breadboard\/TI_Launchpad_MSP430G2.1_breadboard.svg",
			"width":"188.912",
			"height":"140.1",
			"points": [[87.708, 132.258, 4.778, 4.73], [94.894, 132.258, 4.776, 4.73], [102.077, 132.258, 4.778, 4.73], [109.262, 132.258, 4.776, 4.73], [116.446, 132.258, 4.777, 4.73], [123.63, 132.258, 4.779, 4.73], [130.815, 132.258, 4.777, 4.73], [138.001, 132.258, 4.776, 4.73], [145.184, 132.258, 4.776, 4.73], [152.37, 132.258, 4.773, 4.73], [87.708, 5.38, 4.778, 4.729], [94.894, 5.38, 4.776, 4.729], [102.077, 5.38, 4.778, 4.729], [109.262, 5.38, 4.776, 4.729], [116.446, 5.38, 4.777, 4.729], [123.63, 5.38, 4.779, 4.729], [130.815, 5.38, 4.777, 4.729], [138.001, 5.38, 4.776, 4.729], [145.184, 5.38, 4.776, 4.729], [152.37, 5.38, 4.773, 4.729]]
		}, {
			"name":"Inductors",
			"description":"InductorsBasic Inductor\/Choke-0603 and 1206.Footprints are not proven and vary greatly between part numbers.",
			"image":"core\/breadboard\/sparkfun-passives_cooper_up4b_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-passives_cooper_up4b_breadboard.svg",
			"width":"1070.07",
			"height":"1000",
			"points": [[518.069, 933.05, 33.93, 33.9], [518.069, 33.05, 33.93, 33.9]]
		}, {
			"name":"VCNL4000",
			"description":"Fully integrated proximity and ambient light sensor with infrared emitter and I2C interface",
			"image":"core\/breadboard\/sparkfun-sensors_vcnl4000_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-sensors_vcnl4000_breadboard.svg",
			"width":"600",
			"height":"400",
			"points": [[33.035, 333.05, 33.93, 33.9], [33.035, 33.05, 33.93, 33.9], [133.035, 333.05, 33.93, 33.9], [133.035, 33.05, 33.93, 33.9], [233.035, 333.05, 33.93, 33.9], [233.035, 33.05, 33.93, 33.9], [333.035, 333.05, 33.93, 33.9], [333.035, 33.05, 33.93, 33.9], [433.035, 333.05, 33.93, 33.9], [433.035, 33.05, 33.93, 33.9], [533.035, 333.05, 33.93, 33.9], [533.035, 33.05, 33.93, 33.9]]
		}, {
			"name":"3-Axis Accelerometer Breakout-MMA8452Q",
			"description":"http:\/\/www.sparkfun.com\/products\/10955",
			"image":"core\/breadboard\/3_Axis_Accelerometer_Breakout___MMA8452Q_BB.svg",
			"icon":"core\/breadboard\/3_Axis_Accelerometer_Breakout___MMA8452Q_BB.svg",
			"width":"50.4",
			"height":"50.4",
			"points": [[2.348, 4.148, 6.104, 6.104], [2.348, 11.348, 6.104, 6.104], [2.348, 18.548, 6.104, 6.104], [2.348, 25.748, 6.104, 6.104], [2.348, 32.948, 6.104, 6.104], [2.348, 40.148, 6.104, 6.104]]
		}, {
			"name":"Battery Holders",
			"description":"Battery HoldersVarious common sizes: AA, AAA, 20mm coin cell and 12mm coin cell.",
			"image":"core\/breadboard\/sparkfun-electromechanical_battcom_20mm_pth_breadboard.svg",
			"icon":"core\/breadboard\/sparkfun-electromechanical_bat