/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

var MSG = {
    unit_volt: "V",
    unit_ampere: "A",
    unit_kilobyte: "Kb",
    unit_megabyte: "Mb",
    unit_megahertz: "MHz",

    title: "BearLogica",
    appName: "BearLogica",
    developerText: "By ELRON",
    blocks: "Blocks",
    prog: "Program",
    catLogic: "Logic",
    catLoops: "Loops",
    catMath: "Math",
    catText: "Text",
    catLists: "Lists",
    catColour: "Colour",
    catVariables: "Variables",
    catFunctions: "Functions",
    listVariable: "list",
    textVariable: "Text",
    screenshot: "Download Screenshot",
    xmlError: "Could not load your saved file. Perhaps it was created with a different version of BearLogica?",
    badXml: "Error parsing XML:\n%1\n\nSelect 'OK' to abandon your changes or 'Cancel' to further edit the file.",
    languageSpan: "Choose language",
    interfaceColorSpan: "Interface theme",
    codeEditorColorSpan: "Code editor theme",
    themeSpan: "Choose block theme",
    renderSpan: "Choose block renderer",
    fullScreenButton_span: "Full screen",
    undoButton_span: "Undo",
    redoButton_span: "Redo",
    boardButtonSpan: "List boards",
    verifyButton_span: "Verify code",
    serialButtonSpan: "List COM port",
    noPortAvailable: "No COM port is available",
    uploadButton_span: "Upload",
    serialConnectButton_span: "Serial monitor",
    saveCodeButton_span: "Export Code",
    newButton_span: "New project",
    save_span: "Save file?",
    export_span:"Export .ino file?",
    custom_prompt_title: "Enter name",
    custom_prompt_placeholder: "Enter...",
    ok: "OK",
    cancel: "Cancel",
    confirm_title:"Are you sure?",
    alert_title: "Warning",
    reset_confirm_title: "Clear workspace?",
    saveXMLButton_span: "Save to BearLogica file",
    loadXMLfakeButton_span: "Load BearLogica file",
    loadXML_span: "Replace existing blocks?\n'Cancel' will merge.",
    loadXML_error_span: "Error parsing XML:\n",
    resetButton_span: "Reset BearLogica",
    resetQuestion_span: "Reset BearLogica and",
    helpButton_span: "About",
    helpModalSpan_title: "About",
    helpModalSpan_text:
        '<div style="text-align:center;">' +
        '<img src="./blocklyduino/media/logo_help.png" width="120" height="120" alt="BearLogica logo" style="margin: 10px;" />' +
        '<p><strong>{APP_NAME}</strong> is a visual programming environment for <a href="https://elron.tech/russian-arduino-compatible-board/" target="_blank">Elbear</a> boards.</p>' +
        '<p>It allows you to build programs from blocks and convert them into code compatible with <strong>Arduino IDE</strong>.</p>' +
        '<p>Developed based on a fork of the <a href="https://github.com/BlocklyDuino/BlocklyDuino-v2" target="_blank">BlocklyDuino-v2</a> repository by Sébastien CANET,Fred Lin and <a href="https://github.com/BlocklyDuino/BlocklyDuino2Electron" target="_blank">BlocklyDuino2Electron</a> repository by Sébastien CANET.</p>' +
        '<p>Application is built on top of <a href="https://developers.google.com/blockly/" target="_blank">Blockly</a> from Google.</p>' +
        '<hr>' +
        '<p>Repository: <a href="{REPO_URL}" target="_blank">Gitflic</a></p>' +
        '<p>Version: <strong>{VERSION}</strong></p>' +
        '</div>',
    //menu tools
    toolsButton_span: "tools",
    wiringButton_span: "wiring",
    factoryButton_span: "block factory",
    htmlButton_span: "HTML factory",
    colorConversionButton_span: "colors encoding",
    dataConversionButton_span: "data encoding",
    //menu IoT
    iotConnectButton_span: "servers",
    launchWebServer_span: "local server",
    papyrusConnect_span: "Papyrus connect",
    registerToOrchestrator_span: "Arrowhead connect",
    blynkConnect_span: "Blynk connect",
    //ace editor
    editorReadOnlyToggle_span: "Code editor",
    copyCodeButton_span: "Copy code to clipboard",
    //lateral panel
    accessibilitySpan: "enable Accessibility Mode",
    defaultCursorSpan: "Default Cursor",
    basicCursorSpan: "Basic Cursor",
    lineCursorSpan: "Line Cursor",
    keyMappingSpan: "open key mappings",
    themeClassicSpan: "Classic",
    themeModernSpan: "Modern",
    themeDeuteranopiaSpan: "Deuteranopia/Protanopia",
    themeTritanopiaSpan: "Tritanopia",
    themeZelosSpan: "Zelos",
    themeHighContrastSpan: "High Contrast",
    themeDarkSpan: "Dark",
    themeBwSpan: "Black & White",
    compilationInProgress: "Board",
    keyMappingModalSpan: "Set key mappings",
    detailedCompilation_span: "Detailed compilation verbose",
    CLI_title_span: "compiler management",
    installBoard_title_span: "board install to CLI",
    searchlLib_title_span: "search for a library",
    installLib_title_span: "library install to CLI",
    actionName0: "previous",
    actionName1: "next",
    actionName2: "in",
    actionName3: "out",
    actionName4: "insert",
    actionName5: "mark",
    actionName6: "disconnect",
    actionName7: "toolbox",
    actionName8: "exit",
    actionName9: "move workspace cursor up",
    actionName10: "move workspace cursor down",
    actionName11: "move workspace cursor left",
    actionName12: "move workspace cursor right",
    actionName13: "toggle keyboard navigation",
    setup_sideButton_span: "Setup",
    config_UI_title_span: "Interface",
    displaySpan: "display choice",
    displayChoiceButtons: "buttons only",
    displayChoiceBandT: "buttons + text",
    displayChoiceText: "text only",
    fontSpan: "font choice",
    fontSizeSpan: "rendering",
    optionFontSizeBlocks: "Blocks Font Size",
    optionFontSizePage: "Page Font Size",
    optionFontSpacingPage: "Page Font Spacing",
    //CLI_functions.js
    CLI_githubLinkButton_span: "documentation",
    coreUpdateButton_msg: "Updating...\n<i class='fa fa-spinner fa-pulse fa-1_5x fa-fw'></i>",
    cleanCLIcacheButton_msg: "Cleaning...\n<i class='fa fa-spinner fa-pulse fa-1_5x fa-fw'></i>",
    cleanCLIcacheButton_error_msg: "Error deleting folder .\\tmp",
    cleanCLIcacheButton_success_msg: "Cleaned!",
    listBoardsButton_msg: "Searching for board...\n<i class='fa fa-spinner fa-pulse fa-1_5x fa-fw'></i>",
    installBoardsButton_msg: "Installing board support, wait...\n<i class='fa fa-spinner fa-pulse fa-1_5x fa-fw'></i>",
    searchlLibButton_msg: "Searching for library...\n<i class='fa fa-spinner fa-pulse fa-1_5x fa-fw'></i>",
    installLibButton_msg: "Installing library...\n<i class='fa fa-spinner fa-pulse fa-1_5x fa-fw'></i>",
    coreUpdateButton_span: "update core and libraries",
    cleanCLIcacheButton_span: "cleaning cache",
    listBoardsButton_span: "detection and list boards",
    installBoardsInput_span: "name of board to support",
    installBoardsButton_span: "install this board type",
    searchlLibInput_span: "name of library to search",
    searchlLibButton_span: "search this library",
    installLibInput_span: "name of library to install",
    installLibButton_span: "install this library",
    //categories panel
    categories_title_span: "Categories choice",
    //arrowhead panel
    iot_title_span: "IoT control",
    //modals
    boardListModalHeader_span: "Boards list",
    boardListModalButton_span: "Details",
    boardModal_connect: "Connector",
    boardModal_voltage: "Operating voltage",
    boardModal_voltage_normal: "Operating voltage (recommended)",
    boardModal_voltage_maxi: "Operating voltage (limits)",
    boardModal_cpu: "Microcontroler µC",
    boardModal_speed: "Clock speed",
    boardModal_inout: "Number of logical I/Os",
    boardModal_in_analog: "Number of analog I/Os",
    boardModal_out_analog: "Number of PWM ouput",
    boardModal_flash: "Flash memory",
    boardModal_sram: "SRAM memory",
    boardModal_eeprom: "EEPROM",
    portListModalHeader_span: "COM port list",
    //IDE_functions.js
    IDE_connect: 'Connect to port ',
    IDE_select_port: 'Select a port !',
    IDE_select_board: 'Select a board !',
    IDE_verif_progress: '\nVerification: in progress...\n<i class="fa fa-spinner fa-pulse fa-1_5x fa-fw"></i>',
    IDE_verif_ok: '\nVerification: OK',
    IDE_upload1: 'Board ',
    IDE_upload2: ' on port ',
    IDE_upload3: '\nUpload: in progress...\n<i class="fa fa-spinner fa-pulse fa-1_5x fa-fw"></i>',
    IDE_upload_ok: '\nUpload: OK',
    serial_btn_start: "<span class='fa fa-play'></span> Start",
    serial_info_stop: 'stop<br>',
    serial_btn_stop: "<span class='fa fa-pause'></span> Stop",
    serial_info_start: 'communication starting<br>',
    serial_CSV: 'Export data to CSV',
    inputTextSerial: 'Text',
    btn_serialSend_span: 'Send',
    btn_serialConnect_span: 'Start',
    btn_serialPeekClear_span: 'Clean',
    btn_serialPeekCSV_span: 'Export',
    btn_serialChart_span: 'Graph',
    btn_serialChartPause_span: 'Start'
};