/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @fileoverview Utility functions for handling typed variables.
 * Freely adapted from https://github.com/google/blockly/commit/4e2f8e6e02b0473a86330eb7414794e6bfea430e
 * @author scanet@libreduc.cc (Sébastien CANET)
 */

// var intCompatibility = ['int', 'Number'];
// var floatCompatibility = ['int', 'float', 'Number'];
var numberCompatibility = ['Number'];
var stringCompatibility = ['String'];
var booleanCompatibility = ['Boolean'];

var createVarBtnNumberCallBack = function (button) {
    Blockly.Variables.createVariableButtonHandler(button.getTargetWorkspace(), null, 'Number');
};
// var createVarBtnFloatCallBack = function (button) {
//     Blockly.Variables.createVariableButtonHandler(button.getTargetWorkspace(), null, 'float');
// };
var createVarBtnStringCallBack = function (button) {
    Blockly.Variables.createVariableButtonHandler(button.getTargetWorkspace(), null, 'String');
};
var createVarBtnBooleanCallBack = function (button) {
    Blockly.Variables.createVariableButtonHandler(button.getTargetWorkspace(), null, 'bool');
};

var numVariablesCallBack = function (currWorkspace) {
    var allNumVars = currWorkspace.getVariablesOfType('Number');
    var xmlList = [];
    var createintBtnXml = Blockly.Xml.textToDom('<xml><button text="' + Blockly.Msg.VAR_CREATE_NUMBER + '" callbackKey="createVarBtnNumber">' +
            '</button></xml>').firstChild;
    xmlList.push(createintBtnXml);
    if (allNumVars.length > 0) {
        var firstVariable = allNumVars[allNumVars.length - 1];
        if (Blockly.Blocks['vars_set_number_init']) {
            var initBlockText =
                '<xml>' +
                '<block type="vars_set_number_init" gap="12">' +
                '<field name="VAR_SET_NUMBER" variabletype="Number">' + firstVariable.name + '</field>' +
                '</block>' +
                '</xml>';
            var initBlock = Blockly.Xml.textToDom(initBlockText).firstChild;
            xmlList.push(initBlock);
        }
        if (Blockly.Blocks['vars_set_number']) {
            var gap = 24;
            var blockText =
                    '<xml>' +
                    '<block type="vars_set_number" gap="' + gap + '">' +
                    '<field name="VAR_SET_NUMBER" variabletype="Number">' + firstVariable.name + '</field>' +
                    '</block>' +
                    '</xml>';
            var block = Blockly.Xml.textToDom(blockText).firstChild;
            xmlList.push(block);
        }
        if (Blockly.Blocks['vars_get_number']) {
            allNumVars.sort(Blockly.VariableModel.compareByType);
            for (var i = 0, variable; variable = allNumVars[i]; i++) {
                var blockText =
                        '<xml>' +
                        '<block type="vars_get_number" gap="8">' +
                        '<field name="VAR_GET_NUMBER" variabletype="Number">' + variable.name + '</field>' +
                        '</block>' +
                        '</xml>';
                var block = Blockly.Xml.textToDom(blockText).firstChild;
                xmlList.push(block);
            }
        }
    }
    return xmlList;
};

var textVariablesCallBack = function (currWorkspace) {
    var allStringVars = currWorkspace.getVariablesOfType('String');
    var xmlList = [];
    var createStringBtnXml = Blockly.Xml.textToDom('<xml><button text="' + Blockly.Msg.VAR_CREATE_STRING + '" callbackKey="createVarBtnString">' +
            '</button></xml>').firstChild;
    xmlList.push(createStringBtnXml);
    if (allStringVars.length > 0) {
        var firstVariable = allStringVars[allStringVars.length - 1];
        if (Blockly.Blocks['vars_set_string_init']) {
            var initBlockText =
                '<xml>' +
                '<block type="vars_set_string_init" gap="12">' +
                '<field name="VAR_SET_STRING" variabletype="String">' + firstVariable.name + '</field>' +
                '</block>' +
                '</xml>';
            var initBlock = Blockly.Xml.textToDom(initBlockText).firstChild;
            xmlList.push(initBlock);
        }
        if (Blockly.Blocks['vars_set_string']) {
            var gap = 24;
            var blockText =
                    '<xml>' +
                    '<block type="vars_set_string" gap="' + gap + '">' +
                    '<field name="VAR_SET_STRING" variabletype="String">' + firstVariable.name + '</field>' +
                    '</block>' +
                    '</xml>';
            var block = Blockly.Xml.textToDom(blockText).firstChild;
            xmlList.push(block);
        }
        if (Blockly.Blocks['vars_get_string']) {
            allStringVars.sort(Blockly.VariableModel.compareByType);
            for (var i = 0, variable; variable = allStringVars[i]; i++) {
                var blockText =
                        '<xml>' +
                        '<block type="vars_get_string" gap="8">' +
                        '<field name="VAR_GET_STRING" variabletype="String">' + variable.name + '</field>' +
                        '</block>' +
                        '</xml>';
                var block = Blockly.Xml.textToDom(blockText).firstChild;
                xmlList.push(block);
            }
        }
    }
    return xmlList;
};

var booleanVariablesCallBack = function (currWorkspace) {
    var allStringVars = currWorkspace.getVariablesOfType('bool');
    var xmlList = [];
    var createboolBtnXml = Blockly.Xml.textToDom('<xml><button text="' + Blockly.Msg.VAR_CREATE_BOOLEAN + '" callbackKey="createVarBtnBoolean">' +
            '</button></xml>').firstChild;
    xmlList.push(createboolBtnXml);
    if (allStringVars.length > 0) {
        var firstVariable = allStringVars[allStringVars.length - 1];
        if (Blockly.Blocks['vars_set_boolean_init']) {
            var initBlockText =
                '<xml>' +
                '<block type="vars_set_boolean_init" gap="12">' +
                '<field name="VAR_SET_BOOLEAN" variabletype="bool">' + firstVariable.name + '</field>' +
                '</block>' +
                '</xml>';
            var initBlock = Blockly.Xml.textToDom(initBlockText).firstChild;
            xmlList.push(initBlock);
        }
        if (Blockly.Blocks['vars_set_boolean']) {
            var gap = 24;
            var blockText =
                    '<xml>' +
                    '<block type="vars_set_boolean" gap="' + gap + '">' +
                    '<field name="VAR_SET_BOOLEAN" variabletype="bool">' + firstVariable.name + '</field>' +
                    '</block>' +
                    '</xml>';
            var block = Blockly.Xml.textToDom(blockText).firstChild;
            xmlList.push(block);
        }
        if (Blockly.Blocks['vars_get_boolean']) {
            allStringVars.sort(Blockly.VariableModel.compareByType);
            for (var i = 0, variable; variable = allStringVars[i]; i++) {
                var blockText =
                        '<xml>' +
                        '<block type="vars_get_boolean" gap="8">' +
                        '<field name="VAR_GET_BOOLEAN" variabletype="bool">' + variable.name + '</field>' +
                        '</block>' +
                        '</xml>';
                var block = Blockly.Xml.textToDom(blockText).firstChild;
                xmlList.push(block);
            }
        }
    }
    return xmlList;
};