/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

'use strict';

goog.provide('Blockly.Msg.blocks_ru');

goog.require('Blockly.Msg');

//text in blocks
Blockly.Msg.FIELDDROPDOWN = [["высокое", "HIGH"], ["низкое", "LOW"]];
Blockly.Msg.FIELDDROPDOWN_ONOFF = [["включить", "ON"], ["отключить", "OFF"]];
Blockly.Msg.FIELDDROPDOWN_ONOFF2 = [["замкнуть", "HIGH"], ["разомкнуть", "LOW"]];
Blockly.Msg.FIELDDROPDOWN_ONOFF3 = [["замкнуть", "HIGH"], ["разомкнуть", "LOW"]];

//blockly logic
Blockly.Msg.CONTROLS_SWITCH_CASEBREAK_TOOLTIP = "Добавляет новый вариант";
Blockly.Msg.CONTROLS_SWITCH_DEFAULT_TOOLTIP = "Добавляет окончательное, всеобъемлющее условие в блок 'если'";
Blockly.Msg.CONTROLS_SWITCH_HELPURL = "https://en.wikipedia.org/wiki/Switch_statement";
Blockly.Msg.CONTROLS_SWITCH_SWITCH_TOOLTIP = "Добавьте, удалите или измените порядок разделов, чтобы изменить конфигурацию этого блока 'если'";
Blockly.Msg.CONTROLS_SWITCH_VAR_TITLE = "Проверка значения";
Blockly.Msg.CONTROLS_SWITCH_MSG_DEFAULT = "по умолчанию";
Blockly.Msg.CONTROLS_SWITCH_MSG_CASEBREAK = "вариант";
Blockly.Msg.CONTROLS_SWITCH_MSG_SWITCHVAR = "Выбор (переменная)";
Blockly.Msg.CONTROLS_SWITCH_MSG_DO = "выполнить";
Blockly.Msg.CONTROLS_SWITCH_TOOLTIP_1 = "Если значение в поле 'Проверка значения' совпадает со значением 'вариант 1', то выполняются указанные операторы. Если не совпадает - ничего не происходит";
Blockly.Msg.CONTROLS_SWITCH_TOOLTIP_2 = "Если значение в поле 'Проверка значения' совпадает со значением 'вариант 1', то выполняются операторы из этого варианта. Если значения не совпадают, выполняются операторы из поля по 'умолчанию'";
Blockly.Msg.CONTROLS_SWITCH_TOOLTIP_3 = "Если значение в поле 'Проверка значения' совпадает с каким-то из значений в полях 'вариант', выполняются операторы только из этого варианта (первого совпавшего). Если совпадений нет, ничего не происходит";
Blockly.Msg.CONTROLS_SWITCH_TOOLTIP_4 = "Если значение в поле 'Проверка значения' совпадает с каким-то из значений в полях 'вариант', выполняются операторы только из этого варианта (первого совпавшего). Если совпадений нет, выполняются операторы из поля 'по умолчанию'";
Blockly.Msg.CONTROLS_SWITCH_VAR_TOOLTIP = "Перетащите сюда блок 'вариант' или 'по умолчанию' для добавления в блок";
Blockly.Msg.CONTROLS_SWITCH_CASEBREAK_TOOLTIP = "Добавляет еще один 'вариант' с полем для операторов";
Blockly.Msg.CONTROLS_SWITCH_DEFAULT_TOOLTIP = "Добавляет необязательное действие по умолчанию";
//Arduino base category blocks
Blockly.Msg.VAR_SET_TITLE = "установить";
Blockly.Msg.VAR_SET_INITIAL = "начальное значение";
Blockly.Msg.VAR_CREATE_NUMBER = "число";
Blockly.Msg.VAR_CREATE_FLOAT = "число с плавающей точкой";
Blockly.Msg.VAR_CREATE_STRING = "строка";
Blockly.Msg.VAR_CREATE_BOOLEAN = "логическая переменная";
Blockly.Msg.ARDUINO_INOUT_BUILDIN_LED_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/digital-io/digitalwrite/";
Blockly.Msg.ARDUINO_INOUT_BUILDIN_LED_INPUT = "перевести светодиод в состояние";
Blockly.Msg.ARDUINO_INOUT_BUILDIN_LED_TOOLTIP = "Управляет состоянием встроенного на плату светодиода";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_WRITE_INPUT1 = "изменить состояние вывода #";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_WRITE_INPUT2 = "на";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_ANALOG_ALERT = "Для использования аналогового вывода в качестве цифрового на плате ELBEAR необходимо перевести соответствующий выводу DIP-переключатель в положение «ON»";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_WRITE_TOOLTIP = "Переводит указанный цифровой вывод в указанное состояние - 0 или 1";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_WRITE_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/digital-io/digitalwrite/";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_INPUT = "состояние вывода#";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_TOOLTIP = "Возвращает состояние цифрового вывода - 0 или 1";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_WITH_PULLUP_INPUT = "с притяжкой к питанию";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_WITH_PULLUP_TOOLTIP = "Возвращает состояние цифрового вывода - 0 или 1. При инициализации вывод притягивается к питанию";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/digital-io/digitalread/";
Blockly.Msg.ARDUINO_INOUT_ONOFF_HELPURL = "https://docs.arduino.cc/language-reference/#variables";
Blockly.Msg.ARDUINO_INOUT_ONOFF_TOOLTIP = "Возвращает значение \"0\" или \"1\"";
Blockly.Msg.ARDUINO_INOUT_ANALOG_WRITE_INPUT1 = "включить ШИМ на выводе #";
Blockly.Msg.ARDUINO_INOUT_ANALOG_WRITE_INPUT2 = "со значением";
Blockly.Msg.ARDUINO_INOUT_ANALOG_WRITE_TOOLTIP = "Устанавливает значение от 0 до 255 на указанный ШИМ-вывод";
Blockly.Msg.ARDUINO_INOUT_ANALOG_WRITE_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/analog-io/analogWrite/";
Blockly.Msg.ARDUINO_INOUT_ANALOG_READ_INPUT = "измерить напряжение на аналоговом выводе #";
Blockly.Msg.ARDUINO_INOUT_ANALOG_READ_TOOLTIP = "Измеряет напряжение на указанном выводе и возвращает результат от 0 до 1023";
Blockly.Msg.ARDUINO_INOUT_ANALOG_READ_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/analog-io/analogRead/";
Blockly.Msg.ARDUINO_BASE_DELAY_DELAY_TIME = "задержка в мс";
Blockly.Msg.ARDUINO_BASE_DELAY_TOOLTIP = "Останавливает выполнение программы на указанное в миллисекундах время";
Blockly.Msg.ARDUINO_BASE_DELAY_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/time/delay/";
Blockly.Msg.ARDUINO_BASE_DELAY_US_DELAY_TIME = "задержка в мкс";
Blockly.Msg.ARDUINO_BASE_DELAY_US_TOOLTIP = "Останавливает выполнение программы на указанное в микросекундах время";
Blockly.Msg.ARDUINO_BASE_DELAY_US_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/time/delayMicroseconds/";
Blockly.Msg.ARDUINO_BASE_ANGLE = "угол: ";
Blockly.Msg.ARDUINO_BASE_ANGLE_TOOLTIP = "Задает угол в диапазоне 0...180 градусов";
Blockly.Msg.ARDUINO_BASE_ANGLE_HELPURL = "";
Blockly.Msg.ARDUINO_TONE_INPUT1 = "включить звук на выводе #";
Blockly.Msg.ARDUINO_TONE_INPUT2 = "с частотой";
Blockly.Msg.ARDUINO_TONE_INPUT3 = "Гц на";
Blockly.Msg.ARDUINO_TONE_INPUT4 = "мс";
Blockly.Msg.ARDUINO_TONE_TOOLTIP = "Позволяет использовать указанный вывод для воспроизведения звука на указанной частоте с указанной в миллисекундах длительностью. Для непрерывного воспроизведения указать 0 мс";
Blockly.Msg.ARDUINO_TONE_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/advanced-io/tone/";
Blockly.Msg.ARDUINO_NOTONE_INPUT = "выключить звук на выводе #";
Blockly.Msg.ARDUINO_NOTONE_TOOLTIP = "Отключает звук на указанном выводе";
Blockly.Msg.ARDUINO_NOTONE_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/advanced-io/noTone/";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT1 = "побитово вывести значение";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT2 = "на вывод #";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT3 = "по такту на выводе #";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT4 = "";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT5 = "битом вперед";
Blockly.Msg.ARDUINO_SHIFT_OUT_TOOLTIP = "Последовательно передаёт данные по одному биту на вывод данных, синхронизируя передачу тактовым сигналом";
Blockly.Msg.ARDUINO_SHIFT_OUT_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/advanced-io/shiftOut/";
Blockly.Msg.ARDUINO_MSB = "старшим";
Blockly.Msg.ARDUINO_LSB = "младшим";
Blockly.Msg.ARDUINO_SHIFT_IN_1 = "побитово получить значение на вывод #";
Blockly.Msg.ARDUINO_SHIFT_IN_2 = "по такту на выводе #";
Blockly.Msg.ARDUINO_SHIFT_IN_3 = "";
Blockly.Msg.ARDUINO_SHIFT_IN_4 = "битом вперед";
Blockly.Msg.ARDUINO_SHIFT_IN_TOOLTIP = "Читает байт данных по одному биту с вывода данных, синхронизируясь импульсами на выводе тактирования, в заданном порядке битов";
Blockly.Msg.ARDUINO_SHIFT_IN_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/advanced-io/shiftIn/";

//SERIAL
Blockly.Msg.SERIAL_INIT = "установить скорость передачи данных";
Blockly.Msg.SERIAL_INIT_TOOLTIP = "Настраивает скорость для передачи данных по COM порту";
Blockly.Msg.SERIAL_PRINT_NEWLINE = "добавить перенос строки";
Blockly.Msg.SERIAL_PRINT_FORMAT_1 = "отправить число";
Blockly.Msg.SERIAL_PRINT_FORMAT_2 = "в COM порт в";
Blockly.Msg.SERIAL_PRINT_FORMAT_3 = "формате,";
Blockly.Msg.SERIAL_PRINT_FORMAT_TOOLTIP = "Переводит число в указанный формат (десятичный/шестнадцатеричный/двоичный/восьмеричный) и отправляет его в COM порт. При необходимости добавляет перенос на новую строку после отправленных данных";
Blockly.Msg.SERIAL_PRINT_FORDECIMAL = "десятичном";
Blockly.Msg.SERIAL_PRINT_FORHEXA = "шестнадцатеричном";
Blockly.Msg.SERIAL_PRINT_FORBIN = "двоичном";
Blockly.Msg.SERIAL_PRINT_FOROCT = "восьмеричном";
Blockly.Msg.SERIAL_READ = "прочитать данные из COM порта";
Blockly.Msg.SERIAL_READ_TOOLTIP = "Возвращает один байт данных, полученный по COM порту. Если данных нет, возвращает -1";
Blockly.Msg.SERIAL_AVAILABLE = "количество байт, доступных для чтения";
Blockly.Msg.SERIAL_AVAILABLE_TOOLTIP = "Возвращает количество байт, полученных по COM порту и доступных для чтения. Если данных нет, возвращает 0";
Blockly.Msg.SERIAL_FLUSH = "дождаться окончания передачи данных";
Blockly.Msg.SERIAL_FLUSH_TOOLTIP = "Останавливает выполнение программы до завершения передачи данных по COM порту";
Blockly.Msg.SERIAL_READSTRINGUNTIL_CONTENT = "прочитать данные в строку до знака";
Blockly.Msg.SERIAL_READSTRINGUNTIL_TOOLTIP = "Сохраняет полученные данные в строку, пока не встретится указанный знак";
Blockly.Msg.SERIAL_PRINT_CONTENT_1 = "отправить данные";
Blockly.Msg.SERIAL_PRINT_CONTENT_2 = "в COM порт,";
Blockly.Msg.SERIAL_PRINT_CONTENT_TOOLTIP = "Отправляет в COM порт числа или текст и при необходимости добавляет перенос на новую строку после отправленных данных";

// RTC
Blockly.Msg.DS1302_INIT_INPUT1 = "DS1302 подключить модуль - вывод DATA #";
Blockly.Msg.DS1302_INIT_INPUT2 = "вывод CLK #";
Blockly.Msg.DS1302_INIT_INPUT3 = "вывод RESET #";
Blockly.Msg.DS1302_INIT_TOOLTIP = "Инициализирует выбранные выводы для работы с модулем DS1302";
Blockly.Msg.DS1302_HELPURL = "https://docs.arduino.cc/libraries/ds1302/";
Blockly.Msg.DS1302_SET_TIME_INPUT1 = "DS1302 установить время и дату:";
Blockly.Msg.DS1302_HOURS = "часы";
Blockly.Msg.DS1302_MINUTES = "минуты";
Blockly.Msg.DS1302_SECONDS = "секунды";
Blockly.Msg.DS1302_DAY = "день";
Blockly.Msg.DS1302_MONTH = "месяц";
Blockly.Msg.DS1302_YEAR = "год";
Blockly.Msg.DS1302_SET_TIME_TOOLTIP = "Устанавливает указанные время и дату в модуле DS1302. Год указывается двухзначной цифрой (например, ввести \"25\", чтобы установить 2025 год)";
Blockly.Msg.DS1302_SET_INIT_TIME_INPUT1 = "DS1302 установить начальные время и дату:";
Blockly.Msg.DS1302_SET_INIT_TIME_TOOLTIP = "Устанавливает указанные время и дату в модуле DS1302 при старте программы. Год указывается двухзначной цифрой (например, ввести \"25\", чтобы установить 2025 год)";
Blockly.Msg.DS1302_UPDATE_TIME_INPUT = "DS1302 обновить дату и время";
Blockly.Msg.DS1302_UPDATE_TIME_TOOLTIP = "Считывает текущие дату и время из модуля DS1302 во внутреннюю переменную";
Blockly.Msg.DS1302_GET_PARAM_INPUT = "DS1302 получить";
Blockly.Msg.DS1302_GET_PARAM_TOOLTIP = "Возвращает выбранный параметр из внутренней переменной";

// Sensors
Blockly.Msg.DHT_INPUT1 = "DHT подключить модуль типа";
Blockly.Msg.DHT_INPUT2 = "к выводу #";
Blockly.Msg.DHT_INPUT3 = "и измерить";
Blockly.Msg.DHT_TEMP = "температуру, °С";
Blockly.Msg.DHT_HUM = "влажность, %";
Blockly.Msg.DHT_TOOLTIP = "Измеряет температуру или влажность с помощью датчика DHT указанного типа, подключенного к указанному выводу";
Blockly.Msg.DHT_HELPURL = "https://docs.arduino.cc/libraries/dht-sensor-library/";

Blockly.Msg.HCSR04_INPUT1 = "HCSR04 подключить модуль - вывод TRIG #";
Blockly.Msg.HCSR04_INPUT2 = "вывод ECHO #";
Blockly.Msg.HCSR04_INPUT3 = "и измерить расстояние в см";
Blockly.Msg.HCSR04_TOOLTIP = "Измеряет расстояние до ближайшего препятствия в сантиметрах";
Blockly.Msg.HCSR04_HELPURL = "https://docs.arduino.cc/libraries/hcsr04/";

Blockly.Msg.MFRC522_INPUT1 = "RFID-карта - получить код с выводами SS #";
Blockly.Msg.MFRC522_INPUT2 = "и RST #";
Blockly.Msg.MFRC522_TOOLTIP = "Считывает UID с RFID-карты в строку. Если карта не поднесена, возвращает пустую строку";
Blockly.Msg.MFRC522_HELPURL = "https://docs.arduino.cc/libraries/mfrc522/";

Blockly.Msg.DS18B20_INPUT1 = "DS18B20 подключить модуль к выводу DATA #";
Blockly.Msg.DS18B20_INPUT2 = "и измерить температуру °С";
Blockly.Msg.DS18B20_TOOLTIP = "Возвращает температуру в Цельсиях, которую измерил датчик, подключенный к выводу DATA";
Blockly.Msg.DS18B20_HELPURL = "https://docs.arduino.cc/libraries/ds18b20/";

// Motors
Blockly.Msg.SERVO_MOVE_TOOLTIP = "Поворачивает сервопривод, подключенный к указанному выводу, на заданный угол. Допустимые значения: от 0 до 180 градусов";
Blockly.Msg.SERVO_MOVE_HELPURL = "https://docs.arduino.cc/libraries/servo/";
Blockly.Msg.SERVO_MOVE_INPUT = "сервопривод на выводе #";
Blockly.Msg.SERVO_MOVE_DEGREE = "повернуть на угол";
Blockly.Msg.SERVO_MOVE_DEGREE_1 = "градусов";

Blockly.Msg.STEPPER_HELPURL = "https://docs.arduino.cc/libraries/bonezegei_uln2003_stepper/";
Blockly.Msg.STEPPER_INIT_TOOLTIP = "Настраивает шаговый двигатель под указанным номером - назначает выводы IN1–IN4, к которым подключен драйвер, и задает скорость в мс/шаг. Для использования скорости по умолчанию введите 0 в соответствующем поле";
Blockly.Msg.STEPPER_INIT_INPUT_1 = "настроить шаговый двигатель №";
Blockly.Msg.STEPPER_INIT_INPUT_2 = "выводы";
Blockly.Msg.STEPPER_INIT_INPUT_3 = "скорость";
Blockly.Msg.STEPPER_INIT_INPUT_4 = "мс/шаг";
Blockly.Msg.STEPPER_MOVE_TOOLTIP = "Поворачивает указанный шаговый двигатель вперёд или назад, на заданный угол или число шагов";
Blockly.Msg.STEPPER_MOVE_INPUT_1 = "шаговый двигатель №";
Blockly.Msg.STEPPER_MOVE_INPUT_2 = "повернуть";
Blockly.Msg.STEPPER_MOVE_INPUT_3 = "по";
Blockly.Msg.STEPPER_MOVE_INPUT_4 = "на";
Blockly.Msg.STEPPER_MOVE_FORWORD = "вперед";
Blockly.Msg.STEPPER_MOVE_REVERSE = "назад";
Blockly.Msg.STEPPER_MOVE_ANGLE = "углу";
Blockly.Msg.STEPPER_MOVE_STEPS = "шагам";

// Displays
Blockly.Msg.LCD_I2C_HELPURL = "https://docs.arduino.cc/libraries/liquidcrystal-i2c/";
Blockly.Msg.LCD_I2C_INIT_TOOLTIP = "Настраивает выводы I2C на плате для работы с дисплеем по указанному адресу и с указанным количеством строк и столбцов на дисплее. Включает подсветку дисплея";
Blockly.Msg.LCD_I2C_INIT_ADDR = "I2C LCD подключить дисплей - адрес";
Blockly.Msg.LCD_I2C_INIT_COL = "количество столбцов";
Blockly.Msg.LCD_I2C_INIT_ROW = "и строк";
Blockly.Msg.LCD_I2C_BACKLIGHT_TOOLTIP = "Включает или выключает подсветку дисплея";
Blockly.Msg.LCD_I2C_BACKLIGHT_INPUT_1 = "I2C LCD";
Blockly.Msg.LCD_I2C_BACKLIGHT_INPUT_2 = "подсветку";
Blockly.Msg.LCD_I2C_BACKLIGHT_ON = "включить";
Blockly.Msg.LCD_I2C_BACKLIGHT_OFF = "выключить";
Blockly.Msg.LCD_I2C_CLEAR_TOOLTIP = "Удаляет все содержимое с экрана дисплея";
Blockly.Msg.LCD_I2C_CLEAR = "I2C LCD очистить дисплей";
Blockly.Msg.LCD_I2C_PRINT_TOOLTIP = "Выводит указанный текст в указанную строку, начиная с указанного столбца. Нумерация строк и столбцов начинается с 1";
Blockly.Msg.LCD_I2C_PRINT_TEXT = "I2C LCD вывести текст";
Blockly.Msg.LCD_I2C_PRINT_COL = "в столбец";
Blockly.Msg.LCD_I2C_PRINT_ROW = "строку";