/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

'use strict';

goog.provide('Blockly.Msg.blocks_en');

goog.require('Blockly.Msg');

//text in blocks
Blockly.Msg.FIELDDROPDOWN = [["high", "HIGH"], ["low", "LOW"]];
Blockly.Msg.FIELDDROPDOWN_ONOFF = [["turn on", "ON"], ["turn off", "OFF"]];
Blockly.Msg.FIELDDROPDOWN_ONOFF2 = [["switch on", "HIGH"], ["switch off", "LOW"]];
Blockly.Msg.FIELDDROPDOWN_ONOFF3 = [["close", "HIGH"], ["open", "LOW"]];

//blockly logic
Blockly.Msg.CONTROLS_SWITCH_CASEBREAK_TOOLTIP = "Add new case block";
Blockly.Msg.CONTROLS_SWITCH_DEFAULT_TOOLTIP = "Add a final, catch-all condition to the if block";
Blockly.Msg.CONTROLS_SWITCH_HELPURL = "https://en.wikipedia.org/wiki/Switch_statement";
Blockly.Msg.CONTROLS_SWITCH_SWITCH_TOOLTIP = "Add, remove, or reorder sections to reconfigure this if block.";
Blockly.Msg.CONTROLS_SWITCH_VAR_TITLE = "Switch";
Blockly.Msg.CONTROLS_SWITCH_MSG_DEFAULT = "default";
Blockly.Msg.CONTROLS_SWITCH_MSG_CASEBREAK = "case";
Blockly.Msg.CONTROLS_SWITCH_MSG_SWITCHVAR = "Switch (var)";
Blockly.Msg.CONTROLS_SWITCH_MSG_DO = "do";
Blockly.Msg.CONTROLS_SWITCH_TOOLTIP_1 = "If the value in the 'Switch' field matches the value of 'case 1', then the specified statements are executed. If it doesn't - nothing happens";
Blockly.Msg.CONTROLS_SWITCH_TOOLTIP_2 = "If the value in the 'Switch' field matches the value of 'case 1', then this case statements are executed. If the values ​​don't match, the statements from the 'default' field are executed";
Blockly.Msg.CONTROLS_SWITCH_TOOLTIP_3 = "If the value in the 'Switch' field matches any of the values ​​in the 'case' fields, only the statements from that case (the first one that matches) are executed. If there are no matches, nothing happens";
Blockly.Msg.CONTROLS_SWITCH_TOOLTIP_4 = "If the value in the 'Switch' field matches any of the values ​​in the 'case' fields, only the statements from that case (the first one that matches) are executed. If there are no matches, the statements from the 'default' field are executed";
Blockly.Msg.CONTROLS_SWITCH_VAR_TOOLTIP = "Drag a 'case' or 'default' block here to add it to the common block";
Blockly.Msg.CONTROLS_SWITCH_CASEBREAK_TOOLTIP = "Adds another 'case' with the operators field";
Blockly.Msg.CONTROLS_SWITCH_DEFAULT_TOOLTIP = "Add optional default action";
//Arduino base category blocks
Blockly.Msg.VAR_SET_TITLE = "set";
Blockly.Msg.VAR_SET_INITIAL = "initial value";
Blockly.Msg.VAR_CREATE_NUMBER = "number";
Blockly.Msg.VAR_CREATE_FLOAT = "float";
Blockly.Msg.VAR_CREATE_STRING = "string";
Blockly.Msg.VAR_CREATE_BOOLEAN = "bool";
Blockly.Msg.ARDUINO_INOUT_BUILDIN_LED_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/digital-io/digitalwrite/";
Blockly.Msg.ARDUINO_INOUT_BUILDIN_LED_INPUT = "switch the LED to the state";
Blockly.Msg.ARDUINO_INOUT_BUILDIN_LED_TOOLTIP = "Controls the state of the LED built into the board";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_WRITE_INPUT1 = "change pin #";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_WRITE_INPUT2 = "state to";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_ANALOG_ALERT = "To use an analog pin as a digital one, you must switch the DIP switch corresponding to this pin to the “ON” position on the ELBEAR board";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_WRITE_TOOLTIP = "Sets the specified digital pin to the specified state - 0 or 1";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_WRITE_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/digital-io/digitalwrite/";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_INPUT = "the state of pin #";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_TOOLTIP = "Returns the digital pin state - 0 or 1";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/digital-io/digitalread/";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_WITH_PULLUP_INPUT = "with pull-up";
Blockly.Msg.ARDUINO_INOUT_DIGITAL_READ_WITH_PULLUP_TOOLTIP = "Returns the digital pin state - 0 or 1. Pin is initialized as pull-up pin";
Blockly.Msg.ARDUINO_INOUT_ONOFF_HELPURL = "https://docs.arduino.cc/language-reference/#variables";
Blockly.Msg.ARDUINO_INOUT_ONOFF_TOOLTIP = "Returns value \"0\" or \"1\"";
Blockly.Msg.ARDUINO_INOUT_ANALOG_WRITE_INPUT1 = "enable PWM on pin #";
Blockly.Msg.ARDUINO_INOUT_ANALOG_WRITE_INPUT2 = "with value";
Blockly.Msg.ARDUINO_INOUT_ANALOG_WRITE_TOOLTIP = "Sets a value from 0 to 255 on the specified PWM pin";
Blockly.Msg.ARDUINO_INOUT_ANALOG_WRITE_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/analog-io/analogWrite/";
Blockly.Msg.ARDUINO_INOUT_ANALOG_READ_INPUT = "measure voltage on analog pin #";
Blockly.Msg.ARDUINO_INOUT_ANALOG_READ_TOOLTIP = "Measures the voltage at the specified pin and returns a value between 0 and 1023";
Blockly.Msg.ARDUINO_INOUT_ANALOG_READ_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/analog-io/analogRead/";
Blockly.Msg.ARDUINO_BASE_DELAY_DELAY_TIME = "delay in ms";
Blockly.Msg.ARDUINO_BASE_DELAY_TOOLTIP = "Stops program execution for the specified time in milliseconds";
Blockly.Msg.ARDUINO_BASE_DELAY_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/time/delay/";
Blockly.Msg.ARDUINO_BASE_DELAY_US_DELAY_TIME = "delay in us";
Blockly.Msg.ARDUINO_BASE_DELAY_US_TOOLTIP = "Stops program execution for the specified time in microseconds";
Blockly.Msg.ARDUINO_BASE_DELAY_US_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/time/delayMicroseconds/";
Blockly.Msg.ARDUINO_BASE_ANGLE = "angle: ";
Blockly.Msg.ARDUINO_BASE_ANGLE_TOOLTIP = "Sets the angle in the range 0...180 degrees";
Blockly.Msg.ARDUINO_BASE_ANGLE_HELPURL = "";
Blockly.Msg.ARDUINO_TONE_INPUT1 = "enable sound on pin #";
Blockly.Msg.ARDUINO_TONE_INPUT2 = "with frequency";
Blockly.Msg.ARDUINO_TONE_INPUT3 = "Hz for";
Blockly.Msg.ARDUINO_TONE_INPUT4 = "ms";
Blockly.Msg.ARDUINO_TONE_TOOLTIP = "Allows the specified pin to be used to play sound at the specified frequency for the specified duration in milliseconds. Specify 0 ms for continuous playback";
Blockly.Msg.ARDUINO_TONE_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/advanced-io/tone/";
Blockly.Msg.ARDUINO_NOTONE_INPUT = "disable sound on pin #";
Blockly.Msg.ARDUINO_NOTONE_TOOLTIP = "Mutes the sound on the specified pin";
Blockly.Msg.ARDUINO_NOTONE_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/advanced-io/noTone/";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT1 = "shift out value";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT2 = "on pin #";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT3 = "by clock on pin #";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT4 = "with";
Blockly.Msg.ARDUINO_SHIFT_OUT_INPUT5 = "order";
Blockly.Msg.ARDUINO_SHIFT_OUT_TOOLTIP = "Shifts out a byte of data one bit at a time on the data pin, synchronized by pulses on the clock pin";
Blockly.Msg.ARDUINO_SHIFT_OUT_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/advanced-io/shiftOut/";
Blockly.Msg.ARDUINO_MSB = "MSB";
Blockly.Msg.ARDUINO_LSB = "LSB";
Blockly.Msg.ARDUINO_SHIFT_IN_1 = "shift in value from pin #";
Blockly.Msg.ARDUINO_SHIFT_IN_2 = "by clock on pin #";
Blockly.Msg.ARDUINO_SHIFT_IN_3 = "with";
Blockly.Msg.ARDUINO_SHIFT_IN_4 = "order";
Blockly.Msg.ARDUINO_SHIFT_IN_TOOLTIP = "Reads a byte of data one bit at a time from a data pin, synchronized by pulses on the clock pin";
Blockly.Msg.ARDUINO_SHIFT_IN_HELPURL = "https://docs.arduino.cc/language-reference/en/functions/advanced-io/shiftIn/";

//SERIAL
Blockly.Msg.SERIAL_INIT = "init communication speed";
Blockly.Msg.SERIAL_INIT_TOOLTIP = "Sets the speed for serial communication via COM port";
Blockly.Msg.SERIAL_PRINT_NEWLINE = "add new line";
Blockly.Msg.SERIAL_PRINT_FORMAT_1 = "send the number";
Blockly.Msg.SERIAL_PRINT_FORMAT_2 = "to the serial port in";
Blockly.Msg.SERIAL_PRINT_FORMAT_3 = "format,";
Blockly.Msg.SERIAL_PRINT_FORMAT_TOOLTIP = "Sets the format of data transmitted to the COM port - decimal/hexadecimal/binary/octal. If necessary, adds a new line after the sent data";
Blockly.Msg.SERIAL_PRINT_FORDECIMAL = "decimal";
Blockly.Msg.SERIAL_PRINT_FORHEXA = "hexadecimal";
Blockly.Msg.SERIAL_PRINT_FORBIN = "binary";
Blockly.Msg.SERIAL_PRINT_FOROCT = "octal";
Blockly.Msg.SERIAL_READ = "read serial data from COM port";
Blockly.Msg.SERIAL_READ_TOOLTIP = "Returns one byte of serial data received on the COM port. Returns -1 if there is no data";
Blockly.Msg.SERIAL_AVAILABLE = "number of bytes available for reading";
Blockly.Msg.SERIAL_AVAILABLE_TOOLTIP = "Returns the number of bytes received via the COM port and available for reading. Returns 0 if there is no data";
Blockly.Msg.SERIAL_FLUSH = "wait for the data transfer finish";
Blockly.Msg.SERIAL_FLUSH_TOOLTIP = "Stops program execution until data transfer via COM port is complete";
Blockly.Msg.SERIAL_READSTRINGUNTIL_CONTENT = "read data into a string up to the character";
Blockly.Msg.SERIAL_READSTRINGUNTIL_TOOLTIP = "Stores the received data into a string until the specified character is encountered";
Blockly.Msg.SERIAL_PRINT_CONTENT_1 = "send the data";
Blockly.Msg.SERIAL_PRINT_CONTENT_2 = "to the serial port,";
Blockly.Msg.SERIAL_PRINT_CONTENT_TOOLTIP = "Sends numbers or text to the COM port and, if necessary, adds a new line after the sent data";

// RTC
Blockly.Msg.DS1302_INIT_INPUT1 = "DS1302 connect module - pin DATA #";
Blockly.Msg.DS1302_INIT_INPUT2 = "pin CLK #";
Blockly.Msg.DS1302_INIT_INPUT3 = "pin RESET #";
Blockly.Msg.DS1302_INIT_TOOLTIP = "Initializes the selected pins for use with the DS1302 module";
Blockly.Msg.DS1302_HELPURL = "https://docs.arduino.cc/libraries/ds1302/";
Blockly.Msg.DS1302_SET_TIME_INPUT1 = "DS1302 set date and time:";
Blockly.Msg.DS1302_HOURS = "hour";
Blockly.Msg.DS1302_MINUTES = "minutes";
Blockly.Msg.DS1302_SECONDS = "seconds";
Blockly.Msg.DS1302_DAY = "day";
Blockly.Msg.DS1302_MONTH = "month";
Blockly.Msg.DS1302_YEAR = "year";
Blockly.Msg.DS1302_SET_TIME_TOOLTIP = "Sets the specified time and date on the DS1302 module. The year is specified as a two-digit number (e.g. enter \"25\" to set the year to 2025)";
Blockly.Msg.DS1302_SET_INIT_TIME_INPUT1 = "DS1302 set initial date and time:";
Blockly.Msg.DS1302_SET_INIT_TIME_TOOLTIP = "Sets the specified time and date on the DS1302 module when the program starts. The year is specified as a two-digit number (e.g. enter \"25\" to set the year to 2025)";
Blockly.Msg.DS1302_UPDATE_TIME_INPUT = "DS1302 update date and time";
Blockly.Msg.DS1302_UPDATE_TIME_TOOLTIP = "Reads the current date and time from DS1302 to an internal variable";
Blockly.Msg.DS1302_GET_PARAM_INPUT = "DS1302 get";
Blockly.Msg.DS1302_GET_PARAM_TOOLTIP = "Return the selected value from an internal variable";

// Sensors
Blockly.Msg.DHT_INPUT1 = "DHT connect module with";
Blockly.Msg.DHT_INPUT2 = "type to pin #";
Blockly.Msg.DHT_INPUT3 = "and measure";
Blockly.Msg.DHT_TEMP = "temperature, °С";
Blockly.Msg.DHT_HUM = "humidity, %";
Blockly.Msg.DHT_TOOLTIP = "Measures temperature or humidity using a DHT sensor of the specified type connected to the specified pin";
Blockly.Msg.DHT_HELPURL = "https://docs.arduino.cc/libraries/dht-sensor-library/";

Blockly.Msg.HCSR04_INPUT1 = "HCSR04 connect module - pin TRIG #";
Blockly.Msg.HCSR04_INPUT2 = "pin ECHO #";
Blockly.Msg.HCSR04_INPUT3 = "and measure distance in cm";
Blockly.Msg.HCSR04_TOOLTIP = "Measures the distance to the nearest obstacle in centimeters";
Blockly.Msg.HCSR04_HELPURL = "https://docs.arduino.cc/libraries/hcsr04/";

Blockly.Msg.MFRC522_INPUT1 = "RFID - read UID with pins SS #";
Blockly.Msg.MFRC522_INPUT2 = "RST #";
Blockly.Msg.MFRC522_TOOLTIP = "Returns UID of detected RFID card as a string. If the card is not detected, returns an empty string";
Blockly.Msg.MFRC522_HELPURL = "https://docs.arduino.cc/libraries/mfrc522/";

Blockly.Msg.DS18B20_INPUT1 = "DS18B20 measure temperature with pin DATA #";
Blockly.Msg.DS18B20_TOOLTIP = "Returns the temperature in Celsius measured by the sensor connected to the DATA pin";
Blockly.Msg.DS18B20_HELPURL = "https://docs.arduino.cc/libraries/ds18b20/";

// Motors
Blockly.Msg.SERVO_MOVE_TOOLTIP = "Rotates the servo connected to the specified pin to the specified angle. Valid range: 0 to 180 degrees";
Blockly.Msg.SERVO_MOVE_HELPURL = "https://docs.arduino.cc/libraries/servo/";
Blockly.Msg.SERVO_MOVE_INPUT = "rotate the servomotor on pin";
Blockly.Msg.SERVO_MOVE_DEGREE = "to an angle of";
Blockly.Msg.SERVO_MOVE_DEGREE_1 = "degrees";

Blockly.Msg.STEPPER_HELPURL = "https://docs.arduino.cc/libraries/bonezegei_uln2003_stepper/";
Blockly.Msg.STEPPER_INIT_TOOLTIP = "Configures the stepper motor under the specified number - assigns the IN1–IN4 pins to which the driver is connected and sets the speed in ms/step. To use the default speed, enter 0 in the corresponding field";
Blockly.Msg.STEPPER_INIT_INPUT_1 = "Configure stepper motor №";
Blockly.Msg.STEPPER_INIT_INPUT_2 = "pins";
Blockly.Msg.STEPPER_INIT_INPUT_3 = "speed";
Blockly.Msg.STEPPER_INIT_INPUT_4 = "ms/step";
Blockly.Msg.STEPPER_MOVE_TOOLTIP = "Rotates the specified stepper motor forward or backward by the given angle or steps number";
Blockly.Msg.STEPPER_MOVE_INPUT_1 = "stepper motor №";
Blockly.Msg.STEPPER_MOVE_INPUT_2 = "rotate";
Blockly.Msg.STEPPER_MOVE_INPUT_3 = "by";
Blockly.Msg.STEPPER_MOVE_INPUT_4 = "on";
Blockly.Msg.STEPPER_MOVE_FORWORD = "forward";
Blockly.Msg.STEPPER_MOVE_REVERSE = "backward";
Blockly.Msg.STEPPER_MOVE_ANGLE = "angle";
Blockly.Msg.STEPPER_MOVE_STEPS = "steps";

// Displays
Blockly.Msg.LCD_I2C_HELPURL = "https://docs.arduino.cc/libraries/liquidcrystal-i2c/";
Blockly.Msg.LCD_I2C_INIT_TOOLTIP = "Configures the board I2C pins to drive the display at the specified address and with the specified number of rows and columns. Enables display backlight";
Blockly.Msg.LCD_I2C_INIT_ADDR = "I2C LCD connect display - address";
Blockly.Msg.LCD_I2C_INIT_COL = "number of columns";
Blockly.Msg.LCD_I2C_INIT_ROW = "and rows";
Blockly.Msg.LCD_I2C_BACKLIGHT_TOOLTIP = "Enables or disables display backlight";
Blockly.Msg.LCD_I2C_BACKLIGHT_INPUT_1 = "I2C LCD";
Blockly.Msg.LCD_I2C_BACKLIGHT_INPUT_2 = "backlight";
Blockly.Msg.LCD_I2C_BACKLIGHT_ON = "enable";
Blockly.Msg.LCD_I2C_BACKLIGHT_OFF = "disable";
Blockly.Msg.LCD_I2C_CLEAR_TOOLTIP = "Clears all content from the display screen";
Blockly.Msg.LCD_I2C_CLEAR = "I2C LCD clear display";
Blockly.Msg.LCD_I2C_PRINT_TOOLTIP = "Displays the specified text on the given row and column of the LCD. Row and column numbering starts from 1";
Blockly.Msg.LCD_I2C_PRINT_TEXT = "I2C LCD print text";
Blockly.Msg.LCD_I2C_PRINT_COL = "to column";
Blockly.Msg.LCD_I2C_PRINT_ROW = "row";