/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @fileoverview Helper functions for selecting and changing boards.
 * @author scanet@libreduc.cc (Sébastien CANET)
 */

'use strict';

goog.provide('Blockly.Boards');

//set default profile
profile.default = profile["none"][0];

/**
 * Set board when click in board modal
 */
Code.setBoard = function () {
    var boardId = Code.getStringParamFromUrl('board', '');
    // Если плата не передана в URL — установить по умолчанию ace_uno
    if (!boardId || !profile[boardId]) {
        boardId = "ace_uno_8";
    }

    document.getElementById('boardMenu').value = boardId;
    profile.default = profile[boardId][0];
	profile.default.defaultBaudRate = profile.default.speed || "9600";
	localStorage.setItem("defaultBaudRate", profile.default.defaultBaudRate);

	document.getElementById('boardButton').classList.add('active');
	document.getElementById('boardButton').title = profile["default"].description;
	document.getElementById('boardButton').onmouseover = function () {
		document.getElementById("content_hoverButton").textContent = profile["default"].description;
	};
	document.getElementById('boardButton').onmouseout = function () {
		document.getElementById("content_hoverButton").textContent = "";
	};

	// Обновим строку состояния с платой и портом
	document.getElementById("boardSelected_span").textContent = profile["default"].description;
	const serialMenu = document.getElementById("serialMenu");
	const selectedPort = decodeURIComponent(serialMenu?.options[serialMenu.selectedIndex]?.value || "...");
	document.getElementById("portSelected_span").textContent = " : " + selectedPort;
};

/**
 * Set board throught URL
 */
Code.changeBoard = function ()  {
    var boardMenu = document.getElementById('boardDescriptionSelector');
    var newBoard = encodeURIComponent(boardMenu.options[boardMenu.selectedIndex].value);
    var search = window.location.search;
    if (search.length <= 1) {
        search = '?board=' + newBoard;
    } else if (search.match(/[?&]board=[^&]*/)) {
        search = search.replace(/([?&]board=)[^&]*/, '$1' + newBoard);
    } else {
        search = search.replace(/\?/, '?board=' + newBoard + '&');
    }
    profile["default"] = profile[newBoard][0];
	document.getElementById("boardDescriptionSelector").selectedIndex = newBoard;
	document.getElementById("boardDescriptionSelector").value = newBoard;
	document.getElementById("boardSelected_span").textContent = profile["default"].description;
	const portRaw = document.getElementById('serialMenu').options[document.getElementById('serialMenu').selectedIndex].value;
	document.getElementById("portSelected_span").textContent = ' : ' + decodeURIComponent(portRaw);
	window.history.pushState({}, "blocklyduino", window.location.host + window.location.pathname + search);
	// "reboot" elements
	document.getElementById('overlayForModals').style.display = "none";
	document.getElementById('boardListModal').classList.remove('show');
	Code.setBoard();
	Code.buildToolbox();
	var xml = Blockly.Xml.workspaceToDom(Code.workspace);
	Blockly.Xml.domToWorkspace(xml, Code.workspace);
}
;

/**
 * Set COM port
 */
Code.setPort = function ()  {
    var serialPortMenu = document.getElementById('serialMenu');
    var newPort = encodeURIComponent(serialPortMenu.options[serialPortMenu.selectedIndex].value);
	document.getElementById('overlayForModals').style.display = "none";
	document.getElementById('portListModal').classList.remove('show');
	document.getElementById("portSelected_span").textContent = ' : ' + decodeURIComponent(newPort);
	if (newPort != 'none') {
			document.getElementById('serialButton').classList.add('active');
			document.getElementById('serialButton').title = decodeURIComponent(newPort);
			document.getElementById('serialButton').onmouseover = function () {
			document.getElementById("content_hoverButton").textContent = decodeURIComponent(newPort);
		};
		document.getElementById('serialButton').onmouseout = function () {
			document.getElementById("content_hoverButton").textContent = "";
		}
	}
		else {
			document.getElementById('serialButton').classList.remove('active');
			document.getElementById('serialButton').title = MSG['serialButtonSpan'];
			document.getElementById('serialButton').onmouseover = function () {
				document.getElementById("content_hoverButton").textContent = MSG['serialButtonSpan'];
			};
			document.getElementById('serialButton').onmouseout = function () {
				document.getElementById("content_hoverButton").textContent = "";
			};
		}
}
;