/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @fileoverview Typed variable blocks for Blockly.
 * @author scanet@libreduc.cc (Sébastien CANET)
 */

'use strict';

goog.provide('Blockly.Constants.VariablesTyped');

Blockly.Blocks['vars_set_number_init'] = {
    init: function () {
        this.appendValueInput("VALUE")
            .appendField(Blockly.Msg.VAR_SET_INITIAL || "set initial")
            .appendField(new Blockly.FieldVariable("", null, ['Number'], 'Number'), "VAR_SET_NUMBER")
            .setCheck("Number");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['vars_set_number'] = {
    init: function () {
        this.appendValueInput("VALUE")
                .appendField(Blockly.Msg.VAR_SET_TITLE || "set")
                .appendField(new Blockly.FieldVariable("", null, ['Number'], 'Number'), "VAR_SET_NUMBER")
                .setCheck("Number");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['vars_get_number'] = {
    init: function () {
        this.appendDummyInput()
                .appendField(new Blockly.FieldVariable("", null, ['Number'], 'Number'), "VAR_GET_NUMBER");
        this.setOutput(true, "Number");
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};


Blockly.Blocks['vars_set_string_init'] = {
    init: function () {
        this.appendValueInput("VALUE")
            .appendField(Blockly.Msg.VAR_SET_INITIAL || "set initial")
            .appendField(new Blockly.FieldVariable("", null, ['String'], 'String'), "VAR_SET_STRING")
            .setCheck(stringCompatibility);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['vars_set_string'] = {
    init: function () {
        this.appendValueInput("VALUE")
                .appendField(Blockly.Msg.VAR_SET_TITLE || "set")
                .appendField(new Blockly.FieldVariable("", null, ['String'], 'String'), "VAR_SET_STRING")
                .setCheck(stringCompatibility);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['vars_get_string'] = {
    init: function () {
        this.appendDummyInput()
                .appendField(new Blockly.FieldVariable("", null, ['String'], 'String'), "VAR_GET_STRING");
        this.setOutput(true, "String");
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['vars_set_boolean_init'] = {
    init: function () {
        this.appendValueInput("VALUE")
            .appendField(Blockly.Msg.VAR_SET_INITIAL || "set initial")
            .appendField(new Blockly.FieldVariable("", null, ['bool'], 'bool'), "VAR_SET_BOOLEAN")
            .setCheck(booleanCompatibility);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['vars_set_boolean'] = {
    init: function () {
        this.appendValueInput("VALUE")
                .appendField(Blockly.Msg.VAR_SET_TITLE || "set")
                .appendField(new Blockly.FieldVariable("", null, ['bool'], 'bool'), "VAR_SET_BOOLEAN")
                .setCheck(booleanCompatibility);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['vars_get_boolean'] = {
    init: function () {
        this.appendDummyInput()
                .appendField(new Blockly.FieldVariable("", null, ['bool'], 'bool'), "VAR_GET_BOOLEAN");
        this.setOutput(true, "Boolean");
        this.setStyle('variable_blocks');
        this.setTooltip("");
        this.setHelpUrl("");
    }
};