/**
 * @license
 * Copyright 2025 Elron
 * SPDX-License-Identifier: GPL3
 */

/**
 * @fileoverview different sensors blocks for Blockly
 * @author info@elron.tech
 */
 
'use strict';

goog.require('Blockly.Blocks');
goog.require('Blockly');

// ================================= DHT ================================= //
Blockly.Blocks['dht_block'] = {
    init: function () {
        // исключить выводы светодиода и кнопки
        const filteredDropdown = profile.default.dropdownDigital.filter(item =>
            item[1] !== 'LED_BUILTIN' && item[1] !== 'BTN_BUILTIN'
        );
        this.appendDummyInput()
            .appendField(Blockly.Msg.DHT_INPUT1)
            .appendField(new Blockly.FieldDropdown([
                ["DHT11", "DHT11"],
                ["DHT12", "DHT12"],
                ["DHT21", "DHT21"],
                ["DHT22", "DHT22"]
            ]), "TYPE");
        this.appendDummyInput()
            .appendField(Blockly.Msg.DHT_INPUT2)
            .appendField(new Blockly.FieldDropdown(filteredDropdown), "PIN");
        this.appendDummyInput()
            .appendField(Blockly.Msg.DHT_INPUT3)
            .appendField(new Blockly.FieldDropdown([
                [Blockly.Msg.DHT_TEMP, "temp"],
                [Blockly.Msg.DHT_HUM, "hum"]
            ]), "VALUE");
            
        this.setInputsInline(true);
        this.setOutput(true, "Number");
        this.setStyle('sensors_blocks');
		this.setTooltip(Blockly.Msg.DHT_TOOLTIP);
		this.setHelpUrl(Blockly.Msg.DHT_HELPURL);
    }
};

// ================================= HCSR04 ================================= //
Blockly.Blocks['hcsr04_block'] = {
    init: function () {
        // исключить выводы светодиода и кнопки
        const filteredDropdown = profile.default.dropdownDigital.filter(item =>
            item[1] !== 'LED_BUILTIN' && item[1] !== 'BTN_BUILTIN'
        );
        this.appendDummyInput()
            .appendField(Blockly.Msg.HCSR04_INPUT1)
            .appendField(new Blockly.FieldDropdown(() => {
                const echo = this.getFieldValue("ECHO");
                return filteredDropdown.filter(item => item[1] !== echo);
            }), "TRIG");
        this.appendDummyInput()
            .appendField(Blockly.Msg.HCSR04_INPUT2)
            .appendField(new Blockly.FieldDropdown(() => {
                const trig = this.getFieldValue("TRIG");
                return filteredDropdown.filter(item => item[1] !== trig);
            }), "ECHO");
        this.appendDummyInput()
            .appendField(Blockly.Msg.HCSR04_INPUT3);
            
        this.setInputsInline(true);
        this.setOutput(true, "Number");
        this.setStyle('sensors_blocks');
		this.setTooltip(Blockly.Msg.HCSR04_TOOLTIP);
		this.setHelpUrl(Blockly.Msg.HCSR04_HELPURL);
    }
};

// ================================= RFID ================================= //
Blockly.Blocks['rfid_get_uid'] = {
    init: function () {
        // исключить выводы светодиода и кнопки
        const filteredDropdown = profile.default.dropdownDigital.filter(item =>
            item[1] !== 'LED_BUILTIN' && item[1] !== 'BTN_BUILTIN'
        );
        this.appendDummyInput()
            .appendField(Blockly.Msg.MFRC522_INPUT1)
            .appendField(new Blockly.FieldDropdown(() => {
                const rst = this.getFieldValue("RST");
                return filteredDropdown.filter(item => item[1] !== rst);
            }), "SS");
        this.appendDummyInput()
            .appendField(Blockly.Msg.MFRC522_INPUT2)
            .appendField(new Blockly.FieldDropdown(() => {
                const ss = this.getFieldValue("SS");
                return filteredDropdown.filter(item => item[1] !== ss);
            }), "RST");
        
        this.setInputsInline(true);
        this.setOutput(true, "String");
        this.setStyle("sensors_blocks");
        this.setTooltip(Blockly.Msg.MFRC522_TOOLTIP);
        this.setHelpUrl(Blockly.Msg.MFRC522_HELPURL);
    }
};

// ================================= DS18B20 ================================= //
Blockly.Blocks['ds18b20_block'] = {
    init: function () {
        // исключить выводы светодиода и кнопки
        const filteredDropdown = profile.default.dropdownDigital.filter(item =>
            item[1] !== 'LED_BUILTIN' && item[1] !== 'BTN_BUILTIN'
        );
        this.appendDummyInput()
            .appendField(Blockly.Msg.DS18B20_INPUT1)
            .appendField(new Blockly.FieldDropdown(filteredDropdown), "PIN")
            .appendField(Blockly.Msg.DS18B20_INPUT2);
    
        this.setOutput(true, "Number");
        this.setStyle('sensors_blocks');
		this.setTooltip(Blockly.Msg.DS18B20_TOOLTIP);
		this.setHelpUrl(Blockly.Msg.DS18B20_HELPURL);
    }
};