/**
 * @license
 * Copyright 2025 Elron
 * SPDX-License-Identifier: GPL3
 */

/**
 * @fileoverview different RTC mcu blocks for Blockly
 * @author info@elron.tech
 */
 
'use strict';

goog.require('Blockly.Blocks');
goog.require('Blockly');

Blockly.Blocks['ds1302_init'] = {
    init: function () {
        // исключить выводы светодиода и кнопки
        const filteredDropdown = profile.default.dropdownDigital.filter(item =>
            item[1] !== 'LED_BUILTIN' && item[1] !== 'BTN_BUILTIN'
        );
        this.appendDummyInput()
            .appendField(Blockly.Msg.DS1302_INIT_INPUT1)
            .appendField(new Blockly.FieldDropdown(() => {
                const clk = this.getFieldValue("CLOCK");
				const reset = this.getFieldValue("RESET");
                return filteredDropdown.filter(item => item[1] !== clk && item[1] !== reset);
            }), "DATA");
        this.appendDummyInput()
            .appendField(Blockly.Msg.DS1302_INIT_INPUT2)
            .appendField(new Blockly.FieldDropdown(() => {
                const data = this.getFieldValue("DATA");
				const reset = this.getFieldValue("RESET");
                return filteredDropdown.filter(item => item[1] !== data && item[1] !== reset);
    		}), "CLOCK");
        this.appendDummyInput()
            .appendField(Blockly.Msg.DS1302_INIT_INPUT3)
            .appendField(new Blockly.FieldDropdown(() => {
                const data = this.getFieldValue("DATA");
				const clk = this.getFieldValue("CLOCK");
				return filteredDropdown.filter(item => item[1] !== data && item[1] !== clk);
			}), "RESET");
            
        this.setInputsInline(true);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setStyle('rtc_blocks');
		this.setTooltip(Blockly.Msg.DS1302_INIT_TOOLTIP);
		this.setHelpUrl(Blockly.Msg.DS1302_HELPURL);
    }
};

Blockly.Blocks['ds1302_set_init_time'] = {
  init: function() {
    this.appendDummyInput()
        .appendField(Blockly.Msg.DS1302_SET_INIT_TIME_INPUT1);
	this.appendValueInput("HOUR")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_HOURS);
    this.appendValueInput("MIN")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_MINUTES);
    this.appendValueInput("SEC")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_SECONDS);
    this.appendValueInput("DAY")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_DAY);
    this.appendValueInput("MONTH")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_MONTH);
	this.appendValueInput("YEAR")
        .setCheck("Number")   
		.appendField(Blockly.Msg.DS1302_YEAR);

    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
	this.setInputsInline(true);
    this.setStyle('rtc_blocks');
    this.setTooltip(Blockly.Msg.DS1302_SET_INIT_TIME_TOOLTIP);
    this.setHelpUrl(Blockly.Msg.DS1302_HELPURL);
  }
};

Blockly.Blocks['ds1302_set_time'] = {
  init: function() {
    this.appendDummyInput()
        .appendField(Blockly.Msg.DS1302_SET_TIME_INPUT1);
	this.appendValueInput("HOUR")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_HOURS);
    this.appendValueInput("MIN")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_MINUTES);
    this.appendValueInput("SEC")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_SECONDS);
    this.appendValueInput("DAY")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_DAY);
    this.appendValueInput("MONTH")
        .setCheck("Number")
        .appendField(Blockly.Msg.DS1302_MONTH);
	this.appendValueInput("YEAR")
        .setCheck("Number")   
		.appendField(Blockly.Msg.DS1302_YEAR);

    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
	this.setInputsInline(true);
    this.setStyle('rtc_blocks');
    this.setTooltip(Blockly.Msg.DS1302_SET_TIME_TOOLTIP);
    this.setHelpUrl(Blockly.Msg.DS1302_HELPURL);
  }
};

Blockly.Blocks['ds1302_update_time'] = {
  init: function() {
    this.appendDummyInput()
        .appendField(Blockly.Msg.DS1302_UPDATE_TIME_INPUT);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setStyle('rtc_blocks');
    this.setTooltip(Blockly.Msg.DS1302_UPDATE_TIME_TOOLTIP);
	this.setHelpUrl(Blockly.Msg.DS1302_HELPURL);
  }
};

Blockly.Blocks['ds1302_get_param'] = {
  init: function() {
    this.appendDummyInput()
        .appendField(Blockly.Msg.DS1302_GET_PARAM_INPUT)
        .appendField(new Blockly.FieldDropdown([
          [Blockly.Msg.DS1302_YEAR, "year"],
          [Blockly.Msg.DS1302_MONTH, "month"],
          [Blockly.Msg.DS1302_DAY, "day"],
          [Blockly.Msg.DS1302_HOURS, "hour"],
          [Blockly.Msg.DS1302_MINUTES, "minute"],
          [Blockly.Msg.DS1302_SECONDS, "second"]
        ]), "FIELD");
    this.setOutput(true, "Number");
    this.setStyle('rtc_blocks');
    this.setTooltip(Blockly.Msg.DS1302_GET_PARAM_TOOLTIP);
	this.setHelpUrl(Blockly.Msg.DS1302_HELPURL);
  }
};