/**
 * @license
 * Copyright 2025 Elron
 * SPDX-License-Identifier: GPL3
 */

/**
 * @fileoverview Displays blocks for Blockly.
 * @author info@elron.tech
 */
 
'use strict';

goog.require('Blockly.Blocks');
goog.require('Blockly');

// ================================= I2C LCD ================================= //
Blockly.Blocks['lcd_i2c_init'] = {
    init: function () {
        this.appendDummyInput()
            .appendField(Blockly.Msg.LCD_I2C_INIT_ADDR)
            .appendField(new Blockly.FieldTextInput("0x27"), "ADDR");

        this.appendValueInput("COL")
            .appendField(Blockly.Msg.LCD_I2C_INIT_COL)
            .setCheck('Number');
        
        this.appendValueInput("ROW")
            .appendField(Blockly.Msg.LCD_I2C_INIT_ROW)
            .setCheck('Number');
  
        this.setInputsInline(true);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setTooltip(Blockly.Msg.LCD_I2C_INIT_TOOLTIP);
        this.setHelpUrl(Blockly.Msg.LCD_I2C_HELPURL);
        this.setStyle('lcd_blocks');
    }
};

Blockly.Blocks['lcd_i2c_backlight'] = {
    init: function () {
        this.appendDummyInput()
            .appendField(Blockly.Msg.LCD_I2C_BACKLIGHT_INPUT_1)
            .appendField(new Blockly.FieldDropdown([
                [Blockly.Msg.LCD_I2C_BACKLIGHT_ON, "ON"], 
                [Blockly.Msg.LCD_I2C_BACKLIGHT_OFF, "OFF"]
            ]), "VAL")
            .appendField(Blockly.Msg.LCD_I2C_BACKLIGHT_INPUT_2);
            
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setTooltip(Blockly.Msg.LCD_I2C_BACKLIGHT_TOOLTIP);
        this.setHelpUrl(Blockly.Msg.LCD_I2C_HELPURL);
        this.setStyle('lcd_blocks');
    }
};

Blockly.Blocks['lcd_i2c_clear'] = {
    init: function () {
        this.appendDummyInput()
            .appendField(Blockly.Msg.LCD_I2C_CLEAR)
            
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setTooltip(Blockly.Msg.LCD_I2C_CLEAR_TOOLTIP);
        this.setHelpUrl(Blockly.Msg.LCD_I2C_HELPURL);
        this.setStyle('lcd_blocks');
    }
};

Blockly.Blocks['lcd_i2c_print'] = {
    init: function () {
        this.appendValueInput("TEXT")
            .appendField(Blockly.Msg.LCD_I2C_PRINT_TEXT)
            .setCheck('String');

        this.appendValueInput("COL")
            .appendField(Blockly.Msg.LCD_I2C_PRINT_COL)
            .setCheck('Number');
        
        this.appendValueInput("ROW")
            .appendField(Blockly.Msg.LCD_I2C_PRINT_ROW)
            .setCheck('Number');
  
        this.setInputsInline(true);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setTooltip(Blockly.Msg.LCD_I2C_PRINT_TOOLTIP);
        this.setHelpUrl(Blockly.Msg.LCD_I2C_HELPURL);
        this.setStyle('lcd_blocks');
    }
};
