/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @fileoverview Basics serial command blocks for Blockly.
 * @author scanet@libreduc.cc (Sébastien Canet)
 */

'use strict';

//To support syntax defined in http://arduino.cc/en/Reference/HomePage

goog.provide('Blockly.Constants.board_serial');

goog.require('Blockly.Blocks');
goog.require('Blockly');

var mediaFolder = "./blocklyduino/media/";

Blockly.Blocks['board_serial_init'] = {
    init: function () {
        this.setInputsInline(true);
        this.appendDummyInput("")
                .appendField(Blockly.Msg.SERIAL_INIT)
                .appendField(new Blockly.FieldDropdown(profile.default.serial), "SPEED");
        this.setFieldValue(profile.default.defaultBaudRate, "SPEED");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setTooltip(Blockly.Msg.SERIAL_INIT_TOOLTIP);
        this.setStyle('serial_blocks');
    }
};

Blockly.Blocks['board_serial_printfor'] = {
    init: function () {
        this.setInputsInline(true);
        this.appendValueInput("CONTENT")
                .setCheck('Number')
                .appendField(Blockly.Msg.SERIAL_PRINT_FORMAT_1)  
        this.appendDummyInput()
            .appendField(Blockly.Msg.SERIAL_PRINT_FORMAT_2)
            .appendField(new Blockly.FieldDropdown([[Blockly.Msg.SERIAL_PRINT_FORDECIMAL, "DEC"], [Blockly.Msg.SERIAL_PRINT_FORHEXA, "HEX"], [Blockly.Msg.SERIAL_PRINT_FORBIN, "BIN"], [Blockly.Msg.SERIAL_PRINT_FOROCT, "OCT"]]), "TYPE")
            .appendField(Blockly.Msg.SERIAL_PRINT_FORMAT_3);
        this.appendDummyInput()
            .appendField(Blockly.Msg.SERIAL_PRINT_NEWLINE)
            .appendField(new Blockly.FieldCheckbox("TRUE"), "NEWLINE");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setTooltip(Blockly.Msg.SERIAL_PRINT_FORMAT_TOOLTIP);
        this.setStyle('serial_blocks');
    }
};

Blockly.Blocks['board_serial_print'] = {
    init: function () {
        this.appendValueInput("CONTENT")
            .appendField(Blockly.Msg.SERIAL_PRINT_CONTENT_1);
        this.appendDummyInput()
            .appendField(Blockly.Msg.SERIAL_PRINT_CONTENT_2)
            .appendField(Blockly.Msg.SERIAL_PRINT_NEWLINE) 
            .appendField(new Blockly.FieldCheckbox("TRUE"), "NEWLINE");          
        
        this.setInputsInline(true);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setTooltip(Blockly.Msg.SERIAL_PRINT_CONTENT_TOOLTIP);
        this.setStyle('serial_blocks');
    }
};

Blockly.Blocks['board_serial_available'] = {
    init: function () {
        this.appendDummyInput("")
                .appendField(Blockly.Msg.SERIAL_AVAILABLE);
        this.setInputsInline(true);
        this.setOutput(true, "Number");
        this.setTooltip(Blockly.Msg.SERIAL_AVAILABLE_TOOLTIP);
        this.setStyle('serial_blocks');
    }
};

Blockly.Blocks['board_serial_read'] = {
    init: function () {
        this.appendDummyInput("")
                .appendField(Blockly.Msg.SERIAL_READ);
        this.setInputsInline(true);
        this.setOutput(true, "Number");
        this.setTooltip(Blockly.Msg.SERIAL_READ_TOOLTIP);
        this.setStyle('serial_blocks');
    }
};

Blockly.Blocks['board_serial_readStringUntil'] = {
    init: function () {
        this.appendValueInput("CONTENT")
                .setCheck('String')
                .appendField(Blockly.Msg.SERIAL_READSTRINGUNTIL_CONTENT);
        this.setInputsInline(true);
        this.setOutput(true, "String");
        this.setTooltip(Blockly.Msg.SERIAL_READSTRINGUNTIL_TOOLTIP);
        this.setStyle('serial_blocks');
    }
};

Blockly.Blocks['board_serial_flush'] = {
    init: function () {
        this.appendDummyInput("")
                .appendField(Blockly.Msg.SERIAL_FLUSH);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setTooltip(Blockly.Msg.SERIAL_FLUSH_TOOLTIP);
        this.setStyle('serial_blocks');
    }
};
