'use strict';

goog.require('Blockly.Blocks');
goog.require('Blockly');

Blockly.Blocks['controls_for'] = {
    init: function() {
        this.appendValueInput('VAR')
            .setCheck('Number')
            .appendField(Blockly.Msg["CONTROLS_FOR_COUNTER"]);

        this.appendValueInput('FROM')
            .setCheck('Number')
            .appendField(Blockly.Msg["CONTROLS_FOR_FROM"]);

        this.appendValueInput('TO')
            .setCheck('Number')
            .appendField(Blockly.Msg["CONTROLS_FOR_TO"]);
        
        this.appendDummyInput()
            .appendField(Blockly.Msg["CONTROLS_FOR_STEP"])
            .appendField(new Blockly.FieldDropdown([
                ["+", "+"],
                ["-", "-"]
            ]), "DIR");
            
        this.appendValueInput('BY')
            .setCheck('Number');

        this.appendStatementInput('DO')
            .appendField(Blockly.Msg["CONTROLS_FOR_DO"]);
        
        this.setInputsInline(true);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setStyle('loop_blocks');
        this.setTooltip(Blockly.Msg["CONTROLS_FOR_TOOLTIP"]);
    }
};