/**
 * @license
 * Copyright 2025 Elron
 * SPDX-License-Identifier: GPL3
 */

/**
 * @fileoverview Actuators blocks for Blockly.
 * @author info@elron.tech
 */
 
'use strict';

goog.provide('Blockly.Constants.servo');

goog.require('Blockly.Blocks');
goog.require('Blockly');

// ================================= Servo ================================= //
Blockly.Blocks['servo_move'] = {
    init: function () {
        // исключить выводы светодиода и кнопки
        const filteredDropdown = profile.default.dropdownDigital.filter(item =>
            item[1] !== 'LED_BUILTIN' && item[1] !== 'BTN_BUILTIN'
        );

        this.appendDummyInput()
            .appendField(Blockly.Msg.SERVO_MOVE_INPUT)
            .appendField(new Blockly.FieldDropdown(filteredDropdown), "PIN");
        this.appendValueInput("ANGLE")
            .appendField(Blockly.Msg.SERVO_MOVE_DEGREE)
            .setCheck('Number');
        this.appendDummyInput()
            .appendField(Blockly.Msg.SERVO_MOVE_DEGREE_1)
                
        this.setInputsInline(true);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setTooltip(Blockly.Msg.SERVO_MOVE_TOOLTIP);
        this.setHelpUrl(Blockly.Msg.SERVO_MOVE_HELPURL);
        this.setStyle('actuators_blocks');
    }
};

// ================================= Stepper ================================= //
Blockly.Blocks['stepper_init'] = {
    init: function () {
        const filteredDropdown = profile.default.dropdownDigital.filter(item =>
            item[1] !== 'LED_BUILTIN' && item[1] !== 'BTN_BUILTIN'
        );

        this.appendDummyInput()
            .appendField(Blockly.Msg.STEPPER_INIT_INPUT_1)
            .appendField(new Blockly.FieldDropdown([
                ["1", "1"], 
                ["2", "2"], 
                ["3", "3"], 
                ["4", "4"]
            ]), "NUM");

        this.appendDummyInput()
            .appendField(Blockly.Msg.STEPPER_INIT_INPUT_2)
            .appendField("IN1")
            .appendField(new Blockly.FieldDropdown(() => {
                const used = [
                    this.getFieldValue("IN2"),
                    this.getFieldValue("IN3"),
                    this.getFieldValue("IN4")
                ];
                return filteredDropdown.filter(item => !used.includes(item[1]));
            }), "IN1");

        this.appendDummyInput()
            .appendField("IN2")
            .appendField(new Blockly.FieldDropdown(() => {
                const used = [
                    this.getFieldValue("IN1"),
                    this.getFieldValue("IN3"),
                    this.getFieldValue("IN4")
                ];
                return filteredDropdown.filter(item => !used.includes(item[1]));
            }), "IN2");

        this.appendDummyInput()
            .appendField("IN3")
            .appendField(new Blockly.FieldDropdown(() => {
                const used = [
                    this.getFieldValue("IN1"),
                    this.getFieldValue("IN2"),
                    this.getFieldValue("IN4")
                ];
                return filteredDropdown.filter(item => !used.includes(item[1]));
            }), "IN3");

        this.appendDummyInput()
            .appendField("IN4")
            .appendField(new Blockly.FieldDropdown(() => {
                const used = [
                    this.getFieldValue("IN1"),
                    this.getFieldValue("IN2"),
                    this.getFieldValue("IN3")
                ];
                return filteredDropdown.filter(item => !used.includes(item[1]));
            }), "IN4");

        this.appendValueInput("SPEED")
            .appendField(Blockly.Msg.STEPPER_INIT_INPUT_3)
            .setCheck("Number");

        this.appendDummyInput()
            .appendField(Blockly.Msg.STEPPER_INIT_INPUT_4);
        
        this.setInputsInline(true);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setStyle('actuators_blocks');
        this.setTooltip(Blockly.Msg.STEPPER_INIT_TOOLTIP);
        this.setHelpUrl(Blockly.Msg.STEPPER_HELPURL);
    }
};

Blockly.Blocks['stepper_move'] = {
    init: function () {
        this.appendDummyInput()
            .appendField(Blockly.Msg.STEPPER_MOVE_INPUT_1)
            .appendField(new Blockly.FieldDropdown([
                ["1", "1"], 
                ["2", "2"], 
                ["3", "3"], 
                ["4", "4"]
            ]), "NUM")
            .appendField(Blockly.Msg.STEPPER_MOVE_INPUT_2)
            .appendField(new Blockly.FieldDropdown([
                [Blockly.Msg.STEPPER_MOVE_FORWORD, "forw"],
                [Blockly.Msg.STEPPER_MOVE_REVERSE, "backw"]
            ]), "DIR");

        this.appendDummyInput()
            .appendField(Blockly.Msg.STEPPER_MOVE_INPUT_3)
            .appendField(new Blockly.FieldDropdown([
                [Blockly.Msg.STEPPER_MOVE_STEPS, "steps"],
                [Blockly.Msg.STEPPER_MOVE_ANGLE, "angle"]
            ]), "MODE");

        this.appendValueInput("VALUE")
            .setCheck("Number")
            .appendField(Blockly.Msg.STEPPER_MOVE_INPUT_4);

        this.setInputsInline(true);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setStyle('actuators_blocks');
        this.setTooltip(Blockly.Msg.STEPPER_MOVE_TOOLTIP);
        this.setHelpUrl(Blockly.Msg.STEPPER_HELPURL);
    }
};