/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @fileoverview Generating Arduino code for typed variable.
 * @author scanet@libreduc.cc (Sébastien CANET)
 */

'use strict';

goog.provide('Blockly.Arduino.VariablesTyped');

goog.require('Blockly.Arduino');

Blockly.Arduino['vars_set_number_init'] = function (block) {
    var argument0 = Blockly.Arduino.valueToCode(block, 'VALUE', Blockly.Arduino.ORDER_ASSIGNMENT) || '0';
    var varName = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_SET_NUMBER'), Blockly.Variables.NAME_TYPE);
    // добавляем присваивание в setup() и в loop ничего не возвращаем
    Blockly.Arduino.setups_['init_' + varName] = varName + ' = ' + argument0 + ';';
    return '';
};
Blockly.Arduino['vars_set_number'] = function (block) {
    var argument0 = Blockly.Arduino.valueToCode(block, 'VALUE', Blockly.Arduino.ORDER_ASSIGNMENT) || '0';
    var varName = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_SET_NUMBER'), Blockly.Variables.NAME_TYPE);
    return varName + ' = ' + argument0 + ';\n';
};
Blockly.Arduino['vars_get_number'] = function (block) {
    var code = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_GET_NUMBER'), Blockly.Variables.NAME_TYPE);
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['vars_set_string_init'] = function (block) {
    var argument0 = Blockly.Arduino.valueToCode(block, 'VALUE', Blockly.Arduino.ORDER_ASSIGNMENT) || '0';
    var varName = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_SET_STRING'), Blockly.Variables.NAME_TYPE);
    Blockly.Arduino.setups_['init_' + varName] = varName + ' = ' + argument0 + ';';
    return '';
};
Blockly.Arduino['vars_set_string'] = function (block) {
    var argument0 = Blockly.Arduino.valueToCode(block, 'VALUE', Blockly.Arduino.ORDER_ASSIGNMENT) || '0';
    var varName = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_SET_STRING'), Blockly.Variables.NAME_TYPE);
    return varName + ' = ' + argument0 + ';\n';
};
Blockly.Arduino['vars_get_string'] = function (block) {
    var code = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_GET_STRING'), Blockly.Variables.NAME_TYPE);
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['vars_set_boolean_init'] = function (block) {
    var argument0 = Blockly.Arduino.valueToCode(block, 'VALUE', Blockly.Arduino.ORDER_ASSIGNMENT) || '0';
    var varName = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_SET_BOOLEAN'), Blockly.Variables.NAME_TYPE);
    Blockly.Arduino.setups_['init_' + varName] = varName + ' = ' + argument0 + ';';
    return '';
};
Blockly.Arduino['vars_set_boolean'] = function (block) {
    var argument0 = Blockly.Arduino.valueToCode(block, 'VALUE', Blockly.Arduino.ORDER_ASSIGNMENT) || '0';
    var varName = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_SET_BOOLEAN'), Blockly.Variables.NAME_TYPE);
    return varName + ' = ' + argument0 + ';\n';
};
Blockly.Arduino['vars_get_boolean'] = function (block) {
    var code = Blockly.Arduino.variableDB_.getName(block.getFieldValue('VAR_GET_BOOLEAN'), Blockly.Variables.NAME_TYPE);
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};