/**
 * @license
 * Copyright 2020 Sébastien CANET
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @fileoverview Generating Arduino code for basics board command blocks.
 * @author scanet@libreduc.cc (Sébastien CANET)
 */

'use strict';

goog.provide('Blockly.Arduino.board_serial');

goog.require('Blockly.Arduino');

Blockly.Arduino['board_serial_init'] = function () {
    var dropdown_speed = this.getFieldValue('SPEED');
    Blockly.Arduino.setups_['serial_begin'] = 'Serial.begin(' + dropdown_speed + ');';
    return "";
};

Blockly.Arduino['board_serial_printfor'] = function () {
    var content = Blockly.Arduino.valueToCode(this, 'CONTENT', Blockly.Arduino.ORDER_NONE);
    var type = this.getFieldValue('TYPE');
    var newline = this.getFieldValue('NEWLINE') === 'TRUE';
    var func = newline ? 'println' : 'print';
    var code = 'Serial.' + func + '(' + content + ', ' + type + ');\n';
    return code;
};

Blockly.Arduino['board_serial_print'] = function (block) {
    var content = Blockly.Arduino.valueToCode(this, 'CONTENT', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var newline = this.getFieldValue('NEWLINE') === 'TRUE';
    var func = newline ? 'println' : 'print';
    var code = 'Serial.' + func + '(' + content + ');\n';
    return code;
};

Blockly.Arduino['board_serial_available'] = function () {
    var code = 'Serial.available()';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['board_serial_read'] = function () {
    var code = 'Serial.read()';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['board_serial_readStringUntil'] = function () {
    var content = Blockly.Arduino.valueToCode(this, 'CONTENT', Blockly.Arduino.ORDER_NONE);
    content = content.replace('"', '\'');
    content = content.replace('"', '\'');
    var code = 'Serial.readStringUntil(' + content + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['board_serial_flush'] = function () {
    var code = 'Serial.flush();\n';
    return code;
};
