/**
 * @license
 * Copyright 2025 Elron
 * SPDX-License-Identifier: GPL3
 */

/**
 * @fileoverview different RTC mcu blocks for Blockly
 * @author info@elron.tech
 */
 
'use strict';

goog.require('Blockly.Arduino');

// ================================= DS1302 ================================= //
var ds1302_instance_name = 'ds1302_rtc';
var ds1302_datetime_name = 'ds1302_time';

Blockly.Arduino['ds1302_init'] = function() {
  var data_pin  = this.getFieldValue('DATA');
  var clk_pin   = this.getFieldValue('CLOCK');
  var rst_pin   = this.getFieldValue('RESET');

  Blockly.Arduino.includes_['ds1302_include'] = '#include <Ds1302.h>';
  Blockly.Arduino.definitions_['ds1302_def'] = 'Ds1302 ' + ds1302_instance_name + '(' + rst_pin +', ' + clk_pin + ', ' + data_pin + ');';
  Blockly.Arduino.definitions_['ds1302_datetime'] = 'Ds1302::DateTime ' + ds1302_datetime_name + ';';
  Blockly.Arduino.setups_['setup_ds1302_init'] = ds1302_instance_name + '.init();';

  return '';
};

Blockly.Arduino['ds1302_set_init_time'] = function(block) {
  var year   = Blockly.Arduino.valueToCode(block, 'YEAR', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var month  = Blockly.Arduino.valueToCode(block, 'MONTH', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var day    = Blockly.Arduino.valueToCode(block, 'DAY', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var hour   = Blockly.Arduino.valueToCode(block, 'HOUR', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var minute = Blockly.Arduino.valueToCode(block, 'MIN', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var second = Blockly.Arduino.valueToCode(block, 'SEC', Blockly.Arduino.ORDER_ATOMIC) || 0;

  // инициализация времени один раз в setup()
  Blockly.Arduino.setups_['setup_ds1302_set_init_time'] = ds1302_datetime_name + ' = {' + year + ', ' + month + ', ' + day + ', ' + hour + ', ' 
    + minute + ', ' + second + ', 1};\n  ' + ds1302_instance_name + '.setDateTime(&' + ds1302_datetime_name + ');\n';

  return '';
};

Blockly.Arduino['ds1302_set_time'] = function(block) {
  var year   = Blockly.Arduino.valueToCode(block, 'YEAR', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var month  = Blockly.Arduino.valueToCode(block, 'MONTH', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var day    = Blockly.Arduino.valueToCode(block, 'DAY', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var hour   = Blockly.Arduino.valueToCode(block, 'HOUR', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var minute = Blockly.Arduino.valueToCode(block, 'MIN', Blockly.Arduino.ORDER_ATOMIC) || 0;
  var second = Blockly.Arduino.valueToCode(block, 'SEC', Blockly.Arduino.ORDER_ATOMIC) || 0;

  // на дне недели заглушка
  var code = ds1302_datetime_name + ' = {' + year + ', ' + month + ', ' + day + ', ' + hour + ', ' + minute + ', ' + second + ', 1};\n';
  code += ds1302_instance_name + '.setDateTime(&' + ds1302_datetime_name + ');\n';

  return code;
};

Blockly.Arduino['ds1302_update_time'] = function(block) {
  var code = ds1302_instance_name + '.getDateTime(&' + ds1302_datetime_name + ');\n';
  return code;
};

Blockly.Arduino['ds1302_get_param'] = function(block) {
  var field = block.getFieldValue('FIELD');
  var code = [ds1302_datetime_name + '.' + field, Blockly.Arduino.ORDER_ATOMIC];
  return code; 
};