#!/usr/bin/env bash
set -euo pipefail

# пути до исходников
APP_NAME="BearLogica"
ICON_PNG="appIcon.png"                 # лежит рядом со скриптом
DESKTOP_IN="BearLogica.desktop.in"     # шаблон
DESKTOP_OUT="BearLogica.desktop"       # итоговый файл в проекте

ICON_NAME="bearlogica"                 
ICON_THEME_DIR="$HOME/.local/share/icons/hicolor/256x256/apps"
DESKTOP_TARGET_DIR="$HOME/.local/share/applications"

# проверить наличие исходников
DIR="$(cd "$(dirname "$0")" && pwd)"   # абсолютный путь к проекту

[[ -f "$DIR/$ICON_PNG"   ]] || { echo "$ICON_PNG does not found"; exit 1; }
[[ -f "$DIR/$DESKTOP_IN" ]] || { echo "$DESKTOP_IN does not found"; exit 1; }
[[ -x "$DIR/bearlogica"  ]] || { echo "bin file bearlogica does not found or it is not executable"; exit 1; }

echo "Installing $APP_NAME…"

# сгенерировать BearLogica.desktop в корне проекта и дать ему разрешение на исполнение
EXEC_PATH="$DIR/bearlogica"
PATH_DIR="$DIR"

sed \
  -e "s|__EXEC__|$EXEC_PATH|" \
  -e "s|__PATH__|$PATH_DIR|" \
  -e "s|__ICON__|$ICON_NAME|" \
  "$DIR/$DESKTOP_IN" > "$DIR/$DESKTOP_OUT"

chmod +x "$DIR/$DESKTOP_OUT"
echo "$DESKTOP_OUT created"

# скопировать иконку
mkdir -p "$ICON_THEME_DIR"
cp "$DIR/$ICON_PNG" "$ICON_THEME_DIR/${ICON_NAME}.png"

# создать index.theme, если темовая папка пуста
INDEX_FILE="$HOME/.local/share/icons/hicolor/index.theme"
if [[ ! -f "$INDEX_FILE" ]]; then
  cat > "$INDEX_FILE" <<EOF
[Icon Theme]
Name=Hicolor
Comment=Fallback icon theme
Directories=256x256/apps

[256x256/apps]
Size=256
Context=Applications
Type=Fixed
EOF
fi

# обновить кэш иконок
command -v gtk-update-icon-cache &>/dev/null && \
  gtk-update-icon-cache -f "$HOME/.local/share/icons/hicolor" || true

# скопировать .desktop в систему
mkdir -p "$DESKTOP_TARGET_DIR"
cp "$DIR/$DESKTOP_OUT" "$DESKTOP_TARGET_DIR/$DESKTOP_OUT"
chmod +x "$DESKTOP_TARGET_DIR/$DESKTOP_OUT"

# обновить базу .desktop-файлов
command -v update-desktop-database &>/dev/null && \
  update-desktop-database "$DESKTOP_TARGET_DIR" || true

echo "Icon installation done"