# Cборка исполняемых файлов BearLogica в ОС Linux
Для сборки исполняемых файлов в операционной системе Linux необходимо пройти следующие шаги:
1. Установить системные зависимости и инструменты, необходимые для сборки  
   ```
   sudo apt update && sudo apt upgrade -y
   sudo apt install -y build-essential curl git python3 python3-pip libusb-1.0-0-dev libudev-dev libx11-dev libxkbfile-dev
   ```
2. Установить Node.js v22 и проверить версии установленных пакетов
   ```
   curl -fsSL https://deb.nodesource.com/setup_22.x | sudo -E bash -
   sudo apt install -y nodejs
   node -v
   npm -v
   ```
3. Клонировать проект на свой ПК:
   ```
   git clone https://gitflic.ru/project/elron-tech/bearlogica.git
   cd bearlogica
   ```
4. Установить зависимости командами
   ```
   npm install --save-dev node-gyp
   npm install
   ```
5. Запустить веб-версию приложения для теста можно командой  
```npm start```
6. Сборка приложения в исполняемый файл осуществляется после запуска скрипта для сборки (расположен в корне проекта) в терминале  
```./build_script.sh```  
В результате сборки в корне проекта должна появиться папка dist, а внутри - готовый к распространению архив.  

Сборка проекта была успешно произведена на ОС Ubuntu 20.04 с инструментами следующих версий:
```
node v22.17.1
npm 10.9.2
node-gyp v11.2.0
Python 3.8.10
```
Более подробную информацию о необходимых пакетах и их версиях можно найти в файле `package.json` в разделах `devDependencies` и `dependencies`.