# Cборка исполняемых файлов BearLogica в ОС Windows
1. Для сборки исполняемых файлов в операционной системе Windows необходимо установить программный пакет Node.js в комплекте с необходимыми для сборки инструментами (Python, Visual Studio Build Tools). Сборка приложения была проверена на Node.js v22.17.0, скачать установочный файл можно на официальном сайте по ссылке https://nodejs.org/en/download.
Важно при установке пакета выбрать опцию `Automatically install the necessary tools...`, чтобы в комплекте установились необходимые инструменты.  
![installation](Nodejs_install.PNG)  
После установки Node.js откроется дополнительное окно терминала для установки инструментов.  
![build_tools_install_1](build_tools_install_1.PNG)  
Установка займет определенное время. В случае успешного завершения в окне установки будет перечислен список установленных пакетов и надпись `Type ENTER to exit:`.  
![build_tools_install_2](build_tools_install_2.PNG)  
2. Далее необходимо клонировать проект на свой ПК (или скачать и разархивировать архив) и перейти внутрь папки с проектом:
   ```
   git clone https://gitflic.ru/project/elron-tech/bearlogica.git
   cd bearlogica
   ```
3. Установить зависимости для приложения и еще один пакет, необходимый для сборки нативных модулей, командами
   ```
   npm install --save-dev node-gyp
   pip install setuptools
   ```
4. Запустить приложение в режиме разработчика можно командой `npm start`.  
Если сборка приложения производится на ПК с ОС Windows x64, может возникнуть проблема с пакетом `serialPort`. Он собирается отдельно под каждую версию ОС. Если собрать его под ПК с разрядностью 64 бита - возникнет ошибка при запуске собранного приложения, так как приложение собирается под Windows x32. Если собрать пакет под ПК с разрядностью 32 бита - есть проблемы при запуске приложения в режиме разработчика. Для упрощения работы в проект добавлены скрипты для запуска приложения в режиме разработчика (`debug_start_for_win64.bat`) и для сборки приложения (`build_for_win32.bat`). В них пакет `serialPort` пересобирается под нужную разрядность, после чего запускается или режим разработчика, или сборка приложения.
5. Сборка приложения в исполняемый файл осуществляется командой `npm run compile`, если пакет `serialPort` уже был собран для ОС х32, или запуском скрипта `build_for_win32.bat`. В результате сборки в корне проекта должна появиться папка dist, а внутри - готовый к распространению архив.  
  
Сборка проекта была успешно произведена с инструментами следующих версий:
```
node v22.17.1
npm 10.9.2
node-gyp v11.2.0
Python 3.13.5
Visual Studio Build Tools 2019
```
Более подробную информацию о необходимых пакетах и их версиях можно найти в файле `package.json` в разделах `devDependencies` и `dependencies`.