![logo](docs/logo_ELBEAR_.png)
# BearLogica
BearLogica - это среда визуального программирования для плат [ELBEAR](https://elron.tech/russian-arduino-compatible-board/) на базе MIK32 Амур от Микрон. 
Приложение позволяет собирать программу из графических блоков, преобразовывать её в код, совместимый с Arduino IDE, а также загружать полученный код на плату.  
  
## Подготовка к использованию на ОС Windows
1. Скачать zip-архив `BearLogica...-win.zip` из релизов и разархивировать его в папку на своем ПК.
2. Убедиться, что ПК имеет доступ в интернет.
3. В корне папки найти файл `install_board.bat` и запустить его двойным нажатием. Откроется окно установки пакета поддержки плат ELBEAR и необходимых библиотек. Необходимо дождаться, пока в окне не появится надпись `Для продолжения нажмите любую клавишу...`, на это потребуется некоторое время. В случае возникновения проблем с установкой необходимо обратиться к производителю.  
![board_installation.png](docs/_board_installation_.png)
4. Для запуска приложения необходимо найти файл BearLogica.exe в папке приложения и дважды на него нажать.  
При первом запуске файлов BearLogica.exe, install_board.bat и update_board.bat операционная система Windows может отобразить предупреждение SmartScreen, так как файлы загружены из интернета.
При появлении окна `Защита Windows SmartScreen` нажмите `Дополнительные сведения` и выберите `Запустить в любом случае`. После однократного подтверждения данное предупреждение больше не будет появляться, и вы сможете пользоваться программой в обычном режиме.
5. Для работы с платами ELBEAR по интерфейсу USB необходимо установить драйверы. Драйвер можно найти на официальном сайте - [драйвер для платы ELBEAR ACE-UNO](https://www.wch-ic.com/downloads/CH341SER_EXE.html), [драйвер для платы ELBEAR ACE-NANO](https://www.wch-ic.com/downloads/CH343SER_EXE.html).
  
## Подготовка к использованию на ОС Linux
1. Скачать zip-архив `BearLogica-...tar.gz` из релизов и разархивировать его в удобную папку на своем ПК.
2. Убедиться, что ПК имеет доступ в интернет.
3. В корне папки найти файл установки приложения и запустить его в терминале:  
```./install_app.sh```  
При этом иконка и ярлык приложения будут добавлены в системные папки, а также будет скачан и установлен пакет поддержки плат ELBEAR и необходимые для работы библиотеки. Необходимо дождаться, пока в терминале не появится надпись `Installation done... Done`, на это потребуется некоторое время. В случае возникновения проблем с установкой необходимо обратиться к производителю.  
![board_installation.png](docs/_board_installation_lin.png)
4. Далее необходимо добавить своего пользователя в некоторые группы, чтобы устройство корректно распознавалось системой и имело доступ к последовательному порту. Для этого в терминале выполните (потребуется ввод пароля от учетной записи):  
```sudo usermod -a -G dialout,plugdev $USER```  
Для того, чтобы изменения вступили в силу, необходимо перезагрузить ПК или выйти из системы и повторно войти в неё.
5. После перезапуска приложение станет доступно для запуска из меню приложений. Также возможно запустить приложение из папки приложения двойным нажатием на файл Bearlogica.desktop (или просто Bearlogica).  
  
В случае перемещения папки с приложением или после ее переименования необходимо снова запустить скрипт установки -  `./install_app.sh`, иначе приложение перестанет запускаться и из меню, и из папки.  

## Использование
1. Запустите приложение Bearlogica. Откроется окно рабочей области.  
![workspace.png](docs/_workspace.png)
2. В выпадающем меню (1) можно создать новый проект или загрузить уже созданный, сохранить текущий проект в файл, а так же сохранить текущий сгенерированный код в файл с расширением .ino, совместимый с ArduinoIDE.  
![popup_menu.png](docs/_popup_menu.png) 
3. По умолчанию для работы выбрана плата ELBEAR ACE-UNO 8Мб. Можно посмотреть краткое описание выбранной платы, нажав на кнопку "Список плат" (2) с изображением микросхемы.  
![board_details.png](docs/_board_details.png)
4. Для создания программы необходимо выбрать блок из нужной категории (8) и перетащить его в рабочую область (9). При этом в редакторе кода (10) появится код, соответствующий этому блоку. Используя блоки из разных категорий, можно сформировать нужную программу.
5. Когда программа готова, ее нужно проверить, нажав кнопку (3). При этом в окне состояния (11) появится информация о ходе проверки. После окончания проверки, если ошибок нет, появится надпись `Проверка: ОК`.
6. После проверки программы ее можно загружать на плату. Для этого нужно подключить плату к ПК, в приложении нажать кнопку "Список COM портов"(4), выбрать порт, к которому подключена плата, и сохранить выбор.  
![comPort_list.png](docs/_comPort_list.png)
7. После выбора порта нажать кнопку "Загрузить"(5) и подождать. Перед загрузкой программа еще раз проверяется на наличие ошибок и только после этого загружается на плату. В случае успешной загрузки в окне состояния (11) появится надпись `Загрузка: ОК`.
8. В приложении также доступен встроенный монитор порта, с помощью которого можно просматривать данные, поступающие от платы по последовательному порту, а также отправлять данные с компьютера на плату. Для работы с монитором необходимо нажать кнопку "Монитор порта" (6) – откроется новое окно. Для начала передачи данных в окне необходимо выбрать скорость передачи данных и нажать кнопку "Запустить".  
![serial_monitor.png](docs/_serial_monitor.png)
9. В настройках приложения (7) можно выбрать используемый язык, цветовую схему приложения, а так же отображаемые в рабочей области категории блоков.  
![setup.png](docs/_setup.png)

Для быстрого старта можно использовать [инструкцию](docs/Blink_example.md) по созданию примера моргания встроенного на плату светодиода или воспользоваться готовыми примерами из папки examples.

## Сборка исполняемых файлов BearLogica
Информация о сборке исполняемых файлов - для [ОС Windows](docs/Build.md) и [ОС Linux](docs/Build_linux.md).

## Используемые инструменты
- [Ace-Editor](https://ace.c9.io/)  
- [Arduino-CLI](https://github.com/arduino/arduino-cli)  
- [Electron](https://www.electronjs.org/)  
- [Node SerialPort](https://serialport.io/)  

## Лицензия
Разработка проекта ведётся на основе объединения двух репозиториев:
- [BlocklyDuino-v2](https://github.com/BlocklyDuino/BlocklyDuino-v2), авторы Sébastien Canet и Fred Lin
- [BlocklyDuino2Electron](https://github.com/BlocklyDuino/BlocklyDuino2Electron), автор Sébastien Canet  
  
Оба проекта распространяются на условиях лицензии GNU General Public License v3.0.  
В соответствии с условиями указанной лицензии, данный проект также распространяется под лицензией GPLv3.
Вы можете свободно использовать, изменять и распространять данный проект при соблюдении условий лицензии GNU GPLv3.
Полный текст лицензии доступен в файле LICENSE и на официальном сайте: https://www.gnu.org/licenses/gpl-3.0.html
  
В проекте используется следующий сторонний код:
- Blockly. Лицензия Apache License 2.0, репозиторий проекта - https://github.com/google/blockly
- STudio4Education. Лицензия BSD 3-Clause, репозиторий проекта - https://github.com/A-S-T-U-C-E/STudio4Education
- Arduino CLI — используется как бинарный инструмент. Лицензия GNU GPLv3,репозиторий проекта - https://github.com/arduino/arduino-cli  
  
При распространении проекта необходимо сохранять уведомления о лицензиях и авторстве, относящиеся к используемому стороннему коду.

## Полезные ссылки 
*  [Материалы по платам ELBEAR](https://elron.tech/support/#elbear)
*  [Телеграмм-канал проекта](https://t.me/bearlogica)
*  [Телеграмм-канал компании](https://t.me/elrontech)