
// Определение номеров выводов Elbear Ace-Uno, подключенных к 74HC595
int latchPin = 8; // Вывод, подключенный к ST_CP (RCLK) регистра сдвига
int clockPin = 12; // Вывод, подключенный к SH_CP (SRCLK) регистра сдвига
int dataPin = 11; // Вывод, подключенный к DS (DATA) регистра сдвига

byte number = 1;

void setup() {
  // Настраиваем выводы микроконтроллера как выходы
  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);
}

void loop() {  
  // Устанавливаем низкий уровень вывода latchPin перед началом передачи данных
  digitalWrite(latchPin, LOW);
  // Отправляем биты в регистр сдвига
  shiftOut(dataPin, clockPin, LSBFIRST, number);
  // Увеличиваем значение сдвигом влево (было 0b00000001, станет 0b00000010, на следующем шаге станет 0b00000100)
  number = (number << 1);
  // Когда единица выйдет за пределы байта, присвоим number снова единицу (при 0b10000000 << 1, значение станет равным 0b00000000)
  if ( ! number ) number = 1;
  // Устанавливаем высокий уровень вывода latchPin после передачи данных
  digitalWrite(latchPin, HIGH);
  // Задержка между обновлениями светодиодов
  delay(100); // 0,1 секунды
}
