/*
 * Данная программа управляет семисегментным индикатором, подключенным к плате Elbear Ace-Uno, для 
 * отображения цифр от 0 до 9.
 * Вот что происходит в программе:
 *  1. Определены константы для каждого сегмента индикатора (A-G), соответствующие цифровым выводам Elbear (2-8).
 *  2. Определена константа pause с временем задержки в 500 миллисекунд, которая используется для паузы между 
 *  отображением каждой цифры.
 *  3. Создан двумерный массив numer, который содержит информацию о состоянии каждого сегмента для отображения 
 *  цифр от 0 до 9. Значение 1 означает, что сегмент должен быть включен, а 0 - выключен.
 *  4. В функции setup() настраиваются все выводы, к которым подключены сегменты индикатора, как выходы.
 *  5. В функции loop() происходит следующее:
 *    - Проверяется, не достиг ли счетчик i значения 10, и если достиг, счетчик сбрасывается в 0, чтобы начать 
 *    цикл отображения цифр сначала.
 *    - С помощью функции digitalWrite() на каждый сегмент индикатора подается сигнал в соответствии с данными 
 *    из массива numer для текущей цифры i.
 *    - Счетчик i увеличивается на единицу, чтобы перейти к следующей цифре.
 *    - Программа ожидает время, заданное в переменной pause (500 мс), перед тем как отобразить следующую цифру.
 * Таким образом, программа последовательно отображает цифры от 0 до 9 на семисегментном индикаторе 500мс,  
 * и затем повторяет процесс
*/
const int led2 =  2; // A
const int led3 =  3; // B
const int led4 =  4; // C
const int led5 =  5; // D
const int led6 =  6; // E
const int led7 =  7; // F
const int led8 =  8; // G
const int pause = 500; // пауза между сменой цифр

// Для уменьшение кода опишем в виде масива каждую цифру
int numer[10][7] = {
// A,B,C,D,E,F,G  
  {1,1,1,1,1,1,0}, // 0
  {0,1,1,0,0,0,0}, // 1
  {1,1,0,1,1,0,1}, // 2
  {1,1,1,1,0,0,1}, // 3
  {0,1,1,0,0,1,1}, // 4
  {1,0,1,1,0,1,1}, // 5
  {1,0,1,1,1,1,1}, // 6
  {1,1,1,0,0,0,0}, // 7
  {1,1,1,1,1,1,1}, // 8
  {1,1,1,1,0,1,1}  // 9
};
// Номер цифры 
int i = 0;

// Настраиваем выводы на выход
void setup() {
  pinMode(led2, OUTPUT);
  pinMode(led3, OUTPUT);
  pinMode(led4, OUTPUT);
  pinMode(led5, OUTPUT);
  pinMode(led6, OUTPUT);
  pinMode(led7, OUTPUT);
  pinMode(led8, OUTPUT);
}

void loop() {
  // Проверяем, если номер цивры равен или больше 10, возращаем цифру 0 
  if (i >= 10) {
    i = 0;
  }
  // Отображаем цифру
  digitalWrite(led2, numer[i][0]);
  digitalWrite(led3, numer[i][1]);
  digitalWrite(led4, numer[i][2]);
  digitalWrite(led5, numer[i][3]);
  digitalWrite(led6, numer[i][4]);
  digitalWrite(led7, numer[i][5]);
  digitalWrite(led8, numer[i][6]);
  // Увеличиваем счетчик на едицицу
  i++;
  // Ждем немного 
  delay(pause);
}
