#include <Wire.h>
#include <DHT.h>
#include <LiquidCrystal_I2C.h>
#include <Ds1302.h>

// Инициализация DHT11 
#define DHTPIN 2 // Вывод, к которому подключен DHT11 
#define DHTTYPE DHT11 
DHT dht(DHTPIN, DHTTYPE); 

// Выводы для RTC DS1302 
#define RTC_RST 10 // Вывод RST для DS1302 
#define RTC_DAT 11 // Вывод DAT для DS1302 
#define RTC_CLK 13 // Вывод CLK для DS1302 

// Инициализация RTC DS1302
Ds1302::DateTime t; 
Ds1302 rtc(RTC_RST, RTC_CLK, RTC_DAT); 
// Инициализация ЖК-дисплея 
LiquidCrystal_I2C lcd(0x27, 16, 2); // Адрес I2C и размерность дисплея 

void setup() { 
  // Инициализация интерфейсов 
  Wire.begin(); 
  dht.begin(); 
  rtc.init(); 
  lcd.init(); // Инициализация дисплея 
  lcd.backlight(); // Включение подсветки
  if (rtc.isHalted()) { 
    // Задаем определенные дату и время для RTC  
    Ds1302::DateTime dt = { 
      .year = 24, // Год (00-99) 
      .month = Ds1302::MONTH_JUN, // Месяц в виде перечисления 
      .day = 25, // День месяца (1-31)
      .hour = 11, // Час дня (0-23) 
      .minute = 00, // Минута (0-59) 
      .second = 0, // Секунда (0-59) 
      .dow = Ds1302::DOW_TUE // День недели в виде перечисления 
    }; 
    // Записываем дату и время в RTC  
    rtc.setDateTime(&dt); 
  } 
}

void loop() { 
  // Получение текущего времени и даты 
  rtc.getDateTime(&t); 
  float temp = dht.readTemperature(); // Чтение значения температуры 
  float humidity = dht.readHumidity(); // Чтение уровня влажности 

  // Формирование строки с датой и временем 
  char dateTimeStr[17]; 
  sprintf(dateTimeStr, "%02d-%02d-%04d %02d:%02d", t.day, t.month, t.year + 2000, t.hour, t.minute); 

  // Формирование строки с днем недели, температурой и влажностью 
  char statusStr[17] = {0}; // Инициализация строки нулями

  // Копирование дня недели в начало строки 
  const char* dow = dayOfWeek(t.dow); sprintf(statusStr, "%s", dow); 
  // Форматирование строки со значением температуры и влажности 
  //и добавление в конец строки 
  char tempHumStr[10]; 
  sprintf(tempHumStr, "%02dC %02d%%", (int)temp, (int)humidity); 
  // Выравнивание строки по правому краю 
  int spaceCount = 16 - strlen(statusStr) - strlen(tempHumStr); 
  // Количество пробелов для заполнения 
  for (int i = 0; i < spaceCount; i++) { 
      strcat(statusStr, " "); // Добавление пробелов для выравнивания 
  } 
  strcat(statusStr, tempHumStr); // Добавление температуры и влажности в конец строки 
  // Отображение информации на ЖК-дисплее 
  lcd.setCursor(0, 0); 
  lcd.print(dateTimeStr); 
  lcd.setCursor(0, 1); 
  lcd.print(statusStr); 
  delay(1000); // Обновление информации раз в секунду 
}

// Функция для получения строки с днем недели 
const char* dayOfWeek(int dayIndex) { 
  const char* daysOfWeek[] = { 
    "Mon", // "Понедельник" 
    "Tue", // "Вторник"
    "Wed", // "Среда" 
    "Thu", // "Четверг" 
    "Fri", // "Пятница" 
    "Sat", // "Суббота" 
    "Sun" // "Воскресенье" 
  }; 
  return daysOfWeek[dayIndex - 1]; // Индексация дней недели начинается с 1 
} 
