
#include <Ds1302.h>

// Экземпляр DS1302 RTC
// Инициализация DS1302 RTC со следующими подключениями:
// Elbear D10 к RTC RST (Сброс)
// Elbear D13 к RTC CLK (Часы)
// Elbear D11 к RTC DAT (Данные)
Ds1302 rtc(10, 13, 11);

// Массив строк, представляющих дни недели
const static char* WeekDays[] =
{
  "Понедельник",
  "Вторник",
  "Среда",
  "Четверг",
  "Пятница",
  "Суббота",
  "Воскресенье"
};

// Функция setup запускается один раз при нажатии кнопки сброса или подаче питания на плату
void setup()
{
  // Инициализируем последовательную передачу данных     
  // со скоростью 9600 бит в секунду 
  Serial.begin(9600);
  // Инициализируем RTC
  rtc.init();
  // Проверяем, остановлен ли RTC, и если да, то устанавливаем время
  if (rtc.isHalted())
  {
    Serial.println("RTC остановлен. Установка времени...");
    // Задаем определенные дату и время для RTC 
    Ds1302::DateTime dt = {
      .year = 24, // Год (00-99)
      .month = Ds1302::MONTH_JUN, // Месяц в виде перечисления
      .day = 25, // День месяца (1-31)
      .hour = 11, // Час дня (0-23)
      .minute = 00, // Минута (0-59)
      .second = 0, // Секунда (0-59)
      .dow = Ds1302::DOW_TUE // День недели в виде перечисления
    };
    // Записываем дату и время в RTC 
    rtc.setDateTime(&dt);
  }
}
// Функция loop выполняется снова и снова бесконечно
void loop()
{
  // Получить текущее время от RTC
  Ds1302::DateTime now;
  rtc.getDateTime(&now);
  // Отслеживем последнюю обработанную секунду
  static uint8_t last_second = 0;
  if (last_second != now.second)
  {
    last_second = now.second;
    // Выводим текущую дату и время
    Serial.print("20"); // Префикс для года, чтобы сделать его четырехзначным
    Serial.print(now.year); // Выводим год (00-99)
    Serial.print('-');
    if (now.month < 10) Serial.print('0'); // Выводим ведущий ноль для месяца
    Serial.print(now.month); // Выводим месяц (01-12)
    Serial.print('-');
    if (now.day < 10) Serial.print('0'); // Выводим ведущий ноль для дня
    Serial.print(now.day); // Выводим день (01-31)
    Serial.print(' ');
    Serial.print(WeekDays[now.dow - 1]); // Выводим день недели (1-7)
    Serial.print(' ');
    if (now.hour < 10) Serial.print('0'); // Выводим ведущий ноль для часа
    Serial.print(now.hour); // Выводим час (00-23)
    Serial.print(':');
    if (now.minute < 10) Serial.print('0'); // Выводим ведущий ноль для минуты
    Serial.print(now.minute); // Выводим минуту (00-59)
    Serial.print(':');
    if (now.second < 10) Serial.print('0'); // Выводим ведущий ноль для секунды
    Serial.print(now.second); // Выводим секунду (00-59)
    Serial.println(); // Заканчиваем вывод строки 
  }
  // Задержка полсекунды
  delay(500);
}
