#include <SPI.h>
#include <MFRC522.h>

#define RELAY_PIN 6 // Вывод для управления реле 
#define RELAY_ON 0 // Уровень для включения реле 
#define RELAY_OFF 1 // Уровень для выключения реле 
#define RST_PIN 7 // Вывод RST для RFID-модуля 
#define SS_PIN 10 // Вывод SS для RFID-модуля 

MFRC522 mfrc522(SS_PIN, RST_PIN); // Создание экземпляра MFRC522 

void setup() { 
  Serial.begin(9600); // Инициализация последовательного порта 
  SPI.begin(); // Инициализация SPI 
  mfrc522.PCD_Init(); // Инициализация MFRC522 
  pinMode(RELAY_PIN, OUTPUT); // Настройка вывода реле на выход 
  digitalWrite(RELAY_PIN, RELAY_OFF); // Выключение реле 
} 

void loop() { 
  // Проверка наличия новой RFID-карты 
  if (mfrc522.PICC_IsNewCardPresent() && mfrc522.PICC_ReadCardSerial()) { 
    // Сравнение UID карты с разрешенными значениями 
    if (compare_uid(mfrc522.uid.uidByte, mfrc522.uid.size)) {       
      Serial.println("Включение реле");
      digitalWrite(RELAY_PIN, RELAY_ON); // Включение реле
      delay(3000); // Время активации реле 
      digitalWrite(RELAY_PIN, RELAY_OFF); // Выключение реле        
      Serial.println("Выключение реле");
    } 
  } 
} 

// Функция сравнения UID 
boolean compare_uid(byte *buffer, byte bufferSize) { 
  // Здесь должна быть проверка есть ли  
  // UID считанной метки в списке разрешенных 

  return true; // по умолчанию все UID разрешены
} 
