
const int columnPins[] = {9, 2, 3, 12, A1, 11, 7, 6}; // анод (vcc)
const int rowPins[] = {13, 8, A3, 10, 5, A2, 4, A0}; // катод (ground)
int pixel = 0; //порядковый номер светодиода в матрице от 0 до 63
int columnLevel = 0; //значения пикселей преобразовываются в номер столбца матрицы
int rowLevel = 0; // значения пикселей преобразовываются в номер строки матрицы

void setup() {
  for (int i = 0; i < 8; i++) {
    pinMode(columnPins[i], OUTPUT);    
  }  
}

void loop() {
  pixel = pixel + 1;
  if (pixel > 63) pixel = 0;
  columnLevel = pixel / 8; //преобразовываем в номер столбца
  rowLevel = pixel % 8; // преобразовываем в номер строки
  for (int column = 0; column < 8; column++) {
    digitalWrite(columnPins[column], HIGH);
    for (int row = 0; row < 8; row++) {
      if(columnLevel > column){
        pinMode(rowPins[row], OUTPUT);
      }
      if(columnLevel == column && rowLevel >= row) {
        pinMode(rowPins[row], OUTPUT);
      }else {
        digitalWrite(columnPins[column], HIGH);
      }
      delayMicroseconds(150);
      pinMode(rowPins[row], INPUT);
    }
    digitalWrite(columnPins[column], LOW);
  }
}
