
const int digital = 2; // Цифровой вход вывода 2
const int analog = A0; // Аналоговый вход вывода A0 
uint8_t digital_data; // Цифровой сигнал с датчика
uint16_t analog_data; // Аналоговый сигнал с датчика

void setup()
{
  // вывод светодиода на плате Elbear конфигурируем на выход
  pinMode(LED_BUILTIN, OUTPUT);
  // цифровой вывод датчика настраиваем на вход с подтяжкой к питанию
  pinMode(digital, INPUT_PULLUP);
  Serial.begin(9600);
}
 
void loop()
{
  digital_data = digitalRead(digital);
  analog_data = analogRead(analog);
  // Если уровень цифрового сигнала с датчика высокий
  // или уровень аналогового сигнала менее 500, то
  if (digital_data || analog_data < 500){  
    // выводим данные в монитор последовательного порта
    Serial.print("Digital: ");
    Serial.print(digital_data);
    Serial.print(", Analog: ");
    Serial.println(analog_data);
    // переключаем светодиод (меняем состояние)
    digitalToggle(LED_BUILTIN);
  }
  // минимальная задержка
  delay(5);
}
