
#include <DHT.h> // DHT-sensor-library от adafruit

// Инициализация DHT11
#define DHTPIN 2 // Вывод, к которому подключен датчик DHT11
#define DHTTYPE DHT11 // Используемый тип датчика DHT11

DHT dht(DHTPIN, DHTTYPE);

void setup() {
  Serial.begin(9600); // Инициализация последовательного порта
  dht.begin(); // Запуск датчика DHT11
}
void loop() {
  // Чтение уровней влажности и температуры
  float humidity = dht.readHumidity();
  float temperature = dht.readTemperature();
  // Проверка считанных данных 
  if (isnan(humidity) || isnan(temperature)) {
    Serial.println("Не удалось считать данные с датчика DHT11");
    return;
  }
  // Вывод уровней влажности и температуры в последовательный порт
  Serial.print("Влажность: ");
  Serial.print(humidity);
  Serial.print("%\t");
  Serial.print("Температура: ");
  Serial.print(temperature);
  Serial.println("°C");
  // Задержка перед следующим измерением
  delay(2000);
}
