
// Подключаем библиотеку для управления шаговым двигателем через драйвер ULN2003 
#include "Bonezegei_ULN2003_Stepper.h" 
// Определяем количество шагов, которое должен сделать двигатель за один цикл 
#define STEPS 200 
// Создаем объект Stepper для управления шаговым двигателем 
// Выводы 8, 9, 10, 11 Elbear Ace-Uno подключены к входам In1, In2, In3, In4 драйвера ULN2003A 
Bonezegei_ULN2003_Stepper Stepper(8, 9, 10, 11); 
// Определяем константы для направления вращения двигателя 
#define FORWARD 1 // Вперед 
#define REVERSE 0 // Назад 
// Создаем массив с номерами выводов, к которым подключены кнопки 
int pinButtons1[] = {6, 7};
 
void setup() { 
  // Инициализируем драйвер двигателя 
  Stepper.begin(); 
  // Настраиваем выводы кнопок на вход
  pinMode(pinButtons1[0], INPUT); 
  pinMode(pinButtons1[1], INPUT); 
}

void loop() { 
  // Проверяем состояние первой кнопки 
  if (digitalRead(pinButtons1[0]) == HIGH) { 
      // Если кнопка нажата, вращаем двигатель вперед 
      Stepper.step(FORWARD, STEPS); 
  } 
  // Проверяем состояние второй кнопки 
  if (digitalRead(pinButtons1[1]) == HIGH) { 
      // Если кнопка нажата, вращаем двигатель назад
      Stepper.step(REVERSE, STEPS);
  } 
}
