// Определение номеров выводов для зуммера и фоторезистора
#define buzzerPin 5   // Номер вывода зуммера
#define photoPin A3   // Вывод подключения фоторезистора

// Переменные для хранения значений
int aVal;                      // Показания фоторезистора
int sMax=1023;                 // Максимальное показание фоторезистора
int buzzerFreq;                // Частота звука
const long BUZZ_FREQ_MAX = 2500;  // Задаем максимальную частоту излучения

void setup() {
  pinMode(buzzerPin, OUTPUT);  // Настройка вывода зуммера на выход
  Serial.begin(9600);          // Инициализация последовательного порта для отладки
}

void loop() {
  aVal = analogRead(photoPin);  // Считываем аналоговое значение с фоторезистора
  Serial.print("aVal: ");
  Serial.println(aVal);         // Выводим значение в монитор последовательного порта
  buzzerFreq = (aVal * BUZZ_FREQ_MAX) / sMax;  // Рассчитываем частоту для зуммера
  buzz(buzzerPin, buzzerFreq, 50);  // Генерация звука на зуммере
}

// Функция для генерации звука заданной частоты и продолжительности
void buzz(int targetPin, long frequency, long length) {
  long delayValue = 1000000 / frequency / 2;  // Расчет времени задержки для полуволны
  long numCycles = frequency * length / 1000; // Расчет количества циклов звука

  // Генерация звукового сигнала
  for (long i = 0; i < numCycles; i++) {
    digitalWrite(targetPin, HIGH);  // Установка высокого уровня сигнала
    delayMicroseconds(delayValue);  // Задержка для создания полуволны
    digitalWrite(targetPin, LOW);   // Установка низкого уровня  сигнала
    delayMicroseconds(delayValue);  // Задержка для создания полуволны
  }
}
