
// Массив выводов подключения светодиодов
const int leds[] = {3, 4, 5, 6, 7, 8, 9, 10};
const int LIGHT = A0; // Контакт A0 для входа фоторезистора
const int MIN_LIGHT = 200; // Нижний порог освещенности
const int MAX_LIGHT = 900; // Верхний порог освещенности
// Переменная для хранения данных фоторезистора
int val = 0;

void setup() {
  // Конфигурирование выводов светодиодов на выход
  for (int i = 0; i < 8; i++) 
    pinMode(leds[i], OUTPUT);
}

void loop() {
  val = analogRead(LIGHT); // Считываем показания фоторезистора
  // Применение функции map()
  val = map(val, MIN_LIGHT, MAX_LIGHT, 8, 0);
  // Ограничиваем значение val диапазоном от 0 до 8
  val = constrain(val, 0, 8);
  // Зажечь количество светодиодов, пропорциональное освещенности,
  // остальные погасить
  for (int i = 1; i < 9; i++) {
    if (i >= val) // Зажечь светодиоды
      digitalWrite(leds[i - 1], HIGH);
    else // Погасить светодиоды
      digitalWrite(leds[i - 1], LOW);
  }
  delay(100); // Пауза перед следующим измерением
}
