
#define BUZZER_PIN   12  // вывод, к которому подключен пьезоизлучатель
#define PLAYER_COUNT 2   // количество игроков

// вместо перечисления всех выводов по одному создаются массивы:
// один с номерами выводов с кнопками, другой - со светодиодами
int buttonPins[PLAYER_COUNT] = {3, 13};
int ledPins[PLAYER_COUNT] = {9, 11};
 
void setup()
{
  pinMode(BUZZER_PIN, OUTPUT);
  for (int player = 0; player < PLAYER_COUNT; ++player) {
    // при помощи квадратных скобок получают значение элемента 
    // массива ledPins и buttonPins с индексом player. 
    // Нумерация начинается с нуля
    pinMode(ledPins[player], OUTPUT);
    pinMode(buttonPins[player], INPUT_PULLUP);
  }
}
 
void loop()
{
  // после паузы от 2 до 7 сек подается сигнал начала дуэли 
  delay(random(2000, 7000));
  tone(BUZZER_PIN, 3000, 250); // 3 килогерца, 250 миллисекунд
 
  for (int player = 0; ; player = (player+1) % PLAYER_COUNT) {
    // если игрок номер «player» нажал кнопку...
    if (!digitalRead(buttonPins[player])) {
      // ...включаем его светодиод и сигнал победы на 1 сек
      digitalWrite(ledPins[player], HIGH);
      tone(BUZZER_PIN, 4000, 1000);
      delay(1000);
      digitalWrite(ledPins[player], LOW);
      break; // Есть победитель! Выход из цикла
    }
  }
}
