
// пьезоизлучатель родключен к D11
int buzzer = 11; // Вывод 11 подключен к пьезоизлучателю

#include "pitches.h"

// ноты в мелодии: 
int melody[] = {NOTE_C4, NOTE_G3, NOTE_G3, NOTE_A3, NOTE_G3, 0, NOTE_B3, NOTE_C4 };

// длительность нот: 4 = четвертная нота, 8 = восьмая нота и т.д.: 
int noteDurations[] = {4, 8, 8, 4, 4, 4, 4, 4 };

void setup() {
  pinMode(buzzer, OUTPUT); // Инициализация цифрового вывода как выход
}
void loop() {
  // итерация по нотам мелодии
  for (int thisNote = 0; thisNote < 8; thisNote++) {    
    // для расчета длительности ноты возьмите одну секунду, деленную на тип ноты
    // например, четвертная нота = 1000 / 4, восьмая нота = 1000/8 и т.д.
    int noteDuration = 1000 / noteDurations[thisNote];
    // при 0 подождать и пропустить итерацию
    if ( ! melody[thisNote] ) {
      delay(noteDuration * 1.30);
      continue;
    }
    // воспроизведение
    tone(11, melody[thisNote], noteDuration);
    // для различия нот установите минимальное время между ними
    // длительность ноты + 30%
    delay(noteDuration * 1.30);
    // остановить воспроизведение тона
    noTone(11);
  } 
  // задержка перед повтором мелодии
  delay(2000);
}
